/*
 * Decompiled with CFR 0.152.
 */
package SPITClientGUI;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import MIDIPackage.MidiDeviceWrapper;
import MIDIPackage.SPITType_MidiObject;
import StartPackage.MidiClient_StartFrame;
import SwingModelPackage.TableAndListModel;
import SwingToolTipPackage.PopUpToolTip;
import ToolsPackage.EventQueueHandler;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;

public class SPITType_MidiDevices_TableModel
extends TableAndListModel<MidiDeviceWrapper>
implements PropertyChangeListener {
    public static final int COLUMNCOUNT = 3;
    public static final int COLUMNINDEX_OPENED = 0;
    public static final int COLUMNINDEX_NAME = 1;
    public static final int COLUMNINDEX_VENDOR = 2;
    @LiveLanguageString
    public static String COLUMN_OPENED = "Open";
    @LiveLanguageString
    public static String COLUMN_NAME = "Name";
    @LiveLanguageString
    public static String COLUMN_VENDOR = "Vendor";
    @LiveLanguageString
    public static String COLUMN_DESCRIPTION = "Description";
    public static double FRAMESPERSECOND = 44100.0;
    private final Object m_SyncObject = new Object();

    public SPITType_MidiDevices_TableModel() {
        super(false);
        this.initMembers();
        LiveLanguage.addLanguageListener((Object)this, (String)"Midi_Client");
    }

    private void initMembers() {
    }

    public void finishJTable(JTable p_JTable) {
        SPITType_MidiDevicesCellRenderer o_TableCellEditorRenderer_String;
        if (p_JTable == null) {
            return;
        }
        TableRowSorter<SPITType_MidiDevices_TableModel> o_TableRowSorter = new TableRowSorter<SPITType_MidiDevices_TableModel>(this);
        super.finishJTable(p_JTable, o_TableRowSorter, null);
        TableColumnModel o_TableColumnModel = p_JTable.getColumnModel();
        TableColumn o_TableColumn = o_TableColumnModel.getColumn(0);
        if (o_TableColumn != null) {
            o_TableColumn.setMinWidth(40);
            o_TableColumn.setMaxWidth(40);
            o_TableColumn.setPreferredWidth(40);
            o_TableColumn.setResizable(false);
            TableAndListModel.TableCellEditorRenderer_CheckBox o_TableCellEditorRenderer_CheckBox = new TableAndListModel.TableCellEditorRenderer_CheckBox();
            o_TableColumn.setCellEditor((TableCellEditor)o_TableCellEditorRenderer_CheckBox);
            o_TableColumn.setCellRenderer((TableCellRenderer)o_TableCellEditorRenderer_CheckBox);
        }
        if ((o_TableColumn = o_TableColumnModel.getColumn(1)) != null) {
            o_TableCellEditorRenderer_String = new SPITType_MidiDevicesCellRenderer();
            o_TableColumn.setCellEditor((TableCellEditor)((Object)o_TableCellEditorRenderer_String));
            o_TableColumn.setCellRenderer((TableCellRenderer)((Object)o_TableCellEditorRenderer_String));
        }
        if ((o_TableColumn = o_TableColumnModel.getColumn(2)) != null) {
            o_TableCellEditorRenderer_String = new SPITType_MidiDevicesCellRenderer();
            o_TableColumn.setCellEditor((TableCellEditor)((Object)o_TableCellEditorRenderer_String));
            o_TableColumn.setCellRenderer((TableCellRenderer)((Object)o_TableCellEditorRenderer_String));
        }
        p_JTable.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.m_SyncObject;
        synchronized (object) {
            super.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMIDIDevice(MidiDeviceWrapper p_MidiDeviceWrapper) {
        if (p_MidiDeviceWrapper == null) {
            return false;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (this.contains(p_MidiDeviceWrapper)) {
                return false;
            }
            this.add(p_MidiDeviceWrapper);
            p_MidiDeviceWrapper.addPropertyChangeListener((PropertyChangeListener)this);
        }
        for (int intObject = 0; intObject < SPITType_MidiObject.s_SPITType_MidiObjectTableModel.size(); ++intObject) {
            SPITType_MidiObject o_SPITType_MidiObject = SPITType_MidiObject.s_SPITType_MidiObjectTableModel.getSPITType_MidiObject(intObject);
            if (o_SPITType_MidiObject == null) continue;
            o_SPITType_MidiObject.eventMidiDeviceAdded(p_MidiDeviceWrapper);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMIDIDevice(MidiDeviceWrapper p_MidiDeviceWrapper) {
        if (p_MidiDeviceWrapper == null) {
            return false;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            boolean boolRemoved = this.remove(p_MidiDeviceWrapper);
            p_MidiDeviceWrapper.removePropertyChangeListener((PropertyChangeListener)this);
        }
        for (int intObject = 0; intObject < SPITType_MidiObject.s_SPITType_MidiObjectTableModel.size(); ++intObject) {
            SPITType_MidiObject o_SPITType_MidiObject = SPITType_MidiObject.s_SPITType_MidiObjectTableModel.getSPITType_MidiObject(intObject);
            if (o_SPITType_MidiObject == null) continue;
            o_SPITType_MidiObject.eventMidiDeviceRemoved(p_MidiDeviceWrapper);
        }
        return true;
    }

    public MidiDeviceWrapper getMIDIDevice(int p_Index) {
        return (MidiDeviceWrapper)this.get(p_Index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MidiDeviceWrapper getMIDIDevice(Object p_MidiDevice) {
        if (p_MidiDevice == null) {
            return null;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            for (int intMidiDevice = 0; intMidiDevice < this.size(); ++intMidiDevice) {
                Object o_MidiDevice;
                MidiDeviceWrapper o_MidiDeviceWrapper = (MidiDeviceWrapper)this.get(intMidiDevice);
                if (o_MidiDeviceWrapper == null || (o_MidiDevice = o_MidiDeviceWrapper.getMidiDevice()) != p_MidiDevice) continue;
                return o_MidiDeviceWrapper;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MidiDeviceWrapper getMIDIDevice(String p_MidiDeviceID) {
        if (p_MidiDeviceID == null) {
            return null;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            for (int intMidiDevice = 0; intMidiDevice < this.size(); ++intMidiDevice) {
                MidiDeviceWrapper o_MidiDeviceWrapper = (MidiDeviceWrapper)this.get(intMidiDevice);
                if (o_MidiDeviceWrapper == null) continue;
                Object o_MidiDevice = o_MidiDeviceWrapper.getMidiDevice();
                if (!p_MidiDeviceID.equals(o_MidiDeviceWrapper.getID())) continue;
                return o_MidiDeviceWrapper;
            }
            return null;
        }
    }

    public int getColumnCount() {
        return 3;
    }

    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return COLUMN_OPENED;
            }
            case 1: {
                return COLUMN_NAME;
            }
            case 2: {
                return COLUMN_VENDOR;
            }
        }
        return "";
    }

    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Boolean.class;
        }
        return String.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue(MidiDeviceWrapper p_MidiDeviceWrapper, int columnIndex) {
        String stringValue = "";
        Object object = this.m_SyncObject;
        synchronized (object) {
            switch (columnIndex) {
                case 0: {
                    if (p_MidiDeviceWrapper == null) {
                        return false;
                    }
                    SPITType_MidiObject o_SPITType_MidiObject = MidiClient_StartFrame.s_SelfReference.getSelectedSPITType_MidiObject();
                    if (o_SPITType_MidiObject == null) {
                        return false;
                    }
                    if (!o_SPITType_MidiObject.containsMidiDevice(p_MidiDeviceWrapper)) {
                        return false;
                    }
                    return true;
                }
                case 1: {
                    if (p_MidiDeviceWrapper == null) {
                        stringValue = "";
                    }
                    stringValue = p_MidiDeviceWrapper.getInterfaceName();
                    break;
                }
                case 2: {
                    if (p_MidiDeviceWrapper == null) {
                        stringValue = "";
                    }
                    stringValue = p_MidiDeviceWrapper.getManufacturerName();
                }
            }
            return stringValue;
        }
    }

    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 0: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(MidiDeviceWrapper p_MidiDeviceWrapper, Object value, int col) {
        SPITType_MidiObject o_SPITType_MidiObject = MidiClient_StartFrame.s_SelfReference.getSelectedSPITType_MidiObject();
        if (o_SPITType_MidiObject == null) {
            return;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (p_MidiDeviceWrapper == null) {
                return;
            }
        }
        switch (col) {
            case 0: {
                if (!(value instanceof Boolean)) {
                    return;
                }
                boolean boolSelected = (Boolean)value;
                if (boolSelected) {
                    o_SPITType_MidiObject.addMidiDevice(p_MidiDeviceWrapper);
                    break;
                }
                o_SPITType_MidiObject.removeMidiDevice(p_MidiDeviceWrapper);
            }
        }
    }

    @Override
    public void propertyChange(final PropertyChangeEvent evt) {
        if (evt.getSource() instanceof MidiDeviceWrapper) {
            MidiDeviceWrapper o_MidiDeviceWrapper = (MidiDeviceWrapper)evt.getSource();
            if ("propertyselectionChanged".equals(evt.getPropertyName())) {
                this.changedElement(o_MidiDeviceWrapper);
            } else if ("propertyclosed".equals(evt.getPropertyName())) {
                EventQueueHandler.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SPITType_MidiDevices_TableModel.this.removeMIDIDevice((MidiDeviceWrapper)evt.getSource());
                    }
                });
            } else if ("propertyconnection".equals(evt.getPropertyName())) {
                this.changedElement(o_MidiDeviceWrapper);
            }
        }
    }

    public static class SPITType_MidiDevicesCellRenderer
    extends TableAndListModel.TableCellEditorRenderer_String {
        public static Color s_NotConfirmedColor = new Color(100, 0, 0);
        public static Color s_FIXEDColor = new Color(0, 100, 0);

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            MidiDeviceWrapper o_MidiDevice = null;
            JComponent o_JComponent = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (table.getModel() instanceof SPITType_MidiDevices_TableModel) {
                SPITType_MidiDevices_TableModel o_SPITType_MidiDevices_TableModel = (SPITType_MidiDevices_TableModel)((Object)table.getModel());
                try {
                    int intRowModel = table.convertRowIndexToModel(row);
                    o_MidiDevice = (MidiDeviceWrapper)o_SPITType_MidiDevices_TableModel.getElementAt(intRowModel);
                    if (!o_MidiDevice.getIsConnected()) {
                        o_JComponent.setBackground(s_NotConfirmedColor);
                    }
                }
                catch (Exception e) {
                    o_MidiDevice = null;
                }
            }
            return o_JComponent;
        }
    }

    public static class StringComparator_NumericInteger
    implements Comparator<String> {
        @Override
        public int compare(String o1, String o2) {
            Integer int2;
            Integer int1;
            if (o1 == null || o2 == null) {
                return 0;
            }
            try {
                int1 = Integer.valueOf(o1.trim());
                int2 = Integer.valueOf(o2.trim());
            }
            catch (Exception e) {
                return 0;
            }
            return int1.compareTo(int2);
        }
    }

    public static class StringComparator_Normal
    implements Comparator<String> {
        @Override
        public int compare(String o1, String o2) {
            if (o1 == null || o2 == null) {
                return 0;
            }
            return o1.compareToIgnoreCase(o2);
        }
    }
}

