/*
 * Decompiled with CFR 0.152.
 */
package SPITClientGUI;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import MIDIPackage.MidiCommDeviceType;
import MIDIPackage.SPITTrigger_MidiObject;
import SwingToolTipPackage.PopUpToolTip;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class MidiCommDeviceSelection
extends JDialog {
    public static Icon s_Icon = new ImageIcon(MidiCommDeviceSelection.class.getResource("/IconsPackage/USBPlug.png"));
    public static MidiCommDeviceSelection s_SelfReference = new MidiCommDeviceSelection(true);
    private MidiCommDeviceType m_SelectedHardwareType;
    private boolean m_Confirmed;
    private ButtonGroup buttonGroup_Hardware;
    private JButton jButton_Apply;
    private JButton jButton_Cancel;
    private JLabel jLabel_HardwareIcon;
    private JLabel jLabel_HardwareInfo;
    private JLabel jLabel_HardwareSelect;
    private JLabel jLabel_Manufactureer;
    private JPanel jPanel1;
    private JPanel jPanel_HardwareInfo;
    private JRadioButton jRadioButton_HardwareComm;
    private JRadioButton jRadioButton_HarwareLoopback;
    private JScrollPane jScrollPane_HardwareTypes;
    private JTree jTree_HardwareTypes;

    public static MidiCommDeviceSelection getSelfReference() {
        return s_SelfReference;
    }

    public static void closeProject() {
        if (s_SelfReference != null) {
            s_SelfReference.setVisible(false);
        }
    }

    public static void close() {
        if (s_SelfReference != null) {
            MidiCommDeviceSelection.closeProject();
            MidiCommDeviceSelection.s_SelfReference.jButton_Apply.setComponentPopupMenu(null);
            MidiCommDeviceSelection.s_SelfReference.jButton_Cancel.setComponentPopupMenu(null);
        }
    }

    public MidiCommDeviceSelection(boolean modal) {
        super((Frame)null, modal);
        s_SelfReference = this;
        this.initComponents();
        this.initMembers();
        this.initComponentsFurther();
    }

    private void initMembers() {
        this.m_Confirmed = false;
        MidiCommDeviceType.refreshDMXHardwareTypes();
        this.jTree_HardwareTypes.setModel((TreeModel)MidiCommDeviceType.getTreeModel());
        this.jTree_HardwareTypes.setCellRenderer((TreeCellRenderer)MidiCommDeviceType.getTreeCellRenderer());
        DefaultTreeSelectionModel o_TreeSelectionModel = new DefaultTreeSelectionModel();
        o_TreeSelectionModel.setSelectionMode(1);
        this.jTree_HardwareTypes.setSelectionModel(o_TreeSelectionModel);
        LiveLanguage.addLanguageListener((Object)this, (String)"Midi_Client");
        this.jButton_Apply.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_Cancel.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
    }

    public boolean getConfirmed() {
        return this.m_Confirmed;
    }

    public Object getSelectedDMXHardwareType() {
        if (this.jRadioButton_HardwareComm.isSelected()) {
            return this.m_SelectedHardwareType;
        }
        if (this.jRadioButton_HarwareLoopback.isSelected()) {
            return SPITTrigger_MidiObject.s_MidiTimecodeGenerator.createLoopbackDevice();
        }
        return null;
    }

    private void setSelectedDMXHardwareType(MidiCommDeviceType p_DMXHardwareType) {
        this.m_SelectedHardwareType = p_DMXHardwareType;
        if (this.m_SelectedHardwareType != null) {
            this.jLabel_Manufactureer.setIcon(this.m_SelectedHardwareType.getIconLogo());
            this.jLabel_HardwareIcon.setIcon(this.m_SelectedHardwareType.getIconInterface());
            this.jLabel_HardwareInfo.setText(this.m_SelectedHardwareType.getInterfaceName());
        } else {
            this.m_SelectedHardwareType = null;
            this.jLabel_Manufactureer.setIcon(null);
            this.jLabel_HardwareIcon.setIcon(null);
            this.jLabel_HardwareInfo.setText("");
        }
        this.refreshButtons();
    }

    private void refreshButtons() {
        if (this.jRadioButton_HarwareLoopback.isSelected()) {
            this.jButton_Apply.setEnabled(true);
        } else if (this.m_SelectedHardwareType != null) {
            this.jButton_Apply.setEnabled(true);
        } else {
            this.jButton_Apply.setEnabled(false);
        }
    }

    private void initComponents() {
        this.buttonGroup_Hardware = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jScrollPane_HardwareTypes = new JScrollPane();
        this.jTree_HardwareTypes = new JTree();
        this.jLabel_HardwareSelect = new JLabel();
        this.jButton_Cancel = new JButton();
        this.jButton_Apply = new JButton();
        this.jPanel_HardwareInfo = new JPanel();
        this.jLabel_HardwareIcon = new JLabel();
        this.jLabel_Manufactureer = new JLabel();
        this.jLabel_HardwareInfo = new JLabel();
        this.jRadioButton_HarwareLoopback = new JRadioButton();
        this.jRadioButton_HardwareComm = new JRadioButton();
        this.setTitle("Select Hardware Interface");
        this.setAlwaysOnTop(true);
        this.setIconImage(null);
        this.setMinimumSize(new Dimension(500, 400));
        this.setPreferredSize(new Dimension(370, 600));
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jScrollPane_HardwareTypes.setMaximumSize(null);
        this.jScrollPane_HardwareTypes.setMinimumSize(null);
        this.jTree_HardwareTypes.setMaximumSize(new Dimension(30000, 30000));
        this.jTree_HardwareTypes.setPreferredSize(new Dimension(250, 48));
        this.jTree_HardwareTypes.setRootVisible(false);
        this.jTree_HardwareTypes.setRowHeight(26);
        this.jTree_HardwareTypes.setShowsRootHandles(true);
        this.jTree_HardwareTypes.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MidiCommDeviceSelection.this.jTree_HardwareTypesMouseClicked(evt);
            }
        });
        this.jTree_HardwareTypes.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                MidiCommDeviceSelection.this.jTree_HardwareTypesValueChanged(evt);
            }
        });
        this.jScrollPane_HardwareTypes.setViewportView(this.jTree_HardwareTypes);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jScrollPane_HardwareTypes, gridBagConstraints);
        this.jLabel_HardwareSelect.setHorizontalAlignment(0);
        this.jLabel_HardwareSelect.setText("Select COMM Hardware");
        this.jLabel_HardwareSelect.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jLabel_HardwareSelect, gridBagConstraints);
        this.jButton_Cancel.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Cancel.png")));
        this.jButton_Cancel.setToolTipText("Cancel");
        this.jButton_Cancel.setActionCommand("Remove DMXUniverse");
        this.jButton_Cancel.setContentAreaFilled(false);
        this.jButton_Cancel.setMargin(new Insets(-1, -1, -1, -1));
        this.jButton_Cancel.setMaximumSize(new Dimension(125, 23));
        this.jButton_Cancel.setMinimumSize(new Dimension(32, 32));
        this.jButton_Cancel.setPreferredSize(new Dimension(32, 32));
        this.jButton_Cancel.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_Cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MidiCommDeviceSelection.this.jButton_CancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jButton_Cancel, gridBagConstraints);
        this.jButton_Apply.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_OK.png")));
        this.jButton_Apply.setToolTipText("add Hardware");
        this.jButton_Apply.setActionCommand("Remove DMXUniverse");
        this.jButton_Apply.setContentAreaFilled(false);
        this.jButton_Apply.setMargin(new Insets(-1, -1, -1, -1));
        this.jButton_Apply.setMaximumSize(new Dimension(125, 23));
        this.jButton_Apply.setMinimumSize(new Dimension(32, 32));
        this.jButton_Apply.setPreferredSize(new Dimension(32, 32));
        this.jButton_Apply.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_Apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MidiCommDeviceSelection.this.jButton_ApplyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jButton_Apply, gridBagConstraints);
        this.jPanel_HardwareInfo.setBackground(new Color(255, 255, 255));
        this.jPanel_HardwareInfo.setMinimumSize(new Dimension(50, 50));
        this.jPanel_HardwareInfo.setLayout(new GridBagLayout());
        this.jLabel_HardwareIcon.setBackground(new Color(255, 255, 254));
        this.jLabel_HardwareIcon.setForeground(new Color(0, 0, 1));
        this.jLabel_HardwareIcon.setHorizontalAlignment(0);
        this.jLabel_HardwareIcon.setHorizontalTextPosition(0);
        this.jLabel_HardwareIcon.setPreferredSize(new Dimension(100, 100));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.33;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_HardwareInfo.add((Component)this.jLabel_HardwareIcon, gridBagConstraints);
        this.jLabel_Manufactureer.setBackground(new Color(255, 255, 255));
        this.jLabel_Manufactureer.setFont(new Font("Tahoma", 1, 11));
        this.jLabel_Manufactureer.setForeground(new Color(0, 0, 1));
        this.jLabel_Manufactureer.setHorizontalAlignment(0);
        this.jLabel_Manufactureer.setHorizontalTextPosition(0);
        this.jLabel_Manufactureer.setPreferredSize(new Dimension(100, 100));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.33;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_HardwareInfo.add((Component)this.jLabel_Manufactureer, gridBagConstraints);
        this.jLabel_HardwareInfo.setBackground(new Color(255, 255, 254));
        this.jLabel_HardwareInfo.setForeground(new Color(0, 0, 1));
        this.jLabel_HardwareInfo.setHorizontalAlignment(0);
        this.jLabel_HardwareInfo.setHorizontalTextPosition(0);
        this.jLabel_HardwareInfo.setPreferredSize(new Dimension(100, 100));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.33;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_HardwareInfo.add((Component)this.jLabel_HardwareInfo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jPanel_HardwareInfo, gridBagConstraints);
        this.buttonGroup_Hardware.add(this.jRadioButton_HarwareLoopback);
        this.jRadioButton_HarwareLoopback.setText("Loopback Interface");
        this.jRadioButton_HarwareLoopback.setToolTipText("");
        this.jRadioButton_HarwareLoopback.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MidiCommDeviceSelection.this.jRadioButton_HarwareLoopbackItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 3, 3, 3);
        this.jPanel1.add((Component)this.jRadioButton_HarwareLoopback, gridBagConstraints);
        this.buttonGroup_Hardware.add(this.jRadioButton_HardwareComm);
        this.jRadioButton_HardwareComm.setSelected(true);
        this.jRadioButton_HardwareComm.setText("Comm Hardware");
        this.jRadioButton_HardwareComm.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jRadioButton_HardwareComm, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void initComponentsFurther() {
        this.getContentPane().setBackground(Color.DARK_GRAY);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                MidiCommDeviceSelection.this.m_Confirmed = false;
            }
        });
        this.setIconImage(((ImageIcon)s_Icon).getImage());
    }

    private void jTree_HardwareTypesValueChanged(TreeSelectionEvent evt) {
        TreePath o_TreePath = evt.getNewLeadSelectionPath();
        if (o_TreePath == null) {
            this.setSelectedDMXHardwareType(null);
            return;
        }
        Object o_SourceObject = ((MidiCommDeviceType.DMXHardwareTypeTreeNode)o_TreePath.getLastPathComponent()).getSourceObject();
        if (o_SourceObject instanceof MidiCommDeviceType) {
            this.setSelectedDMXHardwareType((MidiCommDeviceType)o_SourceObject);
        } else {
            this.setSelectedDMXHardwareType(null);
        }
    }

    private void jButton_CancelActionPerformed(ActionEvent evt) {
        this.m_Confirmed = false;
        this.setVisible(false);
    }

    private void jButton_ApplyActionPerformed(ActionEvent evt) {
        this.m_Confirmed = true;
        this.setVisible(false);
    }

    private void jTree_HardwareTypesMouseClicked(MouseEvent evt) {
        this.jRadioButton_HardwareComm.setSelected(true);
    }

    private void jRadioButton_HarwareLoopbackItemStateChanged(ItemEvent evt) {
        this.refreshButtons();
    }
}

