/*
 * Decompiled with CFR 0.152.
 */
package MIDIPackage;

import MIDIPackage.MIDI_Devices;
import MIDIPackage.MIDI_MessageObject;
import MIDIPackage.MidiDeviceWrapper;
import MIDIPackage.MidiMessageListener;
import MIDIPackage.MidiMessageSender;
import MIDIPackage.MidiTimecodeGenerator;
import MIDIPackage.SPITType_MidiObject;
import MIDIPackage.SPIT_MidiObject;
import SPITActionPackage.SPIT_ActionStatus;
import SPITActionPackage.SPIT_Action_Interface;
import SPITClientGUI.SPITTrigger_MidiObjectTableModel;
import SPITClientPackage.SPIT_Client;
import SPITClientPackage.SPIT_Object;
import SPITLibraryPackage.SPIT_ClientInterface;
import SPITLibraryPackage.SPIT_Object_Interface;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;

public class SPITTrigger_MidiObject
extends SPIT_MidiObject
implements MidiMessageListener,
SPIT_Action_Interface,
PropertyChangeListener,
Externalizable {
    public static final int SOFTWAREVERSION = 1;
    public static SPITTrigger_MidiObjectTableModel s_SPITTrigger_MidiObjectTableModel = new SPITTrigger_MidiObjectTableModel();
    public static MidiTimecodeGenerator s_MidiTimecodeGenerator = new MidiTimecodeGenerator();
    private boolean m_LastGenerator_UseTimecodeManual;
    private SPITType_MidiObject m_SPITType_MidiObject;
    private long m_LastPlayInsideFrame;

    public static void addSPITTrigger_MidiObject(SPIT_Client p_SPIT_Client, SPIT_Object_Interface p_SPIT_Object_Interface) {
        if (p_SPIT_Object_Interface == null) {
            return;
        }
        if (s_SPITTrigger_MidiObjectTableModel.contains(p_SPIT_Object_Interface.getID())) {
            return;
        }
        SPITTrigger_MidiObject o_SPITTrigger_MidiObject = new SPITTrigger_MidiObject(p_SPIT_Client, p_SPIT_Object_Interface);
        s_SPITTrigger_MidiObjectTableModel.addSPIT_MidiObject(o_SPITTrigger_MidiObject);
    }

    public static void addSPITTrigger_MidiObject_ReadExternal(SPIT_Client p_SPIT_Client, SPITTrigger_MidiObject p_SPITTrigger_MidiObject) {
        if (p_SPITTrigger_MidiObject == null) {
            return;
        }
        if (s_SPITTrigger_MidiObjectTableModel.contains(p_SPITTrigger_MidiObject)) {
            return;
        }
        s_SPITTrigger_MidiObjectTableModel.addSPIT_MidiObject(p_SPITTrigger_MidiObject);
    }

    public static void removeSPITTrigger_MidiObject(SPIT_Object_Interface p_SPIT_Object_Interface) {
        if (p_SPIT_Object_Interface == null) {
            return;
        }
        SPIT_MidiObject o_SPIT_MidiObject = s_SPITTrigger_MidiObjectTableModel.getSPIT_MidiObject(p_SPIT_Object_Interface.getID());
        if (o_SPIT_MidiObject == null) {
            return;
        }
        s_SPITTrigger_MidiObjectTableModel.removeSPIT_MidiObject(o_SPIT_MidiObject);
    }

    public static void save(ObjectOutput out) throws IOException {
        SPITTrigger_MidiObject.saveSPITTrigger_MidiObjects(out);
    }

    public static void load(ObjectInput in) throws IOException, ClassNotFoundException {
        SPITTrigger_MidiObject.loadSPITTrigger_MidiObjects(in);
    }

    public static void saveSPITTrigger_MidiObjects(ObjectOutput out) throws IOException {
        SPITTrigger_MidiObject o_SPITTrigger_MidiObject;
        int intType;
        int intSPITTypeCount = s_SPITTrigger_MidiObjectTableModel.size();
        ArrayList<SPITTrigger_MidiObject> o_SPITTrigger_MidiObjects = new ArrayList<SPITTrigger_MidiObject>(intSPITTypeCount);
        for (intType = 0; intType < intSPITTypeCount; ++intType) {
            o_SPITTrigger_MidiObject = (SPITTrigger_MidiObject)s_SPITTrigger_MidiObjectTableModel.getSPIT_MidiObject(intType);
            if (o_SPITTrigger_MidiObject == null) continue;
            o_SPITTrigger_MidiObjects.add(o_SPITTrigger_MidiObject);
        }
        out.writeInt(1);
        out.writeInt(o_SPITTrigger_MidiObjects.size());
        for (intType = 0; intType < o_SPITTrigger_MidiObjects.size(); ++intType) {
            o_SPITTrigger_MidiObject = (SPITTrigger_MidiObject)o_SPITTrigger_MidiObjects.get(intType);
            o_SPITTrigger_MidiObject.writeExternal(out);
        }
    }

    public static void loadSPITTrigger_MidiObjects(ObjectInput in) throws IOException, ClassNotFoundException {
        SPITTrigger_MidiObject o_SPITTrigger_MidiObject;
        int intObject;
        int intSoftwareVersion = in.readInt();
        int intObjectCount = in.readInt();
        ArrayList<SPITTrigger_MidiObject> o_SPITTrigger_MidiObjects = new ArrayList<SPITTrigger_MidiObject>(intObjectCount);
        for (intObject = 0; intObject < intObjectCount; ++intObject) {
            o_SPITTrigger_MidiObject = new SPITTrigger_MidiObject(SPIT_Client.s_SelfReference);
            o_SPITTrigger_MidiObject.readExternal(in);
            o_SPITTrigger_MidiObjects.add(o_SPITTrigger_MidiObject);
        }
        for (intObject = 0; intObject < intObjectCount; ++intObject) {
            SPITType_MidiObject o_SPITType_MidiObject;
            o_SPITTrigger_MidiObject = (SPITTrigger_MidiObject)s_SPITTrigger_MidiObjectTableModel.getSPIT_MidiObject(intObject);
            if (o_SPITTrigger_MidiObject == null || (o_SPITType_MidiObject = o_SPITTrigger_MidiObject.getSPITType_MidiObject()) == null) continue;
            o_SPITTrigger_MidiObject.assignSPITAction(o_SPITType_MidiObject.isSet());
        }
    }

    public static void clearTrash() {
    }

    public SPITTrigger_MidiObject(SPIT_ClientInterface p_SPIT_ClientInterface) {
        super(p_SPIT_ClientInterface);
        this.initMembers();
    }

    public SPITTrigger_MidiObject(SPIT_Client p_SPIT_Client, SPIT_Object_Interface p_SPIT_Object) {
        super(p_SPIT_Client, p_SPIT_Object);
        this.initMembers();
        MIDI_Devices.addMidiMessageListener(this);
        this.m_SPIT_Object_Interface.addPropertyChangeListener(this);
        this.m_SPITType_MidiObject = SPITType_MidiObject.getSPITType_MidiObject(p_SPIT_Object.getSPITTypeID());
        if (this.m_SPITType_MidiObject != null) {
            this.m_SPITType_MidiObject.addPropertyChangeListener(this);
            this.assignSPITAction(this.m_SPITType_MidiObject.isSet());
        }
    }

    private void initMembers() {
        this.m_SPITType_MidiObject = null;
        this.m_LastPlayInsideFrame = 0L;
    }

    public void setSPIT_ObjectInterface(SPIT_Object_Interface p_SPIT_Object_Interface) {
        if (this.m_SPIT_Object_Interface == p_SPIT_Object_Interface) {
            return;
        }
        if (this.m_SPIT_Object_Interface != null) {
            // empty if block
        }
        this.m_SPIT_Object_Interface = p_SPIT_Object_Interface;
        if (this.m_SPIT_Object_Interface != null) {
            this.m_SPIT_Object_Interface.addPropertyChangeListener(this);
        }
    }

    public void setSPITType_MidiObject(SPITType_MidiObject p_SPITType_MidiObject) {
        if (this.m_SPITType_MidiObject == p_SPITType_MidiObject) {
            return;
        }
        if (this.m_SPITType_MidiObject != null) {
            // empty if block
        }
        this.m_SPITType_MidiObject = p_SPITType_MidiObject;
        if (this.m_SPITType_MidiObject != null) {
            this.m_SPITType_MidiObject.addPropertyChangeListener(this);
            this.assignSPITAction(this.m_SPITType_MidiObject.isSet());
        }
    }

    @Override
    public void close() {
        MIDI_Devices.removeMidiMessageListener(this);
        if (this.m_SPITType_MidiObject != null) {
            this.m_SPITType_MidiObject.removePropertyChangeListener(this);
        }
        if (this.m_SPIT_Object_Interface != null) {
            this.m_SPIT_Object_Interface.removePropertyChangeListener(this);
        }
        super.close();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        this.m_SPIT_Object_Interface.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        SPIT_Object o_SPIT_Object = new SPIT_Object();
        o_SPIT_Object.readExternal(in);
        if (SPIT_Object.getSPIT_Object(o_SPIT_Object.getID()) != null) {
            boolean bl = false;
        }
        this.m_SPIT_Object_Interface = o_SPIT_Object;
        this.m_SPIT_Object_Interface.addPropertyChangeListener(this);
        this.m_SPITType_MidiObject = SPITType_MidiObject.getSPITType_MidiObject(this.m_SPIT_Object_Interface.getSPITTypeID());
        if (this.m_SPITType_MidiObject != null) {
            SPITTrigger_MidiObject.addSPITTrigger_MidiObject_ReadExternal(SPIT_Client.s_SelfReference, this);
            this.m_SPITType_MidiObject.addPropertyChangeListener(this);
        } else {
            this.close();
        }
    }

    public MIDI_MessageObject getMIDI_MessageObject(int p_MidiObjectPosition) {
        SPITType_MidiObject o_SPITType_MidiObject = this.m_SPITType_MidiObject;
        if (o_SPITType_MidiObject == null) {
            return null;
        }
        return o_SPITType_MidiObject.getMIDI_MessageObject(p_MidiObjectPosition);
    }

    public void eventMidiMessageReceived(MidiDeviceWrapper p_MidiDeviceWrapper, byte[] p_MidiMessageBytes) {
        if (p_MidiMessageBytes == null) {
            return;
        }
        if (s_IsLearning) {
            return;
        }
    }

    public void eventMidiMessageReceived(MidiDeviceWrapper p_MidiDeviceWrapper, MIDI_MessageObject p_MIDI_MessageObject) {
        if (p_MIDI_MessageObject == null) {
            return;
        }
        if (s_IsLearning) {
            return;
        }
    }

    public SPITType_MidiObject getSPITType_MidiObject() {
        return this.m_SPITType_MidiObject;
    }

    public void assignSPITAction(boolean p_AssignSPITAction) {
        SPIT_Object_Interface o_SPIT_Object_Interface = this.m_SPIT_Object_Interface;
        if (o_SPIT_Object_Interface == null) {
            return;
        }
        if (p_AssignSPITAction) {
            if (o_SPIT_Object_Interface.getSPIT_Action_Interface() != null) {
                return;
            }
            o_SPIT_Object_Interface.setSPIT_Action_Interface(this, null);
        } else {
            if (o_SPIT_Object_Interface.getSPIT_Action_Interface() == null) {
                return;
            }
            o_SPIT_Object_Interface.setSPIT_Action_Interface(null, null);
        }
    }

    private long calculateTimecodeStart(MIDI_MessageObject p_MIDI_MessageObject, SPIT_ActionStatus p_SPIT_ActionStatus) {
        long longStartTime;
        if (p_SPIT_ActionStatus.getIsPlayPrePosition()) {
            return -1L;
        }
        long longTimeInsideObject = (long)(1000.0 * (double)p_SPIT_ActionStatus.getPlayFrameInside() / (double)this.m_SPIT_Client.getServerFramesPerSecond());
        if (longTimeInsideObject < (long)this.m_SPIT_Client.getServerStepTime()) {
            longTimeInsideObject = 0L;
        }
        if (p_MIDI_MessageObject.getUseTimecodeManual()) {
            this.m_LastGenerator_UseTimecodeManual = true;
            longStartTime = p_MIDI_MessageObject.getMidiTimecode_Trigger();
        } else {
            this.m_LastGenerator_UseTimecodeManual = false;
            longStartTime = (long)(1000.0 * (double)this.getSPIT_Object_Interface().getFrameStart() / (double)this.m_SPIT_Client.getServerFramesPerSecond());
        }
        if (longTimeInsideObject > 0L) {
            longStartTime += longTimeInsideObject;
        }
        return longStartTime;
    }

    private boolean checkJumped(SPIT_ActionStatus p_SPIT_ActionStatus) {
        long longTimeInsideObject_Last;
        long longTimeInsideObject = (long)(1000.0 * (double)p_SPIT_ActionStatus.getPlayFrameInside() / (double)this.m_SPIT_Client.getServerFramesPerSecond());
        return Math.abs(longTimeInsideObject - (longTimeInsideObject_Last = (long)(1000.0 * (double)this.m_LastPlayInsideFrame / (double)this.m_SPIT_Client.getServerFramesPerSecond()))) > (long)(2 * this.m_SPIT_Client.getServerStepTime());
    }

    @Override
    public void playStarted(SPIT_Object_Interface p_SPIT_Object_Interface, SPIT_ActionStatus p_SPIT_ActionStatus, Object p_ActionObject) {
        SPITType_MidiObject o_SPITType_MidiObject = this.m_SPITType_MidiObject;
        if (o_SPITType_MidiObject == null) {
            return;
        }
        MIDI_MessageObject o_MIDI_MessageObject = o_SPITType_MidiObject.getMIDI_MessageObject(0);
        if (o_MIDI_MessageObject == null) {
            return;
        }
        if (o_MIDI_MessageObject.getTypeSub() == 3) {
            if (!p_SPIT_ActionStatus.getIsPlayPrePosition()) {
                long longStartTime = this.calculateTimecodeStart(o_MIDI_MessageObject, p_SPIT_ActionStatus);
                s_MidiTimecodeGenerator.stop((Object)this);
                if (p_SPIT_ActionStatus.getPlayerIsRunning()) {
                    s_MidiTimecodeGenerator.start((Object)this, (MidiMessageSender.MidiMessageDeviceContainer)o_SPITType_MidiObject, longStartTime);
                }
                this.m_LastPlayInsideFrame = p_SPIT_ActionStatus.getPlayFrameInside();
            }
        } else {
            int intMidiValue;
            s_MidiTimecodeGenerator.stop((Object)this);
            if (o_MIDI_MessageObject.getUseTriggerObjectValue()) {
                double doubleValueFactor = (double)p_SPIT_ActionStatus.getPlayValue() / 1000000.0;
                double doubleVolumeFactor = (double)p_SPIT_Object_Interface.getValueFactor() / 1000000.0;
                intMidiValue = (int)((double)o_MIDI_MessageObject.getValueMax() * doubleValueFactor * doubleVolumeFactor);
            } else {
                intMidiValue = o_MIDI_MessageObject.getValue();
            }
            o_MIDI_MessageObject.setValueToSend(intMidiValue);
            MIDI_Devices.s_MessageSender.sendMidiMessage_Trigger(o_MIDI_MessageObject, (MidiMessageSender.MidiMessageDeviceContainer)o_SPITType_MidiObject);
        }
    }

    @Override
    public void play(SPIT_Object_Interface p_SPIT_Object_Interface, SPIT_ActionStatus p_SPIT_ActionStatus, Object p_ActionObject) {
        int intMidiValue;
        SPITType_MidiObject o_SPITType_MidiObject = this.m_SPITType_MidiObject;
        if (o_SPITType_MidiObject == null) {
            return;
        }
        MIDI_MessageObject o_MIDI_MessageObject = o_SPITType_MidiObject.getMIDI_MessageObject(0);
        if (o_MIDI_MessageObject == null) {
            return;
        }
        if (o_MIDI_MessageObject.getTypeSub() == 3) {
            if (!p_SPIT_ActionStatus.getIsPlayPrePosition()) {
                if (!p_SPIT_ActionStatus.getPlayerIsRunning()) {
                    s_MidiTimecodeGenerator.stop((Object)this);
                } else if (this.checkJumped(p_SPIT_ActionStatus)) {
                    s_MidiTimecodeGenerator.start((Object)this, (MidiMessageSender.MidiMessageDeviceContainer)o_SPITType_MidiObject, this.calculateTimecodeStart(o_MIDI_MessageObject, p_SPIT_ActionStatus));
                } else if (s_MidiTimecodeGenerator.getActor() == this || s_MidiTimecodeGenerator.getActor() == null) {
                    if (!s_MidiTimecodeGenerator.isRunning()) {
                        s_MidiTimecodeGenerator.start((Object)this, (MidiMessageSender.MidiMessageDeviceContainer)o_SPITType_MidiObject, this.calculateTimecodeStart(o_MIDI_MessageObject, p_SPIT_ActionStatus));
                    } else if (o_MIDI_MessageObject.getUseTimecodeManual() != this.m_LastGenerator_UseTimecodeManual) {
                        s_MidiTimecodeGenerator.stop((Object)this);
                        s_MidiTimecodeGenerator.start((Object)this, (MidiMessageSender.MidiMessageDeviceContainer)o_SPITType_MidiObject, this.calculateTimecodeStart(o_MIDI_MessageObject, p_SPIT_ActionStatus));
                    }
                }
            }
            this.m_LastPlayInsideFrame = p_SPIT_ActionStatus.getPlayFrameInside();
        } else {
            s_MidiTimecodeGenerator.stop((Object)this);
        }
        o_MIDI_MessageObject = o_SPITType_MidiObject.getMIDI_MessageObject(1);
        if (o_MIDI_MessageObject.getUseTriggerObjectValue()) {
            double doubleValueFactor = (double)p_SPIT_ActionStatus.getPlayValue() / 1000000.0;
            double doubleVolumeFactor = (double)p_SPIT_Object_Interface.getValueFactor() / 1000000.0;
            intMidiValue = (int)((double)o_MIDI_MessageObject.getValueMax() * doubleValueFactor * doubleVolumeFactor);
        } else {
            intMidiValue = o_MIDI_MessageObject.getValue();
        }
        o_MIDI_MessageObject.setValueToSend(intMidiValue);
        MIDI_Devices.s_MessageSender.sendMidiMessage_Trigger(o_MIDI_MessageObject, (MidiMessageSender.MidiMessageDeviceContainer)o_SPITType_MidiObject);
    }

    @Override
    public void playEnd(SPIT_Object_Interface p_SPIT_Object_Interface, SPIT_ActionStatus p_SPIT_ActionStatus, Object p_ActionObject) {
        int intMidiValue;
        SPITType_MidiObject o_SPITType_MidiObject = this.m_SPITType_MidiObject;
        if (o_SPITType_MidiObject == null) {
            return;
        }
        MIDI_MessageObject o_MIDI_MessageObject = o_SPITType_MidiObject.getMIDI_MessageObject(0);
        if (o_MIDI_MessageObject == null) {
            return;
        }
        if (o_MIDI_MessageObject.getTypeSub() == 3) {
            if (!p_SPIT_ActionStatus.getIsPlayPrePosition()) {
                s_MidiTimecodeGenerator.stop((Object)this);
            }
        } else {
            s_MidiTimecodeGenerator.stop((Object)this);
        }
        if ((o_MIDI_MessageObject = o_SPITType_MidiObject.getMIDI_MessageObject(2)).getUseTriggerObjectValue()) {
            double doubleValueFactor = (double)p_SPIT_ActionStatus.getPlayValue() / 1000000.0;
            double doubleVolumeFactor = (double)p_SPIT_Object_Interface.getValueFactor() / 1000000.0;
            intMidiValue = (int)((double)o_MIDI_MessageObject.getValueMax() * doubleValueFactor * doubleVolumeFactor);
        } else {
            intMidiValue = o_MIDI_MessageObject.getValue();
        }
        o_MIDI_MessageObject.setValueToSend(intMidiValue);
        MIDI_Devices.s_MessageSender.sendMidiMessage_Trigger(o_MIDI_MessageObject, (MidiMessageSender.MidiMessageDeviceContainer)o_SPITType_MidiObject);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        SPIT_Object_Interface o_SPIT_Object_Interface;
        if (evt.getSource() instanceof SPITType_MidiObject) {
            SPITType_MidiObject o_SPITType_MidiObject = (SPITType_MidiObject)evt.getSource();
            if (("midiObjectChanged".equals(evt.getPropertyName()) || "midiDeviceChanged".equals(evt.getPropertyName())) && o_SPITType_MidiObject == this.m_SPITType_MidiObject) {
                if (o_SPITType_MidiObject != null) {
                    this.assignSPITAction(o_SPITType_MidiObject.isSet());
                } else {
                    this.assignSPITAction(false);
                }
            }
        }
        if (evt.getSource() instanceof SPIT_Object_Interface && (o_SPIT_Object_Interface = (SPIT_Object_Interface)evt.getSource()) == this.m_SPIT_Object_Interface) {
            if ("paramchanged".equals(evt.getPropertyName())) {
                this.m_SPITType_MidiObject = SPITType_MidiObject.getSPITType_MidiObject(o_SPIT_Object_Interface.getSPITTypeID());
                SPITType_MidiObject o_SPITType_MidiObject = this.m_SPITType_MidiObject;
                if (o_SPITType_MidiObject != null) {
                    this.assignSPITAction(o_SPITType_MidiObject.isSet());
                } else {
                    this.assignSPITAction(false);
                }
            } else if ("closed".equals(evt.getPropertyName())) {
                SPITTrigger_MidiObject.removeSPITTrigger_MidiObject(o_SPIT_Object_Interface);
                this.close();
            }
        }
    }
}

