/*
 * Decompiled with CFR 0.152.
 */
package MIDIPackage;

import MIDIPackage.MIDI_Devices;
import MIDIPackage.MIDI_MessageObject;
import MIDIPackage.MidiDeviceWrapper;
import MIDIPackage.MidiMessageListener;
import MIDIPackage.SPIT_MidiObject;
import SPITClientGUI.SPITRemote_MidiObjectTableModel;
import SPITClientPackage.SPIT_Client;
import SPITClientPackage.SPIT_Object;
import SPITClientPackage.SPIT_Type;
import SPITLibraryPackage.SPIT_ClientInterface;
import SPITLibraryPackage.SPIT_Object_Interface;
import SPITLibraryPackage.SPIT_Type_Interface;
import SPITRemotePackage.SPITRemote;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;

public class SPITRemote_MidiObject
extends SPIT_MidiObject
implements MidiMessageListener,
SPIT_Object_Interface.SPIT_Object_Listener,
PropertyChangeListener,
MIDI_MessageObject.MessageContainer,
Externalizable {
    public static final int SOFTWAREVERSION = 1;
    public static SPITRemote_MidiObjectTableModel s_SPITRemote_MidiObjectTableModel = new SPITRemote_MidiObjectTableModel();
    private MidiDeviceWrapper m_LastDeviceReceived;
    private MIDI_MessageObject m_MIDI_MessageObject_Received;
    private static HashMap<String, MIDI_MessageObject> s_UndoTrash_MidiMessageObjects = new HashMap();

    public static void addSPITRemote_MidiObject(SPIT_Client p_SPIT_Client, SPIT_Object_Interface p_SPIT_Object_Interface) {
        if (p_SPIT_Object_Interface == null) {
            return;
        }
        if (s_SPITRemote_MidiObjectTableModel.contains(p_SPIT_Object_Interface.getID())) {
            return;
        }
        SPITRemote_MidiObject o_SPIT_MidiObject = new SPITRemote_MidiObject(p_SPIT_Client, p_SPIT_Object_Interface);
        s_SPITRemote_MidiObjectTableModel.addSPIT_MidiObject(o_SPIT_MidiObject);
    }

    public static void addSPITRemote_MidiObject_ReadExternal(SPIT_Client p_SPIT_Client, SPITRemote_MidiObject p_SPITRemote_MidiObject) {
        if (p_SPITRemote_MidiObject == null) {
            return;
        }
        if (s_SPITRemote_MidiObjectTableModel.contains(p_SPITRemote_MidiObject.getID())) {
            return;
        }
        s_SPITRemote_MidiObjectTableModel.addSPIT_MidiObject(p_SPITRemote_MidiObject);
    }

    public static void removeSPITRemote_MidiObject(SPIT_Object_Interface p_SPIT_Object_Interface) {
        if (p_SPIT_Object_Interface == null) {
            return;
        }
        SPIT_MidiObject o_SPIT_MidiObject = s_SPITRemote_MidiObjectTableModel.getSPIT_MidiObject(p_SPIT_Object_Interface.getID());
        if (o_SPIT_MidiObject == null) {
            return;
        }
        s_SPITRemote_MidiObjectTableModel.removeSPIT_MidiObject(o_SPIT_MidiObject);
    }

    public static void saveRemoteSPITTypes(ObjectOutput out) throws IOException {
        SPIT_Type_Interface o_SPIT_Type_Interface;
        int intType;
        int intSPITRemoteTypeCount = SPITRemote.getRemoteSPIT_TypeCount();
        ArrayList<SPIT_Type_Interface> o_SPITTypes = new ArrayList<SPIT_Type_Interface>(intSPITRemoteTypeCount);
        for (intType = 0; intType < intSPITRemoteTypeCount; ++intType) {
            o_SPIT_Type_Interface = SPITRemote.getRemoteSPIT_Type(intType);
            if (o_SPIT_Type_Interface == null || o_SPITTypes.contains(o_SPIT_Type_Interface)) continue;
            o_SPITTypes.add(o_SPIT_Type_Interface);
        }
        out.writeInt(1);
        out.writeInt(o_SPITTypes.size());
        for (intType = 0; intType < o_SPITTypes.size(); ++intType) {
            o_SPIT_Type_Interface = (SPIT_Type_Interface)o_SPITTypes.get(intType);
            o_SPIT_Type_Interface.writeExternal(out);
        }
    }

    public static void loadRemoteSPITTypes(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        int intTypeCount = in.readInt();
        for (int intType = 0; intType < intTypeCount; ++intType) {
            SPIT_Type o_SPIT_Type = new SPIT_Type();
            o_SPIT_Type.readExternal(in);
        }
    }

    public static void saveSPITRemote_MidiObjects(ObjectOutput out) throws IOException {
        SPITRemote_MidiObject o_SPITRemote_MidiObject;
        int intType;
        int intObjectCount = s_SPITRemote_MidiObjectTableModel.size();
        ArrayList<SPITRemote_MidiObject> o_SPITRemote_MidiObjects = new ArrayList<SPITRemote_MidiObject>(intObjectCount);
        for (intType = 0; intType < intObjectCount; ++intType) {
            o_SPITRemote_MidiObject = (SPITRemote_MidiObject)s_SPITRemote_MidiObjectTableModel.getSPIT_MidiObject(intType);
            if (o_SPITRemote_MidiObject == null) continue;
            o_SPITRemote_MidiObjects.add(o_SPITRemote_MidiObject);
        }
        out.writeInt(1);
        out.writeInt(o_SPITRemote_MidiObjects.size());
        for (intType = 0; intType < o_SPITRemote_MidiObjects.size(); ++intType) {
            o_SPITRemote_MidiObject = (SPITRemote_MidiObject)o_SPITRemote_MidiObjects.get(intType);
            o_SPITRemote_MidiObject.writeExternal(out);
        }
    }

    public static void loadSPITRemote_MidiObjects(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        int intObjectCount = in.readInt();
        ArrayList<SPITRemote_MidiObject> o_SPITRemote_MidiObjects = new ArrayList<SPITRemote_MidiObject>(intObjectCount);
        for (int intType = 0; intType < intObjectCount; ++intType) {
            SPITRemote_MidiObject o_SPITRemote_MidiObject = new SPITRemote_MidiObject(SPIT_Client.s_SelfReference);
            o_SPITRemote_MidiObject.readExternal(in);
            o_SPITRemote_MidiObjects.add(o_SPITRemote_MidiObject);
        }
    }

    public static void save(ObjectOutput out) throws IOException {
        SPITRemote_MidiObject.saveRemoteSPITTypes(out);
        SPITRemote_MidiObject.saveSPITRemote_MidiObjects(out);
    }

    public static void load(ObjectInput in) throws IOException, ClassNotFoundException {
        SPITRemote_MidiObject.loadRemoteSPITTypes(in);
        SPITRemote_MidiObject.loadSPITRemote_MidiObjects(in);
    }

    public static void clearUndoTrash() {
        s_UndoTrash_MidiMessageObjects.clear();
    }

    public SPITRemote_MidiObject(SPIT_Client p_SPIT_Client) {
        super(p_SPIT_Client);
        this.initMembers();
        MIDI_Devices.addMidiMessageListener(this);
        SPIT_Object.addSPIT_Object_Listener(this);
    }

    public SPITRemote_MidiObject(SPIT_Client p_SPIT_Client, SPIT_Object_Interface p_SPIT_Object) {
        super(p_SPIT_Client, p_SPIT_Object);
        this.initMembers();
        this.initMIDI_MessageObjects(p_SPIT_Object.getID());
        if (this.m_SPIT_Object_Interface != null) {
            this.m_SPIT_Object_Interface.addPropertyChangeListener(this);
        }
        MIDI_Devices.addMidiMessageListener(this);
        SPIT_Object.addSPIT_Object_Listener(this);
    }

    private void initMembers() {
        this.m_MIDI_MessageObject_Received = new MIDI_MessageObject();
        this.m_LastDeviceReceived = null;
    }

    private void initMIDI_MessageObjects(String p_ID) {
        this.m_MIDI_MessageObject = s_UndoTrash_MidiMessageObjects.get(p_ID);
        if (this.m_MIDI_MessageObject == null) {
            this.m_MIDI_MessageObject = new MIDI_MessageObject();
        }
    }

    @Override
    public void close() {
        MIDI_MessageObject o_MIDI_MessageObject;
        SPIT_Object.removeSPIT_Object_Listener(this);
        MIDI_Devices.removeMidiMessageListener(this);
        if (this.m_SPIT_Object_Interface != null) {
            this.m_SPIT_Object_Interface.removePropertyChangeListener(this);
        }
        if ((o_MIDI_MessageObject = this.m_MIDI_MessageObject) != null) {
            s_UndoTrash_MidiMessageObjects.put(this.getID(), o_MIDI_MessageObject);
        }
        super.close();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        this.m_SPIT_Object_Interface.writeExternal(out);
        this.m_MIDI_MessageObject.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        SPIT_Object o_SPIT_Object = new SPIT_Object();
        o_SPIT_Object.readExternal(in);
        this.m_SPIT_Object_Interface = o_SPIT_Object;
        this.m_SPIT_Object_Interface.addPropertyChangeListener(this);
        this.initMIDI_MessageObjects(o_SPIT_Object.getID());
        this.m_MIDI_MessageObject.readExternal(in);
        SPITRemote_MidiObject.addSPITRemote_MidiObject_ReadExternal(SPIT_Client.s_SelfReference, this);
    }

    public void setMidiTimecode_Trigger(long p_MIlliseconds) {
        this.m_MIDI_MessageObject.getMidiTimecode().setTimeTrigger(p_MIlliseconds);
    }

    public void setMidiTimecode_ObjectStart(long p_Milliseconds) {
        this.m_MIDI_MessageObject.setMidiTimecode_ObjectStart(p_Milliseconds);
    }

    public long getMidiTimecode_ObjectStart() {
        return this.m_MIDI_MessageObject.getMidiTimecode_ObjectStart();
    }

    public void setUseTimecodeManual(boolean p_UseTimecodeManual) {
        this.m_MIDI_MessageObject.setUseTimecodeManual(p_UseTimecodeManual);
    }

    @Override
    public boolean getUseTimecodeManual() {
        return this.m_MIDI_MessageObject.getUseTimecodeManual();
    }

    public void eventMidiMessageReceived(MidiDeviceWrapper p_MidiDeviceWrapper, byte[] p_MidiMessage) {
    }

    public void eventMidiMessageReceived(MidiDeviceWrapper p_MidiDeviceWrapper, MIDI_MessageObject p_MIDI_MessageObject) {
        int intValueMax;
        int intValue;
        if (p_MidiDeviceWrapper == null) {
            return;
        }
        if (p_MIDI_MessageObject == null) {
            return;
        }
        if (!(p_MIDI_MessageObject instanceof MIDI_MessageObject)) {
            return;
        }
        if (s_IsLearning) {
            return;
        }
        if (p_MidiDeviceWrapper.getDeviceType() == 0) {
            return;
        }
        SPIT_Object_Interface o_SPIT_Object_Interface = this.m_SPIT_Object_Interface;
        MIDI_MessageObject o_MIDI_MessageObject = this.m_MIDI_MessageObject;
        int intSPITValue = 0;
        boolean boolTrigger = false;
        if (o_MIDI_MessageObject == null) {
            return;
        }
        if (o_SPIT_Object_Interface == null) {
            return;
        }
        this.m_MIDI_MessageObject_Received.copyReceivedFrom(p_MIDI_MessageObject);
        if (o_MIDI_MessageObject.getType() != this.m_MIDI_MessageObject_Received.getType()) {
            return;
        }
        if (o_MIDI_MessageObject.getTypeSub() != this.m_MIDI_MessageObject_Received.getTypeSub()) {
            return;
        }
        if (o_MIDI_MessageObject.getTypeSub() == 3) {
            long longMidiTimeTolerance;
            if (!this.m_MIDI_MessageObject_Received.getMidiTimecode().getRunning_Received()) {
                return;
            }
            if (this.m_MIDI_MessageObject_Received.getType() == 1 && !this.m_MIDI_MessageObject_Received.getMidiTimecode().getQuarterReceived_Completed()) {
                return;
            }
            switch (this.m_MIDI_MessageObject_Received.getMidiTimecode().getFrameTypeReceived()) {
                case 0: {
                    longMidiTimeTolerance = 83L;
                    break;
                }
                case 1: {
                    longMidiTimeTolerance = 79L;
                    break;
                }
                case 2: {
                    longMidiTimeTolerance = 66L;
                    break;
                }
                case 4: {
                    longMidiTimeTolerance = 66L;
                    break;
                }
                default: {
                    longMidiTimeTolerance = 0L;
                }
            }
            long longTimeTrigger = o_MIDI_MessageObject.getUseTimecodeManual() ? o_MIDI_MessageObject.getMidiTimecode().getTimeTrigger() : o_MIDI_MessageObject.getMidiTimecode().getTime_ObjectStart();
            if (Math.abs(longTimeTrigger - this.m_MIDI_MessageObject_Received.getMidiTimecode().getTimeReceived_Actual()) < longMidiTimeTolerance) {
                SPITRemote.playClientRemoteSPIT_Object(this.m_SPIT_Client, o_SPIT_Object_Interface);
            }
            return;
        }
        switch (this.m_MIDI_MessageObject_Received.getType()) {
            case 1: {
                if (this.m_MIDI_MessageObject_Received.getShortStatusByte() == 0) {
                    return;
                }
                if (this.m_MIDI_MessageObject_Received.getShortChannel() != o_MIDI_MessageObject.getShortChannel()) {
                    return;
                }
                if (this.m_MIDI_MessageObject_Received.getShortCommandByte() != o_MIDI_MessageObject.getShortCommandByte()) {
                    return;
                }
                if (o_MIDI_MessageObject.getTypeSub() != 3 && this.m_MIDI_MessageObject_Received.getShortData1() != o_MIDI_MessageObject.getShortData1()) {
                    return;
                }
                intValue = this.m_MIDI_MessageObject_Received.getValue();
                intValueMax = this.m_MIDI_MessageObject_Received.getValueMax();
                break;
            }
            case 2: {
                if (this.m_MIDI_MessageObject_Received.getSysexSubID1() == 0) {
                    return;
                }
                if (this.m_MIDI_MessageObject_Received.getSysexManufacturer() != o_MIDI_MessageObject.getSysexManufacturer()) {
                    return;
                }
                if (this.m_MIDI_MessageObject_Received.getSysexDeviceID() != 127 && this.m_MIDI_MessageObject_Received.getSysexDeviceID() != o_MIDI_MessageObject.getSysexDeviceID()) {
                    return;
                }
                if (this.m_MIDI_MessageObject_Received.getSysexSubID1() != o_MIDI_MessageObject.getSysexSubID1()) {
                    return;
                }
                if (this.m_MIDI_MessageObject_Received.getSysexSubID2() != o_MIDI_MessageObject.getSysexSubID2()) {
                    return;
                }
                intValue = this.m_MIDI_MessageObject_Received.getValue();
                intValueMax = this.m_MIDI_MessageObject_Received.getValueMax();
                break;
            }
            default: {
                return;
            }
        }
        intSPITValue = intValueMax > 0 ? (int)((double)intValue / (double)intValueMax * 1000000.0) : 0;
        this.m_LastDeviceReceived = p_MidiDeviceWrapper;
        if (o_SPIT_Object_Interface.getValueUse() == 0) {
            if (o_MIDI_MessageObject.getSPITOperator() == 0) {
                boolTrigger = true;
            } else if (o_MIDI_MessageObject.getSPITOperator() == 1) {
                if (intSPITValue < o_MIDI_MessageObject.getThreshhold()) {
                    boolTrigger = true;
                }
            } else if (o_MIDI_MessageObject.getSPITOperator() == 2) {
                if (intSPITValue <= o_MIDI_MessageObject.getThreshhold()) {
                    boolTrigger = true;
                }
            } else if (o_MIDI_MessageObject.getSPITOperator() == 3) {
                if (intSPITValue > o_MIDI_MessageObject.getThreshhold()) {
                    boolTrigger = true;
                }
            } else if (o_MIDI_MessageObject.getSPITOperator() == 4) {
                if (intSPITValue >= o_MIDI_MessageObject.getThreshhold()) {
                    boolTrigger = true;
                }
            } else if (o_MIDI_MessageObject.getSPITOperator() == 5 && intSPITValue == o_MIDI_MessageObject.getThreshhold()) {
                boolTrigger = true;
            }
            if (boolTrigger) {
                SPITRemote.playClientRemoteSPIT_Object(this.m_SPIT_Client, o_SPIT_Object_Interface);
            }
            return;
        }
        if (o_SPIT_Object_Interface.getValueUse() == 1 || o_SPIT_Object_Interface.getValueUse() == 2) {
            if (intValueMax > 0) {
                if (o_MIDI_MessageObject.getSPITValueUsage() == 0) {
                    SPITRemote.playClientRemoteSPIT_Object(this.m_SPIT_Client, o_SPIT_Object_Interface, intSPITValue);
                } else {
                    if (intValue == 0) {
                        return;
                    }
                    intSPITValue = (int)(o_MIDI_MessageObject.getSPITInDecreasePC() / 100.0f * 1000000.0f);
                    if ((double)intValue / (double)(intValueMax + 1) > 0.5) {
                        SPITRemote.playClientRemoteSPIT_Object(this.m_SPIT_Client, o_SPIT_Object_Interface, intSPITValue, true);
                    } else {
                        SPITRemote.playClientRemoteSPIT_Object(this.m_SPIT_Client, o_SPIT_Object_Interface, intSPITValue, false);
                    }
                }
            }
            return;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof SPIT_Object_Interface) {
            SPIT_Object_Interface o_SPIT_Object_Interface = (SPIT_Object_Interface)evt.getSource();
            if (!"paramchanged".equals(evt.getPropertyName()) && "closed".equals(evt.getPropertyName())) {
                SPITRemote_MidiObject.removeSPITRemote_MidiObject(o_SPIT_Object_Interface);
                this.close();
            }
        }
    }

    @Override
    public void eventSPIT_Object_Added(SPIT_Object_Interface p_SPIT_Object_Interface) {
    }

    @Override
    public void eventSPIT_Object_Changed(SPIT_Object_Interface p_SPIT_Object_Interface) {
    }

    @Override
    public void eventSPIT_Object_Removed(SPIT_Object_Interface p_SPIT_Object_Interface) {
    }

    @Override
    public void eventRemoteSPIT_Object_Added(SPIT_Object_Interface p_SPIT_Object_Interface) {
    }

    @Override
    public void eventRemoteSPIT_Object_Changed(SPIT_Object_Interface p_SPIT_Object_Interface) {
        if (p_SPIT_Object_Interface == null) {
            return;
        }
        if (p_SPIT_Object_Interface != this.m_SPIT_Object_Interface) {
            return;
        }
        MIDI_MessageObject o_MIDI_MessageObject = this.m_MIDI_MessageObject;
        if (o_MIDI_MessageObject == null) {
            return;
        }
        SPIT_Object_Interface o_SPIT_Object_Interface = this.m_SPIT_Object_Interface;
        if (o_SPIT_Object_Interface == null) {
            return;
        }
        SPIT_ClientInterface o_SPIT_Client = this.m_SPIT_Client;
        if (o_SPIT_Client == null) {
            return;
        }
        long longStartTime = (long)(1000.0 * (double)p_SPIT_Object_Interface.getFrameStart() / (double)o_SPIT_Client.getServerFramesPerSecond());
        o_MIDI_MessageObject.setMidiTimecode_ObjectStart(longStartTime);
        if (o_SPIT_Object_Interface.getValueUse() != 0) {
            return;
        }
        if (o_MIDI_MessageObject.getValueMax() > 0) {
            int intPlayValue = p_SPIT_Object_Interface.getSPIT_ActionStatus().getPlayValue();
            int intValueToSend = (int)((double)intPlayValue / 1000000.0 * (double)o_MIDI_MessageObject.getValueMax());
            o_MIDI_MessageObject.setValueToSend(intValueToSend);
            MIDI_Devices.sendMidiMessage_Remote(o_MIDI_MessageObject, this.m_LastDeviceReceived);
            this.m_LastDeviceReceived = null;
        }
        this.notifyChanged();
    }

    @Override
    public void eventRemoteSPIT_Object_Removed(SPIT_Object_Interface p_SPIT_Object_Interface) {
    }

    public void setMidiObjectPosition(int p_Position) {
    }

    @Override
    public boolean isSet() {
        MIDI_MessageObject o_MIDI_MessageObject = this.m_MIDI_MessageObject;
        if (o_MIDI_MessageObject == null) {
            return false;
        }
        return o_MIDI_MessageObject.isSet();
    }
}

