/*
 * Decompiled with CFR 0.152.
 */
package MIDIPackage;

import MIDIPackage.MIDI_Devices;
import MIDIPackage.MIDI_MessageObject;
import MIDIPackage.MidiDeviceWrapper;
import MIDIPackage.MidiMessageListener;
import MidiHardwarePackage.MidiCommDeviceInterface;
import MidiHardwarePackage.MidiCommDeviceListener;
import SwingModelPackage.SinglePropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.UUID;

public class MidiDevice_Comm
implements MidiDeviceWrapper,
MidiCommDeviceListener {
    private String m_ID;
    private MidiCommDeviceInterface m_MidiCommDeviceInterface;
    private boolean m_Selected;
    private int m_DeviceType;
    private MidiMessageListener m_MidiMessageListener;
    private SinglePropertyChangeSupport m_SinglePropertyChangeSupport;
    private final Object m_SyncListeners = new Object();

    public MidiDevice_Comm(MidiCommDeviceInterface p_MidiCommDeviceInterface, int p_DeviceType) {
        this.initMembers();
        this.m_MidiCommDeviceInterface = p_MidiCommDeviceInterface;
        this.m_ID = p_MidiCommDeviceInterface.getID();
        this.m_MidiCommDeviceInterface.addMidiCommDeviceListener((MidiCommDeviceListener)this);
        this.m_DeviceType = p_DeviceType;
    }

    private void initMembers() {
        this.m_ID = UUID.randomUUID().toString();
        this.m_MidiCommDeviceInterface = null;
        this.m_Selected = false;
        this.m_DeviceType = 0;
        this.m_MidiMessageListener = null;
        this.m_SinglePropertyChangeSupport = new SinglePropertyChangeSupport((Object)this);
    }

    public void close() {
        this.m_SinglePropertyChangeSupport.firePropertyChange("propertyclosed", null, (Object)this);
        MidiCommDeviceInterface o_MidiCommDeviceInterface = this.m_MidiCommDeviceInterface;
        if (o_MidiCommDeviceInterface != null) {
            o_MidiCommDeviceInterface.removeMidiCommDeviceListener((MidiCommDeviceListener)this);
            o_MidiCommDeviceInterface.close();
            this.m_MidiCommDeviceInterface = null;
        }
    }

    public void connect(String p_ConnectionParam) {
        MidiCommDeviceInterface o_MidiCommDeviceInterface = this.m_MidiCommDeviceInterface;
        if (o_MidiCommDeviceInterface == null) {
            return;
        }
        o_MidiCommDeviceInterface.connect(p_ConnectionParam);
    }

    public String getID() {
        return this.m_ID;
    }

    public void setID(String p_ID) {
        if (p_ID == null) {
            return;
        }
        this.m_ID = p_ID;
    }

    public MidiCommDeviceInterface getMidiCommDeviceInterface() {
        return this.m_MidiCommDeviceInterface;
    }

    public String getInterfaceName() {
        MidiCommDeviceInterface o_MidiCommDeviceInterface = this.m_MidiCommDeviceInterface;
        if (o_MidiCommDeviceInterface == null) {
            return "";
        }
        return o_MidiCommDeviceInterface.getInterfaceName();
    }

    public String getManufacturerName() {
        MidiCommDeviceInterface o_MidiCommDeviceInterface = this.m_MidiCommDeviceInterface;
        if (o_MidiCommDeviceInterface == null) {
            return "";
        }
        return o_MidiCommDeviceInterface.getManufacturerName();
    }

    public String getDescription() {
        MidiCommDeviceInterface o_MidiCommDeviceInterface = this.m_MidiCommDeviceInterface;
        if (o_MidiCommDeviceInterface == null) {
            return "";
        }
        return o_MidiCommDeviceInterface.getMidiInterfaceDescription();
    }

    public void setDeviceType(int p_DeviceType) {
        this.m_DeviceType = p_DeviceType;
    }

    public int getDeviceType() {
        return this.m_DeviceType;
    }

    public boolean getSelected() {
        return this.m_Selected;
    }

    public void setSelected(boolean p_Selected) {
        this.m_Selected = p_Selected;
        if (this.m_DeviceType == 0 || this.m_DeviceType == 2) {
            if (this.m_Selected) {
                MIDI_Devices.s_SPIType_MidiDevices_TableModel.addMIDIDevice(this);
            } else {
                MIDI_Devices.s_SPIType_MidiDevices_TableModel.removeMIDIDevice(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        Object object = this.m_SyncListeners;
        synchronized (object) {
            this.m_SinglePropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        Object object = this.m_SyncListeners;
        synchronized (object) {
            this.m_SinglePropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
        }
    }

    public Object getMidiDevice() {
        return null;
    }

    public void setMidiMessageListener(MidiMessageListener p_MessageListener) {
        this.m_MidiMessageListener = p_MessageListener;
    }

    public void send(MIDI_MessageObject p_MIDI_MessageObject, long p_TimeStamp) {
        MidiCommDeviceInterface o_MidiCommDeviceInterface = this.m_MidiCommDeviceInterface;
        if (o_MidiCommDeviceInterface == null) {
            return;
        }
        MIDI_MessageObject o_MIDI_MessageObject = MidiDevice_Comm.checkMidi_MessageObject(p_MIDI_MessageObject);
        if (o_MIDI_MessageObject == null) {
            return;
        }
        o_MidiCommDeviceInterface.send(o_MIDI_MessageObject.getMessageBytesToSend());
    }

    private static MIDI_MessageObject checkMidi_MessageObject(MIDI_MessageObject p_MIDI_MessageObject) {
        if (p_MIDI_MessageObject == null) {
            return null;
        }
        try {
            switch (p_MIDI_MessageObject.getType()) {
                case 1: {
                    if (p_MIDI_MessageObject.getShortStatusByte() == 0) {
                        return null;
                    }
                    break;
                }
                case 2: {
                    if (p_MIDI_MessageObject.getSysexManufacturer() == 0) {
                        return null;
                    }
                    byte[] o_DataBytes = p_MIDI_MessageObject.getMessageBytesToSend();
                    if (o_DataBytes == null || o_DataBytes.length <= 0) {
                        return null;
                    }
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        catch (Exception e) {
            System.out.println("MidiDevices sendMidiMessage Error: " + e.toString());
            return null;
        }
        return p_MIDI_MessageObject;
    }

    public boolean isRemovable() {
        return true;
    }

    public boolean hasProperties() {
        return true;
    }

    public void showPropertyDialog() {
        MidiCommDeviceInterface o_MidiCommDeviceInterface = this.m_MidiCommDeviceInterface;
        if (o_MidiCommDeviceInterface == null) {
            return;
        }
        o_MidiCommDeviceInterface.showConfigurationDialog(null);
    }

    public void eventMidiMessageReceived(MidiCommDeviceInterface p_MidiCommDeviceInterface, byte[] p_MIDIDMessageBytes) {
        MidiMessageListener o_MidiMessageListener = this.m_MidiMessageListener;
        if (o_MidiMessageListener == null) {
            return;
        }
        o_MidiMessageListener.eventMidiMessageReceived((MidiDeviceWrapper)this, p_MIDIDMessageBytes);
    }

    public void eventMidiConnectionStatus(MidiCommDeviceInterface p_MidiCommDeviceInterface, boolean p_IsConnected) {
        this.m_SinglePropertyChangeSupport.firePropertyChange("propertyconnection", !p_IsConnected, p_IsConnected);
    }

    public boolean getIsConnected() {
        MidiCommDeviceInterface o_MidiCommDeviceInterface = this.m_MidiCommDeviceInterface;
        if (o_MidiCommDeviceInterface == null) {
            return false;
        }
        return o_MidiCommDeviceInterface.getIsConnected();
    }

    public void eventMidiCommDeviceInterfaceClosed(MidiCommDeviceInterface p_MidiCommDeviceInterface) {
        this.close();
    }
}

