/*
 * Decompiled with CFR 0.152.
 */
package MIDIPackage;

import MIDIPackage.MIDI_MessageObject;
import MIDIPackage.MidiCommDeviceType;
import MIDIPackage.MidiDeviceWrapper;
import MIDIPackage.MidiDevice_Comm;
import MIDIPackage.MidiDevice_Midi;
import MIDIPackage.MidiMessageListener;
import MIDIPackage.MidiMessageSender;
import MIDIPackage.MidiTimecode;
import MIDIPackage.MidiTimecodeGenerator;
import MIDIPackage.SPITTrigger_MidiObject;
import MidiHardwarePackage.MidiCommDeviceInterface;
import SPITClientGUI.MidiDevices_TableModel;
import SPITClientGUI.SPITType_MidiDevices_TableModel;
import ToolsPackage.EventQueueHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.sound.midi.Receiver;

public class MIDI_Devices {
    public static final int SOFTWAREVERSION = 1;
    public static MidiDevices_TableModel s_MidiDeviceWrapper_TableModel_Trigger = new MidiDevices_TableModel();
    public static MidiDevices_TableModel s_MidiDeviceWrapper_TableModel_Remote = new MidiDevices_TableModel();
    public static SPITType_MidiDevices_TableModel s_SPIType_MidiDevices_TableModel = new SPITType_MidiDevices_TableModel();
    public static ArrayList<Receiver> s_OutputReceivers = new ArrayList();
    public static ArrayList<MidiMessageListener> s_MessageListeners = new ArrayList();
    public static ArrayList<MidiTimecode.ReceiverListener> s_TimecodeReceiverListeners = new ArrayList();
    public static final Object s_SyncMidiDevices = new Object();
    public static final Object s_SyncMessageListener = new Object();
    public static final Object s_SyncMessageEvent = new Object();
    public static ArrayList<String> s_SelectedDeviceIDs_Remote = new ArrayList();
    public static ArrayList<String> s_SelectedDeviceIDs_Trigger = new ArrayList();
    public static MIDI_MessageObject s_Message_Received = new MIDI_MessageObject();
    public static MidiMessageListener s_MessageListener = new MidiMessageListener(){

        public void eventMidiMessageReceived(MidiDeviceWrapper p_MidiDeviceWrapper, byte[] p_MidiMessageBytes) {
            MIDI_Devices.notifyMidiMessageReceived(p_MidiDeviceWrapper, p_MidiMessageBytes);
        }

        public void eventMidiMessageReceived(MidiDeviceWrapper p_MidiDeviceWrapper, MIDI_MessageObject p_MIDI_MessageObject) {
        }
    };
    public static MidiMessageSender s_MessageSender = new MidiMessageSender(){

        public void sendMidiMessage_Trigger(MIDI_MessageObject p_MIDI_MessageObject, MidiMessageSender.MidiMessageDeviceContainer p_MidiMessageDeviceContainer) {
            MIDI_Devices.sendMidiMessage_Trigger(p_MIDI_MessageObject, p_MidiMessageDeviceContainer);
        }

        public void sendMidiMessage_Remote(MIDI_MessageObject p_MIDI_MessageObject, MidiDeviceWrapper p_ExludeLastReceivedDevice) {
            MIDI_Devices.sendMidiMessage_Remote(p_MIDI_MessageObject, p_ExludeLastReceivedDevice);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAll() {
        MidiDeviceWrapper o_MidiDeviceWrapper;
        int intMidiDevice;
        MidiDevice_Midi.closeAll();
        Object object = s_SyncMidiDevices;
        synchronized (object) {
            for (intMidiDevice = s_MidiDeviceWrapper_TableModel_Trigger.size() - 1; intMidiDevice >= 0; --intMidiDevice) {
                o_MidiDeviceWrapper = s_MidiDeviceWrapper_TableModel_Trigger.getMIDIDevice(intMidiDevice);
                if (o_MidiDeviceWrapper == null) continue;
                o_MidiDeviceWrapper.close();
            }
        }
        object = s_SyncMidiDevices;
        synchronized (object) {
            for (intMidiDevice = s_MidiDeviceWrapper_TableModel_Remote.size() - 1; intMidiDevice >= 0; --intMidiDevice) {
                o_MidiDeviceWrapper = s_MidiDeviceWrapper_TableModel_Remote.getMIDIDevice(intMidiDevice);
                if (o_MidiDeviceWrapper == null) continue;
                o_MidiDeviceWrapper.close();
            }
        }
    }

    public static void addMidiDeviceWrapper_Trigger(final MidiDeviceWrapper p_MidiDeviceWrapper) {
        if (p_MidiDeviceWrapper == null) {
            return;
        }
        EventQueueHandler.invokeLater(new Runnable(){

            @Override
            public void run() {
                s_MidiDeviceWrapper_TableModel_Trigger.addMIDIDevice(p_MidiDeviceWrapper);
            }
        });
    }

    public static void removeMidiDeviceWrapper_Trigger(final MidiDeviceWrapper p_MidiDeviceWrapper) {
        if (p_MidiDeviceWrapper == null) {
            return;
        }
        EventQueueHandler.invokeLater(new Runnable(){

            @Override
            public void run() {
                s_MidiDeviceWrapper_TableModel_Trigger.removeMIDIDevice(p_MidiDeviceWrapper);
            }
        });
    }

    public static void addMidiDeviceWrapper_Remote(final MidiDeviceWrapper p_MidiDeviceWrapper) {
        if (p_MidiDeviceWrapper == null) {
            return;
        }
        EventQueueHandler.invokeLater(new Runnable(){

            @Override
            public void run() {
                p_MidiDeviceWrapper.setMidiMessageListener(s_MessageListener);
                s_MidiDeviceWrapper_TableModel_Remote.addMIDIDevice(p_MidiDeviceWrapper);
            }
        });
    }

    public static void removeMidiDeviceWrapper_Remote(final MidiDeviceWrapper p_MidiDeviceWrapper) {
        if (p_MidiDeviceWrapper == null) {
            return;
        }
        EventQueueHandler.invokeLater(new Runnable(){

            @Override
            public void run() {
                p_MidiDeviceWrapper.setMidiMessageListener(null);
                s_MidiDeviceWrapper_TableModel_Remote.removeMIDIDevice(p_MidiDeviceWrapper);
            }
        });
    }

    public static ArrayList<MidiDeviceWrapper> getMidiDeviceWrappers_Trigger() {
        return s_MidiDeviceWrapper_TableModel_Trigger.getMIDIDevices();
    }

    public static MidiDeviceWrapper getMIDIDevice_Trigger(Object p_MidiDevice) {
        return s_MidiDeviceWrapper_TableModel_Trigger.getMIDIDevice(p_MidiDevice);
    }

    public static MidiDeviceWrapper getMidiDeviceWrapper_Trigger(String p_DeviceID) {
        return s_MidiDeviceWrapper_TableModel_Trigger.getMIDIDevice(p_DeviceID);
    }

    public static MidiDeviceWrapper getMidiDeviceWrapper_Trigger(String p_Name, String p_ManufacturerName, String p_Description) {
        return s_MidiDeviceWrapper_TableModel_Trigger.getMIDIDevice(p_Name, p_ManufacturerName, p_Description);
    }

    public static ArrayList<MidiDeviceWrapper> getMidiDeviceWrappers_Remote() {
        return s_MidiDeviceWrapper_TableModel_Remote.getMIDIDevices();
    }

    public static MidiDeviceWrapper getMIDIDevice_Remote(Object p_MidiDevice) {
        return s_MidiDeviceWrapper_TableModel_Remote.getMIDIDevice(p_MidiDevice);
    }

    public static MidiDeviceWrapper getMidiDeviceWrapper_Remote(String p_DeviceID) {
        return s_MidiDeviceWrapper_TableModel_Remote.getMIDIDevice(p_DeviceID);
    }

    public static void checkConnectInfoID_Trigger(MidiDeviceWrapper o_MidiDeviceWrapper) {
        MIDI_Devices.checkConnectInfoID(o_MidiDeviceWrapper, s_SelectedDeviceIDs_Trigger);
    }

    public static void checkConnectInfoID_Remote(MidiDeviceWrapper o_MidiDeviceWrapper) {
        MIDI_Devices.checkConnectInfoID(o_MidiDeviceWrapper, s_SelectedDeviceIDs_Remote);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deselectedAll() {
        MidiDeviceWrapper o_MidiDeviceWrapper;
        int intMidiDevice;
        Object object = s_SyncMidiDevices;
        synchronized (object) {
            for (intMidiDevice = s_MidiDeviceWrapper_TableModel_Trigger.size() - 1; intMidiDevice >= 0; --intMidiDevice) {
                o_MidiDeviceWrapper = s_MidiDeviceWrapper_TableModel_Trigger.getMIDIDevice(intMidiDevice);
                if (o_MidiDeviceWrapper == null) continue;
                o_MidiDeviceWrapper.setSelected(false);
            }
        }
        object = s_SyncMidiDevices;
        synchronized (object) {
            for (intMidiDevice = s_MidiDeviceWrapper_TableModel_Remote.size() - 1; intMidiDevice >= 0; --intMidiDevice) {
                o_MidiDeviceWrapper = s_MidiDeviceWrapper_TableModel_Remote.getMIDIDevice(intMidiDevice);
                if (o_MidiDeviceWrapper == null) continue;
                o_MidiDeviceWrapper.setSelected(false);
            }
        }
    }

    public static void setSelectedDeviceID_Trigger(MidiDeviceWrapper p_MidiDeviceWrapper, boolean p_Selected) {
        if (p_MidiDeviceWrapper == null) {
            return;
        }
        String stringDeviceID = p_MidiDeviceWrapper.getID();
        if (p_Selected) {
            if (s_SelectedDeviceIDs_Trigger.contains(stringDeviceID)) {
                return;
            }
            s_SelectedDeviceIDs_Trigger.add(stringDeviceID);
        } else {
            s_SelectedDeviceIDs_Trigger.remove(stringDeviceID);
        }
    }

    public static void setSelectedDeviceID_Remote(MidiDeviceWrapper p_MidiDeviceWrapper, boolean p_Selected) {
        if (p_MidiDeviceWrapper == null) {
            return;
        }
        String stringDeviceID = p_MidiDeviceWrapper.getID();
        if (p_Selected) {
            if (s_SelectedDeviceIDs_Remote.contains(stringDeviceID)) {
                return;
            }
            s_SelectedDeviceIDs_Remote.add(stringDeviceID);
        } else {
            s_SelectedDeviceIDs_Remote.remove(stringDeviceID);
        }
    }

    public static void checkConnectInfoID(MidiDeviceWrapper p_MidiDeviceWrapper, ArrayList<String> p_LoadedInfoIDs) {
        if (p_MidiDeviceWrapper == null) {
            return;
        }
        if (p_LoadedInfoIDs == null) {
            return;
        }
        String stringID = p_MidiDeviceWrapper.getID();
        for (int intInfo = p_LoadedInfoIDs.size() - 1; intInfo >= 0; --intInfo) {
            String stringLoadedID = p_LoadedInfoIDs.get(intInfo);
            if (!stringID.equals(stringLoadedID) || p_MidiDeviceWrapper.getSelected()) continue;
            try {
                p_MidiDeviceWrapper.setSelected(true);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void writeExternal(ObjectOutput out) throws IOException {
        int intInfo;
        MidiCommDeviceInterface o_MidiCommDeviceInterface;
        MidiDevice_Comm o_MidiDevice_Comm;
        MidiDeviceWrapper o_MidiDeviceWrapper;
        int intDevice;
        MidiTimecodeGenerator.LoopbackDevice o_LoopbackDevice = null;
        boolean boolLoopbackSelected = false;
        ArrayList<MidiCommDeviceInterface> o_MidiCommDeviceInterfaces = new ArrayList<MidiCommDeviceInterface>();
        ArrayList<Boolean> o_MidiCommDeviceSelected_Remote = new ArrayList<Boolean>();
        ArrayList<Boolean> o_MidiCommDeviceSelected_Trigger = new ArrayList<Boolean>();
        ArrayList<MidiDevice_Midi> o_MidiDevices_Midi_Remote = new ArrayList<MidiDevice_Midi>();
        for (intDevice = 0; intDevice < s_MidiDeviceWrapper_TableModel_Remote.size(); ++intDevice) {
            o_MidiDeviceWrapper = s_MidiDeviceWrapper_TableModel_Remote.getMIDIDevice(intDevice);
            if (o_MidiDeviceWrapper == null) continue;
            if (o_MidiDeviceWrapper instanceof MidiDevice_Comm) {
                o_MidiDevice_Comm = (MidiDevice_Comm)o_MidiDeviceWrapper;
                o_MidiCommDeviceInterface = o_MidiDevice_Comm.getMidiCommDeviceInterface();
                o_MidiCommDeviceInterfaces.add(o_MidiCommDeviceInterface);
                if (o_MidiDeviceWrapper.getSelected()) {
                    o_MidiCommDeviceSelected_Remote.add(Boolean.TRUE);
                    continue;
                }
                o_MidiCommDeviceSelected_Remote.add(Boolean.FALSE);
                continue;
            }
            if (o_MidiDeviceWrapper instanceof MidiTimecodeGenerator.LoopbackDevice) {
                o_LoopbackDevice = (MidiTimecodeGenerator.LoopbackDevice)o_MidiDeviceWrapper;
                boolLoopbackSelected = o_MidiDeviceWrapper.getSelected();
            }
            if (!o_MidiDeviceWrapper.getSelected() || !(o_MidiDeviceWrapper instanceof MidiDevice_Midi)) continue;
            o_MidiDevices_Midi_Remote.add((MidiDevice_Midi)o_MidiDeviceWrapper);
        }
        ArrayList<MidiDevice_Midi> o_MidiDevices_Midi_Trigger = new ArrayList<MidiDevice_Midi>();
        for (intDevice = 0; intDevice < s_MidiDeviceWrapper_TableModel_Trigger.size(); ++intDevice) {
            o_MidiDeviceWrapper = s_MidiDeviceWrapper_TableModel_Trigger.getMIDIDevice(intDevice);
            if (o_MidiDeviceWrapper == null) continue;
            if (o_MidiDeviceWrapper instanceof MidiDevice_Comm) {
                o_MidiDevice_Comm = (MidiDevice_Comm)o_MidiDeviceWrapper;
                o_MidiCommDeviceInterface = o_MidiDevice_Comm.getMidiCommDeviceInterface();
                if (!o_MidiCommDeviceInterfaces.contains(o_MidiCommDeviceInterface)) {
                    o_MidiCommDeviceInterfaces.add(o_MidiCommDeviceInterface);
                }
                if (o_MidiDeviceWrapper.getSelected()) {
                    o_MidiCommDeviceSelected_Trigger.add(Boolean.TRUE);
                    continue;
                }
                o_MidiCommDeviceSelected_Trigger.add(Boolean.FALSE);
                continue;
            }
            if (!o_MidiDeviceWrapper.getSelected() || !(o_MidiDeviceWrapper instanceof MidiDevice_Midi)) continue;
            o_MidiDevices_Midi_Trigger.add((MidiDevice_Midi)o_MidiDeviceWrapper);
        }
        out.writeInt(1);
        out.writeInt(s_SelectedDeviceIDs_Remote.size());
        for (intInfo = 0; intInfo < s_SelectedDeviceIDs_Remote.size(); ++intInfo) {
            out.writeUTF(s_SelectedDeviceIDs_Remote.get(intInfo));
        }
        out.writeInt(s_SelectedDeviceIDs_Trigger.size());
        for (intInfo = 0; intInfo < s_SelectedDeviceIDs_Trigger.size(); ++intInfo) {
            out.writeUTF(s_SelectedDeviceIDs_Trigger.get(intInfo));
        }
        out.writeInt(o_MidiCommDeviceInterfaces.size());
        for (int intInterface = 0; intInterface < o_MidiCommDeviceInterfaces.size(); ++intInterface) {
            o_MidiCommDeviceInterface = (MidiCommDeviceInterface)o_MidiCommDeviceInterfaces.get(intInterface);
            String stringID = o_MidiCommDeviceInterface.getID();
            String stringClassPath = o_MidiCommDeviceInterface.getClass().getName();
            boolean boolIsConnected = o_MidiCommDeviceInterface.getIsConnected();
            String stringConnectionParameters = o_MidiCommDeviceInterface.getConnectionParameters();
            boolean boolSelected_Remote = (Boolean)o_MidiCommDeviceSelected_Remote.get(intInterface);
            boolean boolSelected_Trigger = (Boolean)o_MidiCommDeviceSelected_Trigger.get(intInterface);
            out.writeUTF(stringID);
            out.writeUTF(stringClassPath);
            out.writeBoolean(boolIsConnected);
            out.writeUTF(stringConnectionParameters);
            out.writeBoolean(boolSelected_Remote);
            out.writeBoolean(boolSelected_Trigger);
            ByteArrayOutputStream o_ByteBuffer = new ByteArrayOutputStream();
            o_ByteBuffer.reset();
            ObjectOutputStream o_AdditionalOutput = new ObjectOutputStream(o_ByteBuffer);
            o_MidiCommDeviceInterface.writeExternal((ObjectOutput)o_AdditionalOutput);
            o_AdditionalOutput.flush();
            o_ByteBuffer.flush();
            int intByteBufferSize = o_ByteBuffer.size();
            out.writeInt(intByteBufferSize);
            out.write(o_ByteBuffer.toByteArray());
            o_AdditionalOutput.close();
            o_ByteBuffer.close();
        }
        if (o_LoopbackDevice == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
        }
        out.writeBoolean(boolLoopbackSelected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readExternal(ObjectInput in) throws IOException {
        int intSoftwareVersion = in.readInt();
        int intDeviceCount = 0;
        Object object = s_SyncMidiDevices;
        synchronized (object) {
            String stringInfoID;
            int intInfo;
            s_SelectedDeviceIDs_Remote.clear();
            s_SelectedDeviceIDs_Trigger.clear();
            intDeviceCount = in.readInt();
            for (intInfo = 0; intInfo < intDeviceCount; ++intInfo) {
                stringInfoID = in.readUTF();
                s_SelectedDeviceIDs_Remote.add(stringInfoID);
            }
            intDeviceCount = in.readInt();
            for (intInfo = 0; intInfo < intDeviceCount; ++intInfo) {
                stringInfoID = in.readUTF();
                s_SelectedDeviceIDs_Trigger.add(stringInfoID);
            }
            boolean boolWasConnected = false;
            intDeviceCount = in.readInt();
            for (int intInterface = 0; intInterface < intDeviceCount; ++intInterface) {
                String stringID = in.readUTF();
                String stringClassPath = in.readUTF();
                boolWasConnected = in.readBoolean();
                String stringConnectionParameters = in.readUTF();
                boolean boolSelected_Remote = in.readBoolean();
                boolean boolSelected_Trigger = in.readBoolean();
                MidiCommDeviceType o_MidiCommDeviceType = MidiCommDeviceType.getDMXHardwareType((String)stringClassPath);
                if (o_MidiCommDeviceType == null) continue;
                MidiCommDeviceInterface o_MidiCommDeviceInterface = o_MidiCommDeviceType.getNewInstanceOfHardwareInterface();
                int longByteCountHardware = in.readInt();
                if (longByteCountHardware > 0) {
                    if (o_MidiCommDeviceInterface != null) {
                        byte[] o_ArrayByte = new byte[longByteCountHardware];
                        in.readFully(o_ArrayByte);
                        ByteArrayInputStream o_ByteArrayInputStream = new ByteArrayInputStream(o_ArrayByte);
                        ObjectInputStream o_AdditionalInput = new ObjectInputStream(o_ByteArrayInputStream);
                        try {
                            o_MidiCommDeviceInterface.readExternal((ObjectInput)o_AdditionalInput);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        o_AdditionalInput.close();
                        o_ByteArrayInputStream.close();
                    } else {
                        in.skip(longByteCountHardware);
                    }
                }
                if (o_MidiCommDeviceInterface == null) continue;
                o_MidiCommDeviceInterface.setID(stringID);
                MidiDevice_Comm o_MidiDevice_Comm = new MidiDevice_Comm(o_MidiCommDeviceInterface, 1);
                MIDI_Devices.addMidiDeviceWrapper_Remote(o_MidiDevice_Comm);
                o_MidiDevice_Comm.setSelected(boolSelected_Remote);
                o_MidiDevice_Comm = new MidiDevice_Comm(o_MidiCommDeviceInterface, 0);
                MIDI_Devices.addMidiDeviceWrapper_Trigger(o_MidiDevice_Comm);
                o_MidiDevice_Comm.setSelected(boolSelected_Trigger);
                if (!boolWasConnected) continue;
                o_MidiCommDeviceInterface.connect(stringConnectionParameters);
                o_MidiCommDeviceInterface.requestCheckHardware();
            }
            int intCountLoppbackDevices = 0;
            intCountLoppbackDevices = in.readInt();
            boolean boolLoopbackSelected = in.readBoolean();
            if (intCountLoppbackDevices > 0) {
                MidiTimecodeGenerator.LoopbackDevice o_LoopbackDevice = SPITTrigger_MidiObject.s_MidiTimecodeGenerator.createLoopbackDevice();
                MIDI_Devices.addMidiDeviceWrapper_Remote((MidiDeviceWrapper)o_LoopbackDevice);
                o_LoopbackDevice.setSelected(boolLoopbackSelected);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkLoaded() {
        Object object = s_SyncMidiDevices;
        synchronized (object) {
            MidiDeviceWrapper o_MidiDeviceWrapper;
            int intDevice;
            ArrayList<String> o_LoadedIDs;
            if (s_SelectedDeviceIDs_Remote.size() > 0) {
                o_LoadedIDs = new ArrayList<String>(s_SelectedDeviceIDs_Remote.size());
                o_LoadedIDs.addAll(s_SelectedDeviceIDs_Remote);
                for (intDevice = 0; intDevice < s_MidiDeviceWrapper_TableModel_Remote.size(); ++intDevice) {
                    o_MidiDeviceWrapper = s_MidiDeviceWrapper_TableModel_Remote.getMIDIDevice(intDevice);
                    if (o_MidiDeviceWrapper == null) continue;
                    MIDI_Devices.checkConnectInfoID(o_MidiDeviceWrapper, o_LoadedIDs);
                }
            }
            if (s_SelectedDeviceIDs_Trigger.size() > 0) {
                o_LoadedIDs = new ArrayList(s_SelectedDeviceIDs_Trigger.size());
                o_LoadedIDs.addAll(s_SelectedDeviceIDs_Trigger);
                for (intDevice = 0; intDevice < s_MidiDeviceWrapper_TableModel_Trigger.size(); ++intDevice) {
                    o_MidiDeviceWrapper = s_MidiDeviceWrapper_TableModel_Trigger.getMIDIDevice(intDevice);
                    if (o_MidiDeviceWrapper == null) continue;
                    MIDI_Devices.checkConnectInfoID(o_MidiDeviceWrapper, o_LoadedIDs);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendMidiMessage_Remote(MIDI_MessageObject p_MIDI_MessageObject, MidiDeviceWrapper p_ExludeLastReceivedDevice) {
        if (p_MIDI_MessageObject == null) {
            return;
        }
        Object object = s_SyncMidiDevices;
        synchronized (object) {
            for (int intReceiver = 0; intReceiver < s_MidiDeviceWrapper_TableModel_Remote.size(); ++intReceiver) {
                MidiDeviceWrapper o_MidiDeviceWrapper = s_MidiDeviceWrapper_TableModel_Remote.getMIDIDevice(intReceiver);
                if (o_MidiDeviceWrapper == null || p_ExludeLastReceivedDevice == o_MidiDeviceWrapper) continue;
                o_MidiDeviceWrapper.send(p_MIDI_MessageObject, -1L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendMidiMessage_Trigger(MIDI_MessageObject p_MIDI_MessageObject, MidiMessageSender.MidiMessageDeviceContainer p_MidiMessageDeviceContainer) {
        if (p_MIDI_MessageObject == null) {
            return;
        }
        if (p_MidiMessageDeviceContainer == null) {
            MIDI_Devices.sendMidiMessage_Trigger(p_MIDI_MessageObject);
            return;
        }
        Object object = s_SyncMidiDevices;
        synchronized (object) {
            for (int intReceiver = 0; intReceiver < p_MidiMessageDeviceContainer.getMidiDeviceCount(); ++intReceiver) {
                MidiDeviceWrapper o_MidiDeviceWrapper;
                String stringMidiDeviceID = p_MidiMessageDeviceContainer.getMidiDeviceID(intReceiver);
                if (stringMidiDeviceID == null || (o_MidiDeviceWrapper = s_MidiDeviceWrapper_TableModel_Trigger.getMIDIDevice(stringMidiDeviceID)) == null || !o_MidiDeviceWrapper.getSelected()) continue;
                o_MidiDeviceWrapper.send(p_MIDI_MessageObject, -1L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendMidiMessage_Trigger(MIDI_MessageObject p_MIDI_MessageObject) {
        if (p_MIDI_MessageObject == null) {
            return;
        }
        Object object = s_SyncMidiDevices;
        synchronized (object) {
            for (int intReceiver = 0; intReceiver < s_MidiDeviceWrapper_TableModel_Trigger.size(); ++intReceiver) {
                MidiDeviceWrapper o_MidiDeviceWrapper = s_MidiDeviceWrapper_TableModel_Trigger.getMIDIDevice(intReceiver);
                if (o_MidiDeviceWrapper == null || !o_MidiDeviceWrapper.getSelected()) continue;
                o_MidiDeviceWrapper.send(p_MIDI_MessageObject, -1L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMidiMessageListener(MidiMessageListener p_MidiMessageListener) {
        if (p_MidiMessageListener == null) {
            return;
        }
        Object object = s_SyncMessageListener;
        synchronized (object) {
            if (s_MessageListeners.contains(p_MidiMessageListener)) {
                return;
            }
            s_MessageListeners.add(p_MidiMessageListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeMidiMessageListener(MidiMessageListener p_MidiMessageListener) {
        if (p_MidiMessageListener == null) {
            return;
        }
        Object object = s_SyncMessageListener;
        synchronized (object) {
            s_MessageListeners.remove(p_MidiMessageListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMidiTimecodeReceiverListener(MidiTimecode.ReceiverListener p_ReceiverListener) {
        if (p_ReceiverListener == null) {
            return;
        }
        Object object = s_SyncMessageListener;
        synchronized (object) {
            if (s_TimecodeReceiverListeners.contains(p_ReceiverListener)) {
                return;
            }
            s_TimecodeReceiverListeners.add(p_ReceiverListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeMidiTimecodeReceiverListener(MidiTimecode.ReceiverListener p_ReceiverListener) {
        if (p_ReceiverListener == null) {
            return;
        }
        Object object = s_SyncMessageListener;
        synchronized (object) {
            s_TimecodeReceiverListeners.remove(p_ReceiverListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyMidiMessageReceived(MidiDeviceWrapper p_MidiDeviceWrapper, byte[] p_MidiMessageBytes) {
        ArrayList<MidiTimecode.ReceiverListener> o_TimecodeReceiverListeners;
        ArrayList<MidiMessageListener> o_MessageListeners;
        if (p_MidiMessageBytes == null) {
            return;
        }
        Object object = s_SyncMessageListener;
        synchronized (object) {
            if (s_MessageListeners.size() <= 0) {
                return;
            }
            o_MessageListeners = new ArrayList<MidiMessageListener>(s_MessageListeners.size());
            o_MessageListeners.addAll(s_MessageListeners);
            o_TimecodeReceiverListeners = new ArrayList<MidiTimecode.ReceiverListener>(s_TimecodeReceiverListeners.size());
            o_TimecodeReceiverListeners.addAll(s_TimecodeReceiverListeners);
        }
        object = s_SyncMessageEvent;
        synchronized (object) {
            s_Message_Received.setMessageBytes(p_MidiMessageBytes);
            if (s_Message_Received.getTypeSub() == 3) {
                long longMilliseconds = s_Message_Received.getMidiTimecode().getTimeReceived_Actual();
                for (int intListener = 0; intListener < o_TimecodeReceiverListeners.size(); ++intListener) {
                    MidiTimecode.ReceiverListener o_TimecodeReceiverListener = (MidiTimecode.ReceiverListener)o_TimecodeReceiverListeners.get(intListener);
                    if (o_TimecodeReceiverListener == null) continue;
                    o_TimecodeReceiverListener.eventTimecodeReceived(longMilliseconds);
                }
            }
            for (int intListener = 0; intListener < o_MessageListeners.size(); ++intListener) {
                MidiMessageListener o_MidiMessageListener = (MidiMessageListener)o_MessageListeners.get(intListener);
                if (o_MidiMessageListener == null) continue;
                o_MidiMessageListener.eventMidiMessageReceived(p_MidiDeviceWrapper, s_Message_Received);
            }
        }
    }
}

