/*
 * Decompiled with CFR 0.152.
 */
package MIDIPackage;

import javax.sound.midi.MidiDevice;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiDeviceProvider;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiException;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiNotification;

public class CoreMidi4J_Available {
    public static void main(String[] args) throws Exception {
        try {
            Class<?> deviceProviderClass = Class.forName("uk.co.xfactorylibrarians.coremidi4j.CoreMidiDeviceProvider");
            System.out.println("CoreMIDI4J Java classes are available.");
            System.out.println("Working MIDI Devices:");
            for (MidiDevice.Info device : Example.getWorkingDeviceInfo()) {
                System.out.println("  " + device);
            }
            if (Example.isCoreMidiLoaded()) {
                System.out.println("CoreMIDI4J native library is running.");
                Example.watchForMidiChanges();
                System.out.println("Watching for MIDI environment changes for thirty seconds.");
                Thread.sleep(30000L);
            } else {
                System.out.println("CoreMIDI4J native library is not available.");
            }
        }
        catch (Exception e) {
            System.out.println("CoreMIDI4J Java classes are not available.");
        }
    }

    public static class Example {
        public static boolean isCoreMidiLoaded() throws CoreMidiException {
            return CoreMidiDeviceProvider.isLibraryLoaded();
        }

        public static void watchForMidiChanges() throws CoreMidiException {
            CoreMidiDeviceProvider.addNotificationListener((CoreMidiNotification)new CoreMidiNotification(){

                public void midiSystemUpdated() {
                    System.out.println("The MIDI environment has changed.");
                }
            });
        }

        public static MidiDevice.Info[] getWorkingDeviceInfo() {
            return CoreMidiDeviceProvider.getMidiDeviceInfo();
        }
    }
}

