/*
 * Decompiled with CFR 0.152.
 */
package JarLoader;

import JarLoader.JarClassLoader;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;

public final class JarResources {
    public boolean m_DebugOn;
    private HashMap<String, Integer> m_HashtableSizes;
    private HashMap<String, byte[]> m_HashtableJarContents;
    private char classNameReplacementChar;
    private String m_JarFileName;
    private boolean m_Valid;
    private JarClassLoader m_JarClassLoader;

    public JarResources(String p_JarFileName) {
        this.m_JarFileName = p_JarFileName;
        this.initMembers();
        this.loadJarFile(p_JarFileName);
    }

    private void initMembers() {
        this.m_DebugOn = false;
        this.m_Valid = false;
        this.m_HashtableSizes = new HashMap();
        this.m_HashtableJarContents = new HashMap();
    }

    public void close() {
        if (this.m_HashtableJarContents != null) {
            this.m_HashtableJarContents.clear();
        }
        if (this.m_HashtableSizes != null) {
            this.m_HashtableSizes.clear();
        }
    }

    public String getJarFileName() {
        return this.m_JarFileName;
    }

    protected void loadJarFile(String p_JarFileName) {
        this.m_Valid = false;
        if (p_JarFileName == null) {
            return;
        }
        if (p_JarFileName.length() <= 0) {
            return;
        }
        this.m_JarFileName = p_JarFileName;
        try {
            String stringFileName = this.m_JarFileName;
            File o_File = new File(stringFileName);
            boolean boolFileExists = o_File.exists();
            if (!boolFileExists) {
                stringFileName = "lib/" + this.m_JarFileName;
                o_File = new File(stringFileName);
                boolFileExists = o_File.exists();
            }
            if (!boolFileExists) {
                stringFileName = "dist/" + this.m_JarFileName;
                o_File = new File(stringFileName);
                boolFileExists = o_File.exists();
            }
            if (!boolFileExists) {
                stringFileName = "dist/lib/" + this.m_JarFileName;
                o_File = new File(stringFileName);
                boolFileExists = o_File.exists();
            }
            if (!boolFileExists) {
                throw new FileNotFoundException(this.m_JarFileName);
            }
            this.m_JarFileName = stringFileName;
            this.loadJarFile(o_File);
            o_File = null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    protected void loadJarFile(File p_JarFile) {
        block20: {
            this.m_Valid = false;
            if (p_JarFile == null) {
                return;
            }
            try {
                ZipFile o_ZipFile = new ZipFile(p_JarFile);
                this.m_JarFileName = o_ZipFile.getName();
                Enumeration<? extends ZipEntry> o_EnumerationEntries = o_ZipFile.entries();
                while (o_EnumerationEntries.hasMoreElements()) {
                    ZipEntry o_ZipEntry = o_EnumerationEntries.nextElement();
                    if (this.m_DebugOn) {
                        System.out.println(this.dumpZipEntry(o_ZipEntry));
                    }
                    this.m_HashtableSizes.put(o_ZipEntry.getName(), new Integer((int)o_ZipEntry.getSize()));
                }
                o_ZipFile.close();
                FileInputStream o_FileInputStream = null;
                BufferedInputStream o_BufferedInputStream = null;
                ZipInputStream o_ZipInputStream = null;
                try {
                    o_FileInputStream = new FileInputStream(p_JarFile);
                    o_BufferedInputStream = new BufferedInputStream(o_FileInputStream);
                    o_ZipInputStream = new ZipInputStream(o_BufferedInputStream);
                    ZipEntry o_ZipEntry = null;
                    while ((o_ZipEntry = o_ZipInputStream.getNextEntry()) != null) {
                        int intSize;
                        if (o_ZipEntry.isDirectory()) continue;
                        if (this.m_DebugOn) {
                            System.out.println("ze.getName()=" + o_ZipEntry.getName() + ",getSize()=" + o_ZipEntry.getSize());
                        }
                        if ((intSize = (int)o_ZipEntry.getSize()) == -1) {
                            intSize = this.m_HashtableSizes.get(o_ZipEntry.getName());
                        }
                        byte[] byteArray = new byte[intSize];
                        int intReadBytes = 0;
                        int intChunk = 0;
                        while (intSize - intReadBytes > 0 && (intChunk = o_ZipInputStream.read(byteArray, intReadBytes, intSize - intReadBytes)) != -1) {
                            intReadBytes += intChunk;
                        }
                        this.m_HashtableJarContents.put(o_ZipEntry.getName(), byteArray);
                        if (!this.m_DebugOn) continue;
                        System.out.println(o_ZipEntry.getName() + "  rb=" + intReadBytes + ",size=" + intSize + ",csize=" + o_ZipEntry.getCompressedSize());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (o_ZipInputStream != null) {
                        o_ZipInputStream.close();
                    }
                    if (o_BufferedInputStream != null) {
                        o_BufferedInputStream.close();
                    }
                    if (o_FileInputStream != null) {
                        o_FileInputStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.m_Valid = true;
                return;
            }
            catch (NullPointerException e) {
                if (this.m_DebugOn) {
                    System.out.println("done.");
                }
            }
            catch (FileNotFoundException e) {
                if (this.m_DebugOn) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                if (!this.m_DebugOn) break block20;
                e.printStackTrace();
            }
        }
        this.m_Valid = false;
    }

    public JarClassLoader getJarClassLoader() {
        if (this.m_JarClassLoader == null) {
            this.m_JarClassLoader = new JarClassLoader(this.m_JarFileName);
        }
        return this.m_JarClassLoader;
    }

    public boolean isValid() {
        return this.m_Valid;
    }

    public ArrayList<String> getResourceNames() {
        ArrayList<String> o_ArrayListKeyNames = new ArrayList<String>(this.m_HashtableJarContents.keySet());
        return o_ArrayListKeyNames;
    }

    public ArrayList<String> getResourceNames(String p_TypeFilter) {
        ArrayList<String> o_ArrayListKeyNames = new ArrayList<String>(this.m_HashtableJarContents.keySet());
        if (p_TypeFilter == null || p_TypeFilter.length() == 0) {
            return o_ArrayListKeyNames;
        }
        for (int intKey = 0; intKey < o_ArrayListKeyNames.size(); ++intKey) {
            String stringKey = o_ArrayListKeyNames.get(intKey);
            if (stringKey.length() < p_TypeFilter.length()) {
                o_ArrayListKeyNames.remove(intKey);
                --intKey;
                continue;
            }
            String stringEnding = stringKey.substring(stringKey.length() - p_TypeFilter.length(), stringKey.length());
            if (stringEnding.toLowerCase().equals(p_TypeFilter.toLowerCase())) continue;
            o_ArrayListKeyNames.remove(intKey);
            --intKey;
        }
        return o_ArrayListKeyNames;
    }

    public ArrayList<String> getClassNames() {
        ArrayList<String> o_ArrayListResourceNames = this.getResourceNames();
        if (o_ArrayListResourceNames == null) {
            return null;
        }
        ArrayList<String> o_ArrayListClassNames = new ArrayList<String>();
        for (int intResource = 0; intResource < o_ArrayListResourceNames.size(); ++intResource) {
            String stringSubString;
            String stringResource = o_ArrayListResourceNames.get(intResource);
            if (stringResource == null || stringResource.length() <= 6 || !(stringSubString = stringResource.substring(stringResource.length() - 6, stringResource.length())).toLowerCase().equals(".class".toLowerCase())) continue;
            stringSubString = stringResource.substring(0, stringResource.length() - 6);
            stringSubString = stringSubString.replace('/', '.');
            o_ArrayListClassNames.add(stringSubString);
        }
        return o_ArrayListClassNames;
    }

    public byte[] getResource(String p_ResourceName) {
        return this.m_HashtableJarContents.get(p_ResourceName);
    }

    public void setClassNameReplacementChar(char p_Replacement) {
        this.classNameReplacementChar = p_Replacement;
    }

    public String formatClassName(String p_ClassName) {
        if (p_ClassName == null) {
            return null;
        }
        String stringClassName = p_ClassName.substring(p_ClassName.length() - 6, p_ClassName.length()).equals(".class") ? p_ClassName.substring(0, p_ClassName.length() - 6) : p_ClassName;
        stringClassName = this.classNameReplacementChar == '\u0000' ? stringClassName.replace('.', '/') : stringClassName.replace('.', this.classNameReplacementChar);
        return stringClassName + ".class";
    }

    public BufferedImage getImageResource(String p_ImageResourceName) {
        byte[] byteArrayResource = this.getResource(p_ImageResourceName);
        if (byteArrayResource == null) {
            return null;
        }
        return JarResources.convertByteArrayToBufferedImage(byteArrayResource);
    }

    public static byte[] convertBufferedImageToByteArray(BufferedImage p_BufferedImage) {
        byte[] o_ByteArray;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (p_BufferedImage == null) {
            return null;
        }
        try {
            ImageIO.write((RenderedImage)p_BufferedImage, "gif", baos);
            baos.flush();
            o_ByteArray = baos.toByteArray();
        }
        catch (Exception e) {
            o_ByteArray = null;
        }
        try {
            baos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return o_ByteArray;
    }

    public static BufferedImage convertByteArrayToBufferedImage(byte[] p_ByteArray) {
        if (p_ByteArray == null) {
            return null;
        }
        ByteArrayInputStream o_ArrayInputStream = new ByteArrayInputStream(p_ByteArray);
        try {
            BufferedImage o_BufferedImage = ImageIO.read(o_ArrayInputStream);
            o_ArrayInputStream.close();
            return o_BufferedImage;
        }
        catch (Exception e) {
            try {
                o_ArrayInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    private String dumpZipEntry(ZipEntry p_ZipEntry) {
        StringBuffer stringBuffer = new StringBuffer();
        if (p_ZipEntry.isDirectory()) {
            stringBuffer.append("d ");
        } else {
            stringBuffer.append("f ");
        }
        if (p_ZipEntry.getMethod() == 0) {
            stringBuffer.append("stored   ");
        } else {
            stringBuffer.append("defalted ");
        }
        stringBuffer.append(p_ZipEntry.getName());
        stringBuffer.append("\t");
        stringBuffer.append("" + p_ZipEntry.getSize());
        if (p_ZipEntry.getMethod() == 8) {
            stringBuffer.append("/" + p_ZipEntry.getCompressedSize());
        }
        return stringBuffer.toString();
    }
}

