/*
 * Decompiled with CFR 0.152.
 */
package MIDIPackage;

import MIDIPackage.MIDI_MessageObject;
import MIDIPackage.MidiDeviceWrapper;
import MIDIPackage.MidiMessageListener;
import MIDIPackage.MidiMessageSender;
import MIDIPackage.MidiTimecode;
import OSCheckerPackage.OSChecker;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;

public class MidiTimecodeGenerator
implements Runnable {
    private Object m_ActorObject;
    private MidiMessageSender.MidiMessageDeviceContainer m_ActorDeviceContainer;
    private long m_StartTime;
    private long m_ScheduledTime;
    private int m_FrameType;
    private Sender m_Sender;
    private Thread m_TimerThread;
    private long m_TimerRate;
    private final Object m_TimerSync = new Object();
    private boolean m_TimerStop;
    private boolean m_TimerClose;
    private boolean m_TimerNewStart;
    private boolean m_IsRunning;
    private MIDI_MessageObject m_MIDI_MessageObject_Short;
    private MIDI_MessageObject m_MIDI_MessageObject_Sysex;
    private MidiMessageSender m_MidiMessageSender;
    private ArrayList<MidiTimecode.SenderListener> m_TimecodeSenderListeners;
    private final Object m_SyncSenderListeners = new Object();
    private Runnable m_RunnableSetActualTime;
    private Runnable m_RunnableSendQuarter;
    private Runnable m_RunnableSendFull;
    private LoopbackDevice m_LoopbackDevice;

    public MidiTimecodeGenerator() {
        this.initMembers();
    }

    private void initMembers() {
        this.m_MidiMessageSender = null;
        this.m_TimecodeSenderListeners = new ArrayList();
        this.m_Sender = new Sender();
        this.m_StartTime = 0L;
        this.m_FrameType = 1;
        this.m_TimerRate = 25L;
        this.m_TimerStop = true;
        this.m_TimerClose = false;
        this.m_TimerNewStart = false;
        this.m_IsRunning = false;
        this.m_MIDI_MessageObject_Short = new MIDI_MessageObject();
        this.m_MIDI_MessageObject_Short.setManuallyMIDI_ElementShort(MIDI_MessageObject.s_MIDI_ElementShort_Timecode);
        this.m_MIDI_MessageObject_Sysex = new MIDI_MessageObject();
        this.m_MIDI_MessageObject_Sysex.setManuallyMIDI_ElementSysex(MIDI_MessageObject.s_MIDI_ElementSysex_Timecode);
        this.m_ActorObject = null;
        this.m_ActorDeviceContainer = null;
        this.m_TimerThread = new Thread(this);
        this.m_TimerThread.start();
    }

    public void close() {
        this.m_TimerClose = true;
        this.m_Sender.close();
        this.m_TimerSync.notifyAll();
    }

    public Object getActor() {
        return this.m_ActorObject;
    }

    public MidiMessageSender.MidiMessageDeviceContainer getActorMidiMessageDeviceContainer() {
        return this.m_ActorDeviceContainer;
    }

    public long getStartTime() {
        return this.m_StartTime;
    }

    public void setFrameType(int p_FrameType) {
        switch (p_FrameType) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                this.m_FrameType = p_FrameType;
                break;
            }
            default: {
                return;
            }
        }
    }

    public int getFrameType() {
        return this.m_FrameType;
    }

    public int getFramesPerSecond() {
        switch (this.m_FrameType) {
            case 0: {
                return 24;
            }
            case 1: {
                return 25;
            }
            case 2: 
            case 4: {
                return 30;
            }
        }
        return -1;
    }

    public void setTimerRate(long p_Milliseconds) {
        if (p_Milliseconds < 20L) {
            p_Milliseconds = 20L;
        }
        this.m_TimerRate = p_Milliseconds;
    }

    public long getTimerRate() {
        return this.m_TimerRate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Object p_Actor, MidiMessageSender.MidiMessageDeviceContainer p_MidiMessageDeviceContainer, long p_Milliseconds) {
        if (p_Milliseconds < 0L) {
            p_Milliseconds = 0L;
        }
        Object object = this.m_TimerSync;
        synchronized (object) {
            this.m_StartTime = p_Milliseconds;
            this.m_ActorObject = p_Actor;
            this.m_ActorDeviceContainer = p_MidiMessageDeviceContainer;
            this.m_Sender.clear();
            this.m_TimerStop = false;
            this.m_TimerNewStart = true;
            this.m_IsRunning = true;
            this.m_TimerSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(Object p_Actor) {
        Object object = this.m_TimerSync;
        synchronized (object) {
            if (this.m_ActorObject != p_Actor) {
                return;
            }
            this.m_TimerStop = true;
            this.m_IsRunning = false;
            this.m_ActorObject = null;
            this.m_TimerSync.notifyAll();
        }
    }

    public boolean isRunning() {
        return this.m_IsRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.m_RunnableSendFull == null) {
            this.m_RunnableSendFull = new Runnable(){

                @Override
                public void run() {
                    LoopbackDevice o_LoopbackDevice;
                    MidiMessageSender o_MessageSender = MidiTimecodeGenerator.this.m_MidiMessageSender;
                    byte[] o_MessageBytes = MidiTimecodeGenerator.this.m_MIDI_MessageObject_Sysex.getMidiTimecode().getMessageBytes_FullSend();
                    MidiTimecodeGenerator.this.m_MIDI_MessageObject_Sysex.setMessageByteToSend(o_MessageBytes);
                    if (o_MessageSender != null) {
                        o_MessageSender.sendMidiMessage_Trigger(MidiTimecodeGenerator.this.m_MIDI_MessageObject_Sysex, MidiTimecodeGenerator.this.m_ActorDeviceContainer);
                    }
                    if ((o_LoopbackDevice = MidiTimecodeGenerator.this.m_LoopbackDevice) != null) {
                        o_LoopbackDevice.eventMidiMessageReceived(o_MessageBytes);
                    }
                }
            };
        }
        if (this.m_RunnableSendQuarter == null) {
            this.m_RunnableSendQuarter = new Runnable(){

                @Override
                public void run() {
                    LoopbackDevice o_LoopbackDevice;
                    MidiMessageSender o_MessageSender = MidiTimecodeGenerator.this.m_MidiMessageSender;
                    byte[] o_MessageBytes = MidiTimecodeGenerator.this.m_MIDI_MessageObject_Short.getMidiTimecode().getMessageBytes_QuarterSend();
                    MidiTimecodeGenerator.this.m_MIDI_MessageObject_Short.setMessageByteToSend(o_MessageBytes);
                    if (o_MessageSender != null) {
                        o_MessageSender.sendMidiMessage_Trigger(MidiTimecodeGenerator.this.m_MIDI_MessageObject_Short, MidiTimecodeGenerator.this.m_ActorDeviceContainer);
                    }
                    if ((o_LoopbackDevice = MidiTimecodeGenerator.this.m_LoopbackDevice) != null) {
                        o_LoopbackDevice.eventMidiMessageReceived(o_MessageBytes);
                    }
                }
            };
        }
        if (this.m_RunnableSetActualTime == null) {
            this.m_RunnableSetActualTime = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ArrayList o_SenderListeners = null;
                    MidiTimecode.SenderListener o_SenderListener = null;
                    Object object = MidiTimecodeGenerator.this.m_SyncSenderListeners;
                    synchronized (object) {
                        if (MidiTimecodeGenerator.this.m_TimecodeSenderListeners.size() > 0) {
                            o_SenderListeners = new ArrayList(MidiTimecodeGenerator.this.m_TimecodeSenderListeners.size());
                            o_SenderListeners.addAll(MidiTimecodeGenerator.this.m_TimecodeSenderListeners);
                        }
                    }
                    if (o_SenderListeners != null) {
                        for (int intListener = 0; intListener < o_SenderListeners.size(); ++intListener) {
                            o_SenderListener = (MidiTimecode.SenderListener)o_SenderListeners.get(intListener);
                            o_SenderListener.eventTimecodeSended(MidiTimecodeGenerator.this.m_ScheduledTime);
                        }
                    }
                    MidiTimecodeGenerator.this.m_MIDI_MessageObject_Short.getMidiTimecode().setTimeSend_Actual(MidiTimecodeGenerator.this.m_ScheduledTime);
                    MidiTimecodeGenerator.this.m_MIDI_MessageObject_Sysex.getMidiTimecode().setTimeSend_Actual(MidiTimecodeGenerator.this.m_ScheduledTime);
                }
            };
        }
        long longTimeWait = (long)(1000.0 / (double)this.getFramesPerSecond() / 4.0);
        long longTimeStepCounter = 0L;
        long longTime = 0L;
        long longStartTime = 0L;
        long longSystemTimeStarted = 0L;
        long longTimeDiff = 0L;
        int intSendCounter = 0;
        this.m_ScheduledTime = this.m_StartTime;
        while (!this.m_TimerClose) {
            Object object = this.m_TimerSync;
            synchronized (object) {
                try {
                    if (this.m_TimerStop) {
                        this.m_TimerSync.wait();
                    } else {
                        if (longTimeWait > 0L) {
                            if (OSChecker.getIsWindows()) {
                                long longWaitStart;
                                for (long longWaitTime = longTimeWait; !(longWaitTime <= 0L || this.m_TimerClose || this.m_TimerStop || this.m_TimerNewStart); longWaitTime -= System.nanoTime() / 1000000L - longWaitStart) {
                                    longWaitStart = System.nanoTime() / 1000000L;
                                    this.m_TimerSync.wait(longWaitTime);
                                }
                            } else {
                                this.m_TimerSync.wait(longTimeWait);
                            }
                        }
                        if (this.m_TimerStop) {
                            longTimeWait = (long)(1000.0 / (double)this.getFramesPerSecond() / 4.0);
                            continue;
                        }
                    }
                    if (this.m_TimerNewStart) {
                        this.m_MIDI_MessageObject_Short.getMidiTimecode().clearQuarterFrames_Send();
                        longSystemTimeStarted = System.nanoTime() / 1000000L;
                        longTimeWait = (long)(1000.0 / (double)this.getFramesPerSecond() / 4.0);
                        longStartTime = this.m_StartTime;
                        this.m_ScheduledTime = this.m_StartTime;
                        intSendCounter = 0;
                        longTimeStepCounter = 0L;
                        this.m_Sender.clear();
                        this.m_Sender.invokeLater(this.m_RunnableSetActualTime);
                        this.m_Sender.invokeLater(this.m_RunnableSendFull);
                        this.m_TimerNewStart = false;
                    }
                }
                catch (Exception e) {
                    System.out.println("Error MidiTimecodeGenerator: " + e.getStackTrace());
                }
                if (this.m_TimerClose) {
                    break;
                }
            }
            if (intSendCounter < 7) {
                this.m_Sender.invokeLater(this.m_RunnableSendQuarter);
                longTime = (long)((double)(++longTimeStepCounter) * (1000.0 / (double)this.getFramesPerSecond()) / 4.0);
                longTimeDiff = System.nanoTime() / 1000000L - longSystemTimeStarted;
                longTimeWait = (long)(1000.0 / (double)this.getFramesPerSecond() + (double)(longTime - longTimeDiff));
                ++intSendCounter;
                continue;
            }
            this.m_Sender.invokeLater(this.m_RunnableSendQuarter);
            longTime = (long)((double)(++longTimeStepCounter) * (1000.0 / (double)this.getFramesPerSecond()) / 4.0);
            longTimeDiff = System.nanoTime() / 1000000L - longSystemTimeStarted;
            longTimeWait = (long)(1000.0 / (double)this.getFramesPerSecond() + (double)(longTime - longTimeDiff));
            this.m_ScheduledTime = longStartTime + longTime;
            this.m_Sender.invokeLater(this.m_RunnableSetActualTime);
            intSendCounter = 0;
        }
        this.m_IsRunning = false;
    }

    public void setMidiMessageSender(MidiMessageSender p_MessageSender) {
        this.m_MidiMessageSender = p_MessageSender;
    }

    public MidiMessageSender getMidiMessageSender() {
        return this.m_MidiMessageSender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMidiTimecodeSenderListener(MidiTimecode.SenderListener p_SenderListener) {
        if (p_SenderListener == null) {
            return;
        }
        Object object = this.m_SyncSenderListeners;
        synchronized (object) {
            if (this.m_TimecodeSenderListeners.contains(p_SenderListener)) {
                return;
            }
            this.m_TimecodeSenderListeners.add(p_SenderListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMidiTimecodeSenderListener(MidiTimecode.SenderListener p_SenderListener) {
        if (p_SenderListener == null) {
            return;
        }
        Object object = this.m_SyncSenderListeners;
        synchronized (object) {
            this.m_TimecodeSenderListeners.remove(p_SenderListener);
        }
    }

    public LoopbackDevice createLoopbackDevice() {
        if (this.m_LoopbackDevice == null) {
            this.m_LoopbackDevice = new LoopbackDevice();
        }
        return this.m_LoopbackDevice;
    }

    public LoopbackDevice getLoopbackDevice() {
        return this.m_LoopbackDevice;
    }

    public static class LoopbackDevice
    implements MidiDeviceWrapper {
        private boolean m_Selected;
        private MidiMessageListener m_MessageListener;

        public LoopbackDevice() {
            this.initMembers();
        }

        private void initMembers() {
            this.m_Selected = false;
        }

        @Override
        public void close() {
        }

        @Override
        public String getID() {
            return "Loopback_Timecode";
        }

        @Override
        public void setDeviceType(int p_DeviceType) {
        }

        @Override
        public int getDeviceType() {
            return 1;
        }

        @Override
        public boolean getSelected() {
            return this.m_Selected;
        }

        @Override
        public void setSelected(boolean p_Selected) {
            this.m_Selected = p_Selected;
        }

        @Override
        public String getInterfaceName() {
            return "Test Loopback Timecode";
        }

        @Override
        public String getManufacturerName() {
            return "SPIT_MidiClient";
        }

        @Override
        public String getDescription() {
            return "Looped sent timecode back";
        }

        @Override
        public void send(MIDI_MessageObject p_MIDI_MessageObject, long p_TimeStamp) {
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        }

        @Override
        public Object getMidiDevice() {
            return this;
        }

        @Override
        public void setMidiMessageListener(MidiMessageListener p_MessageListener) {
            this.m_MessageListener = p_MessageListener;
        }

        public void eventMidiMessageReceived(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return;
            }
            MidiMessageListener o_MessageListener = this.m_MessageListener;
            if (o_MessageListener == null) {
                return;
            }
            if (!this.m_Selected) {
                return;
            }
            o_MessageListener.eventMidiMessageReceived((MidiDeviceWrapper)this, p_MessageBytes);
        }

        @Override
        public boolean isRemovable() {
            return true;
        }

        @Override
        public boolean hasProperties() {
            return false;
        }

        @Override
        public void showPropertyDialog() {
        }

        @Override
        public boolean getIsConnected() {
            return true;
        }
    }

    public static class Sender
    implements Runnable {
        private ArrayList<Runnable> m_Runnables;
        private boolean m_Close;
        private Thread m_Thread;
        private final Object m_SyncRunnables = new Object();

        public Sender() {
            this.initMembers();
            this.m_Thread.start();
        }

        private void initMembers() {
            this.m_Runnables = new ArrayList();
            this.m_Close = false;
            this.m_Thread = new Thread(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            this.m_Close = true;
            Object object = this.m_SyncRunnables;
            synchronized (object) {
                this.m_SyncRunnables.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invokeLater(Runnable p_Runnable) {
            if (p_Runnable == null) {
                return;
            }
            if (this.m_Close) {
                return;
            }
            Object object = this.m_SyncRunnables;
            synchronized (object) {
                this.m_Runnables.add(p_Runnable);
                this.m_SyncRunnables.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.m_SyncRunnables;
            synchronized (object) {
                this.m_Runnables.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.m_Close) {
                Runnable o_Runnable;
                Object object = this.m_SyncRunnables;
                synchronized (object) {
                    o_Runnable = null;
                    if (this.m_Runnables.size() <= 0) {
                        try {
                            this.m_SyncRunnables.wait();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        continue;
                    }
                    o_Runnable = this.m_Runnables.get(0);
                    this.m_Runnables.remove(0);
                }
                if (o_Runnable == null) continue;
                o_Runnable.run();
            }
        }
    }
}

