/*
 * Decompiled with CFR 0.152.
 */
package MIDIPackage;

import MIDIPackage.MIDI_MessageObject;

public class MidiTimecode {
    public static final int MIDIFRAMETYPE_24 = 0;
    public static final int MIDIFRAMETYPE_25 = 1;
    public static final int MIDIFRAMETYPE_30_DROP = 2;
    public static final int MIDIFRAMETYPE_30 = 4;
    private MIDI_MessageObject m_MIDI_MessageObject;
    private boolean m_Running_Received;
    private int m_FrameTypeReceived;
    private int m_FrameTypeSend;
    private long m_TimeReceived_Actual;
    private long m_TimeReceived_Last;
    private long m_TimeSend_Actual;
    private long m_TimeSend_Part;
    private long m_TimeTrigger;
    private long m_TimeObjectStart;
    private boolean m_UseTimecodeManual;
    private byte[] m_MessageBytes_SendFull;
    private byte[] m_MessageBytes_SendQuarter;
    private byte m_QuarterReceivedNibbles;
    private byte m_QuarterReceivedHours;
    private byte m_QuarterReceivedMinutes;
    private byte m_QuarterReceivedSeconds;
    private byte m_QuarterReceivedFrames;
    private byte m_QuarterReceivedFrameType;
    private boolean m_QuarterReceivedCompleted;
    private int m_QuarterSendPart;
    private byte m_QuarterSendHours;
    private byte m_QuarterSendMinutes;
    private byte m_QuarterSendSeconds;
    private byte m_QuarterSendFrames;
    private byte m_QuarterSendFrameType;

    public MidiTimecode(MIDI_MessageObject p_MIDI_MessageObject) {
        this.initMembers();
        this.m_MIDI_MessageObject = p_MIDI_MessageObject;
    }

    private void initMembers() {
        this.m_TimeReceived_Actual = 0L;
        this.m_TimeReceived_Last = 0L;
        this.m_TimeTrigger = -1L;
        this.m_TimeObjectStart = 0L;
        this.m_UseTimecodeManual = false;
        this.m_TimeReceived_Actual = 0L;
        this.m_TimeReceived_Last = 0L;
        this.m_TimeSend_Actual = 0L;
        this.m_TimeSend_Part = 0L;
        this.m_Running_Received = false;
        this.m_FrameTypeReceived = 1;
        this.m_FrameTypeSend = 1;
        this.m_MessageBytes_SendFull = new byte[10];
        this.m_MessageBytes_SendQuarter = new byte[2];
        this.clearQuarterFrames_Received();
        this.clearQuarterFrames_Send();
    }

    public void copyReceivedFrom(MidiTimecode p_MidiTimecode) {
        if (p_MidiTimecode == null) {
            return;
        }
        this.m_TimeReceived_Actual = p_MidiTimecode.getTimeReceived_Actual();
        this.m_TimeReceived_Last = p_MidiTimecode.getTimeReceived_Last();
        this.m_FrameTypeReceived = p_MidiTimecode.getFrameTypeReceived();
        this.m_QuarterReceivedCompleted = p_MidiTimecode.getQuarterReceived_Completed();
        this.m_QuarterReceivedNibbles = p_MidiTimecode.getQuarterReceivedNibbles();
        this.m_QuarterReceivedFrameType = p_MidiTimecode.getQuarterReceivedFrameType();
        this.m_QuarterReceivedHours = p_MidiTimecode.getQuarterReceivedHours();
        this.m_QuarterReceivedMinutes = p_MidiTimecode.getQuarterReceivedMinutes();
        this.m_QuarterReceivedSeconds = p_MidiTimecode.getQuarterReceivedSeconds();
        this.m_QuarterReceivedFrames = p_MidiTimecode.getQuarterReceivedFrames();
        this.m_Running_Received = p_MidiTimecode.getRunning_Received();
    }

    public void setFrameTypeSend(int p_FrameType) {
        if (this.m_FrameTypeSend == p_FrameType) {
            return;
        }
        if (p_FrameType < 0) {
            return;
        }
        if (p_FrameType > 3) {
            return;
        }
        this.m_FrameTypeSend = p_FrameType;
    }

    public int getFrameTypeSend() {
        return this.m_FrameTypeSend;
    }

    public int getFramesPerSecondSend() {
        switch (this.m_FrameTypeSend) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
        }
        return 1;
    }

    public int getFrameTypeReceived() {
        return this.m_FrameTypeReceived;
    }

    public int getFramesPerSecondReveived() {
        switch (this.m_FrameTypeReceived) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
        }
        return -1;
    }

    public long getTimeReceived_Actual() {
        return this.m_TimeReceived_Actual;
    }

    public long getTimeReceived_Last() {
        return this.m_TimeReceived_Last;
    }

    public void setTimeTrigger(long p_Milliseconds) {
        if (p_Milliseconds < 0L) {
            p_Milliseconds = -1L;
        }
        this.m_TimeTrigger = p_Milliseconds;
    }

    public long getTimeTrigger() {
        return this.m_TimeTrigger;
    }

    public void setTime_ObjectStart(long p_Milliseconds) {
        if (p_Milliseconds < 0L) {
            p_Milliseconds = 0L;
        }
        this.m_TimeObjectStart = p_Milliseconds;
    }

    public long getTime_ObjectStart() {
        return this.m_TimeObjectStart;
    }

    public void setUseTimecodeManual(boolean p_UseManualTimecode) {
        if (this.m_UseTimecodeManual == p_UseManualTimecode) {
            return;
        }
        this.m_UseTimecodeManual = p_UseManualTimecode;
    }

    public boolean getUseTimecodeManual() {
        return this.m_UseTimecodeManual;
    }

    public void setTimeSend_Actual(long p_Milliseconds) {
        if (p_Milliseconds < 0L) {
            p_Milliseconds = 0L;
        }
        this.m_TimeSend_Actual = p_Milliseconds;
        this.clearQuarterFrames_Send();
    }

    public long getTimeSend_Actual() {
        return this.m_TimeSend_Actual;
    }

    public boolean getRunning_Received() {
        return this.m_Running_Received;
    }

    public void eventTimeCodeFull(MIDI_MessageObject p_MIDI_MessageObject) {
        if (p_MIDI_MessageObject == null) {
            return;
        }
        if (p_MIDI_MessageObject.getType() != 2) {
            return;
        }
        if ((p_MIDI_MessageObject.getSysexSubID1() & 0xFF) != 1) {
            return;
        }
        byte[] o_BytesTimecode = p_MIDI_MessageObject.getSysexData();
        this.calculateTimeCodeFull_Received(p_MIDI_MessageObject.getMessageBytes());
    }

    private void calculateTimeCodeFull_Received(byte[] p_MessageBytes) {
        if (p_MessageBytes == null || p_MessageBytes.length != 10) {
            return;
        }
        long longTime = 0L;
        byte byteHours = p_MessageBytes[5];
        byte byteMinutes = p_MessageBytes[6];
        byte byteSeconds = p_MessageBytes[7];
        byte byteFrames = p_MessageBytes[8];
        int intFrameType = (byteHours & 0x60) >> 5;
        longTime += (long)((byteHours & 0x1F) * 3600000);
        longTime += (long)((byteMinutes & 0xFF) * 60000);
        longTime += (long)((byteSeconds & 0xFF) * 1000);
        switch (intFrameType) {
            case 0: {
                longTime += (long)((double)byteFrames / 24.0 * 1000.0);
                break;
            }
            case 1: {
                longTime += (long)((double)byteFrames / 25.0 * 1000.0);
                break;
            }
            case 2: {
                longTime += (long)((double)byteFrames / 30.0 * 1000.0);
                break;
            }
            case 4: {
                longTime += (long)((double)byteFrames / 30.0 * 1000.0);
                break;
            }
            default: {
                longTime = -1L;
            }
        }
        this.clearQuarterFrames_Received();
        this.m_Running_Received = false;
        this.m_FrameTypeReceived = intFrameType;
        this.m_TimeReceived_Last = longTime;
        this.m_TimeReceived_Actual = longTime;
    }

    public byte[] getMessageBytes_FullSend() {
        byte byteHour = 0;
        long longTime = this.m_TimeSend_Actual;
        this.m_MessageBytes_SendFull[0] = -16;
        this.m_MessageBytes_SendFull[1] = 127;
        this.m_MessageBytes_SendFull[2] = 127;
        this.m_MessageBytes_SendFull[3] = 1;
        this.m_MessageBytes_SendFull[4] = 1;
        this.m_MessageBytes_SendFull[9] = -9;
        byteHour = (byte)(this.m_FrameTypeSend << 5 & 0x60);
        int intValue = (int)((double)longTime / 3600000.0);
        longTime -= (long)(intValue * 3600000);
        this.m_MessageBytes_SendFull[5] = byteHour = (byte)(byteHour | intValue & 0x1F);
        intValue = (int)((double)longTime / 60000.0);
        longTime -= (long)(intValue * 60000);
        this.m_MessageBytes_SendFull[6] = (byte)(intValue & 0xFF);
        intValue = (int)((double)longTime / 1000.0);
        longTime -= (long)(intValue * 1000);
        this.m_MessageBytes_SendFull[7] = (byte)(intValue & 0xFF);
        intValue = (int)longTime;
        switch (this.m_FrameTypeReceived) {
            case 0: {
                intValue = (int)((double)longTime / 24.0);
                break;
            }
            case 1: {
                intValue = (int)((double)longTime / 24.0);
                break;
            }
            case 2: {
                intValue = (int)((double)longTime / 30.0);
                break;
            }
            case 4: {
                intValue = (int)((double)longTime / 30.0);
            }
        }
        this.m_MessageBytes_SendFull[8] = (byte)(intValue & 0xFF);
        this.clearQuarterFrames_Send();
        return this.m_MessageBytes_SendFull;
    }

    public void eventTimeCodeQuarter(MIDI_MessageObject p_MIDI_MessageObject) {
        if (p_MIDI_MessageObject == null) {
            return;
        }
        if (p_MIDI_MessageObject.getType() != 1) {
            return;
        }
        if ((p_MIDI_MessageObject.getShortCommandByte() & 0xFF) != 241) {
            return;
        }
        this.calculateQuarterFrames_Received(p_MIDI_MessageObject.getShortData1());
    }

    private void clearQuarterFrames_Received() {
        this.m_QuarterReceivedNibbles = 0;
        this.m_QuarterReceivedFrames = 0;
        this.m_QuarterReceivedSeconds = 0;
        this.m_QuarterReceivedMinutes = 0;
        this.m_QuarterReceivedHours = 0;
        this.m_QuarterReceivedFrameType = 0;
    }

    private void calculateQuarterFrames_Received(byte p_DataByte) {
        int intNumber = (p_DataByte & 0x70) >> 4;
        if (intNumber < 0 || intNumber > 7) {
            return;
        }
        byte byteData = (byte)(p_DataByte & 0xF);
        this.m_Running_Received = true;
        this.m_QuarterReceivedCompleted = false;
        switch (intNumber) {
            case 0: {
                if (this.m_QuarterReceivedNibbles != 0 && this.m_QuarterReceivedNibbles != 254) {
                    this.clearQuarterFrames_Received();
                }
                this.m_QuarterReceivedFrames = (byte)(this.m_QuarterReceivedFrames | byteData);
                this.m_QuarterReceivedNibbles = (byte)(this.m_QuarterReceivedNibbles | 1);
                if (this.m_QuarterReceivedNibbles != 255) break;
                this.setQuarterTimeReceived(false);
                this.clearQuarterFrames_Received();
                break;
            }
            case 1: {
                if (this.m_QuarterReceivedNibbles == 0) {
                    return;
                }
                byteData = (byte)((byteData & 1) << 4);
                this.m_QuarterReceivedFrames = (byte)(this.m_QuarterReceivedFrames | byteData);
                this.m_QuarterReceivedNibbles = (byte)(this.m_QuarterReceivedNibbles | 2);
                break;
            }
            case 2: {
                if (this.m_QuarterReceivedNibbles == 0) {
                    return;
                }
                this.m_QuarterReceivedSeconds = (byte)(this.m_QuarterReceivedSeconds | byteData);
                this.m_QuarterReceivedNibbles = (byte)(this.m_QuarterReceivedNibbles | 4);
                break;
            }
            case 3: {
                if (this.m_QuarterReceivedNibbles == 0) {
                    return;
                }
                byteData = (byte)((byteData & 3) << 4);
                this.m_QuarterReceivedSeconds = (byte)(this.m_QuarterReceivedSeconds | byteData);
                this.m_QuarterReceivedNibbles = (byte)(this.m_QuarterReceivedNibbles | 8);
                break;
            }
            case 4: {
                if (this.m_QuarterReceivedNibbles == 0) {
                    return;
                }
                this.m_QuarterReceivedMinutes = (byte)(this.m_QuarterReceivedMinutes | byteData);
                this.m_QuarterReceivedNibbles = (byte)(this.m_QuarterReceivedNibbles | 0x10);
                break;
            }
            case 5: {
                if (this.m_QuarterReceivedNibbles == 0) {
                    return;
                }
                byteData = (byte)((byteData & 3) << 4);
                this.m_QuarterReceivedMinutes = (byte)(this.m_QuarterReceivedMinutes | byteData);
                this.m_QuarterReceivedNibbles = (byte)(this.m_QuarterReceivedNibbles | 0x20);
                break;
            }
            case 6: {
                if (this.m_QuarterReceivedNibbles == 0) {
                    return;
                }
                this.m_QuarterReceivedHours = (byte)(this.m_QuarterReceivedHours | byteData);
                this.m_QuarterReceivedNibbles = (byte)(this.m_QuarterReceivedNibbles | 0x40);
                break;
            }
            case 7: {
                if (this.m_QuarterReceivedNibbles != 0 && this.m_QuarterReceivedNibbles != 127) {
                    this.clearQuarterFrames_Received();
                }
                byteData = (byte)((byteData & 1) << 4);
                this.m_QuarterReceivedHours = (byte)(this.m_QuarterReceivedHours | byteData);
                this.m_QuarterReceivedNibbles = (byte)(this.m_QuarterReceivedNibbles | 0x80);
                byteData = (byte)(p_DataByte & 0xF);
                this.m_QuarterReceivedFrameType = (byte)((byteData & 6) >> 1);
                if (this.m_QuarterReceivedNibbles != -1) break;
                this.setQuarterTimeReceived(true);
                this.clearQuarterFrames_Received();
            }
        }
    }

    private void setQuarterTimeReceived(boolean p_CountForward) {
        long longTime = 0L;
        longTime += (long)(this.m_QuarterReceivedHours * 3600000);
        longTime += (long)(this.m_QuarterReceivedMinutes * 60000);
        longTime += (long)(this.m_QuarterReceivedSeconds * 1000);
        int intFrames = this.m_QuarterReceivedFrames;
        if (p_CountForward) {
            intFrames += 2;
        }
        switch (this.m_QuarterReceivedFrameType) {
            case 0: {
                longTime += (long)((double)intFrames / 24.0 * 1000.0);
                break;
            }
            case 1: {
                longTime += (long)((double)intFrames / 25.0 * 1000.0);
                break;
            }
            case 2: {
                longTime += (long)((double)intFrames / 30.0 * 1000.0);
                break;
            }
            case 4: {
                longTime += (long)((double)intFrames / 30.0 * 1000.0);
            }
        }
        this.m_FrameTypeReceived = this.m_QuarterReceivedFrameType;
        this.m_TimeReceived_Last = this.m_TimeReceived_Actual;
        this.m_TimeReceived_Actual = longTime;
        this.m_QuarterReceivedCompleted = true;
    }

    public boolean getQuarterReceived_Completed() {
        return this.m_QuarterReceivedCompleted;
    }

    public byte getQuarterReceivedNibbles() {
        return (byte)(this.m_QuarterReceivedNibbles & 0xFF);
    }

    public byte getQuarterReceivedHours() {
        return (byte)(this.m_QuarterReceivedHours & 0xFF);
    }

    public byte getQuarterReceivedMinutes() {
        return (byte)(this.m_QuarterReceivedMinutes & 0xFF);
    }

    public byte getQuarterReceivedSeconds() {
        return (byte)(this.m_QuarterReceivedSeconds & 0xFF);
    }

    public byte getQuarterReceivedFrames() {
        return (byte)(this.m_QuarterReceivedFrames & 0xFF);
    }

    public byte getQuarterReceivedFrameType() {
        return (byte)(this.m_QuarterReceivedFrameType & 0xFF);
    }

    public void clearQuarterFrames_Send() {
        this.m_QuarterSendPart = 0;
        this.m_QuarterSendFrames = 0;
        this.m_QuarterSendSeconds = 0;
        this.m_QuarterSendMinutes = 0;
        this.m_QuarterSendHours = 0;
        this.m_QuarterSendFrameType = 0;
    }

    public byte[] getMessageBytes_QuarterSend() {
        this.m_MessageBytes_SendQuarter[0] = -15;
        byte o_DataByte = (byte)(this.m_QuarterSendPart << 4);
        switch (this.m_QuarterSendPart) {
            case 0: {
                this.calculateQuarterFrames_Send(this.m_TimeSend_Actual);
                o_DataByte = (byte)(o_DataByte | (byte)(this.m_QuarterSendFrames & 0xF));
                this.m_QuarterSendPart = 1;
                break;
            }
            case 1: {
                o_DataByte = (byte)(o_DataByte | (byte)((this.m_QuarterSendFrames & 0x10) >> 4));
                this.m_QuarterSendPart = 2;
                break;
            }
            case 2: {
                o_DataByte = (byte)(o_DataByte | (byte)(this.m_QuarterSendSeconds & 0xF));
                this.m_QuarterSendPart = 3;
                break;
            }
            case 3: {
                o_DataByte = (byte)(o_DataByte | (byte)((this.m_QuarterSendSeconds & 0x30) >> 4));
                this.m_QuarterSendPart = 4;
                break;
            }
            case 4: {
                o_DataByte = (byte)(o_DataByte | (byte)(this.m_QuarterSendMinutes & 0xF));
                this.m_QuarterSendPart = 5;
                break;
            }
            case 5: {
                o_DataByte = (byte)(o_DataByte | (byte)((this.m_QuarterSendMinutes & 0x30) >> 4));
                this.m_QuarterSendPart = 6;
                break;
            }
            case 6: {
                o_DataByte = (byte)(o_DataByte | (byte)(this.m_QuarterSendHours & 0xF));
                this.m_QuarterSendPart = 7;
                break;
            }
            case 7: {
                o_DataByte = (byte)(o_DataByte | (byte)((this.m_QuarterSendHours & 0x10) >> 4));
                o_DataByte = (byte)(o_DataByte | (byte)((this.m_FrameTypeSend & 0xF) << 1));
                this.clearQuarterFrames_Send();
                break;
            }
            default: {
                return null;
            }
        }
        this.m_MessageBytes_SendQuarter[1] = o_DataByte;
        return this.m_MessageBytes_SendQuarter;
    }

    private void calculateQuarterFrames_Send(long p_Milliseconds) {
        long longTime = this.m_TimeSend_Actual;
        int intValue = (int)((double)longTime / 3600000.0);
        this.m_QuarterSendHours = (byte)(intValue & 0x1F);
        longTime -= (long)(intValue * 3600000);
        intValue = this.m_QuarterSendFrameType;
        this.m_QuarterSendHours = (byte)(this.m_QuarterSendHours | intValue << 5);
        intValue = (int)((double)longTime / 60000.0);
        this.m_QuarterSendMinutes = (byte)(intValue & 0x3F);
        longTime -= (long)(intValue * 60000);
        intValue = (int)((double)longTime / 1000.0);
        this.m_QuarterSendSeconds = (byte)(intValue & 0x3F);
        longTime -= (long)(intValue * 1000);
        switch (this.m_FrameTypeSend) {
            case 0: {
                intValue = (int)((double)longTime / 41.666666666666664);
                this.m_QuarterSendFrames = (byte)(intValue & 0x1F);
                break;
            }
            case 1: {
                intValue = (int)((double)longTime / 40.0);
                this.m_QuarterSendFrames = (byte)(intValue & 0x1F);
                break;
            }
            case 2: {
                intValue = (int)((double)longTime / 33.333333333333336);
                this.m_QuarterSendFrames = (byte)(intValue & 0x1F);
                break;
            }
            case 4: {
                intValue = (int)((double)longTime / 33.333333333333336);
                this.m_QuarterSendFrames = (byte)(intValue & 0x1F);
            }
        }
    }

    public int getQuarterSendPart() {
        return this.m_QuarterSendPart;
    }

    public byte getQuarterSendHours() {
        return (byte)(this.m_QuarterSendHours & 0xFF);
    }

    public byte getQuarterSendMinutes() {
        return (byte)(this.m_QuarterSendMinutes & 0xFF);
    }

    public byte getQuarterSendSeconds() {
        return (byte)(this.m_QuarterSendSeconds & 0xFF);
    }

    public byte getQuarterSendFrames() {
        return (byte)(this.m_QuarterSendFrames & 0xFF);
    }

    public byte getQuarterSendFrameType() {
        return (byte)(this.m_QuarterSendFrameType & 0xFF);
    }

    public static interface ReceiverListener {
        public void eventTimecodeReceived(long var1);
    }

    public static interface SenderListener {
        public void eventTimecodeSended(long var1);
    }
}

