/*
 * Decompiled with CFR 0.152.
 */
package MIDIPackage;

import MIDIPackage.MidiTimecode;
import MIDIPackage.Midi_MessageInterface;
import SwingModelPackage.TableAndListModel;
import ToolsPackage.MidiTools;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class MIDI_MessageObject
implements Midi_MessageInterface,
Externalizable {
    public static final int SOFTWAREVERSION = 2;
    public static final int TYPE_UNDEFINED = 0;
    public static final int TYPE_SHORT = 1;
    public static final int TYPE_SYSEX = 2;
    public static final int TYPESUB_TIMECODE = 3;
    public static final int TYPE_SHORT_MIDITIMECODE = 241;
    public static final int TYPE_SHORT_SONGPOSITIONPOINTER = 242;
    public static final int TYPE_SHORT_SONGSELECT = 243;
    public static final int TYPE_SHORT_TUNEREQUEST = 246;
    public static final int TYPE_SHORT_ENDOFEXCLUSIVE = 247;
    public static final int TYPE_SHORT_TIMINGCLOCK = 248;
    public static final int TYPE_SHORT_START = 250;
    public static final int TYPE_SHORT_CONTINUE = 251;
    public static final int TYPE_SHORT_STOP = 252;
    public static final int TYPE_SHORT_ACTIVESENSING = 254;
    public static final int TYPE_SHORT_SYSTEMRESET = 255;
    public static final int TYPE_SHORT_NOTEOFF = 128;
    public static final int TYPE_SHORT_NOTEON = 144;
    public static final int TYPE_SHORT_POLYPRESSURE = 160;
    public static final int TYPE_SHORT_CONTROLCHANGE = 176;
    public static final int TYPE_SHORT_PROGRAMCHANGE = 192;
    public static final int TYPE_SHORT_CHANNELPRESSURE = 208;
    public static final int TYPE_SHORT_PITCHBEND = 224;
    public static TableAndListModel.ListModel<MIDI_ElementShort> s_MIDI_ElementShortList = new TableAndListModel.ListModel(false);
    public static MIDI_ElementShort s_MIDI_ElementShort_Undefined;
    public static final int SYSTEM_EXCLUSIVE = 240;
    public static final int SPECIAL_SYSTEM_EXCLUSIVE = 247;
    public static final int TYPE_SYSEX_UNDEFINED = 0;
    public static final int TYPE_SYSEX_REALTIME = 1;
    public static final int TYPE_SYSEX_NONREALTIME = 2;
    public static final int TYPE_SYSEX_MANUFACTURER = 3;
    public static TableAndListModel.ListModel<MIDI_ElementSysex> s_SysexRealtimeList;
    public static final int TYPE_REALTIME_MIDITIMECODE = 1;
    public static final int TYPE_REALTIME_MSC = 2;
    public static final int TYPE_REALTIME_NOTATION = 3;
    public static final int TYPE_REALTIME_DEVICECONTROL = 4;
    public static final int TYPE_REALTIME_MTC = 5;
    public static final int TYPE_REALTIME_MMC = 6;
    public static final int TYPE_REALTIME_MMCRESPONSE = 7;
    public static final int TYPE_REALTIME_MIDITUNING = 8;
    public static final int TYPE_REALTIME_CONTROLLERDESTINATION = 9;
    public static final int TYPE_REALTIME_KEYBASEDINSTRUMENT = 10;
    public static final int TYPE_REALTIME_SCALABLEPOLYPHONY = 11;
    public static final int TYPE_REALTIME_MOBILEPHONE = 12;
    public static TableAndListModel.ListModel<MIDI_ElementSysex> s_SysexNonRealtimeList;
    public static final int TYPE_NONREALTIME_SAMPLEDUMPHEADER = 1;
    public static final int TYPE_NONREALTIME_SAMPLEDATAPACKET = 2;
    public static final int TYPE_NONREALTIME_SAMPLEDUMPREQUEST = 3;
    public static final int TYPE_NONREALTIME_MIDITIMECODE = 4;
    public static final int TYPE_NONREALTIME_SAMPLEDUMPEXTENSION = 5;
    public static final int TYPE_NONREALTIME_GENERALINFORMATION = 6;
    public static final int TYPE_NONREALTIME_FILEDUMP = 7;
    public static final int TYPE_NONREALTIME_MIDITUNING = 8;
    public static final int TYPE_NONREALTIME_GENERALMIDI = 9;
    public static final int TYPE_NONREALTIME_EOF = 123;
    public static final int TYPE_NONREALTIME_WAIT = 124;
    public static final int TYPE_NONREALTIME_CANCEL = 125;
    public static final int TYPE_NONREALTIME_NAK = 126;
    public static final int TYPE_NONREALTIME_ACK = 127;
    public static MIDI_ElementSysex s_MIDI_ElementSysex_Undefined;
    public static MIDI_ElementSysex s_MIDI_ElementSysex_ManufacturerUndefined;
    public static MIDI_ElementSysex s_MIDI_ElementSysex_RealtimeUndefined;
    public static MIDI_ElementSysex s_MIDI_ElementSysex_NonRealtimeUndefined;
    public static MIDI_ElementShort s_MIDI_ElementShort_Timecode;
    public static MIDI_ElementSysex s_MIDI_ElementSysex_Timecode;
    private static boolean s_ELementsFilled;
    private int m_Type;
    private int m_TypeSub;
    private MIDI_ElementShort m_MIDI_ElementShort;
    private MIDI_ElementSysex m_MIDI_ElementSysex;
    private byte[] m_Bytes_Short;
    private byte[] m_Bytes_ShortToSend;
    private byte[] m_Bytes_Sysex;
    private byte[] m_Bytes_SysexToSend;
    private MidiTimecode m_MidiTimecode;
    protected boolean m_TriggerUseObjectValue;
    protected int m_RemoteOperator;
    protected int m_RemoteThreshhold;
    protected int m_RemoteValueUsage;
    protected float m_RemoteValueInDecreasePC;
    public static final int OPERATOR_VALUE_IGNORE = 0;
    public static final int OPERATOR_VALUE_LOWER = 1;
    public static final int OPERATOR_VALUE_LOWER_EQUAL = 2;
    public static final int OPERATOR_VALUE_GREATER = 3;
    public static final int OPERATOR_VALUE_GREATER_EQUAL = 4;
    public static final int OPERATOR_VALUE_EQUAL = 5;
    public static final int VALUEUSAGE_DIRECT = 0;
    public static final int VALUEUSAGE_INDECREASE = 1;
    public static final float VALUEUSAGE_INDECREASE_DEFAULTPC = 0.5f;

    public static boolean fillElements() {
        MIDI_ElementSysex o_MIDI_ElementSysex;
        MIDI_ElementShort o_ElementShort;
        s_MIDI_ElementShort_Undefined = o_ElementShort = new MIDI_ElementShort(0, "---");
        o_ElementShort = new MIDI_ElementShort(128, "NOTE OFF");
        o_ElementShort = new MIDI_ElementShort(144, "NOTE ON");
        o_ElementShort = new MIDI_ElementShort(160, "POLY PRESSURE");
        o_ElementShort = new MIDI_ElementShort(176, "CC CONTROL CHANGE");
        o_ElementShort = new MIDI_ElementShort(192, "PROGRAM CHANGE");
        o_ElementShort = new MIDI_ElementShort(208, "CHANNEL PRESSURE");
        o_ElementShort = new MIDI_ElementShort(224, "PITCH BEND");
        s_MIDI_ElementShort_Timecode = o_ElementShort = new MIDI_ElementShort(241, "MIDI TIME CODE");
        o_ElementShort = new MIDI_ElementShort(242, "SONG POSITION POINTER");
        o_ElementShort = new MIDI_ElementShort(243, "SONG SELECT");
        o_ElementShort = new MIDI_ElementShort(246, "TUNER EQUEST");
        o_ElementShort = new MIDI_ElementShort(247, "END OF EXCLUSIVE");
        o_ElementShort = new MIDI_ElementShort(248, "TIMING CLOCK");
        o_ElementShort = new MIDI_ElementShort(250, "START");
        o_ElementShort = new MIDI_ElementShort(251, "CONTINUE");
        o_ElementShort = new MIDI_ElementShort(252, "STOP");
        o_ElementShort = new MIDI_ElementShort(254, "ACTIVE SENSING");
        o_ElementShort = new MIDI_ElementShort(255, "SYSTEM RESET");
        s_MIDI_ElementSysex_Undefined = o_MIDI_ElementSysex = new MIDI_ElementSysex(0, 0);
        s_MIDI_ElementSysex_ManufacturerUndefined = new MIDI_ElementSysex_Manufacturer(0);
        s_MIDI_ElementSysex_RealtimeUndefined = new MIDI_ElementSysex_Realtime(0);
        o_MIDI_ElementSysex = new MIDI_ElementSysex_DEVICECONTROL();
        s_MIDI_ElementSysex_Timecode = o_MIDI_ElementSysex = new MIDI_ElementSysex_MIDITIMECODE();
        o_MIDI_ElementSysex = new MIDI_ElementSysex_MIDITUNING();
        o_MIDI_ElementSysex = new MIDI_ElementSysex_MMC();
        o_MIDI_ElementSysex = new MIDI_ElementSysex_MMCRESPONSE();
        o_MIDI_ElementSysex = new MIDI_ElementSysex_MSC();
        o_MIDI_ElementSysex = new MIDI_ElementSysex_MTC();
        o_MIDI_ElementSysex = new MIDI_ElementSysex_NOTATION();
        o_MIDI_ElementSysex = new MIDI_ElementSysex_CONTROLLERDESTINATION();
        o_MIDI_ElementSysex = new MIDI_ElementSysex_KEYBASEDINSTRUMENT();
        o_MIDI_ElementSysex = new MIDI_ElementSysex_SCALABLEPOLYPHONY();
        o_MIDI_ElementSysex = new MIDI_ElementSysex_MOBILEPHONE();
        s_MIDI_ElementSysex_NonRealtimeUndefined = new MIDI_ElementSysex_NonRealtime(0);
        return true;
    }

    public MIDI_MessageObject() {
        this.initMembers();
    }

    private void initMembers() {
        this.m_Bytes_Short = new byte[3];
        this.m_Bytes_ShortToSend = new byte[3];
        this.m_Bytes_Sysex = new byte[MIDI_ElementSysex.MINIMUM_MESSAGEBYTES];
        this.m_Bytes_SysexToSend = new byte[MIDI_ElementSysex.MINIMUM_MESSAGEBYTES];
        this.m_Bytes_Sysex[0] = -16;
        this.m_Bytes_Sysex[MIDI_ElementSysex.MINIMUM_MESSAGEBYTES - 1] = -9;
        this.m_Type = 1;
        this.m_TypeSub = 0;
        this.m_TriggerUseObjectValue = false;
        this.m_RemoteOperator = 2;
        this.m_RemoteThreshhold = 0;
        this.m_RemoteValueUsage = 0;
        this.m_RemoteValueInDecreasePC = 0.5f;
        this.m_MidiTimecode = new MidiTimecode(this);
    }

    public void copyReceivedFrom(MIDI_MessageObject p_MIDI_MessageObject) {
        if (p_MIDI_MessageObject == null) {
            return;
        }
        this.clearMessageBytes_Short();
        byte[] o_MessageBytes = p_MIDI_MessageObject.getMessageBytes_Short();
        System.arraycopy(o_MessageBytes, 0, this.m_Bytes_Short, 0, o_MessageBytes.length);
        o_MessageBytes = p_MIDI_MessageObject.getMessageBytes_Sysex();
        if (this.m_Bytes_Sysex == null || this.m_Bytes_Sysex.length != o_MessageBytes.length) {
            this.m_Bytes_Sysex = new byte[o_MessageBytes.length];
        }
        System.arraycopy(o_MessageBytes, 0, this.m_Bytes_Sysex, 0, o_MessageBytes.length);
        this.m_MIDI_ElementShort = p_MIDI_MessageObject.getMIDI_ElementShort();
        this.m_MIDI_ElementSysex = p_MIDI_MessageObject.getMIDI_ElementSysex();
        if (this.m_Bytes_SysexToSend.length != this.m_Bytes_Sysex.length) {
            this.m_Bytes_SysexToSend = new byte[this.m_Bytes_Sysex.length];
        }
        this.m_Type = p_MIDI_MessageObject.getType();
        this.m_TypeSub = p_MIDI_MessageObject.getTypeSub();
        this.m_MidiTimecode.copyReceivedFrom(p_MIDI_MessageObject.getMidiTimecode());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(2);
        byte[] o_MessageBytes = this.getMessageBytes();
        int intByteCount = o_MessageBytes.length;
        out.writeInt(intByteCount);
        for (int intByte = 0; intByte < intByteCount; ++intByte) {
            out.writeByte(o_MessageBytes[intByte]);
        }
        out.writeLong(this.m_MidiTimecode.getTimeTrigger());
        out.writeLong(this.m_MidiTimecode.getTime_ObjectStart());
        out.writeBoolean(this.m_MidiTimecode.getUseTimecodeManual());
        out.writeBoolean(this.m_TriggerUseObjectValue);
        out.writeInt(this.m_RemoteOperator);
        out.writeInt(this.m_RemoteThreshhold);
        out.writeInt(this.m_RemoteValueUsage);
        out.writeFloat(this.m_RemoteValueInDecreasePC);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        int intByteCount = in.readInt();
        byte[] o_MessageBytes = new byte[intByteCount];
        for (int intByte = 0; intByte < intByteCount; ++intByte) {
            o_MessageBytes[intByte] = in.readByte();
        }
        if (intSoftwareVersion >= 2) {
            this.m_MidiTimecode.setTimeTrigger(in.readLong());
            this.m_MidiTimecode.setTime_ObjectStart(in.readLong());
            this.m_MidiTimecode.setUseTimecodeManual(in.readBoolean());
        }
        this.m_TriggerUseObjectValue = in.readBoolean();
        this.m_RemoteOperator = in.readInt();
        this.m_RemoteThreshhold = in.readInt();
        this.m_RemoteValueUsage = in.readInt();
        this.m_RemoteValueInDecreasePC = in.readFloat();
        this.setMessageBytes(o_MessageBytes);
    }

    public boolean setSPITOperator(int p_Operator) {
        if (this.m_RemoteOperator == p_Operator) {
            return false;
        }
        this.m_RemoteOperator = p_Operator;
        return true;
    }

    public int getSPITOperator() {
        return this.m_RemoteOperator;
    }

    public boolean setSPITThreshhold_Float(float p_Treshhold) {
        return this.setThreshhold((int)(p_Treshhold * 1000000.0f));
    }

    public boolean setThreshhold(int p_Treshhold) {
        if (p_Treshhold < 0) {
            p_Treshhold = 0;
        }
        if (p_Treshhold > 1000000) {
            p_Treshhold = 1000000;
        }
        if (this.m_RemoteThreshhold == p_Treshhold) {
            return false;
        }
        this.m_RemoteThreshhold = p_Treshhold;
        return true;
    }

    public float getSPITThreshhold_Float() {
        return (float)this.m_RemoteThreshhold / 1000000.0f;
    }

    public int getThreshhold() {
        return this.m_RemoteThreshhold;
    }

    public int getSPITValueUsage() {
        return this.m_RemoteValueUsage;
    }

    public boolean setSPITValueUseage(int p_FlagValueUsage) {
        if (p_FlagValueUsage != 0 && p_FlagValueUsage != 1) {
            p_FlagValueUsage = 0;
        }
        if (this.m_RemoteValueUsage == p_FlagValueUsage) {
            return false;
        }
        this.m_RemoteValueUsage = p_FlagValueUsage;
        return true;
    }

    public float getSPITInDecreasePC() {
        return this.m_RemoteValueInDecreasePC;
    }

    public boolean setSPITInDecreasePC(float p_PC) {
        if (p_PC < 0.0f) {
            p_PC = 0.0f;
        }
        if (p_PC > 100.0f) {
            p_PC = 100.0f;
        }
        if (this.m_RemoteValueInDecreasePC == p_PC) {
            return false;
        }
        this.m_RemoteValueInDecreasePC = p_PC;
        return true;
    }

    public byte[] getMessageBytes_Short() {
        return this.m_Bytes_Short;
    }

    public byte[] getMessageBytes_Sysex() {
        return this.m_Bytes_Sysex;
    }

    public boolean isSet() {
        if (this.m_Type == 1) {
            return this.getShortStatusByte() != 0;
        }
        if (this.m_Type == 2) {
            return this.getSysexManufacturer() != 0;
        }
        return false;
    }

    public byte[] getMessageBytes() {
        if (this.m_Type == 1) {
            return this.getMessageBytes_Short();
        }
        if (this.m_Type == 2) {
            return this.getMessageBytes_Sysex();
        }
        return this.getMessageBytes_Short();
    }

    public byte[] getMessageBytes_ShortToSend() {
        return this.m_Bytes_ShortToSend;
    }

    public byte[] getMessageBytes_SysexToSend() {
        return this.m_Bytes_SysexToSend;
    }

    @Override
    public byte[] getMessageBytesToSend() {
        if (this.m_Type == 1) {
            return this.m_Bytes_ShortToSend;
        }
        if (this.m_Type == 2) {
            return this.m_Bytes_SysexToSend;
        }
        return this.m_Bytes_ShortToSend;
    }

    public void setMessageBytes(byte[] p_MessageBytes) {
        this.clearMessageBytes_Short();
        if (p_MessageBytes == null) {
            this.m_Type = 1;
            return;
        }
        int intType = this.interpreteMessageBytes(p_MessageBytes);
        switch (intType) {
            case 1: {
                this.m_Type = 1;
                int intLength = p_MessageBytes.length;
                if (intLength > this.m_Bytes_Short.length) {
                    intLength = this.m_Bytes_Short.length;
                }
                System.arraycopy(p_MessageBytes, 0, this.m_Bytes_Short, 0, p_MessageBytes.length);
                System.arraycopy(this.m_Bytes_Short, 0, this.m_Bytes_ShortToSend, 0, this.m_Bytes_Short.length);
                if (this.m_TypeSub != 3) break;
                this.m_MidiTimecode.eventTimeCodeQuarter(this);
                break;
            }
            case 2: {
                this.m_Type = 2;
                if (this.m_Bytes_Sysex == null || this.m_Bytes_Sysex.length != p_MessageBytes.length) {
                    this.m_Bytes_Sysex = new byte[p_MessageBytes.length];
                }
                System.arraycopy(p_MessageBytes, 0, this.m_Bytes_Sysex, 0, p_MessageBytes.length);
                if (this.m_Bytes_SysexToSend.length != this.m_Bytes_Sysex.length) {
                    this.m_Bytes_SysexToSend = new byte[this.m_Bytes_Sysex.length];
                }
                System.arraycopy(this.m_Bytes_Sysex, 0, this.m_Bytes_SysexToSend, 0, this.m_Bytes_Sysex.length);
                if (this.m_TypeSub != 3) break;
                this.setSysexSubID2((byte)1);
                this.m_MidiTimecode.eventTimeCodeFull(this);
                break;
            }
            default: {
                this.m_Type = 1;
                this.m_TypeSub = 0;
            }
        }
    }

    public void setMessageByteToSend(byte[] p_MessageBytes) {
        if (p_MessageBytes == null) {
            return;
        }
        int intLength = p_MessageBytes.length;
        switch (this.m_Type) {
            case 1: {
                if (intLength > this.m_Bytes_ShortToSend.length) {
                    intLength = this.m_Bytes_ShortToSend.length;
                }
                System.arraycopy(p_MessageBytes, 0, this.m_Bytes_ShortToSend, 0, intLength);
                break;
            }
            case 2: {
                if (this.m_Bytes_SysexToSend.length != p_MessageBytes.length) {
                    this.m_Bytes_SysexToSend = new byte[p_MessageBytes.length];
                }
                System.arraycopy(p_MessageBytes, 0, this.m_Bytes_SysexToSend, 0, this.m_Bytes_SysexToSend.length);
            }
        }
    }

    public MidiTimecode getMidiTimecode() {
        return this.m_MidiTimecode;
    }

    public int interpreteMessageBytes(byte[] p_MessageBytes) {
        this.m_MIDI_ElementShort = null;
        this.m_MIDI_ElementSysex = null;
        if (p_MessageBytes == null) {
            return 0;
        }
        if (p_MessageBytes.length < 1) {
            return 0;
        }
        if (p_MessageBytes.length == 4) {
            return 0;
        }
        if (p_MessageBytes.length <= 3) {
            this.m_MIDI_ElementShort = this.findMIDI_ElementShort(p_MessageBytes);
            this.m_TypeSub = (this.m_MIDI_ElementShort.getCommandByte() & 0xFF) == 241 ? 3 : 0;
            return 1;
        }
        if ((p_MessageBytes[0] & 0xFF) != 240 || (p_MessageBytes[p_MessageBytes.length - 1] & 0xFF) != 247) {
            return 0;
        }
        this.m_MIDI_ElementSysex = this.findMIDI_ElementSysex(p_MessageBytes);
        this.m_TypeSub = (this.m_MIDI_ElementSysex.getSubID1() & 0xFF) == 1 ? 3 : 0;
        return 2;
    }

    public int getType() {
        return this.m_Type;
    }

    public int getTypeSub() {
        return this.m_TypeSub;
    }

    public void clearMessageBytes_Short() {
        for (int intByte = 0; intByte < this.m_Bytes_Short.length; ++intByte) {
            this.m_Bytes_Short[intByte] = 0;
            this.m_Bytes_ShortToSend[intByte] = 0;
        }
    }

    public void clearMessageBytes_Sysex() {
        for (int intByte = 0; intByte < this.m_Bytes_Sysex.length; ++intByte) {
            this.m_Bytes_Sysex[intByte] = 0;
            this.m_Bytes_SysexToSend[intByte] = 0;
        }
        this.m_Bytes_Sysex[0] = -16;
        this.m_Bytes_Sysex[MIDI_ElementSysex.MINIMUM_MESSAGEBYTES - 1] = -9;
        this.m_Bytes_SysexToSend[0] = -16;
        this.m_Bytes_SysexToSend[MIDI_ElementSysex.MINIMUM_MESSAGEBYTES - 1] = -9;
    }

    private MIDI_ElementShort findMIDI_ElementShort(byte[] p_MessageBytes) {
        if (p_MessageBytes == null) {
            return s_MIDI_ElementShort_Undefined;
        }
        if (p_MessageBytes.length < 1) {
            return s_MIDI_ElementShort_Undefined;
        }
        for (int intElement = 0; intElement < s_MIDI_ElementShortList.size(); ++intElement) {
            MIDI_ElementShort o_MIDI_ElementShort = (MIDI_ElementShort)s_MIDI_ElementShortList.get(intElement);
            if (!o_MIDI_ElementShort.matchStatusByte(p_MessageBytes)) continue;
            if (p_MessageBytes.length < o_MIDI_ElementShort.getDataLength() + 1) {
                return s_MIDI_ElementShort_Undefined;
            }
            return o_MIDI_ElementShort;
        }
        return s_MIDI_ElementShort_Undefined;
    }

    public MIDI_ElementShort getMIDI_ElementShort() {
        return this.m_MIDI_ElementShort;
    }

    public void setManuallyMIDI_ElementShort(MIDI_ElementShort p_MIDI_ElementShort) {
        if (p_MIDI_ElementShort == null) {
            return;
        }
        this.m_Type = 1;
        if (this.m_MIDI_ElementShort == p_MIDI_ElementShort) {
            return;
        }
        int intShortChannel = this.getShortChannel();
        this.m_MIDI_ElementShort = p_MIDI_ElementShort;
        this.m_Bytes_Short[0] = p_MIDI_ElementShort.createStatusByte(intShortChannel);
        this.m_Bytes_ShortToSend[0] = this.m_Bytes_Short[0];
        this.m_TypeSub = p_MIDI_ElementShort == s_MIDI_ElementShort_Timecode ? 3 : 0;
    }

    public byte getShortStatusByte() {
        return MIDI_ElementShort.getStatusByte(this.m_Bytes_Short);
    }

    public void setShortStatusByte(byte p_StatusByte) {
        this.m_Type = 1;
        MIDI_ElementShort.setStatusByte(p_StatusByte, this.m_Bytes_Short);
        this.m_MIDI_ElementShort = this.findMIDI_ElementShort(this.m_Bytes_Short);
        this.m_TypeSub = this.m_MIDI_ElementShort == s_MIDI_ElementShort_Timecode ? 3 : 0;
    }

    public byte getShortCommandByte() {
        if (this.m_MIDI_ElementShort == null) {
            return 0;
        }
        return this.m_MIDI_ElementShort.getCommandByte();
    }

    public int getShortChannel() {
        if (this.m_MIDI_ElementShort == null) {
            return 0;
        }
        return this.m_MIDI_ElementShort.getChannel(this.m_Bytes_Short);
    }

    public void setShortChannel(int p_Channel) {
        this.m_Type = 1;
        if (this.m_MIDI_ElementShort == null) {
            return;
        }
        this.m_MIDI_ElementShort.setChannel(p_Channel, this.m_Bytes_Short);
        this.m_MIDI_ElementShort.setChannel(p_Channel, this.m_Bytes_ShortToSend);
    }

    public Byte getShortData1() {
        if (this.m_MIDI_ElementShort == null) {
            return (byte)0;
        }
        return this.m_MIDI_ElementShort.getData1(this.m_Bytes_Short);
    }

    public Byte getShortData1ToSend() {
        if (this.m_MIDI_ElementShort == null) {
            return (byte)0;
        }
        return this.m_MIDI_ElementShort.getData1(this.m_Bytes_ShortToSend);
    }

    public void setShortData1(byte p_Data1) {
        this.m_Type = 1;
        if (this.m_MIDI_ElementShort == null) {
            return;
        }
        this.m_MIDI_ElementShort.setData1(p_Data1, this.m_Bytes_Short);
        this.m_MIDI_ElementShort.setData1(p_Data1, this.m_Bytes_ShortToSend);
    }

    public Byte getShortData2() {
        if (this.m_MIDI_ElementShort == null) {
            return (byte)0;
        }
        return this.m_MIDI_ElementShort.getData2(this.m_Bytes_Short);
    }

    public Byte getShortData2ToSend() {
        if (this.m_MIDI_ElementShort == null) {
            return (byte)0;
        }
        return this.m_MIDI_ElementShort.getData2(this.m_Bytes_ShortToSend);
    }

    public void setShortData2(byte p_Data2) {
        this.m_Type = 1;
        if (this.m_MIDI_ElementShort == null) {
            return;
        }
        this.m_MIDI_ElementShort.setData2(p_Data2, this.m_Bytes_Short);
        this.m_MIDI_ElementShort.setData2(p_Data2, this.m_Bytes_ShortToSend);
    }

    private MIDI_ElementSysex findMIDI_ElementSysex(byte[] p_MessageBytes) {
        if (p_MessageBytes == null) {
            return s_MIDI_ElementSysex_Undefined;
        }
        if (p_MessageBytes.length < MIDI_ElementSysex.MINIMUM_MESSAGEBYTES) {
            return s_MIDI_ElementSysex_Undefined;
        }
        switch (p_MessageBytes[1]) {
            case 127: {
                for (int intElement = 0; intElement < s_SysexRealtimeList.size(); ++intElement) {
                    MIDI_ElementSysex o_MIDI_ElementSysex = (MIDI_ElementSysex)s_SysexRealtimeList.get(intElement);
                    if (!o_MIDI_ElementSysex.match(p_MessageBytes)) continue;
                    return o_MIDI_ElementSysex;
                }
                return s_MIDI_ElementSysex_RealtimeUndefined;
            }
            case 126: {
                for (int intElement = 0; intElement < s_SysexNonRealtimeList.size(); ++intElement) {
                    MIDI_ElementSysex o_MIDI_ElementSysex = (MIDI_ElementSysex)s_SysexNonRealtimeList.get(intElement);
                    if (!o_MIDI_ElementSysex.match(p_MessageBytes)) continue;
                    return o_MIDI_ElementSysex;
                }
                return s_MIDI_ElementSysex_NonRealtimeUndefined;
            }
            case 0: {
                return s_MIDI_ElementSysex_Undefined;
            }
        }
        return s_MIDI_ElementSysex_ManufacturerUndefined;
    }

    public MIDI_ElementSysex getMIDI_ElementSysex() {
        return this.m_MIDI_ElementSysex;
    }

    public void setManuallyMIDI_ElementSysex(MIDI_ElementSysex p_MIDI_ElementSysex) {
        if (p_MIDI_ElementSysex == null) {
            return;
        }
        this.m_Type = 2;
        if (this.m_MIDI_ElementSysex == p_MIDI_ElementSysex) {
            return;
        }
        this.m_MIDI_ElementSysex = p_MIDI_ElementSysex;
        this.m_Bytes_Sysex[1] = p_MIDI_ElementSysex.getManufucturer();
        this.m_Bytes_Sysex[3] = p_MIDI_ElementSysex.getSubID1();
        this.m_Bytes_SysexToSend[1] = p_MIDI_ElementSysex.getManufucturer();
        this.m_Bytes_SysexToSend[3] = p_MIDI_ElementSysex.getSubID1();
    }

    public byte getSysexManufacturer() {
        return MIDI_ElementSysex.getManufacturer(this.m_Bytes_Sysex);
    }

    public void setSysexManufacturer(byte p_Manufacturer) {
        this.m_Type = 2;
        this.m_Bytes_Sysex[1] = p_Manufacturer;
        this.m_Bytes_SysexToSend[1] = p_Manufacturer;
        this.m_MIDI_ElementSysex = this.findMIDI_ElementSysex(this.m_Bytes_Sysex);
        this.m_TypeSub = this.m_MIDI_ElementSysex == s_MIDI_ElementSysex_Timecode ? 3 : 0;
    }

    public byte getSysexDeviceID() {
        return MIDI_ElementSysex.getDeviceID(this.m_Bytes_Sysex);
    }

    public void setSysexDeviceID(byte p_DeviceID) {
        this.m_Type = 2;
        this.m_Bytes_Sysex[2] = p_DeviceID;
        this.m_Bytes_SysexToSend[2] = p_DeviceID;
    }

    public byte getSysexSubID1() {
        return MIDI_ElementSysex.getSubID1(this.m_Bytes_Sysex);
    }

    public void setSysexSubID1(byte p_SubID1) {
        this.m_Type = 2;
        this.m_Bytes_Sysex[3] = p_SubID1;
        this.m_Bytes_SysexToSend[3] = p_SubID1;
        this.m_MIDI_ElementSysex = this.findMIDI_ElementSysex(this.m_Bytes_Sysex);
    }

    public byte getSysexSubID2() {
        return MIDI_ElementSysex.getSubID2(this.m_Bytes_Sysex);
    }

    public void setSysexSubID2(byte p_SubID2) {
        this.m_Type = 2;
        this.m_Bytes_Sysex[4] = p_SubID2;
        this.m_Bytes_SysexToSend[4] = p_SubID2;
    }

    public String getSysexSubID2Name() {
        if (this.m_MIDI_ElementSysex == null) {
            return "";
        }
        return this.m_MIDI_ElementSysex.getSubID2Name(this.m_Bytes_Sysex);
    }

    public byte[] getSysexData() {
        return MIDI_ElementSysex.getDataBytes(this.m_Bytes_Sysex);
    }

    public void setSysexData(byte[] p_Data) {
        this.m_Type = 2;
        int intLength = p_Data == null || p_Data.length <= 0 ? 0 : p_Data.length;
        if (this.m_Bytes_Sysex.length == intLength) {
            MIDI_ElementSysex.setData(p_Data, this.m_Bytes_Sysex);
            MIDI_ElementSysex.setData(p_Data, this.m_Bytes_SysexToSend);
        } else {
            byte[] o_NewBytes = new byte[MIDI_ElementSysex.MINIMUM_MESSAGEBYTES + intLength];
            System.arraycopy(this.m_Bytes_Sysex, 0, o_NewBytes, 0, MIDI_ElementSysex.MINIMUM_MESSAGEBYTES - 1);
            o_NewBytes[o_NewBytes.length - 1] = -9;
            this.m_Bytes_Sysex = o_NewBytes;
            MIDI_ElementSysex.setData(p_Data, this.m_Bytes_Sysex);
            this.m_Bytes_SysexToSend = new byte[this.m_Bytes_Sysex.length];
            System.arraycopy(this.m_Bytes_Sysex, 0, this.m_Bytes_SysexToSend, 0, this.m_Bytes_Sysex.length);
        }
    }

    public void setManuallyMidiTimecode_Trigger(long p_Milliseconds) {
        if (p_Milliseconds >= 0L) {
            this.setManuallyMIDI_ElementShort(s_MIDI_ElementShort_Timecode);
            this.m_MidiTimecode.setTimeTrigger(p_Milliseconds);
        } else {
            this.m_MidiTimecode.setTimeTrigger(-1L);
        }
    }

    public void setMidiTimeCode_Trigger(long p_Milliseconds) {
        this.m_MidiTimecode.setTimeTrigger(p_Milliseconds);
    }

    public long getMidiTimecode_Trigger() {
        return this.m_MidiTimecode.getTimeTrigger();
    }

    public void setManuallyTimecode_ObjectStart(long p_Milliseconds) {
        this.m_MidiTimecode.setTime_ObjectStart(p_Milliseconds);
    }

    public void setMidiTimecode_ObjectStart(long p_Milliseconds) {
        this.m_MidiTimecode.setTime_ObjectStart(p_Milliseconds);
    }

    public long getMidiTimecode_ObjectStart() {
        return this.m_MidiTimecode.getTime_ObjectStart();
    }

    public void setManuallyUseTimecodeManual(boolean p_useManualTimecode) {
        this.setManuallyMIDI_ElementShort(s_MIDI_ElementShort_Timecode);
        if (this.m_MidiTimecode.getTimeTrigger() < 0L) {
            this.m_MidiTimecode.setTimeTrigger(0L);
        }
        this.m_MidiTimecode.setUseTimecodeManual(p_useManualTimecode);
    }

    public void setUseTimecodeManual(boolean p_useManualTimecode) {
        this.m_MidiTimecode.setUseTimecodeManual(p_useManualTimecode);
    }

    public boolean getUseTimecodeManual() {
        return this.m_MidiTimecode.getUseTimecodeManual();
    }

    public int getValueMax() {
        if (this.m_Type == 1) {
            if (this.m_MIDI_ElementShort == null) {
                return 0;
            }
            return this.m_MIDI_ElementShort.getValueMax();
        }
        if (this.m_Type == 2) {
            if (this.m_MIDI_ElementSysex == null) {
                return 0;
            }
            return this.m_MIDI_ElementSysex.getValueMax();
        }
        return 0;
    }

    public int getValue() {
        if (this.m_Type == 1) {
            if (this.m_MIDI_ElementShort == null) {
                return 0;
            }
            return this.m_MIDI_ElementShort.getValue(this.m_Bytes_Short);
        }
        if (this.m_Type == 2) {
            if (this.m_MIDI_ElementSysex == null) {
                return 0;
            }
            return this.m_MIDI_ElementSysex.getValue(this.m_Bytes_Sysex);
        }
        return 0;
    }

    public void setValueToSend(int p_Value) {
        if (this.m_Type == 1) {
            if (this.m_MIDI_ElementShort == null) {
                return;
            }
            this.m_MIDI_ElementShort.setValue(p_Value, this.m_Bytes_ShortToSend);
        } else if (this.m_Type == 2) {
            if (this.m_MIDI_ElementSysex == null) {
                return;
            }
            this.m_MIDI_ElementSysex.setValue(p_Value, this.m_Bytes_SysexToSend);
        }
    }

    public void setUseTriggerObjectValue(boolean p_UseValue) {
        this.m_TriggerUseObjectValue = p_UseValue;
    }

    public boolean getUseTriggerObjectValue() {
        return this.m_TriggerUseObjectValue;
    }

    public String getMessageBytesString() {
        if (this.m_Type == 1) {
            return MidiTools.getStringFromByteArray(this.m_Bytes_Short, true);
        }
        return MidiTools.getStringFromByteArray(this.m_Bytes_Sysex, true);
    }

    static {
        s_SysexRealtimeList = new TableAndListModel.ListModel(false);
        s_SysexNonRealtimeList = new TableAndListModel.ListModel(false);
        s_ELementsFilled = MIDI_MessageObject.fillElements();
    }

    public static interface MessageContainer {
        public void setMidiObjectPosition(int var1);

        public MIDI_MessageObject getMIDI_MessageObject();

        public void setMessageBytes(byte[] var1);

        public byte[] getMessageBytes();

        public void setMidiTimecode_Trigger(long var1);

        public long getMidiTimecode_Trigger();

        public void setMidiTimecode_ObjectStart(long var1);

        public long getMidiTimecode_ObjectStart();

        public void setUseTimecodeManual(boolean var1);

        public boolean getUseTimecodeManual();

        public void setSPITOperator(int var1);

        public int getSPITOperator();

        public void setSPITThreshhold(float var1);

        public void setSPITThreshhold(int var1);

        public float getSPITTreshhold();

        public float getSPITTreshhold_Float();

        public void setSPITValueUsage(int var1);

        public int getSPITValueUsage();

        public void setSPITInDecreasePC(float var1);

        public float getSPITInDecreasePC();

        public void setUseTriggerObjectValue(boolean var1);

        public boolean getUseTriggerObjectValue();

        public void addPropertyChangeListener(PropertyChangeListener var1);

        public void removePropertyChangeListener(PropertyChangeListener var1);

        public boolean isSet();
    }

    public static class MIDI_ElementSysex_MOBILEPHONE
    extends MIDI_ElementSysex_Realtime {
        public static String s_Name = "MobilePhone";

        public MIDI_ElementSysex_MOBILEPHONE() {
            super((byte)12);
        }

        @Override
        public String getName() {
            return s_Name;
        }
    }

    public static class MIDI_ElementSysex_SCALABLEPOLYPHONY
    extends MIDI_ElementSysex_Realtime {
        public static String s_Name = "ScalablePolyphony";

        public MIDI_ElementSysex_SCALABLEPOLYPHONY() {
            super((byte)11);
        }

        @Override
        public String getName() {
            return s_Name;
        }
    }

    public static class MIDI_ElementSysex_KEYBASEDINSTRUMENT
    extends MIDI_ElementSysex_Realtime {
        public static String s_Name = "KeyBasedInstrument";

        public MIDI_ElementSysex_KEYBASEDINSTRUMENT() {
            super((byte)10);
        }

        @Override
        public String getName() {
            return s_Name;
        }
    }

    public static class MIDI_ElementSysex_CONTROLLERDESTINATION
    extends MIDI_ElementSysex_Realtime {
        public static String s_Name = "ControllerDestination";

        public MIDI_ElementSysex_CONTROLLERDESTINATION() {
            super((byte)9);
        }

        @Override
        public String getName() {
            return s_Name;
        }
    }

    public static class MIDI_ElementSysex_MIDITUNING
    extends MIDI_ElementSysex_Realtime {
        public static String s_Name = "MIDITUNING";

        public MIDI_ElementSysex_MIDITUNING() {
            super((byte)8);
        }

        @Override
        public String getName() {
            return s_Name;
        }
    }

    public static class MIDI_ElementSysex_MMCRESPONSE
    extends MIDI_ElementSysex_Realtime {
        public static String s_Name = "MMC RESPONSE";

        public MIDI_ElementSysex_MMCRESPONSE() {
            super((byte)7);
        }

        @Override
        public String getName() {
            return s_Name;
        }
    }

    public static class MIDI_ElementSysex_MMC
    extends MIDI_ElementSysex_Realtime {
        public static String s_Name = "MMC MidiMachineControl";

        public MIDI_ElementSysex_MMC() {
            super((byte)6);
        }

        @Override
        public String getName() {
            return s_Name;
        }
    }

    public static class MIDI_ElementSysex_MTC
    extends MIDI_ElementSysex_Realtime {
        public static String s_Name = "RealTime MTC Cueing";

        public MIDI_ElementSysex_MTC() {
            super((byte)5);
        }

        @Override
        public String getName() {
            return s_Name;
        }
    }

    public static class MIDI_ElementSysex_DEVICECONTROL
    extends MIDI_ElementSysex_Realtime {
        public static String s_Name = "DEVICECONTROL";

        public MIDI_ElementSysex_DEVICECONTROL() {
            super((byte)4);
            this.m_ValueMax = 16383;
        }

        @Override
        public String getName() {
            return s_Name;
        }

        @Override
        public String getSubID2Name(byte[] p_MessageBytes) {
            if (p_MessageBytes == null || p_MessageBytes.length < MINIMUM_MESSAGEBYTES) {
                return "";
            }
            switch (p_MessageBytes[4]) {
                case 1: {
                    return "MasterVolume";
                }
                case 2: {
                    return "MasterBalance";
                }
                case 3: {
                    return "MasterFineTuning";
                }
                case 4: {
                    return "MasterCoarseTuning";
                }
                case 5: {
                    return "GlobalParameterControl";
                }
            }
            return "";
        }

        @Override
        public int getValueMax() {
            return this.m_ValueMax;
        }

        @Override
        public int getValue(byte[] p_MessageBytes) {
            if (p_MessageBytes == null || p_MessageBytes.length < MINIMUM_MESSAGEBYTES + 2) {
                return 0;
            }
            if (this.m_ValueMax <= 0) {
                return 0;
            }
            int intValue = 128 * (p_MessageBytes[6] & 0xFF);
            return intValue += p_MessageBytes[5] & 0xFF;
        }

        @Override
        public void setValue(int p_Value, byte[] p_MessageBytes) {
            if (p_MessageBytes == null || p_MessageBytes.length < MINIMUM_MESSAGEBYTES + 2) {
                return;
            }
            if (this.m_ValueMax <= 0) {
                return;
            }
            if (p_Value < 0) {
                p_Value = 0;
            }
            if (p_Value > this.m_ValueMax) {
                p_Value = this.m_ValueMax;
            }
            int intValue = p_Value;
            p_MessageBytes[6] = (byte)((intValue /= 128) & 0xFF);
            intValue = p_Value - 128 * intValue;
            p_MessageBytes[5] = (byte)(intValue & 0xFF);
        }
    }

    public static class MIDI_ElementSysex_NOTATION
    extends MIDI_ElementSysex_Realtime {
        public static String s_Name = "NOTATION";

        public MIDI_ElementSysex_NOTATION() {
            super((byte)3);
        }

        @Override
        public String getName() {
            return s_Name;
        }
    }

    public static class MIDI_ElementSysex_MSC
    extends MIDI_ElementSysex_Realtime {
        public static String s_Name = "MSC MidiShowControl";

        public MIDI_ElementSysex_MSC() {
            super((byte)2);
        }

        @Override
        public String getName() {
            return s_Name;
        }
    }

    public static class MIDI_ElementSysex_MIDITIMECODE
    extends MIDI_ElementSysex_Realtime {
        public static String s_Name = "MIDI TIME CODE";

        public MIDI_ElementSysex_MIDITIMECODE() {
            super((byte)1);
        }

        @Override
        public String getName() {
            return s_Name;
        }
    }

    public static class MIDI_ElementSysex_Realtime
    extends MIDI_ElementSysex {
        public MIDI_ElementSysex_Realtime(byte p_SubID1) {
            super((byte)127, p_SubID1);
            s_SysexRealtimeList.add((Object)this);
        }
    }

    public static class MIDI_ElementSysex_NonRealtime
    extends MIDI_ElementSysex {
        public MIDI_ElementSysex_NonRealtime(byte p_SubID1) {
            super((byte)126, p_SubID1);
            s_SysexNonRealtimeList.add((Object)this);
        }
    }

    public static class MIDI_ElementSysex_Manufacturer
    extends MIDI_ElementSysex {
        public MIDI_ElementSysex_Manufacturer(byte p_SubID1) {
            super((byte)1, p_SubID1);
        }

        @Override
        public boolean match(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return false;
            }
            if (p_MessageBytes.length < MINIMUM_MESSAGEBYTES) {
                return false;
            }
            if (p_MessageBytes[3] != this.m_SubID1) {
                return false;
            }
            return this.matchSubID2(p_MessageBytes);
        }
    }

    public static class MIDI_ElementSysex {
        public static int MINIMUM_MESSAGEBYTES = 6;
        protected byte m_Manufacturer;
        protected byte m_SubID1;
        protected int m_ValueMax;

        public static byte getManufacturer(byte[] p_MessageBytes) {
            if (p_MessageBytes == null || p_MessageBytes.length < MINIMUM_MESSAGEBYTES) {
                return 0;
            }
            return p_MessageBytes[1];
        }

        public static void setManufacturer(byte p_Manufacturer, byte[] p_MessageBytes) {
            if (p_MessageBytes == null || p_MessageBytes.length < MINIMUM_MESSAGEBYTES) {
                return;
            }
            p_MessageBytes[1] = p_Manufacturer;
        }

        public static byte getDeviceID(byte[] p_MessageBytes) {
            if (p_MessageBytes == null || p_MessageBytes.length < MINIMUM_MESSAGEBYTES) {
                return 0;
            }
            return p_MessageBytes[2];
        }

        public static void setDeviceID(byte p_DeviceID, byte[] p_MessageBytes) {
            if (p_MessageBytes == null || p_MessageBytes.length < MINIMUM_MESSAGEBYTES) {
                return;
            }
            p_MessageBytes[2] = p_DeviceID;
        }

        public static byte getSubID1(byte[] p_MessageBytes) {
            if (p_MessageBytes == null || p_MessageBytes.length < MINIMUM_MESSAGEBYTES) {
                return 0;
            }
            return p_MessageBytes[3];
        }

        public static void setSubID1(byte p_SubID1, byte[] p_MessageBytes) {
            if (p_MessageBytes == null || p_MessageBytes.length < MINIMUM_MESSAGEBYTES) {
                return;
            }
            p_MessageBytes[3] = p_SubID1;
        }

        public static byte getSubID2(byte[] p_MessageBytes) {
            if (p_MessageBytes == null || p_MessageBytes.length < MINIMUM_MESSAGEBYTES) {
                return 0;
            }
            return p_MessageBytes[4];
        }

        public static void setSubID2(byte p_SubID2, byte[] p_MessageBytes) {
            if (p_MessageBytes == null || p_MessageBytes.length < MINIMUM_MESSAGEBYTES) {
                return;
            }
            p_MessageBytes[4] = p_SubID2;
        }

        public static byte[] getDataBytes(byte[] p_MessageBytes) {
            if (p_MessageBytes == null || p_MessageBytes.length < 6) {
                return null;
            }
            if (p_MessageBytes.length == MINIMUM_MESSAGEBYTES) {
                return new byte[0];
            }
            byte[] o_DataBytes = new byte[p_MessageBytes.length - MINIMUM_MESSAGEBYTES];
            System.arraycopy(p_MessageBytes, 5, o_DataBytes, 0, p_MessageBytes.length - MINIMUM_MESSAGEBYTES);
            return o_DataBytes;
        }

        public static void setData(byte[] p_Data, byte[] p_MessageBytes) {
            if (p_MessageBytes == null || p_MessageBytes.length < MINIMUM_MESSAGEBYTES) {
                return;
            }
            if (p_Data == null) {
                return;
            }
            int intBytesToCopy = 0;
            int intNullBytes = 0;
            if (p_Data.length == p_MessageBytes.length - MINIMUM_MESSAGEBYTES) {
                intBytesToCopy = p_Data.length;
            } else if (p_Data.length > p_MessageBytes.length - MINIMUM_MESSAGEBYTES) {
                intBytesToCopy = p_MessageBytes.length - MINIMUM_MESSAGEBYTES;
            } else if (p_Data.length < p_MessageBytes.length - MINIMUM_MESSAGEBYTES) {
                intBytesToCopy = p_Data.length;
                intNullBytes = p_MessageBytes.length - MINIMUM_MESSAGEBYTES - intBytesToCopy;
            }
            if (intBytesToCopy > 0) {
                System.arraycopy(p_Data, 0, p_MessageBytes, 5, intBytesToCopy);
            }
            if (intNullBytes > 0) {
                for (int intByte = 0; intByte < intNullBytes; ++intByte) {
                    p_MessageBytes[5 + intBytesToCopy + intByte] = 0;
                }
            }
        }

        public MIDI_ElementSysex(byte p_Manufacturer, byte p_SubID1) {
            this.initMembers();
            this.m_Manufacturer = p_Manufacturer;
            this.m_SubID1 = p_SubID1;
        }

        private void initMembers() {
            this.m_ValueMax = 0;
            this.m_Manufacturer = 0;
            this.m_SubID1 = 0;
        }

        public String getName() {
            return "Undefined";
        }

        public String getSubID2Name(byte[] p_MessageBytes) {
            return "";
        }

        public byte getManufucturer() {
            return this.m_Manufacturer;
        }

        public byte getSubID1() {
            return this.m_SubID1;
        }

        public boolean match(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return false;
            }
            if (p_MessageBytes.length < MINIMUM_MESSAGEBYTES) {
                return false;
            }
            if (p_MessageBytes[1] != this.m_Manufacturer) {
                return false;
            }
            if (p_MessageBytes[3] != this.m_SubID1) {
                return false;
            }
            return this.matchSubID2(p_MessageBytes);
        }

        public boolean matchSubID2(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return false;
            }
            return p_MessageBytes.length >= MINIMUM_MESSAGEBYTES;
        }

        public int getValueMax() {
            return this.m_ValueMax;
        }

        public int getValue(byte[] p_MessageBytes) {
            return 0;
        }

        public void setValue(int p_Value, byte[] p_MessageBytes) {
        }
    }

    public static class MIDI_ElementShort {
        private int m_StatusByte;
        private String m_Name;
        private int m_DataLength;
        private boolean m_HasChannel;
        private int m_ValueMax;

        public static byte getStatusByte(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return 0;
            }
            if (p_MessageBytes.length < 1) {
                return 0;
            }
            return (byte)(p_MessageBytes[0] & 0xFF);
        }

        public static void setStatusByte(byte p_StatusByte, byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return;
            }
            if (p_MessageBytes.length < 1) {
                return;
            }
            p_MessageBytes[0] = p_StatusByte;
        }

        public MIDI_ElementShort(int p_StatusByte, String p_Description) {
            this.initMembers();
            this.getDataLength(p_StatusByte);
            if (p_Description == null) {
                p_Description = "";
            }
            this.m_Name = p_Description;
            s_MIDI_ElementShortList.add((Object)this);
        }

        private void initMembers() {
            this.m_Name = "";
            this.m_DataLength = 0;
            this.m_HasChannel = false;
            this.m_ValueMax = 0;
        }

        protected final void getDataLength(int p_StatusByte) {
            switch (p_StatusByte & 0xFF) {
                case 249: 
                case 253: {
                    this.m_StatusByte = 0;
                    this.m_HasChannel = false;
                    this.m_DataLength = 0;
                    return;
                }
                case 246: 
                case 247: 
                case 248: 
                case 250: 
                case 251: 
                case 252: 
                case 254: 
                case 255: {
                    this.m_StatusByte = p_StatusByte;
                    this.m_HasChannel = false;
                    this.m_DataLength = 0;
                    return;
                }
                case 241: 
                case 243: {
                    this.m_StatusByte = p_StatusByte;
                    this.m_HasChannel = false;
                    this.m_DataLength = 1;
                    return;
                }
                case 242: {
                    this.m_StatusByte = p_StatusByte;
                    this.m_HasChannel = false;
                    this.m_DataLength = 2;
                    return;
                }
            }
            this.m_DataLength = 0;
            this.m_HasChannel = false;
            this.m_StatusByte = 0;
            switch (p_StatusByte & 0xF0) {
                case 128: 
                case 144: 
                case 160: 
                case 176: 
                case 224: {
                    this.m_StatusByte = p_StatusByte & 0xF0;
                    this.m_HasChannel = true;
                    this.m_DataLength = 2;
                    this.m_ValueMax = p_StatusByte == 224 ? 16383 : 127;
                    return;
                }
                case 192: 
                case 208: {
                    this.m_StatusByte = p_StatusByte & 0xF0;
                    this.m_HasChannel = true;
                    this.m_DataLength = 1;
                    return;
                }
            }
            this.m_StatusByte = 0;
            this.m_HasChannel = false;
            this.m_DataLength = 0;
        }

        public String getName() {
            return this.m_Name;
        }

        public boolean matchStatusByte(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return false;
            }
            if (p_MessageBytes.length < 1) {
                return false;
            }
            if ((p_MessageBytes[0] & 0xFF) == this.m_StatusByte) {
                return true;
            }
            return (p_MessageBytes[0] & 0xF0) == this.m_StatusByte;
        }

        public boolean hasChannel() {
            return this.m_HasChannel;
        }

        public int getChannel(byte[] p_MessageBytes) {
            if (!this.m_HasChannel) {
                return 0;
            }
            if (p_MessageBytes == null || p_MessageBytes.length <= 0) {
                return 0;
            }
            return (p_MessageBytes[0] & 0xF) + 1;
        }

        public void setChannel(int p_Channel, byte[] p_MessageBytes) {
            if (!this.m_HasChannel) {
                return;
            }
            if (p_MessageBytes == null) {
                return;
            }
            if (p_MessageBytes.length < 1) {
                return;
            }
            if (p_Channel < 1) {
                p_Channel = 1;
            }
            if (p_Channel > 16) {
                p_Channel = 16;
            }
            p_MessageBytes[0] = (byte)(p_MessageBytes[0] & 0xF0 | p_Channel - 1 & 0xF);
        }

        public byte getCommandByte() {
            if (!this.m_HasChannel) {
                return (byte)(this.m_StatusByte & 0xFF);
            }
            return (byte)(this.m_StatusByte & 0xF0);
        }

        public byte getData1(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return 0;
            }
            if (p_MessageBytes.length < 2) {
                return 0;
            }
            if (this.getDataLength() < 1) {
                return 0;
            }
            return (byte)(p_MessageBytes[1] & 0xFF);
        }

        public void setData1(byte p_Data1, byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return;
            }
            if (p_MessageBytes.length < 2) {
                return;
            }
            p_MessageBytes[1] = p_Data1;
        }

        public byte getData2(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return 0;
            }
            if (p_MessageBytes.length < 3) {
                return 0;
            }
            if (this.getDataLength() < 2) {
                return 0;
            }
            return (byte)(p_MessageBytes[2] & 0xFF);
        }

        public void setData2(byte p_Data2, byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return;
            }
            if (p_MessageBytes.length < 3) {
                return;
            }
            p_MessageBytes[2] = p_Data2;
        }

        public byte createStatusByte(int p_Channel) {
            if (!this.m_HasChannel) {
                return (byte)(this.m_StatusByte & 0xFF);
            }
            if (p_Channel < 1 || p_Channel > 16) {
                p_Channel = 1;
            }
            return (byte)((this.m_StatusByte & 0xF0 | p_Channel - 1 & 0xF) & 0xFF);
        }

        public int getDataLength() {
            return this.m_DataLength;
        }

        public int getValueMax() {
            return this.m_ValueMax;
        }

        public int getValue(byte[] p_MessageBytes) {
            int intValue;
            if (p_MessageBytes == null || p_MessageBytes.length < 3) {
                return 0;
            }
            if (this.m_ValueMax <= 0) {
                intValue = 0;
            } else if (this.m_ValueMax > 127) {
                intValue = p_MessageBytes[2] & 0xFF;
                intValue *= 128;
                intValue += p_MessageBytes[1] & 0xFF;
            } else {
                intValue = p_MessageBytes[2] & 0xFF;
            }
            return intValue;
        }

        public void setValue(int p_Value, byte[] p_MessageBytes) {
            if (p_MessageBytes == null || p_MessageBytes.length < 3) {
                return;
            }
            if (this.m_ValueMax <= 0) {
                return;
            }
            if (p_Value > this.m_ValueMax) {
                p_Value = this.m_ValueMax;
            }
            if (p_Value < 0) {
                p_Value = 0;
            }
            if (this.m_ValueMax > 127) {
                int intValue = p_Value / 128;
                p_MessageBytes[2] = (byte)(intValue & 0xFF);
                intValue = p_Value - intValue * 128;
                p_MessageBytes[1] = (byte)(intValue & 0xFF);
            } else {
                p_MessageBytes[2] = (byte)(p_Value & 0xFF);
            }
        }
    }
}

