/*
 * Decompiled with CFR 0.152.
 */
package SwingTextPackage;

import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;

public class DocumentFilter_Double
extends DocumentFilter {
    private boolean m_AllowNegativeNumbers;
    private boolean m_AllowEmptyString;
    private AbstractDocument m_AbstractDocument;

    public DocumentFilter_Double(AbstractDocument p_Document) {
        this.initMembers();
        this.m_AbstractDocument = p_Document;
        if (p_Document != null) {
            p_Document.setDocumentFilter(this);
        }
    }

    public DocumentFilter_Double(JTextComponent p_TextComponent) {
        this.initMembers();
        AbstractDocument o_AbstractDocument = p_TextComponent == null ? null : (AbstractDocument)p_TextComponent.getDocument();
        this.m_AbstractDocument = o_AbstractDocument;
        if (o_AbstractDocument != null) {
            o_AbstractDocument.setDocumentFilter(this);
        }
    }

    private void initMembers() {
        this.m_AllowEmptyString = false;
        this.m_AllowNegativeNumbers = true;
    }

    public AbstractDocument getDocument() {
        return this.m_AbstractDocument;
    }

    public void setAllowEmptyString(boolean p_AllowEmptyString) {
        this.m_AllowEmptyString = p_AllowEmptyString;
    }

    public void setAllowNegativeNumbers(boolean p_AllowNegativeNumbers) {
        this.m_AllowNegativeNumbers = p_AllowNegativeNumbers;
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass p_FilterBypass, int p_Offset, String p_String, AttributeSet p_AttributeSet) throws BadLocationException {
        if (p_String == null) {
            return;
        }
        try {
            String stringDocument;
            AbstractDocument o_Document = (AbstractDocument)p_FilterBypass.getDocument();
            if (o_Document == null) {
                return;
            }
            if (!this.m_AllowNegativeNumbers && p_String.contains("-")) {
                return;
            }
            int intDocumentLength = o_Document.getLength();
            if (intDocumentLength <= 0) {
                stringDocument = p_String;
            } else {
                stringDocument = o_Document.getText(0, o_Document.getLength());
                stringDocument = stringDocument.substring(0, p_Offset) + p_String + stringDocument.substring(p_Offset, stringDocument.length());
            }
            if (stringDocument.length() <= 0 && this.m_AllowEmptyString) {
                super.insertString(p_FilterBypass, p_Offset, p_String, p_AttributeSet);
                return;
            }
            double doubleValue = Double.parseDouble(stringDocument);
            if (doubleValue < 0.0 && !this.m_AllowNegativeNumbers) {
                return;
            }
            super.insertString(p_FilterBypass, p_Offset, p_String, p_AttributeSet);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void replace(DocumentFilter.FilterBypass p_FilterBypass, int p_Offset, int p_Length, String p_String, AttributeSet p_AttributeSet) throws BadLocationException {
        if (p_String == null) {
            return;
        }
        try {
            String stringDocument;
            AbstractDocument o_Document = (AbstractDocument)p_FilterBypass.getDocument();
            if (o_Document == null) {
                return;
            }
            if (!this.m_AllowNegativeNumbers && p_String.contains("-")) {
                return;
            }
            int intDocumentLenght = o_Document.getLength();
            stringDocument = intDocumentLenght <= 0 ? p_String : (p_Offset + p_Length <= (stringDocument = o_Document.getText(0, intDocumentLenght)).length() ? stringDocument.substring(0, p_Offset) + p_String + stringDocument.substring(p_Offset + p_Length) : stringDocument.substring(0, p_Offset) + p_String);
            if (stringDocument.length() <= 0 && this.m_AllowEmptyString) {
                super.replace(p_FilterBypass, p_Offset, p_Length, p_String, p_AttributeSet);
                return;
            }
            if (stringDocument.length() == 1 && "-".equals(stringDocument)) {
                if (!this.m_AllowNegativeNumbers) {
                    return;
                }
                super.replace(p_FilterBypass, p_Offset, p_Length, p_String, p_AttributeSet);
                return;
            }
            double doubleValue = Double.parseDouble(stringDocument);
            if (doubleValue < 0.0 && !this.m_AllowNegativeNumbers) {
                return;
            }
            if (p_Length > intDocumentLenght) {
                return;
            }
            super.replace(p_FilterBypass, p_Offset, p_Length, p_String, p_AttributeSet);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Double getValue(String p_ValueString) {
        try {
            double doubleValue = Double.valueOf(p_ValueString);
            return doubleValue;
        }
        catch (Exception e) {
            return null;
        }
    }
}

