#!/bin/bash
#This script installs the liveSHOW software

#---- Declare path settings ----

SOURCE_APPFOLDER="LiveShow_MediaServer"
SOURCE_APPPATH=`dirname "$0"`

DEST_APPNAME="liveSHOW_Media"
DEST_APPFOLDER="$SOURCE_APPFOLDER"
DEST_APPSPATH="$HOME/.local/share/liveSHOWApps"

#Path to applications menu
DEST_MENUPATH="$HOME/.local/share/applications"
#Path to Desktop
desktopVar=$(cat $HOME/.config/user-dirs.dirs | grep "XDG_DESKTOP_DIR")
DEST_DESKTOPPATH="${desktopVar[@]/XDG_DESKTOP_DIR='"$HOME'/$HOME}"
DEST_DESKTOPPATH="${DEST_DESKTOPPATH[@]/'"'/''}"
#Path to autostart
DEST_AUTOSTARTPATH="$HOME/.config/autostart"

mkdir "$DEST_AUTOSTARTPATH"

DESKTOP_FILE="$DEST_AUTOSTARTPATH/$DEST_APPNAME.desktop"

cat > $DESKTOP_FILE << EOM
[Desktop Entry]
Version=1.0
Name=$DEST_APPNAME
Comment=Start $DEST_APPNAME
Icon=$DEST_APPSPATH/$DEST_APPFOLDER/icon.png
Exec=bash -c "sleep 60 && '$DEST_APPSPATH/$DEST_APPFOLDER/Start.sh'"
Type=Application
StartupNotify=false
Terminal=false
Categories=AudioVideo
EOM

#---- Make Start.sh executable ----
chmod +x $DEST_AUTOSTARTPATH/$DEST_APPNAME.desktop

#---- Copy desktop file to autostart ----

cp "$DESKTOP_FILE" "$DEST_AUTOSTARTPATH"

echo "$DEST_APPNAME autostart enabled"
