#!/bin/bash
#This script installs the liveSHOW software

#---- Declare path settings ----

SOURCE_APPFOLDER="LiveShow_MediaServer"
SOURCE_APPPATH=`dirname "$0"`

DEST_APPNAME="liveSHOW_Media"
DEST_APPFOLDER="$SOURCE_APPFOLDER"
DEST_APPSPATH="$HOME/.local/share/liveSHOWApps"

#Path to applications menu
DEST_MENUPATH="$HOME/.local/share/applications"
#Path to Desktop
desktopVar=$(cat $HOME/.config/user-dirs.dirs | grep "XDG_DESKTOP_DIR")
DEST_DESKTOPPATH="${desktopVar[@]/XDG_DESKTOP_DIR='"$HOME'/$HOME}"
DEST_DESKTOPPATH="${DEST_DESKTOPPATH[@]/'"'/''}"
#Path to autostart
DEST_AUTOSTARTPATH="$HOME/.config/autostart"

#---- Remove the program files ----

echo "Remove app directory from $SOURCE_APPPATH/$SOURCE_APPFOLDER to $DEST_APPSPATH"
rm -r $DEST_APPSPATH/$DEST_APPFOLDER


#---- remove desktopfile from autostart ----
echo "remove .desktop file from menu: $DEST_AUTOSTARTPATH"
rm $DEST_AUTOSTARTPATH/$DEST_APPNAME.desktop
#---- remove desktopfile from menu ----
echo "remove .desktop file from menu: $DEST_MENUPATH"
rm $DEST_MENUPATH/$DEST_APPNAME.desktop
#---- remove desktopfile from desktop ----
echo "remove .desktop file to desktop: $DEST_DESKTOPPATH"
rm $DEST_DESKTOPPATH/$DEST_APPNAME.desktop

echo "$DEST_APPNAME sucessfully removed"
