/*
 * Decompiled with CFR 0.152.
 */
package SwingTextPackage;

import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;

public class DocumentFilter_Time
extends DocumentFilter {
    private boolean m_AllowNegativeTime;

    public DocumentFilter_Time(AbstractDocument p_Document) {
        if (p_Document != null) {
            p_Document.setDocumentFilter(this);
        }
    }

    public DocumentFilter_Time(JTextComponent p_TextComponent) {
        AbstractDocument o_AbstractDocument = p_TextComponent == null ? null : (AbstractDocument)p_TextComponent.getDocument();
        if (o_AbstractDocument != null) {
            o_AbstractDocument.setDocumentFilter(this);
        }
    }

    private void initMembers() {
        this.m_AllowNegativeTime = false;
    }

    public void setAllowNegativeTime(boolean p_AllowNegativeTime) {
        this.m_AllowNegativeTime = p_AllowNegativeTime;
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass p_FilterBypass, int p_Offset, String p_String, AttributeSet p_AttributeSet) throws BadLocationException {
        if (p_String == null) {
            return;
        }
        try {
            AbstractDocument o_Document = (AbstractDocument)p_FilterBypass.getDocument();
            if (o_Document == null) {
                return;
            }
            if (!this.m_AllowNegativeTime && p_String.contains("-")) {
                return;
            }
            String[] stringArray = p_String.split(":");
            for (int intString = 0; intString < stringArray.length; ++intString) {
                String stringPart = stringArray[intString];
                if (DocumentFilter_Time.isNumeric_Integer(stringPart)) continue;
                return;
            }
            String stringDocument = o_Document.getText(0, o_Document.getLength());
            stringDocument = stringDocument.substring(0, p_Offset) + p_String + stringDocument.substring(p_Offset, stringDocument.length());
            long longValue = DocumentFilter_Time.getMillisecondsFromString(stringDocument);
            if (!this.m_AllowNegativeTime && longValue < 0L) {
                return;
            }
            super.insertString(p_FilterBypass, p_Offset, p_String, p_AttributeSet);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public void replace(DocumentFilter.FilterBypass p_FilterBypass, int p_Offset, int p_Length, String p_String, AttributeSet p_AttributeSet) throws BadLocationException {
        if (p_String == null) {
            return;
        }
        try {
            AbstractDocument o_Document = (AbstractDocument)p_FilterBypass.getDocument();
            if (o_Document == null) {
                return;
            }
            if (!this.m_AllowNegativeTime && p_String.contains("-")) {
                return;
            }
            String[] stringArray = p_String.split(":");
            for (int intString = 0; intString < stringArray.length; ++intString) {
                String stringPart = stringArray[intString];
                if (DocumentFilter_Time.isNumeric_Integer(stringPart)) continue;
                return;
            }
            String stringDocument = o_Document.getText(0, o_Document.getLength());
            stringDocument = stringDocument.substring(0, p_Offset) + p_String + stringDocument.substring(p_Offset + p_Length);
            long longValue = DocumentFilter_Time.getMillisecondsFromString(stringDocument);
            if (!this.m_AllowNegativeTime && longValue < 0L) {
                return;
            }
            super.replace(p_FilterBypass, p_Offset, p_Length, p_String, p_AttributeSet);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public static boolean isNumeric_Integer(String p_String) {
        if (p_String == null) {
            return false;
        }
        try {
            int intValue = Integer.parseInt(p_String);
            if (intValue >= 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static String getTimeStringFromMillis(long p_Milliseconds) {
        if (p_Milliseconds < 0L) {
            return "?";
        }
        StringBuilder o_StringBuffer_Temp = new StringBuilder();
        StringBuilder o_StringBuffer_Time = new StringBuilder();
        boolean boolSetString = false;
        int intHours = (int)(p_Milliseconds / 3600000L);
        p_Milliseconds -= (long)(intHours * 3600000);
        if (boolSetString || intHours > 0) {
            o_StringBuffer_Temp.delete(0, o_StringBuffer_Temp.length());
            o_StringBuffer_Temp.append("00");
            o_StringBuffer_Temp.append(intHours);
            o_StringBuffer_Time.append(o_StringBuffer_Temp.substring(o_StringBuffer_Temp.length() - 2, o_StringBuffer_Temp.length()));
            o_StringBuffer_Time.append(":");
            boolSetString = true;
        }
        int intMinutes = (int)(p_Milliseconds / 60000L);
        p_Milliseconds -= (long)(intMinutes * 60000);
        if (boolSetString || intMinutes > 0) {
            o_StringBuffer_Temp.delete(0, o_StringBuffer_Temp.length());
            o_StringBuffer_Temp.append("00");
            o_StringBuffer_Temp.append(intMinutes);
            o_StringBuffer_Time.append(o_StringBuffer_Temp.substring(o_StringBuffer_Temp.length() - 2, o_StringBuffer_Temp.length()));
            o_StringBuffer_Time.append(":");
            boolSetString = true;
        }
        int intSeconds = (int)(p_Milliseconds / 1000L);
        p_Milliseconds -= (long)(intSeconds * 1000);
        if (boolSetString || intSeconds > 0) {
            o_StringBuffer_Temp.delete(0, o_StringBuffer_Temp.length());
            o_StringBuffer_Temp.append("00");
            o_StringBuffer_Temp.append(intSeconds);
            o_StringBuffer_Time.append(o_StringBuffer_Temp.substring(o_StringBuffer_Temp.length() - 2, o_StringBuffer_Temp.length()));
            o_StringBuffer_Time.append(":");
            boolSetString = true;
        }
        int intMilliseconds = (int)p_Milliseconds;
        o_StringBuffer_Temp.delete(0, o_StringBuffer_Temp.length());
        o_StringBuffer_Temp.append("000");
        o_StringBuffer_Temp.append(intMilliseconds);
        o_StringBuffer_Time.append(o_StringBuffer_Temp.substring(o_StringBuffer_Temp.length() - 3, o_StringBuffer_Temp.length()));
        return o_StringBuffer_Time.toString();
    }

    public static long getMillisecondsFromString(String p_TimeString) {
        if (p_TimeString == null || p_TimeString.length() <= 0) {
            return 0L;
        }
        long longMilliseconds = 0L;
        int intSeconds = 0;
        int intMinutes = 0;
        int intHours = 0;
        try {
            String[] arrayTimeString = p_TimeString.split(":");
            if (arrayTimeString.length >= 1) {
                longMilliseconds += (long)Integer.valueOf(arrayTimeString[arrayTimeString.length - 1].trim()).intValue();
            }
            if (arrayTimeString.length >= 2) {
                intSeconds = Integer.valueOf(arrayTimeString[arrayTimeString.length - 2].trim());
                longMilliseconds += (long)(intSeconds * 1000);
            }
            if (arrayTimeString.length >= 3) {
                intMinutes = Integer.valueOf(arrayTimeString[arrayTimeString.length - 3].trim());
                longMilliseconds += (long)(intMinutes * 60000);
            }
            if (arrayTimeString.length >= 4) {
                intHours = Integer.valueOf(arrayTimeString[arrayTimeString.length - 4].trim());
                longMilliseconds += (long)(intHours * 3600000);
            }
        }
        catch (Exception e) {
            longMilliseconds = 0L;
        }
        return longMilliseconds;
    }

    public static String getTimeStringFromFrames(long p_Frames, double p_FramesPerSecond) {
        if (p_FramesPerSecond <= 0.0) {
            return DocumentFilter_Time.getTimeStringFromMillis(0L);
        }
        return DocumentFilter_Time.getTimeStringFromMillis((long)(1000.0 * (double)p_Frames / p_FramesPerSecond));
    }

    public static long getFramesFromTimeString(String p_TimeString, double p_FramesPerSecond) {
        long longMillis = DocumentFilter_Time.getMillisecondsFromString(p_TimeString);
        return DocumentFilter_Time.getFramesFromMilliseconds(longMillis, p_FramesPerSecond);
    }

    public static long getFramesFromMilliseconds(long p_Milliseconds, double p_FramesPerSecond) {
        if (p_Milliseconds < 0L) {
            p_Milliseconds = 0L;
        }
        long longFrame = (long)((double)p_Milliseconds / 1000.0 * p_FramesPerSecond);
        return longFrame;
    }
}

