/*
 * Decompiled with CFR 0.152.
 */
package SocketPackage;

import GUID.LiveDBUID;
import RareByteInterpreterPackage.RareByteInterpreterInterface;
import SocketManagementPackage.LiveDBAdminThread;
import SocketManagementPackage.LiveDBSocketChannelManagement;
import SocketManagementPackage.LiveDBSocketChannelMerger;
import SocketManagementPackage.LiveDBStream;
import SocketMessagePackage.LiveDBConnectionDescription;
import SocketMessagePackage.LiveDBMessageServerClose;
import SocketMessagePackage.LiveDBMessageSocketClose;
import SocketMessagePackage.LiveDBMessageSocketHandshake;
import SocketMessagePackage.LiveDBMessageStreamCancel;
import SocketMessagePackage.LiveDBMessageStreamConfirmation;
import SocketMessagePackage.LiveDBMessageStreamInfo;
import SocketMessagePackage.LiveDBMessageStreamPackage;
import SocketPackage.LiveDBSocketListener;
import SynchronizationPackage.LiveDBCloseSemaphore;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;

public class LiveDBSocket {
    public static int TIME_WAITFORHANDSHAKE = 20000;
    private String m_ID;
    private LiveDBConnectionDescription m_LiveDBConnectionDescription;
    private LiveDBSocketChannelMerger m_LiveDBSocketChannelMerger;
    private int m_ConnectionStatus;
    private long m_ConnectionLostTime;
    private ArrayList<Serializable> m_IncomingMessages;
    private ArrayList<Object> m_OutgoingMessageObjects;
    private ArrayList<LiveDBStream> m_IncomingStreams;
    private int m_OutgoingStreamCount;
    private ArrayList<LiveDBSocketListener> m_LiveDBSocketListeners;
    private RareByteInterpreterInterface m_RareByteInterpreterInterface;
    private boolean m_HandshakeConfirmed;
    private long m_TimeLastReaction;
    private LiveDBCloseSemaphore m_LiveDBCloseSemaphore;
    private final Object m_SyncListeners = new Object();
    private final Object m_SyncOutgoing = new Object();
    private final Object m_SyncIncoming = new Object();
    private final Object m_SyncWaitHandshake = new Object();
    private boolean m_HandshakeHandled;
    private LiveDBSocket m_SelfReference;

    public LiveDBSocket(LiveDBConnectionDescription p_LiveDBConnectionDescription) {
        this(null, p_LiveDBConnectionDescription);
    }

    public LiveDBSocket(String p_ID, LiveDBConnectionDescription p_LiveDBConnectionDescription) {
        this.initMembers();
        this.m_SelfReference = this;
        if (p_ID != null) {
            this.m_ID = p_ID;
        } else {
            LiveDBUID.restart();
            this.m_ID = LiveDBUID.getUID();
        }
        this.m_LiveDBConnectionDescription = p_LiveDBConnectionDescription.clone(this.m_LiveDBConnectionDescription);
    }

    private void initMembers() {
        this.m_LiveDBCloseSemaphore = new LiveDBCloseSemaphore(this.getClass().getName());
        this.m_ConnectionStatus = 0;
        this.m_ConnectionLostTime = -1L;
        this.m_LiveDBSocketChannelMerger = null;
        this.m_OutgoingMessageObjects = new ArrayList();
        this.m_IncomingMessages = new ArrayList();
        this.m_IncomingStreams = new ArrayList();
        this.m_OutgoingStreamCount = 0;
        this.m_LiveDBSocketListeners = new ArrayList();
        this.m_HandshakeConfirmed = false;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public void close() {
        Runnable o_Runnable = new Runnable(){

            @Override
            public void run() {
                LiveDBSocket.this.handleClose();
            }
        };
        LiveDBAdminThread o_LiveDBAdminThread = LiveDBSocketChannelManagement.getLiveDBAdminThread();
        if (o_LiveDBAdminThread != null) {
            if (Thread.currentThread() == o_LiveDBAdminThread.getThread()) {
                o_Runnable.run();
            } else {
                o_LiveDBAdminThread.addRunnable(o_Runnable);
            }
        } else {
            o_Runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleClose() {
        Object object;
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        switch (this.m_ConnectionStatus) {
            case 2: 
            case 3: {
                this.m_LiveDBCloseSemaphore.leaveWorkerSection();
                LiveDBSocketChannelManagement.actionCloseLiveDBSocket(this);
                return;
            }
            case 1: {
                break;
            }
        }
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
        this.setHandshakeConfirmed(false);
        if (!this.m_LiveDBCloseSemaphore.enterCloseSection()) {
            return;
        }
        this.closeMessages();
        if (this.m_LiveDBSocketChannelMerger != null) {
            this.m_LiveDBSocketChannelMerger.setLiveDBSocket(null);
            this.m_LiveDBSocketChannelMerger.close();
        }
        if (this.m_LiveDBSocketListeners != null) {
            this.notifyListeners_ConnectionStatus(0);
            object = this.m_SyncListeners;
            synchronized (object) {
                this.m_LiveDBSocketListeners.clear();
                this.m_LiveDBSocketListeners = null;
            }
        }
        object = this.m_SyncOutgoing;
        synchronized (object) {
            this.m_OutgoingMessageObjects = null;
        }
        this.m_LiveDBSocketChannelMerger = null;
        object = this.m_SyncIncoming;
        synchronized (object) {
            this.m_IncomingMessages = null;
            this.m_IncomingStreams = null;
        }
        this.m_LiveDBCloseSemaphore.leaveCloseSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeMessages() {
        Object object;
        if (this.m_IncomingStreams != null) {
            object = this.m_SyncIncoming;
            synchronized (object) {
                if (this.m_IncomingStreams != null) {
                    for (int intMessage = 0; intMessage < this.m_IncomingStreams.size(); ++intMessage) {
                        LiveDBStream o_LiveDBStream = this.m_IncomingStreams.get(intMessage);
                        o_LiveDBStream.cancel("Close Socket");
                    }
                    this.m_IncomingStreams.clear();
                }
            }
        }
        object = this.m_SyncOutgoing;
        synchronized (object) {
            if (this.m_OutgoingMessageObjects != null) {
                ArrayList<LiveDBStream> o_LiveDBStreams = new ArrayList<LiveDBStream>();
                for (int intMessage = 0; intMessage < this.m_OutgoingMessageObjects.size(); ++intMessage) {
                    Object o_Message = this.m_OutgoingMessageObjects.get(intMessage);
                    if (!(o_Message instanceof LiveDBStream)) continue;
                    o_LiveDBStreams.add((LiveDBStream)o_Message);
                }
                for (int intStream = 0; intStream < o_LiveDBStreams.size(); ++intStream) {
                    LiveDBStream o_LiveDBStream = (LiveDBStream)o_LiveDBStreams.get(intStream);
                    o_LiveDBStream.cancel("Close Socket");
                }
                this.m_OutgoingMessageObjects.clear();
                this.m_OutgoingStreamCount = 0;
            }
        }
        object = this.m_SyncIncoming;
        synchronized (object) {
            if (this.m_IncomingMessages != null) {
                this.m_IncomingMessages.clear();
            }
        }
    }

    public void setRareByteInterpreter(RareByteInterpreterInterface p_RareByteInterpreterInterface) {
        this.m_RareByteInterpreterInterface = p_RareByteInterpreterInterface;
    }

    public RareByteInterpreterInterface getRareByteInterpreterInterface() {
        return this.m_RareByteInterpreterInterface;
    }

    public boolean isUsingRareByte() {
        return this.m_RareByteInterpreterInterface != null;
    }

    public String getID() {
        return this.m_ID;
    }

    public void connect(int p_LocalPort) {
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        if (this.isConnected()) {
            this.m_LiveDBCloseSemaphore.leaveWorkerSection();
            return;
        }
        this.setHandshakeConfirmed(false);
        this.m_LiveDBConnectionDescription.setClientLocalPort(p_LocalPort);
        LiveDBSocketChannelManagement.actionConnectLiveDBSocket(this);
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    public void waitForHandshake() {
        this.m_HandshakeConfirmed = false;
        if (TIME_WAITFORHANDSHAKE <= 0) {
            return;
        }
        Runnable o_Runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = LiveDBSocket.this.m_SyncWaitHandshake;
                synchronized (object) {
                    if (!LiveDBSocket.this.m_HandshakeHandled) {
                        try {
                            long longWaitStart;
                            for (long longWaitTime = (long)TIME_WAITFORHANDSHAKE; longWaitTime > 0L && !LiveDBSocket.this.m_HandshakeHandled; longWaitTime -= System.nanoTime() / 1000000L - longWaitStart) {
                                longWaitStart = System.nanoTime() / 1000000L;
                                LiveDBSocket.this.m_SyncWaitHandshake.wait(longWaitTime);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (!LiveDBSocket.this.m_HandshakeHandled && !LiveDBSocket.this.m_HandshakeConfirmed) {
                    LiveDBSocketChannelManagement.eventConnectionFailed(LiveDBSocket.this.m_LiveDBSocketChannelMerger);
                }
            }
        };
        this.m_HandshakeHandled = false;
        Thread o_ThreadWait = new Thread(o_Runnable, this.getClass().getSimpleName() + "_waitForHandshake");
        o_ThreadWait.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHandshakeConfirmed(boolean p_Confirmed) {
        this.setTimeStampReaction();
        this.m_HandshakeConfirmed = p_Confirmed;
        this.m_HandshakeHandled = true;
        Object object = this.m_SyncWaitHandshake;
        synchronized (object) {
            this.m_SyncWaitHandshake.notifyAll();
        }
    }

    public boolean getHandshakeConfirmed() {
        return this.m_HandshakeConfirmed;
    }

    public void setTimeStampReaction() {
        this.m_TimeLastReaction = System.currentTimeMillis();
    }

    public long getTimeStampReaction() {
        return this.m_TimeLastReaction;
    }

    public boolean checkTimeStampReaction() {
        long longActualTime = System.currentTimeMillis();
        long longWatchdogConnection_Time = LiveDBSocketChannelManagement.getWatchdogConnection_Time();
        long longWatchdogTimeDiff = longActualTime - this.m_TimeLastReaction;
        if (longWatchdogConnection_Time <= 0L) {
            return true;
        }
        if (!LiveDBSocketChannelManagement.getWatchdogConnection_IsRunning()) {
            return true;
        }
        return longWatchdogTimeDiff < longWatchdogConnection_Time;
    }

    public LiveDBConnectionDescription getLiveDBConnectionDescription() {
        return this.m_LiveDBConnectionDescription;
    }

    public void setLiveDBSocketChannelMerger(LiveDBSocketChannelMerger p_LiveDBSocketChannelMerger) {
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        if (this.m_LiveDBSocketChannelMerger == p_LiveDBSocketChannelMerger) {
            this.m_LiveDBCloseSemaphore.leaveWorkerSection();
            return;
        }
        LiveDBSocketChannelMerger o_LiveDBSocketChannelMerger = this.m_LiveDBSocketChannelMerger;
        if (o_LiveDBSocketChannelMerger != null) {
            o_LiveDBSocketChannelMerger.close();
            o_LiveDBSocketChannelMerger = null;
        }
        this.m_LiveDBSocketChannelMerger = p_LiveDBSocketChannelMerger;
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    public LiveDBSocketChannelMerger getLiveDBSocketChannelMerger() {
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        LiveDBSocketChannelMerger o_LiveDBSocketChannelMerger = this.m_LiveDBSocketChannelMerger;
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
        return o_LiveDBSocketChannelMerger;
    }

    public boolean isConnected() {
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        boolean boolConnected = this.m_ConnectionStatus == 2 || this.m_ConnectionStatus == 3;
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
        return boolConnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionStatus(int p_ConnectionStatus) {
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        if (this.m_ConnectionStatus == p_ConnectionStatus) {
            this.m_LiveDBCloseSemaphore.leaveWorkerSection();
            return;
        }
        this.m_ConnectionStatus = p_ConnectionStatus;
        switch (this.m_ConnectionStatus) {
            case 0: {
                this.m_ConnectionLostTime = -1L;
                this.close();
                this.setHandshakeConfirmed(false);
                break;
            }
            case 8: {
                this.m_ConnectionLostTime = System.currentTimeMillis();
                this.notifyListeners_ConnectionStatus(this.m_ConnectionStatus);
                this.setHandshakeConfirmed(false);
                break;
            }
            case 3: {
                ArrayList<LiveDBStream> o_LiveDBStreams;
                this.m_ConnectionLostTime = -1L;
                this.notifyListeners_ConnectionStatus(this.m_ConnectionStatus);
                LiveDBStream o_LiveDBStream = null;
                Object object = this.m_SyncOutgoing;
                synchronized (object) {
                    o_LiveDBStreams = new ArrayList<LiveDBStream>();
                    if (this.m_OutgoingMessageObjects != null) {
                        for (int intMessage = 0; intMessage < this.m_OutgoingMessageObjects.size(); ++intMessage) {
                            Object o_MessageObject = this.m_OutgoingMessageObjects.get(intMessage);
                            if (o_MessageObject == null || !(o_MessageObject instanceof LiveDBStream)) continue;
                            o_LiveDBStream = (LiveDBStream)o_MessageObject;
                            o_LiveDBStreams.add(o_LiveDBStream);
                        }
                    }
                }
                for (int intStream = 0; intStream < o_LiveDBStreams.size(); ++intStream) {
                    o_LiveDBStream = (LiveDBStream)o_LiveDBStreams.get(intStream);
                    if (o_LiveDBStream.getDataPositionConfirmed() <= 0L) {
                        this.addOutgoingMessage(o_LiveDBStream.getStreamInfo());
                        continue;
                    }
                    LiveDBMessageStreamPackage o_StreamPackage = new LiveDBMessageStreamPackage(o_LiveDBStream.getID(), o_LiveDBStream.getDataPosition(), LiveDBStream.getPackageSize());
                    o_StreamPackage.setEndOfStream(o_LiveDBStream.getEndOfStream());
                    o_StreamPackage.setCanceled(o_LiveDBStream.getCanceled());
                    o_StreamPackage.setError(o_LiveDBStream.getError());
                    this.addOutgoingMessage(o_StreamPackage);
                }
                break;
            }
            default: {
                this.m_ConnectionLostTime = -1L;
                this.notifyListeners_ConnectionStatus(this.m_ConnectionStatus);
            }
        }
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    public int getConnectionStatus() {
        return this.m_ConnectionStatus;
    }

    public long getConnectionLostDate() {
        return this.m_ConnectionLostTime;
    }

    public void eventError(Exception p_Exception, String p_Remark) {
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.notifyListeners_Error(p_Exception, p_Remark);
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    public void eventMessageReadUnknown() {
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.notifyListeners_MessageReadUnknown();
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    public void eventMessageWritten(Object p_Object) {
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.notifyListeners_MessageWritten(p_Object);
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIncomingMessage(Serializable p_Message) {
        if (p_Message == null) {
            return;
        }
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        Object object = this.m_SyncIncoming;
        synchronized (object) {
            this.m_IncomingMessages.add(p_Message);
        }
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable getNextIncomingMessage() {
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        Serializable o_Message = null;
        Object object = this.m_SyncIncoming;
        synchronized (object) {
            if (this.m_IncomingMessages != null && this.m_IncomingMessages.size() > 0) {
                o_Message = this.m_IncomingMessages.get(0);
                this.m_IncomingMessages.remove(0);
            }
        }
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
        return o_Message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIncomingMessageSize() {
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return 0;
        }
        int o_MessageSize = 0;
        Object object = this.m_SyncIncoming;
        synchronized (object) {
            if (this.m_IncomingMessages != null) {
                o_MessageSize = this.m_IncomingMessages.size();
            }
        }
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
        return o_MessageSize;
    }

    public void parseMessage(Serializable p_MessageObject) {
        if (p_MessageObject == null) {
            return;
        }
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        LiveDBStream o_LiveDBStream = null;
        if (p_MessageObject instanceof LiveDBMessageStreamInfo) {
            LiveDBMessageStreamInfo o_StreamInfo = (LiveDBMessageStreamInfo)p_MessageObject;
            if (this.getIncomingStream(o_StreamInfo.getStreamID()) != null) {
                this.m_LiveDBCloseSemaphore.leaveWorkerSection();
                return;
            }
            if (o_StreamInfo.getDataType() == -1) {
                o_LiveDBStream = LiveDBStream.createIncomingStream(this, o_StreamInfo, null);
            }
            this.notifyListeners_ParseMessageStreamIncomingStart(o_LiveDBStream, o_StreamInfo);
        } else if (p_MessageObject instanceof LiveDBMessageStreamPackage) {
            LiveDBMessageStreamPackage o_StreamPackage = (LiveDBMessageStreamPackage)p_MessageObject;
            o_LiveDBStream = this.getIncomingStream(o_StreamPackage.getStreamID());
            if (o_LiveDBStream != null) {
                o_LiveDBStream.parseIncomingStreamPackage((LiveDBMessageStreamPackage)p_MessageObject);
                this.notifyListeners_ParseMessageStreamIncomingPackage(o_LiveDBStream, o_StreamPackage.getDataLengthValid());
                if (o_StreamPackage.getCanceled() || o_StreamPackage.getError() || o_StreamPackage.getEndOfStream()) {
                    this.notifyListeners_ParseMessageIncomingStreamEnd(o_LiveDBStream, o_StreamPackage.getEndOfStream(), o_StreamPackage.getCanceled(), o_StreamPackage.getError(), "");
                }
            }
        } else if (p_MessageObject instanceof LiveDBMessageStreamCancel) {
            LiveDBMessageStreamCancel o_LiveDBMessageStreamCancel = (LiveDBMessageStreamCancel)p_MessageObject;
            String stringCancelStreamID = o_LiveDBMessageStreamCancel.getStreamID();
            o_LiveDBStream = this.getOutgoingStream(stringCancelStreamID);
            if (o_LiveDBStream != null) {
                o_LiveDBStream.cancel(o_LiveDBMessageStreamCancel.getCause());
            }
        } else if (p_MessageObject instanceof LiveDBMessageStreamConfirmation) {
            LiveDBMessageStreamConfirmation o_StreamConfirmObject = (LiveDBMessageStreamConfirmation)p_MessageObject;
            o_LiveDBStream = this.getOutgoingStream(o_StreamConfirmObject.getStreamID());
            if (o_LiveDBStream != null) {
                boolean boolClosed = o_LiveDBStream.parseConfirmObject(o_StreamConfirmObject);
                this.notifyListeners_ParseMessageOutgoingStreamConfirmed(o_LiveDBStream, o_StreamConfirmObject.getDataPosition());
                if (boolClosed) {
                    this.notifyListeners_ParseMessageOutgoingStreamEnd(o_LiveDBStream, o_LiveDBStream.getEndOfStream(), o_LiveDBStream.getCanceled(), o_LiveDBStream.getError(), "");
                    LiveDBSocketChannelManagement.checkGarbageCollection();
                }
            } else {
                boolean bl = false;
            }
        } else if (p_MessageObject instanceof LiveDBMessageSocketClose) {
            LiveDBSocketChannelManagement.actionCloseLiveDBSocket(this);
        } else if (p_MessageObject instanceof LiveDBMessageServerClose) {
            int intShutdownFlag = ((LiveDBMessageServerClose)p_MessageObject).getCloseFlag();
            LiveDBSocketChannelManagement.actionCloseServer(this, intShutdownFlag);
        } else {
            this.m_LiveDBCloseSemaphore.leaveWorkerSection();
            this.notifyListeners_ParseMessage(p_MessageObject);
            return;
        }
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOutgoingMessage(Object p_MessageObject) {
        if (p_MessageObject == null) {
            return;
        }
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        Object object = this.m_SyncOutgoing;
        synchronized (object) {
            if (this.m_OutgoingMessageObjects == null) {
                this.m_LiveDBCloseSemaphore.leaveWorkerSection();
                return;
            }
            int intOutgoing = 0;
            if (p_MessageObject instanceof LiveDBMessageSocketHandshake) {
                this.m_OutgoingMessageObjects.add(0, p_MessageObject);
            } else if (p_MessageObject instanceof LiveDBStream) {
                LiveDBStream o_OutgoingStream;
                Object o_MessageObject;
                LiveDBStream o_NewStream = (LiveDBStream)p_MessageObject;
                for (intOutgoing = this.m_OutgoingMessageObjects.size() - 1; intOutgoing >= 0 && (o_MessageObject = this.m_OutgoingMessageObjects.get(intOutgoing)) instanceof LiveDBStream && (o_OutgoingStream = (LiveDBStream)o_MessageObject).getPriority() < o_NewStream.getPriority(); --intOutgoing) {
                }
                ++this.m_OutgoingStreamCount;
                this.m_OutgoingMessageObjects.add(++intOutgoing, p_MessageObject);
            } else {
                Object o_MessageObject;
                for (intOutgoing = this.m_OutgoingMessageObjects.size() - 1; intOutgoing >= 0 && (o_MessageObject = this.m_OutgoingMessageObjects.get(intOutgoing)) instanceof LiveDBStream; --intOutgoing) {
                }
                this.m_OutgoingMessageObjects.add(++intOutgoing, p_MessageObject);
            }
        }
        LiveDBSocketChannelMerger o_LiveDBSocketChannelMerger = this.m_LiveDBSocketChannelMerger;
        if (o_LiveDBSocketChannelMerger != null) {
            o_LiveDBSocketChannelMerger.addChannelEventInterest(4);
        }
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable getNextOutgoingMessage() {
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        Object o_MessageObject = null;
        Object o_StreamObject = null;
        Object object = this.m_SyncOutgoing;
        synchronized (object) {
            if (this.m_OutgoingMessageObjects == null) {
                o_MessageObject = null;
            } else if (this.m_OutgoingMessageObjects.size() <= 0) {
                o_MessageObject = null;
            } else {
                o_MessageObject = this.m_OutgoingMessageObjects.get(0);
                if (o_MessageObject instanceof LiveDBStream) {
                    o_StreamObject = ((LiveDBStream)o_MessageObject).getNextOutgoingStreamObject();
                    if (o_StreamObject == null) {
                        o_MessageObject = null;
                    }
                } else {
                    this.m_OutgoingMessageObjects.remove(o_MessageObject);
                }
            }
        }
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
        if (o_StreamObject != null) {
            if (o_StreamObject instanceof LiveDBMessageStreamInfo) {
                this.notifyListeners_ParseMessageStreamOutgoingStart((LiveDBStream)o_MessageObject, (LiveDBMessageStreamInfo)o_StreamObject);
            }
            o_MessageObject = o_StreamObject;
        }
        if (o_MessageObject == null) {
            return null;
        }
        return (Serializable)o_MessageObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOutgoingMessagesCount() {
        int o_SerializableCount;
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return 0;
        }
        Object object = this.m_SyncOutgoing;
        synchronized (object) {
            o_SerializableCount = this.m_OutgoingMessageObjects == null ? 0 : this.m_OutgoingMessageObjects.size();
        }
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
        return o_SerializableCount;
    }

    public int getOutgoingStreamCount() {
        return this.m_OutgoingStreamCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getOutgoingMessage(int p_Index) {
        Object o_MessageObject = null;
        if (p_Index < 0) {
            return o_MessageObject;
        }
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return o_MessageObject;
        }
        Object object = this.m_SyncOutgoing;
        synchronized (object) {
            if (this.m_OutgoingMessageObjects == null) {
                o_MessageObject = null;
            } else if (p_Index < this.m_OutgoingMessageObjects.size()) {
                o_MessageObject = this.m_OutgoingMessageObjects.get(p_Index);
            }
        }
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
        return o_MessageObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeOutgoingMessage(Object p_MessageObject) {
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        boolean boolRemoved = false;
        boolean boolSetWriteInterest = false;
        LiveDBSocketChannelMerger o_LiveDBSocketChannelMerger = this.m_LiveDBSocketChannelMerger;
        Object object = this.m_SyncOutgoing;
        synchronized (object) {
            if (this.m_OutgoingMessageObjects != null) {
                boolRemoved = this.m_OutgoingMessageObjects.remove(p_MessageObject);
                if (boolRemoved && p_MessageObject instanceof LiveDBStream) {
                    --this.m_OutgoingStreamCount;
                }
                if (this.m_OutgoingMessageObjects.size() > 0 && o_LiveDBSocketChannelMerger != null) {
                    boolSetWriteInterest = true;
                }
            }
        }
        if (boolSetWriteInterest && o_LiveDBSocketChannelMerger != null) {
            o_LiveDBSocketChannelMerger.addChannelEventInterest(4);
        }
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
        return boolRemoved;
    }

    public LiveDBStream addOutgoingMessageAsStream(InputStream p_MessageInputStream, int p_DataType, int p_Priority, long p_DataBytesCount, String p_Remark) {
        if (p_MessageInputStream == null) {
            return null;
        }
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        LiveDBStream o_LiveDBStream = LiveDBStream.createOutgoingStream(this, p_MessageInputStream, p_DataType, p_Priority, p_DataBytesCount, p_Remark);
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
        if (o_LiveDBStream == null) {
            return null;
        }
        return o_LiveDBStream;
    }

    public LiveDBStream addOutgoingMessageAsStream(Serializable p_MessageObject, int p_Priority) {
        if (p_MessageObject == null) {
            return null;
        }
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        LiveDBStream o_LiveDBStream = LiveDBStream.createOutgoingStream(this, p_MessageObject, p_Priority);
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
        return o_LiveDBStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveDBStream getOutgoingStream(String p_StreamID) {
        if (p_StreamID == null) {
            return null;
        }
        if (p_StreamID.length() <= 0) {
            return null;
        }
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        Object o_MessageObject = null;
        LiveDBStream o_LiveDBStream = null;
        Object object = this.m_SyncOutgoing;
        synchronized (object) {
            if (this.m_OutgoingMessageObjects != null) {
                for (int intMessage = 0; intMessage < this.m_OutgoingMessageObjects.size(); ++intMessage) {
                    o_MessageObject = this.m_OutgoingMessageObjects.get(intMessage);
                    if (!(o_MessageObject instanceof LiveDBStream)) continue;
                    o_LiveDBStream = (LiveDBStream)o_MessageObject;
                    if (p_StreamID.equals(o_LiveDBStream.getID())) break;
                    o_LiveDBStream = null;
                }
            }
        }
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
        if (o_LiveDBStream == null) {
            boolean bl = false;
        }
        return o_LiveDBStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addIncomingStream(LiveDBStream p_LiveDBStream) {
        if (p_LiveDBStream == null) {
            return false;
        }
        String stringStreamID = p_LiveDBStream.getID();
        if (stringStreamID == null || stringStreamID.length() <= 0) {
            return false;
        }
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        Object object = this.m_SyncIncoming;
        synchronized (object) {
            if (this.m_IncomingStreams == null) {
                this.m_LiveDBCloseSemaphore.leaveWorkerSection();
                return false;
            }
            for (int intStream = 0; intStream < this.m_IncomingStreams.size(); ++intStream) {
                LiveDBStream o_LiveDBStream = this.m_IncomingStreams.get(intStream);
                if (!stringStreamID.equals(o_LiveDBStream.getID())) continue;
                this.m_LiveDBCloseSemaphore.leaveWorkerSection();
                return true;
            }
            this.m_IncomingStreams.add(p_LiveDBStream);
        }
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
        this.addOutgoingMessage(p_LiveDBStream.getStreamConfirmPackage());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveDBStream getIncomingStream(String p_StreamID) {
        if (p_StreamID == null) {
            return null;
        }
        if (p_StreamID.length() <= 0) {
            return null;
        }
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        LiveDBStream o_LiveDBStream = null;
        Object object = this.m_SyncIncoming;
        synchronized (object) {
            if (this.m_IncomingStreams == null) {
                this.m_LiveDBCloseSemaphore.leaveWorkerSection();
                return null;
            }
            for (int intStream = 0; intStream < this.m_IncomingStreams.size() && !p_StreamID.equals((o_LiveDBStream = this.m_IncomingStreams.get(intStream)).getID()); ++intStream) {
                o_LiveDBStream = null;
            }
        }
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
        return o_LiveDBStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeIncomingStream(LiveDBStream p_LiveDBStream) {
        if (p_LiveDBStream == null) {
            return false;
        }
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        boolean boolRemoved = false;
        Object object = this.m_SyncIncoming;
        synchronized (object) {
            if (this.m_IncomingStreams != null) {
                boolRemoved = this.m_IncomingStreams.remove(p_LiveDBStream);
            }
        }
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
        return boolRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLiveDBSocketListener(LiveDBSocketListener p_LiveDBSocketListener) {
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_LiveDBSocketListeners != null && !this.m_LiveDBSocketListeners.contains(p_LiveDBSocketListener)) {
                this.m_LiveDBSocketListeners.add(p_LiveDBSocketListener);
            }
        }
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLiveDBSocketListenersCount() {
        int intListenerCount;
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return 0;
        }
        Object object = this.m_SyncListeners;
        synchronized (object) {
            intListenerCount = this.m_LiveDBSocketListeners == null ? 0 : this.m_LiveDBSocketListeners.size();
        }
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
        return intListenerCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveDBSocketListener removeLiveDBSocketListener(int p_Index) {
        LiveDBSocketListener o_LiveDBSocketListener;
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        Object object = this.m_SyncListeners;
        synchronized (object) {
            o_LiveDBSocketListener = this.m_LiveDBSocketListeners == null ? null : (p_Index < 0 || p_Index >= this.m_LiveDBSocketListeners.size() ? null : this.m_LiveDBSocketListeners.remove(p_Index));
        }
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
        return o_LiveDBSocketListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeLiveDBSocketListener(LiveDBSocketListener p_LiveDBSocketListener) {
        boolean boolFound;
        if (p_LiveDBSocketListener == null) {
            return false;
        }
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        Object object = this.m_SyncListeners;
        synchronized (object) {
            boolFound = this.m_LiveDBSocketListeners == null ? false : this.m_LiveDBSocketListeners.remove(p_LiveDBSocketListener);
        }
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
        return boolFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners_ConnectionStatus(int p_ConnectionStatus) {
        if (this.m_LiveDBSocketListeners == null) {
            return;
        }
        Object[] o_Listeners = null;
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_LiveDBSocketListeners != null) {
                o_Listeners = this.m_LiveDBSocketListeners.toArray();
            }
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBSocketListener o_LiveDBSocketListener = (LiveDBSocketListener)o_Listeners[intListener];
                if (o_LiveDBSocketListener == null) continue;
                o_LiveDBSocketListener.eventSocketConnectionStatus(this, p_ConnectionStatus);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners_MessageReadUnknown() {
        if (this.m_LiveDBSocketListeners == null) {
            return;
        }
        Object[] o_Listeners = null;
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_LiveDBSocketListeners != null) {
                o_Listeners = this.m_LiveDBSocketListeners.toArray();
            }
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBSocketListener o_LiveDBSocketListener = (LiveDBSocketListener)o_Listeners[intListener];
                if (o_LiveDBSocketListener == null) continue;
                o_LiveDBSocketListener.eventSocketMessageReadUnknown(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners_MessageWritten(Object p_MessageObject) {
        if (this.m_LiveDBSocketListeners == null) {
            return;
        }
        Object[] o_Listeners = null;
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_LiveDBSocketListeners != null) {
                o_Listeners = this.m_LiveDBSocketListeners.toArray();
            }
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBSocketListener o_LiveDBSocketListener = (LiveDBSocketListener)o_Listeners[intListener];
                if (o_LiveDBSocketListener == null) continue;
                o_LiveDBSocketListener.eventSocketMessageWritten(this, p_MessageObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners_Error(Exception p_Exception, String p_Remark) {
        if (this.m_LiveDBSocketListeners == null) {
            return;
        }
        Object[] o_Listeners = null;
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_LiveDBSocketListeners != null) {
                o_Listeners = this.m_LiveDBSocketListeners.toArray();
            }
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBSocketListener o_LiveDBSocketListener = (LiveDBSocketListener)o_Listeners[intListener];
                if (o_LiveDBSocketListener == null) continue;
                o_LiveDBSocketListener.eventSocketError(this, p_Exception, p_Remark);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners_ParseMessage(Serializable p_MessageObject) {
        if (this.m_LiveDBSocketListeners == null) {
            return;
        }
        Object[] o_Listeners = null;
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_LiveDBSocketListeners != null) {
                o_Listeners = this.m_LiveDBSocketListeners.toArray();
            }
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBSocketListener o_LiveDBSocketListener = (LiveDBSocketListener)o_Listeners[intListener];
                if (o_LiveDBSocketListener == null) continue;
                o_LiveDBSocketListener.parseMessage(this, p_MessageObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners_ParseMessageStreamIncomingStart(LiveDBStream p_LiveDBStream, LiveDBMessageStreamInfo p_StreamInfo) {
        if (this.m_LiveDBSocketListeners == null) {
            return;
        }
        Object[] o_Listeners = null;
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_LiveDBSocketListeners != null) {
                o_Listeners = this.m_LiveDBSocketListeners.toArray();
            }
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBSocketListener o_LiveDBSocketListener = (LiveDBSocketListener)o_Listeners[intListener];
                if (o_LiveDBSocketListener == null) continue;
                o_LiveDBSocketListener.parseMessageIncomingStreamStart(this, p_LiveDBStream, p_StreamInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners_ParseMessageIncomingStreamEnd(LiveDBStream p_LiveDBStream, boolean p_EndOfStream, boolean p_Canceled, boolean p_Error, String p_CancelRemark) {
        if (this.m_LiveDBSocketListeners == null) {
            return;
        }
        Object[] o_Listeners = null;
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_LiveDBSocketListeners != null) {
                o_Listeners = this.m_LiveDBSocketListeners.toArray();
            }
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBSocketListener o_LiveDBSocketListener = (LiveDBSocketListener)o_Listeners[intListener];
                if (o_LiveDBSocketListener == null) continue;
                o_LiveDBSocketListener.parseMessageIncomingStreamEnd(this, p_LiveDBStream, p_EndOfStream, p_Canceled, p_Error, p_CancelRemark);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners_ParseMessageStreamIncomingPackage(LiveDBStream p_LiveDBStream, long p_ValidBytesCount) {
        if (this.m_LiveDBSocketListeners == null) {
            return;
        }
        Object[] o_Listeners = null;
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_LiveDBSocketListeners != null) {
                o_Listeners = this.m_LiveDBSocketListeners.toArray();
            }
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBSocketListener o_LiveDBSocketListener = (LiveDBSocketListener)o_Listeners[intListener];
                if (o_LiveDBSocketListener == null) continue;
                o_LiveDBSocketListener.parseMessageIncomingStreamPackage(this, p_LiveDBStream, p_ValidBytesCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners_ParseMessageStreamOutgoingStart(LiveDBStream p_LiveDBStream, LiveDBMessageStreamInfo p_StreamInfo) {
        if (this.m_LiveDBSocketListeners == null) {
            return;
        }
        Object[] o_Listeners = null;
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_LiveDBSocketListeners != null) {
                o_Listeners = this.m_LiveDBSocketListeners.toArray();
            }
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBSocketListener o_LiveDBSocketListener = (LiveDBSocketListener)o_Listeners[intListener];
                if (o_LiveDBSocketListener == null) continue;
                o_LiveDBSocketListener.parseMessageOutgoingStreamStart(this, p_LiveDBStream, p_StreamInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners_ParseMessageOutgoingStreamEnd(LiveDBStream p_LiveDBStream, boolean p_EndOfStream, boolean p_Canceled, boolean p_Error, String p_CancelRemark) {
        if (this.m_LiveDBSocketListeners == null) {
            return;
        }
        Object[] o_Listeners = null;
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_LiveDBSocketListeners != null) {
                o_Listeners = this.m_LiveDBSocketListeners.toArray();
            }
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBSocketListener o_LiveDBSocketListener = (LiveDBSocketListener)o_Listeners[intListener];
                if (o_LiveDBSocketListener == null) continue;
                o_LiveDBSocketListener.parseMessageOutgoingStreamEnd(this, p_LiveDBStream, p_EndOfStream, p_Canceled, p_Error, p_CancelRemark);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners_ParseMessageOutgoingStreamConfirmed(LiveDBStream p_LiveDBStream, long p_ReceivedBytesCount) {
        if (this.m_LiveDBSocketListeners == null) {
            return;
        }
        Object[] o_Listeners = null;
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_LiveDBSocketListeners != null) {
                o_Listeners = this.m_LiveDBSocketListeners.toArray();
            }
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBSocketListener o_LiveDBSocketListener = (LiveDBSocketListener)o_Listeners[intListener];
                if (o_LiveDBSocketListener == null) continue;
                o_LiveDBSocketListener.parseMessageOutgoingStreamConfirmed(this, p_LiveDBStream, p_ReceivedBytesCount);
            }
        }
    }
}

