/*
 * Decompiled with CFR 0.152.
 */
package SocketManagementPackage;

import SocketManagementPackage.LiveDBSocketChannelManagement;
import SocketMessagePackage.LiveDBMessageSocketWatchdog;
import SynchronizationPackage.LiveDBCloseSemaphore;

public class LiveDBSocketWatchdogConnection {
    public static long s_MinScheduleTime = 2000L;
    public static long s_DefaultScheduleTime = 10000L;
    public static LiveDBMessageSocketWatchdog m_LiveDBSocketWatchdog = new LiveDBMessageSocketWatchdog();
    private long m_ScheduleTime_Send;
    private long m_ScheduleTime_Check;
    private Thread m_TimerThread;
    private final Object m_SyncTimer = new Object();
    private Runnable m_TimerRunnable;
    private boolean m_TimerStop = false;
    private boolean m_IsRunning = false;
    private LiveDBCloseSemaphore m_LiveDBCloseSemaphore = new LiveDBCloseSemaphore(this.getClass().getName());

    public LiveDBSocketWatchdogConnection() {
        this.m_ScheduleTime_Check = s_DefaultScheduleTime;
        this.m_TimerRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (LiveDBSocketWatchdogConnection.this.m_ScheduleTime_Check <= 0L) {
                    LiveDBSocketWatchdogConnection.this.m_IsRunning = false;
                    return;
                }
                LiveDBSocketWatchdogConnection.this.m_IsRunning = true;
                LiveDBSocketChannelManagement.handleWatchdogConnectionStarted();
                LiveDBSocketWatchdogConnection.this.m_ScheduleTime_Send = LiveDBSocketWatchdogConnection.this.m_ScheduleTime_Check / 2L;
                boolean boolCheck = false;
                while (!LiveDBSocketWatchdogConnection.this.m_TimerStop) {
                    Object object = LiveDBSocketWatchdogConnection.this.m_SyncTimer;
                    synchronized (object) {
                        try {
                            long longWaitStart;
                            for (long longWaitTime = LiveDBSocketWatchdogConnection.this.m_ScheduleTime_Send; longWaitTime > 0L && !LiveDBSocketWatchdogConnection.this.m_TimerStop; longWaitTime -= System.nanoTime() / 1000000L - longWaitStart) {
                                longWaitStart = System.nanoTime() / 1000000L;
                                LiveDBSocketWatchdogConnection.this.m_SyncTimer.wait(longWaitTime);
                            }
                        }
                        catch (Exception e) {
                            break;
                        }
                    }
                    if (!LiveDBSocketWatchdogConnection.this.m_TimerStop) {
                        try {
                            if (boolCheck) {
                                LiveDBSocketWatchdogConnection.this.eventWatchdogConnection_Check();
                                boolCheck = false;
                                continue;
                            }
                            LiveDBSocketWatchdogConnection.this.eventWatchdogConnection_Send();
                            boolCheck = true;
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    boolean inTest = false;
                    break;
                }
                LiveDBSocketWatchdogConnection.this.m_IsRunning = false;
            }
        };
    }

    public void close() {
        if (!this.m_LiveDBCloseSemaphore.enterCloseSection()) {
            return;
        }
        this.stop();
        this.m_LiveDBCloseSemaphore.leaveCloseSection();
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    private void eventWatchdogConnection_Send() {
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        LiveDBSocketChannelManagement.eventWatchdogConnection_Send();
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    private void eventWatchdogConnection_Check() {
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        LiveDBSocketChannelManagement.eventWatchdogConnection_Check();
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    public void setWatchdogConnection_Time(long p_ScheduleTime) {
        boolean boolWasRunning = this.m_IsRunning;
        this.stop();
        this.m_ScheduleTime_Check = p_ScheduleTime <= 0L ? 0L : (p_ScheduleTime < s_MinScheduleTime ? s_MinScheduleTime : p_ScheduleTime);
        if (boolWasRunning && this.m_ScheduleTime_Check > 0L) {
            this.start(this.m_ScheduleTime_Check);
        }
    }

    public long getWatchdogConnection_Time() {
        return this.m_ScheduleTime_Check;
    }

    public void start(long p_ScheduleTime) {
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.stop();
        if (p_ScheduleTime <= 0L) {
            this.m_ScheduleTime_Check = 0L;
            this.m_LiveDBCloseSemaphore.leaveWorkerSection();
            return;
        }
        this.m_ScheduleTime_Check = p_ScheduleTime < s_MinScheduleTime ? s_MinScheduleTime : p_ScheduleTime;
        this.m_TimerStop = false;
        this.m_TimerThread = new Thread(this.m_TimerRunnable, "TimerThread");
        this.m_TimerThread.start();
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.m_TimerStop = true;
        if (this.m_TimerThread != null) {
            Object object = this.m_SyncTimer;
            synchronized (object) {
                try {
                    this.m_SyncTimer.notifyAll();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                this.m_TimerThread.join(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.m_IsRunning) {
                try {
                    this.m_TimerThread.interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.m_TimerThread = null;
        }
    }

    public boolean getIsRunning() {
        return this.m_IsRunning;
    }
}

