/*
 * Decompiled with CFR 0.152.
 */
package SocketManagementPackage;

import GUID.LiveDBUID;
import JarLoader.JarClassLoader;
import LogEventPackage.LogEvent;
import RareByteInterpreterPackage.RareByteInterpreterInterface;
import SelectorPackage.LiveDBSelector;
import ServerPackage.LiveDBSocketServerListener;
import SocketManagementPackage.LiveDBAdminThread;
import SocketManagementPackage.LiveDBParserManager;
import SocketManagementPackage.LiveDBSocketChannelMerger;
import SocketManagementPackage.LiveDBSocketWatchdogConnection;
import SocketManagementPackage.LiveDBSocketWatchdogConnectionLost;
import SocketManagementPackage.LiveDBStream;
import SocketMessagePackage.LiveDBConnectionDescription;
import SocketMessagePackage.LiveDBMessageServerClose;
import SocketMessagePackage.LiveDBMessageSocketClose;
import SocketMessagePackage.LiveDBMessageSocketHandshake;
import SocketMessagePackage.LiveDBMessageSocketWatchdog;
import SocketMessagePackage.LiveDBMessageSocketWatchdogAnswer;
import SocketMessagePackage.LiveDBMessageStreamCancel;
import SocketMessagePackage.LiveDBMessageStreamConfirmation;
import SocketMessagePackage.LiveDBMessageStreamInfo;
import SocketMessagePackage.LiveDBMessageStreamPackage;
import SocketPackage.LiveDBSocket;
import SynchronizationPackage.LiveDBCloseSemaphore;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;

public class LiveDBSocketChannelManagement {
    public static int MESSAGE_MAXLENGTH = 0x8000000;
    public static byte[] MESSAGE_PRECODE = "/////".getBytes(Charset.forName("ISO-8859-15"));
    public static final int CONNECTION_CLOSE = 0;
    public static final int CONNECTION_TRYCONNECTION = 1;
    public static final int CONNECTION_CONNECT = 2;
    public static final int CONNECTION_RECONNECT = 3;
    public static final int CONNECTION_FAILED = 6;
    public static final int CONNECTION_LOST = 8;
    public static final int CONNECTION_TRYCLOSE = 9;
    public static final int CLOSESERVER_NOEFFECT = 0;
    public static final int CLOSESERVER_SUDDENLY = 1;
    public static final int CLOSESERVER_WAITFORCLIENTS = 2;
    public static final int CLOSESERVER_CANCEL = 9;
    public static final int DEFAULT_SOCKET_RECEIVEBUFFERSIZE = 32768;
    public static final int DEFAULT_SOCKET_SENDBUFFERSIZE = 32768;
    public static final int DEFAULT_SOCKET_SOTIMEOUT = 5000;
    public static final int DEFAULT_SOCKET_LINGERTIME = 0;
    public static final boolean DEFAULT_SOCKET_TCP_NODELAY = true;
    private static int m_SocketSendBufferSize = 32768;
    private static int m_SocketReceiveBufferSize = 32768;
    private static int m_SocketSoTimeOut = 5000;
    private static int m_SocketLingerTime = 0;
    private static boolean m_SocketTcpNoDelay = true;
    public static String ERROR_SERVERCANNOTOPEN = "Server can't open";
    public static String ERROR_SERVERCANNOTBIND = "Server cannot bind to port";
    public static String ERROR_SERVERNOSELECTOR = "Server has no selector";
    public static String ERROR_SERVERREFUSECONNECTION = "Server refuse the connection";
    public static String ERROR_CLIENTUNRESOLVEDSERVER = "Client cannot resolve serveraddress";
    public static String ERROR_CLIENTCANNOTOPEN = "Client cannot open socketchannel";
    public static String ERROR_CLIENTCANNOTBIND = "Client cannot bind to port";
    public static String ERROR_CLIENTCANNOTCONNECTSERVER = "Client cannot connect to the server";
    public static String ERROR_SELECTORACCEPTSOCKET = "Selector cannot accept new socket";
    public static String ERROR_SELECTORCANNOTOPEN = "Selector can't open";
    public static String ERROR_SELECTORCLOSESOCKET = "Selector closing socket";
    public static String ERROR_SELECTORCLOSE = "Selector cannot close";
    public static String ERROR_SELECTORREGISTERCHANEL = "Selector cannot register channel";
    public static String ERROR_SELECTORCHANGEKEYINTEREST = "Selector cannot change key event interest";
    public static String ERROR_SELECTORFINISHCONNECT = "Client cannot connect to the server, error occured while selector finishes the connection";
    public static String ERROR_SELECTORSELECTKEYS = "Error while Selector.getkeys()";
    public static String ERROR_SELECTORMISSINGATTACHMENT = "Selector key has no attachment";
    public static String ERROR_SELECTORPARSEKEY = "Selector error while parsing key event";
    public static String ERROR_MESSAGEREADING = "Error while reading from the socketchannel";
    public static String ERROR_MESSAGEWRITING = "Error while writing into the socketchannel";
    public static String ERROR_MESSAGEDESERIALIZING = "Cannot deserialize incoming message";
    public static String ERROR_MESSAGESERIALIZING = "Cannot serialize outgoing message";
    public static String ERROR_MESSAGEUNKNOWN = "Unknown message - PERHABS HACKER ATTACK!";
    public static String ERROR_MESSAGEPARSING = "Error while parsing a message: ";
    public static String ERROR_STREAMWRITE_READINPUTBUFFER = "Error stream outgoing reading from InputBuffer";
    public static String ERROR_STREAMREAD_WRITEOUTPUTBUFFER = "Error stream incoming writing to OutputBuffer";
    public static String ERROR_SYSTEMRUNJOB = "Error while running a system's job";
    public static String ERROR_RAREBYTEINTERPRETER_JARFILE = "load RareByteInterpreter: jar-file is invalid";
    public static String ERROR_RAREBYTEINTERPRETER_CLASSNAME = "load RareByteInterpreter: class not found";
    public static String ERROR_RAREBYTEINTERPRETER_NOCONSTRUCTOR = "load RareByteInterpreter: cannot find constructor";
    public static String ERROR_RAREBYTEINTERPRETER_CREATEINSTANCE = "load RareByteInterpreter: create instance failed";
    private static LiveDBConnectionDescription m_ServerConnectionDescription;
    public static InetSocketAddress m_ServerInetSocketAddress;
    private static int m_ServerConnectionStatus;
    private static LiveDBSocketList m_ServerLiveDBSocketList;
    private static ArrayList<LiveDBSocketServerListener> m_ServerListeners;
    private static ArrayList<String> m_ServerVerbosedClientIPs;
    private static ArrayList<LiveDBSocketList> m_ClientLiveDBSocketLists;
    private static RareByteInterpreterInterface m_RareByteInterpreter;
    private static LiveDBAdminThread s_LiveDBAdminThread;
    private static boolean m_IsInitialized;
    private static LiveDBParserManager m_ParserManager;
    private static LiveDBSocketWatchdogConnection m_LiveDBSocketWatchdogConnection;
    private static long m_WatchdogConnectionTime;
    private static ArrayList<LiveDBSocket> m_WatchdogLostLiveDBSockets;
    private static LiveDBSocketWatchdogConnectionLost m_LiveDBSocketWatchdogConnectionLost;
    private static long m_WatchdogConnectionLostTime;
    private static ArrayList<LiveDBSocket> m_WatchdogCloseLiveDBSockets;
    private static Runnable s_RunnableWatchdogConnection_Send;
    private static Runnable s_RunnableWatchdogConnection_Check;
    private static Runnable s_RunnableWatchdogConnectionLost;
    private static Runtime m_Runtime;
    private static double m_GarbageCollectionRatio;
    private static boolean m_GarbageCollectorRequest;
    private static LiveDBCloseSemaphore m_LiveDBCloseSemaphore;
    public static final Object m_SyncLiveDBSocketLists;
    public static final Object m_SyncServerListeners;
    public static final Object m_SyncServerVerbosedClientIP;
    public static final Object m_SyncGarbageCollection;

    public static void initialize() {
        if (m_IsInitialized) {
            return;
        }
        Security.setProperty("networkaddress.cache.ttl", "0");
        Security.setProperty("networkaddress.cache.negative.ttl", "0");
        m_IsInitialized = true;
    }

    public static void setMessagePrecode(byte[] p_MessagePrecode) {
        MESSAGE_PRECODE = p_MessagePrecode;
    }

    public static byte[] getMessagePrecode() {
        return MESSAGE_PRECODE;
    }

    public static void setMaxMessageLength(int p_MaxMessageLength) {
        MESSAGE_MAXLENGTH = p_MaxMessageLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destruct() {
        LiveDBSocketList o_ServerLiveDBSocketList;
        LiveDBSocketList o_LiveDBSocketList;
        ArrayList<LiveDBSocketList> o_LiveDBSocketLists;
        if (!m_LiveDBCloseSemaphore.enterCloseSection()) {
            return;
        }
        Object object = m_SyncServerListeners;
        synchronized (object) {
            if (m_ServerListeners != null) {
                m_ServerListeners.clear();
            }
        }
        if (m_LiveDBSocketWatchdogConnection != null) {
            m_LiveDBSocketWatchdogConnection.close();
        }
        if (m_LiveDBSocketWatchdogConnectionLost != null) {
            m_LiveDBSocketWatchdogConnectionLost.close();
        }
        Object object2 = m_SyncLiveDBSocketLists;
        synchronized (object2) {
            o_LiveDBSocketLists = new ArrayList<LiveDBSocketList>();
            int intListCount = m_ClientLiveDBSocketLists.size();
            for (int intList = intListCount - 1; intList >= 0; --intList) {
                o_LiveDBSocketList = m_ClientLiveDBSocketLists.get(0);
                if (o_LiveDBSocketList == null) continue;
                o_LiveDBSocketLists.add(o_LiveDBSocketList);
            }
            m_ClientLiveDBSocketLists.clear();
        }
        for (int intList = 0; intList < o_LiveDBSocketLists.size(); ++intList) {
            o_LiveDBSocketList = (LiveDBSocketList)o_LiveDBSocketLists.get(intList);
            if (o_LiveDBSocketList == null) continue;
            o_LiveDBSocketList.close();
        }
        Object intList = m_SyncServerVerbosedClientIP;
        synchronized (intList) {
            if (m_ServerVerbosedClientIPs != null) {
                m_ServerVerbosedClientIPs.clear();
                m_ServerVerbosedClientIPs = null;
            }
        }
        Object object3 = m_SyncLiveDBSocketLists;
        synchronized (object3) {
            o_ServerLiveDBSocketList = m_ServerLiveDBSocketList;
            m_ServerLiveDBSocketList = null;
        }
        if (o_ServerLiveDBSocketList != null) {
            o_ServerLiveDBSocketList.close();
            o_ServerLiveDBSocketList = null;
        }
        if (m_ParserManager != null) {
            m_ParserManager.close();
            m_ParserManager = null;
        }
        if (s_LiveDBAdminThread != null) {
            s_LiveDBAdminThread.close();
            s_LiveDBAdminThread = null;
        }
        m_LiveDBCloseSemaphore.leaveCloseSection();
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public static void setSocketReceiveBufferSize(int p_ReadBufferSize) {
        if (p_ReadBufferSize <= 1024) {
            return;
        }
        m_SocketReceiveBufferSize = p_ReadBufferSize;
    }

    public static int getSocketReceiveBufferSize() {
        return m_SocketReceiveBufferSize;
    }

    public static void setSocketSendBufferSize(int p_SendBufferSize) {
        if (p_SendBufferSize <= 1024) {
            return;
        }
        m_SocketSendBufferSize = p_SendBufferSize;
    }

    public static int getSocketSendBufferSize() {
        return m_SocketSendBufferSize;
    }

    public static void setSocketSoTimeOut(int p_SOTimeOut) {
        if (p_SOTimeOut < 0) {
            return;
        }
        m_SocketSoTimeOut = p_SOTimeOut;
    }

    public static int getSocketSoTimeOut() {
        return m_SocketSoTimeOut;
    }

    public static void setSocketLingerTime(int p_LingerTime) {
        if (p_LingerTime < 0) {
            return;
        }
        m_SocketLingerTime = p_LingerTime;
    }

    public static int getSocketLingerTime() {
        return m_SocketLingerTime;
    }

    public static void setSocketTcpNoDelay(boolean p_TCPNoDelay) {
        m_SocketTcpNoDelay = p_TCPNoDelay;
    }

    public static boolean getSocketTcpNoDelay() {
        return m_SocketTcpNoDelay;
    }

    public static void actionConnectServer(final LiveDBConnectionDescription p_LiveDBConnectionDescription) {
        if (!m_IsInitialized) {
            LiveDBSocketChannelManagement.initialize();
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        Runnable o_Runnable = new Runnable(){

            @Override
            public void run() {
                if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
                    return;
                }
                LiveDBSocketChannelManagement.handleConnectServer(p_LiveDBConnectionDescription);
                m_LiveDBCloseSemaphore.leaveWorkerSection();
            }
        };
        if (Thread.currentThread() == s_LiveDBAdminThread.getThread()) {
            o_Runnable.run();
        } else {
            s_LiveDBAdminThread.addRunnable(o_Runnable);
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    private static void handleConnectServer(LiveDBConnectionDescription p_LiveDBConnectionDescription) {
        ServerSocketChannel o_ServerSocketChannel;
        if (p_LiveDBConnectionDescription == null) {
            return;
        }
        if (LiveDBSocketChannelManagement.isServerConnected()) {
            return;
        }
        LiveDBSocketChannelManagement.setServerConnectionStatus(1);
        m_ServerConnectionDescription = p_LiveDBConnectionDescription;
        int intServerPort = m_ServerConnectionDescription.getServerPort();
        String stringServerURL = m_ServerConnectionDescription.getServerLocalURL();
        if (intServerPort < 0 || intServerPort > 65534) {
            intServerPort = LiveDBConnectionDescription.DEFAULT_SERVERPORT;
        }
        try {
            o_ServerSocketChannel = ServerSocketChannel.open();
        }
        catch (Exception e) {
            LiveDBSocketChannelManagement.eventServerError(e, ERROR_SERVERCANNOTOPEN);
            LiveDBSocketChannelManagement.setServerConnectionStatus(6);
            return;
        }
        try {
            o_ServerSocketChannel.socket().setReuseAddress(true);
            o_ServerSocketChannel.socket().setReceiveBufferSize(m_SocketReceiveBufferSize);
            o_ServerSocketChannel.socket().setSoTimeout(m_SocketSoTimeOut);
        }
        catch (Exception e) {
            // empty catch block
        }
        m_ServerInetSocketAddress = null;
        try {
            if (stringServerURL == null || stringServerURL.length() <= 0) {
                m_ServerInetSocketAddress = new InetSocketAddress(intServerPort);
            } else {
                m_ServerInetSocketAddress = LiveDBSocketChannelManagement.getInetSocketAddressIP4(stringServerURL, intServerPort);
                if (m_ServerInetSocketAddress == null) {
                    m_ServerInetSocketAddress = new InetSocketAddress(stringServerURL, intServerPort);
                }
            }
            o_ServerSocketChannel.socket().bind(m_ServerInetSocketAddress);
        }
        catch (IOException e) {
            try {
                o_ServerSocketChannel.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            o_ServerSocketChannel = null;
            LiveDBSocketChannelManagement.eventServerError(e, ERROR_SERVERCANNOTBIND);
            LiveDBSocketChannelManagement.setServerConnectionStatus(6);
            return;
        }
        m_ServerInetSocketAddress = (InetSocketAddress)o_ServerSocketChannel.socket().getLocalSocketAddress();
        m_ServerConnectionDescription.setServerLocalURL(LiveDBSocketChannelManagement.getServerHostName());
        m_ServerConnectionDescription.setServerLocalIP(m_ServerInetSocketAddress.getAddress().getHostAddress());
        m_ServerLiveDBSocketList = new LiveDBSocketList(p_LiveDBConnectionDescription);
        LiveDBSelector o_ServerSelector = m_ServerLiveDBSocketList.getLiveDBSelector();
        if (o_ServerSelector == null) {
            try {
                o_ServerSocketChannel.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            LiveDBSocketChannelManagement.eventServerError(new Exception("Connection Server failed there is no ServerSelector"), ERROR_SERVERNOSELECTOR);
            LiveDBSocketChannelManagement.setServerConnectionStatus(6);
            m_ServerLiveDBSocketList.close();
            m_ServerLiveDBSocketList = null;
            return;
        }
        LiveDBSocketChannelManagement.setServerConnectionStatus(2);
        o_ServerSelector.registerChannelLater(o_ServerSocketChannel, 16, null);
        if (m_LiveDBSocketWatchdogConnection != null) {
            m_LiveDBSocketWatchdogConnection.start(m_WatchdogConnectionTime);
        }
        if (m_LiveDBSocketWatchdogConnectionLost != null) {
            m_LiveDBSocketWatchdogConnectionLost.start(m_WatchdogConnectionLostTime);
        }
    }

    public static byte[] getIP4AddressBytes(String p_Inet4AddressString) {
        if (p_Inet4AddressString == null) {
            return null;
        }
        String[] stringArray = p_Inet4AddressString.split("\\.");
        if (stringArray.length != 4) {
            return null;
        }
        byte[] o_AddressBytes = new byte[4];
        for (int intByte = 0; intByte < 4; ++intByte) {
            int intByteContent;
            String stringByte = stringArray[intByte];
            try {
                intByteContent = Integer.valueOf(stringByte);
            }
            catch (Exception e) {
                return null;
            }
            if (intByteContent < 0 || intByteContent > 255) {
                return null;
            }
            o_AddressBytes[intByte] = (byte)(intByteContent & 0xFF);
        }
        return o_AddressBytes;
    }

    public static InetSocketAddress getInetSocketAddressIP4(String p_IP4Address, int p_Port) {
        InetSocketAddress o_InetSocketAddress;
        if (p_IP4Address == null) {
            return null;
        }
        byte[] o_IP4AddressBytes = LiveDBSocketChannelManagement.getIP4AddressBytes(p_IP4Address);
        if (o_IP4AddressBytes == null) {
            return null;
        }
        try {
            Inet4Address o_Inet4Address = (Inet4Address)Inet4Address.getByAddress(o_IP4AddressBytes);
            o_InetSocketAddress = new InetSocketAddress(o_Inet4Address, p_Port);
        }
        catch (Exception e) {
            return null;
        }
        return o_InetSocketAddress;
    }

    public static String getServerHostName() {
        String stringHostName = "";
        try {
            InetAddress o_InetAddressLocal = InetAddress.getLocalHost();
            stringHostName = o_InetAddressLocal.getHostName();
        }
        catch (Exception e) {
            stringHostName = "";
        }
        return stringHostName;
    }

    public static void actionCloseServer(final LiveDBSocket p_LiveDBSocket, final int p_CloseType) {
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        Runnable o_Runnable = new Runnable(){

            @Override
            public void run() {
                if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
                    return;
                }
                LiveDBSocketChannelManagement.handleCloseServer(p_LiveDBSocket, p_CloseType);
                m_LiveDBCloseSemaphore.leaveWorkerSection();
            }
        };
        if (Thread.currentThread() == s_LiveDBAdminThread.getThread()) {
            o_Runnable.run();
        } else {
            s_LiveDBAdminThread.addRunnable(o_Runnable);
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleCloseServer(LiveDBSocket p_LiveDBSocket, int p_CloseType) {
        boolean boolOK = true;
        if (m_ServerListeners != null) {
            LiveDBSocketServerListener o_LiveDBServerListener;
            ArrayList<LiveDBSocketServerListener> o_LiveDBSocketServerListeners;
            Object object = m_SyncServerListeners;
            synchronized (object) {
                o_LiveDBSocketServerListeners = new ArrayList<LiveDBSocketServerListener>();
                int intListenerSize = m_ServerListeners.size();
                for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                    o_LiveDBServerListener = m_ServerListeners.get(intListener);
                    if (o_LiveDBServerListener == null) continue;
                    o_LiveDBSocketServerListeners.add(o_LiveDBServerListener);
                }
            }
            for (int intListener = 0; intListener < o_LiveDBSocketServerListeners.size(); ++intListener) {
                o_LiveDBServerListener = (LiveDBSocketServerListener)o_LiveDBSocketServerListeners.get(intListener);
                if (!boolOK) break;
                if (o_LiveDBServerListener == null) continue;
                boolOK = o_LiveDBServerListener.verifyCloseServer(p_LiveDBSocket, p_CloseType);
            }
        }
        if (!boolOK) {
            return;
        }
        LiveDBSocketList o_ServerLiveDBSocketList = m_ServerLiveDBSocketList;
        switch (p_CloseType) {
            case 1: {
                ArrayList<LiveDBSocket> o_LiveDBSockets;
                LiveDBSocketChannelManagement.setServerConnectionStatus(9);
                if (o_ServerLiveDBSocketList == null || o_ServerLiveDBSocketList.getLiveDBSocketCount() <= 0) {
                    LiveDBSocketChannelManagement.finishCloseServer();
                    return;
                }
                Object intListener = m_SyncLiveDBSocketLists;
                synchronized (intListener) {
                    o_LiveDBSockets = new ArrayList<LiveDBSocket>(o_ServerLiveDBSocketList.getLiveDBSocketCount());
                    for (int intSocket = 0; intSocket < o_ServerLiveDBSocketList.getLiveDBSocketCount(); ++intSocket) {
                        LiveDBSocket o_LiveDBSocket = o_ServerLiveDBSocketList.getLiveDBSocket(intSocket);
                        if (o_LiveDBSocket == null) continue;
                        o_LiveDBSockets.add(o_LiveDBSocket);
                    }
                }
                for (int intSocket = 0; intSocket < o_LiveDBSockets.size(); ++intSocket) {
                    LiveDBSocket o_LiveDBSocket = (LiveDBSocket)o_LiveDBSockets.get(intSocket);
                    LiveDBSocketChannelManagement.actionCloseLiveDBSocket(o_LiveDBSocket);
                }
                return;
            }
            case 2: {
                LiveDBSocketChannelManagement.setServerConnectionStatus(9);
                if (o_ServerLiveDBSocketList == null || o_ServerLiveDBSocketList.getLiveDBSocketCount() <= 0) {
                    LiveDBSocketChannelManagement.finishCloseServer();
                    return;
                }
                return;
            }
            case 9: {
                if (m_ServerConnectionStatus == 9) {
                    LiveDBSocketChannelManagement.setServerConnectionStatus(2);
                }
                return;
            }
        }
    }

    private static void finishCloseServer() {
        LiveDBSocketList o_ServerLiveDBSocketList = m_ServerLiveDBSocketList;
        if (o_ServerLiveDBSocketList != null) {
            o_ServerLiveDBSocketList.close();
            m_ServerLiveDBSocketList = null;
        }
        LiveDBSocketChannelManagement.setServerConnectionStatus(0);
    }

    private static void setServerConnectionStatus(int p_ServerConnectionStatus) {
        if (m_ServerConnectionStatus == p_ServerConnectionStatus) {
            return;
        }
        m_ServerConnectionStatus = p_ServerConnectionStatus;
        LiveDBSocketChannelManagement.notifyServerListeners_ConnectionStatus(m_ServerConnectionStatus);
    }

    public static int getServerConnectionStatus() {
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return 0;
        }
        int intConnectionStatus = m_ServerConnectionStatus;
        m_LiveDBCloseSemaphore.leaveWorkerSection();
        return intConnectionStatus;
    }

    private static boolean isServerConnected() {
        return m_ServerConnectionStatus == 2 || m_ServerConnectionStatus == 3;
    }

    public static LiveDBConnectionDescription getServerConnectionDescription() {
        return m_ServerConnectionDescription;
    }

    public static void addLiveDBSocketServerListener(final LiveDBSocketServerListener p_LiveDBServerListener) {
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        Runnable o_Runnable = new Runnable(){

            @Override
            public void run() {
                if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
                    return;
                }
                LiveDBSocketChannelManagement.handleAddLiveDBSocketServerListener(p_LiveDBServerListener);
                m_LiveDBCloseSemaphore.leaveWorkerSection();
            }
        };
        if (Thread.currentThread() == s_LiveDBAdminThread.getThread()) {
            o_Runnable.run();
        } else {
            s_LiveDBAdminThread.addRunnable(o_Runnable);
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleAddLiveDBSocketServerListener(LiveDBSocketServerListener p_LiveDBServerListener) {
        if (p_LiveDBServerListener == null) {
            return;
        }
        Object object = m_SyncServerListeners;
        synchronized (object) {
            if (m_ServerListeners == null) {
                return;
            }
            if (m_ServerListeners.contains(p_LiveDBServerListener)) {
                return;
            }
            m_ServerListeners.add(p_LiveDBServerListener);
        }
    }

    public static void removeLiveDBSocketServerListener(final LiveDBSocketServerListener p_LiveDBServerListener) {
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        Runnable o_Runnable = new Runnable(){

            @Override
            public void run() {
                if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
                    return;
                }
                LiveDBSocketChannelManagement.handleRemoveLiveDBSocketServerListener(p_LiveDBServerListener);
                m_LiveDBCloseSemaphore.leaveWorkerSection();
            }
        };
        if (Thread.currentThread() == s_LiveDBAdminThread.getThread()) {
            o_Runnable.run();
        } else {
            s_LiveDBAdminThread.addRunnable(o_Runnable);
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleRemoveLiveDBSocketServerListener(LiveDBSocketServerListener p_LiveDBServerListener) {
        if (p_LiveDBServerListener == null) {
            return;
        }
        Object object = m_SyncServerListeners;
        synchronized (object) {
            if (m_ServerListeners != null) {
                m_ServerListeners.remove(p_LiveDBServerListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLiveDBSocketServerListenerCount() {
        int intListenerCount;
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return 0;
        }
        Object object = m_SyncServerListeners;
        synchronized (object) {
            intListenerCount = m_ServerListeners == null ? 0 : m_ServerListeners.size();
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
        return intListenerCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyServerListeners_ConnectionStatus(int p_ConnectionStatus) {
        if (m_ServerListeners == null) {
            return;
        }
        Object[] o_Listeners = null;
        Object object = m_SyncServerListeners;
        synchronized (object) {
            if (m_ServerListeners == null) {
                return;
            }
            o_Listeners = m_ServerListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBSocketServerListener o_LiveDBServerListener = (LiveDBSocketServerListener)o_Listeners[intListener];
                if (o_LiveDBServerListener == null) continue;
                o_LiveDBServerListener.eventServerConnectionStatus(p_ConnectionStatus);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyServerListeners_Error(Exception p_Exception, String p_Remark) {
        if (m_ServerListeners == null) {
            return;
        }
        Object[] o_Listeners = null;
        Object object = m_SyncServerListeners;
        synchronized (object) {
            if (m_ServerListeners == null) {
                return;
            }
            o_Listeners = m_ServerListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBSocketServerListener o_LiveDBServerListener = (LiveDBSocketServerListener)o_Listeners[intListener];
                if (o_LiveDBServerListener == null) continue;
                o_LiveDBServerListener.eventServerError(p_Exception, p_Remark);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyServerListeners_LiveDBSocketAdded(LiveDBSocket p_LiveDBSocket) {
        if (m_ServerListeners == null) {
            return;
        }
        Object[] o_Listeners = null;
        Object object = m_SyncServerListeners;
        synchronized (object) {
            if (m_ServerListeners == null) {
                return;
            }
            o_Listeners = m_ServerListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBSocketServerListener o_LiveDBServerListener = (LiveDBSocketServerListener)o_Listeners[intListener];
                if (o_LiveDBServerListener == null) continue;
                o_LiveDBServerListener.eventServerLiveDBSocketAdded(p_LiveDBSocket);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyServerListeners_LiveDBSocketRemoved(LiveDBSocket p_LiveDBSocket) {
        if (m_ServerListeners == null) {
            return;
        }
        Object[] o_Listeners = null;
        Object object = m_SyncServerListeners;
        synchronized (object) {
            if (m_ServerListeners == null) {
                return;
            }
            o_Listeners = m_ServerListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBSocketServerListener o_LiveDBServerListener = (LiveDBSocketServerListener)o_Listeners[intListener];
                if (o_LiveDBServerListener == null) continue;
                o_LiveDBServerListener.eventServerLiveDBSocketRemoved(p_LiveDBSocket);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyServerListeners_VerbosedIP(String p_VerbosedIP, boolean p_New) {
        if (m_ServerListeners == null) {
            return;
        }
        Object[] o_Listeners = null;
        Object object = m_SyncServerListeners;
        synchronized (object) {
            if (m_ServerListeners == null) {
                return;
            }
            o_Listeners = m_ServerListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBSocketServerListener o_LiveDBServerListener = (LiveDBSocketServerListener)o_Listeners[intListener];
                if (o_LiveDBServerListener == null) continue;
                o_LiveDBServerListener.eventServerVerbosedClientIP(p_VerbosedIP, p_New);
            }
        }
    }

    public static void actionConnectLiveDBSocket(final LiveDBSocket p_LiveDBSocket) {
        if (!m_IsInitialized) {
            LiveDBSocketChannelManagement.initialize();
        }
        if (p_LiveDBSocket == null) {
            return;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        Runnable o_Runnable = new Runnable(){

            @Override
            public void run() {
                if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
                    return;
                }
                LiveDBSocketChannelManagement.handleConnectLiveDBSocket(p_LiveDBSocket);
                m_LiveDBCloseSemaphore.leaveWorkerSection();
            }
        };
        if (Thread.currentThread() == s_LiveDBAdminThread.getThread()) {
            o_Runnable.run();
        } else {
            s_LiveDBAdminThread.addRunnable(o_Runnable);
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    private static void handleConnectLiveDBSocket(LiveDBSocket p_LiveDBSocket) {
        if (p_LiveDBSocket == null) {
            return;
        }
        if (p_LiveDBSocket.getLiveDBConnectionDescription() == null) {
            return;
        }
        if (p_LiveDBSocket.isConnected()) {
            return;
        }
        LiveDBSocketList o_ServerSocketList = LiveDBSocketChannelManagement.getClientSocketList(p_LiveDBSocket.getLiveDBConnectionDescription());
        if (o_ServerSocketList == null) {
            LiveDBSocketChannelManagement.eventLiveDBSocketError(p_LiveDBSocket, new Exception("Server address unresolved"), ERROR_CLIENTUNRESOLVEDSERVER);
            p_LiveDBSocket.setConnectionStatus(6);
            p_LiveDBSocket.setConnectionStatus(0);
            return;
        }
        p_LiveDBSocket.setConnectionStatus(1);
        o_ServerSocketList.connectLiveDBSocket(p_LiveDBSocket);
    }

    public static void actionCloseLiveDBSocket(final LiveDBSocket p_LiveDBSocket) {
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        Runnable o_Runnable = new Runnable(){

            @Override
            public void run() {
                if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
                    return;
                }
                LiveDBSocketChannelManagement.handleCloseLiveDBSocket(p_LiveDBSocket);
                m_LiveDBCloseSemaphore.leaveWorkerSection();
            }
        };
        if (Thread.currentThread() == s_LiveDBAdminThread.getThread()) {
            o_Runnable.run();
        } else {
            s_LiveDBAdminThread.addRunnable(o_Runnable);
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    private static void handleCloseLiveDBSocket(LiveDBSocket p_LiveDBSocket) {
        if (p_LiveDBSocket == null) {
            return;
        }
        if (p_LiveDBSocket.isConnected()) {
            p_LiveDBSocket.setConnectionStatus(9);
            LiveDBMessageSocketClose o_LiveDBSocketClose = new LiveDBMessageSocketClose();
            p_LiveDBSocket.addOutgoingMessage(o_LiveDBSocketClose);
            return;
        }
        LiveDBSocketChannelManagement.finishCloseLiveDBSocket(p_LiveDBSocket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void finishCloseLiveDBSocket(LiveDBSocket p_LiveDBSocket) {
        LiveDBSocketList o_LiveDBSocketList;
        ArrayList<LiveDBSocketList> o_LiveDBSocketLists;
        LiveDBSocketList o_ServerLiveDBSocketList;
        if (p_LiveDBSocket == null) {
            return;
        }
        LiveDBSocketChannelMerger o_LiveDBSocketChannelMerger = p_LiveDBSocket.getLiveDBSocketChannelMerger();
        if (o_LiveDBSocketChannelMerger != null) {
            o_LiveDBSocketChannelMerger.close();
        }
        if ((o_ServerLiveDBSocketList = m_ServerLiveDBSocketList) != null) {
            boolean boolRemoved;
            Object object = m_SyncLiveDBSocketLists;
            synchronized (object) {
                boolRemoved = o_ServerLiveDBSocketList.removeLiveDBSocket(p_LiveDBSocket);
            }
            if (boolRemoved) {
                p_LiveDBSocket.setConnectionStatus(0);
                LiveDBSocketChannelManagement.notifyServerListeners_LiveDBSocketRemoved(p_LiveDBSocket);
                return;
            }
        }
        Object object = m_SyncLiveDBSocketLists;
        synchronized (object) {
            o_LiveDBSocketLists = new ArrayList<LiveDBSocketList>();
            for (int intList = m_ClientLiveDBSocketLists.size() - 1; intList >= 0; --intList) {
                o_LiveDBSocketList = m_ClientLiveDBSocketLists.get(intList);
                if (o_LiveDBSocketList == null) continue;
                o_LiveDBSocketLists.add(o_LiveDBSocketList);
            }
        }
        for (int intList = 0; intList < o_LiveDBSocketLists.size(); ++intList) {
            o_LiveDBSocketList = (LiveDBSocketList)o_LiveDBSocketLists.get(intList);
            if (o_LiveDBSocketList == null || !o_LiveDBSocketList.removeLiveDBSocket(p_LiveDBSocket)) continue;
            p_LiveDBSocket.setConnectionStatus(0);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LiveDBSocketList getClientSocketList(LiveDBConnectionDescription p_LiveDBConnectionDescription) {
        ArrayList<LiveDBSocketList> o_LiveDBSocketLists;
        String stringServerURL = p_LiveDBConnectionDescription.getServerRemoteURL();
        if (stringServerURL == null || stringServerURL.length() <= 0) {
            return null;
        }
        int intServerPort = p_LiveDBConnectionDescription.getServerPort();
        if (stringServerURL.length() <= 0) {
            stringServerURL = LiveDBConnectionDescription.DEFAULT_SERVERURL;
        }
        if (intServerPort < 0 || intServerPort > 65534) {
            intServerPort = LiveDBConnectionDescription.DEFAULT_SERVERPORT;
        }
        p_LiveDBConnectionDescription.setServerPort(intServerPort);
        InetSocketAddress o_ServerSocketAddress = LiveDBSocketChannelManagement.getInetSocketAddressIP4(stringServerURL, intServerPort);
        if (o_ServerSocketAddress == null) {
            o_ServerSocketAddress = new InetSocketAddress(p_LiveDBConnectionDescription.getServerRemoteURL(), p_LiveDBConnectionDescription.getServerPort());
        }
        if (o_ServerSocketAddress == null || o_ServerSocketAddress.isUnresolved()) {
            return null;
        }
        InetAddress o_ServerInetAddress = o_ServerSocketAddress.getAddress();
        if (o_ServerInetAddress == null) {
            return null;
        }
        LiveDBSocketList o_LiveDBSocketList = null;
        Object object = m_SyncLiveDBSocketLists;
        synchronized (object) {
            o_LiveDBSocketLists = new ArrayList<LiveDBSocketList>(m_ClientLiveDBSocketLists.size());
            o_LiveDBSocketLists.addAll(m_ClientLiveDBSocketLists);
        }
        for (int intSocketList = 0; intSocketList < o_LiveDBSocketLists.size(); ++intSocketList) {
            o_LiveDBSocketList = (LiveDBSocketList)o_LiveDBSocketLists.get(intSocketList);
            if (o_LiveDBSocketList == null) continue;
            o_LiveDBSocketList.checkServerAddress();
            InetSocketAddress o_LiveDBSocketListServerAddress = o_LiveDBSocketList.getServerInetSocketAddress();
            if (o_ServerSocketAddress.equals(o_LiveDBSocketListServerAddress)) break;
            o_LiveDBSocketList = null;
        }
        if (o_LiveDBSocketList == null) {
            o_LiveDBSocketList = new LiveDBSocketList(p_LiveDBConnectionDescription);
            o_LiveDBSocketList.checkServerAddress();
            Object object2 = m_SyncLiveDBSocketLists;
            synchronized (object2) {
                m_ClientLiveDBSocketLists.add(o_LiveDBSocketList);
            }
        }
        p_LiveDBConnectionDescription.setServerRemoteURL(o_ServerInetAddress.getHostAddress());
        p_LiveDBConnectionDescription.setServerRemoteIP(o_ServerInetAddress.getHostAddress());
        return o_LiveDBSocketList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addVerbosedClientIP(String p_VerbosedClientIP) {
        if (p_VerbosedClientIP == null) {
            return;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        boolean boolAdded = false;
        Object object = m_SyncServerVerbosedClientIP;
        synchronized (object) {
            if (m_ServerVerbosedClientIPs != null && !m_ServerVerbosedClientIPs.contains(p_VerbosedClientIP)) {
                boolAdded = m_ServerVerbosedClientIPs.add(p_VerbosedClientIP);
            }
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
        if (boolAdded) {
            LiveDBSocketChannelManagement.notifyServerListeners_VerbosedIP(p_VerbosedClientIP, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeVerbosedClientIP(String p_VerbosedClientIP) {
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        boolean boolRemoved = false;
        Object object = m_SyncServerVerbosedClientIP;
        synchronized (object) {
            if (m_ServerVerbosedClientIPs != null) {
                boolRemoved = m_ServerVerbosedClientIPs.remove(p_VerbosedClientIP);
            }
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
        if (boolRemoved) {
            LiveDBSocketChannelManagement.notifyServerListeners_VerbosedIP(p_VerbosedClientIP, false);
        }
        return boolRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String removeVerbosedClientIP(int p_Index) {
        if (p_Index > 0) {
            return null;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        String stringVerbosedClientIP = null;
        Object object = m_SyncServerVerbosedClientIP;
        synchronized (object) {
            if (m_ServerVerbosedClientIPs != null) {
                stringVerbosedClientIP = p_Index >= m_ServerVerbosedClientIPs.size() ? null : m_ServerVerbosedClientIPs.remove(p_Index);
            }
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
        if (stringVerbosedClientIP != null) {
            LiveDBSocketChannelManagement.notifyServerListeners_VerbosedIP(stringVerbosedClientIP, false);
        }
        return stringVerbosedClientIP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearVerbosedClientIPs() {
        String stringVerbosedIP;
        ArrayList<String> o_ServerVerbosedClientIPs;
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
        Object object = m_SyncServerVerbosedClientIP;
        synchronized (object) {
            o_ServerVerbosedClientIPs = new ArrayList<String>();
            if (m_ServerVerbosedClientIPs != null) {
                int intSize = m_ServerVerbosedClientIPs.size();
                for (int intIP = intSize - 1; intIP >= 0; --intIP) {
                    stringVerbosedIP = m_ServerVerbosedClientIPs.get(intIP);
                    o_ServerVerbosedClientIPs.add(stringVerbosedIP);
                    m_ServerVerbosedClientIPs.remove(intIP);
                }
            }
        }
        for (int intIP = 0; intIP < o_ServerVerbosedClientIPs.size(); ++intIP) {
            stringVerbosedIP = (String)o_ServerVerbosedClientIPs.get(intIP);
            LiveDBSocketChannelManagement.notifyServerListeners_VerbosedIP(stringVerbosedIP, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getVerbosedClientIPsCount() {
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return 0;
        }
        int intVerbosedCount = 0;
        Object object = m_SyncServerVerbosedClientIP;
        synchronized (object) {
            if (m_ServerVerbosedClientIPs != null) {
                intVerbosedCount = m_ServerVerbosedClientIPs.size();
            }
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
        return intVerbosedCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVerbosedClientIP(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        String stringVerbosedClientIP = null;
        Object object = m_SyncServerVerbosedClientIP;
        synchronized (object) {
            if (m_ServerVerbosedClientIPs != null) {
                stringVerbosedClientIP = p_Index >= m_ServerVerbosedClientIPs.size() ? null : m_ServerVerbosedClientIPs.get(p_Index);
            }
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
        return stringVerbosedClientIP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isVerbosedClientIP(String p_ClientIP) {
        if (p_ClientIP == null) {
            return false;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        boolean boolVerbosedClientIP = false;
        Object object = m_SyncServerVerbosedClientIP;
        synchronized (object) {
            if (m_ServerVerbosedClientIPs != null) {
                boolVerbosedClientIP = m_ServerVerbosedClientIPs.contains(p_ClientIP);
            }
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
        return boolVerbosedClientIP;
    }

    public static void eventConnectionAccept(final SocketChannel p_ClientSocketChannel) {
        if (p_ClientSocketChannel == null) {
            return;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        Runnable o_Runnable = new Runnable(){

            @Override
            public void run() {
                if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
                    return;
                }
                LiveDBSocketChannelManagement.handleConnectionAccept(p_ClientSocketChannel);
                m_LiveDBCloseSemaphore.leaveWorkerSection();
            }
        };
        if (Thread.currentThread() == s_LiveDBAdminThread.getThread()) {
            o_Runnable.run();
        } else {
            s_LiveDBAdminThread.addRunnable(o_Runnable);
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleConnectionAccept(SocketChannel p_ClientSocketChannel) {
        if (p_ClientSocketChannel == null) {
            return;
        }
        LiveDBSocketList o_ServerLiveDBSocketList = m_ServerLiveDBSocketList;
        if (o_ServerLiveDBSocketList == null) {
            return;
        }
        LiveDBSelector o_ServerSelector = o_ServerLiveDBSocketList.getLiveDBSelector();
        if (o_ServerSelector == null) {
            return;
        }
        String stringClientRemoteIP = null;
        boolean boolVerbosed = false;
        try {
            InetSocketAddress o_RemoteInetSocketAddress = (InetSocketAddress)p_ClientSocketChannel.socket().getRemoteSocketAddress();
            stringClientRemoteIP = o_RemoteInetSocketAddress == null ? null : o_RemoteInetSocketAddress.getAddress().getHostAddress();
        }
        catch (Exception e) {
            stringClientRemoteIP = null;
        }
        if (stringClientRemoteIP != null) {
            Object e = m_SyncServerVerbosedClientIP;
            synchronized (e) {
                boolVerbosed = LiveDBSocketChannelManagement.isVerbosedClientIP(stringClientRemoteIP);
            }
        }
        if (boolVerbosed) {
            try {
                p_ClientSocketChannel.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            return;
        }
        LiveDBSocketChannelMerger o_LiveDBSocketChannelMerger = new LiveDBSocketChannelMerger(p_ClientSocketChannel, o_ServerSelector);
        o_ServerSelector.registerChannelLater(p_ClientSocketChannel, 1, o_LiveDBSocketChannelMerger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleServerReceivedHandshake(LiveDBSocketChannelMerger p_LiveDBSocketChannelMerger, LiveDBMessageSocketHandshake p_LiveDBSocketHandshake, boolean p_UseRareByteInterpreter) {
        String stringClientRemoteIP;
        if (p_LiveDBSocketHandshake == null) {
            return;
        }
        if (p_LiveDBSocketChannelMerger == null) {
            return;
        }
        int intAnswerConnectionStatus = 0;
        String stringSocketClientID = p_LiveDBSocketHandshake.getSocketClientID();
        if (stringSocketClientID == null || stringSocketClientID.length() <= 0) {
            stringSocketClientID = LiveDBUID.getUID();
        }
        LiveDBSocket o_LiveDBSocket = null;
        LiveDBConnectionDescription o_HandshakeConnectionDescription = p_LiveDBSocketHandshake.getLiveDBConnectionDescription();
        boolean boolNewConnected = false;
        try {
            InetSocketAddress o_RemoteInetSocketAddress = (InetSocketAddress)p_LiveDBSocketChannelMerger.getSocketChannel().socket().getRemoteSocketAddress();
            stringClientRemoteIP = o_RemoteInetSocketAddress == null ? null : o_RemoteInetSocketAddress.getAddress().getHostAddress();
        }
        catch (Exception e) {
            stringClientRemoteIP = "";
        }
        LiveDBConnectionDescription o_LiveDBConnectionDescription = LiveDBConnectionDescription.createConnectionDescription_ServerSide(m_ServerConnectionDescription.getServerLocalURL(), m_ServerConnectionDescription.getServerPort(), m_ServerConnectionDescription.getServerID(), m_ServerConnectionDescription.getServerTaskID(), m_ServerConnectionDescription.getServerName(), m_ServerConnectionDescription.getServerLongName(), m_ServerConnectionDescription.getServerVersion());
        o_LiveDBConnectionDescription.setServerLocalIP(m_ServerConnectionDescription.getServerLocalIP());
        o_LiveDBConnectionDescription.setServerPort(m_ServerConnectionDescription.getServerPort());
        o_LiveDBConnectionDescription.setServerRemoteIP(o_HandshakeConnectionDescription.getServerRemoteIP());
        o_LiveDBConnectionDescription.setServerRemoteURL(o_HandshakeConnectionDescription.getServerRemoteURL());
        o_LiveDBConnectionDescription.setClientVersion(o_HandshakeConnectionDescription.getClientVersion());
        o_LiveDBConnectionDescription.setClientLicense(o_HandshakeConnectionDescription.getClientLicense());
        o_LiveDBConnectionDescription.setClientMacAddress(o_HandshakeConnectionDescription.getClientMacAddress());
        o_LiveDBConnectionDescription.setClientUserStatus(o_HandshakeConnectionDescription.getClientUserStatus());
        o_LiveDBConnectionDescription.setClientUserName(o_HandshakeConnectionDescription.getClientUserName());
        o_LiveDBConnectionDescription.setClientLocalIP(o_HandshakeConnectionDescription.getClientLocalIP());
        o_LiveDBConnectionDescription.setClientLocalPort(o_HandshakeConnectionDescription.getClientLocalPort());
        o_LiveDBConnectionDescription.setClientRemoteIP(stringClientRemoteIP);
        boolean boolAccept = true;
        LiveDBSocketList o_ServerLiveDBSocketList = m_ServerLiveDBSocketList;
        if (o_ServerLiveDBSocketList == null) {
            return;
        }
        o_LiveDBSocket = o_ServerLiveDBSocketList.getLiveDBSocket(stringSocketClientID);
        if (o_LiveDBSocket == null) {
            intAnswerConnectionStatus = 2;
            o_LiveDBSocket = new LiveDBSocket(stringSocketClientID, o_LiveDBConnectionDescription);
            if (p_UseRareByteInterpreter) {
                o_LiveDBSocket.setRareByteInterpreter(m_RareByteInterpreter);
            } else {
                o_LiveDBSocket.setRareByteInterpreter(null);
            }
            boolNewConnected = true;
        } else {
            intAnswerConnectionStatus = 3;
            if (p_UseRareByteInterpreter) {
                o_LiveDBSocket.setRareByteInterpreter(m_RareByteInterpreter);
            } else {
                o_LiveDBSocket.setRareByteInterpreter(null);
            }
            boolNewConnected = false;
        }
        if (m_ServerConnectionStatus == 9) {
            boolAccept = false;
        } else {
            LiveDBSocketServerListener o_LiveDBServerListener;
            ArrayList<LiveDBSocketServerListener> o_ServerListeners = null;
            Object object = m_SyncServerListeners;
            synchronized (object) {
                if (m_ServerListeners != null) {
                    o_ServerListeners = new ArrayList<LiveDBSocketServerListener>();
                    int intListenerSize = m_ServerListeners.size();
                    for (int intServerListener = 0; intServerListener < intListenerSize; ++intServerListener) {
                        o_LiveDBServerListener = m_ServerListeners.get(intServerListener);
                        if (o_LiveDBServerListener == null) continue;
                        o_ServerListeners.add(o_LiveDBServerListener);
                    }
                }
            }
            if (o_ServerListeners != null) {
                for (int intServerListener = 0; intServerListener < o_ServerListeners.size() && boolAccept; ++intServerListener) {
                    o_LiveDBServerListener = (LiveDBSocketServerListener)o_ServerListeners.get(intServerListener);
                    if (o_LiveDBServerListener == null) continue;
                    if (!o_LiveDBServerListener.verifyClientSoftwareVersion(o_LiveDBSocket, o_HandshakeConnectionDescription.getClientVersion(), o_LiveDBConnectionDescription)) {
                        boolAccept = false;
                    }
                    if (o_LiveDBServerListener.verifyClientLicense(o_LiveDBSocket, o_HandshakeConnectionDescription.getClientLicense(), o_LiveDBConnectionDescription)) continue;
                    boolAccept = false;
                }
            }
        }
        if (!boolAccept) {
            intAnswerConnectionStatus = 9;
        } else if (boolNewConnected) {
            Object object = m_SyncLiveDBSocketLists;
            synchronized (object) {
                o_ServerLiveDBSocketList.addLiveDBSocket(o_LiveDBSocket);
            }
            LiveDBSocketChannelManagement.notifyServerListeners_LiveDBSocketAdded(o_LiveDBSocket);
        }
        o_LiveDBConnectionDescription.clone(o_LiveDBSocket.getLiveDBConnectionDescription());
        o_LiveDBSocket.setLiveDBSocketChannelMerger(p_LiveDBSocketChannelMerger);
        p_LiveDBSocketChannelMerger.setLiveDBSocket(o_LiveDBSocket);
        o_LiveDBSocket.setConnectionStatus(intAnswerConnectionStatus);
        LiveDBMessageSocketHandshake o_LiveDBSocketHandshake = new LiveDBMessageSocketHandshake(o_LiveDBSocket.getID(), o_LiveDBSocket.getLiveDBConnectionDescription(), intAnswerConnectionStatus);
        o_LiveDBSocket.addOutgoingMessage(o_LiveDBSocketHandshake);
        o_LiveDBSocket.setHandshakeConfirmed(true);
    }

    public static void eventConnectionConnect(final LiveDBSocketChannelMerger p_LiveDBSocketChannelMerger) {
        if (p_LiveDBSocketChannelMerger == null) {
            return;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        Runnable o_Runnable = new Runnable(){

            @Override
            public void run() {
                if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
                    return;
                }
                LiveDBSocketChannelManagement.handleConnectionConnect(p_LiveDBSocketChannelMerger);
                m_LiveDBCloseSemaphore.leaveWorkerSection();
            }
        };
        if (Thread.currentThread() == s_LiveDBAdminThread.getThread()) {
            o_Runnable.run();
        } else {
            s_LiveDBAdminThread.addRunnable(o_Runnable);
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    private static void handleConnectionConnect(LiveDBSocketChannelMerger p_LiveDBSocketChannelMerger) {
        if (p_LiveDBSocketChannelMerger == null) {
            return;
        }
        LiveDBSocket o_LiveDBSocket = p_LiveDBSocketChannelMerger.getLiveDBSocket();
        if (o_LiveDBSocket == null) {
            return;
        }
        p_LiveDBSocketChannelMerger.addChannelEventInterest(1);
        LiveDBMessageSocketHandshake o_LiveDBSocketHandshake = new LiveDBMessageSocketHandshake(o_LiveDBSocket.getID(), o_LiveDBSocket.getLiveDBConnectionDescription(), 1);
        o_LiveDBSocket.addOutgoingMessage(o_LiveDBSocketHandshake);
    }

    private static void handleClientReceivedHandshake(LiveDBSocketChannelMerger p_LiveDBSocketChannelMerger, LiveDBMessageSocketHandshake p_LiveDBSocketHandshake, boolean p_UseRareByteInterpreter) {
        if (p_LiveDBSocketChannelMerger == null) {
            return;
        }
        if (p_LiveDBSocketHandshake == null) {
            return;
        }
        LiveDBSocket o_LiveDBSocket = p_LiveDBSocketChannelMerger.getLiveDBSocket();
        if (o_LiveDBSocket == null) {
            return;
        }
        if (p_UseRareByteInterpreter) {
            o_LiveDBSocket.setRareByteInterpreter(m_RareByteInterpreter);
        } else {
            o_LiveDBSocket.setRareByteInterpreter(null);
        }
        LiveDBConnectionDescription o_HandshakeConnectionDescription = p_LiveDBSocketHandshake.getLiveDBConnectionDescription();
        LiveDBConnectionDescription o_LiveDBSocketConnectionDescription = o_LiveDBSocket.getLiveDBConnectionDescription();
        o_LiveDBSocketConnectionDescription.setServerID(o_HandshakeConnectionDescription.getServerID());
        o_LiveDBSocketConnectionDescription.setServerTaskID(o_HandshakeConnectionDescription.getServerTaskID());
        o_LiveDBSocketConnectionDescription.setServerLocalURL(o_HandshakeConnectionDescription.getServerLocalURL());
        o_LiveDBSocketConnectionDescription.setServerLocalIP(o_HandshakeConnectionDescription.getServerLocalIP());
        o_LiveDBSocketConnectionDescription.setServerName(o_HandshakeConnectionDescription.getServerName());
        o_LiveDBSocketConnectionDescription.setServerLongName(o_HandshakeConnectionDescription.getServerLongName());
        o_LiveDBSocketConnectionDescription.setServerVersion(o_HandshakeConnectionDescription.getServerVersion());
        o_LiveDBSocketConnectionDescription.setConnectionRemark(o_HandshakeConnectionDescription.getConnectionRemark());
        int intConnectionStatus = p_LiveDBSocketHandshake.getConnectionStatus();
        o_LiveDBSocket.setHandshakeConfirmed(true);
        o_LiveDBSocket.setConnectionStatus(intConnectionStatus);
        if (intConnectionStatus == 6) {
            LiveDBSocketChannelManagement.eventLiveDBSocketError(o_LiveDBSocket, new Exception("Server refuses the connection: " + o_LiveDBSocketConnectionDescription.getConnectionRemark()), ERROR_SERVERREFUSECONNECTION);
        } else if (m_LiveDBSocketWatchdogConnection != null && !m_LiveDBSocketWatchdogConnection.getIsRunning()) {
            m_LiveDBSocketWatchdogConnection.start(m_WatchdogConnectionTime);
        }
    }

    public static void eventConnectionLost(final LiveDBSocketChannelMerger p_LiveDBSocketChannelMerger) {
        if (p_LiveDBSocketChannelMerger == null) {
            return;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        Runnable o_Runnable = new Runnable(){

            @Override
            public void run() {
                if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
                    return;
                }
                LiveDBSocketChannelManagement.handleConnectionLost(p_LiveDBSocketChannelMerger);
                m_LiveDBCloseSemaphore.leaveWorkerSection();
            }
        };
        if (Thread.currentThread() == s_LiveDBAdminThread.getThread()) {
            o_Runnable.run();
        } else {
            s_LiveDBAdminThread.addRunnable(o_Runnable);
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    private static void handleConnectionLost(LiveDBSocketChannelMerger p_LiveDBSocketChannelMerger) {
        if (p_LiveDBSocketChannelMerger == null) {
            return;
        }
        LiveDBSocket o_LiveDBSocket = p_LiveDBSocketChannelMerger.getLiveDBSocket();
        if (o_LiveDBSocket == null) {
            return;
        }
        try {
            o_LiveDBSocket.setHandshakeConfirmed(false);
            int intConnectionStatus = o_LiveDBSocket.getConnectionStatus();
            switch (intConnectionStatus) {
                case 9: {
                    LiveDBSocketChannelManagement.finishCloseLiveDBSocket(o_LiveDBSocket);
                    return;
                }
                case 2: 
                case 3: {
                    o_LiveDBSocket.setConnectionStatus(8);
                    break;
                }
                default: {
                    o_LiveDBSocket.setConnectionStatus(8);
                }
            }
            p_LiveDBSocketChannelMerger.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void eventConnectionFailed(final LiveDBSocketChannelMerger p_LiveDBSocketChannelMerger) {
        if (p_LiveDBSocketChannelMerger == null) {
            return;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        Runnable o_Runnable = new Runnable(){

            @Override
            public void run() {
                if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
                    return;
                }
                LiveDBSocketChannelManagement.handleConnectionFailed(p_LiveDBSocketChannelMerger);
                m_LiveDBCloseSemaphore.leaveWorkerSection();
            }
        };
        if (Thread.currentThread() == s_LiveDBAdminThread.getThread()) {
            o_Runnable.run();
        } else {
            s_LiveDBAdminThread.addRunnable(o_Runnable);
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    private static void handleConnectionFailed(LiveDBSocketChannelMerger p_LiveDBSocketChannelMerger) {
        if (p_LiveDBSocketChannelMerger == null) {
            return;
        }
        LiveDBSocket o_LiveDBSocket = p_LiveDBSocketChannelMerger.getLiveDBSocket();
        if (o_LiveDBSocket != null) {
            o_LiveDBSocket.setConnectionStatus(6);
        }
        LiveDBSocketChannelManagement.finishCloseLiveDBSocket(o_LiveDBSocket);
    }

    public static void selectorMessageRead(final LiveDBSocketChannelMerger p_LiveDBSocketChannelMerger, Serializable p_Message, final boolean p_RareByteInterpreterUsed) {
        if (p_LiveDBSocketChannelMerger == null) {
            return;
        }
        if (p_Message == null) {
            return;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        if (p_Message instanceof LiveDBMessageSocketHandshake) {
            final LiveDBMessageSocketHandshake o_LiveDBSocketHandshake = (LiveDBMessageSocketHandshake)p_Message;
            int intConnectionStatus = o_LiveDBSocketHandshake.getConnectionStatus();
            if (intConnectionStatus < 0) {
                intConnectionStatus = 1;
            }
            switch (intConnectionStatus) {
                case 1: {
                    Runnable o_Runnable = new Runnable(){

                        @Override
                        public void run() {
                            if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
                                return;
                            }
                            LiveDBSocketChannelManagement.handleServerReceivedHandshake(p_LiveDBSocketChannelMerger, o_LiveDBSocketHandshake, p_RareByteInterpreterUsed);
                            m_LiveDBCloseSemaphore.leaveWorkerSection();
                        }
                    };
                    if (Thread.currentThread() == s_LiveDBAdminThread.getThread()) {
                        o_Runnable.run();
                        break;
                    }
                    s_LiveDBAdminThread.addRunnable(o_Runnable);
                    break;
                }
                case 2: 
                case 6: {
                    LiveDBSocket o_LiveDBSocket = p_LiveDBSocketChannelMerger.getLiveDBSocket();
                    if (o_LiveDBSocket != null) {
                        o_LiveDBSocket.closeMessages();
                    }
                }
                case 3: {
                    Runnable o_Runnable = new Runnable(){

                        @Override
                        public void run() {
                            if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
                                return;
                            }
                            LiveDBSocketChannelManagement.handleClientReceivedHandshake(p_LiveDBSocketChannelMerger, o_LiveDBSocketHandshake, p_RareByteInterpreterUsed);
                            m_LiveDBCloseSemaphore.leaveWorkerSection();
                        }
                    };
                    if (Thread.currentThread() == s_LiveDBAdminThread.getThread()) {
                        o_Runnable.run();
                        break;
                    }
                    s_LiveDBAdminThread.addRunnable(o_Runnable);
                }
            }
            m_LiveDBCloseSemaphore.leaveWorkerSection();
            return;
        }
        if (p_Message instanceof LiveDBMessageSocketClose) {
            Runnable o_Runnable = new Runnable(){

                @Override
                public void run() {
                    if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
                        return;
                    }
                    LiveDBSocketChannelManagement.finishCloseLiveDBSocket(p_LiveDBSocketChannelMerger.getLiveDBSocket());
                    m_LiveDBCloseSemaphore.leaveWorkerSection();
                }
            };
            if (Thread.currentThread() == s_LiveDBAdminThread.getThread()) {
                o_Runnable.run();
            } else {
                s_LiveDBAdminThread.addRunnable(o_Runnable);
            }
            m_LiveDBCloseSemaphore.leaveWorkerSection();
            return;
        }
        if (p_Message instanceof LiveDBMessageServerClose) {
            int intShutdownFlag = ((LiveDBMessageServerClose)p_Message).getCloseFlag();
            LiveDBSocketChannelManagement.actionCloseServer(p_LiveDBSocketChannelMerger.getLiveDBSocket(), intShutdownFlag);
            m_LiveDBCloseSemaphore.leaveWorkerSection();
            return;
        }
        if (p_Message instanceof LiveDBMessageSocketWatchdog) {
            LiveDBSocket o_LiveDBSocket = p_LiveDBSocketChannelMerger.getLiveDBSocket();
            if (o_LiveDBSocket != null && o_LiveDBSocket.getOutgoingMessagesCount() - o_LiveDBSocket.getOutgoingStreamCount() <= 0) {
                LiveDBMessageSocketWatchdogAnswer o_LiveDBMessageSocketWatchdogAnswer = new LiveDBMessageSocketWatchdogAnswer();
                o_LiveDBSocket.addOutgoingMessage(o_LiveDBMessageSocketWatchdogAnswer);
            }
            m_LiveDBCloseSemaphore.leaveWorkerSection();
            return;
        }
        if (p_Message instanceof LiveDBMessageSocketWatchdogAnswer) {
            m_LiveDBCloseSemaphore.leaveWorkerSection();
            return;
        }
        if (p_Message instanceof LiveDBMessageStreamInfo) {
            LiveDBStream o_LiveDBStream;
            LiveDBMessageStreamInfo o_StreamInfo = (LiveDBMessageStreamInfo)p_Message;
            LiveDBSocket o_LiveDBSocket = p_LiveDBSocketChannelMerger.getLiveDBSocket();
            if (o_LiveDBSocket != null && (o_LiveDBStream = o_LiveDBSocket.getIncomingStream(o_StreamInfo.getStreamID())) != null) {
                o_LiveDBSocket.addOutgoingMessage(o_LiveDBStream.getStreamConfirmPackage());
                m_LiveDBCloseSemaphore.leaveWorkerSection();
                return;
            }
        } else if (p_Message instanceof LiveDBMessageStreamPackage) {
            LiveDBStream o_LiveDBStream;
            LiveDBMessageStreamPackage o_StreamPackage = (LiveDBMessageStreamPackage)p_Message;
            LiveDBSocket o_LiveDBSocket = p_LiveDBSocketChannelMerger.getLiveDBSocket();
            if (o_LiveDBSocket != null && (o_LiveDBStream = o_LiveDBSocket.getIncomingStream(o_StreamPackage.getStreamID())) == null) {
                if (o_StreamPackage.getEndOfStream()) {
                    LiveDBMessageStreamConfirmation o_StreamConfirmObject = new LiveDBMessageStreamConfirmation(o_StreamPackage.getStreamID(), o_StreamPackage.getDataPosition());
                    o_LiveDBSocket.addOutgoingMessage(o_StreamConfirmObject);
                } else {
                    LiveDBMessageStreamCancel o_LiveDBMessageStreamCancel = new LiveDBMessageStreamCancel(o_StreamPackage.getStreamID(), "Receiver has closed the stream");
                    o_LiveDBSocket.addOutgoingMessage(o_LiveDBMessageStreamCancel);
                }
                m_LiveDBCloseSemaphore.leaveWorkerSection();
                return;
            }
        } else if (p_Message instanceof LiveDBMessageStreamConfirmation) {
            LiveDBStream o_LiveDBStream;
            LiveDBMessageStreamConfirmation o_StreamConfirmation = (LiveDBMessageStreamConfirmation)p_Message;
            LiveDBSocket o_LiveDBSocket = p_LiveDBSocketChannelMerger.getLiveDBSocket();
            if (o_LiveDBSocket != null && (o_LiveDBStream = o_LiveDBSocket.getOutgoingStream(o_StreamConfirmation.getStreamID())) != null) {
                o_LiveDBStream.selectorConfirmObject(o_StreamConfirmation);
            }
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
        LiveDBSocketChannelManagement.handleSelectorMessageRead(p_LiveDBSocketChannelMerger, p_Message);
    }

    private static void handleSelectorMessageRead(LiveDBSocketChannelMerger p_LiveDBSocketChannelMerger, Serializable p_Message) {
        if (p_LiveDBSocketChannelMerger == null) {
            return;
        }
        if (p_Message == null) {
            return;
        }
        LiveDBSocket o_LiveDBSocket = p_LiveDBSocketChannelMerger.getLiveDBSocket();
        if (o_LiveDBSocket == null) {
            return;
        }
        o_LiveDBSocket.addIncomingMessage(p_Message);
        LiveDBParserManager o_LiveDBParserManager = m_ParserManager;
        if (o_LiveDBParserManager == null) {
            return;
        }
        o_LiveDBParserManager.invokeParsing(o_LiveDBSocket);
    }

    public static void parseMessage(LiveDBSocket p_LiveDBSocket, Serializable p_Message) {
        if (p_LiveDBSocket == null) {
            return;
        }
        if (p_Message == null) {
            return;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        p_LiveDBSocket.parseMessage(p_Message);
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    public static void selectorMessageReadUnknown(LiveDBSocketChannelMerger p_LiveDBSocketChannelMerger) {
        if (p_LiveDBSocketChannelMerger == null) {
            return;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        LiveDBSocketChannelManagement.handleSelectorMessageReadUnkown(p_LiveDBSocketChannelMerger);
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleSelectorMessageReadUnkown(LiveDBSocketChannelMerger p_LiveDBSocketChannelMerger) {
        if (p_LiveDBSocketChannelMerger == null) {
            return;
        }
        final LiveDBSocket o_LiveDBSocket = p_LiveDBSocketChannelMerger.getLiveDBSocket();
        LiveDBAdminThread o_LiveDBAdminThread = s_LiveDBAdminThread;
        if (o_LiveDBSocket == null) {
            SocketChannel o_SocketChannel = p_LiveDBSocketChannelMerger.getSocketChannel();
            if (o_SocketChannel != null) {
                String stringClientRemoteIP = null;
                try {
                    InetSocketAddress o_RemoteInetSocketAddress = (InetSocketAddress)o_SocketChannel.socket().getRemoteSocketAddress();
                    stringClientRemoteIP = o_RemoteInetSocketAddress == null ? null : o_RemoteInetSocketAddress.getAddress().getHostAddress();
                }
                catch (Exception e) {
                    stringClientRemoteIP = null;
                }
                p_LiveDBSocketChannelMerger.close();
                if (stringClientRemoteIP != null) {
                    Object object = m_SyncServerVerbosedClientIP;
                    synchronized (object) {
                        if (m_ServerVerbosedClientIPs != null && !m_ServerVerbosedClientIPs.contains(stringClientRemoteIP)) {
                            final String stringVerbosedCLientIP = stringClientRemoteIP;
                            m_ServerVerbosedClientIPs.add(stringVerbosedCLientIP);
                            Runnable o_Runnable = new Runnable(){

                                @Override
                                public void run() {
                                    if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
                                        return;
                                    }
                                    LiveDBSocketChannelManagement.notifyServerListeners_VerbosedIP(stringVerbosedCLientIP, true);
                                    m_LiveDBCloseSemaphore.leaveWorkerSection();
                                }
                            };
                            if (o_LiveDBAdminThread != null) {
                                if (Thread.currentThread() == o_LiveDBAdminThread.getThread()) {
                                    o_Runnable.run();
                                } else {
                                    o_LiveDBAdminThread.addRunnable(o_Runnable);
                                }
                            }
                        }
                    }
                }
            }
            return;
        }
        Runnable o_Runnable = new Runnable(){

            @Override
            public void run() {
                if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
                    return;
                }
                o_LiveDBSocket.eventMessageReadUnknown();
                m_LiveDBCloseSemaphore.leaveWorkerSection();
            }
        };
        if (o_LiveDBAdminThread != null) {
            if (Thread.currentThread() == o_LiveDBAdminThread.getThread()) {
                o_Runnable.run();
            } else {
                o_LiveDBAdminThread.addRunnable(o_Runnable);
            }
        }
    }

    public static void selectorMessageWritten(final LiveDBSocketChannelMerger p_LiveDBSocketChannelMerger, final Object p_Object) {
        if (p_LiveDBSocketChannelMerger == null) {
            return;
        }
        if (p_Object instanceof LiveDBMessageSocketHandshake) {
            return;
        }
        if (p_Object instanceof LiveDBMessageSocketWatchdog) {
            return;
        }
        if (p_Object instanceof LiveDBMessageStreamPackage) {
            return;
        }
        if (p_Object instanceof LiveDBMessageStreamConfirmation) {
            return;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        Runnable o_Runnable = new Runnable(){

            @Override
            public void run() {
                if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
                    return;
                }
                LiveDBSocketChannelManagement.handleSelectorMessageWritten(p_LiveDBSocketChannelMerger, p_Object);
                m_LiveDBCloseSemaphore.leaveWorkerSection();
            }
        };
        if (Thread.currentThread() == s_LiveDBAdminThread.getThread()) {
            o_Runnable.run();
        } else {
            s_LiveDBAdminThread.addRunnable(o_Runnable);
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
        LiveDBSocketChannelManagement.checkGarbageCollection();
    }

    private static void handleSelectorMessageWritten(LiveDBSocketChannelMerger p_LiveDBSocketChannelMerger, Object p_Object) {
        if (p_LiveDBSocketChannelMerger == null) {
            return;
        }
        LiveDBSocket o_LiveDBSocket = p_LiveDBSocketChannelMerger.getLiveDBSocket();
        if (o_LiveDBSocket == null) {
            return;
        }
        o_LiveDBSocket.eventMessageWritten(p_Object);
    }

    public static void eventSelectorError(final LiveDBSocketChannelMerger p_LiveDBSocketChannelMerger, final Exception p_Exception, final String p_Remark) {
        if (p_LiveDBSocketChannelMerger == null) {
            return;
        }
        if (p_Exception == null) {
            return;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        Runnable o_Runnable = new Runnable(){

            @Override
            public void run() {
                if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
                    return;
                }
                LiveDBSocket o_LiveDBSocket = p_LiveDBSocketChannelMerger.getLiveDBSocket();
                LiveDBSocketChannelManagement.handleLiveDBSocketError(o_LiveDBSocket, p_Exception, p_Remark);
                m_LiveDBCloseSemaphore.leaveWorkerSection();
            }
        };
        if (Thread.currentThread() == s_LiveDBAdminThread.getThread()) {
            o_Runnable.run();
        } else {
            s_LiveDBAdminThread.addRunnable(o_Runnable);
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    public static void eventLiveDBSocketError(final LiveDBSocket p_LiveDBSocket, final Exception p_Exception, final String p_Remark) {
        if (p_LiveDBSocket == null) {
            return;
        }
        if (p_Exception == null) {
            return;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        Runnable o_Runnable = new Runnable(){

            @Override
            public void run() {
                if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
                    return;
                }
                LiveDBSocketChannelManagement.handleLiveDBSocketError(p_LiveDBSocket, p_Exception, p_Remark);
                m_LiveDBCloseSemaphore.leaveWorkerSection();
            }
        };
        if (Thread.currentThread() == s_LiveDBAdminThread.getThread()) {
            o_Runnable.run();
        } else {
            s_LiveDBAdminThread.addRunnable(o_Runnable);
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    private static void handleLiveDBSocketError(LiveDBSocket p_LiveDBSocket, Exception p_Exception, String p_Remark) {
        if (p_LiveDBSocket == null) {
            LiveDBSocketChannelManagement.notifyServerListeners_Error(p_Exception, p_Remark);
            return;
        }
        p_LiveDBSocket.eventError(p_Exception, p_Remark);
    }

    public static void eventServerError(final Exception p_Exception, final String p_Remark) {
        if (p_Exception == null) {
            return;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        Runnable o_Runnable = new Runnable(){

            @Override
            public void run() {
                if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
                    return;
                }
                LiveDBSocketChannelManagement.handleServerError(p_Exception, p_Remark);
                m_LiveDBCloseSemaphore.leaveWorkerSection();
            }
        };
        if (Thread.currentThread() == s_LiveDBAdminThread.getThread()) {
            o_Runnable.run();
        } else {
            s_LiveDBAdminThread.addRunnable(o_Runnable);
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    private static void handleServerError(Exception p_Exception, String p_Remark) {
        LiveDBSocketChannelManagement.notifyServerListeners_Error(p_Exception, p_Remark);
    }

    public static void eventError(final Exception p_Exception, final String p_Remark) {
        if (p_Exception == null) {
            return;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        Runnable o_Runnable = new Runnable(){

            @Override
            public void run() {
                if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
                    return;
                }
                LiveDBSocketChannelManagement.handleManagementError(p_Exception, p_Remark);
                m_LiveDBCloseSemaphore.leaveWorkerSection();
            }
        };
        if (Thread.currentThread() == s_LiveDBAdminThread.getThread()) {
            o_Runnable.run();
        } else {
            s_LiveDBAdminThread.addRunnable(o_Runnable);
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    private static void handleManagementError(Exception p_Exception, String p_Remark) {
        if (p_Exception != null) {
            LogEvent.write((String)"LiveDBSocketChannelManagement", (String)"Error", (String)p_Exception.getMessage(), (String)p_Remark);
        } else {
            LogEvent.write((String)"LiveDBSocketChannelManagement", (String)"Error", (String)"unknown", (String)p_Remark);
        }
    }

    public static void setWatchdogConnection_Time(long p_Milliseconds) {
        if (p_Milliseconds <= LiveDBSocketWatchdogConnection.s_MinScheduleTime) {
            p_Milliseconds = LiveDBSocketWatchdogConnection.s_MinScheduleTime;
        }
        if (m_WatchdogConnectionTime == p_Milliseconds) {
            return;
        }
        m_WatchdogConnectionTime = p_Milliseconds;
        if (m_LiveDBSocketWatchdogConnection != null) {
            m_LiveDBSocketWatchdogConnection.setWatchdogConnection_Time(p_Milliseconds);
        }
    }

    public static long getWatchdogConnection_Time() {
        return m_WatchdogConnectionTime;
    }

    public static boolean getWatchdogConnection_IsRunning() {
        if (m_LiveDBSocketWatchdogConnection == null) {
            return false;
        }
        return m_LiveDBSocketWatchdogConnection.getIsRunning();
    }

    public static void eventWatchdogConnection_Check() {
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        if (Thread.currentThread() == s_LiveDBAdminThread.getThread()) {
            s_RunnableWatchdogConnection_Check.run();
        } else {
            s_LiveDBAdminThread.addRunnable(s_RunnableWatchdogConnection_Check);
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    public static void eventWatchdogConnection_Send() {
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
        if (Thread.currentThread() == s_LiveDBAdminThread.getThread()) {
            s_RunnableWatchdogConnection_Send.run();
        } else {
            s_LiveDBAdminThread.addRunnable(s_RunnableWatchdogConnection_Send);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleWatchdogConnectionStarted() {
        LiveDBSocket o_LiveDBSocket;
        Object object = m_SyncLiveDBSocketLists;
        synchronized (object) {
            if (m_ServerLiveDBSocketList != null) {
                for (int intSocket = 0; intSocket < m_ServerLiveDBSocketList.getLiveDBSocketCount(); ++intSocket) {
                    o_LiveDBSocket = m_ServerLiveDBSocketList.getLiveDBSocket(intSocket);
                    if (o_LiveDBSocket == null) continue;
                    o_LiveDBSocket.setTimeStampReaction();
                }
            }
        }
        Object object2 = m_SyncLiveDBSocketLists;
        synchronized (object2) {
            for (int intList = 0; intList < m_ClientLiveDBSocketLists.size(); ++intList) {
                LiveDBSocketList o_LiveDBSocketList = m_ClientLiveDBSocketLists.get(intList);
                if (o_LiveDBSocketList == null) continue;
                for (int intSocket = 0; intSocket < o_LiveDBSocketList.getLiveDBSocketCount(); ++intSocket) {
                    o_LiveDBSocket = o_LiveDBSocketList.getLiveDBSocket(intSocket);
                    o_LiveDBSocket.setTimeStampReaction();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleWatchdogConnection_Send() {
        LiveDBSocket o_LiveDBSocket;
        ArrayList<LiveDBSocket> o_LiveDBSockets = null;
        Object object = m_SyncLiveDBSocketLists;
        synchronized (object) {
            if (m_ServerLiveDBSocketList != null) {
                o_LiveDBSockets = new ArrayList<LiveDBSocket>();
                for (int intSocket = 0; intSocket < m_ServerLiveDBSocketList.getLiveDBSocketCount(); ++intSocket) {
                    o_LiveDBSocket = m_ServerLiveDBSocketList.getLiveDBSocket(intSocket);
                    if (o_LiveDBSocket == null || !o_LiveDBSocket.getHandshakeConfirmed() || o_LiveDBSocket.getConnectionStatus() != 2 || o_LiveDBSocket.getOutgoingMessagesCount() - o_LiveDBSocket.getOutgoingStreamCount() > 0) continue;
                    o_LiveDBSockets.add(o_LiveDBSocket);
                }
            }
        }
        if (o_LiveDBSockets != null) {
            for (int intSocket = 0; intSocket < o_LiveDBSockets.size(); ++intSocket) {
                o_LiveDBSocket = (LiveDBSocket)o_LiveDBSockets.get(intSocket);
                o_LiveDBSocket.addOutgoingMessage(LiveDBSocketWatchdogConnection.m_LiveDBSocketWatchdog);
            }
            o_LiveDBSockets.clear();
        }
        o_LiveDBSockets = null;
        Object intSocket = m_SyncLiveDBSocketLists;
        synchronized (intSocket) {
            if (m_ClientLiveDBSocketLists != null) {
                o_LiveDBSockets = new ArrayList();
                for (int intList = m_ClientLiveDBSocketLists.size() - 1; intList >= 0; --intList) {
                    LiveDBSocketList o_LiveDBSocketList = m_ClientLiveDBSocketLists.get(intList);
                    if (o_LiveDBSocketList == null) continue;
                    for (int intSocket2 = o_LiveDBSocketList.getLiveDBSocketCount() - 1; intSocket2 >= 0; --intSocket2) {
                        o_LiveDBSocket = o_LiveDBSocketList.getLiveDBSocket(intSocket2);
                        if (o_LiveDBSocket == null) continue;
                        o_LiveDBSockets.add(o_LiveDBSocket);
                    }
                }
            }
        }
        if (o_LiveDBSockets != null) {
            for (int intSocket3 = 0; intSocket3 < o_LiveDBSockets.size(); ++intSocket3) {
                o_LiveDBSocket = (LiveDBSocket)o_LiveDBSockets.get(intSocket3);
                if (o_LiveDBSocket == null || !o_LiveDBSocket.getHandshakeConfirmed() || o_LiveDBSocket.getConnectionStatus() != 2 || o_LiveDBSocket.getOutgoingMessagesCount() - o_LiveDBSocket.getOutgoingStreamCount() > 0) continue;
                o_LiveDBSocket.addOutgoingMessage(LiveDBSocketWatchdogConnection.m_LiveDBSocketWatchdog);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleWatchdogConnection_Check() {
        LiveDBSocket o_LiveDBSocket;
        ArrayList<LiveDBSocket> o_LostLiveDBSockets = null;
        ArrayList<LiveDBSocket> o_LiveDBSockets_Alive = null;
        Object object = m_SyncLiveDBSocketLists;
        synchronized (object) {
            if (m_ServerLiveDBSocketList != null) {
                o_LiveDBSockets_Alive = m_ServerLiveDBSocketList.getLiveDBSocketCount() <= 0 ? null : new ArrayList<LiveDBSocket>();
                o_LostLiveDBSockets = null;
                m_WatchdogLostLiveDBSockets.clear();
                for (int intSocket = 0; intSocket < m_ServerLiveDBSocketList.getLiveDBSocketCount(); ++intSocket) {
                    o_LiveDBSocket = m_ServerLiveDBSocketList.getLiveDBSocket(intSocket);
                    if (o_LiveDBSocket == null || !o_LiveDBSocket.getHandshakeConfirmed() || o_LiveDBSocket.getConnectionStatus() != 2) continue;
                    if (!o_LiveDBSocket.checkTimeStampReaction()) {
                        m_WatchdogLostLiveDBSockets.add(o_LiveDBSocket);
                        continue;
                    }
                    if (o_LiveDBSocket.getOutgoingMessagesCount() - o_LiveDBSocket.getOutgoingStreamCount() > 0) continue;
                    o_LiveDBSockets_Alive.add(o_LiveDBSocket);
                }
                if (m_WatchdogLostLiveDBSockets.size() > 0) {
                    o_LostLiveDBSockets = new ArrayList<LiveDBSocket>(m_WatchdogLostLiveDBSockets.size());
                    o_LostLiveDBSockets.addAll(m_WatchdogLostLiveDBSockets);
                    m_WatchdogLostLiveDBSockets.clear();
                }
            }
        }
        if (o_LiveDBSockets_Alive != null) {
            for (int intSocket = 0; intSocket < o_LiveDBSockets_Alive.size(); ++intSocket) {
                o_LiveDBSocket = (LiveDBSocket)o_LiveDBSockets_Alive.get(intSocket);
                o_LiveDBSocket.addOutgoingMessage(LiveDBSocketWatchdogConnection.m_LiveDBSocketWatchdog);
            }
        }
        if (o_LostLiveDBSockets != null) {
            for (int intLostSocket = o_LostLiveDBSockets.size() - 1; intLostSocket >= 0; --intLostSocket) {
                o_LiveDBSocket = (LiveDBSocket)o_LostLiveDBSockets.get(intLostSocket);
                LiveDBSocketChannelManagement.eventConnectionLost(o_LiveDBSocket.getLiveDBSocketChannelMerger());
            }
        }
        o_LiveDBSockets_Alive = null;
        o_LostLiveDBSockets = null;
        Object intSocket = m_SyncLiveDBSocketLists;
        synchronized (intSocket) {
            if (m_ClientLiveDBSocketLists != null) {
                o_LiveDBSockets_Alive = m_ClientLiveDBSocketLists.size() <= 0 ? null : new ArrayList();
                m_WatchdogLostLiveDBSockets.clear();
                o_LostLiveDBSockets = null;
                for (int intList = m_ClientLiveDBSocketLists.size() - 1; intList >= 0; --intList) {
                    LiveDBSocketList o_LiveDBSocketList = m_ClientLiveDBSocketLists.get(intList);
                    if (o_LiveDBSocketList == null) continue;
                    for (int intSocket2 = o_LiveDBSocketList.getLiveDBSocketCount() - 1; intSocket2 >= 0; --intSocket2) {
                        o_LiveDBSocket = o_LiveDBSocketList.getLiveDBSocket(intSocket2);
                        if (o_LiveDBSocket == null || !o_LiveDBSocket.getHandshakeConfirmed() || o_LiveDBSocket.getConnectionStatus() != 2) continue;
                        if (!o_LiveDBSocket.checkTimeStampReaction()) {
                            m_WatchdogLostLiveDBSockets.add(o_LiveDBSocket);
                            continue;
                        }
                        if (o_LiveDBSocket.getOutgoingMessagesCount() - o_LiveDBSocket.getOutgoingStreamCount() > 0) continue;
                        o_LiveDBSockets_Alive.add(o_LiveDBSocket);
                    }
                }
                if (m_WatchdogLostLiveDBSockets.size() > 0) {
                    o_LostLiveDBSockets = new ArrayList(m_WatchdogLostLiveDBSockets.size());
                    o_LostLiveDBSockets.addAll(m_WatchdogLostLiveDBSockets);
                    m_WatchdogLostLiveDBSockets.clear();
                }
            }
        }
        if (o_LiveDBSockets_Alive != null) {
            for (int intSocket3 = 0; intSocket3 < o_LiveDBSockets_Alive.size(); ++intSocket3) {
                o_LiveDBSocket = (LiveDBSocket)o_LiveDBSockets_Alive.get(intSocket3);
                o_LiveDBSocket.addOutgoingMessage(LiveDBSocketWatchdogConnection.m_LiveDBSocketWatchdog);
            }
        }
        if (o_LostLiveDBSockets != null) {
            for (int intLostSocket = o_LostLiveDBSockets.size() - 1; intLostSocket >= 0; --intLostSocket) {
                o_LiveDBSocket = (LiveDBSocket)o_LostLiveDBSockets.get(intLostSocket);
                LiveDBSocketChannelManagement.eventConnectionLost(o_LiveDBSocket.getLiveDBSocketChannelMerger());
            }
        }
    }

    public static void setWatchdogConnectionLost_Time(long p_Milliseconds) {
        if (p_Milliseconds <= LiveDBSocketWatchdogConnectionLost.s_MinScheduleTime) {
            return;
        }
        if (m_WatchdogConnectionLostTime == p_Milliseconds) {
            return;
        }
        m_WatchdogConnectionLostTime = p_Milliseconds;
        if (m_LiveDBSocketWatchdogConnectionLost != null) {
            m_LiveDBSocketWatchdogConnectionLost.setWatchdogConnectionLost_Time(m_WatchdogConnectionLostTime);
        }
    }

    public static long getWatchdogConnectionLost_Time() {
        return m_WatchdogConnectionLostTime;
    }

    public static void eventWatchdogConnectionLost() {
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        s_LiveDBAdminThread.addRunnable(s_RunnableWatchdogConnectionLost);
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleWatchdogConnectionLost() {
        LiveDBSocket o_LiveDBSocket;
        ArrayList<LiveDBSocket> o_CloseLiveDBSockets = null;
        long longTimeWatchdog = System.currentTimeMillis();
        Object object = m_SyncLiveDBSocketLists;
        synchronized (object) {
            if (m_ServerLiveDBSocketList != null) {
                m_WatchdogCloseLiveDBSockets.clear();
                for (int intSocket = 0; intSocket < m_ServerLiveDBSocketList.getLiveDBSocketCount(); ++intSocket) {
                    long longConnectionLostTime;
                    o_LiveDBSocket = m_ServerLiveDBSocketList.getLiveDBSocket(intSocket);
                    if (o_LiveDBSocket == null || o_LiveDBSocket.getConnectionStatus() != 8 || (longConnectionLostTime = o_LiveDBSocket.getConnectionLostDate()) <= 0L || longTimeWatchdog - longConnectionLostTime <= m_WatchdogConnectionLostTime) continue;
                    m_WatchdogCloseLiveDBSockets.add(o_LiveDBSocket);
                }
                if (m_WatchdogCloseLiveDBSockets.size() > 0) {
                    o_CloseLiveDBSockets = new ArrayList<LiveDBSocket>(m_WatchdogCloseLiveDBSockets.size());
                    o_CloseLiveDBSockets.addAll(m_WatchdogCloseLiveDBSockets);
                    m_WatchdogCloseLiveDBSockets.clear();
                }
            }
        }
        if (o_CloseLiveDBSockets != null) {
            for (int intCloseSocket = 0; intCloseSocket < o_CloseLiveDBSockets.size(); ++intCloseSocket) {
                o_LiveDBSocket = (LiveDBSocket)o_CloseLiveDBSockets.get(intCloseSocket);
                LiveDBSocketChannelManagement.actionCloseLiveDBSocket(o_LiveDBSocket);
            }
        }
    }

    private static void eventLiveDBSocketListEmpty(final LiveDBSocketList p_LiveDBSocketList) {
        if (p_LiveDBSocketList == null) {
            return;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        Runnable o_Runnable = new Runnable(){

            @Override
            public void run() {
                if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
                    return;
                }
                LiveDBSocketChannelManagement.handleLiveDBSocketListEmpty(p_LiveDBSocketList);
                m_LiveDBCloseSemaphore.leaveWorkerSection();
            }
        };
        if (Thread.currentThread() == s_LiveDBAdminThread.getThread()) {
            o_Runnable.run();
        } else {
            s_LiveDBAdminThread.addRunnable(0, o_Runnable);
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleLiveDBSocketListEmpty(LiveDBSocketList p_LiveDBSocketList) {
        if (p_LiveDBSocketList == null) {
            return;
        }
        if (p_LiveDBSocketList == m_ServerLiveDBSocketList) {
            if (m_ServerConnectionStatus == 9) {
                Runnable o_Runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
                            return;
                        }
                        LiveDBSocketChannelManagement.finishCloseServer();
                        m_LiveDBCloseSemaphore.leaveWorkerSection();
                    }
                };
                if (Thread.currentThread() == s_LiveDBAdminThread.getThread()) {
                    o_Runnable.run();
                } else {
                    s_LiveDBAdminThread.addRunnable(0, o_Runnable);
                }
                return;
            }
        } else {
            p_LiveDBSocketList.close();
            Object object = m_SyncLiveDBSocketLists;
            synchronized (object) {
                if (m_ClientLiveDBSocketLists != null) {
                    m_ClientLiveDBSocketLists.remove(p_LiveDBSocketList);
                }
            }
        }
    }

    public static long getFreeMemory() {
        return m_Runtime.freeMemory();
    }

    public static long getMaximalMemory() {
        return m_Runtime.maxMemory();
    }

    public static long getTotalMemory() {
        return m_Runtime.totalMemory();
    }

    public static void setGarbageCollectionRatio(double p_Ratio) {
        m_GarbageCollectionRatio = p_Ratio < 0.0 ? 0.0 : (p_Ratio > 1.0 ? 1.0 : p_Ratio);
    }

    public static double getGarbageCollectionRatio() {
        return m_GarbageCollectionRatio;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkGarbageCollection() {
        if (m_GarbageCollectionRatio <= 0.0) {
            return false;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        if ((double)LiveDBSocketChannelManagement.getFreeMemory() / (double)LiveDBSocketChannelManagement.getTotalMemory() >= m_GarbageCollectionRatio) {
            m_LiveDBCloseSemaphore.leaveWorkerSection();
            return false;
        }
        Object object = m_SyncGarbageCollection;
        synchronized (object) {
            if (m_GarbageCollectorRequest) {
                m_LiveDBCloseSemaphore.leaveWorkerSection();
                return true;
            }
            m_GarbageCollectorRequest = true;
            Runnable o_Runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
                        return;
                    }
                    LogEvent.write((String)"Start GarbageCollection manually", (String)("FreeMemory: " + LiveDBSocketChannelManagement.getFreeMemory()), (String)("TotalMemory: " + LiveDBSocketChannelManagement.getTotalMemory()), (String)("MaximalMemory: " + LiveDBSocketChannelManagement.getMaximalMemory()));
                    m_Runtime.gc();
                    LogEvent.write((String)"End GarbageCollection manually", (String)("FreeMemory: " + LiveDBSocketChannelManagement.getFreeMemory()), (String)("TotalMemory: " + LiveDBSocketChannelManagement.getTotalMemory()), (String)("MaximalMemory: " + LiveDBSocketChannelManagement.getMaximalMemory()));
                    Object object = m_SyncGarbageCollection;
                    synchronized (object) {
                        m_GarbageCollectorRequest = false;
                    }
                    m_LiveDBCloseSemaphore.leaveWorkerSection();
                }
            };
            if (Thread.currentThread() == s_LiveDBAdminThread.getThread()) {
                o_Runnable.run();
            } else {
                s_LiveDBAdminThread.addRunnable(o_Runnable);
            }
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
        return true;
    }

    public static boolean loadRareByteInterpreter(String p_JarPathName, String p_ClassName) {
        Constructor o_Constructor;
        Class o_Class;
        if (p_JarPathName == null) {
            return false;
        }
        if (p_ClassName == null) {
            return false;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        JarClassLoader o_JarClassLoader = new JarClassLoader(p_JarPathName);
        if (!o_JarClassLoader.isValid()) {
            LiveDBSocketChannelManagement.notifyServerListeners_Error(new Exception("load RareByteInterpreter invalid JarFile" + p_JarPathName), ERROR_RAREBYTEINTERPRETER_JARFILE);
            m_LiveDBCloseSemaphore.leaveWorkerSection();
            return false;
        }
        String stringClassPathName = p_ClassName.length() <= 27 || !p_ClassName.substring(0, 27).equals("RareByteInterpreterPackage.") ? "RareByteInterpreterPackage." + p_ClassName : p_ClassName;
        try {
            o_Class = o_JarClassLoader.loadClass(stringClassPathName);
        }
        catch (ClassNotFoundException e_ClassNotFoundException) {
            LiveDBSocketChannelManagement.notifyServerListeners_Error(e_ClassNotFoundException, ERROR_RAREBYTEINTERPRETER_CLASSNAME);
            m_LiveDBCloseSemaphore.leaveWorkerSection();
            return false;
        }
        try {
            o_Constructor = o_Class.getConstructor(new Class[0]);
        }
        catch (Exception e_Exception) {
            LiveDBSocketChannelManagement.notifyServerListeners_Error(e_Exception, ERROR_RAREBYTEINTERPRETER_NOCONSTRUCTOR);
            m_LiveDBCloseSemaphore.leaveWorkerSection();
            return false;
        }
        try {
            m_RareByteInterpreter = (RareByteInterpreterInterface)o_Constructor.newInstance(new Object[0]);
        }
        catch (Exception e_Exception) {
            LiveDBSocketChannelManagement.notifyServerListeners_Error(e_Exception, ERROR_RAREBYTEINTERPRETER_CREATEINSTANCE);
            m_LiveDBCloseSemaphore.leaveWorkerSection();
            return false;
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
        return true;
    }

    public static void setRareByteInterpreter(RareByteInterpreterInterface p_RareByteInterpreterInterface) {
        m_RareByteInterpreter = p_RareByteInterpreterInterface;
    }

    public static RareByteInterpreterInterface getRareByteInterpreter() {
        return m_RareByteInterpreter;
    }

    public static LiveDBAdminThread getLiveDBAdminThread() {
        return s_LiveDBAdminThread;
    }

    public void eventLanguageChanged(Locale p_OldLanguage, Locale p_SelectedLanguage) {
    }

    static {
        m_ServerConnectionStatus = 0;
        m_ServerListeners = new ArrayList();
        m_ServerVerbosedClientIPs = new ArrayList();
        m_ClientLiveDBSocketLists = new ArrayList();
        m_RareByteInterpreter = null;
        s_LiveDBAdminThread = new LiveDBAdminThread();
        m_IsInitialized = false;
        m_ParserManager = new LiveDBParserManager(-1);
        m_LiveDBSocketWatchdogConnection = new LiveDBSocketWatchdogConnection();
        m_WatchdogConnectionTime = LiveDBSocketWatchdogConnection.s_DefaultScheduleTime;
        m_WatchdogLostLiveDBSockets = new ArrayList();
        m_LiveDBSocketWatchdogConnectionLost = new LiveDBSocketWatchdogConnectionLost();
        m_WatchdogConnectionLostTime = LiveDBSocketWatchdogConnectionLost.s_DefaultScheduleTime;
        m_WatchdogCloseLiveDBSockets = new ArrayList();
        s_RunnableWatchdogConnection_Send = new Runnable(){

            @Override
            public void run() {
                if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
                    return;
                }
                LiveDBSocketChannelManagement.handleWatchdogConnection_Send();
                m_LiveDBCloseSemaphore.leaveWorkerSection();
            }
        };
        s_RunnableWatchdogConnection_Check = new Runnable(){

            @Override
            public void run() {
                if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
                    return;
                }
                LiveDBSocketChannelManagement.handleWatchdogConnection_Check();
                m_LiveDBCloseSemaphore.leaveWorkerSection();
            }
        };
        s_RunnableWatchdogConnectionLost = new Runnable(){

            @Override
            public void run() {
                if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
                    return;
                }
                LiveDBSocketChannelManagement.handleWatchdogConnectionLost();
                m_LiveDBCloseSemaphore.leaveWorkerSection();
            }
        };
        m_Runtime = Runtime.getRuntime();
        m_GarbageCollectionRatio = 0.0;
        m_GarbageCollectorRequest = false;
        m_LiveDBCloseSemaphore = new LiveDBCloseSemaphore("LiveDBSocketChannelManagement");
        m_SyncLiveDBSocketLists = new Object();
        m_SyncServerListeners = new Object();
        m_SyncServerVerbosedClientIP = new Object();
        m_SyncGarbageCollection = new Object();
    }

    public static class LiveDBSocketList {
        private LiveDBConnectionDescription m_LiveDBConnectionDescription;
        private InetSocketAddress m_ServerInetSocketAddress;
        private LiveDBSelector m_LiveDBSelector;
        private ArrayList<LiveDBSocket> m_LiveDBSockets;
        private LiveDBCloseSemaphore m_InnerCloseSemaphore;
        private final Object m_SyncLiveDBSockets = new Object();

        public LiveDBSocketList(LiveDBConnectionDescription p_LiveDBConnectionDescription) {
            this.initMembers();
            this.m_LiveDBConnectionDescription = p_LiveDBConnectionDescription;
            this.m_LiveDBSelector = new LiveDBSelector();
        }

        private void initMembers() {
            this.m_InnerCloseSemaphore = new LiveDBCloseSemaphore(this.getClass().getName());
            this.m_LiveDBSockets = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            if (!this.m_InnerCloseSemaphore.enterCloseSection()) {
                return;
            }
            ArrayList<LiveDBSocket> o_LiveDBSockets = null;
            Object object = this.m_SyncLiveDBSockets;
            synchronized (object) {
                if (this.m_LiveDBSockets != null) {
                    o_LiveDBSockets = new ArrayList<LiveDBSocket>(this.m_LiveDBSockets.size());
                    o_LiveDBSockets.addAll(this.m_LiveDBSockets);
                }
            }
            if (o_LiveDBSockets != null) {
                for (int intSocket = o_LiveDBSockets.size() - 1; intSocket >= 0; --intSocket) {
                    LiveDBSocket o_LiveDBSocket = (LiveDBSocket)o_LiveDBSockets.get(intSocket);
                    if (o_LiveDBSocket == null) continue;
                    o_LiveDBSocket.setConnectionStatus(9);
                    LiveDBSocketChannelManagement.finishCloseLiveDBSocket(o_LiveDBSocket);
                }
            }
            if (this.m_LiveDBSelector != null) {
                this.m_LiveDBSelector.close();
            }
            Object object2 = this.m_SyncLiveDBSockets;
            synchronized (object2) {
                if (this.m_LiveDBSockets != null) {
                    this.m_LiveDBSockets.clear();
                }
            }
            this.m_InnerCloseSemaphore.leaveCloseSection();
        }

        public InetSocketAddress getServerInetSocketAddress() {
            return this.m_ServerInetSocketAddress;
        }

        public static boolean checkServerAdressIsLoopback(String p_ServerURL, int p_ServerPort) {
            boolean boolIsLoopback = false;
            InetSocketAddress o_ServerInetSocketAddress = new InetSocketAddress(p_ServerURL, p_ServerPort);
            InetAddress o_ServerInetAddress = o_ServerInetSocketAddress.getAddress();
            boolIsLoopback = o_ServerInetAddress.isLoopbackAddress();
            return boolIsLoopback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean checkServerAddress() {
            String stringServerIP;
            boolean boolServerAddressOk = true;
            boolean boolServerAddressChanged = false;
            if (!this.m_InnerCloseSemaphore.enterWorkerSection()) {
                return false;
            }
            InetSocketAddress o_ServerInetSocketAddress = null;
            if (this.m_ServerInetSocketAddress != null && !this.m_ServerInetSocketAddress.isUnresolved()) {
                this.m_InnerCloseSemaphore.leaveWorkerSection();
                return true;
            }
            o_ServerInetSocketAddress = LiveDBSocketChannelManagement.getInetSocketAddressIP4(this.m_LiveDBConnectionDescription.getServerRemoteURL(), this.m_LiveDBConnectionDescription.getServerPort());
            if (o_ServerInetSocketAddress == null) {
                o_ServerInetSocketAddress = new InetSocketAddress(this.m_LiveDBConnectionDescription.getServerRemoteURL(), this.m_LiveDBConnectionDescription.getServerPort());
            }
            if (o_ServerInetSocketAddress.isUnresolved()) {
                boolServerAddressOk = false;
                stringServerIP = "";
            } else {
                stringServerIP = o_ServerInetSocketAddress.getAddress().getHostAddress();
            }
            if (this.m_ServerInetSocketAddress == null) {
                this.m_ServerInetSocketAddress = o_ServerInetSocketAddress;
                this.m_LiveDBConnectionDescription.setServerRemoteIP(stringServerIP);
                this.m_InnerCloseSemaphore.leaveWorkerSection();
                return boolServerAddressOk;
            }
            this.m_ServerInetSocketAddress = o_ServerInetSocketAddress;
            if (boolServerAddressOk && !this.m_LiveDBConnectionDescription.getServerRemoteIP().equals(stringServerIP)) {
                boolServerAddressChanged = true;
            }
            if (!boolServerAddressOk || boolServerAddressChanged) {
                LiveDBSocket o_LiveDBSocket;
                this.m_ServerInetSocketAddress = o_ServerInetSocketAddress;
                this.m_LiveDBConnectionDescription.setServerRemoteIP(stringServerIP);
                ArrayList<LiveDBSocket> o_LiveDBSockets = null;
                Object object = this.m_SyncLiveDBSockets;
                synchronized (object) {
                    if (o_LiveDBSockets != null) {
                        o_LiveDBSockets = new ArrayList<LiveDBSocket>();
                        for (int intLiveDBSocket = this.m_LiveDBSockets.size() - 1; intLiveDBSocket >= 0; --intLiveDBSocket) {
                            o_LiveDBSocket = this.m_LiveDBSockets.get(intLiveDBSocket);
                            if (o_LiveDBSocket == null || !o_LiveDBSocket.isConnected()) continue;
                            o_LiveDBSockets.add(o_LiveDBSocket);
                        }
                    }
                }
                if (o_LiveDBSockets != null) {
                    for (int intSocket = 0; intSocket < o_LiveDBSockets.size(); ++intSocket) {
                        o_LiveDBSocket = (LiveDBSocket)o_LiveDBSockets.get(intSocket);
                        if (o_LiveDBSocket == null) continue;
                        LiveDBSocketChannelManagement.eventConnectionLost(o_LiveDBSocket.getLiveDBSocketChannelMerger());
                    }
                }
            }
            this.m_InnerCloseSemaphore.leaveWorkerSection();
            return boolServerAddressOk;
        }

        public void connectLiveDBSocket(LiveDBSocket p_LiveDBSocket) {
            Exception o_Exception;
            String stringLocalURL;
            boolean boolConnectionOK;
            int intLocalPort;
            boolean boolTryAllInterfaces;
            SocketChannel o_SocketChannel;
            block47: {
                if (p_LiveDBSocket == null) {
                    return;
                }
                o_SocketChannel = null;
                if (!this.m_InnerCloseSemaphore.enterWorkerSection()) {
                    return;
                }
                LiveDBConnectionDescription o_LiveDBConnectionDescription = p_LiveDBSocket.getLiveDBConnectionDescription();
                boolTryAllInterfaces = o_LiveDBConnectionDescription.getClientTryAllInterfeces();
                intLocalPort = o_LiveDBConnectionDescription.getClientLocalPort();
                if (!this.checkServerAddress()) {
                    LiveDBSocketChannelManagement.eventLiveDBSocketError(p_LiveDBSocket, new Exception("ServerLiveDBSocketList.connect Unresolvable ServerAddress: URL=" + this.m_LiveDBConnectionDescription.getServerRemoteURL() + " Port=" + this.m_LiveDBConnectionDescription.getServerPort()), ERROR_CLIENTUNRESOLVEDSERVER);
                    this.m_InnerCloseSemaphore.leaveWorkerSection();
                    p_LiveDBSocket.setConnectionStatus(6);
                    p_LiveDBSocket.setConnectionStatus(0);
                    return;
                }
                boolean boolBindOK = false;
                boolConnectionOK = false;
                stringLocalURL = o_LiveDBConnectionDescription.getClientLocalIP();
                if (LiveDBSocketList.checkServerAdressIsLoopback(this.m_LiveDBConnectionDescription.getServerRemoteURL(), this.m_LiveDBConnectionDescription.getServerPort()) && this.m_ServerInetSocketAddress.getAddress().isLoopbackAddress()) {
                    stringLocalURL = this.m_ServerInetSocketAddress.getAddress() instanceof Inet4Address ? "127.0.0.1" : "::1";
                }
                if (stringLocalURL == null || stringLocalURL.length() <= 0) {
                    if (LiveDBSocketList.checkServerAdressIsLoopback(this.m_LiveDBConnectionDescription.getServerRemoteURL(), this.m_LiveDBConnectionDescription.getServerPort())) {
                        stringLocalURL = InetAddress.getLoopbackAddress().getHostAddress();
                    } else {
                        try {
                            stringLocalURL = InetAddress.getLocalHost().getHostAddress();
                        }
                        catch (Exception e) {
                            stringLocalURL = InetAddress.getLoopbackAddress().getHostAddress();
                        }
                    }
                }
                if ((o_SocketChannel = this.createSocketChannel_Rare(p_LiveDBSocket)) == null) {
                    this.m_InnerCloseSemaphore.leaveWorkerSection();
                    p_LiveDBSocket.setConnectionStatus(6);
                    p_LiveDBSocket.setConnectionStatus(0);
                    return;
                }
                if (intLocalPort < 0 || intLocalPort > 65534) {
                    intLocalPort = 0;
                }
                if ((o_Exception = this.bindSocket(p_LiveDBSocket, o_SocketChannel, stringLocalURL, intLocalPort)) != null) {
                    try {
                        o_SocketChannel.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    o_SocketChannel = null;
                    if (!boolTryAllInterfaces) {
                        LiveDBSocketChannelManagement.eventLiveDBSocketError(p_LiveDBSocket, o_Exception, ERROR_CLIENTCANNOTBIND);
                        this.m_InnerCloseSemaphore.leaveWorkerSection();
                        p_LiveDBSocket.setConnectionStatus(6);
                        p_LiveDBSocket.setConnectionStatus(0);
                        return;
                    }
                } else {
                    boolBindOK = true;
                }
                if (boolBindOK) {
                    try {
                        o_SocketChannel.connect(this.m_ServerInetSocketAddress);
                        o_LiveDBConnectionDescription.setClientLocalIP(stringLocalURL);
                        boolConnectionOK = true;
                    }
                    catch (Exception e) {
                        boolConnectionOK = false;
                        try {
                            if (o_SocketChannel != null) {
                                o_SocketChannel.close();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (boolTryAllInterfaces) break block47;
                        LiveDBSocketChannelManagement.eventLiveDBSocketError(p_LiveDBSocket, e, ERROR_CLIENTCANNOTCONNECTSERVER);
                        this.m_InnerCloseSemaphore.leaveWorkerSection();
                        p_LiveDBSocket.setConnectionStatus(6);
                        p_LiveDBSocket.setConnectionStatus(0);
                        return;
                    }
                }
            }
            if (!boolConnectionOK && boolTryAllInterfaces) {
                ArrayList<InetAddress> o_IP6Addresses;
                ArrayList<InetAddress> o_IP4Addresses;
                block48: {
                    o_IP4Addresses = new ArrayList<InetAddress>();
                    o_IP6Addresses = new ArrayList<InetAddress>();
                    try {
                        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                        for (NetworkInterface o_NetworkInterface : Collections.list(interfaces)) {
                            if (o_NetworkInterface.isLoopback()) continue;
                            try {
                                if (!o_NetworkInterface.isUp()) {
                                }
                            }
                            catch (Exception e) {}
                            continue;
                            Enumeration<InetAddress> addresses = o_NetworkInterface.getInetAddresses();
                            for (InetAddress o_InetAddress : Collections.list(addresses)) {
                                if (o_InetAddress == null) continue;
                                if (o_InetAddress instanceof Inet6Address) {
                                    o_IP6Addresses.add(o_InetAddress);
                                }
                                if (!(o_InetAddress instanceof Inet4Address)) continue;
                                o_IP4Addresses.add(o_InetAddress);
                            }
                        }
                    }
                    catch (Exception e) {
                        boolConnectionOK = false;
                        if (o_SocketChannel == null) break block48;
                        try {
                            o_SocketChannel.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        o_SocketChannel = null;
                    }
                }
                boolean boolFirstTryIP6 = this.m_ServerInetSocketAddress.getAddress() instanceof Inet6Address;
                for (int intList = 0; intList < 2; ++intList) {
                    ArrayList<InetAddress> o_InetAddresses = intList == 0 ? (boolFirstTryIP6 ? o_IP6Addresses : o_IP4Addresses) : (boolFirstTryIP6 ? o_IP4Addresses : o_IP6Addresses);
                    for (int intInetAddress = 0; intInetAddress < o_InetAddresses.size(); ++intInetAddress) {
                        InetAddress o_InetAddressTry = (InetAddress)o_InetAddresses.get(intInetAddress);
                        if (o_InetAddressTry == null) continue;
                        if (o_SocketChannel != null) {
                            try {
                                o_SocketChannel.close();
                            }
                            catch (Exception addresses) {
                                // empty catch block
                            }
                            o_SocketChannel = null;
                        }
                        if ((o_SocketChannel = this.createSocketChannel_Rare(p_LiveDBSocket)) == null) {
                            this.m_InnerCloseSemaphore.leaveWorkerSection();
                            p_LiveDBSocket.setConnectionStatus(6);
                            p_LiveDBSocket.setConnectionStatus(0);
                            return;
                        }
                        stringLocalURL = o_InetAddressTry.getHostAddress();
                        o_Exception = this.bindSocket(p_LiveDBSocket, o_SocketChannel, stringLocalURL, intLocalPort);
                        if (o_Exception != null) {
                            try {
                                o_SocketChannel.close();
                            }
                            catch (Exception addresses) {
                                // empty catch block
                            }
                            o_SocketChannel = null;
                            continue;
                        }
                        boolConnectionOK = false;
                        try {
                            o_SocketChannel.connect(this.m_ServerInetSocketAddress);
                            boolConnectionOK = true;
                        }
                        catch (Exception e) {
                            boolConnectionOK = false;
                            try {
                                if (o_SocketChannel == null) continue;
                                o_SocketChannel.close();
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        if (!boolConnectionOK) continue;
                        p_LiveDBSocket.getLiveDBConnectionDescription().setClientLocalIP(stringLocalURL);
                        break;
                    }
                    if (boolConnectionOK) break;
                }
            }
            if (!boolConnectionOK) {
                Exception e = new Exception("All Interfaces tested, no match found");
                LiveDBSocketChannelManagement.eventLiveDBSocketError(p_LiveDBSocket, e, ERROR_CLIENTCANNOTCONNECTSERVER);
                this.m_InnerCloseSemaphore.leaveWorkerSection();
                p_LiveDBSocket.setConnectionStatus(6);
                p_LiveDBSocket.setConnectionStatus(0);
                return;
            }
            LiveDBSocketChannelMerger o_LiveDBSocketChannelMerger = new LiveDBSocketChannelMerger(p_LiveDBSocket, o_SocketChannel, this.m_LiveDBSelector);
            p_LiveDBSocket.setLiveDBSocketChannelMerger(o_LiveDBSocketChannelMerger);
            this.addLiveDBSocket(p_LiveDBSocket);
            p_LiveDBSocket.waitForHandshake();
            this.m_LiveDBSelector.registerChannelLater(o_SocketChannel, 8, o_LiveDBSocketChannelMerger);
            this.m_InnerCloseSemaphore.leaveWorkerSection();
        }

        private SocketChannel createSocketChannel_Rare(LiveDBSocket p_LiveDBSocket) {
            SocketChannel o_SocketChannel = null;
            try {
                o_SocketChannel = SocketChannel.open();
                Socket o_Socket = o_SocketChannel.socket();
                o_Socket.setReuseAddress(true);
                o_Socket.setReceiveBufferSize(LiveDBSocketChannelManagement.getSocketReceiveBufferSize());
                o_Socket.setSendBufferSize(LiveDBSocketChannelManagement.getSocketSendBufferSize());
                o_Socket.setSoTimeout(LiveDBSocketChannelManagement.getSocketSoTimeOut());
                int intLinget = LiveDBSocketChannelManagement.getSocketLingerTime();
                if (intLinget < 0) {
                    o_Socket.setSoLinger(false, 0);
                } else {
                    o_Socket.setSoLinger(true, intLinget);
                }
                o_Socket.setTcpNoDelay(LiveDBSocketChannelManagement.getSocketTcpNoDelay());
                o_SocketChannel.configureBlocking(false);
            }
            catch (Exception e) {
                try {
                    if (o_SocketChannel != null) {
                        o_SocketChannel.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LiveDBSocketChannelManagement.eventLiveDBSocketError(p_LiveDBSocket, e, ERROR_CLIENTCANNOTOPEN);
                return null;
            }
            return o_SocketChannel;
        }

        private Exception bindSocket(LiveDBSocket p_LiveDBSocket, SocketChannel p_SocketChannel, String p_LocalURL, int p_Port) {
            Socket o_Socket = p_SocketChannel.socket();
            try {
                InetSocketAddress o_LocalSocketAddress = new InetSocketAddress(p_LocalURL, p_Port);
                o_Socket.bind(o_LocalSocketAddress);
            }
            catch (IOException e) {
                return e;
            }
            return null;
        }

        public LiveDBSelector getLiveDBSelector() {
            if (!this.m_InnerCloseSemaphore.enterWorkerSection()) {
                return null;
            }
            LiveDBSelector o_LiveDBSelector = this.m_LiveDBSelector;
            this.m_InnerCloseSemaphore.leaveWorkerSection();
            return o_LiveDBSelector;
        }

        public int getLiveDBSocketCount() {
            if (!this.m_InnerCloseSemaphore.enterWorkerSection()) {
                return 0;
            }
            if (this.m_LiveDBSockets == null) {
                this.m_InnerCloseSemaphore.leaveWorkerSection();
                return 0;
            }
            int intSize = this.m_LiveDBSockets.size();
            this.m_InnerCloseSemaphore.leaveWorkerSection();
            return intSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLiveDBSocket(LiveDBSocket p_LiveDBSocket) {
            if (p_LiveDBSocket == null) {
                return;
            }
            if (!this.m_InnerCloseSemaphore.enterWorkerSection()) {
                return;
            }
            if (this.m_LiveDBSockets == null) {
                this.m_InnerCloseSemaphore.leaveWorkerSection();
                return;
            }
            Object object = this.m_SyncLiveDBSockets;
            synchronized (object) {
                if (this.m_LiveDBSockets == null || this.m_LiveDBSockets.contains(p_LiveDBSocket)) {
                    this.m_InnerCloseSemaphore.leaveWorkerSection();
                    return;
                }
                this.m_LiveDBSockets.add(p_LiveDBSocket);
            }
            this.m_InnerCloseSemaphore.leaveWorkerSection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LiveDBSocket getLiveDBSocket(int p_Index) {
            LiveDBSocket o_LiveDBSocket;
            if (!this.m_InnerCloseSemaphore.enterWorkerSection()) {
                return null;
            }
            Object object = this.m_SyncLiveDBSockets;
            synchronized (object) {
                if (p_Index < 0 || this.m_LiveDBSockets == null || p_Index >= this.m_LiveDBSockets.size()) {
                    this.m_InnerCloseSemaphore.leaveWorkerSection();
                    return null;
                }
                o_LiveDBSocket = this.m_LiveDBSockets.get(p_Index);
            }
            this.m_InnerCloseSemaphore.leaveWorkerSection();
            return o_LiveDBSocket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LiveDBSocket getLiveDBSocket(String p_ID) {
            if (p_ID == null || p_ID.length() <= 0) {
                return null;
            }
            if (!this.m_InnerCloseSemaphore.enterWorkerSection()) {
                return null;
            }
            LiveDBSocket o_LiveDBSocket = null;
            Object object = this.m_SyncLiveDBSockets;
            synchronized (object) {
                if (this.m_LiveDBSockets != null) {
                    String stringID;
                    for (int intSocket = 0; intSocket < this.m_LiveDBSockets.size() && !p_ID.equals(stringID = (o_LiveDBSocket = this.m_LiveDBSockets.get(intSocket)).getID()); ++intSocket) {
                        o_LiveDBSocket = null;
                    }
                }
            }
            this.m_InnerCloseSemaphore.leaveWorkerSection();
            return o_LiveDBSocket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LiveDBSocket removeLiveDBSocket(int p_Index) {
            LiveDBSocket o_LiveDBSocket;
            if (!this.m_InnerCloseSemaphore.enterWorkerSection()) {
                return null;
            }
            boolean boolIsEmpty = false;
            Object object = this.m_SyncLiveDBSockets;
            synchronized (object) {
                if (p_Index < 0 || this.m_LiveDBSockets == null || p_Index >= this.m_LiveDBSockets.size()) {
                    this.m_InnerCloseSemaphore.leaveWorkerSection();
                    return null;
                }
                o_LiveDBSocket = this.m_LiveDBSockets.get(p_Index);
                this.m_LiveDBSockets.remove(p_Index);
                if (this.m_LiveDBSockets.size() <= 0) {
                    boolIsEmpty = true;
                }
            }
            this.m_InnerCloseSemaphore.leaveWorkerSection();
            if (o_LiveDBSocket != null && boolIsEmpty) {
                LiveDBSocketChannelManagement.eventLiveDBSocketListEmpty(this);
            }
            return o_LiveDBSocket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeLiveDBSocket(LiveDBSocket p_LiveDBSocket) {
            if (!this.m_InnerCloseSemaphore.enterWorkerSection()) {
                return false;
            }
            boolean boolRemoved = false;
            Object object = this.m_SyncLiveDBSockets;
            synchronized (object) {
                if (this.m_LiveDBSockets != null) {
                    boolRemoved = this.m_LiveDBSockets.remove(p_LiveDBSocket);
                }
            }
            this.m_InnerCloseSemaphore.leaveWorkerSection();
            if (boolRemoved && this.m_LiveDBSockets.size() <= 0) {
                LiveDBSocketChannelManagement.handleLiveDBSocketListEmpty(this);
            }
            return boolRemoved;
        }
    }
}

