/*
 * Decompiled with CFR 0.152.
 */
package ToolsGraphics;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class JColorChooserOnTop
extends JColorChooser {
    public static Color showDialog(Component component, String title, Color initialColor) throws HeadlessException {
        JColorChooser pane = new JColorChooser(initialColor != null ? initialColor : Color.white);
        ColorTracker ok = new ColorTracker(pane);
        JDialog dialog = JColorChooserOnTop.createDialog(component, title, true, pane, ok, null);
        dialog.addComponentListener(new ColorChooserDialog.DisposeOnClose());
        dialog.setAlwaysOnTop(true);
        dialog.setVisible(true);
        return ok.getColor();
    }

    public static class ColorChooserDialog
    extends JDialog {
        private Color initialColor;
        private JColorChooser chooserPane;
        private JButton cancelButton;

        public ColorChooserDialog(Dialog owner, String title, boolean modal, Component c, JColorChooser chooserPane, ActionListener okListener, ActionListener cancelListener) throws HeadlessException {
            super(owner, title, modal);
            this.initColorChooserDialog(c, chooserPane, okListener, cancelListener);
        }

        public ColorChooserDialog(Frame owner, String title, boolean modal, Component c, JColorChooser chooserPane, ActionListener okListener, ActionListener cancelListener) throws HeadlessException {
            super(owner, title, modal);
            this.initColorChooserDialog(c, chooserPane, okListener, cancelListener);
        }

        protected void initColorChooserDialog(Component c, JColorChooser chooserPane, ActionListener okListener, ActionListener cancelListener) {
            boolean supportsWindowDecorations;
            this.chooserPane = chooserPane;
            Locale locale = this.getLocale();
            String okString = UIManager.getString((Object)"ColorChooser.okText", locale);
            String cancelString = UIManager.getString((Object)"ColorChooser.cancelText", locale);
            String resetString = UIManager.getString((Object)"ColorChooser.resetText", locale);
            Container contentPane = this.getContentPane();
            contentPane.setLayout(new BorderLayout());
            contentPane.add((Component)chooserPane, "Center");
            JPanel buttonPane = new JPanel();
            buttonPane.setLayout(new FlowLayout(1));
            JButton okButton = new JButton(okString);
            this.getRootPane().setDefaultButton(okButton);
            okButton.getAccessibleContext().setAccessibleDescription(okString);
            okButton.setActionCommand("OK");
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.setVisible(false);
                }
            });
            if (okListener != null) {
                okButton.addActionListener(okListener);
            }
            buttonPane.add(okButton);
            this.cancelButton = new JButton(cancelString);
            this.cancelButton.getAccessibleContext().setAccessibleDescription(cancelString);
            this.cancelButton.setActionCommand("cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.setVisible(false);
                }
            });
            if (cancelListener != null) {
                this.cancelButton.addActionListener(cancelListener);
            }
            buttonPane.add(this.cancelButton);
            JButton resetButton = new JButton(resetString);
            resetButton.getAccessibleContext().setAccessibleDescription(resetString);
            resetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.reset();
                }
            });
            buttonPane.add(resetButton);
            contentPane.add((Component)buttonPane, "South");
            if (JDialog.isDefaultLookAndFeelDecorated() && (supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
                this.getRootPane().setWindowDecorationStyle(5);
            }
            this.applyComponentOrientation((c == null ? this.getRootPane() : c).getComponentOrientation());
            this.pack();
            this.setLocationRelativeTo(c);
            this.addWindowListener(new Closer());
        }

        @Override
        public void show() {
            this.initialColor = this.chooserPane.getColor();
            super.show();
        }

        public void reset() {
            this.chooserPane.setColor(this.initialColor);
        }

        public static class DisposeOnClose
        extends ComponentAdapter
        implements Serializable {
            @Override
            public void componentHidden(ComponentEvent e) {
                Window w = (Window)e.getComponent();
                w.dispose();
            }
        }

        class Closer
        extends WindowAdapter
        implements Serializable {
            Closer() {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                ColorChooserDialog.this.cancelButton.doClick(0);
                Window w = e.getWindow();
                w.setVisible(false);
            }
        }
    }

    public static class ColorTracker
    implements ActionListener,
    Serializable {
        JColorChooser chooser;
        Color color;

        public ColorTracker(JColorChooser c) {
            this.chooser = c;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.color = this.chooser.getColor();
        }

        public Color getColor() {
            return this.color;
        }
    }
}

