/*
 * Decompiled with CFR 0.152.
 */
package ToolsGraphics;

import ToolsGraphics.ImagesTools;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.imageio.ImageIO;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.JComponent;

public class BackgroundComponent
implements Externalizable {
    protected boolean m_Opaque;
    protected boolean m_Enabled;
    protected int m_BackgroundStyle;
    protected Image m_BackgroundImage;
    protected Image m_BackgroundImageDisabled;
    protected Color m_BackgroundGradientColorFrom;
    protected Color m_BackgroundGradientColorTo;
    protected int m_BackgroundGradientAngle;
    protected Point m_GradientPointFrom;
    protected Point m_GradientPointTo;
    protected GradientPaint m_GradientPaint;
    protected boolean m_GradientRepaint;
    protected Color m_BackgroundColor;
    protected Image m_Image;
    protected GrayFilter m_GrayFilter;
    protected boolean m_RepaintFlag;
    protected Rectangle m_RectSize;
    protected Rectangle m_OldRectSize;
    protected Rectangle m_RectangleToFill;
    protected Dimension m_ImageSize;

    public BackgroundComponent() {
        this.initMembers();
    }

    private void initMembers() {
        this.m_Opaque = false;
        this.m_Enabled = true;
        this.m_BackgroundImage = null;
        this.m_BackgroundImageDisabled = null;
        this.m_BackgroundStyle = 0;
        this.m_BackgroundGradientColorFrom = Color.WHITE;
        this.m_BackgroundGradientColorTo = Color.YELLOW;
        this.m_BackgroundColor = Color.WHITE;
        this.m_GradientPaint = null;
        this.m_GradientPointFrom = new Point();
        this.m_GradientPointTo = new Point();
        this.m_RectSize = new Rectangle(0, 0, 0, 0);
        this.m_OldRectSize = new Rectangle(0, 0, 0, 0);
        this.m_RectangleToFill = new Rectangle(0, 0, 0, 0);
        this.m_RepaintFlag = true;
        this.m_GrayFilter = new GrayFilter(true, 10);
        this.m_ImageSize = new Dimension(0, 0);
    }

    private Object readResolve() {
        return this;
    }

    @Override
    public void writeExternal(ObjectOutput p_Out) throws IOException {
        p_Out.writeBoolean(this.m_Opaque);
        p_Out.writeInt(this.m_BackgroundStyle);
        p_Out.writeObject(this.m_BackgroundColor);
        p_Out.writeInt(this.m_BackgroundGradientAngle);
        p_Out.writeObject(this.m_BackgroundGradientColorFrom);
        p_Out.writeObject(this.m_BackgroundGradientColorTo);
        ImagesTools.writeImage(p_Out, this.m_BackgroundImage);
    }

    @Override
    public void readExternal(ObjectInput p_In) throws ClassNotFoundException, IOException {
        try {
            this.m_Opaque = p_In.readBoolean();
            this.m_BackgroundStyle = p_In.readInt();
            this.m_BackgroundColor = (Color)p_In.readObject();
            this.m_BackgroundGradientAngle = p_In.readInt();
            this.m_BackgroundGradientColorFrom = (Color)p_In.readObject();
            this.m_BackgroundGradientColorTo = (Color)p_In.readObject();
            this.m_BackgroundImage = (BufferedImage)ImagesTools.readImage(p_In);
        }
        catch (ClassNotFoundException e_ClassNotFound) {
            throw e_ClassNotFound;
        }
        catch (IOException e) {
            throw e;
        }
    }

    public void paintComponentBackground(Graphics g, JComponent p_Component) {
        boolean boolWidthChanged = false;
        boolean boolHeightChanged = false;
        if (p_Component == null) {
            return;
        }
        if (!this.m_Opaque) {
            return;
        }
        Insets insetsParent = p_Component.getInsets();
        this.m_RectSize.setRect(insetsParent.left, insetsParent.top, p_Component.getWidth() - insetsParent.left - insetsParent.right, p_Component.getHeight() - insetsParent.top - insetsParent.bottom);
        if (this.m_RectSize.getWidth() != this.m_OldRectSize.getWidth()) {
            boolWidthChanged = true;
        }
        if (this.m_RectSize.getHeight() != this.m_OldRectSize.getHeight()) {
            boolHeightChanged = true;
        }
        if (boolWidthChanged || boolHeightChanged) {
            // empty if block
        }
        this.m_OldRectSize.setRect(this.m_RectSize.getX(), this.m_RectSize.getY(), this.m_RectSize.getWidth(), this.m_RectSize.getHeight());
        if (this.m_RectSize.getWidth() <= 0.0 || this.m_RectSize.getHeight() <= 0.0) {
            return;
        }
        if (this.m_RepaintFlag) {
            if (this.m_Enabled) {
                this.m_Image = this.m_BackgroundImage;
            } else if (this.m_BackgroundImage != null) {
                if (this.m_BackgroundImageDisabled == null) {
                    Image o_GrayImage = GrayFilter.createDisabledImage(this.m_BackgroundImage);
                    this.m_ImageSize.setSize(this.m_BackgroundImage.getWidth(null), this.m_BackgroundImage.getHeight(null));
                    this.m_BackgroundImageDisabled = ImagesTools.convertToBufferedImage(o_GrayImage, this.m_ImageSize);
                    o_GrayImage.flush();
                    o_GrayImage = null;
                }
                this.m_Image = this.m_BackgroundImageDisabled;
            } else {
                this.m_Image = null;
            }
        }
        if (this.m_Opaque) {
            Graphics2D g2d = (Graphics2D)g;
            switch (this.m_BackgroundStyle) {
                case 2: {
                    if (this.m_Image != null) {
                        g2d.drawImage(this.m_Image, this.m_RectSize.x, this.m_RectSize.y, this.m_RectSize.x + this.m_RectSize.width, this.m_RectSize.y + this.m_RectSize.height, 0, 0, this.m_BackgroundImage.getWidth(null), this.m_BackgroundImage.getHeight(null), p_Component);
                        break;
                    }
                }
                case 3: {
                    if (this.m_Image != null) {
                        int intWidth;
                        int intHeight;
                        double doubleWidthFactor;
                        int intImageWidth = this.m_BackgroundImage.getWidth(null);
                        int intImageHeight = this.m_BackgroundImage.getHeight(null);
                        if (intImageHeight <= 0 || intImageWidth <= 0) {
                            return;
                        }
                        double doubleHeightFactor = this.m_RectSize.getHeight() / (double)intImageHeight;
                        if (doubleHeightFactor < (doubleWidthFactor = this.m_RectSize.getWidth() / (double)intImageWidth)) {
                            intHeight = (int)((double)this.m_BackgroundImage.getHeight(null) * doubleHeightFactor);
                            intWidth = (int)((double)this.m_BackgroundImage.getWidth(null) * doubleHeightFactor);
                        } else {
                            intHeight = (int)((double)this.m_BackgroundImage.getHeight(null) * doubleWidthFactor);
                            intWidth = (int)((double)this.m_BackgroundImage.getWidth(null) * doubleWidthFactor);
                        }
                        int intRectX = this.m_RectSize.x + (this.m_RectSize.width - intWidth) / 2;
                        int intRectY = this.m_RectSize.y + (this.m_RectSize.height - intHeight) / 2;
                        g2d.drawImage(this.m_Image, intRectX, intRectY, intRectX + intWidth, intRectY + intHeight, 0, 0, this.m_BackgroundImage.getWidth(null), this.m_BackgroundImage.getHeight(null), p_Component);
                        break;
                    }
                }
                case 0: {
                    g2d.setColor(p_Component.getBackground());
                    g2d.fillRect(this.m_RectSize.x, this.m_RectSize.y, this.m_RectSize.width, this.m_RectSize.height);
                    break;
                }
                case 1: {
                    this.m_RectangleToFill.setRect(this.m_RectSize.x, this.m_RectSize.y, this.m_RectSize.width, this.m_RectSize.height);
                    if (boolHeightChanged || boolWidthChanged || this.m_GradientPaint == null || this.m_GradientRepaint) {
                        this.m_GradientPointFrom = ImagesTools.getPointOnRectangleBorder(this.m_GradientPointFrom, this.m_RectangleToFill, this.m_BackgroundGradientAngle);
                        this.m_GradientPointTo = ImagesTools.getDiagonalPoint(this.m_GradientPointTo, this.m_RectangleToFill, this.m_GradientPointFrom);
                        this.m_GradientPaint = new GradientPaint(this.m_GradientPointFrom.x, this.m_GradientPointFrom.y, this.m_BackgroundGradientColorFrom, this.m_GradientPointTo.x, this.m_GradientPointTo.y, this.m_BackgroundGradientColorTo);
                        this.m_GradientRepaint = false;
                    }
                    g2d.setPaint(this.m_GradientPaint);
                    g2d.fill(this.m_RectangleToFill);
                }
            }
            this.m_RepaintFlag = false;
        }
    }

    public boolean setBackgroundStyle(int p_BackgroundStyle) {
        if (this.m_BackgroundStyle == p_BackgroundStyle) {
            return false;
        }
        int intOldBackgroundStyle = this.m_BackgroundStyle;
        switch (this.m_BackgroundStyle) {
            case 2: {
                this.m_BackgroundStyle = p_BackgroundStyle;
                break;
            }
            case 0: {
                this.m_BackgroundStyle = p_BackgroundStyle;
                break;
            }
            case 1: {
                this.m_BackgroundStyle = p_BackgroundStyle;
                break;
            }
        }
        return this.m_BackgroundStyle != intOldBackgroundStyle;
    }

    public int getBackgroundStyle() {
        return this.m_BackgroundStyle;
    }

    public boolean setBackground(Color p_BackgroundColor) {
        if (p_BackgroundColor == null) {
            return false;
        }
        Color oldBg = this.m_BackgroundColor;
        this.m_BackgroundColor = p_BackgroundColor;
        if (oldBg == null && this.m_BackgroundColor == null || oldBg != null && oldBg.equals(this.m_BackgroundColor)) {
            return false;
        }
        return this.m_BackgroundStyle == 0;
    }

    public Color getBackground() {
        return this.m_BackgroundColor;
    }

    public boolean setBackgroundImage(Image p_BackgroundImage) {
        if (this.m_BackgroundImage == p_BackgroundImage) {
            return false;
        }
        this.m_BackgroundImage = p_BackgroundImage;
        this.m_BackgroundImageDisabled = null;
        this.m_RepaintFlag = true;
        return true;
    }

    public Image getBackgroundImage() {
        return this.m_BackgroundImage;
    }

    public boolean setBackgroundImage(String p_BackgroundImageFile) {
        this.m_BackgroundImageDisabled = null;
        if (p_BackgroundImageFile == null || p_BackgroundImageFile.length() <= 0) {
            if (this.m_BackgroundImage == null) {
                return false;
            }
            this.m_BackgroundImage = null;
        } else {
            try {
                this.m_BackgroundImage = ImageIO.read(new File(p_BackgroundImageFile));
            }
            catch (IOException e) {
                this.m_BackgroundImage = null;
            }
        }
        this.m_RepaintFlag = true;
        return true;
    }

    public boolean setBackgroundImage(Icon p_Icon) {
        if (p_Icon == null) {
            if (this.m_BackgroundImage == null) {
                return false;
            }
            this.m_BackgroundImage = null;
            this.m_BackgroundImageDisabled = null;
            this.m_RepaintFlag = true;
            return true;
        }
        try {
            this.m_BackgroundImage = ImagesTools.convertToBufferedImage(p_Icon);
        }
        catch (Exception e) {
            this.m_BackgroundImage = null;
        }
        this.m_RepaintFlag = true;
        return true;
    }

    public Color getBackgroundGradientColorFrom() {
        return this.m_BackgroundGradientColorFrom;
    }

    public boolean setBackgroundGradientColorFrom(Color p_BackgroundGradientColorFrom) {
        if (this.m_BackgroundGradientColorFrom.equals(p_BackgroundGradientColorFrom)) {
            return false;
        }
        this.m_BackgroundGradientColorFrom = p_BackgroundGradientColorFrom;
        if (this.m_BackgroundStyle == 1) {
            this.m_GradientRepaint = true;
            return true;
        }
        return false;
    }

    public Color getBackgroundGradientColorTo() {
        return this.m_BackgroundGradientColorTo;
    }

    public boolean setBackgroundGradientColorTo(Color backgroundGradientColorTo) {
        if (this.m_BackgroundGradientColorTo.equals(backgroundGradientColorTo)) {
            return false;
        }
        this.m_BackgroundGradientColorTo = backgroundGradientColorTo;
        if (this.m_BackgroundStyle == 1) {
            this.m_GradientRepaint = true;
            return true;
        }
        return false;
    }

    public int getBackgroundGradientAngle() {
        return this.m_BackgroundGradientAngle;
    }

    public boolean setBackgroundGradientAngle(int backgroundGradientAngle) {
        if (this.m_BackgroundGradientAngle == backgroundGradientAngle) {
            return false;
        }
        this.m_BackgroundGradientAngle = backgroundGradientAngle;
        if (this.m_BackgroundStyle == 1) {
            this.m_GradientRepaint = true;
            return true;
        }
        return false;
    }

    public boolean setOpaque(boolean p_Opaque) {
        if (this.m_Opaque == p_Opaque) {
            return false;
        }
        this.m_Opaque = p_Opaque;
        return true;
    }

    public boolean getOpaque() {
        return this.m_Opaque;
    }

    public void setEnabled(boolean p_Enabled) {
        if (this.m_Enabled == p_Enabled) {
            return;
        }
        this.m_Enabled = p_Enabled;
        this.m_RepaintFlag = true;
    }

    public boolean isEnabled() {
        return this.m_Enabled;
    }
}

