/*
 * Decompiled with CFR 0.152.
 */
package Text;

import SwingTextPackage.DocumentFilter_Double;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseWheelEvent;
import javax.swing.JTextField;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;

public class JTextFieldNumber
extends JTextField {
    public static final String PROP_VALUE = "value";
    public static final String PROP_TYPE = "numType";
    public static final String PROP_MINVALUE = "minValue";
    public static final String PROP_MAXVALUE = "maxValue";
    public static final String PROP_RESOLUTION = "resolution";
    protected Class<?> m_Type;
    protected Double m_MinValue;
    protected Double m_MaxValue;
    protected int m_Resolution;
    protected long m_ResolutionFactor;
    protected DocumentFilter m_DocumentFilter;
    protected double m_Value;
    protected JTextField m_SelfReference;

    public JTextFieldNumber() {
        this(Double.class, null, null);
    }

    public JTextFieldNumber(Class<?> p_Class, Double p_MinValue, Double p_MaxValue) {
        this.initMembers();
        this.m_Type = p_Class;
        this.m_MinValue = p_MinValue;
        this.m_MaxValue = p_MaxValue;
        this.m_SelfReference = this;
        this.initComponentsFurther();
    }

    private void initMembers() {
        this.m_Value = 0.0;
        this.m_Resolution = -1;
        this.m_Resolution = -1;
    }

    private void initComponentsFurther() {
        this.setType(this.m_Type);
        super.setText(String.valueOf(this.m_Value));
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                double doubleRange = JTextFieldNumber.this.m_MaxValue - JTextFieldNumber.this.m_MinValue;
                if (e.getKeyCode() == 10) {
                    JTextFieldNumber.this.setValue(JTextFieldNumber.this.getValue(JTextFieldNumber.this.m_SelfReference.getText()));
                } else if (e.getKeyCode() == 225 || e.getKeyCode() == 40) {
                    JTextFieldNumber.this.setValue(JTextFieldNumber.this.m_Value - doubleRange / 10.0);
                } else if (e.getKeyCode() == 224 || e.getKeyCode() == 38) {
                    JTextFieldNumber.this.setValue(JTextFieldNumber.this.m_Value + doubleRange / 10.0);
                }
            }
        });
        this.addMouseWheelListener(new MouseAdapter(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                double doubleRange = JTextFieldNumber.this.m_MaxValue - JTextFieldNumber.this.m_MinValue;
                JTextFieldNumber.this.setValue(JTextFieldNumber.this.m_Value - (double)e.getWheelRotation() * doubleRange / 10.0);
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                JTextFieldNumber.this.setValue(JTextFieldNumber.this.getValue(JTextFieldNumber.this.m_SelfReference.getText()));
            }
        });
    }

    public void setType(Class<?> p_Type) {
        Class<?> oldValue = this.m_Type;
        boolean boolTypeOK = false;
        if (p_Type == Double.class) {
            boolTypeOK = true;
            this.m_DocumentFilter = new DocumentFilter_Double((JTextComponent)this);
            if (this.m_MinValue == null) {
                this.m_MinValue = -1.7976931348623157E308;
            }
            if (this.m_MaxValue == null) {
                this.m_MaxValue = Double.MAX_VALUE;
            }
        } else if (p_Type == Float.class) {
            boolTypeOK = true;
            this.m_DocumentFilter = new DocumentFilter_Double((JTextComponent)this);
            if (this.m_MinValue == null) {
                this.m_MinValue = -3.4028234663852886E38;
            }
            if (this.m_MaxValue == null) {
                this.m_MaxValue = 3.4028234663852886E38;
            }
        } else if (p_Type == Integer.class) {
            boolTypeOK = true;
            this.m_DocumentFilter = new DocumentFilter_Double((JTextComponent)this);
            if (this.m_MinValue == null) {
                this.m_MinValue = 2.147483648E9;
            }
            if (this.m_MaxValue == null) {
                this.m_MaxValue = 2.147483647E9;
            }
        }
        if (boolTypeOK) {
            this.m_Type = p_Type;
            if (this.m_MinValue > this.m_MaxValue) {
                double tempDouble = this.m_MaxValue;
                this.m_MaxValue = this.m_MinValue;
                this.m_MinValue = tempDouble;
            }
            this.firePropertyChange(PROP_TYPE, oldValue, this.m_Type);
            this.setValue(this.m_Value);
        }
    }

    private Class<?> getType() {
        return this.m_Type;
    }

    private double getValue(String p_ValueString) {
        double doubleValue = 0.0;
        try {
            doubleValue = Double.valueOf(p_ValueString);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return doubleValue;
    }

    public void setValue(double p_Value) {
        double oldValue = this.m_Value;
        if (p_Value < this.m_MinValue) {
            p_Value = this.m_MinValue;
        }
        if (p_Value > this.m_MaxValue) {
            p_Value = this.m_MaxValue;
        }
        if (this.getType() == Integer.TYPE) {
            this.m_Value = (int)this.roundValue(p_Value);
            super.setText(String.valueOf((int)this.m_Value));
        } else {
            this.m_Value = this.roundValue(p_Value);
            super.setText(String.valueOf(this.m_Value));
        }
        this.firePropertyChange(PROP_VALUE, oldValue, this.m_Value);
    }

    public double getValue() {
        return this.m_Value;
    }

    public double roundValue(double p_Value) {
        if (this.m_ResolutionFactor <= 0L) {
            return p_Value;
        }
        return Math.rint(p_Value * (double)this.m_ResolutionFactor) / (double)this.m_ResolutionFactor;
    }

    public void setMinMaxValue(double p_MinValue, double p_MaxValue) {
        this.setMinValue(p_MinValue);
        this.setMaxValue(p_MaxValue);
    }

    public void setMaxValue(double p_MaxValue) {
        double doubleMinValue = 0.0;
        double doubleMaxValue = 0.0;
        double oldValue = this.m_MaxValue;
        if (this.m_Type == Double.class) {
            doubleMinValue = -1.7976931348623157E308;
            doubleMaxValue = Double.MAX_VALUE;
        } else if (this.m_Type == Float.class) {
            doubleMinValue = -3.4028234663852886E38;
            doubleMaxValue = 3.4028234663852886E38;
        } else if (this.m_Type == Integer.class) {
            doubleMinValue = -2.147483648E9;
            doubleMaxValue = 2.147483647E9;
        }
        if (p_MaxValue > doubleMaxValue) {
            p_MaxValue = doubleMaxValue;
        }
        if (p_MaxValue < doubleMinValue) {
            p_MaxValue = doubleMinValue;
        }
        this.m_MaxValue = p_MaxValue;
        if (this.m_MinValue > this.m_MaxValue) {
            double tempDouble = this.m_MaxValue;
            this.m_MaxValue = this.m_MinValue;
            this.m_MinValue = tempDouble;
        }
        this.firePropertyChange(PROP_MAXVALUE, (Object)oldValue, this.m_MaxValue);
        this.setValue(this.m_Value);
    }

    public double getMaxValue() {
        return this.m_MaxValue;
    }

    public void setMinValue(double p_MinValue) {
        double doubleMinValue = 0.0;
        double doubleMaxValue = 0.0;
        double oldValue = this.m_MinValue;
        if (this.m_Type == Double.class) {
            doubleMinValue = -1.7976931348623157E308;
            doubleMaxValue = Double.MAX_VALUE;
        } else if (this.m_Type == Float.class) {
            doubleMinValue = -3.4028234663852886E38;
            doubleMaxValue = 3.4028234663852886E38;
        } else if (this.m_Type == Integer.class) {
            doubleMinValue = -2.147483648E9;
            doubleMaxValue = 2.147483647E9;
        }
        if (p_MinValue > doubleMaxValue) {
            p_MinValue = doubleMaxValue;
        }
        if (p_MinValue < doubleMinValue) {
            p_MinValue = doubleMinValue;
        }
        this.m_MinValue = p_MinValue;
        if (this.m_MinValue > this.m_MaxValue) {
            double tempDouble = this.m_MaxValue;
            this.m_MaxValue = this.m_MinValue;
            this.m_MinValue = tempDouble;
        }
        this.firePropertyChange(PROP_MINVALUE, (Object)oldValue, this.m_MinValue);
        this.setValue(this.m_Value);
    }

    public double getMinValue() {
        return this.m_MinValue;
    }

    public void setResolution(int p_Resolution) {
        int oldValue = this.m_Resolution;
        if (p_Resolution < 0) {
            this.m_Resolution = -1;
            this.m_ResolutionFactor = -1L;
        } else {
            this.m_Resolution = p_Resolution > 127 ? 127 : p_Resolution;
        }
        if (this.m_Resolution >= 0) {
            this.m_ResolutionFactor = 1L;
            for (int intExp = 0; intExp < this.m_Resolution; ++intExp) {
                this.m_ResolutionFactor *= 10L;
            }
        }
        this.firePropertyChange(PROP_RESOLUTION, oldValue, this.m_Resolution);
    }

    public int getResolution() {
        return this.m_Resolution;
    }
}

