/*
 * Decompiled with CFR 0.152.
 */
package Text;

import FileToolPackage.FileSelection;
import FileToolPackage.FileTools;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowObjectPackage.LiveShowObject;
import LiveShowObjectPackage.LiveShowProjectDescription;
import LiveShowVirtualPackage.LiveShowSceneBookPanel;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import LiveShowVirtualPackage.LiveShowVIP;
import SwingFramePackage.JOptionDialog;
import ToolsGraphics.LiveShowHTMLDocument;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.filechooser.FileNameExtensionFilter;

public class Export_HTML {
    public static String FIELDSEPERATOR = ";";
    public static final int COLUMN_FORMAT_LEFT = 0;
    public static final int COLUMN_FORMAT_CENTER = 2;
    public static final int COLUMN_FORMAT_RIGHT = 4;
    @LiveLanguageString
    public static String TITEL_EXPORT = "HTML Export";
    @LiveLanguageString
    public static String FILEEXISTS_TITEL = "file already exists";
    @LiveLanguageString
    public static String FILEEXISTS_MESSAGE = "Overwrite existing file?";
    @LiveLanguageString
    public static String FILENOTWRITABLE_TITEL = "file not writable";
    @LiveLanguageString
    public static String FILENOTWRITABLE_MESSAGE = "<html>The file may be opened by another program<br>or you have no write permission!</html>";
    @LiveLanguageString
    public static String TIME = "Time";
    @LiveLanguageString
    public static String DURATION = "Duration";
    @LiveLanguageString
    public static String DURATIONALL = "duration all";
    @LiveLanguageString
    public static String SCENEBOOK = "Scenebook";
    public static String s_Title = "";
    public static int COLUMN_TIME = 0;
    public static int COLUMN_MAINBRIDGEDURATION = 1;
    public static int COLUMN_STARTOFBRIDGES = 2;
    private static File s_LastDirectory = null;
    private static String s_ActualExportType;
    private static String s_ActualSheetName;
    private static File s_ActualHTMLFile;
    private static HTMLClass s_HTMLClass;
    private static Color s_ColorMainSceneBridge;
    private static Color s_ColorSceneBridge;
    private static Export_HTML s_SelfReference;
    public static FileNameExtensionFilter s_FileNameExtensionFilter_HTML;

    public Export_HTML() {
        LiveLanguage.addLanguageListener(this, null);
    }

    public static void SceneBookExport(LiveShowSceneBookPanel p_LiveShowSceneBookPanel, boolean p_WithDirections) {
        LiveShowVIP o_LiveShowVIP;
        int intVip;
        if (s_ActualExportType != null) {
            return;
        }
        if (p_LiveShowSceneBookPanel == null) {
            return;
        }
        long longTimeLineEnd = 0L;
        int intVipCount = p_LiveShowSceneBookPanel.getLiveShowVIPCount();
        ArrayList<LiveShowVIP> o_LiveShowVIPs = new ArrayList<LiveShowVIP>();
        for (intVip = 0; intVip < intVipCount; ++intVip) {
            o_LiveShowVIP = p_LiveShowSceneBookPanel.getLiveShowVIP(intVip);
            if (o_LiveShowVIP == null || !o_LiveShowVIP.getActive()) continue;
            o_LiveShowVIPs.add(o_LiveShowVIP);
        }
        intVipCount = o_LiveShowVIPs.size();
        if (o_LiveShowVIPs.size() <= 0) {
            return;
        }
        LiveShowProjectDescription o_LiveShowProjectDescription = p_LiveShowSceneBookPanel.getLiveShowProjectDescription();
        s_ActualSheetName = o_LiveShowProjectDescription == null ? SCENEBOOK : o_LiveShowProjectDescription.getProjectName() + "_" + SCENEBOOK;
        if (!Export_HTML.export_Start(o_LiveShowProjectDescription, SCENEBOOK)) {
            return;
        }
        ArrayList<LiveShowSceneBridge> o_LiveShowSceneBridges = new ArrayList<LiveShowSceneBridge>(o_LiveShowVIPs.size());
        ArrayList<Long> o_LiveShowSceneBridgeStarts = new ArrayList<Long>(o_LiveShowVIPs.size());
        for (intVip = 0; intVip < o_LiveShowVIPs.size(); ++intVip) {
            o_LiveShowSceneBridges.add(null);
            o_LiveShowSceneBridgeStarts.add(-1L);
        }
        long longStartFrame = 0L;
        long longStartFrameSum = -1L;
        boolean boolDone = false;
        int intColumnCount = 0;
        ArrayList<Object> o_ArrayList_Row = new ArrayList<Object>();
        ArrayList<Integer> o_ArrayList_ColumnFormats = new ArrayList<Integer>();
        o_ArrayList_Row.add(TIME);
        o_ArrayList_ColumnFormats.add(4);
        ++intColumnCount;
        o_ArrayList_Row.add(DURATIONALL);
        o_ArrayList_ColumnFormats.add(4);
        ++intColumnCount;
        for (int intVip2 = 0; intVip2 < o_LiveShowVIPs.size(); ++intVip2) {
            o_LiveShowVIP = (LiveShowVIP)o_LiveShowVIPs.get(intVip2);
            longTimeLineEnd = o_LiveShowVIP.getFrameEnd();
            o_ArrayList_Row.add(DURATION);
            o_ArrayList_ColumnFormats.add(4);
            ++intColumnCount;
            o_ArrayList_Row.add(o_LiveShowVIP.getType());
            o_ArrayList_ColumnFormats.add(2);
            ++intColumnCount;
        }
        s_HTMLClass.table_Start(o_ArrayList_Row, o_ArrayList_ColumnFormats);
        while (!boolDone) {
            int intCell;
            int intBridge;
            long longFramesToNextMainSceneBridge;
            int intNewLineIndex;
            String stringDirection;
            LiveShowHTMLDocument o_LiveShowHTMLDocument;
            int intBridge2;
            long longSceneBridgeFrame = -1L;
            boolDone = true;
            for (int intVip3 = 0; intVip3 < o_LiveShowVIPs.size(); ++intVip3) {
                o_LiveShowVIP = (LiveShowVIP)o_LiveShowVIPs.get(intVip3);
                o_LiveShowSceneBridges.set(intVip3, null);
                LiveShowSceneBridge o_LiveShowSceneBridge = o_LiveShowVIP.getLiveShowSceneBridge_Next(longStartFrame, false, true);
                if (o_LiveShowSceneBridge == null) continue;
                boolDone = false;
                if (longSceneBridgeFrame >= 0L && o_LiveShowSceneBridge.getFrameStart() < longSceneBridgeFrame) {
                    for (int intScenebridge = intVip3; intScenebridge >= 0; --intScenebridge) {
                        LiveShowSceneBridge o_TempLiveShowSceneBridge = (LiveShowSceneBridge)o_LiveShowSceneBridges.get(intScenebridge);
                        if (o_TempLiveShowSceneBridge == null || o_LiveShowSceneBridge.getFrameStart() >= o_TempLiveShowSceneBridge.getFrameStart()) continue;
                        o_LiveShowSceneBridges.set(intScenebridge, null);
                    }
                    longSceneBridgeFrame = o_LiveShowSceneBridge.getFrameStart();
                }
                if (longSceneBridgeFrame >= 0L && o_LiveShowSceneBridge.getFrameStart() > longSceneBridgeFrame) {
                    o_LiveShowSceneBridges.set(intVip3, null);
                    continue;
                }
                o_LiveShowSceneBridges.set(intVip3, o_LiveShowSceneBridge);
                longSceneBridgeFrame = o_LiveShowSceneBridge.getFrameStart();
            }
            if (boolDone) continue;
            o_ArrayList_Row.clear();
            for (int intCell2 = 0; intCell2 < intColumnCount; ++intCell2) {
                o_ArrayList_Row.add(null);
            }
            if (p_WithDirections) {
                for (intBridge2 = 0; intBridge2 < o_LiveShowSceneBridges.size(); ++intBridge2) {
                    LiveShowSceneBridge o_LiveShowSceneBridge = (LiveShowSceneBridge)o_LiveShowSceneBridges.get(intBridge2);
                    o_LiveShowHTMLDocument = p_LiveShowSceneBookPanel.getLiveShowEditorDocument_Pre(o_LiveShowSceneBridge);
                    if (o_LiveShowHTMLDocument == null) continue;
                    stringDirection = o_LiveShowHTMLDocument.getText();
                    intNewLineIndex = stringDirection.indexOf("\n");
                    if (intNewLineIndex == 0) {
                        stringDirection = stringDirection.substring(1, stringDirection.length());
                    }
                    o_ArrayList_Row.set(COLUMN_STARTOFBRIDGES + 2 * intBridge2 + 1, stringDirection);
                }
                s_HTMLClass.tableRow_Add(o_ArrayList_Row, null);
            }
            LiveShowSceneBridge o_LiveShowSceneBridge = null;
            for (intBridge2 = 0; intBridge2 < o_LiveShowSceneBridges.size() && (o_LiveShowSceneBridge = (LiveShowSceneBridge)o_LiveShowSceneBridges.get(intBridge2)) == null; ++intBridge2) {
            }
            if (o_LiveShowSceneBridge == null) {
                boolDone = true;
                continue;
            }
            longStartFrameSum = (Long)o_LiveShowSceneBridgeStarts.get(o_LiveShowSceneBridges.indexOf(o_LiveShowSceneBridge));
            if (o_LiveShowSceneBridge.getIsMainBridge()) {
                if (longStartFrameSum < 0L) {
                    longStartFrameSum = 0L;
                }
                for (intBridge2 = 0; intBridge2 < o_LiveShowSceneBridges.size(); ++intBridge2) {
                    o_LiveShowSceneBridgeStarts.set(intBridge2, longStartFrameSum);
                }
            }
            o_ArrayList_Row.set(COLUMN_TIME, o_LiveShowSceneBridge.getTimeStringFromFrames_Seconds(longStartFrameSum));
            if (o_LiveShowSceneBridge.getIsMainBridge() && (longFramesToNextMainSceneBridge = Export_HTML.getFramesToNextMainSceneBridge(o_LiveShowSceneBridge)) >= 0L) {
                o_ArrayList_Row.set(COLUMN_MAINBRIDGEDURATION, o_LiveShowSceneBridge.getTimeStringFromFrames_Seconds(longFramesToNextMainSceneBridge));
            }
            Color o_Color = null;
            for (intBridge = 0; intBridge < o_LiveShowSceneBridges.size(); ++intBridge) {
                o_LiveShowSceneBridge = (LiveShowSceneBridge)o_LiveShowSceneBridges.get(intBridge);
                if (o_LiveShowSceneBridge == null) continue;
                long longFramesToNextSceneBridge = o_LiveShowSceneBridge.getFramesRecordedNextSceneBridge();
                if (longFramesToNextSceneBridge <= 0L) {
                    longFramesToNextSceneBridge = o_LiveShowSceneBridge.getFramesToNextSceneBridge();
                }
                o_ArrayList_Row.set(COLUMN_STARTOFBRIDGES + intBridge * 2, o_LiveShowSceneBridge.getTimeStringFromFrames_Seconds(longFramesToNextSceneBridge));
                o_ArrayList_Row.set(COLUMN_STARTOFBRIDGES + intBridge * 2 + 1, o_LiveShowSceneBridge.getName());
                o_Color = o_LiveShowSceneBridge.getIsMainBridge() ? s_ColorMainSceneBridge : s_ColorSceneBridge;
                longStartFrameSum = (Long)o_LiveShowSceneBridgeStarts.get(intBridge);
                if (longStartFrameSum < 0L) continue;
                o_LiveShowSceneBridgeStarts.set(intBridge, (Long)o_LiveShowSceneBridgeStarts.get(intBridge) + longFramesToNextSceneBridge);
            }
            s_HTMLClass.tableRow_Add(o_ArrayList_Row, o_Color);
            for (intCell = 0; intCell < intColumnCount; ++intCell) {
                o_ArrayList_Row.set(intCell, null);
            }
            longStartFrame = longSceneBridgeFrame;
            ++longStartFrame;
            if (!p_WithDirections) continue;
            for (intBridge = 0; intBridge < o_LiveShowSceneBridges.size(); ++intBridge) {
                o_LiveShowSceneBridge = (LiveShowSceneBridge)o_LiveShowSceneBridges.get(intBridge);
                o_LiveShowHTMLDocument = p_LiveShowSceneBookPanel.getLiveShowEditorDocument_Post(o_LiveShowSceneBridge);
                if (o_LiveShowHTMLDocument == null) continue;
                stringDirection = o_LiveShowHTMLDocument.getText();
                intNewLineIndex = stringDirection.indexOf("\n");
                if (intNewLineIndex == 0) {
                    stringDirection = stringDirection.substring(1, stringDirection.length());
                }
                o_ArrayList_Row.set(COLUMN_STARTOFBRIDGES + 2 * intBridge + 1, stringDirection);
            }
            s_HTMLClass.tableRow_Add(o_ArrayList_Row, null);
            for (intCell = 0; intCell < intColumnCount; ++intCell) {
                o_ArrayList_Row.set(intCell, null);
            }
        }
        o_ArrayList_Row.set(COLUMN_TIME, Export_HTML.getTimeStringFromFrames_Seconds(longTimeLineEnd));
        for (int intBridge = 0; intBridge < o_LiveShowSceneBridges.size(); ++intBridge) {
            o_ArrayList_Row.set(COLUMN_STARTOFBRIDGES + 2 * intBridge + 1, "---");
        }
        s_HTMLClass.tableRow_Add(o_ArrayList_Row, null);
        Export_HTML.export_End();
    }

    public static String getTimeStringFromFrames_Seconds(long p_Frames) {
        if (p_Frames < 0L) {
            return "";
        }
        long longMilliseconds = (long)((double)p_Frames * LiveShowVIP.FRAMETIME);
        long longSeconds = (long)((double)longMilliseconds / 1000.0 + 0.5);
        String stringTime = LiveShowObject.getTimeStringFromMillis(longMilliseconds = longSeconds * 1000L);
        if (stringTime.length() < 4) {
            return "0";
        }
        stringTime = stringTime.substring(0, stringTime.length() - 4);
        return stringTime;
    }

    public static long getFramesToNextMainSceneBridge(LiveShowSceneBridge p_LiveShowSceneBridge) {
        if (p_LiveShowSceneBridge == null) {
            return -1L;
        }
        boolean boolDone = false;
        LiveShowVIP o_LiveShowVIP = p_LiveShowSceneBridge.getLiveShowVIP();
        if (o_LiveShowVIP == null) {
            return -1L;
        }
        long longFramesSum = 0L;
        long longFrames = p_LiveShowSceneBridge.getFramesRecordedNextSceneBridge();
        if (longFrames <= 0L) {
            longFrames = p_LiveShowSceneBridge.getFramesToNextSceneBridge();
        }
        longFramesSum += longFrames;
        LiveShowSceneBridge o_NextSceneBridge = p_LiveShowSceneBridge;
        while (!boolDone) {
            if ((o_NextSceneBridge = o_LiveShowVIP.getLiveShowSceneBridge_Next(o_NextSceneBridge, false, true)) == null) {
                boolDone = true;
                continue;
            }
            if (o_NextSceneBridge.getIsMainBridge()) {
                boolDone = true;
                continue;
            }
            longFrames = o_NextSceneBridge.getFramesRecordedNextSceneBridge();
            if (longFrames <= 0L) {
                longFrames = o_NextSceneBridge.getFramesToNextSceneBridge();
            }
            longFramesSum += longFrames;
        }
        return longFramesSum;
    }

    public static File selectExportFile(String p_Name) {
        File o_SelectedFile = null;
        boolean boolFileOK = true;
        if (s_LastDirectory == null) {
            s_LastDirectory = new File(System.getProperty("user.home"));
            o_SelectedFile = new File(p_Name + ".html");
        } else {
            o_SelectedFile = new File(s_LastDirectory.getAbsolutePath() + File.separator + p_Name + ".html");
        }
        o_SelectedFile = FileSelection.showSave(null, TITEL_EXPORT + " " + s_ActualExportType, o_SelectedFile, s_FileNameExtensionFilter_HTML, true, false, null, null, null, s_FileNameExtensionFilter_HTML);
        if (o_SelectedFile == null) {
            return null;
        }
        if (o_SelectedFile.exists()) {
            if (JOptionDialog.showConfirmDialog(null, (Object)FILEEXISTS_MESSAGE, (String)FILEEXISTS_TITEL, (int)0, (Object)1) == 1) {
                return null;
            }
            try {
                boolFileOK = o_SelectedFile.delete();
            }
            catch (Exception e) {
                boolFileOK = false;
            }
        }
        if (boolFileOK) {
            boolFileOK = FileTools.checkWritable(o_SelectedFile);
        }
        if (!boolFileOK) {
            JOptionDialog.showMessageDialog(null, (Object)FILENOTWRITABLE_MESSAGE, (String)FILENOTWRITABLE_TITEL, (int)0);
            return null;
        }
        s_ActualHTMLFile = o_SelectedFile;
        s_LastDirectory = s_ActualHTMLFile.getParentFile();
        return s_ActualHTMLFile;
    }

    public static boolean export_Start(LiveShowProjectDescription p_LiveShowProjectDescription, String p_ExportType) {
        if (p_ExportType == null) {
            return false;
        }
        if (s_ActualExportType != null) {
            return false;
        }
        if (s_HTMLClass != null) {
            return false;
        }
        s_ActualExportType = p_ExportType;
        s_ActualSheetName = p_LiveShowProjectDescription == null ? p_ExportType : p_LiveShowProjectDescription.getProjectName() + "_" + p_ExportType;
        s_ActualHTMLFile = Export_HTML.selectExportFile(s_ActualSheetName);
        if (s_ActualHTMLFile == null) {
            s_ActualExportType = null;
            return false;
        }
        s_HTMLClass = new HTMLClass(s_ActualHTMLFile);
        return true;
    }

    public static boolean export_TableStart(ArrayList<Object> p_CellContents, ArrayList<Integer> p_ColumnFormats) {
        if (p_CellContents == null) {
            return false;
        }
        if (s_HTMLClass == null) {
            return false;
        }
        s_HTMLClass.table_Start(p_CellContents, p_ColumnFormats);
        return true;
    }

    public static boolean export_TableAddRow(ArrayList<Object> p_CellContents) {
        if (p_CellContents == null) {
            return false;
        }
        if (s_HTMLClass == null) {
            return false;
        }
        s_HTMLClass.tableRow_Add(p_CellContents, null);
        return true;
    }

    public static boolean export_TableFinish() {
        if (s_HTMLClass == null) {
            return false;
        }
        s_HTMLClass.table_Finish();
        return true;
    }

    public static void export_End() {
        if (s_ActualExportType == null) {
            return;
        }
        try {
            s_HTMLClass.table_Finish();
            s_HTMLClass.write();
        }
        catch (Exception exception) {
            // empty catch block
        }
        s_HTMLClass = null;
        s_ActualExportType = null;
    }

    public static String replaceCharacters(String p_String) {
        if (p_String == null) {
            return "";
        }
        String stringResult = p_String;
        stringResult = stringResult.replace("\n", "<br>");
        return stringResult;
    }

    static {
        s_ActualHTMLFile = null;
        s_ColorMainSceneBridge = new Color(255, 180, 180);
        s_ColorSceneBridge = new Color(210, 210, 210);
        s_SelfReference = new Export_HTML();
        s_FileNameExtensionFilter_HTML = FileSelection.createFileNameExtensionFilter("HTML Export (.html)", ".html");
    }

    public static class HTMLClass {
        File m_File;
        ArrayList<Integer> m_ColumnFormats;
        String stringHTMLAll;
        String stringHTMLTable;
        String stringHTMLBody;
        String stringHTMLTitle;

        public HTMLClass(File p_File) {
            this.initMembers();
            this.m_File = p_File;
        }

        private void initMembers() {
            this.stringHTMLAll = this.createHTMLFrame();
            this.stringHTMLBody = "";
            this.stringHTMLTitle = "";
            this.stringHTMLTable = "";
            this.m_ColumnFormats = new ArrayList();
        }

        public String createHTMLFrame() {
            StringBuilder o_StringBuilder = new StringBuilder();
            o_StringBuilder.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
            o_StringBuilder.append("<html>");
            o_StringBuilder.append("<head>");
            o_StringBuilder.append("<meta content=\"text/html; charset=UTF-8\" http-equiv=\"content-type\">");
            o_StringBuilder.append("<title>$title</title>");
            o_StringBuilder.append("</head>");
            o_StringBuilder.append("<body>$body");
            o_StringBuilder.append("</body>");
            o_StringBuilder.append("</html>");
            return o_StringBuilder.toString();
        }

        public void table_Start(ArrayList<Object> p_Cells, ArrayList<Integer> p_ColumnFormats) {
            if (p_Cells == null) {
                return;
            }
            this.m_ColumnFormats.clear();
            for (int intColumn = 0; intColumn < p_ColumnFormats.size(); ++intColumn) {
                this.m_ColumnFormats.add(p_ColumnFormats.get(intColumn));
            }
            StringBuilder o_StringBuilder = new StringBuilder();
            o_StringBuilder.append("<table =\"\">");
            o_StringBuilder.append("<thead>");
            o_StringBuilder.append("<tr>");
            for (int intCell = 0; intCell < p_Cells.size(); ++intCell) {
                Object o_Cell = p_Cells.get(intCell);
                if (o_Cell == null) {
                    o_StringBuilder.append("<th></th>");
                    continue;
                }
                o_StringBuilder.append("<th>");
                String stringCellContent = o_Cell.toString();
                stringCellContent = Export_HTML.replaceCharacters(stringCellContent);
                o_StringBuilder.append(stringCellContent);
                o_StringBuilder.append("</th>");
            }
            o_StringBuilder.append("</tr>");
            o_StringBuilder.append("</thead>");
            o_StringBuilder.append("<tbody>");
            this.stringHTMLTable = o_StringBuilder.toString();
        }

        public void tableRow_Add(ArrayList<Object> p_Cells, Color p_Color) {
            if (p_Cells == null) {
                return;
            }
            Integer intColumnFormat = 0;
            StringBuilder o_StringBuilder = new StringBuilder();
            o_StringBuilder.append(this.stringHTMLTable);
            if (p_Color == null) {
                o_StringBuilder.append("<tr>");
            } else {
                o_StringBuilder.append("<tr bgcolor=\"#");
                String stringColor = Integer.toHexString(p_Color.getRed() & 0xFF);
                o_StringBuilder.append(stringColor);
                stringColor = Integer.toHexString(p_Color.getGreen() & 0xFF);
                o_StringBuilder.append(stringColor);
                stringColor = Integer.toHexString(p_Color.getBlue() & 0xFF);
                o_StringBuilder.append(stringColor);
                o_StringBuilder.append("\">");
            }
            for (int intCell = 0; intCell < p_Cells.size(); ++intCell) {
                String stringCellContent;
                Object o_Cell = p_Cells.get(intCell);
                if (o_Cell instanceof String) {
                    stringCellContent = (String)o_Cell;
                    stringCellContent = Export_HTML.replaceCharacters(stringCellContent);
                } else if (o_Cell instanceof Date) {
                    SimpleDateFormat o_SimpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
                    Date o_Calendar = (Date)o_Cell;
                    stringCellContent = o_SimpleDateFormat.format(o_Calendar);
                } else {
                    stringCellContent = o_Cell instanceof Number ? ((Number)o_Cell).toString() : "";
                }
                intColumnFormat = this.m_ColumnFormats.size() <= intCell ? null : this.m_ColumnFormats.get(intCell);
                if (intColumnFormat == null) {
                    o_StringBuilder.append("<td>");
                } else {
                    switch (intColumnFormat) {
                        case 0: {
                            o_StringBuilder.append("<td style=\"text-align:left;\">");
                            break;
                        }
                        case 2: {
                            o_StringBuilder.append("<td style=\"text-align:center;\">");
                            break;
                        }
                        case 4: {
                            o_StringBuilder.append("<td style=\"text-align:right;\">");
                            break;
                        }
                        default: {
                            o_StringBuilder.append("<td style=\"text-align:left;\">");
                        }
                    }
                }
                o_StringBuilder.append(stringCellContent);
                o_StringBuilder.append("</td>");
            }
            o_StringBuilder.append("</tr>");
            this.stringHTMLTable = o_StringBuilder.toString();
        }

        public void table_Finish() {
            StringBuilder o_StringBuilder = new StringBuilder();
            o_StringBuilder.append(this.stringHTMLTable);
            o_StringBuilder.append("</tbody>");
            o_StringBuilder.append("</table>");
            StringBuilder o_StringBuilder_Body = new StringBuilder();
            o_StringBuilder_Body.append(this.stringHTMLBody);
            o_StringBuilder_Body.append(o_StringBuilder.toString());
            this.stringHTMLBody = o_StringBuilder_Body.toString();
        }

        public void write() {
            if (this.m_File == null) {
                return;
            }
            FileOutputStream o_FileOutputStream = null;
            OutputStreamWriter o_OutputStreamWriter = null;
            try {
                o_FileOutputStream = new FileOutputStream(this.m_File);
                o_OutputStreamWriter = new OutputStreamWriter((OutputStream)o_FileOutputStream, "UTF-8");
                this.stringHTMLAll = this.stringHTMLAll.replace("$title", this.stringHTMLTitle);
                this.stringHTMLAll = this.stringHTMLAll.replace("$body", this.stringHTMLBody);
                o_OutputStreamWriter.write(this.stringHTMLAll, 0, this.stringHTMLAll.length());
                o_OutputStreamWriter.flush();
                o_OutputStreamWriter.close();
                o_FileOutputStream.flush();
                o_FileOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (o_OutputStreamWriter != null) {
                try {
                    o_OutputStreamWriter.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (o_FileOutputStream != null) {
                try {
                    o_FileOutputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

