/*
 * Decompiled with CFR 0.152.
 */
package SynchronizationPackage;

import java.util.ArrayList;

public class LiveCloseSemaphore {
    private ArrayList<Thread> m_WorkerThreads;
    private boolean m_OnClosing;
    private boolean m_CloseThreadIsWaiting;
    private Thread m_CloserThread;
    private String m_stringClassName;
    private boolean m_WillRefresh;
    private final Object m_SyncObject = new Object();

    public LiveCloseSemaphore(String p_ClassName) {
        this.m_stringClassName = p_ClassName;
        this.m_WillRefresh = false;
        this.m_OnClosing = false;
        this.m_CloseThreadIsWaiting = false;
        this.m_CloserThread = null;
        this.m_WorkerThreads = new ArrayList();
    }

    public void refresh() {
        if (!this.m_OnClosing) {
            return;
        }
        if (this.m_CloseThreadIsWaiting) {
            this.m_WillRefresh = true;
            return;
        }
        this.m_WillRefresh = false;
        this.m_OnClosing = false;
        this.m_CloseThreadIsWaiting = false;
        this.m_CloserThread = null;
        this.m_WorkerThreads.clear();
    }

    protected void finalize() throws Throwable {
        this.m_WorkerThreads.clear();
        this.m_WorkerThreads = null;
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enterCloseSection() {
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (this.m_OnClosing) {
                return false;
            }
            this.m_OnClosing = true;
            boolean boolOnlyCloserActive = false;
            this.m_CloserThread = Thread.currentThread();
            while (!boolOnlyCloserActive) {
                this.m_CloseThreadIsWaiting = true;
                boolOnlyCloserActive = true;
                Thread o_WorkerThread = null;
                int intThreadCount = this.m_WorkerThreads.size();
                for (int intThread = 0; intThread < intThreadCount; ++intThread) {
                    if (this.m_CloserThread == this.m_WorkerThreads.get(intThread)) continue;
                    boolOnlyCloserActive = false;
                    o_WorkerThread = this.m_WorkerThreads.get(intThread);
                    break;
                }
                if (!boolOnlyCloserActive) {
                    try {
                        this.m_SyncObject.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.m_CloseThreadIsWaiting = false;
            }
            if (this.m_WillRefresh) {
                this.refresh();
            }
        }
        return true;
    }

    public void leaveCloseSection() {
        this.m_CloserThread = null;
        this.m_WorkerThreads.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enterWorkerSection() {
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (!this.m_WorkerThreads.contains(Thread.currentThread()) && this.m_OnClosing && Thread.currentThread() != this.m_CloserThread) {
                return false;
            }
            this.m_WorkerThreads.add(Thread.currentThread());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leaveWorkerSection() {
        Object object = this.m_SyncObject;
        synchronized (object) {
            for (int intWorker = this.m_WorkerThreads.size() - 1; intWorker >= 0; --intWorker) {
                if (this.m_WorkerThreads.get(intWorker) != Thread.currentThread()) continue;
                this.m_WorkerThreads.remove(intWorker);
                break;
            }
            boolean boolOnlyCloserActive = true;
            if (this.m_CloserThread != null) {
                int intThreadCount = this.m_WorkerThreads.size();
                for (int intThread = 0; intThread < intThreadCount; ++intThread) {
                    if (this.m_CloserThread == this.m_WorkerThreads.get(intThread)) continue;
                    boolOnlyCloserActive = false;
                    break;
                }
                if (boolOnlyCloserActive && this.m_CloseThreadIsWaiting) {
                    this.m_SyncObject.notifyAll();
                }
            }
        }
    }

    public boolean get_OnClosing() {
        return this.m_OnClosing;
    }

    public boolean get_CloseThreadIsWaiting() {
        return this.m_CloseThreadIsWaiting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_WorkerThreadsCount() {
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (this.m_WorkerThreads == null) {
                return 0;
            }
            return this.m_WorkerThreads.size();
        }
    }

    public Thread get_CloserThread() {
        return this.m_CloserThread;
    }
}

