/*
 * Decompiled with CFR 0.152.
 */
package SwingComponents;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;

public class MouseAdapter_Delayed
extends MouseAdapter {
    public static int DELAYMILLISECONDS = 250;
    private int m_DelayMilliseconds;
    private HashMap<Object, MouseActionSource> m_MouseActionSources;
    private final Object m_SyncMouseActionSource = new Object();
    private int m_LastButtonPressed;
    private final Object m_SyncObjectSleep = new Object();
    private static Component s_ComponentDelegated = null;

    public MouseAdapter_Delayed() {
        this.initMembers();
    }

    public MouseAdapter_Delayed(int p_DelayMilliseconds) {
        this.initMembers();
        this.m_DelayMilliseconds = p_DelayMilliseconds;
    }

    private void initMembers() {
        this.m_MouseActionSources = new HashMap();
        this.m_DelayMilliseconds = DELAYMILLISECONDS;
        this.m_LastButtonPressed = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.m_SyncMouseActionSource;
        synchronized (object) {
            Iterator<MouseActionSource> o_Iterator = this.m_MouseActionSources.values().iterator();
            while (o_Iterator.hasNext()) {
                MouseActionSource o_MouseActionSource = o_Iterator.next();
                o_Iterator.remove();
                if (o_MouseActionSource == null) continue;
                o_MouseActionSource.close();
            }
        }
    }

    public int getDelay() {
        return this.m_DelayMilliseconds;
    }

    public void setDelay(int p_DelayMilliseconds) {
        if (p_DelayMilliseconds < 0) {
            p_DelayMilliseconds = 0;
        }
        this.m_DelayMilliseconds = p_DelayMilliseconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sleep(long p_Milliseconds) {
        try {
            Object object = this.m_SyncObjectSleep;
            synchronized (object) {
                this.m_SyncObjectSleep.wait(p_Milliseconds);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void mouseClicked_Delayed(MouseEvent e) {
    }

    public void mousePressed_Delayed(MouseEvent e) {
    }

    public void mouseReleased_Delayed(MouseEvent e) {
    }

    public void mouseEntered_Delayed(MouseEvent e) {
    }

    public void mouseExited_Delayed(MouseEvent e) {
    }

    public void mouseWheelMoved_Delayed(MouseWheelEvent e) {
    }

    public void mouseDragged_Delayed(MouseEvent e) {
    }

    public void mouseMoved_Delayed(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.checkMouseEventDelegate(e)) {
            return;
        }
        this.mouseEntered_Delayed(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.checkMouseEventDelegate(e)) {
            return;
        }
        this.mouseExited_Delayed(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.checkMouseEventDelegate(e)) {
            return;
        }
        this.m_LastButtonPressed = e.getButton();
        if (this.m_DelayMilliseconds <= 0) {
            this.mousePressed_Delayed(e);
            return;
        }
        MouseAction o_MouseAction = this.getMouseAction(e);
        if (o_MouseAction == null) {
            return;
        }
        o_MouseAction.mousePressed(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.checkMouseEventDelegate(e)) {
            return;
        }
        if (this.m_DelayMilliseconds <= 0) {
            this.mouseReleased_Delayed(e);
            return;
        }
        MouseAction o_MouseAction = this.getMouseAction(e);
        if (o_MouseAction == null) {
            return;
        }
        o_MouseAction.mouseReleased(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.checkMouseEventDelegate(e)) {
            return;
        }
        if (this.m_DelayMilliseconds <= 0) {
            this.mouseClicked_Delayed(e);
            return;
        }
        MouseAction o_MouseAction = this.getMouseAction(e);
        if (o_MouseAction == null) {
            return;
        }
        o_MouseAction.mouseClicked(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.checkMouseEventDelegate(e)) {
            return;
        }
        if (this.m_DelayMilliseconds <= 0) {
            this.mouseDragged_Delayed(e);
            return;
        }
        MouseAction o_MouseAction = this.getMouseAction(e, this.m_LastButtonPressed);
        if (o_MouseAction == null) {
            return;
        }
        o_MouseAction.mouseDragged(e);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.checkMouseEventDelegate(e)) {
            return;
        }
        this.mouseWheelMoved_Delayed(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.checkMouseEventDelegate(e)) {
            return;
        }
        this.mouseMoved_Delayed(e);
    }

    public void clearMouseEventDelegate() {
        s_ComponentDelegated = null;
    }

    private boolean checkMouseEventDelegate(MouseEvent e) {
        if (e.getSource() instanceof MouseEventDelegate) {
            MouseEventDelegate o_MouseEventDelegate = (MouseEventDelegate)e.getSource();
            Component o_Component = null;
            Component o_ComponentDelegate = null;
            boolean boolMouseEventDelegateActive = o_MouseEventDelegate.getMouseEventDelegate_IsActive(e);
            if (s_ComponentDelegated == null) {
                if (boolMouseEventDelegateActive) {
                    o_Component = o_MouseEventDelegate.getMouseEventDelegate_ComponentDest(e);
                }
                if (e.getID() == 501 && o_Component != null && boolMouseEventDelegateActive) {
                    s_ComponentDelegated = o_Component;
                }
                if ((o_ComponentDelegate = s_ComponentDelegated) == null && boolMouseEventDelegateActive) {
                    return true;
                }
            } else {
                o_ComponentDelegate = s_ComponentDelegated;
                if (e.getID() == 502) {
                    s_ComponentDelegated = null;
                }
            }
            if (o_ComponentDelegate != null) {
                this.delegateMouseEvent(e, o_ComponentDelegate);
                return true;
            }
        }
        return false;
    }

    private void delegateMouseEvent(MouseEvent p_MouseEvent, Component p_Component) {
        if (p_MouseEvent == null) {
            return;
        }
        if (p_Component == null) {
            return;
        }
        Point o_PointInComponent = new Point(p_MouseEvent.getXOnScreen(), p_MouseEvent.getYOnScreen());
        SwingUtilities.convertPointFromScreen(o_PointInComponent, p_Component);
        MouseEvent o_MouseEvent = new MouseEvent(p_Component, p_MouseEvent.getID(), p_MouseEvent.getWhen(), 0, o_PointInComponent.x, o_PointInComponent.y, p_MouseEvent.getClickCount(), false, p_MouseEvent.getButton());
        p_Component.dispatchEvent(o_MouseEvent);
    }

    private MouseAction getMouseAction(MouseEvent e) {
        if (e.getComponent() == null) {
            return null;
        }
        MouseActionSource o_MouseActionSource = this.getMouseActionSource(e);
        if (o_MouseActionSource == null) {
            return null;
        }
        MouseAction o_MouseAction = o_MouseActionSource.getMouseAction(e.getButton());
        return o_MouseAction;
    }

    private MouseAction getMouseAction(MouseEvent e, int p_Button) {
        if (e.getComponent() == null) {
            return null;
        }
        MouseActionSource o_MouseActionSource = this.getMouseActionSource(e);
        if (o_MouseActionSource == null) {
            return null;
        }
        MouseAction o_MouseAction = o_MouseActionSource.getMouseAction(p_Button);
        return o_MouseAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MouseActionSource getMouseActionSource(MouseEvent e) {
        MouseActionSource o_MouseActionSource;
        if (e.getComponent() == null) {
            return null;
        }
        Object object = this.m_SyncMouseActionSource;
        synchronized (object) {
            o_MouseActionSource = this.m_MouseActionSources.get(e.getSource());
            if (o_MouseActionSource == null) {
                o_MouseActionSource = new MouseActionSource(this, e.getComponent());
                this.m_MouseActionSources.put(e.getSource(), o_MouseActionSource);
            }
        }
        return o_MouseActionSource;
    }

    public static MouseEvent createMouseEvent(MouseEvent e, int p_ID, int p_ClickCount) {
        return MouseAdapter_Delayed.createMouseEvent(e.getComponent(), p_ID, e.getWhen(), e.getModifiersEx(), e.getX(), e.getY(), e.getXOnScreen(), e.getYOnScreen(), p_ClickCount, e.isPopupTrigger(), e.getButton());
    }

    public static MouseEvent createMouseEvent(MouseEvent e, int p_ID, int p_X, int p_Y, int p_XAbs, int p_YAbs, int p_ClickCount) {
        return MouseAdapter_Delayed.createMouseEvent(e.getComponent(), p_ID, e.getWhen(), e.getModifiersEx(), p_X, p_Y, p_XAbs, p_YAbs, p_ClickCount, e.isPopupTrigger(), e.getButton());
    }

    public static MouseEvent createMouseEvent(Component p_Componet, int p_Id, long p_When, int p_Modifiers, int p_X, int p_Y, int p_XAbs, int p_YAbs, int p_ClickCount, boolean p_PopupTrigger, int p_Button) {
        MouseEvent o_MouseEvent = new MouseEvent(p_Componet, p_Id, p_When, p_Modifiers, p_X, p_Y, p_XAbs, p_YAbs, p_ClickCount, p_PopupTrigger, p_Button);
        return o_MouseEvent;
    }

    private static class MouseAction {
        public static final int STATUS_NONE = 0;
        public static final int STATUS_PRESSED = 1;
        public static final int STATUS_RELEASED = 2;
        public static final int STATUS_CLICKED = 3;
        public static final int STATUS_DRAGGED = 4;
        private MouseAdapter_Delayed m_MouseAdapter_Delayed;
        private MouseActionSource m_MouseActionSource;
        private int m_MouseButton;
        private int m_ButtonCount;
        private int m_ButtonCountAFterRelease;
        private boolean m_IsClickEvent;
        private MouseEvent m_MouseEvent_Pressed;
        private MouseEvent m_MouseEvent_Released;
        private MouseEvent m_MouseEvent_Clicked;
        private int m_Status;
        private int m_StatusBefore;
        private boolean m_TimerDelayEnd;
        private Timer m_TimerDelay;
        private TimerTask m_TimerDelayTask;
        private final Object m_SyncDelay = new Object();
        private int m_XPressedFirst;
        private int m_YPressedFirst;
        private int m_XAbsPressedFirst;
        private int m_YAbsPressedFirst;

        public MouseAction(MouseAdapter_Delayed p_MouseAdapter_Delayed, MouseActionSource p_MouseActionSource, int p_MouseButton) {
            this.m_MouseAdapter_Delayed = p_MouseAdapter_Delayed;
            this.m_MouseActionSource = p_MouseActionSource;
            this.m_MouseButton = p_MouseButton;
            this.initMembers();
        }

        private void initMembers() {
            this.m_ButtonCount = 0;
            this.m_ButtonCountAFterRelease = 0;
            this.m_TimerDelayEnd = true;
            this.m_Status = 0;
            this.m_StatusBefore = 0;
            this.m_IsClickEvent = false;
            this.m_TimerDelayTask = new TimerTask(){

                @Override
                public void run() {
                    this.timerDelayEnd();
                }
            };
            this.m_TimerDelay = new Timer("MouseEvent" + String.valueOf(this.m_MouseButton));
        }

        public void close() {
            this.m_TimerDelay.purge();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void timerDelayStart() {
            Object object = this.m_SyncDelay;
            synchronized (object) {
                if (this.m_TimerDelayEnd) {
                    this.m_TimerDelayEnd = false;
                    this.m_TimerDelayTask = new TimerTask(){

                        @Override
                        public void run() {
                            this.timerDelayEnd();
                        }
                    };
                    this.m_TimerDelay.schedule(this.m_TimerDelayTask, this.m_MouseAdapter_Delayed.getDelay());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void timerDelayEnd() {
            Object object = this.m_SyncDelay;
            synchronized (object) {
                this.m_TimerDelayEnd = true;
                switch (this.m_Status) {
                    case 3: {
                        MouseEvent o_MouseEvent;
                        if (this.m_MouseEvent_Pressed != null) {
                            o_MouseEvent = MouseAdapter_Delayed.createMouseEvent(this.m_MouseEvent_Pressed, 501, this.m_XPressedFirst, this.m_YPressedFirst, this.m_XAbsPressedFirst, this.m_YAbsPressedFirst, this.m_ButtonCountAFterRelease);
                            this.m_MouseAdapter_Delayed.mousePressed_Delayed(o_MouseEvent);
                            if (o_MouseEvent.isConsumed()) {
                                this.m_MouseEvent_Pressed.consume();
                            }
                        }
                        if (this.m_MouseEvent_Released != null) {
                            o_MouseEvent = MouseAdapter_Delayed.createMouseEvent(this.m_MouseEvent_Released, 502, this.m_ButtonCountAFterRelease);
                            this.m_MouseAdapter_Delayed.mouseReleased_Delayed(o_MouseEvent);
                            if (o_MouseEvent.isConsumed()) {
                                this.m_MouseEvent_Released.consume();
                            }
                        }
                        if (this.m_MouseEvent_Clicked != null) {
                            o_MouseEvent = MouseAdapter_Delayed.createMouseEvent(this.m_MouseEvent_Clicked, 500, this.m_ButtonCountAFterRelease);
                            this.m_MouseAdapter_Delayed.mouseClicked_Delayed(o_MouseEvent);
                            if (o_MouseEvent.isConsumed()) {
                                this.m_MouseEvent_Clicked.consume();
                            }
                        }
                        this.endButtonSequence();
                        break;
                    }
                    case 2: {
                        MouseEvent o_MouseEvent;
                        if (this.m_MouseEvent_Pressed != null) {
                            o_MouseEvent = MouseAdapter_Delayed.createMouseEvent(this.m_MouseEvent_Pressed, 501, this.m_XPressedFirst, this.m_YPressedFirst, this.m_XAbsPressedFirst, this.m_YAbsPressedFirst, this.m_ButtonCount);
                            this.m_MouseAdapter_Delayed.mousePressed_Delayed(o_MouseEvent);
                            if (o_MouseEvent.isConsumed()) {
                                this.m_MouseEvent_Pressed.consume();
                            }
                        }
                        if (this.m_MouseEvent_Released != null) {
                            o_MouseEvent = MouseAdapter_Delayed.createMouseEvent(this.m_MouseEvent_Released, 502, this.m_ButtonCount);
                            this.m_MouseAdapter_Delayed.mouseReleased_Delayed(o_MouseEvent);
                            if (o_MouseEvent.isConsumed()) {
                                this.m_MouseEvent_Released.consume();
                            }
                        }
                        if (this.m_StatusBefore == 1 && this.m_MouseEvent_Pressed != null) {
                            o_MouseEvent = MouseAdapter_Delayed.createMouseEvent(this.m_MouseEvent_Released, 500, this.m_ButtonCount);
                            this.m_MouseAdapter_Delayed.mouseClicked_Delayed(o_MouseEvent);
                            if (o_MouseEvent.isConsumed()) {
                                this.m_MouseEvent_Released.consume();
                            }
                        }
                        this.endButtonSequence();
                        break;
                    }
                    case 1: {
                        if (this.m_MouseEvent_Pressed == null) break;
                        MouseEvent o_MouseEvent = MouseAdapter_Delayed.createMouseEvent(this.m_MouseEvent_Pressed, 501, this.m_XPressedFirst, this.m_YPressedFirst, this.m_XAbsPressedFirst, this.m_YAbsPressedFirst, this.m_ButtonCount);
                        this.m_MouseAdapter_Delayed.mousePressed_Delayed(o_MouseEvent);
                        if (!o_MouseEvent.isConsumed()) break;
                        this.m_MouseEvent_Pressed.consume();
                        break;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mousePressed(MouseEvent e) {
            Object object = this.m_SyncDelay;
            synchronized (object) {
                this.m_MouseEvent_Pressed = e;
                this.m_Status = 1;
                this.m_StatusBefore = 0;
                ++this.m_ButtonCount;
                if (this.m_TimerDelayEnd) {
                    this.m_IsClickEvent = false;
                    this.m_XPressedFirst = e.getX();
                    this.m_YPressedFirst = e.getY();
                    this.m_XAbsPressedFirst = e.getXOnScreen();
                    this.m_YAbsPressedFirst = e.getYOnScreen();
                    this.timerDelayStart();
                } else {
                    this.m_MouseEvent_Pressed.consume();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseReleased(MouseEvent e) {
            Object object = this.m_SyncDelay;
            synchronized (object) {
                this.m_MouseEvent_Released = e;
                this.m_StatusBefore = this.m_Status;
                this.m_Status = 2;
                this.m_IsClickEvent = true;
                this.m_ButtonCountAFterRelease = this.m_ButtonCount;
                if (this.m_TimerDelayEnd) {
                    MouseEvent o_MouseEvent = MouseAdapter_Delayed.createMouseEvent(this.m_MouseEvent_Released, 502, this.m_ButtonCount);
                    this.m_MouseAdapter_Delayed.mouseReleased_Delayed(o_MouseEvent);
                    if (o_MouseEvent.isConsumed()) {
                        e.consume();
                    }
                    if (this.m_StatusBefore == 1) {
                        this.m_Status = 3;
                        o_MouseEvent = MouseAdapter_Delayed.createMouseEvent(this.m_MouseEvent_Released, 500, this.m_ButtonCount);
                        this.m_MouseAdapter_Delayed.mouseClicked_Delayed(o_MouseEvent);
                        if (o_MouseEvent.isConsumed()) {
                            e.consume();
                        }
                    }
                    this.endButtonSequence();
                } else {
                    this.m_MouseEvent_Released.consume();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseClicked(MouseEvent e) {
            Object object = this.m_SyncDelay;
            synchronized (object) {
                this.m_MouseEvent_Clicked = e;
                this.m_StatusBefore = this.m_Status;
                this.m_Status = 3;
                if (this.m_TimerDelayEnd) {
                    if (this.m_StatusBefore == 1) {
                        MouseEvent o_MouseEvent = MouseAdapter_Delayed.createMouseEvent(this.m_MouseEvent_Clicked, 500, this.m_ButtonCountAFterRelease);
                        this.m_MouseAdapter_Delayed.mouseClicked_Delayed(o_MouseEvent);
                        if (o_MouseEvent.isConsumed()) {
                            e.consume();
                        }
                    }
                } else {
                    this.m_MouseEvent_Clicked.consume();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseDragged(MouseEvent e) {
            Object object = this.m_SyncDelay;
            synchronized (object) {
                if (this.m_IsClickEvent) {
                    e.consume();
                    return;
                }
                if (!this.m_TimerDelayEnd) {
                    if (this.m_Status == 1) {
                        MouseEvent o_MouseEvent = MouseAdapter_Delayed.createMouseEvent(this.m_MouseEvent_Pressed, 501, this.m_XPressedFirst, this.m_YPressedFirst, this.m_XAbsPressedFirst, this.m_YAbsPressedFirst, this.m_ButtonCount);
                        this.m_MouseAdapter_Delayed.mousePressed_Delayed(o_MouseEvent);
                        if (o_MouseEvent.isConsumed()) {
                            this.m_MouseEvent_Pressed.consume();
                        }
                    }
                    this.m_TimerDelayEnd = true;
                }
                this.m_Status = 4;
                this.m_MouseAdapter_Delayed.mouseDragged_Delayed(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void endButtonSequence() {
            Object object = this.m_SyncDelay;
            synchronized (object) {
                this.m_ButtonCount = 0;
            }
        }
    }

    private static class MouseActionSource {
        private MouseAdapter_Delayed m_MouseAdapter_Delayed;
        private Component m_Source;
        private HashMap<Integer, MouseAction> m_MouseActions;
        private final Object m_SyncMouseActions = new Object();

        public MouseActionSource(MouseAdapter_Delayed p_MouseAdapter_Delayed, Component p_Source) {
            this.m_MouseAdapter_Delayed = p_MouseAdapter_Delayed;
            this.m_Source = p_Source;
            this.initMembers();
        }

        private void initMembers() {
            this.m_MouseActions = new HashMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.m_SyncMouseActions;
            synchronized (object) {
                Iterator<MouseAction> o_Iterator = this.m_MouseActions.values().iterator();
                while (o_Iterator.hasNext()) {
                    MouseAction o_MouseAction = o_Iterator.next();
                    o_Iterator.remove();
                    if (o_MouseAction == null) continue;
                    o_MouseAction.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MouseAction getMouseAction(int p_Button) {
            MouseAction o_MouseAction;
            Object object = this.m_SyncMouseActions;
            synchronized (object) {
                o_MouseAction = this.m_MouseActions.get(p_Button);
                if (o_MouseAction == null) {
                    o_MouseAction = new MouseAction(this.m_MouseAdapter_Delayed, this, p_Button);
                    this.m_MouseActions.put(p_Button, o_MouseAction);
                }
            }
            return o_MouseAction;
        }
    }

    public static interface MouseEventDelegate {
        public Component getMouseEventDelegate_ComponentDest(MouseEvent var1);

        public boolean getMouseEventDelegate_IsActive(MouseEvent var1);
    }
}

