/*
 * Decompiled with CFR 0.152.
 */
package SoundPackage;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import SoundPackage.SoundMixers;
import SoundPackage.Sound_LineFactorPanel;
import SoundPackage.Sound_LinesPanel;
import SwingTextPackage.DocumentFilter_Double;
import SwingToolTipPackage.PopUpToolTip;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.text.JTextComponent;

public class Sound_Channel_LinesPanel
extends JPanel {
    public static ImageIcon s_ArraowRight = new ImageIcon(Sound_Channel_LinesPanel.class.getResource("/IconsPackage/Arrow_Right_16.png"));
    public static ImageIcon s_ArraowLeft = new ImageIcon(Sound_Channel_LinesPanel.class.getResource("/IconsPackage/Arrow_Left_16.png"));
    private static Border s_TextBorder = new LineBorder(Color.GRAY, 1);
    private Sound_LinesPanel m_Sound_LinesPanel;
    private SoundMixers.Sound_Lines m_Sound_Lines;
    private SoundMixers.Sound_Lines_Parent m_Sound_Lines_Parent;
    private int m_Channel;
    private ArrayList<Sound_LineFactorPanel> m_Sound_LineFactorPanels;
    private final Object m_SyncObject = new Object();
    private JLabel jLabel_Channel;
    private JLabel jLabel_DB;
    private JLabel jLabel_Direction;
    private JPanel jPanel_SoundLineFactors;
    private JTextField jTextField_ChannelDelay_ms;

    public Sound_Channel_LinesPanel(Sound_LinesPanel p_Sound_LinesPanel, int p_Channel) {
        this.initMembers();
        this.initComponents();
        this.m_Sound_LinesPanel = p_Sound_LinesPanel;
        this.m_Channel = p_Channel;
        this.initComponentsFurther();
        LiveLanguage.addLanguageListener(this, null);
    }

    private void initMembers() {
        this.m_Channel = 0;
        this.m_Sound_Lines = null;
        this.m_Sound_LineFactorPanels = new ArrayList();
    }

    private void initComponentsFurther() {
        this.jLabel_Channel.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jTextField_ChannelDelay_ms.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jTextField_ChannelDelay_ms.setBorder(s_TextBorder);
        DocumentFilter_Double o_DocumentFilter_Double = new DocumentFilter_Double((JTextComponent)this.jTextField_ChannelDelay_ms);
        Dimension o_Dimension_SoundLineFactors = new Dimension(SoundMixers.SOUND_SOUNDLINES_COUNT * Sound_LineFactorPanel.s_Size.width, Sound_LineFactorPanel.s_Size.height);
        this.jPanel_SoundLineFactors.setMinimumSize(o_Dimension_SoundLineFactors);
        this.jPanel_SoundLineFactors.setMaximumSize(o_Dimension_SoundLineFactors);
        this.jPanel_SoundLineFactors.setPreferredSize(o_Dimension_SoundLineFactors);
        for (int intLine = 0; intLine < SoundMixers.SOUND_SOUNDLINES_COUNT; ++intLine) {
            GridBagConstraints o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = intLine;
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.anchor = 10;
            Sound_LineFactorPanel o_Sound_LineFactorPanel = new Sound_LineFactorPanel(this, this.m_Channel, intLine);
            this.m_Sound_LineFactorPanels.add(o_Sound_LineFactorPanel);
            this.jPanel_SoundLineFactors.add((Component)o_Sound_LineFactorPanel, o_GridBagConstraints);
        }
        int intInsetsLeftRight = 6;
        int intWidth = 0;
        intWidth += this.jLabel_Channel.getPreferredSize().width + intInsetsLeftRight;
        intWidth += this.jLabel_Direction.getPreferredSize().width + intInsetsLeftRight;
        intWidth += this.jLabel_DB.getPreferredSize().width + intInsetsLeftRight;
        intWidth += o_Dimension_SoundLineFactors.width + intInsetsLeftRight;
        intWidth += this.jTextField_ChannelDelay_ms.getPreferredSize().width + intInsetsLeftRight;
        int intHeight = 0;
        if (this.jLabel_Channel.getPreferredSize().height > intHeight) {
            intHeight = this.jLabel_Channel.getPreferredSize().height;
        }
        if (this.jLabel_Direction.getPreferredSize().height > intHeight) {
            intHeight = this.jLabel_Direction.getPreferredSize().height;
        }
        if (this.jLabel_DB.getPreferredSize().height > intHeight) {
            intHeight = this.jLabel_DB.getPreferredSize().height;
        }
        if (o_Dimension_SoundLineFactors.height > intHeight) {
            intHeight = o_Dimension_SoundLineFactors.height;
        }
        Dimension o_Dimension = new Dimension(intWidth, intHeight);
        this.setMinimumSize(o_Dimension);
        this.setMaximumSize(o_Dimension);
        this.setPreferredSize(o_Dimension);
    }

    private void initComponents() {
        this.jLabel_Channel = new JLabel();
        this.jPanel_SoundLineFactors = new JPanel();
        this.jLabel_DB = new JLabel();
        this.jLabel_Direction = new JLabel();
        this.jTextField_ChannelDelay_ms = new JTextField();
        this.setForeground(new Color(255, 255, 255));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 37));
        this.setMinimumSize(new Dimension(300, 37));
        this.setName("");
        this.setPreferredSize(new Dimension(300, 37));
        this.setLayout(new GridBagLayout());
        this.jLabel_Channel.setFont(new Font("Tahoma", 0, 14));
        this.jLabel_Channel.setText("99 (SUB)");
        this.jLabel_Channel.setToolTipText("");
        this.jLabel_Channel.setMaximumSize(new Dimension(70, 35));
        this.jLabel_Channel.setMinimumSize(new Dimension(70, 35));
        this.jLabel_Channel.setPreferredSize(new Dimension(70, 35));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_Channel, gridBagConstraints);
        this.jPanel_SoundLineFactors.setMaximumSize(new Dimension(Short.MAX_VALUE, 35));
        this.jPanel_SoundLineFactors.setMinimumSize(new Dimension(100, 35));
        this.jPanel_SoundLineFactors.setPreferredSize(new Dimension(100, 35));
        this.jPanel_SoundLineFactors.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jPanel_SoundLineFactors, gridBagConstraints);
        this.jLabel_DB.setFont(new Font("Tahoma", 0, 10));
        this.jLabel_DB.setHorizontalAlignment(2);
        this.jLabel_DB.setText("db");
        this.jLabel_DB.setToolTipText("");
        this.jLabel_DB.setMaximumSize(new Dimension(35, 35));
        this.jLabel_DB.setMinimumSize(new Dimension(35, 35));
        this.jLabel_DB.setName("");
        this.jLabel_DB.setPreferredSize(new Dimension(35, 35));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_DB, gridBagConstraints);
        this.jLabel_Direction.setFont(new Font("Tahoma", 0, 14));
        this.jLabel_Direction.setHorizontalAlignment(0);
        this.jLabel_Direction.setToolTipText("");
        this.jLabel_Direction.setMaximumSize(new Dimension(16, 16));
        this.jLabel_Direction.setMinimumSize(new Dimension(16, 16));
        this.jLabel_Direction.setName("");
        this.jLabel_Direction.setPreferredSize(new Dimension(16, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_Direction, gridBagConstraints);
        this.jTextField_ChannelDelay_ms.setHorizontalAlignment(0);
        this.jTextField_ChannelDelay_ms.setText("0");
        this.jTextField_ChannelDelay_ms.setToolTipText("<html>Enter delay in milliseconds and press 'Enter'<br>or<br>enter distance and press:<br> m for meters<br> i  for inches<br> f  for foots<br> y for yards.</html> ");
        this.jTextField_ChannelDelay_ms.setBorder(null);
        this.jTextField_ChannelDelay_ms.setMaximumSize(new Dimension(55, 25));
        this.jTextField_ChannelDelay_ms.setMinimumSize(new Dimension(55, 25));
        this.jTextField_ChannelDelay_ms.setPreferredSize(new Dimension(55, 25));
        this.jTextField_ChannelDelay_ms.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                Sound_Channel_LinesPanel.this.jTextField_ChannelDelay_msFocusLost(evt);
            }
        });
        this.jTextField_ChannelDelay_ms.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                Sound_Channel_LinesPanel.this.jTextField_ChannelDelay_msKeyPressed(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                Sound_Channel_LinesPanel.this.jTextField_ChannelDelay_msKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jTextField_ChannelDelay_ms, gridBagConstraints);
    }

    private void jTextField_ChannelDelay_msFocusLost(FocusEvent evt) {
        this.setDelay_ms();
    }

    private void jTextField_ChannelDelay_msKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.setDelay_ms();
        }
    }

    private void jTextField_ChannelDelay_msKeyTyped(KeyEvent evt) {
        if (evt.getKeyChar() == 'm' || evt.getKeyChar() == 'M') {
            this.setDelay_Meter("meter");
        } else if (evt.getKeyChar() == 'i' || evt.getKeyChar() == 'I') {
            this.setDelay_Meter("inch");
        } else if (evt.getKeyChar() == 'f' || evt.getKeyChar() == 'F') {
            this.setDelay_Meter("foot");
        } else if (evt.getKeyChar() == 'y' || evt.getKeyChar() == 'Y') {
            this.setDelay_Meter("yard");
        }
    }

    private void setDelay_ms() {
        int intDelay;
        try {
            intDelay = Double.valueOf(this.jTextField_ChannelDelay_ms.getText()).intValue();
        }
        catch (Exception e) {
            intDelay = 0;
        }
        if (this.m_Sound_Lines_Parent instanceof SoundMixers.SoundMixer && this.m_Sound_Lines.getChannelDelay_ms(this.m_Channel) != intDelay) {
            this.m_Sound_Lines.setChannelDelay_ms(this.m_Channel, intDelay);
            this.notifyUserInput();
        }
        this.refreshGUI();
    }

    private void setDelay_Meter(String p_Unit) {
        double doubleMeter;
        double doubleValue;
        try {
            String stringMeter = this.jTextField_ChannelDelay_ms.getText();
            doubleValue = Double.valueOf(stringMeter);
        }
        catch (Exception e) {
            doubleValue = 0.0;
        }
        switch (p_Unit) {
            case "meter": {
                doubleMeter = doubleValue;
                break;
            }
            case "inch": {
                doubleMeter = doubleValue * 2.54 / 100.0;
                break;
            }
            case "foot": {
                doubleMeter = doubleValue * 30.48 / 100.0;
                break;
            }
            case "yard": {
                doubleMeter = doubleValue * 0.9144;
                break;
            }
            default: {
                doubleMeter = 0.0;
            }
        }
        if (this.m_Sound_Lines_Parent instanceof SoundMixers.SoundMixer) {
            int intDelay_ms = (int)(doubleMeter / 343.46 * 1000.0);
            if (this.m_Sound_Lines.getChannelDelay_ms(this.m_Channel) != intDelay_ms) {
                this.m_Sound_Lines.setChannelDelay_ms(this.m_Channel, intDelay_ms);
                this.notifyUserInput();
            }
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Sound_Channel_LinesPanel.this.refreshGUI();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSound_Lines_Parent(SoundMixers.Sound_Lines_Parent p_Sound_Lines_Parent) {
        Object object = this.m_SyncObject;
        synchronized (object) {
            this.m_Sound_Lines_Parent = p_Sound_Lines_Parent;
            this.m_Sound_Lines = this.m_Sound_Lines_Parent != null ? this.m_Sound_Lines_Parent.getSound_Lines() : null;
            for (int intLine = 0; intLine < SoundMixers.SOUND_SOUNDLINES_COUNT; ++intLine) {
                Sound_LineFactorPanel o_Sound_LineFactorPanel = this.m_Sound_LineFactorPanels.get(intLine);
                o_Sound_LineFactorPanel.setSound_Lines_Parent(this.m_Sound_Lines_Parent);
            }
        }
        this.refreshGUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSound_Lines(SoundMixers.Sound_Lines p_Sound_Lines) {
        Object object = this.m_SyncObject;
        synchronized (object) {
            this.m_Sound_Lines_Parent = null;
            this.m_Sound_Lines = p_Sound_Lines;
            for (int intLine = 0; intLine < SoundMixers.SOUND_SOUNDLINES_COUNT; ++intLine) {
                Sound_LineFactorPanel o_Sound_LineFactorPanel = this.m_Sound_LineFactorPanels.get(intLine);
                o_Sound_LineFactorPanel.setSound_Lines(this.m_Sound_Lines);
            }
        }
        this.refreshGUI();
    }

    public void notifyUserInput() {
        if (this.m_Sound_LinesPanel != null) {
            this.m_Sound_LinesPanel.notifySound_Lines_Changed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changedExternalSound_Lines() {
        this.refreshGUI();
        Object object = this.m_SyncObject;
        synchronized (object) {
            for (int intPanel = 0; intPanel < this.m_Sound_LineFactorPanels.size(); ++intPanel) {
                Sound_LineFactorPanel o_Sound_LineFactorPanel = this.m_Sound_LineFactorPanels.get(intPanel);
                o_Sound_LineFactorPanel.changedExternalSound_Lines();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshGUI() {
        int intInsetsLeftRight = 6;
        int intWidth = 0;
        Object object = this.m_SyncObject;
        synchronized (object) {
            this.jLabel_Channel.setText(SoundMixers.getChannelName(this.m_Channel));
            this.jLabel_Channel.setToolTipText(SoundMixers.getChannelToolTip(this.m_Channel));
            String stringParentType = this.m_Sound_Lines == null ? "" : this.m_Sound_Lines.getParentType();
            if ("SoundObject".equals(stringParentType)) {
                this.jLabel_Direction.setIcon(s_ArraowRight);
            } else if ("SoundMixer".equals(stringParentType)) {
                this.jLabel_Direction.setIcon(s_ArraowLeft);
            } else if ("SoundTrachbouncing".equals(stringParentType)) {
                this.jLabel_Direction.setIcon(s_ArraowLeft);
            } else {
                this.jLabel_Direction.setIcon(null);
            }
            if (this.m_Sound_Lines_Parent instanceof SoundMixers.SoundMixer) {
                this.jTextField_ChannelDelay_ms.setVisible(true);
                intWidth += this.jTextField_ChannelDelay_ms.getPreferredSize().width;
                int intDelay_ms = 0;
                SoundMixers.Sound_Channel_Lines o_Sound_Channel_Lines = this.m_Sound_Lines.getSound_Channel_Lines(this.m_Channel);
                if (o_Sound_Channel_Lines != null) {
                    intDelay_ms = o_Sound_Channel_Lines.getChannelDelay();
                }
                this.jTextField_ChannelDelay_ms.setText(String.valueOf(intDelay_ms));
            } else {
                this.jTextField_ChannelDelay_ms.setVisible(false);
            }
            intWidth += this.jLabel_Channel.getPreferredSize().width + intInsetsLeftRight;
            intWidth += this.jLabel_Direction.getPreferredSize().width + intInsetsLeftRight;
            intWidth += this.jLabel_DB.getPreferredSize().width + intInsetsLeftRight;
            intWidth += this.jPanel_SoundLineFactors.getPreferredSize().width + intInsetsLeftRight;
            int intHeight = 0;
            if (this.jLabel_Channel.getPreferredSize().height > intHeight) {
                intHeight = this.jLabel_Channel.getPreferredSize().height;
            }
            if (this.jLabel_Direction.getPreferredSize().height > intHeight) {
                intHeight = this.jLabel_Direction.getPreferredSize().height;
            }
            if (this.jLabel_DB.getPreferredSize().height > intHeight) {
                intHeight = this.jLabel_DB.getPreferredSize().height;
            }
            if (this.jPanel_SoundLineFactors.getPreferredSize().height > intHeight) {
                intHeight = this.jPanel_SoundLineFactors.getPreferredSize().height;
            }
            Dimension o_Dimension = new Dimension(intWidth, intHeight);
            this.setMinimumSize(o_Dimension);
            this.setPreferredSize(o_Dimension);
        }
    }
}

