/*
 * Decompiled with CFR 0.152.
 */
package SoundPackage;

import BioMathmaticsPackage.BioMathematics;
import FileToolPackage.FileSelection;
import FileToolPackage.FileTools;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowObjectPackage.SinglePropertyChangeSupport;
import OS.OSChecker;
import SoundPackage.JDialog_Sound_Lines;
import SwingFramePackage.JOptionDialog;
import SwingModelPackage.TableAndListModel;
import SwingToolTipPackage.PopUpToolTip;
import com.liveshowsound.Device;
import com.liveshowsound.DirectSound;
import com.liveshowsound.Exception_SoundCardLost;
import com.liveshowsound.PlayBuffer;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import org.bytedeco.javacv.FFmpegFrameGrabber;

public class SoundMixers {
    public static final boolean DEBUG_ON = false;
    public static AudioFormat DEFAULT_AUDIOFORMAT = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 2, 4, 44100.0f, false);
    public static int BUFFERSIZE_FRAMES_MIXER = 512;
    public static int BUFFERSIZE_FRAMES_PLAYBUFFER = 4 * BUFFERSIZE_FRAMES_MIXER;
    public static int BUFFERSIZE_FRAMES_SOUNDCARD = 12 * BUFFERSIZE_FRAMES_MIXER;
    public static int DELAY_MAX_MILLISECONDS = 500;
    public static int SOUND_SOUNDLINES_COUNT = 10;
    public static int SOUND_SOUNDLINES_COUNT_NEW = 10;
    public static int SOUND_SOUNDLINES_COUNT_MIN = 8;
    public static int SOUND_SOUNDLINES_COUNT_MAX = 16;
    public static int BUFFERSIZE_IN_MS = 100;
    @LiveLanguageString
    public static String SOUNDMIXER_SAVESETTINGS_TITEL = "Save SoundMixer Settings";
    @LiveLanguageString
    public static String SOUNDMIXER_LOADSETTINGS_TITEL = "Load SoundMixer Settings";
    @LiveLanguageString
    public static String SOUNDMIXERERROR_TITEL = "Error SoundMixer";
    @LiveLanguageString
    public static String SOUNDMIXERERROR_NOMIXERFOUND_REMARK = "There exists no suitable soundmixer!";
    @LiveLanguageString
    public static String SOUNDMIXERERROR_MIXEREMOVED_REMARK = "The mixer is not reachable!<br>He may be plugged off.";
    @LiveLanguageString
    public static String SOUNDMIXERERROR_NOMIXERACTIVATED_REMARK = "<html>No soundcard is activated.<br>Please check if all soundcards are connected<br>or check the soundcard settings!</html>";
    public static boolean SHOW_NOTIFICATION_SOUNCARDLOST = false;
    private static boolean s_AutoRefreshMixersStop = false;
    private static final Object s_SyncAutoRefreshMixers = new Object();
    private static Thread s_AutoRefreshMixersThread;
    private static Runnable s_AutoRefreshMixersRunnable;
    private static final double MAX_INT16 = 32767.0;
    private static final double MAX_INT18 = 131071.0;
    private static final double MAX_INT20 = 524287.0;
    private static final double MAX_INT24 = 8388607.0;
    private static final double MAX_INT32 = 2.147483647E9;
    public static SoundBuffer_Mixers s_SoundBuffer_Mixers;
    public static double s_MainVolumeFactor_Sound;
    public static double s_MainLoudness;
    public static Sound_Lines s_Sound_Lines_Preview;
    public static JDialog_Sound_Lines s_JDialog_Sound_Lines_Preview;
    public static final String SOUNDLINESPREVIEW_FILEEXTENSION = ".slp";
    public static final String SOUNDLINESPREVIEW_FILEDEFAULTNAME = "SoundLinesPreview";
    @LiveLanguageString
    public static String SOUNDMIXER_FILE_FILTERNAME;
    public static final String SOUNDMIXER_FILEEXTENSION = ".sms";
    public static final String SOUNDMIXER_FILEDEFAULTNAME = "Default";
    public static SoundMixer_Setting s_SoundMixer_Setting;
    public static SoundMixerTableModel s_SoundMixerTableModel;
    public static SoundMixer_Controller s_SoundMixer_Controller;
    public static ImageIcon s_IconSoundLines;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startAutoRefreshMixers() {
        Object object = s_SyncAutoRefreshMixers;
        synchronized (object) {
            if (s_AutoRefreshMixersThread == null) {
                s_AutoRefreshMixersThread = new Thread(s_AutoRefreshMixersRunnable, "SoundMixers_AutoRefreshMixers");
                s_AutoRefreshMixersStop = false;
                s_AutoRefreshMixersThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopAutoRefreshMixers() {
        s_AutoRefreshMixersStop = true;
        Object object = s_SyncAutoRefreshMixers;
        synchronized (object) {
            s_SyncAutoRefreshMixers.notifyAll();
        }
        s_AutoRefreshMixersThread = null;
    }

    public static void setAutoRefreshMixers(boolean p_AutoRefresh) {
        if (p_AutoRefresh) {
            SoundMixers.startAutoRefreshMixers();
        } else {
            SoundMixers.stopAutoRefreshMixers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshSoundMixers() {
        Object object = s_SyncAutoRefreshMixers;
        synchronized (object) {
            s_SoundMixerTableModel.refresh_Start();
            if (OSChecker.getIsWindows() && Integer.valueOf(System.getProperty("sun.arch.data.model")) >= 64) {
                SoundMixers.refreshSoundMixers_WinDirectSound_Output();
            } else {
                SoundMixers.refreshSoundMixers_DirectSound_Output();
            }
            s_SoundMixerTableModel.refresh_End();
        }
    }

    public static void startProgram() {
        LiveLanguage.addLanguageListener(SoundMixers.class, null);
        if (OSChecker.getIsWindows() && Integer.valueOf(System.getProperty("sun.arch.data.model")) >= 64) {
            DirectSound.initDirectSound((int)((int)DEFAULT_AUDIOFORMAT.getSampleRate()), (int)DEFAULT_AUDIOFORMAT.getSampleSizeInBits());
            DirectSound.setDebugOn((boolean)false);
        }
        SoundMixers.readSoundLinesPreview();
        SoundMixers.refreshSoundMixers();
        s_SoundMixer_Setting.readSoundMixerSettings(null);
        SoundMixers.setAutoRefreshMixers(true);
    }

    public static void closeProgram() {
        SoundMixers.setAutoRefreshMixers(false);
        s_SoundMixer_Setting.writeSoundMixerSettings(null);
        s_SoundMixer_Controller.close();
        SoundMixers.closeAllSoundMixers();
        SoundMixers.saveSoundLinesPreview();
        if (OSChecker.getIsWindows()) {
            // empty if block
        }
    }

    public static void showNotificationSoundCardLost(boolean p_ShowNotification) {
        SHOW_NOTIFICATION_SOUNCARDLOST = p_ShowNotification;
    }

    public static AudioFormat getAudioFormat(File p_SoundFile) {
        AudioFormat o_AudioFormat;
        block4: {
            FFmpegFrameGrabber o_FFmpegFrameGrabber = null;
            o_AudioFormat = null;
            try {
                o_FFmpegFrameGrabber = new FFmpegFrameGrabber(p_SoundFile);
                o_FFmpegFrameGrabber.start();
                o_AudioFormat = SoundMixers.getAudioFormat(o_FFmpegFrameGrabber);
                o_FFmpegFrameGrabber.stop();
                o_FFmpegFrameGrabber.close();
            }
            catch (Exception e) {
                o_AudioFormat = null;
                if (o_FFmpegFrameGrabber == null) break block4;
                try {
                    o_FFmpegFrameGrabber.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return o_AudioFormat;
    }

    public static AudioFormat getAudioFormat(FFmpegFrameGrabber p_FFmpegFrameGrabber) {
        if (p_FFmpegFrameGrabber == null) {
            return null;
        }
        AudioFormat o_AudioFormat = null;
        try {
            boolean boolIsBigEndian;
            int intSampleSizeInBits;
            AudioFormat.Encoding o_Encoding;
            int intAudioCodec = p_FFmpegFrameGrabber.getAudioCodec();
            int intFrameRate = p_FFmpegFrameGrabber.getSampleRate();
            int intChannels = p_FFmpegFrameGrabber.getAudioChannels();
            switch (intAudioCodec) {
                case 65569: {
                    o_Encoding = AudioFormat.Encoding.PCM_FLOAT;
                    intSampleSizeInBits = 16;
                    boolIsBigEndian = false;
                    break;
                }
                case 65570: {
                    o_Encoding = AudioFormat.Encoding.PCM_FLOAT;
                    intSampleSizeInBits = 24;
                    boolIsBigEndian = false;
                    break;
                }
                case 65556: {
                    o_Encoding = AudioFormat.Encoding.PCM_FLOAT;
                    intSampleSizeInBits = 32;
                    boolIsBigEndian = true;
                    break;
                }
                case 65557: {
                    o_Encoding = AudioFormat.Encoding.PCM_FLOAT;
                    intSampleSizeInBits = 32;
                    boolIsBigEndian = false;
                    break;
                }
                case 65558: {
                    o_Encoding = AudioFormat.Encoding.PCM_FLOAT;
                    intSampleSizeInBits = 64;
                    boolIsBigEndian = true;
                    break;
                }
                case 65559: {
                    o_Encoding = AudioFormat.Encoding.PCM_FLOAT;
                    intSampleSizeInBits = 64;
                    boolIsBigEndian = false;
                    break;
                }
                case 65540: {
                    o_Encoding = AudioFormat.Encoding.PCM_SIGNED;
                    intSampleSizeInBits = 8;
                    boolIsBigEndian = true;
                    break;
                }
                case 65537: {
                    o_Encoding = AudioFormat.Encoding.PCM_SIGNED;
                    intSampleSizeInBits = 16;
                    boolIsBigEndian = true;
                    break;
                }
                case 65536: {
                    o_Encoding = AudioFormat.Encoding.PCM_SIGNED;
                    intSampleSizeInBits = 16;
                    boolIsBigEndian = false;
                    break;
                }
                case 65549: {
                    o_Encoding = AudioFormat.Encoding.PCM_SIGNED;
                    intSampleSizeInBits = 24;
                    boolIsBigEndian = true;
                    break;
                }
                case 65548: {
                    o_Encoding = AudioFormat.Encoding.PCM_SIGNED;
                    intSampleSizeInBits = 24;
                    boolIsBigEndian = false;
                    break;
                }
                case 65545: {
                    o_Encoding = AudioFormat.Encoding.PCM_SIGNED;
                    intSampleSizeInBits = 32;
                    boolIsBigEndian = true;
                    break;
                }
                case 65544: {
                    o_Encoding = AudioFormat.Encoding.PCM_SIGNED;
                    intSampleSizeInBits = 32;
                    boolIsBigEndian = false;
                    break;
                }
                case 65568: {
                    o_Encoding = AudioFormat.Encoding.PCM_SIGNED;
                    intSampleSizeInBits = 64;
                    boolIsBigEndian = true;
                    break;
                }
                case 65567: {
                    o_Encoding = AudioFormat.Encoding.PCM_SIGNED;
                    intSampleSizeInBits = 64;
                    boolIsBigEndian = false;
                    break;
                }
                case 65541: {
                    o_Encoding = AudioFormat.Encoding.PCM_UNSIGNED;
                    intSampleSizeInBits = 8;
                    boolIsBigEndian = true;
                    break;
                }
                case 65539: {
                    o_Encoding = AudioFormat.Encoding.PCM_UNSIGNED;
                    intSampleSizeInBits = 16;
                    boolIsBigEndian = true;
                    break;
                }
                case 65538: {
                    o_Encoding = AudioFormat.Encoding.PCM_UNSIGNED;
                    intSampleSizeInBits = 16;
                    boolIsBigEndian = false;
                    break;
                }
                case 65551: {
                    o_Encoding = AudioFormat.Encoding.PCM_UNSIGNED;
                    intSampleSizeInBits = 24;
                    boolIsBigEndian = true;
                    break;
                }
                case 65550: {
                    o_Encoding = AudioFormat.Encoding.PCM_UNSIGNED;
                    intSampleSizeInBits = 24;
                    boolIsBigEndian = false;
                    break;
                }
                case 65547: {
                    o_Encoding = AudioFormat.Encoding.PCM_UNSIGNED;
                    intSampleSizeInBits = 32;
                    boolIsBigEndian = true;
                    break;
                }
                case 65546: {
                    o_Encoding = AudioFormat.Encoding.PCM_UNSIGNED;
                    intSampleSizeInBits = 32;
                    boolIsBigEndian = false;
                    break;
                }
                default: {
                    o_Encoding = AudioFormat.Encoding.ALAW;
                    intSampleSizeInBits = 0;
                    boolIsBigEndian = true;
                }
            }
            int intFrameSize = intChannels * intSampleSizeInBits / 8;
            o_AudioFormat = new AudioFormat(o_Encoding, intFrameRate, intSampleSizeInBits, intChannels, intFrameSize, intFrameRate, boolIsBigEndian);
        }
        catch (Exception e) {
            o_AudioFormat = null;
        }
        return o_AudioFormat;
    }

    public static String getChannelName(int p_Channel) {
        String stringChannelName;
        if (p_Channel < 0) {
            return "";
        }
        switch (p_Channel) {
            case 0: {
                stringChannelName = "1 (L)";
                break;
            }
            case 1: {
                stringChannelName = "2 (R)";
                break;
            }
            case 2: {
                stringChannelName = "3 (C)";
                break;
            }
            case 3: {
                stringChannelName = "4 (SUB)";
                break;
            }
            case 4: {
                stringChannelName = "5 (R-L)";
                break;
            }
            case 5: {
                stringChannelName = "6 (R-R)";
                break;
            }
            case 6: {
                stringChannelName = "7 (A-L)";
                break;
            }
            case 7: {
                stringChannelName = "8 (A_R)";
                break;
            }
            default: {
                stringChannelName = String.valueOf(p_Channel + 1);
            }
        }
        return stringChannelName;
    }

    public static String getChannelToolTip(int p_Channel) {
        String stringChannelName;
        if (p_Channel < 0) {
            return "";
        }
        switch (p_Channel) {
            case 0: {
                stringChannelName = "1 Left";
                break;
            }
            case 1: {
                stringChannelName = "2 Right";
                break;
            }
            case 2: {
                stringChannelName = "3 Center";
                break;
            }
            case 3: {
                stringChannelName = "4 Subwoofer";
                break;
            }
            case 4: {
                stringChannelName = "5 Rear Left";
                break;
            }
            case 5: {
                stringChannelName = "6 Rear Right";
                break;
            }
            case 6: {
                stringChannelName = "7 Alternative Rear Left";
                break;
            }
            case 7: {
                stringChannelName = "8 Alternative Rear Right";
                break;
            }
            default: {
                stringChannelName = String.valueOf(p_Channel + 1);
            }
        }
        return stringChannelName;
    }

    public static void closeAllSoundMixers() {
        int intSoundMixerCount = s_SoundMixerTableModel.size();
        for (int intMixer = intSoundMixerCount - 1; intMixer >= 0; --intMixer) {
            SoundMixer o_SoundMixer = s_SoundMixerTableModel.getSoundMixer(intMixer);
            if (o_SoundMixer == null) continue;
            s_SoundBuffer_Mixers.removeSoundMixer(o_SoundMixer);
            o_SoundMixer.close();
        }
    }

    public static boolean checkSoundCardActivated() {
        for (int intMixer = 0; intMixer < s_SoundMixerTableModel.size(); ++intMixer) {
            SoundMixer o_SoundMixer = s_SoundMixerTableModel.getSoundMixer(intMixer);
            if (o_SoundMixer == null || !o_SoundMixer.getIsActive()) continue;
            return true;
        }
        return false;
    }

    public static void showNoActiveSoundMixers() {
        Thread o_NotifyThread = new Thread(new Runnable(){

            @Override
            public void run() {
                StringBuilder o_StringBuilder = new StringBuilder();
                o_StringBuilder.append("<html>");
                o_StringBuilder.append(SOUNDMIXERERROR_NOMIXERACTIVATED_REMARK);
                o_StringBuilder.append("</html>");
                JOptionDialog.showHintDialog(null, (Object)o_StringBuilder.toString(), (String)SOUNDMIXERERROR_TITEL, (int)2);
            }
        });
        o_NotifyThread.start();
    }

    public static void refreshSoundMixers_DirectSound_Output() {
        Mixer.Info[] o_MixerInfos = AudioSystem.getMixerInfo();
        for (int intMixer = 0; intMixer < o_MixerInfos.length; ++intMixer) {
            Mixer o_Mixer;
            Mixer.Info o_MixerInfo;
            if (intMixer == 0 || (o_MixerInfo = o_MixerInfos[intMixer]) == null || "PortMixerInfo".equals(o_MixerInfo.getClass().getSimpleName()) || (o_Mixer = AudioSystem.getMixer(o_MixerInfo)).getSourceLineInfo().length <= 0) continue;
            String stringID = SoundMixers.createSoundMixerID_DirectSound(o_MixerInfo);
            String stringIDFound = s_SoundMixerTableModel.findRefreshedMixerID(stringID);
            SoundMixer o_SoundMixer = s_SoundMixerTableModel.findMixer(stringIDFound);
            s_SoundMixerTableModel.refresh_Found(o_SoundMixer);
            if (o_SoundMixer != null) {
                int intChannels;
                s_SoundMixer_Setting.checkSoundMixer_Detected(o_SoundMixer);
                if (!(o_SoundMixer instanceof SoundMixer_DirectSound) || (intChannels = SoundMixers.recalculateMaxChannels((SoundMixer_DirectSound)o_SoundMixer, DEFAULT_AUDIOFORMAT)) == o_SoundMixer.getChannels()) continue;
                o_SoundMixer.close();
            }
            if ((o_SoundMixer = SoundMixers.createSoundMixer_DirectSound(stringIDFound, o_MixerInfo, DEFAULT_AUDIOFORMAT)) == null) continue;
            s_SoundMixer_Setting.checkSoundMixer_Detected(o_SoundMixer);
        }
    }

    public static void refreshSoundMixers_WinDirectSound_Output() {
        DirectSound.refreshDevices();
        int intDeviceCount = DirectSound.getDeviceCount();
        for (int intDevice = 0; intDevice < intDeviceCount; ++intDevice) {
            Device o_Device;
            if (intDevice == 0 || (o_Device = DirectSound.getDevice((int)intDevice)) == null) continue;
            String stringID = SoundMixers.createSoundMixerID_WinDirectSound(o_Device);
            String stringIDFound = s_SoundMixerTableModel.findRefreshedMixerID(stringID);
            SoundMixer o_SoundMixer = s_SoundMixerTableModel.findMixer(stringIDFound);
            s_SoundMixerTableModel.refresh_Found(o_SoundMixer);
            if (o_SoundMixer != null) {
                s_SoundMixer_Setting.checkSoundMixer_Detected(o_SoundMixer);
                if (o_Device.getChannels() == o_SoundMixer.getChannels()) continue;
                o_SoundMixer.close();
            }
            if (o_Device.getChannels() <= 0 || (o_SoundMixer = SoundMixers.createSoundMixer_WinDirectSound(stringIDFound, o_Device, DEFAULT_AUDIOFORMAT)) == null) continue;
            s_SoundMixer_Setting.checkSoundMixer_Detected(o_SoundMixer);
        }
    }

    public static SoundMixer getSoundMixer(String p_SoundMixerID) {
        return s_SoundMixerTableModel.getSoundMixer(p_SoundMixerID);
    }

    public static SoundMixer getSoundMixer(int p_Index) {
        return s_SoundMixerTableModel.getSoundMixer(p_Index);
    }

    public static void SoundMixer_Lost(final SoundMixer p_SoundMixer, final String p_Cause) {
        if (p_SoundMixer == null) {
            return;
        }
        s_SoundMixer_Setting.addSoundMixer_Active(p_SoundMixer);
        s_SoundBuffer_Mixers.removeSoundMixer(p_SoundMixer);
        Thread o_NotifyThread = new Thread(new Runnable(){

            @Override
            public void run() {
                String stringMixerName = "";
                stringMixerName = p_SoundMixer.getName();
                try {
                    p_SoundMixer.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!SHOW_NOTIFICATION_SOUNCARDLOST) {
                    return;
                }
                StringBuilder o_StringBuilder = new StringBuilder();
                o_StringBuilder.append("<html>");
                o_StringBuilder.append("<b>");
                o_StringBuilder.append(stringMixerName);
                o_StringBuilder.append("</b>");
                o_StringBuilder.append("<br>");
                o_StringBuilder.append(SOUNDMIXERERROR_MIXEREMOVED_REMARK);
                o_StringBuilder.append("<br>");
                o_StringBuilder.append("<br>");
                o_StringBuilder.append("<i>");
                o_StringBuilder.append(p_Cause);
                o_StringBuilder.append("</i>");
                o_StringBuilder.append("</html>");
                JOptionPane o_JOptionPane = new JOptionPane(o_StringBuilder.toString(), 2);
                JDialog o_JDialog = o_JOptionPane.createDialog(SOUNDMIXERERROR_TITEL);
                o_JDialog.setModal(false);
                o_JDialog.setAlwaysOnTop(true);
                o_JDialog.setVisible(true);
            }
        });
        o_NotifyThread.start();
    }

    public static SoundBuffer_Player createSoundBuffer_Player(int p_FramesBuffered) {
        SoundBuffer_Player o_SoundBuffer_Player = new SoundBuffer_Player(p_FramesBuffered);
        return o_SoundBuffer_Player;
    }

    public static void setMainVolume(double p_MainLoudness) {
        if (p_MainLoudness < 0.0) {
            p_MainLoudness = 0.0;
        }
        s_MainLoudness = p_MainLoudness;
        s_MainVolumeFactor_Sound = BioMathematics.calculateVolumeFactor_Logarithm(s_MainLoudness);
    }

    public static double getMainVolume() {
        return s_MainLoudness;
    }

    public static double getMainVolume_Factor() {
        return s_MainVolumeFactor_Sound;
    }

    public static String createSoundMixerID_DirectSound(Mixer.Info p_MixerInfo) {
        if (p_MixerInfo == null) {
            return "";
        }
        try {
            StringBuilder o_StringBuilder = new StringBuilder();
            o_StringBuilder.append("DireectSound_");
            o_StringBuilder.append(p_MixerInfo.getName());
            o_StringBuilder.append("_");
            o_StringBuilder.append(p_MixerInfo.getVendor());
            o_StringBuilder.append("_");
            o_StringBuilder.append(p_MixerInfo.getVersion());
            o_StringBuilder.append("_");
            o_StringBuilder.append(p_MixerInfo.getDescription());
            return o_StringBuilder.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static int recalculateMaxChannels(SoundMixer_DirectSound p_SoundMixer_DirectSound, AudioFormat p_AudioFormat) {
        if (p_SoundMixer_DirectSound == null) {
            return 0;
        }
        Mixer o_Mixer = null;
        boolean boolMixerWasOpen = true;
        AudioFormat o_FoundAudioFormat = null;
        DataLine.Info o_FoundDataLineInfo = null;
        try {
            Line.Info[] o_SourceLineInfos;
            o_Mixer = p_SoundMixer_DirectSound.getMixer();
            if (o_Mixer == null) {
                return 0;
            }
            if (!o_Mixer.isOpen()) {
                o_Mixer.open();
                boolMixerWasOpen = false;
            }
            if ((o_SourceLineInfos = o_Mixer.getSourceLineInfo()) == null) {
                return 0;
            }
            for (int intLineInfo = 0; intLineInfo < o_SourceLineInfos.length; ++intLineInfo) {
                DataLine.Info o_DataLineInfo;
                AudioFormat[] o_AudioFormats;
                Line.Info o_SourceLineInfo = o_SourceLineInfos[intLineInfo];
                if (o_SourceLineInfo == null || !(o_SourceLineInfo instanceof DataLine.Info) || !"SourceDataLine".equals(o_SourceLineInfo.getLineClass().getSimpleName()) || (o_AudioFormats = (o_DataLineInfo = (DataLine.Info)o_SourceLineInfo).getFormats()) == null) continue;
                int intChannels = 0;
                for (int intFormat = 0; intFormat < o_AudioFormats.length; ++intFormat) {
                    AudioFormat o_AudioFormat = o_AudioFormats[intFormat];
                    if (!o_AudioFormat.getEncoding().equals(p_AudioFormat.getEncoding()) || o_AudioFormat.getFrameRate() > 0.0f && o_AudioFormat.getFrameRate() != p_AudioFormat.getFrameRate() || o_AudioFormat.getSampleSizeInBits() < 16 || o_AudioFormat.getChannels() <= intChannels) continue;
                    intChannels = o_AudioFormat.getChannels();
                    o_FoundDataLineInfo = o_DataLineInfo;
                    o_FoundAudioFormat = o_AudioFormat;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (o_FoundDataLineInfo == null || o_FoundAudioFormat == null) {
            if (o_Mixer != null && !boolMixerWasOpen) {
                try {
                    o_Mixer.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return 0;
        }
        return o_FoundAudioFormat.getChannels();
    }

    public static SoundMixer_DirectSound createSoundMixer_DirectSound(String p_ID, Mixer.Info p_MixerInfo, AudioFormat p_AudioFormat) {
        AudioFormat o_AudioFormat;
        if (p_AudioFormat == null) {
            return null;
        }
        if (p_MixerInfo == null) {
            return null;
        }
        String stringID = "";
        Line o_Mixer = null;
        int intChannels = 0;
        DataLine.Info o_FoundDataLineInfo = null;
        AudioFormat o_FoundAudioFormat = null;
        SoundMixer_DirectSound o_SoundMixer_DirectSound = null;
        try {
            Line.Info[] o_SourceLineInfos;
            stringID = p_ID;
            o_SoundMixer_DirectSound = (SoundMixer_DirectSound)s_SoundMixerTableModel.findMixer(stringID);
            o_Mixer = AudioSystem.getMixer(p_MixerInfo);
            if (o_Mixer == null) {
                return null;
            }
            if (!o_Mixer.isOpen()) {
                o_Mixer.open();
            }
            if ((o_SourceLineInfos = o_Mixer.getSourceLineInfo()) == null) {
                return null;
            }
            for (int intLineInfo = 0; intLineInfo < o_SourceLineInfos.length; ++intLineInfo) {
                DataLine.Info o_DataLineInfo;
                AudioFormat[] o_AudioFormats;
                Line.Info o_SourceLineInfo = o_SourceLineInfos[intLineInfo];
                if (o_SourceLineInfo == null || !(o_SourceLineInfo instanceof DataLine.Info) || !"SourceDataLine".equals(o_SourceLineInfo.getLineClass().getSimpleName()) || (o_AudioFormats = (o_DataLineInfo = (DataLine.Info)o_SourceLineInfo).getFormats()) == null) continue;
                intChannels = 0;
                for (int intFormat = 0; intFormat < o_AudioFormats.length; ++intFormat) {
                    o_AudioFormat = o_AudioFormats[intFormat];
                    if (!o_AudioFormat.getEncoding().equals(p_AudioFormat.getEncoding()) || o_AudioFormat.getFrameRate() > 0.0f && o_AudioFormat.getFrameRate() != p_AudioFormat.getFrameRate() || o_AudioFormat.getSampleSizeInBits() < 16 || o_AudioFormat.getChannels() <= 0 || o_AudioFormat.getChannels() <= intChannels) continue;
                    intChannels = o_AudioFormat.getChannels();
                    o_FoundDataLineInfo = o_DataLineInfo;
                    o_FoundAudioFormat = o_AudioFormat;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (o_FoundDataLineInfo == null || o_FoundAudioFormat == null) {
            if (o_Mixer != null) {
                try {
                    o_Mixer.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
        if (o_SoundMixer_DirectSound == null) {
            o_AudioFormat = new AudioFormat(o_FoundAudioFormat.getEncoding(), p_AudioFormat.getSampleRate(), o_FoundAudioFormat.getSampleSizeInBits(), o_FoundAudioFormat.getChannels(), o_FoundAudioFormat.getFrameSize(), p_AudioFormat.getFrameRate(), o_FoundAudioFormat.isBigEndian());
            o_SoundMixer_DirectSound = new SoundMixer_DirectSound((Mixer)o_Mixer, stringID, o_AudioFormat, o_FoundDataLineInfo);
        }
        o_SoundMixer_DirectSound.setChannels_Output(o_FoundAudioFormat.getChannels());
        return o_SoundMixer_DirectSound;
    }

    public static String createSoundMixerID_WinDirectSound(Device p_Device) {
        if (p_Device == null) {
            return "";
        }
        try {
            StringBuilder o_StringBuilder = new StringBuilder();
            o_StringBuilder.append("DireectSound_");
            o_StringBuilder.append(p_Device.getName());
            return o_StringBuilder.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static SoundMixer_WinDirectSound createSoundMixer_WinDirectSound(String p_ID, Device p_Device, AudioFormat p_AudioFormat) {
        if (p_AudioFormat == null) {
            return null;
        }
        if (p_Device == null) {
            return null;
        }
        String stringID = "";
        Device o_Device = null;
        AudioFormat o_FoundAudioFormat = null;
        SoundMixer_WinDirectSound o_SoundMixer_WinDirectSound = null;
        stringID = p_ID;
        o_Device = p_Device;
        o_SoundMixer_WinDirectSound = (SoundMixer_WinDirectSound)s_SoundMixerTableModel.findMixer(stringID);
        if (o_SoundMixer_WinDirectSound == null) {
            o_FoundAudioFormat = o_Device.getAudioFormat();
            if (o_FoundAudioFormat == null) {
                return null;
            }
            if (o_FoundAudioFormat.getChannels() <= 0) {
                return null;
            }
            AudioFormat o_AudioFormat = new AudioFormat(o_FoundAudioFormat.getEncoding(), p_AudioFormat.getSampleRate(), o_FoundAudioFormat.getSampleSizeInBits(), o_FoundAudioFormat.getChannels(), o_FoundAudioFormat.getFrameSize(), p_AudioFormat.getFrameRate(), o_FoundAudioFormat.isBigEndian());
            o_SoundMixer_WinDirectSound = new SoundMixer_WinDirectSound(o_Device, stringID, o_AudioFormat);
        }
        o_SoundMixer_WinDirectSound.setChannels_Output(o_FoundAudioFormat.getChannels());
        return o_SoundMixer_WinDirectSound;
    }

    public static void createSoundLinesPreview() {
        s_Sound_Lines_Preview = new Sound_Lines();
        s_Sound_Lines_Preview.setParentChannelCount(SOUND_SOUNDLINES_COUNT);
        for (int intLine = 0; intLine < SOUND_SOUNDLINES_COUNT; ++intLine) {
            s_Sound_Lines_Preview.addSoundLineFactor(intLine, intLine, 1.0, false);
        }
        s_Sound_Lines_Preview.setParentType("SoundObject");
        s_JDialog_Sound_Lines_Preview = new JDialog_Sound_Lines(null, false);
        s_JDialog_Sound_Lines_Preview.setSound_Lines(s_Sound_Lines_Preview);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveSoundLinesPreview() {
        int intSoftwareVersion = 1;
        FileOutputStream o_FileOutputStream = null;
        ObjectOutputStream out = null;
        File o_Directory = OSChecker.getUserHomeConfigDirectory();
        String stringFilePathName = o_Directory.getAbsolutePath() + "/" + SOUNDLINESPREVIEW_FILEDEFAULTNAME + SOUNDLINESPREVIEW_FILEEXTENSION;
        File o_File = new File(stringFilePathName);
        if (o_File.exists()) {
            o_File.delete();
        }
        try {
            o_FileOutputStream = new FileOutputStream(o_File);
            out = new ObjectOutputStream(o_FileOutputStream);
            out.writeInt(intSoftwareVersion);
            s_Sound_Lines_Preview.writeExternal(out);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (o_FileOutputStream != null) {
                    o_FileOutputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readSoundLinesPreview() {
        FileInputStream o_FileInputStream = null;
        ObjectInputStream in = null;
        File o_Directory = OSChecker.getUserHomeConfigDirectory();
        String stringFilePathName = o_Directory.getAbsolutePath() + "/" + SOUNDLINESPREVIEW_FILEDEFAULTNAME + SOUNDLINESPREVIEW_FILEEXTENSION;
        File o_File = new File(stringFilePathName);
        try {
            o_FileInputStream = new FileInputStream(o_File);
            in = new ObjectInputStream(o_FileInputStream);
            int intSoftwareVersion = in.readInt();
            s_Sound_Lines_Preview.readExternal(in);
            s_JDialog_Sound_Lines_Preview.setSound_Lines(s_Sound_Lines_Preview);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (o_FileInputStream != null) {
                    o_FileInputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void saveSoundMixerSettings() {
        s_SoundMixer_Setting.saveSoundMixerSettings();
    }

    public static void loadSoundMixerSettings() {
        s_SoundMixer_Setting.loadSoundMixerSettings();
    }

    public static SoundMixerTableModel getSoundMixerTableModel() {
        return s_SoundMixerTableModel;
    }

    static {
        s_AutoRefreshMixersRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!s_AutoRefreshMixersStop) {
                    try {
                        Object object = s_SyncAutoRefreshMixers;
                        synchronized (object) {
                            long longWaitStart;
                            for (long longWaitTime = 20000L; longWaitTime > 0L && !s_AutoRefreshMixersStop; longWaitTime -= System.nanoTime() / 1000000L - longWaitStart) {
                                longWaitStart = System.nanoTime() / 1000000L;
                                s_SyncAutoRefreshMixers.wait(longWaitTime);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                    if (s_AutoRefreshMixersStop) continue;
                    SoundMixers.refreshSoundMixers();
                }
            }
        };
        s_SoundBuffer_Mixers = new SoundBuffer_Mixers();
        s_MainVolumeFactor_Sound = 1.0;
        s_MainLoudness = 1.0;
        SOUNDMIXER_FILE_FILTERNAME = "SoundMixer Settings";
        s_SoundMixer_Setting = new SoundMixer_Setting();
        s_SoundMixerTableModel = new SoundMixerTableModel(DEFAULT_AUDIOFORMAT);
        s_SoundMixer_Controller = new SoundMixer_Controller();
        s_IconSoundLines = new ImageIcon(SoundMixer.class.getResource("/IconsPackage/Menu_SoundcardSettings.png"));
    }

    public static class SoundMixerTableModel
    extends TableAndListModel<SoundMixer>
    implements TableAndListModel.TableBehaviorListener,
    PropertyChangeListener {
        public static final int COLUMNCOUNT = 5;
        public static final int COLUMNINDEX_MIXERACTIVATED = 0;
        public static final int COLUMNINDEX_MIXERTYPE = 1;
        public static final int COLUMNINDEX_MIXERNAME = 2;
        public static final int COLUMNINDEX_MIXERCHANNELS = 3;
        public static final int COLUMNINDEX_MIXERSOUNDLINES = 4;
        public static JDialog_Sound_Lines s_JDialog_Sound_Lines = null;
        @LiveLanguageString
        public static String COLUMN_MIXERSELECTED = "";
        @LiveLanguageString
        public static String COLUMN_MIXERTYPE = "Type";
        @LiveLanguageString
        public static String COLUMN_MIXERNAME = "Name";
        @LiveLanguageString
        public static String COLUMN_MIXERCHANNELS = "channels";
        @LiveLanguageString
        public static String COLUMN_MIXERDESCRIPTION = "Description";
        @LiveLanguageString
        public static String COLUMN_MIXERSOUNDLINES = "";
        @LiveLanguageString
        public static String TOOLTIP_SELECTMIXER_ASIO = "With Asio drivers only one can be activated!";
        @LiveLanguageString
        public static String TOOLTIP_SOUNDCARDSELECTION = "Activate / Deactivate Soundcard";
        @LiveLanguageString
        public static String TOOLTIP_SOUNDLINES = "Assign sound lines to the channels of the sound card";
        public static boolean s_LanguageLoaded = false;
        private ArrayList<SoundMixer> m_SoundMixersOld;
        private TableRowSorter m_TableRowSorter;
        private AudioFormat m_AudioFormat;
        private DataLine.Info m_SourceDataInfo;
        private final Object m_SyncMixers = new Object();
        private SoundMixerTableModel s_SelReference = this;

        public SoundMixerTableModel(AudioFormat p_AudioFormat) {
            super(false);
            this.initMembers();
            this.m_AudioFormat = p_AudioFormat;
            LiveLanguage.addLanguageListener(this, null);
        }

        private void initMembers() {
            this.m_SoundMixersOld = new ArrayList();
        }

        public void finishJTable(JTable p_JTable) {
            TableAndListModel.TableCellEditorRenderer_String o_TableCellEditorRenderer_String;
            if (p_JTable == null) {
                return;
            }
            this.m_TableRowSorter = new TableRowSorter<SoundMixerTableModel>(this);
            this.m_TableRowSorter.setComparator(2, (Comparator<?>)TableAndListModel.getStringComparator_Normal());
            this.m_TableRowSorter.setComparator(3, (Comparator<?>)TableAndListModel.getStringComparator_Integer());
            super.finishJTable(p_JTable, this.m_TableRowSorter, null);
            p_JTable.setRowHeight(25);
            TableColumn o_TableColumn = p_JTable.getColumnModel().getColumn(0);
            if (o_TableColumn != null) {
                o_TableColumn.setMaxWidth(26);
                o_TableColumn.setMinWidth(26);
                o_TableColumn.setPreferredWidth(26);
                o_TableColumn.setResizable(false);
                TableAndListModel.TableCellEditorRenderer_CheckBox o_TableCellEditorRenderer_CheckBox = new TableAndListModel.TableCellEditorRenderer_CheckBox();
                o_TableCellEditorRenderer_CheckBox.setToolTipText(TOOLTIP_SOUNDCARDSELECTION);
                o_TableCellEditorRenderer_CheckBox.setToolTipTextAt(false, true);
                o_TableColumn.setCellEditor((TableCellEditor)o_TableCellEditorRenderer_CheckBox);
                o_TableColumn.setCellRenderer((TableCellRenderer)o_TableCellEditorRenderer_CheckBox);
            }
            if ((o_TableColumn = p_JTable.getColumnModel().getColumn(1)) != null) {
                o_TableColumn.setMinWidth(150);
                o_TableColumn.setPreferredWidth(150);
                o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
                o_TableCellEditorRenderer_String.setToolTipText_Automatic(1);
                o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
                o_TableColumn.setCellEditor((TableCellEditor)o_TableCellEditorRenderer_String);
                o_TableColumn.setCellRenderer((TableCellRenderer)o_TableCellEditorRenderer_String);
            }
            if ((o_TableColumn = p_JTable.getColumnModel().getColumn(2)) != null) {
                o_TableColumn.setMinWidth(150);
                o_TableColumn.setPreferredWidth(150);
                o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
                o_TableCellEditorRenderer_String.setToolTipText_Automatic(1);
                o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
                o_TableColumn.setCellEditor((TableCellEditor)o_TableCellEditorRenderer_String);
                o_TableColumn.setCellRenderer((TableCellRenderer)o_TableCellEditorRenderer_String);
            }
            if ((o_TableColumn = p_JTable.getColumnModel().getColumn(3)) != null) {
                o_TableColumn.setMaxWidth(75);
                o_TableColumn.setMinWidth(75);
                o_TableColumn.setPreferredWidth(75);
                o_TableColumn.setResizable(false);
                TableAndListModel.TableCellEditorRenderer_Integer o_TableCellEditorRenderer_Integer = new TableAndListModel.TableCellEditorRenderer_Integer();
                o_TableCellEditorRenderer_Integer.setAllowNegativeNumbers(false);
                o_TableCellEditorRenderer_Integer.setToolTipText(COLUMN_MIXERCHANNELS);
                o_TableCellEditorRenderer_Integer.setToolTipTextAt(false, true);
                o_TableColumn.setCellEditor((TableCellEditor)o_TableCellEditorRenderer_Integer);
                o_TableColumn.setCellRenderer((TableCellRenderer)o_TableCellEditorRenderer_Integer);
            }
            if ((o_TableColumn = p_JTable.getColumnModel().getColumn(4)) != null) {
                o_TableColumn.setMaxWidth(34);
                o_TableColumn.setMinWidth(34);
                o_TableColumn.setPreferredWidth(34);
                o_TableColumn.setResizable(false);
                o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
                o_TableCellEditorRenderer_String.setIcon((Icon)s_IconSoundLines);
                o_TableCellEditorRenderer_String.setToolTipText(TOOLTIP_SOUNDLINES);
                o_TableCellEditorRenderer_String.setToolTipTextAt(true, true);
                o_TableColumn.setCellEditor((TableCellEditor)o_TableCellEditorRenderer_String);
                o_TableColumn.setCellRenderer((TableCellRenderer)o_TableCellEditorRenderer_String);
            }
            TableAndListModel.TableBehavior o_TableBehavior = new TableAndListModel.TableBehavior(p_JTable, (TableAndListModel.TableBehaviorListener)this);
            o_TableBehavior.addMouseExcludedColumn(4, false);
            p_JTable.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        }

        public void excludedMouseEvent(MouseEvent p_MouseEvent, JTable p_JTable, int p_RowModel, int p_ColumnModel, Object p_Value) {
            if (p_MouseEvent.getID() == 502 && p_MouseEvent.getButton() == 1) {
                SoundMixer o_SoundMixer = this.getSoundMixer(p_RowModel);
                if (o_SoundMixer == null) {
                    return;
                }
                if (s_JDialog_Sound_Lines == null) {
                    s_JDialog_Sound_Lines = new JDialog_Sound_Lines(null, false);
                }
                s_JDialog_Sound_Lines.setSound_Lines_Parent(o_SoundMixer);
                s_JDialog_Sound_Lines.setVisible(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSoundMixer(SoundMixer p_SoundMixer) {
            if (p_SoundMixer == null) {
                return;
            }
            Object object = this.m_SyncMixers;
            synchronized (object) {
                if (this.add(p_SoundMixer)) {
                    p_SoundMixer.addPropertyChangeListener(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSoundMixer(SoundMixer p_SoundMixer) {
            if (p_SoundMixer == null) {
                return;
            }
            Object object = this.m_SyncMixers;
            synchronized (object) {
                if (this.remove(p_SoundMixer)) {
                    p_SoundMixer.removePropertyChangeListener(this);
                }
            }
        }

        public void changedSoundMixer(SoundMixer p_SoundMixer) {
            if (p_SoundMixer == null) {
                return;
            }
            this.changedElement(p_SoundMixer);
        }

        public boolean containsSoundMixer(SoundMixer p_SoundMixer) {
            if (p_SoundMixer == null) {
                return false;
            }
            return super.contains((Object)p_SoundMixer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SoundMixer findMixer(String p_SoundMixerID) {
            if (p_SoundMixerID == null) {
                return null;
            }
            Object object = this.m_SyncMixers;
            synchronized (object) {
                for (int intMixer = 0; intMixer < this.size(); ++intMixer) {
                    SoundMixer o_SoundMixer = (SoundMixer)this.get(intMixer);
                    if (o_SoundMixer == null || !p_SoundMixerID.equals(o_SoundMixer.getID())) continue;
                    return o_SoundMixer;
                }
            }
            return null;
        }

        public void clear() {
            int intRowCount = this.size();
            for (int intRow = intRowCount - 1; intRow >= 0; --intRow) {
                SoundMixer o_SoundMixer = this.getSoundMixer(intRow);
                if (o_SoundMixer == null) continue;
                this.removeSoundMixer(o_SoundMixer);
            }
            super.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refresh_Start() {
            Object object = this.m_SyncMixers;
            synchronized (object) {
                this.m_SoundMixersOld.clear();
                this.m_SoundMixersOld.addAll(super.getElementArrayList());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String findRefreshedMixerID(String p_SoundMixerID) {
            if (p_SoundMixerID == null) {
                return null;
            }
            Object object = this.m_SyncMixers;
            synchronized (object) {
                for (int intMixer = 0; intMixer < this.size(); ++intMixer) {
                    SoundMixer o_SoundMixer = (SoundMixer)this.get(intMixer);
                    if (o_SoundMixer == null || !p_SoundMixerID.equals(o_SoundMixer.getID())) continue;
                    if (this.m_SoundMixersOld.contains(o_SoundMixer)) {
                        this.refresh_Found(o_SoundMixer);
                        return p_SoundMixerID;
                    }
                    p_SoundMixerID = p_SoundMixerID + "(2)";
                    break;
                }
            }
            return p_SoundMixerID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refresh_Found(SoundMixer p_SoundMixer) {
            if (p_SoundMixer == null) {
                return;
            }
            Object object = this.m_SyncMixers;
            synchronized (object) {
                this.m_SoundMixersOld.remove(p_SoundMixer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refresh_End() {
            ArrayList<SoundMixer> o_SoundMixers_Old;
            Object object = this.m_SyncMixers;
            synchronized (object) {
                if (this.m_SoundMixersOld.size() <= 0) {
                    return;
                }
                o_SoundMixers_Old = new ArrayList<SoundMixer>(this.m_SoundMixersOld.size());
                o_SoundMixers_Old.addAll(this.m_SoundMixersOld);
            }
            for (int intMixer = o_SoundMixers_Old.size() - 1; intMixer >= 0; --intMixer) {
                SoundMixer o_SoundMixer = (SoundMixer)o_SoundMixers_Old.get(intMixer);
                if (o_SoundMixer == null) continue;
                o_SoundMixer.close();
            }
        }

        public void addSelectedSoundMixer(JTable p_JTable, SoundMixer p_SoundMixer) {
            if (p_JTable == null) {
                return;
            }
            if (p_SoundMixer == null) {
                return;
            }
            this.addSelectedElement(p_JTable, p_SoundMixer);
        }

        public void removeSelectedSoundMixer(JTable p_JTable, SoundMixer p_SoundMixer) {
            if (p_JTable == null) {
                return;
            }
            if (p_SoundMixer == null) {
                return;
            }
            this.removeSelectedElement(p_JTable, p_SoundMixer);
        }

        public SoundMixer getSoundMixer(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            return (SoundMixer)this.get(p_Index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SoundMixer getSoundMixer(String p_SoundMixerID) {
            if (p_SoundMixerID == null) {
                return null;
            }
            Object object = this.m_SyncMixers;
            synchronized (object) {
                for (int intMixer = 0; intMixer < this.size(); ++intMixer) {
                    SoundMixer o_SoundMixer = (SoundMixer)this.get(intMixer);
                    if (o_SoundMixer == null || !p_SoundMixerID.equals(o_SoundMixer.getID())) continue;
                    return o_SoundMixer;
                }
            }
            return null;
        }

        public int getColumnCount() {
            return 5;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return COLUMN_MIXERSELECTED;
                }
                case 1: {
                    return COLUMN_MIXERTYPE;
                }
                case 2: {
                    return COLUMN_MIXERNAME;
                }
                case 3: {
                    return COLUMN_MIXERCHANNELS;
                }
                case 4: {
                    return COLUMN_MIXERSOUNDLINES;
                }
            }
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getValue(SoundMixer p_SoundMixer, int columnIndex) {
            String stringValue = "";
            Object object = this.m_SyncMixers;
            synchronized (object) {
                if (p_SoundMixer == null) {
                    return stringValue;
                }
            }
            switch (columnIndex) {
                case 0: {
                    stringValue = String.valueOf(p_SoundMixer.getIsActive());
                    break;
                }
                case 1: {
                    stringValue = p_SoundMixer.getSoundMixerType();
                    break;
                }
                case 2: {
                    stringValue = p_SoundMixer.getName();
                    break;
                }
                case 3: {
                    if (p_SoundMixer.getChannels() <= 0) {
                        stringValue = "?";
                        break;
                    }
                    stringValue = String.valueOf(p_SoundMixer.getChannels());
                    break;
                }
                case 4: {
                    stringValue = "";
                }
            }
            return stringValue;
        }

        public boolean isCellEditable(int row, int col) {
            switch (col) {
                case 0: {
                    return true;
                }
                case 1: {
                    return false;
                }
                case 2: {
                    return false;
                }
                case 3: {
                    return false;
                }
                case 4: {
                    return false;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(SoundMixer p_SoundMixer, Object value, int col) {
            if (p_SoundMixer == null) {
                return;
            }
            Object object = this.m_SyncMixers;
            synchronized (object) {
                switch (col) {
                    case 0: {
                        p_SoundMixer.setActive((Boolean)value, true);
                    }
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof SoundMixer) {
                SoundMixer o_SoundMixer = (SoundMixer)evt.getSource();
                if ("propActive".equals(evt.getPropertyName())) {
                    this.changedElement(o_SoundMixer);
                }
            }
        }
    }

    public static class SoundMixer_Setting {
        private HashMap<String, Sound_Lines> m_SoundMixers_Active;
        private final Object m_SyncObject = new Object();

        public SoundMixer_Setting() {
            this.initMembers();
        }

        private void initMembers() {
            this.m_SoundMixers_Active = new HashMap();
        }

        public void close() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSoundMixer_Active(SoundMixer p_SoundMixer) {
            if (p_SoundMixer == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                Sound_Lines o_Sound_Lines = this.m_SoundMixers_Active.get(p_SoundMixer.getID());
                if (o_Sound_Lines != null) {
                    return;
                }
                o_Sound_Lines = p_SoundMixer.getSound_Lines();
                this.m_SoundMixers_Active.put(p_SoundMixer.getID(), o_Sound_Lines);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSoundMixer_Active(SoundMixer p_SoundMixer) {
            if (p_SoundMixer == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                this.m_SoundMixers_Active.remove(p_SoundMixer.getID());
            }
        }

        public boolean checkSoundMixer_Detected(SoundMixer p_SoundMixer) {
            if (p_SoundMixer == null) {
                return false;
            }
            String StringID = p_SoundMixer.getID();
            Sound_Lines o_Sound_Lines = this.m_SoundMixers_Active.get(StringID);
            if (o_Sound_Lines == null) {
                return false;
            }
            if (!o_Sound_Lines.equals(p_SoundMixer.getSound_Lines())) {
                o_Sound_Lines.copyTo(p_SoundMixer.getSound_Lines());
                this.m_SoundMixers_Active.put(StringID, p_SoundMixer.getSound_Lines());
            }
            p_SoundMixer.setActive(true, true);
            return true;
        }

        public void saveSoundMixerSettings() {
            File o_Directory = OSChecker.getUserHomeConfigDirectory();
            FileNameExtensionFilter o_FileNameExtensionFilter = FileSelection.createFileNameExtensionFilter(SOUNDMIXER_FILE_FILTERNAME + " (" + SoundMixers.SOUNDLINESPREVIEW_FILEEXTENSION + ")", SoundMixers.SOUNDMIXER_FILEEXTENSION);
            File o_FileSelected = FileSelection.showSave(null, SOUNDMIXER_SAVESETTINGS_TITEL, o_Directory, o_FileNameExtensionFilter, true, false);
            if (o_FileSelected == null) {
                return;
            }
            if (!FileTools.checkWritable(o_FileSelected)) {
                return;
            }
            this.writeSoundMixerSettings(o_FileSelected);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeSoundMixerSettings(File p_File) {
            String stringFilePathName;
            File o_Directory;
            int intSoftwareVersion = 2;
            FileOutputStream o_FileOutputStream = null;
            ObjectOutputStream out = null;
            ArrayList<String> o_Sound_ID_List = new ArrayList<String>();
            ArrayList<Sound_Lines> o_Sound_Lines_List = new ArrayList<Sound_Lines>();
            if (p_File == null) {
                o_Directory = OSChecker.getUserHomeConfigDirectory();
                stringFilePathName = o_Directory.getAbsolutePath() + "/" + SoundMixers.SOUNDMIXER_FILEDEFAULTNAME + SoundMixers.SOUNDMIXER_FILEEXTENSION;
            } else {
                o_Directory = p_File.getParentFile();
                stringFilePathName = o_Directory.getAbsolutePath() + "/" + FileTools.getFileNameBase(p_File) + SoundMixers.SOUNDMIXER_FILEEXTENSION;
            }
            File o_File = new File(stringFilePathName);
            if (o_File.exists()) {
                o_File.delete();
            }
            try {
                o_FileOutputStream = new FileOutputStream(o_File);
                out = new ObjectOutputStream(o_FileOutputStream);
                Object object = this.m_SyncObject;
                synchronized (object) {
                    for (String stringSoundMixerID : this.m_SoundMixers_Active.keySet()) {
                        SoundMixer o_SoundMixer;
                        Sound_Lines o_Sound_Lines;
                        if (stringSoundMixerID == null || (o_Sound_Lines = this.m_SoundMixers_Active.get(stringSoundMixerID)) == null || (o_SoundMixer = s_SoundMixerTableModel.getSoundMixer(stringSoundMixerID)) == null || !o_SoundMixer.getIsActive()) continue;
                        o_Sound_ID_List.add(stringSoundMixerID);
                        o_Sound_Lines_List.add(o_Sound_Lines);
                    }
                }
                out.writeInt(intSoftwareVersion);
                out.writeInt(o_Sound_Lines_List.size());
                for (int intMixer = 0; intMixer < o_Sound_Lines_List.size(); ++intMixer) {
                    out.writeUTF((String)o_Sound_ID_List.get(intMixer));
                    ((Sound_Lines)o_Sound_Lines_List.get(intMixer)).writeExternal(out);
                }
            }
            catch (Exception e) {
                System.err.println("SoundMixers SoundMixer_Setting writeSoundMixerSettings File: " + o_File.getAbsolutePath());
                System.err.println("         error: " + e.getMessage());
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                    if (o_FileOutputStream != null) {
                        o_FileOutputStream.close();
                    }
                }
                catch (Exception exception) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void loadSoundMixerSettings() {
            File o_Directory = OSChecker.getUserHomeConfigDirectory();
            FileNameExtensionFilter o_FileNameExtensionFilter = FileSelection.createFileNameExtensionFilter(SOUNDMIXER_FILE_FILTERNAME + " (" + SoundMixers.SOUNDLINESPREVIEW_FILEEXTENSION + ")", SoundMixers.SOUNDMIXER_FILEEXTENSION);
            File o_FileSelected = FileSelection.showOpen(null, SOUNDMIXER_LOADSETTINGS_TITEL, o_Directory, o_FileNameExtensionFilter, true, false);
            if (o_FileSelected == null) {
                return;
            }
            Object object = s_SyncAutoRefreshMixers;
            synchronized (object) {
                this.readSoundMixerSettings(o_FileSelected);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void readSoundMixerSettings(File p_File) {
            SoundMixer o_SoundMixer;
            boolean boolOneMixerReaden = false;
            FileInputStream o_FileInputStream = null;
            ObjectInputStream in = null;
            ArrayList<SoundMixer> o_SoundMixers_Deactived = new ArrayList<SoundMixer>();
            for (int intMixer = 0; intMixer < s_SoundMixerTableModel.size(); ++intMixer) {
                o_SoundMixer = s_SoundMixerTableModel.getSoundMixer(intMixer);
                if (!o_SoundMixer.getIsActive()) continue;
                o_SoundMixers_Deactived.add(o_SoundMixer);
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                String stringFilePathName;
                File o_Directory;
                this.m_SoundMixers_Active.clear();
                if (p_File == null) {
                    o_Directory = OSChecker.getUserHomeConfigDirectory();
                    stringFilePathName = o_Directory.getAbsolutePath() + "/" + SoundMixers.SOUNDMIXER_FILEDEFAULTNAME + SoundMixers.SOUNDMIXER_FILEEXTENSION;
                } else {
                    o_Directory = p_File.getParentFile();
                    stringFilePathName = o_Directory.getAbsolutePath() + "/" + FileTools.getFileNameBase(p_File) + SoundMixers.SOUNDMIXER_FILEEXTENSION;
                }
                File o_File = new File(stringFilePathName);
                if (!o_File.exists()) {
                    return;
                }
                try {
                    try {
                        o_FileInputStream = new FileInputStream(o_File);
                        in = new ObjectInputStream(o_FileInputStream);
                        int intSoftwareVersion = in.readInt();
                        if (intSoftwareVersion <= 1 && OSChecker.getIsWindows()) {
                            o_SoundMixers_Deactived.clear();
                            try {
                                in.close();
                                o_FileInputStream.close();
                                o_File.delete();
                            }
                            catch (Exception e) {
                                try {
                                    if (in != null) {
                                        in.close();
                                    }
                                    if (o_FileInputStream == null) return;
                                    o_FileInputStream.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                return;
                            }
                            return;
                        }
                        int intSoundMixerCount = in.readInt();
                        Object e = this.m_SyncObject;
                        synchronized (e) {
                            for (int intMixer = 0; intMixer < intSoundMixerCount; ++intMixer) {
                                String stringSoundMixer_ID = in.readUTF();
                                Sound_Lines o_Sound_Lines = new Sound_Lines();
                                o_Sound_Lines.readExternal(in);
                                o_SoundMixer = s_SoundMixerTableModel.getSoundMixer(stringSoundMixer_ID);
                                if (o_SoundMixer == null) {
                                    this.m_SoundMixers_Active.put(stringSoundMixer_ID, o_Sound_Lines);
                                    continue;
                                }
                                if (!o_SoundMixer.getSound_Lines().equals(o_Sound_Lines)) {
                                    o_Sound_Lines.copyTo(o_SoundMixer.getSound_Lines());
                                }
                                o_SoundMixers_Deactived.remove(o_SoundMixer);
                                this.m_SoundMixers_Active.put(stringSoundMixer_ID, o_SoundMixer.getSound_Lines());
                                o_SoundMixer.setActive(true, true);
                            }
                        }
                        int intMixer = 0;
                        while (intMixer < o_SoundMixers_Deactived.size()) {
                            o_SoundMixer = (SoundMixer)o_SoundMixers_Deactived.get(intMixer);
                            o_SoundMixer.setActive(false, true);
                            ++intMixer;
                        }
                        return;
                    }
                    finally {
                        try {
                            if (in != null) {
                                in.close();
                            }
                            if (o_FileInputStream != null) {
                                o_FileInputStream.close();
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Exception e) {
                    System.err.println("SoundMixers SoundMixer_Setting readSoundMixerSettings File: " + o_File.getAbsolutePath());
                    System.err.println("         error: " + e.getMessage());
                }
                return;
            }
        }
    }

    public static class SoundMixer_WinDirectSound
    extends SoundMixer {
        private int m_FramesFilled;
        private Device m_Device;
        private PlayBuffer m_PlayBuffer;
        private ByteBuffer m_ByteBuffer;
        private ByteBuffer m_EmptyChannelByteBuffer;
        private int m_IndexWrite;
        private long m_WriteStartTime;
        private boolean m_ShouldRun;
        private boolean m_ShouldStop;
        private Runnable m_RunnableStop;
        private Thread m_ThreadStop;
        private final Object m_SyncObject = new Object();
        private SoundMixer_WinDirectSound m_SelfReference;

        public SoundMixer_WinDirectSound(Device o_Device, String p_ID, AudioFormat p_AudioFormat) {
            super("DirectSound", p_ID, o_Device.getName(), "", p_AudioFormat);
            this.initMembers();
            this.m_Device = o_Device;
            this.m_Name = this.m_Device.getName();
            this.setChannels_Output(p_AudioFormat.getChannels());
            for (int intChannel = 0; intChannel < this.m_AudioFormat.getChannels(); ++intChannel) {
                this.addSoundLineFactor(intChannel, intChannel, 1.0, false);
            }
            this.m_SelfReference = this;
        }

        private void initMembers() {
            this.m_ByteBuffer = null;
            this.m_Device = null;
            this.m_PlayBuffer = null;
            this.m_Channels_Output = 0;
            this.m_IndexWrite = 0;
            this.m_FramesFilled = 0;
            this.m_ShouldRun = false;
            this.m_ShouldStop = false;
            this.m_WriteStartTime = -1L;
            this.m_RunnableStop = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (!m_Closed) {
                        Object object = m_SyncObject;
                        synchronized (object) {
                            if (!m_ShouldStop) {
                                try {
                                    m_SyncObject.wait();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                        if (!m_ShouldStop) continue;
                        m_ShouldStop = false;
                        PlayBuffer o_PlayBuffer = m_PlayBuffer;
                        if (o_PlayBuffer == null || !o_PlayBuffer.isRunning()) continue;
                        int intAvailable = (int)o_PlayBuffer.available();
                        if (intAvailable > m_EmptyChannelByteBuffer.capacity() && intAvailable > m_EmptyChannelByteBuffer.capacity()) {
                            intAvailable = m_EmptyChannelByteBuffer.capacity();
                        }
                        try {
                            o_PlayBuffer.write(m_EmptyChannelByteBuffer, 0, intAvailable);
                            o_PlayBuffer.drainStop();
                        }
                        catch (Exception e_SoundCardLost) {
                            SoundMixers.SoundMixer_Lost(m_SelfReference, "Stop Soundmixer");
                            m_IndexWrite = 0;
                            m_FramesFilled = 0;
                            continue;
                        }
                        m_IndexWrite = 0;
                        m_FramesFilled = 0;
                    }
                }
            };
            this.m_ThreadStop = new Thread(this.m_RunnableStop);
            this.m_ThreadStop.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setActive(boolean p_Active, boolean p_Internal) {
            if (p_Active) {
                Object object = this.m_SyncObject;
                synchronized (object) {
                    if (this.m_PlayBuffer != null) {
                        return true;
                    }
                    if (!this.open()) {
                        return false;
                    }
                    this.checkSoundLines();
                }
                this.m_PropertyChangeSupport.firePropertyChange("propActive", false, true);
                s_SoundMixer_Setting.addSoundMixer_Active(this);
                s_SoundBuffer_Mixers.addSoundMixer(this);
                return true;
            }
            s_SoundBuffer_Mixers.removeSoundMixer(this);
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_PlayBuffer != null) {
                    try {
                        this.m_PlayBuffer.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.m_PlayBuffer = null;
                }
            }
            this.m_PropertyChangeSupport.firePropertyChange("propActive", true, false);
            s_SoundMixer_Setting.removeSoundMixer_Active(this);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean getIsActive() {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_PlayBuffer != null) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void notifyChannelChange_Start() {
        }

        @Override
        public void notifyChannelChange_End() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean open() {
            int intByte_Size;
            PlayBuffer o_PlayBuffer;
            Object object = this.m_SyncObject;
            synchronized (object) {
                Device o_Device = this.m_Device;
                o_PlayBuffer = this.m_PlayBuffer;
                if (o_Device == null) {
                    return false;
                }
                intByte_Size = BUFFERSIZE_FRAMES_MIXER * this.m_AudioFormat.getFrameSize();
            }
            if (this.m_ByteBuffer == null || this.m_ByteBuffer.capacity() != intByte_Size) {
                this.m_ByteBuffer = ByteBuffer.allocateDirect(intByte_Size);
                this.m_EmptyChannelByteBuffer = ByteBuffer.allocateDirect(intByte_Size);
                if (this.m_AudioFormat.isBigEndian()) {
                    this.m_ByteBuffer.order(ByteOrder.BIG_ENDIAN);
                    this.m_EmptyChannelByteBuffer.order(ByteOrder.BIG_ENDIAN);
                } else {
                    this.m_ByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                    this.m_EmptyChannelByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                }
                for (int intByte = 0; intByte < intByte_Size; ++intByte) {
                    this.m_EmptyChannelByteBuffer.put(intByte, (byte)0);
                }
            }
            if (o_PlayBuffer == null && (o_PlayBuffer = this.createPlayBuffer()) == null) {
                return false;
            }
            Object object2 = this.m_SyncObject;
            synchronized (object2) {
                this.m_PlayBuffer = o_PlayBuffer;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean close() {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (!super.close()) {
                    return false;
                }
                this.m_ShouldRun = false;
                this.m_ShouldStop = false;
                this.m_SyncObject.notifyAll();
            }
            PlayBuffer o_PlayBuffer = this.m_PlayBuffer;
            Device o_Device = this.m_Device;
            Object object2 = this.m_SyncObject;
            synchronized (object2) {
                this.m_PlayBuffer = null;
                this.m_Device = null;
            }
            if (o_PlayBuffer != null) {
                try {
                    o_PlayBuffer.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (o_Device != null) {
                try {
                    o_Device.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }

        @Override
        public boolean start(boolean p_ManuallyStarted) {
            this.m_ShouldRun = true;
            this.m_ShouldStop = false;
            this.m_ManuallyStarted = p_ManuallyStarted;
            this.m_IndexWrite = 0;
            this.m_FramesFilled = 0;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startInternal() {
            PlayBuffer o_PlayBuffer;
            Object object = this.m_SyncObject;
            synchronized (object) {
                o_PlayBuffer = this.m_PlayBuffer;
            }
            this.m_WriteStartTime = System.nanoTime();
            if (o_PlayBuffer == null || o_PlayBuffer.isRunning()) {
                this.m_WriteStartTime = -1L;
                this.m_ManuallyStarted = false;
                return;
            }
            this.m_WriteStartTime = -1L;
            SoundMixer o_SoundMixer = s_SoundBuffer_Mixers.getSoundMixer(0);
            if (o_SoundMixer != null && o_SoundMixer != this.m_SelfReference && this.m_ManuallyStarted) {
                int intBytes;
                int intFramesInLine = o_SoundMixer.getFramesInLine();
                int intBytesToWrite = intBytes = intFramesInLine * this.m_AudioFormat.getFrameSize();
                while (intBytesToWrite > 0) {
                    if (intBytesToWrite > this.m_EmptyChannelByteBuffer.capacity()) {
                        intBytesToWrite = this.m_EmptyChannelByteBuffer.capacity();
                    }
                    this.m_WriteStartTime = System.nanoTime();
                    try {
                        o_PlayBuffer.write(this.m_EmptyChannelByteBuffer, 0, intBytesToWrite);
                    }
                    catch (Exception_SoundCardLost e_SoundCardLost) {
                        this.m_WriteStartTime = -1L;
                        SoundMixers.SoundMixer_Lost(o_SoundMixer, "Start Soundmixer - Init");
                        this.m_IndexWrite = 0;
                        this.m_FramesFilled = 0;
                        return;
                    }
                    catch (InvalidParameterException e_InvalidParameters) {
                        this.m_WriteStartTime = -1L;
                        this.m_IndexWrite = 0;
                        this.m_FramesFilled = 0;
                        return;
                    }
                    this.m_WriteStartTime = -1L;
                    intBytesToWrite = intBytes -= intBytesToWrite;
                }
            }
            this.m_ManuallyStarted = false;
            try {
                o_PlayBuffer.start();
            }
            catch (Exception_SoundCardLost e_SoundCardLost) {
                SoundMixers.SoundMixer_Lost(o_SoundMixer, "Start Soundmixer - Start PlayBuffer");
                this.m_IndexWrite = 0;
                this.m_FramesFilled = 0;
                return;
            }
        }

        @Override
        public boolean isRunning() {
            return this.m_PlayBuffer != null && this.m_PlayBuffer.isRunning();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean stop() {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (!this.m_ShouldRun) {
                    return true;
                }
                this.m_ShouldStop = true;
                this.m_ShouldRun = false;
                this.m_SyncObject.notifyAll();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getFramesInLine() {
            PlayBuffer o_PlayBuffer;
            Object object = this.m_SyncObject;
            synchronized (object) {
                o_PlayBuffer = this.m_PlayBuffer;
            }
            if (o_PlayBuffer == null || this.m_AudioFormat == null) {
                return 0;
            }
            int intFilled = (int)o_PlayBuffer.filled();
            int intBytesInLine = intFilled;
            if (intBytesInLine < 0) {
                intBytesInLine = 0;
            }
            return intBytesInLine / this.m_AudioFormat.getFrameSize();
        }

        public Device getDevice() {
            return this.m_Device;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PlayBuffer createPlayBuffer() {
            PlayBuffer o_PlayBuffer = null;
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_Device == null) {
                    return null;
                }
            }
            try {
                o_PlayBuffer = this.m_Device.createPlayBuffer(BUFFERSIZE_FRAMES_SOUNDCARD, BUFFERSIZE_FRAMES_MIXER);
            }
            catch (Exception e) {
                if (o_PlayBuffer != null) {
                    try {
                        o_PlayBuffer.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    o_PlayBuffer = null;
                }
                return null;
            }
            return o_PlayBuffer;
        }

        @Override
        public long getControllerStartTime() {
            return this.m_WriteStartTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeFrames(double[] p_Values) {
            ByteBuffer o_ByteBuffer;
            PlayBuffer o_PlayBuffer;
            if (p_Values == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (!this.m_ShouldRun) {
                    return;
                }
                o_PlayBuffer = this.m_PlayBuffer;
                o_ByteBuffer = this.m_ByteBuffer;
            }
            if (o_PlayBuffer == null) {
                return;
            }
            if (o_ByteBuffer == null) {
                return;
            }
            int intFramesToWrite = p_Values.length / SOUND_SOUNDLINES_COUNT;
            for (int intFrame = 0; intFrame < intFramesToWrite; ++intFrame) {
                block12: for (int intMixerChannel = 0; intMixerChannel < this.m_Channels_Output; ++intMixerChannel) {
                    if (this.m_IndexWrite >= o_ByteBuffer.capacity()) {
                        this.m_FramesFilled = 0;
                        this.m_IndexWrite = 0;
                    }
                    double doubleChannelValue = 0.0;
                    double doubleLineValue = 0.0;
                    if (s_MainVolumeFactor_Sound > 0.0) {
                        int intSoundLinesFactorsCount = this.getSound_Channel_LinesCount(intMixerChannel);
                        for (int intIndex = 0; intIndex < intSoundLinesFactorsCount; ++intIndex) {
                            int intSorceLine;
                            SoundLineFactor o_SoundLineFactor = this.getSoundLineFactorByIndex(intMixerChannel, intIndex);
                            if (o_SoundLineFactor == null) continue;
                            double doubleLineVolume = o_SoundLineFactor.getVolumeFactor();
                            if ((doubleLineVolume *= s_MainVolumeFactor_Sound) <= 0.0 || (intSorceLine = o_SoundLineFactor.getSoundLineNumber()) < 0 || intSorceLine >= SOUND_SOUNDLINES_COUNT) continue;
                            doubleLineValue = p_Values[intFrame * SOUND_SOUNDLINES_COUNT + intSorceLine];
                            if ((doubleLineValue *= doubleLineVolume) == 0.0) continue;
                            doubleChannelValue += doubleLineValue;
                        }
                        if (doubleChannelValue > 1.0) {
                            doubleChannelValue = 1.0;
                        }
                        if (doubleChannelValue < -1.0) {
                            doubleChannelValue = -1.0;
                        }
                    }
                    this.m_DelayBuffer.putFrameValue(intMixerChannel, doubleChannelValue);
                    doubleChannelValue = this.m_DelayBuffer.getFrameValue(intMixerChannel);
                    switch (this.m_AudioFormat.getSampleSizeInBits()) {
                        case 16: {
                            short shortValue = (short)(doubleChannelValue *= 32767.0);
                            o_ByteBuffer.putShort(this.m_IndexWrite, shortValue);
                            this.m_IndexWrite += 2;
                            continue block12;
                        }
                        case 24: {
                            int intValue = (int)(doubleChannelValue *= 2.147483647E9);
                            if (this.m_AudioFormat.isBigEndian()) {
                                o_ByteBuffer.put(this.m_IndexWrite, (byte)(intValue >> 24));
                                o_ByteBuffer.put(this.m_IndexWrite + 1, (byte)(intValue >> 16));
                                o_ByteBuffer.put(this.m_IndexWrite + 2, (byte)(intValue >> 8));
                            } else {
                                o_ByteBuffer.put(this.m_IndexWrite, (byte)(intValue >> 8));
                                o_ByteBuffer.put(this.m_IndexWrite + 1, (byte)(intValue >> 16));
                                o_ByteBuffer.put(this.m_IndexWrite + 2, (byte)(intValue >> 24));
                            }
                            this.m_IndexWrite += 3;
                            continue block12;
                        }
                        case 32: {
                            int intValue = (int)(doubleChannelValue *= 2.147483647E9);
                            o_ByteBuffer.putInt(this.m_IndexWrite, intValue);
                            this.m_IndexWrite += 4;
                        }
                    }
                }
                ++this.m_FramesFilled;
                if (this.m_FramesFilled < BUFFERSIZE_FRAMES_MIXER) continue;
                if (this.m_ShouldRun) {
                    this.startInternal();
                    this.m_WriteStartTime = System.nanoTime();
                    try {
                        o_PlayBuffer.write(o_ByteBuffer, 0, o_ByteBuffer.capacity());
                    }
                    catch (Exception_SoundCardLost e_SoundCardLost) {
                        this.m_WriteStartTime = -1L;
                        this.m_IndexWrite = 0;
                        this.m_FramesFilled = 0;
                        SoundMixers.SoundMixer_Lost(this, "Write SoundFrames");
                        return;
                    }
                    catch (InvalidParameterException e_InvalidParameters) {
                        this.m_WriteStartTime = -1L;
                        this.m_IndexWrite = 0;
                        this.m_FramesFilled = 0;
                        return;
                    }
                    this.m_WriteStartTime = -1L;
                }
                this.m_IndexWrite = 0;
                this.m_FramesFilled = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean writeDelayRest() {
            PlayBuffer o_PlayBuffer;
            DelayBuffer o_DelayBuffer;
            boolean boolReady = true;
            Object object = this.m_SyncObject;
            synchronized (object) {
                o_DelayBuffer = this.m_DelayBuffer;
                o_PlayBuffer = this.m_PlayBuffer;
                if (!this.m_ShouldRun) {
                    return true;
                }
            }
            if (o_DelayBuffer != null && o_PlayBuffer != null) {
                boolReady = o_DelayBuffer.writeDelayRest(this.m_ByteBuffer);
                this.m_WriteStartTime = System.nanoTime();
                try {
                    o_PlayBuffer.write(this.m_ByteBuffer, 0, this.m_ByteBuffer.capacity());
                }
                catch (Exception e) {
                    this.m_WriteStartTime = -1L;
                    boolReady = true;
                }
                this.m_WriteStartTime = -1L;
            } else {
                boolReady = true;
            }
            return boolReady;
        }
    }

    public static class SoundMixer_Controller {
        public static long s_ProofTime = 2500L;
        public static long s_FailTime = 1000L;
        private Runnable m_RunnableController;
        private Thread m_ThreadController;
        private boolean m_Close;
        private final Object m_SyncController = new Object();

        public SoundMixer_Controller() {
            this.initMembers();
            this.m_ThreadController.start();
        }

        private void initMembers() {
            this.m_Close = false;
            this.m_RunnableController = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (!m_Close) {
                        Object object = m_SyncController;
                        synchronized (object) {
                            if (OSChecker.getIsWindows()) {
                                long longWaitTime = s_ProofTime;
                                while (longWaitTime > 0L && !m_Close) {
                                    try {
                                        long longWaitStart = System.nanoTime() / 1000000L;
                                        m_SyncController.wait(longWaitTime);
                                        longWaitTime -= System.nanoTime() / 1000000L - longWaitStart;
                                    }
                                    catch (Exception exception) {}
                                }
                            } else {
                                try {
                                    m_SyncController.wait(s_ProofTime);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (m_Close) {
                                return;
                            }
                            for (int intMixer = 0; intMixer < s_SoundMixerTableModel.size(); ++intMixer) {
                                long longActualTime;
                                long longWriteStartTime;
                                SoundMixer o_SoundMixer = s_SoundMixerTableModel.getSoundMixer(intMixer);
                                if (o_SoundMixer == null || !o_SoundMixer.getIsActive() || (longWriteStartTime = o_SoundMixer.getControllerStartTime()) <= 0L || ((longActualTime = System.nanoTime()) - longWriteStartTime) / 1000000L <= s_FailTime) continue;
                                SoundMixers.SoundMixer_Lost(o_SoundMixer, "Controller Timeout");
                            }
                        }
                    }
                }
            };
            this.m_ThreadController = new Thread(this.m_RunnableController, "DirectSound_Controller");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.m_SyncController;
            synchronized (object) {
                this.m_Close = true;
                this.m_SyncController.notifyAll();
            }
        }
    }

    public static class SoundMixer_DirectSound
    extends SoundMixer {
        private int m_FramesFilled;
        private Mixer m_Mixer;
        private Mixer.Info m_MixerInfo;
        private DataLine.Info m_DataLineInfo;
        private SourceDataLine m_SourceDataLine;
        private boolean m_SourceDataLine_Started;
        private ByteBuffer m_ByteBuffer;
        private int m_ByteBufferMilliseconds;
        private ByteBuffer m_EmptyChannelByteBuffer;
        private int m_IndexWrite;
        private long m_ControllerStartTime;
        private boolean m_ShouldRun;
        private boolean m_ShouldStop;
        private Runnable m_RunnableStop;
        private Thread m_ThreadStop;
        private final Object m_SyncObject = new Object();
        private SoundMixer_DirectSound m_SelfReference;
        private final Object m_SyncSoundDataline = new Object();

        public SoundMixer_DirectSound(Mixer p_Mixer, String p_ID, AudioFormat p_AudioFormat, DataLine.Info p_DataLineInfo) {
            super("DirectSound", p_ID, p_Mixer.getMixerInfo().getName(), "", p_AudioFormat);
            this.initMembers();
            this.m_Mixer = p_Mixer;
            this.m_MixerInfo = p_Mixer.getMixerInfo();
            this.m_Name = this.m_Mixer.getMixerInfo().getName();
            this.setChannels_Output(p_AudioFormat.getChannels());
            this.m_DataLineInfo = p_DataLineInfo;
            for (int intChannel = 0; intChannel < this.m_AudioFormat.getChannels(); ++intChannel) {
                this.addSoundLineFactor(intChannel, intChannel, 1.0, false);
            }
            this.m_SelfReference = this;
        }

        private void initMembers() {
            this.m_ByteBuffer = null;
            this.m_Mixer = null;
            this.m_DataLineInfo = null;
            this.m_Channels_Output = 0;
            this.m_IndexWrite = 0;
            this.m_FramesFilled = 0;
            this.m_ShouldRun = false;
            this.m_ShouldStop = false;
            this.m_ControllerStartTime = -1L;
            this.m_SourceDataLine_Started = false;
            this.m_RunnableStop = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (!m_Closed) {
                        int intBytesToWrite;
                        SourceDataLine o_SourceDataLine;
                        Object object = m_SyncObject;
                        synchronized (object) {
                            if (!m_ShouldStop) {
                                try {
                                    m_SyncObject.wait();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                        if (!m_ShouldStop) continue;
                        m_ShouldStop = false;
                        Object object2 = m_SyncObject;
                        synchronized (object2) {
                            o_SourceDataLine = m_SourceDataLine;
                            if (o_SourceDataLine == null || !o_SourceDataLine.isActive()) {
                                return;
                            }
                        }
                        for (int intAvailable = o_SourceDataLine.getBufferSize(); intAvailable > 0; intAvailable -= intBytesToWrite) {
                            intBytesToWrite = intAvailable > m_EmptyChannelByteBuffer.capacity() ? m_EmptyChannelByteBuffer.capacity() : intAvailable;
                            m_ControllerStartTime = System.nanoTime();
                            try {
                                this.writeSourceDataLine(m_EmptyChannelByteBuffer.array(), 0, intBytesToWrite);
                            }
                            catch (Exception e) {
                                m_ControllerStartTime = -1L;
                                SoundMixers.SoundMixer_Lost(m_SelfReference, "Stop Soundmixer");
                                m_IndexWrite = 0;
                                m_FramesFilled = 0;
                                return;
                            }
                            m_ControllerStartTime = -1L;
                        }
                        o_SourceDataLine.drain();
                        o_SourceDataLine.stop();
                        o_SourceDataLine.flush();
                        m_IndexWrite = 0;
                        m_FramesFilled = 0;
                    }
                }
            };
            this.m_ThreadStop = new Thread(this.m_RunnableStop);
            this.m_ThreadStop.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setActive(boolean p_Active, boolean p_Internal) {
            if (p_Active) {
                Object object = this.m_SyncObject;
                synchronized (object) {
                    if (this.m_SourceDataLine != null) {
                        return true;
                    }
                    if (!this.open()) {
                        return false;
                    }
                    this.checkSoundLines();
                }
                this.m_PropertyChangeSupport.firePropertyChange("propActive", false, true);
                s_SoundMixer_Setting.addSoundMixer_Active(this);
                s_SoundBuffer_Mixers.addSoundMixer(this);
                return true;
            }
            s_SoundBuffer_Mixers.removeSoundMixer(this);
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_SourceDataLine != null) {
                    try {
                        this.m_SourceDataLine.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.m_SourceDataLine = null;
                }
            }
            this.m_PropertyChangeSupport.firePropertyChange("propActive", true, false);
            s_SoundMixer_Setting.removeSoundMixer_Active(this);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean getIsActive() {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_SourceDataLine != null) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void notifyChannelChange_Start() {
        }

        @Override
        public void notifyChannelChange_End() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean open() {
            int intByte_Size;
            SourceDataLine o_SourceDataLine;
            Mixer o_Mixer;
            Object object = this.m_SyncObject;
            synchronized (object) {
                o_Mixer = this.m_Mixer;
                o_SourceDataLine = this.m_SourceDataLine;
                if (o_Mixer == null) {
                    return false;
                }
                intByte_Size = BUFFERSIZE_FRAMES_MIXER * this.m_AudioFormat.getFrameSize();
            }
            if (this.m_ByteBuffer == null || this.m_ByteBuffer.capacity() != intByte_Size) {
                this.m_ByteBuffer = ByteBuffer.allocate(intByte_Size);
                this.m_ByteBufferMilliseconds = (int)((double)((float)BUFFERSIZE_FRAMES_MIXER / this.m_AudioFormat.getFrameRate() * 1000.0f) + 0.5);
                this.m_EmptyChannelByteBuffer = ByteBuffer.allocate(intByte_Size);
                if (this.m_AudioFormat.isBigEndian()) {
                    this.m_ByteBuffer.order(ByteOrder.BIG_ENDIAN);
                    this.m_EmptyChannelByteBuffer.order(ByteOrder.BIG_ENDIAN);
                } else {
                    this.m_ByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                    this.m_EmptyChannelByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                }
                for (int intByte = 0; intByte < intByte_Size; ++intByte) {
                    this.m_EmptyChannelByteBuffer.put(intByte, (byte)0);
                }
            }
            if (!o_Mixer.isOpen()) {
                try {
                    o_Mixer.open();
                }
                catch (Exception e) {
                    if (o_Mixer != null) {
                        try {
                            o_Mixer.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return false;
                }
            }
            if (o_SourceDataLine == null && (o_SourceDataLine = this.createSoundSourceDataLine()) == null) {
                return false;
            }
            Object object2 = this.m_SyncObject;
            synchronized (object2) {
                this.m_SourceDataLine = o_SourceDataLine;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean close() {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (!super.close()) {
                    return false;
                }
                this.m_ShouldRun = false;
                this.m_ShouldStop = false;
                this.m_SyncObject.notifyAll();
            }
            object = this.m_SyncSoundDataline;
            synchronized (object) {
                this.m_SyncSoundDataline.notifyAll();
            }
            this.stop();
            object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_SourceDataLine != null) {
                    try {
                        this.m_SourceDataLine.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.m_SourceDataLine = null;
                }
                if (this.m_Mixer != null) {
                    try {
                        this.m_Mixer.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.m_Mixer = null;
                }
            }
            return true;
        }

        @Override
        public boolean start(boolean p_ManuallyStarted) {
            this.m_ShouldRun = true;
            this.m_ShouldStop = false;
            this.m_ManuallyStarted = p_ManuallyStarted;
            this.m_IndexWrite = 0;
            this.m_FramesFilled = 0;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startInternal() {
            SourceDataLine o_SourceDataLine;
            this.m_ControllerStartTime = System.nanoTime();
            Object object = this.m_SyncObject;
            synchronized (object) {
                o_SourceDataLine = this.m_SourceDataLine;
            }
            try {
                if (o_SourceDataLine == null || o_SourceDataLine.isActive()) {
                    this.m_ControllerStartTime = -1L;
                    this.m_ManuallyStarted = false;
                    return;
                }
            }
            catch (Exception e) {
                this.m_ControllerStartTime = -1L;
                SoundMixers.SoundMixer_Lost(this, "Start Soundmixer");
                this.m_IndexWrite = 0;
                this.m_FramesFilled = 0;
                return;
            }
            this.m_ControllerStartTime = -1L;
            SoundMixer o_SoundMixer = s_SoundBuffer_Mixers.getSoundMixer(0);
            if (o_SoundMixer != null && o_SoundMixer != this.m_SelfReference && this.m_ManuallyStarted) {
                int intBytes;
                int intFramesInLine = o_SoundMixer.getFramesInLine();
                int intBytesToWrite = intBytes = intFramesInLine * this.m_AudioFormat.getFrameSize();
                while (intBytesToWrite > 0) {
                    if (intBytesToWrite > this.m_EmptyChannelByteBuffer.capacity()) {
                        intBytesToWrite = this.m_EmptyChannelByteBuffer.capacity();
                    }
                    this.m_ControllerStartTime = System.nanoTime();
                    try {
                        this.writeSourceDataLine(this.m_EmptyChannelByteBuffer.array(), 0, intBytesToWrite);
                    }
                    catch (Exception e) {
                        this.m_ControllerStartTime = -1L;
                        SoundMixers.SoundMixer_Lost(this, "Start Soundmixer - Init");
                        this.m_IndexWrite = 0;
                        this.m_FramesFilled = 0;
                        return;
                    }
                    this.m_ControllerStartTime = -1L;
                    intBytesToWrite = intBytes -= intBytesToWrite;
                }
            }
            this.m_ManuallyStarted = false;
            this.m_ControllerStartTime = System.nanoTime();
            try {
                o_SourceDataLine.start();
            }
            catch (Exception e) {
                this.m_ControllerStartTime = -1L;
                SoundMixers.SoundMixer_Lost(this, "Start Soundmixer - start SourceDataLine");
                this.m_IndexWrite = 0;
                this.m_FramesFilled = 0;
                return;
            }
            this.m_ControllerStartTime = -1L;
            this.m_SourceDataLine_Started = true;
        }

        @Override
        public boolean isRunning() {
            return this.m_SourceDataLine != null && this.m_SourceDataLine_Started;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean stop() {
            this.m_SourceDataLine_Started = false;
            Object object = this.m_SyncObject;
            synchronized (object) {
                SourceDataLine o_SourceDataLine = this.m_SourceDataLine;
                boolean boolShouldRun = this.m_ShouldRun;
                this.m_ShouldRun = false;
                if (o_SourceDataLine != null && !boolShouldRun) {
                    this.m_ShouldStop = false;
                    try {
                        o_SourceDataLine.flush();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return true;
                }
                this.m_ShouldStop = true;
                this.m_SyncObject.notifyAll();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getFramesInLine() {
            int intAvailable;
            int intBufferSize;
            SourceDataLine o_SourceDataLine;
            Object object = this.m_SyncObject;
            synchronized (object) {
                o_SourceDataLine = this.m_SourceDataLine;
            }
            if (o_SourceDataLine == null || this.m_AudioFormat == null) {
                return 0;
            }
            this.m_ControllerStartTime = System.nanoTime();
            try {
                intBufferSize = o_SourceDataLine.getBufferSize();
                intAvailable = o_SourceDataLine.available();
            }
            catch (Exception e) {
                this.m_ControllerStartTime = -1L;
                return 0;
            }
            this.m_ControllerStartTime = -1L;
            int intBytesInLine = intBufferSize - intAvailable;
            if (intBytesInLine < 0) {
                intBytesInLine = 0;
            }
            return intBytesInLine / this.m_AudioFormat.getFrameSize();
        }

        public Mixer getMixer() {
            return this.m_Mixer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SourceDataLine createSoundSourceDataLine() {
            SourceDataLine o_SourceDataLine = null;
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_Mixer == null) {
                    return null;
                }
                if (this.m_DataLineInfo == null) {
                    return null;
                }
            }
            try {
                o_SourceDataLine = (SourceDataLine)this.m_Mixer.getLine(this.m_DataLineInfo);
                o_SourceDataLine.open(this.m_AudioFormat, BUFFERSIZE_FRAMES_SOUNDCARD * this.m_AudioFormat.getFrameSize());
            }
            catch (Exception e) {
                if (o_SourceDataLine != null) {
                    try {
                        o_SourceDataLine.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    o_SourceDataLine = null;
                }
                return null;
            }
            o_SourceDataLine.addLineListener(new LineListener(){

                @Override
                public void update(LineEvent event) {
                }
            });
            return o_SourceDataLine;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeFrames(double[] p_Values) {
            ByteBuffer o_ByteBuffer;
            SourceDataLine o_SourceDataLine;
            if (p_Values == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (!this.m_ShouldRun) {
                    return;
                }
                o_SourceDataLine = this.m_SourceDataLine;
                o_ByteBuffer = this.m_ByteBuffer;
            }
            if (o_SourceDataLine == null) {
                return;
            }
            if (o_ByteBuffer == null) {
                return;
            }
            int intFramesToWrite = p_Values.length / SOUND_SOUNDLINES_COUNT;
            for (int intFrame = 0; intFrame < intFramesToWrite; ++intFrame) {
                block11: for (int intMixerChannel = 0; intMixerChannel < this.m_Channels_Output; ++intMixerChannel) {
                    if (this.m_IndexWrite >= o_ByteBuffer.capacity()) {
                        this.m_IndexWrite = 0;
                        this.m_FramesFilled = 0;
                    }
                    double doubleChannelValue = 0.0;
                    double doubleLineValue = 0.0;
                    if (s_MainVolumeFactor_Sound > 0.0) {
                        int intSoundLinesFactorsCount = this.getSound_Channel_LinesCount(intMixerChannel);
                        for (int intIndex = 0; intIndex < intSoundLinesFactorsCount; ++intIndex) {
                            int intSorceLine;
                            SoundLineFactor o_SoundLineFactor = this.getSoundLineFactorByIndex(intMixerChannel, intIndex);
                            if (o_SoundLineFactor == null) continue;
                            double doubleLineVolume = o_SoundLineFactor.getVolumeFactor();
                            if ((doubleLineVolume *= s_MainVolumeFactor_Sound) <= 0.0 || (intSorceLine = o_SoundLineFactor.getSoundLineNumber()) < 0 || intSorceLine >= SOUND_SOUNDLINES_COUNT) continue;
                            doubleLineValue = p_Values[intFrame * SOUND_SOUNDLINES_COUNT + intSorceLine];
                            if ((doubleLineValue *= doubleLineVolume) == 0.0) continue;
                            doubleChannelValue += doubleLineValue;
                        }
                        if (doubleChannelValue > 1.0) {
                            doubleChannelValue = 1.0;
                        }
                        if (doubleChannelValue < -1.0) {
                            doubleChannelValue = -1.0;
                        }
                    }
                    this.m_DelayBuffer.putFrameValue(intMixerChannel, doubleChannelValue);
                    doubleChannelValue = this.m_DelayBuffer.getFrameValue(intMixerChannel);
                    switch (this.m_AudioFormat.getSampleSizeInBits()) {
                        case 16: {
                            short shortValue = (short)(doubleChannelValue *= 32767.0);
                            o_ByteBuffer.putShort(this.m_IndexWrite, shortValue);
                            this.m_IndexWrite += 2;
                            continue block11;
                        }
                        case 24: {
                            int intValue = (int)(doubleChannelValue *= 2.147483647E9);
                            if (this.m_AudioFormat.isBigEndian()) {
                                o_ByteBuffer.put(this.m_IndexWrite, (byte)(intValue >> 24));
                                o_ByteBuffer.put(this.m_IndexWrite + 1, (byte)(intValue >> 16));
                                o_ByteBuffer.put(this.m_IndexWrite + 2, (byte)(intValue >> 8));
                            } else {
                                o_ByteBuffer.put(this.m_IndexWrite, (byte)(intValue >> 8));
                                o_ByteBuffer.put(this.m_IndexWrite + 1, (byte)(intValue >> 16));
                                o_ByteBuffer.put(this.m_IndexWrite + 2, (byte)(intValue >> 24));
                            }
                            this.m_IndexWrite += 3;
                            continue block11;
                        }
                        case 32: {
                            int intValue = (int)(doubleChannelValue *= 2.147483647E9);
                            o_ByteBuffer.putInt(this.m_IndexWrite, intValue);
                            this.m_IndexWrite += 4;
                        }
                    }
                }
                ++this.m_FramesFilled;
                if (this.m_FramesFilled < BUFFERSIZE_FRAMES_MIXER) continue;
                if (this.m_ShouldRun) {
                    this.m_ControllerStartTime = System.nanoTime();
                    try {
                        this.startInternal();
                        this.writeSourceDataLine(o_ByteBuffer.array(), 0, o_ByteBuffer.capacity());
                    }
                    catch (Exception e) {
                        this.m_ControllerStartTime = -1L;
                        SoundMixers.SoundMixer_Lost(this, "Write SoundFrames");
                        this.m_IndexWrite = 0;
                        this.m_FramesFilled = 0;
                        return;
                    }
                    this.m_ControllerStartTime = -1L;
                }
                this.m_IndexWrite = 0;
                this.m_FramesFilled = 0;
            }
        }

        @Override
        public long getControllerStartTime() {
            return this.m_ControllerStartTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean writeDelayRest() {
            boolean boolReady = true;
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_DelayBuffer != null && this.m_SourceDataLine != null) {
                    boolReady = this.m_DelayBuffer.writeDelayRest(this.m_ByteBuffer);
                    this.m_ControllerStartTime = System.nanoTime();
                    try {
                        this.writeSourceDataLine(this.m_ByteBuffer.array(), 0, this.m_ByteBuffer.capacity());
                    }
                    catch (Exception e) {
                        this.m_ControllerStartTime = -1L;
                        boolReady = true;
                    }
                    this.m_ControllerStartTime = -1L;
                } else {
                    boolReady = true;
                }
            }
            return boolReady;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int writeSourceDataLine(byte[] p_ByteBufferArray, int p_Offset, int p_Length) throws Exception {
            if (p_ByteBufferArray == null) {
                return 0;
            }
            int intBytesWritten = 0;
            SourceDataLine o_SourceDataLine = this.m_SourceDataLine;
            if (o_SourceDataLine == null) {
                return 0;
            }
            Object object = this.m_SyncSoundDataline;
            synchronized (object) {
                int intAvailableBytes = o_SourceDataLine.available();
                while (o_SourceDataLine.isActive() && intAvailableBytes <= p_Length && this.m_ShouldRun) {
                    if (intAvailableBytes == p_Length) {
                        boolean bl = false;
                    }
                    try {
                        this.m_SyncSoundDataline.wait(this.m_ByteBufferMilliseconds);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    intAvailableBytes = o_SourceDataLine.available();
                }
                if (this.m_ShouldRun) {
                    intBytesWritten = o_SourceDataLine.write(p_ByteBufferArray, p_Offset, p_Length);
                }
            }
            return intBytesWritten;
        }
    }

    public static class SoundBuffer_Mixers {
        private ArrayList<SoundBuffer_Player> m_SoundBuffer_Players;
        private double[] m_FramesArray_Read;
        private double[] m_FramesArray_Empty;
        private ArrayList<SoundMixer> m_SoundMixers;
        private boolean m_SoundMixersStarted;
        private Thread m_Thread_Read;
        private Runnable m_Runnable_Read;
        private boolean m_ShouldStop;
        private boolean m_Closed;
        private final Object m_SyncObject = new Object();
        private final Object m_SyncWrite = new Object();

        public SoundBuffer_Mixers() {
            this.initMembers();
        }

        private void initMembers() {
            this.m_SoundBuffer_Players = new ArrayList();
            this.m_FramesArray_Read = new double[BUFFERSIZE_FRAMES_MIXER * SOUND_SOUNDLINES_COUNT];
            this.m_FramesArray_Empty = new double[BUFFERSIZE_FRAMES_MIXER * SOUND_SOUNDLINES_COUNT];
            for (int intFrameLine = 0; intFrameLine < BUFFERSIZE_FRAMES_MIXER * SOUND_SOUNDLINES_COUNT; ++intFrameLine) {
                this.m_FramesArray_Empty[intFrameLine] = 0.0;
            }
            this.m_SoundMixers = new ArrayList(5);
            this.m_SoundMixersStarted = false;
            this.m_Closed = false;
            this.m_ShouldStop = false;
            this.m_Runnable_Read = new Runnable(){

                @Override
                public void run() {
                    this.readFrames();
                }
            };
            this.m_Thread_Read = new Thread(this.m_Runnable_Read);
            this.m_Thread_Read.setPriority(8);
            this.m_Thread_Read.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_Closed) {
                    return;
                }
                this.m_Closed = true;
                this.m_SyncObject.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSoundBuffer_Player(SoundBuffer_Player p_SoundBuffer_Player) {
            if (p_SoundBuffer_Player == null) {
                return;
            }
            boolean boolStartMixers = false;
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_SoundBuffer_Players.contains(p_SoundBuffer_Player)) {
                    return;
                }
                if (this.m_SoundBuffer_Players.size() <= 0) {
                    boolStartMixers = true;
                }
                this.m_SoundBuffer_Players.add(p_SoundBuffer_Player);
            }
            if (boolStartMixers) {
                this.m_ShouldStop = false;
                this.startMixers();
            }
            object = this.m_SyncObject;
            synchronized (object) {
                this.m_SyncObject.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSoundBuffer_Player(SoundBuffer_Player p_SoundBuffer_Player) {
            if (p_SoundBuffer_Player == null) {
                return;
            }
            boolean boolStopMixers = false;
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (!this.m_SoundBuffer_Players.remove(p_SoundBuffer_Player)) {
                    return;
                }
                if (this.m_SoundBuffer_Players.size() <= 0) {
                    boolStopMixers = true;
                    this.m_SyncObject.notifyAll();
                }
            }
            if (boolStopMixers) {
                this.stopMixers();
            }
        }

        public int getSoundBuffer_PlayerCount() {
            return this.m_SoundBuffer_Players.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SoundBuffer_Player getSoundBuffer_Player(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_Index >= this.m_SoundBuffer_Players.size()) {
                    return null;
                }
                return this.m_SoundBuffer_Players.get(p_Index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readFrames() {
            int intFramesReaden = 0;
            while (!this.m_Closed) {
                Object object = this.m_SyncObject;
                synchronized (object) {
                    if (this.m_SoundBuffer_Players.size() <= 0 && !this.m_Closed && !this.m_ShouldStop) {
                        try {
                            this.m_SyncObject.wait();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (this.m_Closed) {
                    return;
                }
                if (this.m_ShouldStop) {
                    this.m_ShouldStop = false;
                    continue;
                }
                if (this.m_SoundBuffer_Players.size() <= 0) continue;
                boolean boolSomeReaden = false;
                int intSoundBufferPlayersCount = this.m_SoundBuffer_Players.size();
                System.arraycopy(this.m_FramesArray_Empty, 0, this.m_FramesArray_Read, 0, this.m_FramesArray_Read.length);
                for (int intBufferPlayer = 0; intBufferPlayer < intSoundBufferPlayersCount; ++intBufferPlayer) {
                    SoundBuffer_Player o_SoundBuffer_Player = this.getSoundBuffer_Player(intBufferPlayer);
                    if (o_SoundBuffer_Player == null || (intFramesReaden = o_SoundBuffer_Player.readFrames(this.m_FramesArray_Read)) <= 0 && intFramesReaden >= 0) continue;
                    boolSomeReaden = true;
                }
                if (!boolSomeReaden) continue;
                Object object2 = this.m_SyncWrite;
                synchronized (object2) {
                    for (int intMixer = 0; intMixer < this.m_SoundMixers.size(); ++intMixer) {
                        SoundMixer o_SoundMixer = this.getSoundMixer(intMixer);
                        if (o_SoundMixer == null) continue;
                        o_SoundMixer.writeFrames(this.m_FramesArray_Read);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSoundMixer(SoundMixer p_SoundMixer) {
            if (p_SoundMixer == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_SoundMixers.contains(p_SoundMixer)) {
                    return;
                }
                this.m_SoundMixers.add(p_SoundMixer);
                if (this.m_SoundMixersStarted) {
                    p_SoundMixer.start(true);
                } else {
                    p_SoundMixer.stop();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSoundMixer(SoundMixer p_SoundMixer) {
            if (p_SoundMixer == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                this.m_SoundMixers.remove(p_SoundMixer);
            }
        }

        public int getSoundMixerCount() {
            return this.m_SoundMixers.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SoundMixer getSoundMixer(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_Index >= this.m_SoundMixers.size()) {
                    return null;
                }
                return this.m_SoundMixers.get(p_Index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startMixers() {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_SoundMixersStarted) {
                    return;
                }
                this.m_SoundMixersStarted = true;
                int intSoundMixerCount = this.m_SoundMixers.size();
                for (int intMixer = 0; intMixer < intSoundMixerCount; ++intMixer) {
                    SoundMixer o_SoundMixer = this.getSoundMixer(intMixer);
                    if (o_SoundMixer == null) continue;
                    o_SoundMixer.start(false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopMixers() {
            int intSoundMixerCount;
            Object object = this.m_SyncObject;
            synchronized (object) {
                this.m_SoundMixersStarted = false;
                intSoundMixerCount = this.m_SoundMixers.size();
            }
            this.writeDelayRest();
            for (int intMixer = 0; intMixer < intSoundMixerCount; ++intMixer) {
                SoundMixer o_SoundMixer = this.getSoundMixer(intMixer);
                if (o_SoundMixer == null) continue;
                o_SoundMixer.resetDelay();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeDelayRest() {
            int intSoundMixerCount;
            boolean boolReady = false;
            Object object = this.m_SyncObject;
            synchronized (object) {
                intSoundMixerCount = this.m_SoundMixers.size();
            }
            object = this.m_SyncWrite;
            synchronized (object) {
            }
            while (!boolReady) {
                boolReady = true;
                for (int intMixer = 0; intMixer < intSoundMixerCount; ++intMixer) {
                    SoundMixer o_SoundMixer = this.getSoundMixer(intMixer);
                    if (o_SoundMixer == null) continue;
                    if (!o_SoundMixer.writeDelayRest()) {
                        boolReady = false;
                        continue;
                    }
                    o_SoundMixer.stop();
                }
            }
        }
    }

    public static class SoundBuffer_Player {
        public static double[] EMPTY_VALUES = null;
        public static final Object SYNCOBJECT = new Object();
        private DoubleBuffer m_DoubleBuffer;
        private int m_DoubleBuffer_FramesBuffered;
        private int m_IndexFrame_Read;
        private int m_FramesInLine;
        private int m_IndexFrame_Write;
        private int m_FramesFilled;
        private boolean m_Stopped;
        private boolean m_StoppedDrain;
        private boolean m_Started;
        private boolean m_StartedSynchronized = false;
        private boolean m_Closed;
        private final Object m_SyncObject = new Object();
        private SoundBuffer_Player m_SelfReference;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SoundBuffer_Player(int p_FramesBuffered) {
            this.initMembers();
            this.m_SelfReference = this;
            if (p_FramesBuffered <= 0) {
                p_FramesBuffered = BUFFERSIZE_FRAMES_MIXER * 4;
            }
            this.m_DoubleBuffer = DoubleBuffer.allocate(p_FramesBuffered * SOUND_SOUNDLINES_COUNT);
            this.m_DoubleBuffer_FramesBuffered = p_FramesBuffered;
            Object object = SYNCOBJECT;
            synchronized (object) {
                if (EMPTY_VALUES == null) {
                    EMPTY_VALUES = new double[p_FramesBuffered * SOUND_SOUNDLINES_COUNT];
                    for (int intValue = 0; intValue < EMPTY_VALUES.length; ++intValue) {
                        SoundBuffer_Player.EMPTY_VALUES[intValue] = 0.0;
                    }
                }
            }
        }

        private void initMembers() {
            this.m_FramesFilled = 0;
            this.m_IndexFrame_Read = 0;
            this.m_IndexFrame_Write = 0;
            this.m_Started = false;
            this.m_Stopped = true;
            this.m_StoppedDrain = false;
            this.m_Closed = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_Closed) {
                    return;
                }
                this.m_Closed = true;
                this.m_SyncObject.notifyAll();
            }
            s_SoundBuffer_Mixers.removeSoundBuffer_Player(this);
        }

        public int getFramesBuffered() {
            return this.m_DoubleBuffer.capacity() / SOUND_SOUNDLINES_COUNT;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int writeFrames(double[] p_Values, int p_FramesToWrite) {
            int intFramesToWrite;
            if (p_FramesToWrite <= 0) {
                return 0;
            }
            int intFrameSourceOffset = 0;
            int intFramesWritten = 0;
            if (this.m_StartedSynchronized) {
                if (this.m_FramesInLine < 0) {
                    this.m_FramesInLine = 0;
                }
                intFramesToWrite = p_FramesToWrite;
                intFrameSourceOffset += this.m_FramesInLine;
                if ((p_FramesToWrite -= this.m_FramesInLine) > 0) {
                    this.m_FramesInLine = 0;
                    this.m_StartedSynchronized = false;
                } else {
                    this.m_FramesInLine -= intFramesToWrite;
                }
            }
            if (p_FramesToWrite <= 0) {
                return 0;
            }
            while (p_FramesToWrite > 0) {
                Object object = this.m_SyncObject;
                synchronized (object) {
                    if (s_SoundBuffer_Mixers.getSoundMixerCount() <= 0) {
                        return -1;
                    }
                    intFramesToWrite = p_FramesToWrite;
                    if (this.m_IndexFrame_Write + intFramesToWrite > this.m_DoubleBuffer_FramesBuffered) {
                        intFramesToWrite = this.m_DoubleBuffer_FramesBuffered - this.m_IndexFrame_Write;
                    }
                    if (!(this.m_DoubleBuffer_FramesBuffered - this.m_FramesFilled >= intFramesToWrite || this.m_Closed || this.m_StoppedDrain || this.m_Stopped)) {
                        try {
                            this.m_SyncObject.wait();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                if (this.m_Closed || this.m_StoppedDrain || this.m_Stopped) {
                    return intFramesWritten;
                }
                if (this.m_DoubleBuffer_FramesBuffered - this.m_FramesFilled < intFramesToWrite) continue;
                System.arraycopy(p_Values, intFrameSourceOffset * SOUND_SOUNDLINES_COUNT, this.m_DoubleBuffer.array(), this.m_IndexFrame_Write * SOUND_SOUNDLINES_COUNT, intFramesToWrite * SOUND_SOUNDLINES_COUNT);
                object = this.m_SyncObject;
                synchronized (object) {
                    intFramesWritten += intFramesToWrite;
                    this.m_FramesFilled += intFramesToWrite;
                    p_FramesToWrite -= intFramesToWrite;
                    intFrameSourceOffset += intFramesToWrite;
                    this.m_IndexFrame_Write += intFramesToWrite;
                    if (this.m_IndexFrame_Write >= this.m_DoubleBuffer_FramesBuffered) {
                        this.m_IndexFrame_Write -= this.m_DoubleBuffer_FramesBuffered;
                    }
                    if (this.m_FramesFilled >= BUFFERSIZE_FRAMES_MIXER) {
                        this.m_SyncObject.notifyAll();
                    }
                }
            }
            return intFramesWritten;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int readFrames(double[] p_Framerray_Mixers) {
            if (p_Framerray_Mixers == null) {
                return 0;
            }
            int intFramesToRead = p_Framerray_Mixers.length / SOUND_SOUNDLINES_COUNT;
            Object object = this.m_SyncObject;
            synchronized (object) {
                while (!(this.m_FramesFilled >= intFramesToRead || this.m_Closed || this.m_Stopped || this.m_StoppedDrain)) {
                    try {
                        this.m_SyncObject.wait();
                    }
                    catch (Exception exception) {}
                }
            }
            if (this.m_Closed || this.m_Stopped) {
                return 0;
            }
            if (this.m_StoppedDrain) {
                this.m_StoppedDrain = false;
                this.m_Stopped = true;
                return 0;
            }
            for (int intFrame = 0; intFrame < intFramesToRead; ++intFrame) {
                if (this.m_IndexFrame_Read >= this.m_DoubleBuffer_FramesBuffered) {
                    this.m_IndexFrame_Read = 0;
                }
                for (int intLine = 0; intLine < SOUND_SOUNDLINES_COUNT; ++intLine) {
                    int n = intFrame * SOUND_SOUNDLINES_COUNT + intLine;
                    p_Framerray_Mixers[n] = p_Framerray_Mixers[n] + this.m_DoubleBuffer.array()[this.m_IndexFrame_Read * SOUND_SOUNDLINES_COUNT + intLine];
                }
                ++this.m_IndexFrame_Read;
            }
            Object object2 = this.m_SyncObject;
            synchronized (object2) {
                this.m_FramesFilled -= intFramesToRead;
                if (this.m_StoppedDrain) {
                    this.m_SyncObject.notifyAll();
                } else {
                    this.m_SyncObject.notifyAll();
                }
            }
            return intFramesToRead;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            int intValuesCount;
            Object object = this.m_SyncObject;
            synchronized (object) {
                this.m_FramesFilled = 0;
                this.m_IndexFrame_Read = 0;
                this.m_IndexFrame_Write = 0;
            }
            int intValuesToFill = intValuesCount = this.m_DoubleBuffer.capacity();
            while (intValuesCount > 0) {
                if (intValuesToFill > EMPTY_VALUES.length) {
                    intValuesToFill = EMPTY_VALUES.length;
                }
                System.arraycopy(EMPTY_VALUES, 0, this.m_DoubleBuffer.array(), this.m_DoubleBuffer.capacity() - intValuesCount, intValuesToFill);
                intValuesToFill = intValuesCount -= intValuesToFill;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopAndDrain() {
            s_SoundBuffer_Mixers.removeSoundBuffer_Player(this);
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_StoppedDrain) {
                    return;
                }
                this.m_Stopped = false;
                this.m_StoppedDrain = true;
                this.m_Started = false;
                this.m_SyncObject.notifyAll();
            }
            this.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_Stopped) {
                    return;
                }
                this.m_Stopped = true;
                this.m_StoppedDrain = false;
                this.m_Started = false;
                this.m_SyncObject.notifyAll();
            }
            s_SoundBuffer_Mixers.removeSoundBuffer_Player(this);
            this.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            if (this.m_Started) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_Started) {
                    return;
                }
                this.clear();
                this.m_Started = true;
                this.m_Stopped = false;
                this.m_StoppedDrain = false;
                s_SoundBuffer_Mixers.addSoundBuffer_Player(this);
                this.m_SyncObject.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startSynchronized() {
            if (this.m_Started) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_Started) {
                    return;
                }
                int intFramesInLine = 0;
                SoundMixer o_SoundMixer = s_SoundBuffer_Mixers.getSoundMixer(0);
                if (o_SoundMixer != null) {
                    intFramesInLine = o_SoundMixer.getFramesInLine();
                    this.m_StartedSynchronized = true;
                }
                this.m_FramesInLine = intFramesInLine;
                this.clear();
                this.m_Started = true;
                this.m_Stopped = false;
                this.m_StoppedDrain = false;
                s_SoundBuffer_Mixers.addSoundBuffer_Player(this);
                this.m_SyncObject.notifyAll();
            }
        }
    }

    public static class SoundLineFactor
    implements Externalizable {
        public static final int SOFTWAREVERSION = 1;
        private int m_Channel;
        private int m_SoundLineNumber;
        private double m_VolumeFactor;

        public SoundLineFactor() {
            this.initMembers();
        }

        public SoundLineFactor(int p_Channel, int p_SoundLineNumber, double p_VolumeFactor) {
            this.initMembers();
            this.m_Channel = p_Channel;
            this.m_SoundLineNumber = p_SoundLineNumber;
            this.m_VolumeFactor = p_VolumeFactor;
        }

        private void initMembers() {
            this.m_SoundLineNumber = -1;
            this.m_VolumeFactor = 0.0;
        }

        public void setChannel(int p_Channel) {
            this.m_Channel = p_Channel;
        }

        public int getChannel() {
            return this.m_Channel;
        }

        public void setSoundLineNumber(int p_SoundLineNumber) {
            if (p_SoundLineNumber < 0) {
                return;
            }
            this.m_SoundLineNumber = p_SoundLineNumber;
        }

        public int getSoundLineNumber() {
            return this.m_SoundLineNumber;
        }

        public boolean setVolumeFactor(double p_VolumeFactor) {
            if (this.m_VolumeFactor == p_VolumeFactor) {
                return false;
            }
            this.m_VolumeFactor = p_VolumeFactor;
            return true;
        }

        public double getVolumeFactor() {
            return this.m_VolumeFactor;
        }

        public boolean equals(SoundLineFactor p_SoundLineFactor_Dest) {
            if (p_SoundLineFactor_Dest == null) {
                return false;
            }
            if (this.m_Channel != p_SoundLineFactor_Dest.getChannel()) {
                return false;
            }
            if (this.m_SoundLineNumber != p_SoundLineFactor_Dest.getSoundLineNumber()) {
                return false;
            }
            return this.m_VolumeFactor == p_SoundLineFactor_Dest.getVolumeFactor();
        }

        public SoundLineFactor copy(SoundLineFactor p_SoundLineFactor_Dest) {
            if (p_SoundLineFactor_Dest == null) {
                p_SoundLineFactor_Dest = new SoundLineFactor(this.m_Channel, this.m_SoundLineNumber, this.m_VolumeFactor);
                return p_SoundLineFactor_Dest;
            }
            p_SoundLineFactor_Dest.setChannel(this.m_Channel);
            p_SoundLineFactor_Dest.setSoundLineNumber(this.m_SoundLineNumber);
            p_SoundLineFactor_Dest.setVolumeFactor(this.m_VolumeFactor);
            return p_SoundLineFactor_Dest;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(1);
            out.writeInt(this.m_Channel);
            out.writeInt(this.m_SoundLineNumber);
            out.writeDouble(this.m_VolumeFactor);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int intSoftwareVersion = in.readInt();
            this.m_Channel = in.readInt();
            this.m_SoundLineNumber = in.readInt();
            this.m_VolumeFactor = in.readDouble();
        }
    }

    public static class Sound_Channel_Lines
    implements Externalizable {
        public static final int SOFTWAREVERSION = 1;
        private Sound_Lines m_Sound_Lines;
        private int m_Channel;
        private ArrayList<SoundLineFactor> m_SoundLineFactors;
        private int m_ChannelDelay_ms;
        private int m_ChannelDelay_Frames;
        private final Object m_SyncObject = new Object();

        public Sound_Channel_Lines(Sound_Lines p_Sound_Lines) {
            this.initMembers();
            this.m_Sound_Lines = p_Sound_Lines;
        }

        public Sound_Channel_Lines(Sound_Lines p_Sound_Lines, int p_ParentChannel) {
            this.initMembers();
            this.m_Sound_Lines = p_Sound_Lines;
            this.m_Channel = p_ParentChannel;
        }

        private void initMembers() {
            this.m_Sound_Lines = null;
            this.m_Channel = -1;
            this.m_SoundLineFactors = new ArrayList();
            this.m_ChannelDelay_ms = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.m_SyncObject;
            synchronized (object) {
                this.m_SoundLineFactors.clear();
                this.m_Channel = -1;
            }
        }

        public int getChannel() {
            return this.m_Channel;
        }

        public void setChannel(int p_Channel) {
            this.m_Channel = p_Channel;
        }

        public void setChannelDelay(int p_Milliseconds) {
            if (p_Milliseconds < 0) {
                p_Milliseconds = 0;
            }
            if (p_Milliseconds > DELAY_MAX_MILLISECONDS - 1) {
                p_Milliseconds = DELAY_MAX_MILLISECONDS - 1;
            }
            this.m_ChannelDelay_ms = p_Milliseconds;
            this.m_ChannelDelay_Frames = (int)((float)p_Milliseconds * this.m_Sound_Lines.getParentFramerate() / 1000.0f);
        }

        public int getChannelDelay() {
            return this.m_ChannelDelay_ms;
        }

        public int getChannelDelay_Frames() {
            return this.m_ChannelDelay_Frames;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addSoundLineFactor(int p_SoundLineNumber, double p_VolumeFactor) {
            if (p_SoundLineNumber < 0) {
                return false;
            }
            if (p_SoundLineNumber > SOUND_SOUNDLINES_COUNT) {
                return false;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                SoundLineFactor o_SoundLineFactor = null;
                for (int intIndex = 0; intIndex < this.m_SoundLineFactors.size(); ++intIndex) {
                    o_SoundLineFactor = this.m_SoundLineFactors.get(intIndex);
                    if (o_SoundLineFactor == null || o_SoundLineFactor.getSoundLineNumber() != p_SoundLineNumber) continue;
                    o_SoundLineFactor.setVolumeFactor(p_VolumeFactor);
                    return false;
                }
                o_SoundLineFactor = new SoundLineFactor(this.m_Channel, p_SoundLineNumber, p_VolumeFactor);
                this.m_SoundLineFactors.add(o_SoundLineFactor);
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeSoundLineFactor(int p_SoundLineNumber) {
            if (p_SoundLineNumber < 0) {
                return false;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                SoundLineFactor o_SoundLineFactor = null;
                for (int intIndex = 0; intIndex < this.m_SoundLineFactors.size(); ++intIndex) {
                    o_SoundLineFactor = this.m_SoundLineFactors.get(intIndex);
                    if (o_SoundLineFactor == null || o_SoundLineFactor.getSoundLineNumber() != p_SoundLineNumber) continue;
                    this.m_SoundLineFactors.remove(intIndex);
                    return true;
                }
                return false;
            }
        }

        public int getSoundLineFactorsCount() {
            return this.m_SoundLineFactors.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SoundLineFactor getSoundLineFactor(int p_SoundLineNumber) {
            if (p_SoundLineNumber < 0) {
                return null;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                for (int intIndex = 0; intIndex < this.m_SoundLineFactors.size(); ++intIndex) {
                    SoundLineFactor o_SoundLineFactor = this.m_SoundLineFactors.get(intIndex);
                    if (o_SoundLineFactor == null || o_SoundLineFactor.getSoundLineNumber() != p_SoundLineNumber) continue;
                    return o_SoundLineFactor;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SoundLineFactor getSoundLineFactorByIndex(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_Index >= this.m_SoundLineFactors.size()) {
                    return null;
                }
                return this.m_SoundLineFactors.get(p_Index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Sound_Channel_Lines p_Sound_Channel_Lines_Dest) {
            if (p_Sound_Channel_Lines_Dest == null) {
                return false;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_Channel != p_Sound_Channel_Lines_Dest.getChannel()) {
                    return false;
                }
                if (this.m_ChannelDelay_ms != p_Sound_Channel_Lines_Dest.getChannelDelay()) {
                    return false;
                }
                if (this.m_SoundLineFactors.size() != p_Sound_Channel_Lines_Dest.getSoundLineFactorsCount()) {
                    return false;
                }
                for (int intSoundLineFactor = 0; intSoundLineFactor < this.m_SoundLineFactors.size(); ++intSoundLineFactor) {
                    SoundLineFactor o_SoundLineFactor = this.m_SoundLineFactors.get(intSoundLineFactor);
                    SoundLineFactor o_SoundLineFactor_Dest = p_Sound_Channel_Lines_Dest.getSoundLineFactor(o_SoundLineFactor.getSoundLineNumber());
                    if (o_SoundLineFactor_Dest == null) {
                        return false;
                    }
                    if (o_SoundLineFactor.getVolumeFactor() == o_SoundLineFactor_Dest.getVolumeFactor()) continue;
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(1);
            Object object = this.m_SyncObject;
            synchronized (object) {
                out.writeInt(this.m_Channel);
                out.writeInt(this.m_ChannelDelay_ms);
                out.writeInt(this.m_SoundLineFactors.size());
                for (int intSoundLineFactor = 0; intSoundLineFactor < this.m_SoundLineFactors.size(); ++intSoundLineFactor) {
                    SoundLineFactor o_SoundLineFactor = this.m_SoundLineFactors.get(intSoundLineFactor);
                    o_SoundLineFactor.writeExternal(out);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int intSoftwareVersion = in.readInt();
            Object object = this.m_SyncObject;
            synchronized (object) {
                this.m_SoundLineFactors.clear();
                this.m_Channel = in.readInt();
                this.setChannelDelay(in.readInt());
                int intSoundLineFactors_Count = in.readInt();
                for (int intFactor = 0; intFactor < intSoundLineFactors_Count; ++intFactor) {
                    SoundLineFactor o_SoundLineFactor = new SoundLineFactor();
                    o_SoundLineFactor.readExternal(in);
                    if (o_SoundLineFactor.getSoundLineNumber() < 0 || o_SoundLineFactor.getSoundLineNumber() >= SOUND_SOUNDLINES_COUNT) continue;
                    this.m_SoundLineFactors.add(o_SoundLineFactor);
                }
            }
        }
    }

    public static class Sound_Lines
    implements Externalizable {
        public static final int SOFTWAREVERSION = 1;
        private String m_ParentType;
        private int m_ParentChannelCount;
        private float m_ParentFrameRate;
        private HashMap<Integer, Sound_Channel_Lines> m_Sound_Channels_lines;
        private ArrayList<SoundLineFactor> m_RemovedSoundLineFactors;
        private final Object m_SyncObject = new Object();

        public Sound_Lines() {
            this.initMembers();
        }

        private void initMembers() {
            this.m_ParentType = "";
            this.m_ParentChannelCount = 0;
            this.m_ParentFrameRate = DEFAULT_AUDIOFORMAT.getFrameRate();
            this.m_Sound_Channels_lines = new HashMap();
            this.m_RemovedSoundLineFactors = new ArrayList();
        }

        public void close() {
            this.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.m_SyncObject;
            synchronized (object) {
                Iterator<Integer> iteratorChannel = this.m_Sound_Channels_lines.keySet().iterator();
                while (iteratorChannel.hasNext()) {
                    int intChannel = iteratorChannel.next();
                    Sound_Channel_Lines o_Sound_Channel_Lines = this.m_Sound_Channels_lines.get(intChannel);
                    if (o_Sound_Channel_Lines == null) continue;
                    o_Sound_Channel_Lines.clear();
                    iteratorChannel.remove();
                }
            }
        }

        public String getParentType() {
            return this.m_ParentType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setParentType(String p_ParentType) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                this.m_ParentType = p_ParentType;
            }
        }

        public void setParentChannelCount(int p_ParentChannelCount) {
            this.m_ParentChannelCount = p_ParentChannelCount;
        }

        public int getParentChannelCount() {
            return this.m_ParentChannelCount;
        }

        public void setParentFrameRate(float p_FrameRate) {
            this.m_ParentFrameRate = p_FrameRate;
        }

        public float getParentFramerate() {
            return this.m_ParentFrameRate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addSoundLineFactor(int p_MixerChannel, int p_SoundLineNumber, double p_VolumeFactor, boolean p_ProofChannel) {
            if (p_MixerChannel < 0) {
                return false;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_ProofChannel && p_MixerChannel >= this.getParentChannelCount()) {
                    return false;
                }
                if (p_SoundLineNumber < 0) {
                    return false;
                }
                if (p_SoundLineNumber >= SOUND_SOUNDLINES_COUNT) {
                    return false;
                }
                Sound_Channel_Lines o_Sound_Channel_Lines = this.m_Sound_Channels_lines.get(p_MixerChannel);
                if (o_Sound_Channel_Lines != null) {
                    o_Sound_Channel_Lines.addSoundLineFactor(p_SoundLineNumber, p_VolumeFactor);
                    return false;
                }
                o_Sound_Channel_Lines = new Sound_Channel_Lines(this, p_MixerChannel);
                o_Sound_Channel_Lines.addSoundLineFactor(p_SoundLineNumber, p_VolumeFactor);
                this.m_Sound_Channels_lines.put(p_MixerChannel, o_Sound_Channel_Lines);
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeSoundLineFactor(int p_MixerChannel, int p_SoundLineNumber) {
            if (p_MixerChannel < 0) {
                return false;
            }
            boolean boolRemoved = false;
            Object object = this.m_SyncObject;
            synchronized (object) {
                Sound_Channel_Lines o_Sound_Channel_Lines = this.m_Sound_Channels_lines.get(p_MixerChannel);
                if (o_Sound_Channel_Lines == null) {
                    return false;
                }
                SoundLineFactor o_SoundLineFactor = o_Sound_Channel_Lines.getSoundLineFactor(p_SoundLineNumber);
                if (o_SoundLineFactor == null) {
                    return false;
                }
                this.keepRemovedSoundLineFactor(o_SoundLineFactor);
                boolRemoved = o_Sound_Channel_Lines.removeSoundLineFactor(p_SoundLineNumber);
                if (o_Sound_Channel_Lines.getSoundLineFactorsCount() == 0) {
                    this.m_Sound_Channels_lines.remove(p_MixerChannel);
                }
            }
            return boolRemoved;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void keepRemovedSoundLineFactor(SoundLineFactor p_SoundLineFactor) {
            if (p_SoundLineFactor == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                SoundLineFactor o_SoundLineFactor = this.getRemovedSoundLineFactor(p_SoundLineFactor.getChannel(), p_SoundLineFactor.getSoundLineNumber());
                if (o_SoundLineFactor != null) {
                    o_SoundLineFactor.setVolumeFactor(p_SoundLineFactor.getVolumeFactor());
                    return;
                }
                this.m_RemovedSoundLineFactors.add(p_SoundLineFactor.copy(null));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SoundLineFactor getRemovedSoundLineFactor(int p_MixerChannel, int p_SoundLineNumber) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                for (int intFactor = 0; intFactor < this.m_RemovedSoundLineFactors.size(); ++intFactor) {
                    SoundLineFactor o_SoundLineFactor = this.m_RemovedSoundLineFactors.get(intFactor);
                    if (o_SoundLineFactor.getChannel() != p_MixerChannel || o_SoundLineFactor.getSoundLineNumber() != p_SoundLineNumber) continue;
                    this.m_RemovedSoundLineFactors.remove(intFactor);
                    return o_SoundLineFactor;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void checkSoundLines() {
            Object object = this.m_SyncObject;
            synchronized (object) {
                Iterator<Integer> iteratorChannel = this.m_Sound_Channels_lines.keySet().iterator();
                while (iteratorChannel.hasNext()) {
                    int intChannel = iteratorChannel.next();
                    Sound_Channel_Lines o_Sound_Channel_Lines = this.m_Sound_Channels_lines.get(intChannel);
                    if (o_Sound_Channel_Lines == null) continue;
                    if (intChannel >= this.getParentChannelCount()) {
                        iteratorChannel.remove();
                        continue;
                    }
                    for (int intIndex = 0; intIndex < o_Sound_Channel_Lines.getSoundLineFactorsCount(); ++intIndex) {
                        SoundLineFactor o_SoundLineFactor = o_Sound_Channel_Lines.getSoundLineFactorByIndex(intIndex);
                        if (o_SoundLineFactor == null || o_SoundLineFactor.getSoundLineNumber() >= 0 && o_SoundLineFactor.getSoundLineNumber() < SOUND_SOUNDLINES_COUNT) continue;
                        o_Sound_Channel_Lines.removeSoundLineFactor(o_SoundLineFactor.getSoundLineNumber());
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeSound_Channel_Lines(int p_MixerChannel) {
            if (p_MixerChannel < 0) {
                return false;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                Sound_Channel_Lines o_Sound_Channel_Lines = this.m_Sound_Channels_lines.get(p_MixerChannel);
                if (o_Sound_Channel_Lines == null) {
                    return false;
                }
                this.m_Sound_Channels_lines.remove(p_MixerChannel);
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Sound_Channel_Lines getSound_Channel_Lines(int p_Channel) {
            Sound_Channel_Lines o_Sound_Channel_Lines;
            if (p_Channel < 0) {
                return null;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                o_Sound_Channel_Lines = this.m_Sound_Channels_lines.get(p_Channel);
            }
            return o_Sound_Channel_Lines;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setChannelDelay_ms(int p_Channel, int p_Milliseconds) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                Sound_Channel_Lines o_Sound_Channel_Lines = this.m_Sound_Channels_lines.get(p_Channel);
                if (o_Sound_Channel_Lines == null) {
                    return;
                }
                o_Sound_Channel_Lines.setChannelDelay(p_Milliseconds);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getChannelDelay_ms(int p_Channel) {
            Sound_Channel_Lines o_Sound_Channel_Lines;
            Object object = this.m_SyncObject;
            synchronized (object) {
                o_Sound_Channel_Lines = this.m_Sound_Channels_lines.get(p_Channel);
                if (o_Sound_Channel_Lines == null) {
                    return 0;
                }
            }
            return o_Sound_Channel_Lines.getChannelDelay();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getChannelDelay_Frames(int p_Channel) {
            Sound_Channel_Lines o_Sound_Channel_Lines;
            Object object = this.m_SyncObject;
            synchronized (object) {
                o_Sound_Channel_Lines = this.m_Sound_Channels_lines.get(p_Channel);
                if (o_Sound_Channel_Lines == null) {
                    return 0;
                }
            }
            return o_Sound_Channel_Lines.getChannelDelay_Frames();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SoundLineFactor getSoundLineFactor(int p_MixerChannel, int p_SoundLineNumber) {
            if (p_MixerChannel < 0) {
                return null;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_MixerChannel >= this.getParentChannelCount()) {
                    return null;
                }
                if (p_SoundLineNumber < 0) {
                    return null;
                }
                if (p_SoundLineNumber >= SOUND_SOUNDLINES_COUNT) {
                    return null;
                }
                Sound_Channel_Lines o_Sound_Channel_Lines = this.m_Sound_Channels_lines.get(p_MixerChannel);
                if (o_Sound_Channel_Lines == null) {
                    return null;
                }
                return o_Sound_Channel_Lines.getSoundLineFactor(p_SoundLineNumber);
            }
        }

        public int getSound_Channels() {
            return this.m_Sound_Channels_lines.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getSound_Channel_LinesCount(int p_MixerChannel) {
            if (p_MixerChannel < 0) {
                return 0;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_MixerChannel >= this.getParentChannelCount()) {
                    return 0;
                }
                Sound_Channel_Lines o_Sound_Channel_Lines = this.m_Sound_Channels_lines.get(p_MixerChannel);
                if (o_Sound_Channel_Lines == null) {
                    return 0;
                }
                return o_Sound_Channel_Lines.getSoundLineFactorsCount();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SoundLineFactor getSoundLineFactorByIndex(int p_MixerChannel, int p_SoundLine_Index) {
            if (p_MixerChannel < 0) {
                return null;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_MixerChannel >= this.getParentChannelCount()) {
                    return null;
                }
                Sound_Channel_Lines o_Sound_Channel_Lines = this.m_Sound_Channels_lines.get(p_MixerChannel);
                if (o_Sound_Channel_Lines == null) {
                    return null;
                }
                return o_Sound_Channel_Lines.getSoundLineFactorByIndex(p_SoundLine_Index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Sound_Lines copyTo(Sound_Lines p_DestSound_Lines_Dest) {
            if (p_DestSound_Lines_Dest == null) {
                p_DestSound_Lines_Dest = new Sound_Lines();
            }
            if (this.equals(p_DestSound_Lines_Dest)) {
                return p_DestSound_Lines_Dest;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                p_DestSound_Lines_Dest.clear();
                p_DestSound_Lines_Dest.setParentType(this.m_ParentType);
                p_DestSound_Lines_Dest.setParentChannelCount(this.m_ParentChannelCount);
                for (int intChannel : this.m_Sound_Channels_lines.keySet()) {
                    Sound_Channel_Lines o_Sound_Channel_Lines = this.getSound_Channel_Lines(intChannel);
                    if (o_Sound_Channel_Lines == null) continue;
                    for (int intSoundLineFactor = 0; intSoundLineFactor < o_Sound_Channel_Lines.getSoundLineFactorsCount(); ++intSoundLineFactor) {
                        SoundLineFactor o_SoundLineFactor = o_Sound_Channel_Lines.getSoundLineFactorByIndex(intSoundLineFactor);
                        p_DestSound_Lines_Dest.addSoundLineFactor(intChannel, o_SoundLineFactor.getSoundLineNumber(), o_SoundLineFactor.getVolumeFactor(), false);
                    }
                    Sound_Channel_Lines o_Sound_Channel_Lines_Dest = p_DestSound_Lines_Dest.getSound_Channel_Lines(intChannel);
                    if (o_Sound_Channel_Lines_Dest == null) continue;
                    o_Sound_Channel_Lines_Dest.setChannelDelay(o_Sound_Channel_Lines.getChannelDelay());
                }
            }
            return p_DestSound_Lines_Dest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Sound_Lines p_Sound_Lines_Dest) {
            if (p_Sound_Lines_Dest == null) {
                return false;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_Sound_Channels_lines.size() != p_Sound_Lines_Dest.getSound_Channels()) {
                    return false;
                }
                if (!this.m_ParentType.equals(p_Sound_Lines_Dest.getParentType())) {
                    return false;
                }
                for (int intChannel : this.m_Sound_Channels_lines.keySet()) {
                    Sound_Channel_Lines o_Sound_Channel_Lines = this.m_Sound_Channels_lines.get(intChannel);
                    Sound_Channel_Lines o_Sound_Channel_Lines_Dest = p_Sound_Lines_Dest.getSound_Channel_Lines(intChannel);
                    if (o_Sound_Channel_Lines_Dest == null) {
                        return false;
                    }
                    if (o_Sound_Channel_Lines.equals(o_Sound_Channel_Lines_Dest)) continue;
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equalsUsedChannels(Sound_Lines p_Sound_Lines_Dest) {
            if (p_Sound_Lines_Dest == null) {
                return true;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_Sound_Channels_lines.size() != p_Sound_Lines_Dest.getSound_Channels()) {
                    return false;
                }
                for (int intChannel : this.m_Sound_Channels_lines.keySet()) {
                    Sound_Channel_Lines o_Sound_Channel_Lines = this.m_Sound_Channels_lines.get(intChannel);
                    Sound_Channel_Lines o_Sound_Channel_Lines_Dest = p_Sound_Lines_Dest.getSound_Channel_Lines(intChannel);
                    if (o_Sound_Channel_Lines_Dest == null) {
                        return false;
                    }
                    if (o_Sound_Channel_Lines.getSoundLineFactorsCount() > 0 && o_Sound_Channel_Lines_Dest.getSoundLineFactorsCount() <= 0) {
                        return false;
                    }
                    if (o_Sound_Channel_Lines.getSoundLineFactorsCount() > 0 || o_Sound_Channel_Lines_Dest.getSoundLineFactorsCount() <= 0) continue;
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            Object object = this.m_SyncObject;
            synchronized (object) {
                out.writeInt(1);
                out.writeUTF(this.m_ParentType);
                out.writeInt(this.getParentChannelCount());
                out.writeInt(this.m_Sound_Channels_lines.size());
                for (int intChannel : this.m_Sound_Channels_lines.keySet()) {
                    Sound_Channel_Lines o_Sound_Channel_Lines = this.m_Sound_Channels_lines.get(intChannel);
                    o_Sound_Channel_Lines.writeExternal(out);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int intSoftwareVersion = in.readInt();
            this.clear();
            Object object = this.m_SyncObject;
            synchronized (object) {
                this.m_ParentType = in.readUTF();
                this.m_ParentChannelCount = in.readInt();
                int intSound_Channel_LinesCount = in.readInt();
                for (int intSoundChannelLine = 0; intSoundChannelLine < intSound_Channel_LinesCount; ++intSoundChannelLine) {
                    Sound_Channel_Lines o_Sound_Channel_Lines = new Sound_Channel_Lines(this);
                    o_Sound_Channel_Lines.readExternal(in);
                    this.m_Sound_Channels_lines.put(o_Sound_Channel_Lines.getChannel(), o_Sound_Channel_Lines);
                }
            }
        }
    }

    public static interface Sound_Lines_Parent {
        public static final String PARENTTYPE_SOUNDOBJECT = "SoundObject";
        public static final String PARENTTYPE_SOUNDMIXER = "SoundMixer";
        public static final String PARENTTYPE_TRACHBOUNCING = "SoundTrachbouncing";

        public Sound_Lines getSound_Lines();

        public String getName();

        public String getSourceName();

        public boolean addSoundLineFactor(int var1, int var2, double var3, boolean var5);

        public boolean removeSoundLineFactor(int var1, int var2);
    }

    public static class DelayBuffer {
        private SoundMixer m_SoundMixer;
        private AudioFormat m_AudioFormat;
        private int m_Channels;
        private int m_Delay_MaxFrames;
        private ArrayList<DoubleBuffer> m_ChannelDelayBuffers;
        private ArrayList<Integer> m_ChannelsDelay_PositionWrite;
        private ArrayList<Integer> m_ChannelsDelay_PositionRead;
        private DoubleBuffer m_EmptyChannelBuffer;
        private final Object m_SyncObject = new Object();
        public int intLoop = 0;

        public DelayBuffer(SoundMixer p_SoundMixer, AudioFormat p_AudioFormat) {
            this.initMembers();
            this.m_SoundMixer = p_SoundMixer;
            this.setAudioFormat(p_SoundMixer.getAudioFormat());
        }

        private void initMembers() {
            this.m_SoundMixer = null;
            this.m_ChannelDelayBuffers = new ArrayList();
            this.m_ChannelsDelay_PositionWrite = new ArrayList();
            this.m_ChannelsDelay_PositionRead = new ArrayList();
            this.m_EmptyChannelBuffer = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.m_SyncObject;
            synchronized (object) {
                this.m_AudioFormat = null;
                this.m_Channels = 0;
                this.m_SoundMixer = null;
                this.m_ChannelDelayBuffers.clear();
                this.m_ChannelsDelay_PositionWrite.clear();
                this.m_ChannelsDelay_PositionRead.clear();
            }
        }

        private void setAudioFormat(AudioFormat p_AudioFormat) {
            if (p_AudioFormat == null) {
                return;
            }
            this.m_Channels = p_AudioFormat.getChannels();
            this.m_AudioFormat = p_AudioFormat;
            this.m_Delay_MaxFrames = (int)((double)((float)DELAY_MAX_MILLISECONDS * this.m_AudioFormat.getFrameRate()) / 1000.0);
            this.m_ChannelDelayBuffers.clear();
            this.m_ChannelsDelay_PositionWrite.clear();
            this.m_ChannelsDelay_PositionRead.clear();
            for (int intChannel = 0; intChannel < this.m_Channels; ++intChannel) {
                DoubleBuffer o_ChannelDelayBuffer = DoubleBuffer.allocate(this.m_Delay_MaxFrames);
                this.m_ChannelDelayBuffers.add(o_ChannelDelayBuffer);
                this.m_ChannelsDelay_PositionWrite.add(0);
                this.m_ChannelsDelay_PositionRead.add(0);
            }
            this.m_EmptyChannelBuffer = DoubleBuffer.allocate(this.m_Delay_MaxFrames);
            for (int intFrame = 0; intFrame < this.m_Delay_MaxFrames; ++intFrame) {
                this.m_EmptyChannelBuffer.put(intFrame, 0.0);
            }
            this.reset();
        }

        public int getChannelDelayFrames(int p_Channel) {
            if (this.m_SoundMixer == null) {
                return 0;
            }
            return this.m_SoundMixer.getChannelDelay_Frames(p_Channel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putFrameValue(int p_Channel, double p_Value) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_SoundMixer == null) {
                    return;
                }
            }
            if (p_Channel < 0) {
                return;
            }
            if (p_Channel >= this.m_Channels) {
                return;
            }
            int intPositionWrite = this.m_ChannelsDelay_PositionWrite.get(p_Channel);
            int intWriteIndex = intPositionWrite + this.m_SoundMixer.getChannelDelay_Frames(p_Channel);
            if (intWriteIndex >= this.m_Delay_MaxFrames) {
                intWriteIndex -= this.m_Delay_MaxFrames;
            }
            DoubleBuffer o_DoubleBufferChannel = this.m_ChannelDelayBuffers.get(p_Channel);
            o_DoubleBufferChannel.put(intWriteIndex, p_Value);
            if (++intPositionWrite >= this.m_Delay_MaxFrames) {
                intPositionWrite = 0;
            }
            this.m_ChannelsDelay_PositionWrite.set(p_Channel, intPositionWrite);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double getFrameValue(int p_Channel) {
            double doubleValue = 0.0;
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_SoundMixer == null) {
                    return 0.0;
                }
            }
            if (p_Channel < 0) {
                return 0.0;
            }
            if (p_Channel >= this.m_Channels) {
                return 0.0;
            }
            int intPositionRead = this.m_ChannelsDelay_PositionRead.get(p_Channel);
            DoubleBuffer o_ChannelDelayBuffer = this.m_ChannelDelayBuffers.get(p_Channel);
            doubleValue = o_ChannelDelayBuffer.get(intPositionRead);
            o_ChannelDelayBuffer.put(intPositionRead, 0.0);
            if (++intPositionRead >= this.m_Delay_MaxFrames) {
                intPositionRead = 0;
            }
            this.m_ChannelsDelay_PositionRead.set(p_Channel, intPositionRead);
            return doubleValue;
        }

        public void start() {
        }

        public void stop() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean writeDelayRest(ByteBuffer p_ByteBuffer) {
            SoundMixer o_SoundMixer;
            int intPositionRead = 0;
            int intPositionWrite = 0;
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_SoundMixer == null) {
                    return true;
                }
                o_SoundMixer = this.m_SoundMixer;
            }
            boolean boolReady = true;
            int intBufferedFrames = p_ByteBuffer.capacity() / this.m_AudioFormat.getFrameSize();
            int intByteOffset = 0;
            for (int intFrame = 0; intFrame < intBufferedFrames; ++intFrame) {
                block9: for (int intChannel = 0; intChannel < this.m_Channels; ++intChannel) {
                    double doubleValue;
                    intPositionRead = this.m_ChannelsDelay_PositionRead.get(intChannel);
                    intPositionWrite = this.m_ChannelsDelay_PositionWrite.get(intChannel) + o_SoundMixer.getChannelDelay_Frames(intChannel);
                    if (intPositionWrite >= this.m_Delay_MaxFrames) {
                        intPositionWrite -= this.m_Delay_MaxFrames;
                    }
                    if (intPositionRead == intPositionWrite) {
                        doubleValue = 0.0;
                    } else {
                        boolReady = false;
                        doubleValue = this.getFrameValue(intChannel);
                    }
                    switch (this.m_AudioFormat.getSampleSizeInBits()) {
                        case 16: {
                            short shortValue = (short)(doubleValue *= 32767.0);
                            p_ByteBuffer.putShort(intByteOffset, shortValue);
                            intByteOffset += 2;
                            continue block9;
                        }
                        case 24: {
                            int intValue = (int)(doubleValue *= 2.147483647E9);
                            if (this.m_AudioFormat.isBigEndian()) {
                                p_ByteBuffer.put(intByteOffset, (byte)(intValue >> 24));
                                p_ByteBuffer.put(intByteOffset + 1, (byte)(intValue >> 16));
                                p_ByteBuffer.put(intByteOffset + 2, (byte)(intValue >> 8));
                            } else {
                                p_ByteBuffer.put(intByteOffset, (byte)(intValue >> 8));
                                p_ByteBuffer.put(intByteOffset + 1, (byte)(intValue >> 16));
                                p_ByteBuffer.put(intByteOffset + 2, (byte)(intValue >> 24));
                            }
                            intByteOffset += 3;
                            continue block9;
                        }
                        case 32: {
                            int intValue = (int)(doubleValue *= 2.147483647E9);
                            p_ByteBuffer.putInt(intByteOffset, intValue);
                            intByteOffset += 4;
                        }
                    }
                }
            }
            return boolReady;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_SoundMixer == null) {
                    return;
                }
            }
            for (int intChannel = 0; intChannel < this.m_Channels; ++intChannel) {
                DoubleBuffer o_ChannelDelayBuffer = this.m_ChannelDelayBuffers.get(intChannel);
                System.arraycopy(this.m_EmptyChannelBuffer.array(), 0, o_ChannelDelayBuffer.array(), 0, this.m_Delay_MaxFrames);
                this.m_ChannelsDelay_PositionWrite.set(intChannel, 0);
                this.m_ChannelsDelay_PositionRead.set(intChannel, 0);
            }
        }
    }

    public static abstract class SoundMixer
    implements Sound_Lines_Parent {
        public static final String SOUNDMIXERTTYPE_DIRECTSOUND = "DirectSound";
        public static final String SOUNDMIXERTTYPE_MME = "MME";
        public static final String PROP_ACTIVE = "propActive";
        protected String m_ID;
        protected String m_Name;
        protected String m_Description;
        protected String m_SoundMixerType;
        protected AudioFormat m_AudioFormat;
        protected Sound_Lines m_Sound_Lines;
        protected DelayBuffer m_DelayBuffer;
        protected int m_MaxBufferSize_Bytes;
        protected int m_Channels_Output;
        protected boolean m_Selected;
        protected boolean m_Closed;
        protected boolean m_ManuallyStarted;
        protected SinglePropertyChangeSupport m_PropertyChangeSupport;
        private final Object m_SyncMixer = new Object();

        public SoundMixer(String p_SoundMixerType, String p_ID, String p_Name, String p_Description, AudioFormat p_AudioFormat) {
            this.initMembers();
            this.m_SoundMixerType = p_SoundMixerType;
            this.m_ID = p_ID;
            this.m_Name = p_Name;
            this.m_Description = p_Description;
            this.m_AudioFormat = new AudioFormat(p_AudioFormat.getEncoding(), p_AudioFormat.getSampleRate(), p_AudioFormat.getSampleSizeInBits(), p_AudioFormat.getChannels(), p_AudioFormat.getFrameSize(), p_AudioFormat.getFrameRate(), p_AudioFormat.isBigEndian());
            this.m_Sound_Lines.setParentType("SoundMixer");
            this.m_Sound_Lines.setParentChannelCount(this.getChannels());
            this.m_Sound_Lines.setParentFrameRate(this.m_AudioFormat.getFrameRate());
            this.m_DelayBuffer = new DelayBuffer(this, this.m_AudioFormat);
            s_SoundMixerTableModel.addSoundMixer(this);
        }

        private void initMembers() {
            this.m_Closed = false;
            this.m_ID = "";
            this.m_Name = "";
            this.m_Description = "";
            this.m_SoundMixerType = "";
            this.m_MaxBufferSize_Bytes = 0;
            this.m_Channels_Output = 0;
            this.m_Sound_Lines = new Sound_Lines();
            this.m_Selected = false;
            this.m_PropertyChangeSupport = new SinglePropertyChangeSupport(this);
            this.m_ManuallyStarted = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean close() {
            Object object = this.m_SyncMixer;
            synchronized (object) {
                if (this.m_Closed) {
                    return false;
                }
                this.m_Closed = true;
            }
            s_SoundBuffer_Mixers.removeSoundMixer(this);
            s_SoundMixerTableModel.removeSoundMixer(this);
            this.m_DelayBuffer.close();
            return true;
        }

        public String getSoundMixerType() {
            return this.m_SoundMixerType;
        }

        public abstract boolean setActive(boolean var1, boolean var2);

        public abstract boolean getIsActive();

        public abstract boolean open();

        public abstract boolean start(boolean var1);

        public abstract boolean stop();

        public abstract boolean isRunning();

        public abstract int getFramesInLine();

        public abstract void writeFrames(double[] var1);

        public abstract boolean writeDelayRest();

        public abstract long getControllerStartTime();

        public void resetDelay() {
            this.m_DelayBuffer.reset();
        }

        public String getID() {
            return this.m_ID;
        }

        @Override
        public String getName() {
            return this.m_Name;
        }

        @Override
        public String getSourceName() {
            return this.m_SoundMixerType;
        }

        public void setDescription(String p_Description) {
            if (p_Description == null) {
                p_Description = "";
            }
            if (this.m_Description.equals(p_Description)) {
                return;
            }
            this.m_Description = p_Description;
            s_SoundMixerTableModel.changedSoundMixer(this);
        }

        public String getDescription() {
            return this.m_Description;
        }

        public AudioFormat getAudioFormat() {
            return this.m_AudioFormat;
        }

        public void setChannels_Output(int p_Channels) {
            if (this.m_Channels_Output == p_Channels) {
                return;
            }
            this.m_Channels_Output = p_Channels;
            s_SoundMixerTableModel.changedSoundMixer(this);
            this.m_Sound_Lines.setParentChannelCount(p_Channels);
        }

        public int getChannels() {
            return this.m_Channels_Output;
        }

        public void setSelected(boolean p_Selected) {
            if (this.m_Selected == p_Selected) {
                return;
            }
            if (this.m_Selected) {
                // empty if block
            }
            this.m_Selected = p_Selected;
            if (this.m_Selected) {
                // empty if block
            }
            s_SoundMixerTableModel.changedSoundMixer(this);
        }

        public boolean getSelected() {
            return this.m_Selected;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDefaultSoundLines() {
            Object object = this.m_SyncMixer;
            synchronized (object) {
                for (int intMixerChannel = 0; intMixerChannel < this.m_Channels_Output && intMixerChannel < SOUND_SOUNDLINES_COUNT; ++intMixerChannel) {
                    this.m_Sound_Lines.addSoundLineFactor(intMixerChannel, intMixerChannel, 1.0, true);
                }
            }
        }

        @Override
        public Sound_Lines getSound_Lines() {
            return this.m_Sound_Lines;
        }

        public int getSound_Channel_LinesCount(int p_MixerChannel) {
            return this.m_Sound_Lines.getSound_Channel_LinesCount(p_MixerChannel);
        }

        public void setChannelDelay_ms(int p_MixerChannel, int p_MIlliseconds) {
            this.m_Sound_Lines.setChannelDelay_ms(p_MixerChannel, p_MIlliseconds);
        }

        public int getChannelDelay_ms(int p_MixerChannel) {
            return this.m_Sound_Lines.getChannelDelay_ms(p_MixerChannel);
        }

        public int getChannelDelay_Frames(int p_MixerChannel) {
            return this.m_Sound_Lines.getChannelDelay_Frames(p_MixerChannel);
        }

        public SoundLineFactor getSoundLineFactorByIndex(int p_MixerChannel, int p_Index) {
            return this.m_Sound_Lines.getSoundLineFactorByIndex(p_MixerChannel, p_Index);
        }

        @Override
        public boolean addSoundLineFactor(int p_MixerChannel, int p_SoundLineNumber, double p_VolumeFactor, boolean p_ProofMixerChannel) {
            boolean boolNotify = false;
            Sound_Channel_Lines o_Sound_Channel_Lines = this.m_Sound_Lines.getSound_Channel_Lines(p_MixerChannel);
            if (o_Sound_Channel_Lines == null || o_Sound_Channel_Lines.getSoundLineFactorsCount() == 0) {
                boolNotify = true;
            }
            if (boolNotify) {
                this.notifyChannelChange_Start();
            }
            boolean boolAdded = this.m_Sound_Lines.addSoundLineFactor(p_MixerChannel, p_SoundLineNumber, p_VolumeFactor, p_ProofMixerChannel);
            if (boolNotify) {
                this.notifyChannelChange_End();
            }
            return boolAdded;
        }

        @Override
        public boolean removeSoundLineFactor(int p_MixerChannel, int p_SoundLineNumber) {
            SoundLineFactor o_SoundLineFactor;
            boolean boolNotify = false;
            Sound_Channel_Lines o_Sound_Channel_Lines = this.m_Sound_Lines.getSound_Channel_Lines(p_MixerChannel);
            if (o_Sound_Channel_Lines != null && (o_SoundLineFactor = o_Sound_Channel_Lines.getSoundLineFactor(p_SoundLineNumber)) != null && o_Sound_Channel_Lines.getSoundLineFactorsCount() == 1) {
                boolNotify = true;
            }
            if (boolNotify) {
                this.notifyChannelChange_Start();
            }
            boolean boolRemoved = this.m_Sound_Lines.removeSoundLineFactor(p_MixerChannel, p_SoundLineNumber);
            if (boolNotify) {
                this.notifyChannelChange_End();
            }
            return boolRemoved;
        }

        public abstract void notifyChannelChange_Start();

        public abstract void notifyChannelChange_End();

        public void checkSoundLines() {
            this.m_Sound_Lines.checkSoundLines();
        }

        public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
            if (p_PropertyChangeListener == null) {
                return;
            }
            if (this.m_PropertyChangeSupport != null) {
                this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
            }
        }

        public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
            if (this.m_PropertyChangeSupport != null) {
                this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
            }
        }

        public static int writeFrameValueToByteBuffer(double p_ChannelValue, ByteBuffer p_ByteBuffer, int p_ByteOffset, AudioFormat p_AudioFormat) {
            switch (p_AudioFormat.getSampleSizeInBits()) {
                case 16: {
                    short shortValue = (short)(p_ChannelValue *= 32767.0);
                    p_ByteBuffer.putShort(p_ByteOffset, shortValue);
                    p_ByteOffset += 2;
                    break;
                }
                case 24: {
                    int intValue = (int)(p_ChannelValue *= 2.147483647E9);
                    if (p_AudioFormat.isBigEndian()) {
                        p_ByteBuffer.put(p_ByteOffset, (byte)(intValue >> 24));
                        p_ByteBuffer.put(p_ByteOffset + 1, (byte)(intValue >> 16));
                        p_ByteBuffer.put(p_ByteOffset + 2, (byte)(intValue >> 8));
                    } else {
                        p_ByteBuffer.put(p_ByteOffset, (byte)(intValue >> 8));
                        p_ByteBuffer.put(p_ByteOffset + 1, (byte)(intValue >> 16));
                        p_ByteBuffer.put(p_ByteOffset + 2, (byte)(intValue >> 24));
                    }
                    p_ByteOffset += 3;
                    break;
                }
                case 32: {
                    int intValue = (int)(p_ChannelValue *= 2.147483647E9);
                    p_ByteBuffer.putInt(p_ByteOffset, intValue);
                    p_ByteOffset += 4;
                }
            }
            return p_ByteOffset;
        }
    }
}

