/*
 * Decompiled with CFR 0.152.
 */
package RTFPackage;

import FileToolPackage.FileSelection;
import FileToolPackage.FileTools;
import GraphicsDeviceToolsPackage.GraphicsDeviceTools;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import RTFPackage.RTFEditorKit_Corrected;
import SwingToolTipPackage.PopUpToolTip;
import ToolsGraphics.JColorChooserOnTop;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;

public class RTFDocumentKit
implements DocumentListener,
PropertyChangeListener {
    public static int s_SoftwareVersion = 1;
    public static String FILE_SAVEFILETITLE_WRITERTF = "RTF";
    public static String FILE_DESCRIPTION_RTF = "RTF";
    public static String FILE_EXTENSION_RTF = ".rtf";
    public static String s_LastLoadPath = "";
    public static String s_LastSavePath = "";
    protected JTextPane m_JTextPane;
    protected RTFEditorKit_Corrected m_RTFEditorKit;
    protected StyledDocument m_Document;
    protected int m_TextSelectionStart;
    protected int m_TextSelectionEnd;
    protected FocusListener m_FocusListener;
    protected CaretListener m_CaretListener;
    public Color m_DefaultForeground;
    protected boolean m_ReaderIsActive;
    public static String UNDO_TEXT = "Undo";
    public static String REDO_TEXT = "Redo";
    protected UndoAction m_UndoAction;
    protected RedoAction m_RedoAction;
    protected RTFUndoManager m_RTFUndoManager;
    private ArrayList<RTFDocumentKit_EventListener> m_RTFDocumentKit_EventListeners;
    private final Object m_SyncListener = new Object();
    protected static RTFEditorKit_Corrected s_RTFEditorKit_Tmp = new RTFEditorKit_Corrected();
    protected static DefaultStyledDocument s_RTFDocument_Tmp = null;
    protected static final Object s_SyncDefaultDocument = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPlainTextFromRTFString(String p_RTFText) {
        if (p_RTFText == null) {
            return "";
        }
        Object object = s_SyncDefaultDocument;
        synchronized (object) {
            if (s_RTFDocument_Tmp == null) {
                s_RTFDocument_Tmp = (DefaultStyledDocument)s_RTFEditorKit_Tmp.createDefaultDocument();
            }
            try {
                StringReader o_StringReader = new StringReader(p_RTFText);
                s_RTFDocument_Tmp.remove(0, s_RTFDocument_Tmp.getLength());
                s_RTFEditorKit_Tmp.read(o_StringReader, (Document)s_RTFDocument_Tmp, 0);
                return s_RTFDocument_Tmp.getText(0, s_RTFDocument_Tmp.getLength());
            }
            catch (Exception e) {
                return "";
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyDocumentTo(StyledDocument p_Document_Source, int p_Offset_Source, StyledDocument p_Document_Dest, int p_Offset_Dest, int p_Length) {
        if (p_Document_Dest == null) {
            return false;
        }
        if (p_Document_Source == null) {
            return false;
        }
        StyledDocument styledDocument = p_Document_Source;
        synchronized (styledDocument) {
            try {
                Element o_Element_Source;
                p_Document_Dest.remove(0, p_Document_Dest.getLength());
                int intPosition_Source = p_Offset_Source;
                int intPosition_Destination = p_Offset_Dest;
                if (intPosition_Destination > p_Document_Dest.getLength()) {
                    intPosition_Destination = p_Document_Dest.getLength();
                }
                if (intPosition_Destination < 0) {
                    intPosition_Destination = 0;
                }
                if (p_Length > p_Document_Source.getLength() - p_Offset_Source) {
                    p_Length = p_Document_Source.getLength() - p_Offset_Source;
                }
                while (intPosition_Source < p_Offset_Source + p_Length && (o_Element_Source = p_Document_Source.getCharacterElement(intPosition_Source)) != null) {
                    int intElement_EndOffset;
                    MutableAttributeSet o_AttributeSet_Dest = RTFDocumentKit.copyAttributeSet(o_Element_Source.getAttributes());
                    int intElement_StartOffset = o_Element_Source.getStartOffset();
                    if (intElement_StartOffset < p_Offset_Source) {
                        intElement_StartOffset = p_Offset_Source;
                    }
                    if ((intElement_EndOffset = o_Element_Source.getEndOffset()) > p_Offset_Source + p_Length) {
                        intElement_EndOffset = p_Offset_Source + p_Length;
                    }
                    String stringText = p_Document_Source.getText(intElement_StartOffset, intElement_EndOffset - intElement_StartOffset);
                    p_Document_Dest.insertString(intPosition_Destination, stringText, o_AttributeSet_Dest);
                    intPosition_Destination += stringText.length();
                    intPosition_Source = o_Element_Source.getEndOffset();
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public static void removeAttribute_Component(MutableAttributeSet p_AttributeSet) {
        if (p_AttributeSet == null) {
            return;
        }
        p_AttributeSet.removeAttribute(StyleConstants.ComponentAttribute);
        p_AttributeSet.removeAttribute("$ename");
    }

    public static MutableAttributeSet copyAttributeSet(AttributeSet p_AttributeSet) {
        if (p_AttributeSet == null) {
            return null;
        }
        SimpleAttributeSet o_MutableAttributeSet = new SimpleAttributeSet(p_AttributeSet);
        Component o_Component = StyleConstants.getComponent(p_AttributeSet);
        if (o_Component != null) {
            StyleConstants.setComponent(o_MutableAttributeSet, o_Component);
        }
        return o_MutableAttributeSet;
    }

    public static MutableAttributeSet createAttributeSet(AttributeComponent p_AttributeComponent, AttributeSet p_AttributeSet) {
        SimpleAttributeSet o_MutableAttributeSet;
        if (p_AttributeComponent == null) {
            return null;
        }
        if (p_AttributeComponent != null) {
            o_MutableAttributeSet = new SimpleAttributeSet(p_AttributeSet);
            RTFDocumentKit.removeAttribute_Component(o_MutableAttributeSet);
        } else {
            o_MutableAttributeSet = new SimpleAttributeSet();
        }
        StyleConstants.setComponent(o_MutableAttributeSet, (Component)((Object)p_AttributeComponent));
        return o_MutableAttributeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element findFirstAttributeComponent_Code(String p_StartTag, String p_EndTag, StyledDocument p_Document, int p_StartOffset, int p_EndOffset, Point p_Location) {
        if (p_Document == null) {
            return null;
        }
        if (p_Location == null) {
            return null;
        }
        StyledDocument styledDocument = p_Document;
        synchronized (styledDocument) {
            if (p_StartOffset < 0 || p_StartOffset >= p_Document.getLength() - (p_StartTag.length() + p_EndTag.length())) {
                return null;
            }
            if (p_StartOffset >= p_EndOffset - (p_StartTag.length() + p_EndTag.length())) {
                return null;
            }
            try {
                Element o_Element = p_Document.getCharacterElement(p_StartOffset);
                while (o_Element != null) {
                    String stringElementText = p_Document.getText(o_Element.getStartOffset(), o_Element.getEndOffset() - o_Element.getStartOffset());
                    int intCodeStart = stringElementText.indexOf(p_StartTag, 0);
                    int intCodeEnd = stringElementText.indexOf(p_EndTag, 0);
                    if (intCodeStart >= 0 && intCodeEnd >= 0 && intCodeStart < intCodeEnd) {
                        if (p_Location != null) {
                            p_Location.setLocation(o_Element.getStartOffset() + intCodeStart, intCodeEnd + p_EndTag.length() + o_Element.getStartOffset());
                        }
                        return o_Element;
                    }
                    p_StartOffset = o_Element.getEndOffset();
                    if (p_StartOffset >= p_EndOffset - (p_StartTag.length() + p_EndTag.length())) {
                        o_Element = null;
                        continue;
                    }
                    o_Element = p_Document.getCharacterElement(p_StartOffset);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Element findAttributeComponent_Element(StyledDocument p_Document, AttributeComponent p_AttributeComponent) {
        if (p_Document == null) {
            return null;
        }
        if (p_AttributeComponent == null) {
            return null;
        }
        int intStartOffset = 0;
        int intLength = p_Document.getLength();
        if (intStartOffset < 0 || intStartOffset >= p_Document.getLength()) {
            return null;
        }
        if (intStartOffset + intLength > p_Document.getLength()) {
            intLength = p_Document.getLength() - intStartOffset;
        }
        int intStart = intStartOffset;
        int intEnd = intStartOffset + intLength;
        try {
            while (intStart < intEnd) {
                Element o_Element = p_Document.getCharacterElement(intStart);
                if (o_Element == null) {
                    return null;
                }
                if (p_AttributeComponent == StyleConstants.getComponent(o_Element.getAttributes())) {
                    return o_Element;
                }
                intStart = o_Element.getEndOffset();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Element findFirstAttributeComponent_Element(StyledDocument p_Document, int p_Start, int p_Length, String p_SceneBridgeID) {
        if (p_Document == null) {
            return null;
        }
        if (p_SceneBridgeID == null) {
            return null;
        }
        if (p_Start < 0 || p_Start >= p_Document.getLength()) {
            return null;
        }
        if (p_Start + p_Length > p_Document.getLength()) {
            p_Length = p_Document.getLength() - p_Start;
        }
        int intStart = p_Start;
        int intEnd = p_Start + p_Length;
        try {
            while (intStart < intEnd) {
                AttributeComponent o_AttributeComponent;
                Element o_Element = p_Document.getCharacterElement(intStart);
                if (o_Element == null) {
                    return null;
                }
                intStart = o_Element.getEndOffset();
                Component o_Component = StyleConstants.getComponent(o_Element.getAttributes());
                if (!(o_Component instanceof AttributeComponent) || (o_AttributeComponent = (AttributeComponent)((Object)o_Component)) == null || !p_SceneBridgeID.equals(o_AttributeComponent.getContent_ID())) continue;
                return o_Element;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static AttributeComponent_Element findFirstAttributeComponent(StyledDocument p_Document, int p_Start, int p_Length, String p_SceneBridgeID) {
        if (p_Document == null) {
            return null;
        }
        if (p_SceneBridgeID == null) {
            return null;
        }
        if (p_Start < 0 || p_Start >= p_Document.getLength()) {
            return null;
        }
        if (p_Start + p_Length > p_Document.getLength()) {
            p_Length = p_Document.getLength() - p_Start;
        }
        int intStart = p_Start;
        int intEnd = p_Start + p_Length;
        try {
            while (intStart < intEnd) {
                AttributeComponent o_AttributeComponent;
                Element o_Element = p_Document.getCharacterElement(intStart);
                if (o_Element == null) {
                    return null;
                }
                intStart = o_Element.getEndOffset();
                Component o_Component = StyleConstants.getComponent(o_Element.getAttributes());
                if (!(o_Component instanceof AttributeComponent) || (o_AttributeComponent = (AttributeComponent)((Object)o_Component)) == null || !p_SceneBridgeID.equals(o_AttributeComponent.getContent_ID())) continue;
                return new AttributeComponent_Element(o_AttributeComponent, o_Element);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public RTFDocumentKit(JTextPane p_JTextPane) {
        this.initMembers();
        this.setJTextPane(p_JTextPane);
    }

    private void initMembers() {
        this.m_DefaultForeground = Color.BLACK;
        this.m_RTFDocumentKit_EventListeners = new ArrayList();
        this.m_RTFUndoManager = new RTFUndoManager(this);
        this.m_UndoAction = new UndoAction(this);
        this.m_RedoAction = new RedoAction(this);
        this.m_TextSelectionStart = 0;
        this.m_TextSelectionEnd = 0;
        this.m_Document = null;
        this.m_RTFEditorKit = null;
        this.m_ReaderIsActive = false;
    }

    public void close() {
        this.setJTextPane(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDocument() {
        StyledDocument o_Document = this.m_Document;
        if (o_Document == null) {
            return;
        }
        try {
            StyledDocument styledDocument = o_Document;
            synchronized (styledDocument) {
                o_Document.remove(0, o_Document.getLength());
                this.m_RTFUndoManager.clear();
                this.setDefaultAttributeSet();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setJTextPane(JTextPane p_JTextComponent) {
        AbstractDocument o_Document;
        if (this.m_JTextPane == p_JTextComponent) {
            return;
        }
        if (this.m_JTextPane != null) {
            this.m_JTextPane.removeCaretListener(this.m_CaretListener);
            this.m_JTextPane.removeFocusListener(this.m_FocusListener);
            if (this.m_Document != null) {
                AbstractDocument abstractDocument = o_Document = (AbstractDocument)((Object)this.m_Document);
                synchronized (abstractDocument) {
                    o_Document.setDocumentFilter(null);
                    o_Document.removeDocumentListener(this);
                    o_Document.removeUndoableEditListener(this.m_RTFUndoManager);
                }
                this.m_Document = null;
            }
            if (this.m_RTFEditorKit != null) {
                this.m_RTFEditorKit.removePropertyChangeListener(this);
                this.m_RTFEditorKit = null;
            }
            this.m_JTextPane = null;
        }
        this.m_JTextPane = p_JTextComponent;
        if (this.m_JTextPane != null) {
            AbstractAction o_ActionUndo = new AbstractAction(UNDO_TEXT){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RTFDocumentKit.this.m_UndoAction.actionPerformed(e);
                }
            };
            AbstractAction o_ActionRedo = new AbstractAction(REDO_TEXT){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RTFDocumentKit.this.m_RedoAction.actionPerformed(e);
                }
            };
            this.m_JTextPane.getKeymap().addActionForKeyStroke(KeyStroke.getKeyStroke(90, 128), o_ActionUndo);
            this.m_JTextPane.getKeymap().addActionForKeyStroke(KeyStroke.getKeyStroke(89, 128), o_ActionRedo);
            this.m_JTextPane.getKeymap().addActionForKeyStroke(KeyStroke.getKeyStroke(90, 256), o_ActionUndo);
            this.m_JTextPane.getKeymap().addActionForKeyStroke(KeyStroke.getKeyStroke(90, 320), o_ActionRedo);
            this.m_RTFEditorKit = new RTFEditorKit_Corrected();
            this.m_RTFEditorKit.addPropertyChangeListener(this);
            this.m_JTextPane.setEditorKit(this.m_RTFEditorKit);
            this.m_CaretListener = new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent e) {
                    RTFDocumentKit.this.m_TextSelectionStart = RTFDocumentKit.this.m_JTextPane.getSelectionStart();
                    RTFDocumentKit.this.m_TextSelectionEnd = RTFDocumentKit.this.m_JTextPane.getSelectionEnd();
                }
            };
            this.m_JTextPane.addCaretListener(this.m_CaretListener);
            this.m_FocusListener = new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    if (RTFDocumentKit.this.m_TextSelectionStart != RTFDocumentKit.this.m_TextSelectionEnd) {
                        RTFDocumentKit.this.setSelection(RTFDocumentKit.this.m_TextSelectionStart, RTFDocumentKit.this.m_TextSelectionEnd);
                    }
                }

                @Override
                public void focusLost(FocusEvent e) {
                    if (RTFDocumentKit.this.m_TextSelectionStart != RTFDocumentKit.this.m_TextSelectionEnd) {
                        RTFDocumentKit.this.setSelection(RTFDocumentKit.this.m_TextSelectionStart, RTFDocumentKit.this.m_TextSelectionEnd);
                    }
                }
            };
            this.m_JTextPane.addFocusListener(this.m_FocusListener);
            this.m_Document = this.m_JTextPane.getStyledDocument();
            AbstractDocument abstractDocument = o_Document = (AbstractDocument)((Object)this.m_Document);
            synchronized (abstractDocument) {
                this.m_Document.addDocumentListener(this);
                o_Document.setDocumentFilter(new RTFDocumentFilter(this));
                this.setDefaultAttributeSet();
                this.m_Document.addUndoableEditListener(this.m_RTFUndoManager);
            }
            this.m_TextSelectionStart = this.m_JTextPane.getSelectionStart();
            this.m_TextSelectionEnd = this.m_JTextPane.getSelectionEnd();
        }
    }

    public void setDefaultInputForeground(Color p_DefaultForeground) {
        if (p_DefaultForeground == null) {
            return;
        }
        this.m_DefaultForeground = p_DefaultForeground;
        this.setDefaultAttributeSet();
    }

    private MutableAttributeSet setDefaultAttributeSet() {
        MutableAttributeSet o_MutableAttributeSet = this.getInputAttributeSet();
        if (o_MutableAttributeSet == null) {
            return null;
        }
        JTextPane o_JTextPane = this.m_JTextPane;
        if (o_JTextPane == null) {
            return o_MutableAttributeSet;
        }
        RTFDocumentKit.removeAttribute_Component(o_MutableAttributeSet);
        StyleConstants.setForeground(o_MutableAttributeSet, this.m_DefaultForeground);
        Font o_Font = o_JTextPane.getFont();
        StyleConstants.setFontFamily(o_MutableAttributeSet, o_Font.getFamily());
        StyleConstants.setFontSize(o_MutableAttributeSet, o_Font.getSize());
        StyleConstants.setBold(o_MutableAttributeSet, o_Font.isBold());
        StyleConstants.setItalic(o_MutableAttributeSet, o_Font.isItalic());
        return o_MutableAttributeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRTFTextNew(String p_RTFText) {
        JTextPane o_JTextPane = this.m_JTextPane;
        if (o_JTextPane == null) {
            return;
        }
        StyledDocument o_Document = this.m_Document;
        if (o_Document == null) {
            return;
        }
        if (p_RTFText == null) {
            p_RTFText = "";
        }
        StyledDocument styledDocument = o_Document;
        synchronized (styledDocument) {
            try {
                this.clearDocument();
                MutableAttributeSet o_MutableAttributeSet = this.setDefaultAttributeSet();
                if (o_MutableAttributeSet == null) {
                    return;
                }
                o_JTextPane.setText(p_RTFText);
                this.m_RTFUndoManager.clear();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public RTFEditorKit_Corrected getRTFEditorKit() {
        return this.m_RTFEditorKit;
    }

    public MutableAttributeSet getInputAttributeSet() {
        RTFEditorKit_Corrected o_RTFEditorKit = this.m_RTFEditorKit;
        if (o_RTFEditorKit == null) {
            return null;
        }
        return o_RTFEditorKit.getInputAttributes();
    }

    public JTextPane getJTextPane() {
        return this.m_JTextPane;
    }

    public StyledDocument getStyledDocument() {
        return this.m_Document;
    }

    public Document getDocument() {
        return this.m_Document;
    }

    public int getCaretPosition() {
        JTextPane o_JTextPane = this.m_JTextPane;
        if (o_JTextPane == null) {
            return 0;
        }
        return o_JTextPane.getCaretPosition();
    }

    public void setCaretPosition(int p_NewPosition) {
        JTextPane o_JTextPane = this.m_JTextPane;
        if (o_JTextPane == null) {
            return;
        }
        StyledDocument o_Document = o_JTextPane.getStyledDocument();
        if (p_NewPosition < 0) {
            p_NewPosition = 0;
        } else if (p_NewPosition > o_Document.getLength()) {
            p_NewPosition = o_Document.getLength();
        }
        try {
            o_JTextPane.setCaretPosition(p_NewPosition);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setSelection(int p_SelectionStart, int p_SelectionEnd) {
        JTextPane o_JTextPane = this.m_JTextPane;
        if (o_JTextPane != null) {
            try {
                o_JTextPane.select(p_SelectionStart, p_SelectionEnd);
                this.m_TextSelectionStart = p_SelectionStart;
                this.m_TextSelectionEnd = p_SelectionEnd;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int getSelectionStart() {
        JTextPane o_JTextPane = this.m_JTextPane;
        if (o_JTextPane == null) {
            return -1;
        }
        return o_JTextPane.getSelectionStart();
    }

    public int getSelectionEnd() {
        JTextPane o_JTextPane = this.m_JTextPane;
        if (o_JTextPane == null) {
            return -1;
        }
        return o_JTextPane.getSelectionEnd();
    }

    public void scrollToTextPosition(int p_TextPosition) {
        JTextPane o_JTextPane;
        if (p_TextPosition < 0) {
            p_TextPosition = 0;
        }
        if ((o_JTextPane = this.m_JTextPane) == null) {
            return;
        }
        try {
            Container o_Container = o_JTextPane.getParent();
            if (o_Container != null && (o_Container = o_Container.getParent()) == null) {
                return;
            }
            if (!(o_Container instanceof JScrollPane)) {
                return;
            }
            JScrollPane scrollPane = (JScrollPane)o_Container;
            Rectangle rectCaret = o_JTextPane.modelToView(p_TextPosition);
            Rectangle viewRectangle = new Rectangle(0, rectCaret.y - (scrollPane.getHeight() - rectCaret.height) / 2, scrollPane.getWidth(), scrollPane.getHeight());
            o_JTextPane.scrollRectToVisible(viewRectangle);
        }
        catch (Exception e) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText() {
        StyledDocument o_Document = this.m_Document;
        if (o_Document == null) {
            return "";
        }
        StyledDocument styledDocument = o_Document;
        synchronized (styledDocument) {
            try {
                return o_Document.getText(0, o_Document.getLength());
            }
            catch (Exception e) {
                return "";
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRTFText() {
        ByteArrayOutputStream o_ByteArrayOutputStream;
        StyledDocument o_Document = this.m_Document;
        if (o_Document == null) {
            return "";
        }
        StyledDocument styledDocument = o_Document;
        synchronized (styledDocument) {
            o_ByteArrayOutputStream = new ByteArrayOutputStream();
            try {
                Object object = s_SyncDefaultDocument;
                synchronized (object) {
                    s_RTFEditorKit_Tmp.write(o_ByteArrayOutputStream, (Document)o_Document, 0, o_Document.getLength());
                }
            }
            catch (Exception e) {
                return "";
            }
        }
        return o_ByteArrayOutputStream.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertDocument(StyledDocument p_Document_Source, DocumentFilter.FilterBypass p_FilterBypass_Dest, int p_Position_Dest) {
        if (p_Document_Source == null) {
            return;
        }
        if (p_Document_Source.getLength() <= 0) {
            return;
        }
        if (p_FilterBypass_Dest == null) {
            return;
        }
        StyledDocument o_Document_Dest = (StyledDocument)p_FilterBypass_Dest.getDocument();
        if (o_Document_Dest == null) {
            return;
        }
        StyledDocument styledDocument = o_Document_Dest;
        synchronized (styledDocument) {
            Element o_Element;
            if (p_Position_Dest > o_Document_Dest.getLength()) {
                p_Position_Dest = o_Document_Dest.getLength();
            }
            int intPosition_Source = 0;
            try {
                o_Element = p_Document_Source.getCharacterElement(intPosition_Source);
            }
            catch (Exception e) {
                return;
            }
            if (!this.m_ReaderIsActive) {
                this.m_RTFUndoManager.startUndoSequence_Insert(UIManager.getString("AbstractDocument.additionText"));
            }
            while (o_Element != null) {
                try {
                    int intLength = o_Element.getEndOffset() - o_Element.getStartOffset();
                    String stringText = p_Document_Source.getText(o_Element.getStartOffset(), intLength);
                    AttributeSet o_AttributeSet_Source = o_Element.getAttributes();
                    MutableAttributeSet o_AttributeSet_Dest = RTFDocumentKit.copyAttributeSet(o_AttributeSet_Source);
                    p_FilterBypass_Dest.insertString(p_Position_Dest, stringText, o_AttributeSet_Dest);
                    p_Position_Dest += intLength;
                    if ((intPosition_Source += intLength) >= p_Document_Source.getLength()) {
                        o_Element = null;
                        break;
                    }
                    o_Element = p_Document_Source.getCharacterElement(intPosition_Source);
                }
                catch (Exception e) {
                    o_Element = null;
                }
            }
        }
        if (!this.m_ReaderIsActive) {
            this.m_RTFUndoManager.endUndoSequence_Insert();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDocumentListener(DocumentListener p_DocumentListener) {
        if (p_DocumentListener == null) {
            return;
        }
        StyledDocument o_Document = this.m_Document;
        if (o_Document != null) {
            StyledDocument styledDocument = o_Document;
            synchronized (styledDocument) {
                o_Document.addDocumentListener(p_DocumentListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDocumentListener(DocumentListener p_DocumentListener) {
        if (p_DocumentListener == null) {
            return;
        }
        StyledDocument o_Document = this.m_Document;
        if (o_Document != null) {
            StyledDocument styledDocument = o_Document;
            synchronized (styledDocument) {
                this.m_Document.removeDocumentListener(p_DocumentListener);
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    public StyledDocument createDocument_Tmp() {
        RTFEditorKit_Corrected o_RTFEditorKit = this.m_RTFEditorKit;
        if (o_RTFEditorKit == null) {
            return null;
        }
        return (StyledDocument)o_RTFEditorKit.createDefaultDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StyledDocument getDocument_Copy() {
        StyledDocument o_Document = this.m_Document;
        if (o_Document == null) {
            return null;
        }
        StyledDocument o_StyledDocument = this.createDocument_Tmp();
        StyledDocument styledDocument = o_Document;
        synchronized (styledDocument) {
            try {
                o_StyledDocument.remove(0, o_StyledDocument.getLength());
                RTFDocumentKit.copyDocumentTo(o_Document, 0, o_StyledDocument, 0, o_Document.getLength());
            }
            catch (Exception e) {
                return null;
            }
        }
        return o_StyledDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean print() {
        StyledDocument o_Document_Source = this.m_Document;
        if (o_Document_Source == null) {
            return false;
        }
        boolean boolPrintOk = true;
        try {
            JTextPane o_JTextPane_Print = new JTextPane();
            o_JTextPane_Print.setEditorKit(new RTFEditorKit_Corrected());
            StyledDocument o_Document_Print = o_JTextPane_Print.getStyledDocument();
            o_Document_Print.remove(0, o_Document_Print.getLength());
            StyledDocument styledDocument = o_Document_Source;
            synchronized (styledDocument) {
                Element o_Element_Source;
                int intPosition_TextBook = 0;
                int intPosition_Print = 0;
                while (intPosition_TextBook < o_Document_Source.getLength() && (o_Element_Source = o_Document_Source.getCharacterElement(intPosition_TextBook)) != null) {
                    AttributeSet o_AttributeSet_TextBook = o_Element_Source.getAttributes().copyAttributes();
                    String stringText = o_Document_Source.getText(o_Element_Source.getStartOffset(), o_Element_Source.getEndOffset() - o_Element_Source.getStartOffset());
                    Component o_Component_Source = StyleConstants.getComponent(o_AttributeSet_TextBook);
                    if (o_Component_Source != null) {
                        SimpleAttributeSet o_MutableAttributeSet_Print;
                        if (!(o_Component_Source instanceof AttributeComponent)) continue;
                        AttributeComponent o_AttributeComponent = (AttributeComponent)((Object)o_Component_Source);
                        Icon o_Icon_Print = o_AttributeComponent.getContent_PrintIcon();
                        if (o_Icon_Print != null) {
                            o_MutableAttributeSet_Print = new SimpleAttributeSet();
                            stringText = " ";
                            StyleConstants.setIcon(o_MutableAttributeSet_Print, o_Icon_Print);
                            StyleConstants.setBackground(o_MutableAttributeSet_Print, o_AttributeComponent.getContent_PrintBackground());
                            o_Document_Print.insertString(intPosition_Print, stringText, o_MutableAttributeSet_Print);
                            intPosition_Print += stringText.length();
                        }
                        o_MutableAttributeSet_Print = new SimpleAttributeSet(o_AttributeSet_TextBook);
                        RTFDocumentKit.removeAttribute_Component(o_MutableAttributeSet_Print);
                        StyleConstants.setBackground(o_MutableAttributeSet_Print, o_AttributeComponent.getContent_PrintBackground());
                        StyleConstants.setForeground(o_MutableAttributeSet_Print, o_AttributeComponent.getContent_PrintForeground());
                        stringText = " " + o_AttributeComponent.getContent_PrintString();
                        o_Document_Print.insertString(intPosition_Print, stringText, o_MutableAttributeSet_Print);
                        intPosition_Print += stringText.length();
                        intPosition_TextBook = o_Element_Source.getEndOffset();
                        continue;
                    }
                    o_Document_Print.insertString(intPosition_Print, stringText, o_AttributeSet_TextBook);
                    intPosition_Print += stringText.length();
                    intPosition_TextBook = o_Element_Source.getEndOffset();
                }
            }
            o_JTextPane_Print.print();
        }
        catch (Exception e) {
            boolPrintOk = false;
        }
        this.notifyPrintDone(boolPrintOk);
        return boolPrintOk;
    }

    public File saveUnder(String p_InitialFilePathName) {
        File o_File = new File(p_InitialFilePathName);
        String stringPathName = FileTools.getPathName(o_File);
        if ((stringPathName == null || stringPathName.length() <= 0) && s_LastSavePath != null) {
            stringPathName = s_LastSavePath;
        }
        String stringFileName = FileTools.getFileNameBase(o_File);
        stringFileName = stringFileName + FILE_EXTENSION_RTF;
        o_File = new File(stringPathName + File.separator + stringFileName);
        if ((o_File = FileSelection.showSave(null, FILE_DESCRIPTION_RTF, o_File, FileSelection.createFileNameExtensionFilter(FILE_DESCRIPTION_RTF, FILE_EXTENSION_RTF), true, false)) == null) {
            return null;
        }
        return this.save(o_File);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File save(File p_File) {
        if (p_File == null) {
            return null;
        }
        String stringPathName = FileTools.getPathName(p_File);
        String stringFileName = FileTools.getFileNameBase(p_File);
        stringFileName = stringFileName + FILE_EXTENSION_RTF;
        p_File = new File(stringPathName + File.separator + stringFileName);
        if (p_File.exists() && !p_File.delete()) {
            return null;
        }
        StyledDocument o_Document_Save = this.createDocument_Tmp();
        if (o_Document_Save == null) {
            return null;
        }
        StyledDocument o_Document_Source = this.getDocument_Copy();
        if (o_Document_Source == null) {
            return null;
        }
        MutableAttributeSet o_AttributeSet_Save = new SimpleAttributeSet();
        try {
            Element o_Element_Source;
            int intPosition_Source = 0;
            int intPosition_Save = 0;
            while (intPosition_Source < o_Document_Source.getLength() && (o_Element_Source = o_Document_Source.getCharacterElement(intPosition_Source)) != null) {
                String stringText;
                AttributeSet o_AttributeSet_Source = o_Element_Source.getAttributes();
                Component o_Component_Source = StyleConstants.getComponent(o_AttributeSet_Source);
                if (o_Component_Source != null) {
                    if (o_Component_Source instanceof AttributeComponent) {
                        AttributeComponent o_AttributeComponent_Source = (AttributeComponent)((Object)o_Component_Source);
                        o_AttributeSet_Save = RTFDocumentKit.copyAttributeSet(o_AttributeSet_Source);
                        RTFDocumentKit.removeAttribute_Component(o_AttributeSet_Save);
                        stringText = o_AttributeComponent_Source.getCode();
                        o_Document_Save.insertString(intPosition_Save, stringText, o_AttributeSet_Save);
                        intPosition_Save += stringText.length();
                        intPosition_Source = o_Element_Source.getEndOffset();
                        continue;
                    }
                    intPosition_Source = o_Element_Source.getEndOffset();
                    continue;
                }
                stringText = o_Document_Source.getText(o_Element_Source.getStartOffset(), o_Element_Source.getEndOffset() - o_Element_Source.getStartOffset());
                o_Document_Save.insertString(intPosition_Save, stringText, o_AttributeSet_Source);
                intPosition_Save += stringText.length();
                intPosition_Source = o_Element_Source.getEndOffset();
            }
        }
        catch (Exception e) {
            return null;
        }
        boolean boolOK = true;
        StyledDocument styledDocument = o_Document_Save;
        synchronized (styledDocument) {
            FileOutputStream o_FileOutputStream = null;
            try {
                o_FileOutputStream = new FileOutputStream(p_File);
                Object object = s_SyncDefaultDocument;
                synchronized (object) {
                    s_RTFEditorKit_Tmp.write(o_FileOutputStream, (Document)o_Document_Save, 0, o_Document_Save.getLength());
                }
                o_FileOutputStream.flush();
                o_FileOutputStream.close();
                s_LastSavePath = p_File.getParent();
            }
            catch (Exception e) {
                boolOK = false;
                if (o_FileOutputStream != null) {
                    try {
                        o_FileOutputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return null;
            }
        }
        return p_File;
    }

    public File save(String p_FilePathName) {
        if (p_FilePathName == null) {
            return null;
        }
        File o_File = new File(p_FilePathName);
        return this.save(o_File);
    }

    public File loadFileChooser(File p_InitialFile) {
        File o_File = null;
        if (p_InitialFile != null) {
            if (p_InitialFile.isDirectory()) {
                if (p_InitialFile.exists()) {
                    o_File = p_InitialFile;
                }
            } else if (p_InitialFile.exists()) {
                o_File = p_InitialFile.getParentFile();
            }
        }
        if (o_File == null && s_LastLoadPath != null && s_LastLoadPath.length() > 0) {
            o_File = new File(s_LastLoadPath);
        }
        o_File = FileSelection.showOpen(null, FILE_DESCRIPTION_RTF, o_File, FileSelection.createFileNameExtensionFilter(FILE_DESCRIPTION_RTF, FILE_EXTENSION_RTF), true, false);
        return this.load(o_File);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File load(File p_RTFFile) {
        if (p_RTFFile == null) {
            return null;
        }
        if (!p_RTFFile.exists()) {
            return null;
        }
        FileInputStream o_FileInputStream = null;
        boolean boolOk = true;
        JTextPane o_JTextPane = this.m_JTextPane;
        StyledDocument o_Document = this.m_Document;
        RTFEditorKit_Corrected o_RTFEditorKit_Corrected = this.m_RTFEditorKit;
        if (o_JTextPane == null || o_RTFEditorKit_Corrected == null || o_Document == null) {
            return null;
        }
        StyledDocument styledDocument = o_Document;
        synchronized (styledDocument) {
            try {
                o_FileInputStream = new FileInputStream(p_RTFFile);
                o_Document.remove(0, o_Document.getLength());
                o_RTFEditorKit_Corrected.read(o_FileInputStream, (Document)o_Document, 0);
                o_FileInputStream.close();
                s_LastLoadPath = p_RTFFile.getParent();
            }
            catch (Exception e) {
                boolOk = false;
                try {
                    if (o_FileInputStream != null) {
                        o_FileInputStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.m_RTFUndoManager.clear();
        o_JTextPane.setCaretPosition(0);
        o_JTextPane.revalidate();
        o_JTextPane.repaint();
        return p_RTFFile;
    }

    public RTFUndoManager getUndoManager() {
        return this.m_RTFUndoManager;
    }

    public void eventUndoDone() {
        this.notifyUndoDone();
    }

    public void eventRedoDone() {
        this.notifyRedoDone();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof RTFEditorKit_Corrected) {
            if (RTFEditorKit_Corrected.PROP_READER_START.equals(evt.getPropertyName())) {
                this.m_RTFUndoManager.endUndoSequence_Insert();
                this.m_ReaderIsActive = true;
                this.m_RTFUndoManager.startUndoSequence_Insert(UIManager.getString("AbstractDocument.additionText"));
            } else if (RTFEditorKit_Corrected.PROP_READER_END.equals(evt.getPropertyName())) {
                this.m_ReaderIsActive = false;
                this.m_RTFUndoManager.endUndoSequence_Insert();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRTFDocumentKit_EventListener(RTFDocumentKit_EventListener p_RTFDocumentKit_EventListener) {
        if (p_RTFDocumentKit_EventListener == null) {
            return;
        }
        Object object = this.m_SyncListener;
        synchronized (object) {
            if (this.m_RTFDocumentKit_EventListeners.contains(p_RTFDocumentKit_EventListener)) {
                return;
            }
            this.m_RTFDocumentKit_EventListeners.add(p_RTFDocumentKit_EventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRTFDocumentKit_EventListener(RTFDocumentKit_EventListener p_RTFDocumentKit_EventListener) {
        if (p_RTFDocumentKit_EventListener == null) {
            return;
        }
        Object object = this.m_SyncListener;
        synchronized (object) {
            this.m_RTFDocumentKit_EventListeners.remove(p_RTFDocumentKit_EventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notifyPrintWillStart() {
        ArrayList<RTFDocumentKit_EventListener> o_RTFDocumentKit_EventListeners;
        boolean boolPrintDone = false;
        Object object = this.m_SyncListener;
        synchronized (object) {
            o_RTFDocumentKit_EventListeners = new ArrayList<RTFDocumentKit_EventListener>(this.m_RTFDocumentKit_EventListeners.size());
            o_RTFDocumentKit_EventListeners.addAll(this.m_RTFDocumentKit_EventListeners);
        }
        for (int intListener = 0; intListener < o_RTFDocumentKit_EventListeners.size(); ++intListener) {
            RTFDocumentKit_EventListener o_Listener = (RTFDocumentKit_EventListener)o_RTFDocumentKit_EventListeners.get(intListener);
            if (o_Listener == null || !o_Listener.eventPrintWillStart(this)) continue;
            boolPrintDone = true;
        }
        return boolPrintDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyPrintDone(boolean p_PrintOk) {
        ArrayList<RTFDocumentKit_EventListener> o_RTFDocumentKit_EventListeners;
        boolean boolPrintDone = false;
        Object object = this.m_SyncListener;
        synchronized (object) {
            o_RTFDocumentKit_EventListeners = new ArrayList<RTFDocumentKit_EventListener>(this.m_RTFDocumentKit_EventListeners.size());
            o_RTFDocumentKit_EventListeners.addAll(this.m_RTFDocumentKit_EventListeners);
        }
        for (int intListener = 0; intListener < o_RTFDocumentKit_EventListeners.size(); ++intListener) {
            RTFDocumentKit_EventListener o_Listener = (RTFDocumentKit_EventListener)o_RTFDocumentKit_EventListeners.get(intListener);
            if (o_Listener == null) continue;
            o_Listener.eventPrintDone(this, p_PrintOk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyUndoDone() {
        ArrayList<RTFDocumentKit_EventListener> o_RTFDocumentKit_EventListeners;
        boolean boolPrintDone = false;
        Object object = this.m_SyncListener;
        synchronized (object) {
            o_RTFDocumentKit_EventListeners = new ArrayList<RTFDocumentKit_EventListener>(this.m_RTFDocumentKit_EventListeners.size());
            o_RTFDocumentKit_EventListeners.addAll(this.m_RTFDocumentKit_EventListeners);
        }
        for (int intListener = 0; intListener < o_RTFDocumentKit_EventListeners.size(); ++intListener) {
            RTFDocumentKit_EventListener o_Listener = (RTFDocumentKit_EventListener)o_RTFDocumentKit_EventListeners.get(intListener);
            if (o_Listener == null) continue;
            o_Listener.eventUndoDone(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyRedoDone() {
        ArrayList<RTFDocumentKit_EventListener> o_RTFDocumentKit_EventListeners;
        boolean boolPrintDone = false;
        Object object = this.m_SyncListener;
        synchronized (object) {
            o_RTFDocumentKit_EventListeners = new ArrayList<RTFDocumentKit_EventListener>(this.m_RTFDocumentKit_EventListeners.size());
            o_RTFDocumentKit_EventListeners.addAll(this.m_RTFDocumentKit_EventListeners);
        }
        for (int intListener = 0; intListener < o_RTFDocumentKit_EventListeners.size(); ++intListener) {
            RTFDocumentKit_EventListener o_Listener = (RTFDocumentKit_EventListener)o_RTFDocumentKit_EventListeners.get(intListener);
            if (o_Listener == null) continue;
            o_Listener.eventRedoDone(this);
        }
    }

    public static TextToolBar createTextToolBar(RTFDocumentKit p_RTFDocumentKit, boolean p_ShowPrintButton) {
        TextToolBar jToolBar_Text = new TextToolBar(p_RTFDocumentKit, p_ShowPrintButton);
        jToolBar_Text.setFloatable(false);
        return jToolBar_Text;
    }

    public static class PictureReader {
        public static void readImage(JTextPane p_JTextPane) {
            String stringImageName = "/IconsPackage/Edit_Cancel.png";
            InputStream o_InputStream = PictureReader.class.getResourceAsStream(stringImageName);
            ImageIcon icon = new ImageIcon(PictureReader.class.getResource(stringImageName));
            StringBuilder o_StringBuilder = new StringBuilder();
            o_StringBuilder.append("{rtf1ansiparpardplain");
            o_StringBuilder.append("n{*shppict{pict");
            o_StringBuilder.append("picw").append(icon.getIconWidth());
            o_StringBuilder.append("pich").append(icon.getIconHeight());
            o_StringBuilder.append("pngblip");
            int count = 0;
            while (true) {
                try {
                    int i;
                    while ((i = o_InputStream.read()) != -1) {
                        String hexStr = Integer.toHexString(i);
                        if (hexStr.length() == 1) {
                            hexStr = "0" + hexStr;
                        }
                        o_StringBuilder.append(hexStr);
                        if ((count += 2) != 64) continue;
                        count = 0;
                        o_StringBuilder.append("n");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
            o_StringBuilder.append("}}n}n");
            int intPos = p_JTextPane.getCaretPosition();
            Document o_Document = p_JTextPane.getDocument();
            try {
                o_Document.insertString(intPos, o_StringBuilder.toString(), null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class FontAndSizeAction
    extends StyledEditorKit.StyledTextAction {
        private static final long serialVersionUID = 584531387732416339L;
        private RTFDocumentKit m_RTFDocumentKit;
        private String m_FontFamily;
        private float m_FontSize;

        public FontAndSizeAction(RTFDocumentKit p_RTFDocumentKit) {
            super("Font and Size");
            this.m_RTFDocumentKit = p_RTFDocumentKit;
        }

        private void initComponents() {
        }

        public String toString() {
            return "Font and Size";
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextPane o_TextPane = (JTextPane)this.getEditor(e);
            if (o_TextPane == null) {
                return;
            }
            try {
                int intSelectionStart = o_TextPane.getSelectionStart();
                StyledDocument o_StyledDocument = this.getStyledDocument(o_TextPane);
                Element o_Element = o_StyledDocument.getCharacterElement(intSelectionStart);
                AttributeSet o_AttributeSet = o_Element.getAttributes();
                this.m_FontFamily = StyleConstants.getFontFamily(o_AttributeSet);
                this.m_FontSize = StyleConstants.getFontSize(o_AttributeSet);
                TextToolBar.s_FontSizeChooser.setTitle(TextToolBar.FONT);
                TextToolBar.s_FontSizeChooser.setFontFamily(this.m_FontFamily);
                TextToolBar.s_FontSizeChooser.setFontSize(this.m_FontSize);
                if (TextToolBar.s_FontSizeChooser.showDialog() != null) {
                    RTFUndoManager o_RTFUndoManager = this.m_RTFDocumentKit.getUndoManager();
                    if (o_RTFUndoManager.getUndoSequenceStarted_Replace()) {
                        o_RTFUndoManager.endUndoSequence_Replace();
                    }
                    this.m_FontFamily = TextToolBar.s_FontSizeChooser.getFontFamily();
                    this.m_FontSize = TextToolBar.s_FontSizeChooser.getFontSize();
                    SimpleAttributeSet o_MutableAttributeSet = null;
                    o_MutableAttributeSet = new SimpleAttributeSet();
                    StyleConstants.setFontFamily(o_MutableAttributeSet, this.m_FontFamily);
                    StyleConstants.setFontSize(o_MutableAttributeSet, (int)this.m_FontSize);
                    this.setCharacterAttributes(o_TextPane, o_MutableAttributeSet, false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            o_TextPane.requestFocusInWindow();
        }
    }

    public static class FontSizeChooser
    extends JDialog {
        public static Icon s_Icon = new ImageIcon(FontSizeChooser.class.getResource("/IconsPackage/TextFormat_FontSize.png"));
        private boolean m_Accept = false;
        private String m_FontFamily;
        private float m_FontSize;
        private Font m_SelectedFont;
        private JComboBox<String> m_ComboBoxFontFamily;
        private JComboBox<Float> m_ComboBoxFontSize;

        public FontSizeChooser() {
            super((Frame)null, TextToolBar.FONT, true);
            this.initComponents();
            this.setAlwaysOnTop(true);
        }

        private void initComponents() {
            this.setIconImage(((ImageIcon)s_Icon).getImage());
            JPanel o_PanelContent = new JPanel();
            o_PanelContent.setLayout(new GridBagLayout());
            o_PanelContent.setBackground(Color.BLACK);
            o_PanelContent.setForeground(Color.WHITE);
            JPanel o_PanelChoosers = new JPanel();
            o_PanelChoosers.setLayout(new GridBagLayout());
            o_PanelChoosers.setBackground(Color.BLACK);
            o_PanelChoosers.setForeground(Color.WHITE);
            JLabel o_LabelFontFamily = new JLabel("Font");
            o_LabelFontFamily.setBackground(Color.BLACK);
            o_LabelFontFamily.setForeground(Color.WHITE);
            GridBagConstraints o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 0;
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.insets = new Insets(3, 3, 3, 3);
            o_PanelChoosers.add((Component)o_LabelFontFamily, o_GridBagConstraints);
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            String[] fontNames = ge.getAvailableFontFamilyNames();
            this.m_ComboBoxFontFamily = new JComboBox();
            this.m_ComboBoxFontFamily.setMinimumSize(new Dimension(150, 24));
            this.m_ComboBoxFontFamily.setPreferredSize(new Dimension(150, 24));
            for (int i = 0; i < fontNames.length; ++i) {
                this.m_ComboBoxFontFamily.addItem(fontNames[i]);
            }
            this.m_ComboBoxFontFamily.setSelectedIndex(0);
            this.m_FontFamily = (String)this.m_ComboBoxFontFamily.getSelectedItem();
            o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 1;
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.insets = new Insets(3, 3, 3, 3);
            o_GridBagConstraints.fill = 2;
            o_GridBagConstraints.weightx = 1.0;
            o_PanelChoosers.add(this.m_ComboBoxFontFamily, o_GridBagConstraints);
            JLabel o_LabelFontSize = new JLabel("Size");
            o_LabelFontSize.setBackground(Color.BLACK);
            o_LabelFontSize.setForeground(Color.WHITE);
            o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 0;
            o_GridBagConstraints.gridy = 1;
            o_GridBagConstraints.insets = new Insets(3, 3, 3, 3);
            o_PanelChoosers.add((Component)o_LabelFontSize, o_GridBagConstraints);
            this.m_ComboBoxFontSize = new JComboBox();
            this.m_ComboBoxFontSize.setMinimumSize(new Dimension(150, 24));
            this.m_ComboBoxFontSize.setPreferredSize(new Dimension(150, 24));
            this.m_ComboBoxFontSize.setEditable(true);
            this.m_ComboBoxFontSize.addItem(new Float(8.0f));
            this.m_ComboBoxFontSize.addItem(new Float(9.0f));
            this.m_ComboBoxFontSize.addItem(new Float(10.0f));
            this.m_ComboBoxFontSize.addItem(new Float(11.0f));
            this.m_ComboBoxFontSize.addItem(new Float(12.0f));
            this.m_ComboBoxFontSize.addItem(new Float(14.0f));
            this.m_ComboBoxFontSize.addItem(new Float(16.0f));
            this.m_ComboBoxFontSize.addItem(new Float(20.0f));
            this.m_ComboBoxFontSize.addItem(new Float(24.0f));
            this.m_ComboBoxFontSize.setSelectedItem(new Float(14.0f));
            this.m_FontSize = ((Float)this.m_ComboBoxFontSize.getSelectedItem()).floatValue();
            ComboBoxEditor o_ComboBoxEditor = this.m_ComboBoxFontSize.getEditor();
            Component o_Component = o_ComboBoxEditor.getEditorComponent();
            o_Component.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                    if (e.getKeyChar() != '0' && e.getKeyChar() != '1' && e.getKeyChar() != '2' && e.getKeyChar() != '3' && e.getKeyChar() != '4' && e.getKeyChar() != '5' && e.getKeyChar() != '6' && e.getKeyChar() != '7' && e.getKeyChar() != '8' && e.getKeyChar() != '9' && e.getKeyChar() != '.') {
                        e.consume();
                    }
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }
            });
            o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 1;
            o_GridBagConstraints.gridy = 1;
            o_GridBagConstraints.insets = new Insets(3, 3, 3, 3);
            o_GridBagConstraints.fill = 2;
            o_GridBagConstraints.weightx = 1.0;
            o_PanelChoosers.add(this.m_ComboBoxFontSize, o_GridBagConstraints);
            Dimension o_DimensionButtons = new Dimension(32, 32);
            JButton o_Button_Ok = new JButton("");
            o_Button_Ok.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_OK.png")));
            o_Button_Ok.setContentAreaFilled(false);
            o_Button_Ok.setMinimumSize(o_DimensionButtons);
            o_Button_Ok.setMaximumSize(o_DimensionButtons);
            o_Button_Ok.setPreferredSize(o_DimensionButtons);
            o_Button_Ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    m_Accept = true;
                    this.setVisible(false);
                    m_FontFamily = (String)m_ComboBoxFontFamily.getSelectedItem();
                    try {
                        Float floatFontSize = Float.valueOf(Float.parseFloat(m_ComboBoxFontSize.getSelectedItem().toString()));
                        m_FontSize = floatFontSize.floatValue();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    m_SelectedFont = new Font(m_FontFamily, 0, (int)m_FontSize);
                }
            });
            JButton o_Button_Cancel = new JButton("");
            o_Button_Cancel.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Cancel.png")));
            o_Button_Cancel.setContentAreaFilled(false);
            o_Button_Cancel.setMinimumSize(o_DimensionButtons);
            o_Button_Cancel.setMaximumSize(o_DimensionButtons);
            o_Button_Cancel.setPreferredSize(o_DimensionButtons);
            o_Button_Cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    m_Accept = false;
                    this.setVisible(false);
                    m_SelectedFont = null;
                }
            });
            JPanel o_PanelButtons = new JPanel();
            o_PanelButtons.setLayout(new GridBagLayout());
            o_PanelButtons.setBackground(Color.BLACK);
            o_PanelButtons.setForeground(Color.WHITE);
            o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 0;
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.insets = new Insets(3, 3, 3, 3);
            o_GridBagConstraints.fill = 2;
            o_GridBagConstraints.weightx = 1.0;
            o_PanelButtons.add((Component)o_Button_Ok, o_GridBagConstraints);
            o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 1;
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.insets = new Insets(3, 3, 3, 3);
            o_GridBagConstraints.fill = 2;
            o_GridBagConstraints.weightx = 1.0;
            o_PanelButtons.add((Component)o_Button_Cancel, o_GridBagConstraints);
            o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 0;
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.insets = new Insets(3, 3, 3, 3);
            o_GridBagConstraints.fill = 1;
            o_GridBagConstraints.weightx = 1.0;
            o_GridBagConstraints.weighty = 1.0;
            o_PanelContent.add((Component)o_PanelChoosers, o_GridBagConstraints);
            o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 0;
            o_GridBagConstraints.gridy = 1;
            o_GridBagConstraints.insets = new Insets(3, 3, 3, 3);
            o_GridBagConstraints.fill = 2;
            o_GridBagConstraints.weightx = 1.0;
            o_GridBagConstraints.weighty = 0.0;
            o_PanelContent.add((Component)o_PanelButtons, o_GridBagConstraints);
            this.getContentPane().add(o_PanelContent);
            this.setMinimumSize(new Dimension(210, 150));
            this.setPreferredSize(new Dimension(210, 150));
        }

        public void setFontFamily(String p_FontFamily) {
            if (p_FontFamily == null) {
                return;
            }
            this.m_ComboBoxFontFamily.setSelectedItem(p_FontFamily);
        }

        public String getFontFamily() {
            return this.m_FontFamily;
        }

        public void setFontSize(float p_FontSize) {
            this.m_ComboBoxFontSize.setSelectedItem(Float.valueOf(p_FontSize));
        }

        public float getFontSize() {
            return this.m_FontSize;
        }

        public void setSelectedFont(Font p_Font) {
            if (p_Font == null) {
                return;
            }
            this.m_FontFamily = p_Font.getFamily();
            this.m_FontSize = p_Font.getSize2D();
        }

        public Font getSelectedFont() {
            return this.m_SelectedFont;
        }

        public Font showDialog() {
            PointerInfo info = MouseInfo.getPointerInfo();
            Point mousePoint = info.getLocation();
            this.setLocation(mousePoint.x, mousePoint.y);
            this.setVisible(true);
            return this.m_SelectedFont;
        }

        @Override
        public void setLocation(int p_XOnScreen, int p_YOnScreen) {
            Dimension o_Dimension = this.getSize();
            int intX = p_XOnScreen;
            int intY = p_YOnScreen;
            GraphicsDeviceTools.GraphicsDeviceDescription o_GraphicsDeviceDescription = GraphicsDeviceTools.getGraphicsDeviceDescription(p_XOnScreen, p_YOnScreen);
            if (o_GraphicsDeviceDescription == null) {
                o_GraphicsDeviceDescription = GraphicsDeviceTools.getGraphicsDeviceDescription(0);
            }
            if (o_GraphicsDeviceDescription != null) {
                if (intX < o_GraphicsDeviceDescription.getX()) {
                    intX = o_GraphicsDeviceDescription.getX();
                }
                if (intX + o_Dimension.width > o_GraphicsDeviceDescription.getX() + o_GraphicsDeviceDescription.getWidth()) {
                    intX = o_GraphicsDeviceDescription.getX() + o_GraphicsDeviceDescription.getWidth() - o_Dimension.width;
                }
                if (intY < o_GraphicsDeviceDescription.getY()) {
                    intY = o_GraphicsDeviceDescription.getY();
                }
                if (intY + o_Dimension.height > o_GraphicsDeviceDescription.getY() + o_GraphicsDeviceDescription.getHeight()) {
                    intY = o_GraphicsDeviceDescription.getY() + o_GraphicsDeviceDescription.getHeight() - o_Dimension.height;
                }
            }
            super.setLocation(intX, intY);
        }
    }

    public static class BackgroundAction
    extends StyledEditorKit.StyledTextAction {
        private static final long serialVersionUID = 6384632651737400352L;
        private RTFDocumentKit m_RTFDocumentKit;
        private Color m_Color;

        public BackgroundAction(RTFDocumentKit p_RTFDocumentKit) {
            super("background-color");
            this.m_RTFDocumentKit = p_RTFDocumentKit;
            this.initComponents();
        }

        private void initComponents() {
            this.m_Color = new Color(0, 0, 0);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextPane jTextPane = (JTextPane)this.getEditor(e);
            if (jTextPane == null) {
                return;
            }
            try {
                Color o_Color;
                int intSelectionStart = jTextPane.getSelectionStart();
                StyledDocument o_StyledDocument = this.getStyledDocument(jTextPane);
                Element o_Element = o_StyledDocument.getCharacterElement(intSelectionStart);
                AttributeSet o_AttributeSet = o_Element.getAttributes();
                this.m_Color = StyleConstants.getBackground(o_AttributeSet);
                if (this.m_Color == null) {
                    this.m_Color = Color.BLACK;
                }
                if ((o_Color = JColorChooserOnTop.showDialog(null, TextToolBar.BACKGROUND, this.m_Color)) == null) {
                    return;
                }
                this.m_Color = o_Color;
                RTFUndoManager o_RTFUndoManager = this.m_RTFDocumentKit.getUndoManager();
                if (o_RTFUndoManager.getUndoSequenceStarted_Replace()) {
                    o_RTFUndoManager.endUndoSequence_Replace();
                }
                SimpleAttributeSet o_MutableAttributeSet = null;
                o_MutableAttributeSet = new SimpleAttributeSet();
                StyleConstants.setBackground(o_MutableAttributeSet, this.m_Color);
                this.setCharacterAttributes(jTextPane, o_MutableAttributeSet, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            jTextPane.requestFocusInWindow();
        }
    }

    public static class ForegroundAction
    extends StyledEditorKit.StyledTextAction {
        private static final long serialVersionUID = 6384632651737400352L;
        private RTFDocumentKit m_RTFDocumentKit;
        private Color m_Color;

        public ForegroundAction(RTFDocumentKit p_RTFDocumentKit) {
            super("foreground");
            this.m_RTFDocumentKit = p_RTFDocumentKit;
            this.initComponents();
        }

        private void initComponents() {
            this.m_Color = Color.BLACK;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextPane jTextPane = (JTextPane)this.getEditor(e);
            if (jTextPane == null) {
                return;
            }
            try {
                Color o_Color;
                int intSelectionStart = jTextPane.getSelectionStart();
                StyledDocument o_StyledDocument = this.getStyledDocument(jTextPane);
                Element o_Element = o_StyledDocument.getCharacterElement(intSelectionStart);
                AttributeSet o_AttributeSet = o_Element.getAttributes();
                this.m_Color = StyleConstants.getForeground(o_AttributeSet);
                if (this.m_Color == null) {
                    this.m_Color = Color.BLACK;
                }
                if ((o_Color = JColorChooserOnTop.showDialog(null, TextToolBar.FOREGROUND, this.m_Color)) == null) {
                    return;
                }
                this.m_Color = o_Color;
                RTFUndoManager o_RTFUndoManager = this.m_RTFDocumentKit.getUndoManager();
                if (o_RTFUndoManager.getUndoSequenceStarted_Replace()) {
                    o_RTFUndoManager.endUndoSequence_Replace();
                }
                SimpleAttributeSet o_MutableAttributeSet = null;
                o_MutableAttributeSet = new SimpleAttributeSet();
                StyleConstants.setForeground(o_MutableAttributeSet, this.m_Color);
                this.setCharacterAttributes(jTextPane, o_MutableAttributeSet, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            jTextPane.requestFocusInWindow();
        }
    }

    public static class UnderlineAction
    extends StyledEditorKit.StyledTextAction {
        private static final long serialVersionUID = -1428340091100055456L;
        private RTFDocumentKit m_RTFDocumentKit;

        public UnderlineAction(RTFDocumentKit p_RTFDocumentKit) {
            super("underline");
            this.m_RTFDocumentKit = p_RTFDocumentKit;
        }

        public String toString() {
            return "Underline";
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextPane jTextPane = (JTextPane)this.getEditor(e);
            RTFUndoManager o_RTFUndoManager = this.m_RTFDocumentKit.getUndoManager();
            if (jTextPane != null) {
                try {
                    StyledEditorKit o_StyledEditorKit;
                    MutableAttributeSet o_MutableAttributeSet;
                    if (o_RTFUndoManager.getUndoSequenceStarted_Replace()) {
                        o_RTFUndoManager.endUndoSequence_Replace();
                    }
                    boolean boolUnderline = !StyleConstants.isUnderline(o_MutableAttributeSet = (o_StyledEditorKit = this.getStyledEditorKit(jTextPane)).getInputAttributes());
                    SimpleAttributeSet o_SimpleAttributeSet = new SimpleAttributeSet();
                    StyleConstants.setUnderline(o_SimpleAttributeSet, boolUnderline);
                    this.setCharacterAttributes(jTextPane, o_SimpleAttributeSet, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                jTextPane.requestFocusInWindow();
            }
        }
    }

    public static class ItalicAction
    extends StyledEditorKit.StyledTextAction {
        private static final long serialVersionUID = -1428340091100055456L;
        private RTFDocumentKit m_RTFDocumentKit;

        public ItalicAction(RTFDocumentKit p_RTFDocumentKit) {
            super("font-italic");
            this.m_RTFDocumentKit = p_RTFDocumentKit;
        }

        public String toString() {
            return "Italic";
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextPane jTextPane = (JTextPane)this.getEditor(e);
            RTFUndoManager o_RTFUndoManager = this.m_RTFDocumentKit.getUndoManager();
            if (jTextPane != null) {
                try {
                    StyledEditorKit o_StyledEditorKit;
                    MutableAttributeSet o_MutableAttributeSet;
                    if (o_RTFUndoManager.getUndoSequenceStarted_Replace()) {
                        o_RTFUndoManager.endUndoSequence_Replace();
                    }
                    boolean boolItalic = !StyleConstants.isItalic(o_MutableAttributeSet = (o_StyledEditorKit = this.getStyledEditorKit(jTextPane)).getInputAttributes());
                    SimpleAttributeSet o_SimpleAttributeSet = new SimpleAttributeSet();
                    StyleConstants.setItalic(o_SimpleAttributeSet, boolItalic);
                    this.setCharacterAttributes(jTextPane, o_SimpleAttributeSet, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                jTextPane.requestFocusInWindow();
            }
        }
    }

    public static class BoldAction
    extends StyledEditorKit.StyledTextAction {
        private static final long serialVersionUID = 9174670038684056758L;
        private RTFDocumentKit m_RTFDocumentKit;

        public BoldAction(RTFDocumentKit p_RTFDocumentKit) {
            super("font-bold");
            this.m_RTFDocumentKit = p_RTFDocumentKit;
        }

        public String toString() {
            return "Bold";
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextPane jTextPane = (JTextPane)this.getEditor(e);
            RTFUndoManager o_RTFUndoManager = this.m_RTFDocumentKit.getUndoManager();
            if (jTextPane != null) {
                try {
                    StyledEditorKit o_StyledEditorKit;
                    MutableAttributeSet o_MutableAttributeSet;
                    if (o_RTFUndoManager.getUndoSequenceStarted_Replace()) {
                        o_RTFUndoManager.endUndoSequence_Replace();
                    }
                    boolean boolBold = !StyleConstants.isBold(o_MutableAttributeSet = (o_StyledEditorKit = this.getStyledEditorKit(jTextPane)).getInputAttributes());
                    SimpleAttributeSet o_SimpleAttributeSet = new SimpleAttributeSet();
                    StyleConstants.setBold(o_SimpleAttributeSet, boolBold);
                    this.setCharacterAttributes(jTextPane, o_SimpleAttributeSet, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                jTextPane.requestFocusInWindow();
            }
        }
    }

    public static class TextToolBar
    extends JToolBar
    implements FocusListener,
    PropertyChangeListener {
        public static ImageIcon ICON_TEXT_BUTTONPRESSED = new ImageIcon(TextToolBar.class.getResource("TextFormat_ButtonPressed.png"));
        public static ImageIcon ICON_TEXT_BOLD = new ImageIcon(TextToolBar.class.getResource("TextFormat_Bold.png"));
        public static ImageIcon ICON_TEXT_ITALIC = new ImageIcon(TextToolBar.class.getResource("TextFormat_Italic.png"));
        public static ImageIcon ICON_TEXT_FOREGROUND = new ImageIcon(TextToolBar.class.getResource("TextFormat_Foreground.png"));
        public static ImageIcon ICON_TEXT_BACKGROUND = new ImageIcon(TextToolBar.class.getResource("TextFormat_Background.png"));
        public static ImageIcon ICON_TEXT_UNDERLINE = new ImageIcon(TextToolBar.class.getResource("TextFormat_Underline.png"));
        public static ImageIcon ICON_TEXT_FONTSIZE = new ImageIcon(TextToolBar.class.getResource("TextFormat_FontSize.png"));
        public static ImageIcon ICON_TEXT_SAVE = new ImageIcon(TextToolBar.class.getResource("TextFormat_Save.png"));
        public static ImageIcon ICON_TEXT_LOAD = new ImageIcon(TextToolBar.class.getResource("TextFormat_Load.png"));
        public static ImageIcon ICON_TEXT_PRINT = new ImageIcon(TextToolBar.class.getResource("TextFormat_Print.png"));
        public static ImageIcon ICON_TEXT_UNDO = new ImageIcon(TextToolBar.class.getResource("TextFormat_Undo.png"));
        public static ImageIcon ICON_TEXT_REDO = new ImageIcon(TextToolBar.class.getResource("TextFormat_Redo.png"));
        @LiveLanguageString
        public static String FONT = "Font/Size";
        @LiveLanguageString
        public static String FOREGROUND = "Foreground";
        @LiveLanguageString
        public static String BACKGROUND = "Background";
        @LiveLanguageString
        public static String BOLD = "Bold";
        @LiveLanguageString
        public static String ITALIC = "Italic";
        @LiveLanguageString
        public static String UNDERLINE = "Underline";
        @LiveLanguageString
        public static String SAVE = "Save";
        @LiveLanguageString
        public static String LOAD = "Load";
        @LiveLanguageString
        public static String PRINT = "Print";
        @LiveLanguageString
        public static String UNDO_TEXT = "Undo";
        @LiveLanguageString
        public static String REDO_TEXT = "Redo";
        public static FontSizeChooser s_FontSizeChooser = new FontSizeChooser();
        protected RTFDocumentKit m_RTFDocumentKit;
        protected JButton jButton_Bold;
        protected JButton jButton_Italic;
        protected JButton jButton_Font;
        protected JButton jButton_Foreground;
        protected JButton jButton_Underline;
        protected JButton jButton_Print;
        protected JButton jButton_Undo;
        protected JButton jButton_Redo;
        private TextToolBar m_SelfReference = this;

        public TextToolBar(RTFDocumentKit p_RTFDocumentKit, boolean p_ShowPrintButton) {
            this.m_RTFDocumentKit = p_RTFDocumentKit;
            LiveLanguage.addLanguageListener(this, null);
            this.initComponents();
            if (!p_ShowPrintButton) {
                this.jButton_Print.setVisible(false);
            }
            if (this.m_RTFDocumentKit != null) {
                JTextPane o_JTextPane = this.m_RTFDocumentKit.getJTextPane();
                if (o_JTextPane != null) {
                    o_JTextPane.addFocusListener(this);
                }
                RTFUndoManager o_RTFUndoManager = this.m_RTFDocumentKit.getUndoManager();
                o_RTFUndoManager.addPropertyChangeListener(this);
            }
            this.refreshUndoButtons();
        }

        private void initMembers() {
        }

        private void initComponents() {
            this.jButton_Undo = new JButton();
            this.jButton_Undo.setBackground(Color.BLACK);
            this.jButton_Undo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (m_RTFDocumentKit == null) {
                        return;
                    }
                    RTFUndoManager o_UndoManager = m_RTFDocumentKit.getUndoManager();
                    if (o_UndoManager != null) {
                        ((UndoManager)o_UndoManager).undo();
                        this.refreshUndoButtons();
                    }
                }
            });
            this.jButton_Undo.setText("");
            this.jButton_Undo.setIconTextGap(0);
            this.jButton_Undo.setToolTipText(PRINT);
            this.jButton_Undo.setBorder(new EmptyBorder(1, 1, 1, 1));
            this.jButton_Undo.setBorderPainted(false);
            this.jButton_Undo.setMargin(new Insets(-1, -1, -1, -1));
            this.jButton_Undo.setContentAreaFilled(false);
            this.jButton_Undo.setOpaque(false);
            this.jButton_Undo.setIcon(ICON_TEXT_UNDO);
            this.jButton_Undo.setPressedIcon(ICON_TEXT_BUTTONPRESSED);
            this.jButton_Redo = new JButton();
            this.jButton_Redo.setBackground(Color.BLACK);
            this.jButton_Redo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (m_RTFDocumentKit == null) {
                        return;
                    }
                    RTFUndoManager o_UndoManager = m_RTFDocumentKit.getUndoManager();
                    if (o_UndoManager != null) {
                        ((UndoManager)o_UndoManager).redo();
                        this.refreshUndoButtons();
                    }
                }
            });
            this.jButton_Redo.setText("");
            this.jButton_Redo.setIconTextGap(0);
            this.jButton_Redo.setToolTipText(PRINT);
            this.jButton_Redo.setBorder(new EmptyBorder(1, 1, 1, 1));
            this.jButton_Redo.setBorderPainted(false);
            this.jButton_Redo.setMargin(new Insets(-1, -1, -1, -1));
            this.jButton_Redo.setContentAreaFilled(false);
            this.jButton_Redo.setOpaque(false);
            this.jButton_Redo.setIcon(ICON_TEXT_REDO);
            this.jButton_Redo.setPressedIcon(ICON_TEXT_BUTTONPRESSED);
            this.jButton_Print = new JButton();
            this.jButton_Print.setBackground(Color.BLACK);
            this.jButton_Print.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (m_RTFDocumentKit == null) {
                        return;
                    }
                    m_RTFDocumentKit.print();
                }
            });
            this.jButton_Print.setText("");
            this.jButton_Print.setIconTextGap(0);
            this.jButton_Print.setToolTipText(PRINT);
            this.jButton_Print.setBorder(new EmptyBorder(1, 1, 1, 1));
            this.jButton_Print.setBorderPainted(false);
            this.jButton_Print.setMargin(new Insets(-1, -1, -1, -1));
            this.jButton_Print.setContentAreaFilled(false);
            this.jButton_Print.setOpaque(false);
            this.jButton_Print.setIcon(ICON_TEXT_PRINT);
            this.jButton_Print.setPressedIcon(ICON_TEXT_BUTTONPRESSED);
            this.jButton_Bold = new JButton();
            this.jButton_Bold.setBackground(Color.BLACK);
            this.jButton_Bold.setAction(new BoldAction(this.m_RTFDocumentKit));
            this.jButton_Bold.setText("");
            this.jButton_Bold.setIconTextGap(0);
            this.jButton_Bold.setToolTipText(BOLD);
            this.jButton_Bold.setBorder(new EmptyBorder(1, 1, 1, 1));
            this.jButton_Bold.setBorderPainted(false);
            this.jButton_Bold.setMargin(new Insets(-1, -1, -1, -1));
            this.jButton_Bold.setContentAreaFilled(false);
            this.jButton_Bold.setOpaque(false);
            this.jButton_Bold.setIcon(ICON_TEXT_BOLD);
            this.jButton_Bold.setPressedIcon(ICON_TEXT_BUTTONPRESSED);
            this.jButton_Italic = new JButton();
            this.jButton_Italic.setBackground(Color.BLACK);
            this.jButton_Italic.setAction(new ItalicAction(this.m_RTFDocumentKit));
            this.jButton_Italic.setText("");
            this.jButton_Italic.setIconTextGap(0);
            this.jButton_Italic.setToolTipText(ITALIC);
            this.jButton_Italic.setBorder(new EmptyBorder(1, 1, 1, 1));
            this.jButton_Italic.setBorderPainted(false);
            this.jButton_Italic.setMargin(new Insets(-1, -1, -1, -1));
            this.jButton_Italic.setContentAreaFilled(false);
            this.jButton_Italic.setOpaque(false);
            this.jButton_Italic.setIcon(ICON_TEXT_ITALIC);
            this.jButton_Italic.setPressedIcon(ICON_TEXT_BUTTONPRESSED);
            this.jButton_Font = new JButton();
            this.jButton_Font.setBackground(Color.BLACK);
            this.jButton_Font.setAction(new FontAndSizeAction(this.m_RTFDocumentKit));
            this.jButton_Font.setText("");
            this.jButton_Font.setIconTextGap(0);
            this.jButton_Font.setToolTipText(FONT);
            this.jButton_Font.setBorder(new EmptyBorder(1, 1, 1, 1));
            this.jButton_Font.setBorderPainted(false);
            this.jButton_Font.setMargin(new Insets(-1, -1, -1, -1));
            this.jButton_Font.setContentAreaFilled(false);
            this.jButton_Font.setOpaque(false);
            this.jButton_Font.setIcon(new ImageIcon(RTFDocumentKit.class.getResource("TextFormat_FontSize.png")));
            this.jButton_Font.setPressedIcon(ICON_TEXT_BUTTONPRESSED);
            this.jButton_Foreground = new JButton();
            this.jButton_Foreground.setBackground(Color.BLACK);
            this.jButton_Foreground.setAction(new ForegroundAction(this.m_RTFDocumentKit));
            this.jButton_Foreground.setText("");
            this.jButton_Foreground.setIconTextGap(0);
            this.jButton_Foreground.setToolTipText(FOREGROUND);
            this.jButton_Foreground.setBorder(new EmptyBorder(1, 1, 1, 1));
            this.jButton_Foreground.setBorderPainted(false);
            this.jButton_Foreground.setMargin(new Insets(-1, -1, -1, -1));
            this.jButton_Foreground.setContentAreaFilled(false);
            this.jButton_Foreground.setOpaque(false);
            this.jButton_Foreground.setIcon(new ImageIcon(RTFDocumentKit.class.getResource("TextFormat_Foreground.png")));
            this.jButton_Foreground.setPressedIcon(ICON_TEXT_BUTTONPRESSED);
            this.jButton_Underline = new JButton();
            this.jButton_Underline.setBackground(Color.BLACK);
            this.jButton_Underline.setAction(new UnderlineAction(this.m_RTFDocumentKit));
            this.jButton_Underline.setText("");
            this.jButton_Underline.setIconTextGap(0);
            this.jButton_Underline.setToolTipText(UNDERLINE);
            this.jButton_Underline.setBorder(new EmptyBorder(1, 1, 1, 1));
            this.jButton_Underline.setBorderPainted(false);
            this.jButton_Underline.setMargin(new Insets(-1, -1, -1, -1));
            this.jButton_Underline.setContentAreaFilled(false);
            this.jButton_Underline.setOpaque(false);
            this.jButton_Underline.setIcon(new ImageIcon(RTFDocumentKit.class.getResource("TextFormat_Underline.png")));
            this.jButton_Underline.setPressedIcon(ICON_TEXT_BUTTONPRESSED);
            this.add(this.jButton_Print);
            this.add(this.jButton_Undo);
            this.add(this.jButton_Redo);
            this.add(this.jButton_Font);
            this.add(this.jButton_Bold);
            this.add(this.jButton_Italic);
            this.add(this.jButton_Underline);
            this.add(this.jButton_Foreground);
            this.jButton_Bold.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
            this.jButton_Font.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
            this.jButton_Foreground.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
            this.jButton_Italic.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
            this.jButton_Underline.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
            this.jButton_Print.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
            this.jButton_Undo.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
            this.jButton_Redo.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        }

        public void close() {
            if (this.m_RTFDocumentKit != null) {
                RTFUndoManager o_RTFUndoManager = this.m_RTFDocumentKit.getUndoManager();
                o_RTFUndoManager.removePropertyChangeListener(this);
            }
        }

        public JButton getButtonBold() {
            return this.jButton_Bold;
        }

        public JButton getButtonFont() {
            return this.jButton_Font;
        }

        public JButton getButtonForeground() {
            return this.jButton_Foreground;
        }

        public JButton getButtonItalic() {
            return this.jButton_Italic;
        }

        public JButton getButtonUnderline() {
            return this.jButton_Underline;
        }

        public JButton getButtonPrint() {
            return this.jButton_Print;
        }

        public void refreshUndoButtons() {
            if (this.m_RTFDocumentKit != null) {
                RTFUndoManager o_UndoManager = this.m_RTFDocumentKit.getUndoManager();
                if (o_UndoManager != null) {
                    if (o_UndoManager.canUndo()) {
                        this.jButton_Undo.setEnabled(true);
                    } else {
                        this.jButton_Undo.setEnabled(false);
                    }
                    this.jButton_Undo.setToolTipText(o_UndoManager.getUndoPresentationName());
                }
                if (o_UndoManager != null) {
                    if (o_UndoManager.canRedo()) {
                        this.jButton_Redo.setEnabled(true);
                    } else {
                        this.jButton_Redo.setEnabled(false);
                    }
                    this.jButton_Redo.setToolTipText(o_UndoManager.getRedoPresentationName());
                }
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.setEnabled(true);
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.setEnabled(false);
        }

        @Override
        public void setEnabled(boolean p_Enabled) {
            super.setEnabled(p_Enabled);
            for (int intButton = 0; intButton < super.getComponentCount(); ++intButton) {
                Component o_Component = super.getComponent(intButton);
                if (o_Component == null || o_Component == this.jButton_Print || o_Component == this.jButton_Undo || o_Component == this.jButton_Redo) continue;
                o_Component.setEnabled(p_Enabled);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof RTFUndoManager) {
                this.refreshUndoButtons();
            }
        }
    }

    class RedoAction
    extends AbstractAction {
        private RTFDocumentKit m_RTFDocumentKit;

        public RedoAction(RTFDocumentKit p_RTFDocumentKit) {
            super(REDO_TEXT);
            this.m_RTFDocumentKit = p_RTFDocumentKit;
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.m_RTFDocumentKit == null) {
                return;
            }
            StyledDocument o_Document = this.m_RTFDocumentKit.getStyledDocument();
            try {
                RTFUndoManager o_RTFUndoManager = this.m_RTFDocumentKit.getUndoManager();
                if (o_RTFUndoManager.getUndoSequenceStarted_Replace()) {
                    o_RTFUndoManager.endUndoSequence_Replace();
                }
                RTFDocumentKit.this.m_RTFUndoManager.redo();
            }
            catch (CannotRedoException ex) {
                System.out.println("Unable to redo: " + ex);
            }
            this.updateRedoState();
            RTFDocumentKit.this.m_UndoAction.updateUndoState();
        }

        protected void updateRedoState() {
            if (RTFDocumentKit.this.m_RTFUndoManager.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", RTFDocumentKit.this.m_RTFUndoManager.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", REDO_TEXT);
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        private RTFDocumentKit m_RTFDocumentKit;

        public UndoAction(RTFDocumentKit p_RTFDocumentKit) {
            super(UNDO_TEXT);
            this.m_RTFDocumentKit = p_RTFDocumentKit;
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.m_RTFDocumentKit == null) {
                return;
            }
            StyledDocument o_Document = this.m_RTFDocumentKit.getStyledDocument();
            try {
                RTFUndoManager o_RTFUndoManager = this.m_RTFDocumentKit.getUndoManager();
                if (o_RTFUndoManager.getUndoSequenceStarted_Replace()) {
                    o_RTFUndoManager.endUndoSequence_Replace();
                }
                RTFDocumentKit.this.m_RTFUndoManager.undo();
            }
            catch (CannotUndoException ex) {
                System.out.println("Unable to undo: " + ex);
            }
            this.updateUndoState();
            RTFDocumentKit.this.m_RedoAction.updateRedoState();
        }

        protected void updateUndoState() {
            if (RTFDocumentKit.this.m_RTFUndoManager.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", RTFDocumentKit.this.m_RTFUndoManager.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", UNDO_TEXT);
            }
        }
    }

    public static class RTFUndoManager
    extends UndoManager
    implements UndoableEditListener {
        public static String PROP_UNDOREDOCHANGE = "prop_undoredochange";
        private RTFDocumentKit m_RTFDocumentKit;
        private PropertyChangeSupport m_PropertyChangeSupport;
        private boolean m_UndoSequenceStarted_Insert;
        private CompoundEdit m_UndoSequence_Edit_Insert;
        private boolean m_UndoSequenceStarted_Replace;
        private CompoundEdit m_UndoSequence_Edit_Replace;

        public RTFUndoManager(RTFDocumentKit p_RTFDocumentKit) {
            this.initMembers();
            this.m_RTFDocumentKit = p_RTFDocumentKit;
        }

        private void initMembers() {
            this.m_PropertyChangeSupport = new PropertyChangeSupport(this);
            this.m_UndoSequenceStarted_Insert = false;
            this.m_UndoSequence_Edit_Insert = null;
            this.m_UndoSequenceStarted_Replace = false;
            this.m_UndoSequence_Edit_Replace = null;
        }

        public void clear() {
            super.discardAllEdits();
            this.m_PropertyChangeSupport.firePropertyChange(PROP_UNDOREDOCHANGE, false, true);
        }

        public void startUndoSequence_Insert(String p_PresentationName) {
            if (this.m_UndoSequenceStarted_Insert) {
                return;
            }
            this.endUndoSequence_Replace();
            this.m_UndoSequenceStarted_Insert = true;
            this.m_UndoSequence_Edit_Insert = new CompoundEdit_Insert(p_PresentationName);
            this.addEdit(this.m_UndoSequence_Edit_Insert);
        }

        public void endUndoSequence_Insert() {
            if (!this.m_UndoSequenceStarted_Insert) {
                return;
            }
            this.m_UndoSequenceStarted_Insert = false;
            if (this.m_UndoSequence_Edit_Insert == null) {
                return;
            }
            this.m_UndoSequence_Edit_Insert.end();
            this.m_UndoSequence_Edit_Insert = null;
            this.m_PropertyChangeSupport.firePropertyChange(PROP_UNDOREDOCHANGE, false, true);
        }

        public boolean getUndoSequenceStarted_Insert() {
            return this.m_UndoSequenceStarted_Insert;
        }

        public void startUndoSequence_Replace(String p_PresentationName) {
            if (this.m_UndoSequenceStarted_Replace) {
                return;
            }
            this.m_UndoSequenceStarted_Replace = true;
            this.m_UndoSequence_Edit_Replace = new CompoundEdit_Replace(p_PresentationName);
            this.addEdit(this.m_UndoSequence_Edit_Replace);
        }

        public void endUndoSequence_Replace() {
            if (!this.m_UndoSequenceStarted_Replace) {
                return;
            }
            this.m_UndoSequenceStarted_Replace = false;
            if (this.m_UndoSequence_Edit_Replace == null) {
                return;
            }
            this.m_UndoSequence_Edit_Replace.end();
            this.m_UndoSequence_Edit_Replace = null;
            this.m_PropertyChangeSupport.firePropertyChange(PROP_UNDOREDOCHANGE, false, true);
        }

        public boolean getUndoSequenceStarted_Replace() {
            return this.m_UndoSequenceStarted_Replace;
        }

        @Override
        public void undo() {
            try {
                super.undo();
                this.m_PropertyChangeSupport.firePropertyChange(PROP_UNDOREDOCHANGE, false, true);
                if (this.m_RTFDocumentKit != null) {
                    this.m_RTFDocumentKit.eventUndoDone();
                }
                this.m_RTFDocumentKit.getJTextPane().requestFocusInWindow();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void redo() {
            try {
                super.redo();
                this.m_PropertyChangeSupport.firePropertyChange(PROP_UNDOREDOCHANGE, false, true);
                if (this.m_RTFDocumentKit != null) {
                    this.m_RTFDocumentKit.eventRedoDone();
                }
                this.m_RTFDocumentKit.getJTextPane().requestFocusInWindow();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            if (this.m_UndoSequenceStarted_Insert) {
                if (this.m_UndoSequence_Edit_Insert == null) {
                    this.m_UndoSequence_Edit_Insert = new CompoundEdit_Insert(null);
                    this.addEdit(this.m_UndoSequence_Edit_Insert);
                }
                this.m_UndoSequence_Edit_Insert.addEdit(e.getEdit());
            } else if (this.m_UndoSequenceStarted_Replace) {
                if (this.m_UndoSequence_Edit_Replace == null) {
                    this.m_UndoSequence_Edit_Replace = new CompoundEdit_Replace(null);
                    this.addEdit(this.m_UndoSequence_Edit_Replace);
                }
                this.m_UndoSequence_Edit_Replace.addEdit(e.getEdit());
            } else {
                this.addEdit(e.getEdit());
            }
            this.m_PropertyChangeSupport.firePropertyChange(PROP_UNDOREDOCHANGE, false, true);
        }

        public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
            if (p_PropertyChangeListener == null) {
                return;
            }
            if (this.m_PropertyChangeSupport != null) {
                this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
            }
        }

        public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
            if (this.m_PropertyChangeSupport != null) {
                this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
            }
        }

        public static class CompoundEdit_Replace
        extends CompoundEdit {
            private String m_PresentationName = "";

            public CompoundEdit_Replace(String p_PresentationName) {
                this.m_PresentationName = p_PresentationName;
            }

            @Override
            public boolean isInProgress() {
                return false;
            }

            @Override
            public String getPresentationName() {
                if (this.m_PresentationName == null || this.m_PresentationName.length() <= 0) {
                    return super.getPresentationName();
                }
                return this.m_PresentationName;
            }

            @Override
            public String getUndoPresentationName() {
                if (this.m_PresentationName == null || this.m_PresentationName.length() <= 0) {
                    return super.getUndoPresentationName();
                }
                return UIManager.getString("AbstractDocument.undoText") + " " + this.getPresentationName();
            }

            @Override
            public String getRedoPresentationName() {
                if (this.m_PresentationName == null || this.m_PresentationName.length() <= 0) {
                    return super.getRedoPresentationName();
                }
                return UIManager.getString("AbstractDocument.redoText") + " " + this.getPresentationName();
            }
        }

        public static class CompoundEdit_Insert
        extends CompoundEdit {
            private String m_PresentationName = "";

            public CompoundEdit_Insert(String p_PresentationName) {
                this.m_PresentationName = p_PresentationName;
            }

            @Override
            public String getPresentationName() {
                if (this.m_PresentationName == null || this.m_PresentationName.length() <= 0) {
                    return super.getPresentationName();
                }
                return this.m_PresentationName;
            }

            @Override
            public String getUndoPresentationName() {
                if (this.m_PresentationName == null || this.m_PresentationName.length() <= 0) {
                    return super.getUndoPresentationName();
                }
                return UIManager.getString("AbstractDocument.undoText") + " " + this.getPresentationName();
            }

            @Override
            public String getRedoPresentationName() {
                if (this.m_PresentationName == null || this.m_PresentationName.length() <= 0) {
                    return super.getRedoPresentationName();
                }
                return UIManager.getString("AbstractDocument.redoText") + " " + this.getPresentationName();
            }
        }
    }

    public static interface RTFDocumentKit_EventListener {
        public boolean eventPrintWillStart(RTFDocumentKit var1);

        public void eventPrintDone(RTFDocumentKit var1, boolean var2);

        public void eventUndoDone(RTFDocumentKit var1);

        public void eventRedoDone(RTFDocumentKit var1);
    }

    public static class RTFDocumentFilter
    extends DocumentFilter {
        private RTFDocumentKit m_RTFDocumentKit;
        private int m_InsertPosition;
        private int m_LastCharType;
        private int LASTCHAR_UNKNOWN = -1;
        private int LASTCHAR_ALPHANUMERIC = 1;
        private int LASTCHAR_SPECIAL = 2;

        public RTFDocumentFilter(RTFDocumentKit p_RTFDocumentKit) {
            this.m_RTFDocumentKit = p_RTFDocumentKit;
            this.initMembers();
        }

        private void initMembers() {
            this.m_InsertPosition = -1;
            this.m_LastCharType = -1;
        }

        public void setInsertPosition(int p_Position) {
            this.m_InsertPosition = p_Position;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertString(DocumentFilter.FilterBypass p_FilterBypass, int offs, String str, AttributeSet a) throws BadLocationException {
            Document document = p_FilterBypass.getDocument();
            synchronized (document) {
                int intInsertPosition;
                RTFUndoManager o_RTFUndoManager = this.m_RTFDocumentKit.getUndoManager();
                o_RTFUndoManager.endUndoSequence_Replace();
                this.m_LastCharType = this.LASTCHAR_UNKNOWN;
                if (this.m_InsertPosition >= 0) {
                    intInsertPosition = this.m_InsertPosition;
                    this.m_InsertPosition = -1;
                } else {
                    intInsertPosition = this.m_RTFDocumentKit != null ? this.m_RTFDocumentKit.getCaretPosition() : offs;
                }
                super.insertString(p_FilterBypass, intInsertPosition, str, a);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offs, int length, String str, AttributeSet a) throws BadLocationException {
            boolean boolIsAlphaNumeric = false;
            RTFUndoManager o_RTFUndoManager = this.m_RTFDocumentKit.getUndoManager();
            Document document = fb.getDocument();
            synchronized (document) {
                if (str.length() == 1) {
                    boolIsAlphaNumeric = this.isAlphaNumeric(str.charAt(0));
                }
                if (this.m_LastCharType == this.LASTCHAR_UNKNOWN) {
                    o_RTFUndoManager.endUndoSequence_Replace();
                    o_RTFUndoManager.startUndoSequence_Replace(null);
                } else if (this.m_LastCharType == this.LASTCHAR_ALPHANUMERIC) {
                    if (!boolIsAlphaNumeric) {
                        o_RTFUndoManager.endUndoSequence_Replace();
                        o_RTFUndoManager.startUndoSequence_Replace(null);
                    }
                } else if (this.m_LastCharType == this.LASTCHAR_SPECIAL && boolIsAlphaNumeric) {
                    o_RTFUndoManager.endUndoSequence_Replace();
                    o_RTFUndoManager.startUndoSequence_Replace(null);
                }
                this.m_LastCharType = boolIsAlphaNumeric ? this.LASTCHAR_ALPHANUMERIC : this.LASTCHAR_SPECIAL;
                super.replace(fb, offs, length, str, a);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            StyledDocument o_Document;
            int intPosition = offset;
            int intEndOffset = offset + length;
            StyledDocument styledDocument = o_Document = (StyledDocument)fb.getDocument();
            synchronized (styledDocument) {
                while (intPosition < intEndOffset && intPosition < fb.getDocument().getLength()) {
                    try {
                        Element o_Element = o_Document.getCharacterElement(intPosition);
                        if (o_Element == null) break;
                        AttributeSet o_AttributeSet = o_Element.getAttributes();
                        Component o_Component = StyleConstants.getComponent(o_AttributeSet);
                        if (o_Component != null) {
                            if (offset > o_Element.getStartOffset()) {
                                offset = o_Element.getStartOffset();
                            }
                            if (offset + length < o_Element.getEndOffset()) {
                                length = o_Element.getEndOffset() - offset;
                            }
                        }
                        intPosition = o_Element.getEndOffset();
                    }
                    catch (Exception exception) {}
                }
                RTFUndoManager o_RTFUndoManager = this.m_RTFDocumentKit.getUndoManager();
                o_RTFUndoManager.endUndoSequence_Replace();
                this.m_LastCharType = this.LASTCHAR_UNKNOWN;
                super.remove(fb, offset, length);
            }
        }

        public boolean isAlphaNumeric(char p_Char) {
            if (Character.isAlphabetic(p_Char)) {
                return true;
            }
            return Character.isDigit(p_Char);
        }
    }

    public static class AttributeComponent_Element {
        private AttributeComponent m_AttributeComponent = null;
        private Element m_Element = null;

        public AttributeComponent_Element(AttributeComponent p_AttributeComponent, Element p_Element) {
            this.m_AttributeComponent = p_AttributeComponent;
            this.m_Element = p_Element;
        }

        public AttributeComponent getAttributeComponent() {
            return this.m_AttributeComponent;
        }

        public Element getElement() {
            return this.m_Element;
        }
    }

    public static interface AttributeComponent {
        public String getContent_ID();

        public String getContent_Name();

        public String getCode();

        public String getContent_PrintString();

        public Icon getContent_PrintIcon();

        public Color getContent_PrintForeground();

        public Color getContent_PrintBackground();
    }
}

