/*
 * Decompiled with CFR 0.152.
 */
package LiveShowVirtualPackage;

import LiveShowObjectPackage.LiveShowObjectDescription;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowObjectPackage.LiveShowObjectPanel;
import LiveShowPlayPackage.EditControlCursor;
import LiveShowPlayPackage.Play;
import LiveShowPlayPackage.PlayControlCursor;
import LiveShowPlayPackage.PlayListener;
import LiveShowScrollPackage.LiveShowScrollBarListener;
import LiveShowScrollPackage.LiveShowViewListener;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import LiveShowVirtualPackage.LiveShowSceneBridgePanel;
import LiveShowVirtualPackage.LiveShowVIP;
import LiveShowVirtualPackage.LiveShowVIPListener;
import LiveShowVirtualPackage.LiveShowVIPTrack;
import LiveShowVirtualPackage.LiveShowVIPTrackPanel;
import SynchronizationPackage.EventQueueHandler;
import SynchronizationPackage.LiveCloseSemaphore;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class LiveShowVIPPanel
extends JPanel
implements LiveShowVIPListener,
PlayListener,
ComponentListener,
LiveShowScrollBarListener {
    public static final int SNAPDISTANCE = 20;
    private LiveShowVIP m_LiveShowVIP;
    private ArrayList<LiveShowVIPTrackPanel> m_LiveShowVIPTrackPanels;
    private ArrayList<LiveShowSceneBridgePanel> m_LiveShowSceneBridgePanels;
    private ArrayList<LiveShowViewListener> m_LiveShowViewListeners;
    private long m_VisibleFrameStart;
    private long m_VisibleFrameEnd;
    private LiveCloseSemaphore m_LiveCloseSemaphore;
    private final Object m_SyncVIPTracks = new Object();
    private long m_FramePlayCursor;
    private PlayControlCursor m_PlayControlCursor;
    private long m_FrameEditCursor;
    private EditControlCursor m_EditControlCursor;
    private LiveShowVIPPanel m_SelfReference;
    private Dimension m_OldSize;
    private Runnable m_Runnable_CalculatePlayCursor = new Runnable(){

        @Override
        public void run() {
            try {
                if (LiveShowVIPPanel.this.calculatePlayCursor()) {
                    LiveShowVIPPanel.this.revalidate();
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    };
    private Runnable m_Runnable_CalculateEditCursor = new Runnable(){

        @Override
        public void run() {
            try {
                if (LiveShowVIPPanel.this.calculateEditCursor()) {
                    LiveShowVIPPanel.this.revalidate();
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    };
    private Runnable m_Runnable_RepaintParts = new Runnable(){

        @Override
        public void run() {
            try {
                LiveShowVIPPanel.this.repaintParts();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    };
    private Runnable m_Runnable_Resized = new Runnable(){

        @Override
        public void run() {
            try {
                LiveShowVIPPanel.this.calculatePaint();
                LiveShowVIPPanel.this.calculatePlayCursor();
                LiveShowVIPPanel.this.calculateEditCursor();
                LiveShowVIPPanel.this.notifyViewListeners_ViewChanged(LiveShowVIPPanel.this.getFrameStart(), LiveShowVIPPanel.this.getFrameEnd(), LiveShowVIPPanel.this.m_VisibleFrameStart, LiveShowVIPPanel.this.m_VisibleFrameEnd, LiveShowVIPPanel.this.getBounds());
                LiveShowVIPPanel.this.revalidate();
                LiveShowVIPPanel.this.repaint();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    };
    private Runnable m_Runnable_Repaint = new Runnable(){

        @Override
        public void run() {
            try {
                if (LiveShowVIPPanel.this.m_SelfReference != null) {
                    LiveShowVIPPanel.this.m_SelfReference.repaintSuper();
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    };
    private Runnable m_Runnable_Revalidate = new Runnable(){

        @Override
        public void run() {
            try {
                if (LiveShowVIPPanel.this.m_SelfReference != null) {
                    LiveShowVIPPanel.this.m_SelfReference.revalidateSuper();
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    };
    private final Object m_SyncViewListeners = new Object();
    private final Object m_SyncBridgeObjects = new Object();
    public final Object m_SyncScroll = new Object();
    private boolean m_ScrollAutomatic = true;
    private boolean m_ScrollAutomaticOn = true;
    private Thread m_ScrollThread;
    private Runnable m_ScrollRunnable;
    private int m_ScrollAction;
    private LiveShowObjectInterface m_ScrollLiveShowObjectInterface;
    private LiveShowObjectDescription m_ScrollObjectDescription;
    private LiveShowVIP.LiveShowVIPStatus m_ScrollVIPStatus;
    private long m_ScrollFrameDifference;
    private Runnable m_RunnableRepaint;
    private boolean isSettingZoom = false;
    private Runnable m_RunnableEndZoom = new Runnable(){

        @Override
        public void run() {
            LiveShowVIPPanel.this.isSettingZoom = false;
        }
    };

    public LiveShowVIPPanel(LiveShowVIP p_LiveShowVIP) {
        this.initMembers();
        this.m_SelfReference = this;
        this.m_LiveShowVIP = p_LiveShowVIP;
        this.m_LiveShowVIP.addLiveShowVIPListener(this);
        this.m_LiveShowVIP.setLiveShowVIPPanel(this);
        this.initComponents();
        for (int intObject = 0; intObject < this.m_LiveShowVIP.getLiveShowVipTrackCount(); ++intObject) {
            LiveShowVIPTrack o_LiveShowVIPTrack = this.m_LiveShowVIP.getLiveShowVIPTrack(intObject);
            this.eventVIPTrackAdded(this.m_LiveShowVIP, o_LiveShowVIPTrack);
        }
        for (int intSceneBridge = 0; intSceneBridge < this.m_LiveShowVIP.getLiveShowSceneBridgeCount(); ++intSceneBridge) {
            LiveShowSceneBridge o_LiveShowSceneBridge = this.m_LiveShowVIP.getLiveShowSceneBridge(intSceneBridge);
            this.eventVIPSceneBridgeAdded(this.m_LiveShowVIP, o_LiveShowSceneBridge);
        }
        this.m_EditControlCursor = new EditControlCursor();
        this.m_EditControlCursor.setVisible(false);
        this.add(this.m_EditControlCursor, this.m_EditControlCursor.getAbsoluteConstraints(), 0);
        this.m_PlayControlCursor = new PlayControlCursor();
        this.m_PlayControlCursor.setForeground(this.m_LiveShowVIP.getPlay().getColor());
        this.m_PlayControlCursor.setVisible(this.m_LiveShowVIP.getActive());
        this.add(this.m_PlayControlCursor, this.m_PlayControlCursor.getAbsoluteConstraints(), 0);
        this.setComponentZOrder(this.m_PlayControlCursor, 0);
        this.setComponentZOrder(this.m_EditControlCursor, 0);
        this.m_VisibleFrameStart = this.m_LiveShowVIP.getFrameStart();
        this.m_VisibleFrameEnd = this.m_LiveShowVIP.getFrameEnd();
        this.calculatePaint();
        this.setVisibleRegion(this.m_VisibleFrameStart, this.m_VisibleFrameEnd);
        this.m_LiveShowVIP.getPlay().addPlayListener(this);
    }

    private void initMembers() {
        this.m_LiveCloseSemaphore = new LiveCloseSemaphore(this.getClass().getSimpleName());
        this.m_OldSize = new Dimension(0, 0);
        this.m_LiveShowVIPTrackPanels = new ArrayList();
        this.m_LiveShowSceneBridgePanels = new ArrayList();
        this.m_VisibleFrameStart = 0L;
        this.m_VisibleFrameEnd = 0L;
        this.m_LiveShowViewListeners = new ArrayList();
        this.m_RunnableRepaint = new Runnable(){

            @Override
            public void run() {
                LiveShowVIPPanel.this.revalidate();
                LiveShowVIPPanel.this.repaint();
            }
        };
        this.m_ScrollAutomatic = true;
        this.m_ScrollAutomaticOn = false;
        this.m_ScrollFrameDifference = 0L;
        this.m_ScrollRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (LiveShowVIPPanel.this.m_ScrollAutomatic) {
                    long longFrameDifference;
                    LiveShowVIP o_LiveShowVIP;
                    LiveShowVIP.LiveShowVIPStatus o_LiveShowVIPStatus;
                    LiveShowObjectDescription o_LiveShowObjectDescription;
                    LiveShowObjectInterface o_LiveShowObjectInterface;
                    int intScrollAction;
                    Object object = LiveShowVIPPanel.this.m_SyncScroll;
                    synchronized (object) {
                        intScrollAction = LiveShowVIPPanel.this.m_ScrollAction;
                        o_LiveShowObjectInterface = LiveShowVIPPanel.this.m_ScrollLiveShowObjectInterface;
                        o_LiveShowObjectDescription = LiveShowVIPPanel.this.m_ScrollObjectDescription;
                        o_LiveShowVIPStatus = LiveShowVIPPanel.this.m_ScrollVIPStatus;
                        o_LiveShowVIP = LiveShowVIPPanel.this.m_LiveShowVIP;
                        if (!LiveShowVIPPanel.this.m_ScrollAutomaticOn || LiveShowVIPPanel.this.m_ScrollFrameDifference == 0L || o_LiveShowObjectInterface == null && o_LiveShowObjectDescription == null) {
                            try {
                                LiveShowVIPPanel.this.m_SyncScroll.wait();
                                continue;
                            }
                            catch (Exception e) {
                                break;
                            }
                        }
                        longFrameDifference = LiveShowVIPPanel.this.m_ScrollFrameDifference;
                        long longVisibleFrameStart = LiveShowVIPPanel.this.m_VisibleFrameStart;
                        long longVisibleFrameEnd = LiveShowVIPPanel.this.m_VisibleFrameEnd;
                    }
                    try {
                        Thread.sleep(20L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!LiveShowVIPPanel.this.m_ScrollAutomaticOn || LiveShowVIPPanel.this.m_ScrollFrameDifference == 0L) continue;
                    if (o_LiveShowVIP != null) {
                        switch (intScrollAction) {
                            case 99: {
                                if (o_LiveShowObjectDescription == null) break;
                                long longFrameOldValue = o_LiveShowObjectDescription.getFrameStart();
                                long longFrameNewValue = longFrameOldValue + longFrameDifference;
                                if (longFrameNewValue < 0L) {
                                    longFrameNewValue = 0L;
                                }
                                o_LiveShowVIP.doActionMoveObjects(longFrameNewValue, o_LiveShowObjectDescription, o_LiveShowVIPStatus);
                                longFrameDifference = longFrameNewValue - longFrameOldValue;
                                break;
                            }
                            case 4: {
                                if (o_LiveShowObjectInterface == null) break;
                                long longFrameOldValue = o_LiveShowObjectDescription.getFrameStart();
                                long longFrameNewValue = longFrameOldValue + longFrameDifference;
                                if (longFrameNewValue < 0L) {
                                    longFrameNewValue = 0L;
                                }
                                o_LiveShowObjectInterface.setFrameStartResize(longFrameNewValue);
                                longFrameDifference = longFrameNewValue - longFrameOldValue;
                                break;
                            }
                            case 5: {
                                if (o_LiveShowObjectInterface == null) break;
                                long longFrameOldValue = o_LiveShowObjectDescription.getFrameLength();
                                long longFrameNewValue = longFrameOldValue + longFrameDifference;
                                if (longFrameNewValue < 0L) {
                                    longFrameNewValue = 0L;
                                }
                                o_LiveShowObjectInterface.setFrameLength(longFrameNewValue);
                                longFrameDifference = longFrameNewValue - longFrameOldValue;
                            }
                        }
                        if (longFrameDifference != 0L) {
                            LiveShowVIPPanel.this.setVisibleRegion(longVisibleFrameStart += longFrameDifference, longVisibleFrameEnd += longFrameDifference);
                        } else {
                            LiveShowVIPPanel.this.m_ScrollAutomaticOn = false;
                        }
                    }
                    LiveShowVIPPanel.this.repaint();
                }
            }
        };
        this.m_ScrollThread = new Thread(this.m_ScrollRunnable);
        this.m_ScrollThread.start();
    }

    private void initComponents() {
        this.setLayout(new AbsoluteLayout());
        this.setDoubleBuffered(false);
        this.setOpaque(true);
        this.setBackground(Color.DARK_GRAY);
        this.setVisible(true);
        this.addComponentListener(this);
        this.setMinimumSize(new Dimension(0, 0));
        MouseWheelListener o_MouseWheelListener = new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (LiveShowVIPPanel.this.isSettingZoom) {
                    return;
                }
                long longFramePosition = LiveShowVIPPanel.this.getPositionFrame(e.getX());
                if (e.getWheelRotation() > 0) {
                    LiveShowVIPPanel.this.zoomMinus(false, longFramePosition);
                } else if (e.getWheelRotation() < 0) {
                    LiveShowVIPPanel.this.zoomPlus(false, longFramePosition);
                }
            }
        };
        this.addMouseWheelListener(o_MouseWheelListener);
    }

    public void close() {
        this.closeScrollAutomatic();
        EventQueueHandler.removeRunnable(this.m_Runnable_CalculatePlayCursor);
        EventQueueHandler.removeRunnable(this.m_Runnable_CalculateEditCursor);
        EventQueueHandler.removeRunnable(this.m_Runnable_Repaint);
        EventQueueHandler.removeRunnable(this.m_Runnable_RepaintParts);
        EventQueueHandler.removeRunnable(this.m_Runnable_Revalidate);
        EventQueueHandler.removeRunnable(this.m_Runnable_Resized);
        this.removeComponentListener(this);
        if (this.m_LiveShowVIP != null) {
            this.m_LiveShowVIP.removeLiveShowVIPListener(this);
            this.m_LiveShowVIP.setLiveShowVIPPanel(null);
            Play o_Play = this.m_LiveShowVIP.getPlay();
            if (o_Play != null) {
                o_Play.removePlayListener(this);
            }
        }
        this.m_LiveShowViewListeners.clear();
        this.m_SelfReference = null;
    }

    public void revalidateSuper() {
        super.revalidate();
    }

    @Override
    public void revalidate() {
        EventQueueHandler.invokeLater(this.m_Runnable_Revalidate);
    }

    public void repaintSuper() {
        super.repaint();
    }

    @Override
    public void repaint() {
        EventQueueHandler.invokeLater(this.m_Runnable_Repaint);
    }

    public LiveShowVIP getLiveShowVIP() {
        return this.m_LiveShowVIP;
    }

    @Override
    public void setVisibleRegion(long p_VisibleFrameStart, long p_VisibleFrameEnd) {
        boolean boolChanged = false;
        LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIP;
        if (o_LiveShowVIP == null) {
            return;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        long longVisibleFrameLength = p_VisibleFrameEnd - p_VisibleFrameStart;
        if (longVisibleFrameLength > o_LiveShowVIP.getFrameEnd() - o_LiveShowVIP.getFrameStart()) {
            longVisibleFrameLength = o_LiveShowVIP.getFrameEnd() - o_LiveShowVIP.getFrameStart();
        }
        if (p_VisibleFrameStart < o_LiveShowVIP.getFrameStart()) {
            p_VisibleFrameStart = o_LiveShowVIP.getFrameStart();
            p_VisibleFrameEnd = p_VisibleFrameStart + longVisibleFrameLength;
        }
        if (p_VisibleFrameEnd > o_LiveShowVIP.getFrameEnd()) {
            p_VisibleFrameEnd = o_LiveShowVIP.getFrameEnd();
            p_VisibleFrameStart = p_VisibleFrameEnd - longVisibleFrameLength;
        }
        if (p_VisibleFrameStart != this.m_VisibleFrameStart || p_VisibleFrameEnd != this.m_VisibleFrameEnd) {
            this.m_VisibleFrameStart = p_VisibleFrameStart;
            this.m_VisibleFrameEnd = p_VisibleFrameEnd;
            this.calculatePlayCursor();
            this.calculateEditCursor();
            this.notifyViewListeners_ViewChanged(this.getFrameStart(), this.getFrameEnd(), this.m_VisibleFrameStart, this.m_VisibleFrameEnd, this.getBounds());
            boolChanged = true;
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        if (boolChanged) {
            if (!SwingUtilities.isEventDispatchThread()) {
                EventQueueHandler.invokeLater(this.m_RunnableRepaint);
            } else {
                this.revalidate();
                this.repaint();
            }
        }
    }

    @Override
    public long getVisibleFrameStart() {
        return this.m_VisibleFrameStart;
    }

    @Override
    public long getVisibleFrameEnd() {
        return this.m_VisibleFrameEnd;
    }

    @Override
    public long getFrameStart() {
        return 0L;
    }

    @Override
    public long getFrameEnd() {
        LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIP;
        if (o_LiveShowVIP == null) {
            return 0L;
        }
        return o_LiveShowVIP.getFrameEnd();
    }

    public double getFramesPerPoint() {
        if (this.getWidth() <= 0) {
            return 0.0;
        }
        return (double)(this.m_VisibleFrameEnd - this.m_VisibleFrameStart) / (double)this.getWidth();
    }

    public long getFramesOfDistance(int p_DistanceX) {
        return (long)((double)p_DistanceX * this.getFramesPerPoint());
    }

    public long getPositionFrame(Point p_Point) {
        return this.getPositionFrame(p_Point.x);
    }

    public long getPositionFrame(int p_X) {
        long longFrame = (long)((double)this.m_VisibleFrameStart + (double)p_X * this.getFramesPerPoint());
        return longFrame;
    }

    public int getPositionX(long p_Frame) {
        double doubleFramesPerPoint;
        LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIP;
        if (o_LiveShowVIP == null) {
            return 0;
        }
        if (p_Frame < o_LiveShowVIP.getFrameStart()) {
            p_Frame = o_LiveShowVIP.getFrameStart();
        }
        if (p_Frame > o_LiveShowVIP.getFrameEnd()) {
            p_Frame = o_LiveShowVIP.getFrameEnd();
        }
        if ((doubleFramesPerPoint = this.getFramesPerPoint()) <= 0.0) {
            return 0;
        }
        int intX = (int)((double)(p_Frame - this.m_VisibleFrameStart) / doubleFramesPerPoint);
        return intX;
    }

    public long getSnapDistanceFrames() {
        return (long)(20.0 * this.getFramesPerPoint());
    }

    public LiveShowVIPTrackPanel getLiveShowVIPTrackPanel(int p_MouseXOnScreen, int p_MouseYOnScreen) {
        Point o_PointMouseInComponent = new Point(p_MouseXOnScreen, p_MouseYOnScreen);
        for (int intTrackPanel = 0; intTrackPanel < this.getLiveShowVIPTrackPanelCount(); ++intTrackPanel) {
            o_PointMouseInComponent.setLocation(p_MouseXOnScreen, p_MouseYOnScreen);
            LiveShowVIPTrackPanel o_LiveShowVIPTrackPanel = this.getLiveShowVIPTrackPanel(intTrackPanel);
            if (o_LiveShowVIPTrackPanel == null) continue;
            SwingUtilities.convertPointFromScreen(o_PointMouseInComponent, o_LiveShowVIPTrackPanel);
            Rectangle o_Rectangle = o_LiveShowVIPTrackPanel.getBounds();
            o_Rectangle.setLocation(0, 0);
            if (!o_Rectangle.contains(o_PointMouseInComponent)) continue;
            return o_LiveShowVIPTrackPanel;
        }
        return null;
    }

    public LiveShowObjectPanel getLiveShowObjectPanel(int p_MouseXOnScreen, int p_MouseYOnScreen) {
        Point o_PointMouseInComponent = new Point(p_MouseXOnScreen, p_MouseYOnScreen);
        LiveShowVIPTrackPanel o_LiveShowVIPTrackPanel = this.getLiveShowVIPTrackPanel(p_MouseXOnScreen, p_MouseYOnScreen);
        if (o_LiveShowVIPTrackPanel == null) {
            return null;
        }
        for (int intObjectPanel = 0; intObjectPanel < o_LiveShowVIPTrackPanel.getLiveShowOBjectPanelCount(); ++intObjectPanel) {
            o_PointMouseInComponent.setLocation(p_MouseXOnScreen, p_MouseYOnScreen);
            LiveShowObjectPanel o_LiveShowObjectPanel = o_LiveShowVIPTrackPanel.getLiveShowObjectPanel(intObjectPanel);
            if (o_LiveShowObjectPanel == null) continue;
            SwingUtilities.convertPointFromScreen(o_PointMouseInComponent, o_LiveShowObjectPanel);
            Rectangle o_Rectangle = o_LiveShowObjectPanel.getBounds();
            o_Rectangle.setLocation(0, 0);
            if (!o_Rectangle.contains(o_PointMouseInComponent)) continue;
            return o_LiveShowObjectPanel;
        }
        return null;
    }

    public boolean calculateEditCursor() {
        AbsoluteConstraints o_AbsoluteConstraints = this.m_EditControlCursor.getAbsoluteConstraints();
        o_AbsoluteConstraints.width = 5;
        o_AbsoluteConstraints.height = this.getHeight();
        int intNewX = this.getPositionX(this.m_FrameEditCursor);
        if (intNewX != o_AbsoluteConstraints.x) {
            o_AbsoluteConstraints.x = intNewX;
            return true;
        }
        return false;
    }

    public void calculatePlayCursor(long p_FramePlayCursor) {
        LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIP;
        if (o_LiveShowVIP == null) {
            return;
        }
        if (p_FramePlayCursor < o_LiveShowVIP.getFrameStart()) {
            p_FramePlayCursor = o_LiveShowVIP.getFrameStart();
        }
        if (p_FramePlayCursor > o_LiveShowVIP.getFrameEnd()) {
            p_FramePlayCursor = o_LiveShowVIP.getFrameEnd();
        }
        this.m_FramePlayCursor = p_FramePlayCursor;
        this.calculatePlayCursor();
    }

    public boolean calculatePlayCursor() {
        AbsoluteConstraints o_AbsoluteConstraints = this.m_PlayControlCursor.getAbsoluteConstraints();
        o_AbsoluteConstraints.width = 5;
        o_AbsoluteConstraints.height = this.getHeight();
        int intNewX = this.getPositionX(this.m_FramePlayCursor);
        if ((intNewX -= o_AbsoluteConstraints.width / 2) != o_AbsoluteConstraints.x) {
            o_AbsoluteConstraints.x = intNewX;
            EventQueueHandler.invokeLater(this.m_Runnable_Revalidate);
            return true;
        }
        return false;
    }

    @Override
    public void eventEditModeOn(Play p_Play, boolean p_EditModeOn) {
        if (p_EditModeOn) {
            this.m_EditControlCursor.setVisible(true);
        } else {
            this.m_EditControlCursor.setVisible(false);
        }
    }

    @Override
    public void eventEditCursorSet(Play p_Play, long p_FrameEditCursor) {
        LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIP;
        if (o_LiveShowVIP == null) {
            return;
        }
        if (p_FrameEditCursor < o_LiveShowVIP.getFrameStart()) {
            p_FrameEditCursor = o_LiveShowVIP.getFrameStart();
        }
        if (p_FrameEditCursor > o_LiveShowVIP.getFrameEnd()) {
            p_FrameEditCursor = o_LiveShowVIP.getFrameEnd();
        }
        this.m_FrameEditCursor = p_FrameEditCursor;
        EventQueueHandler.invokeLater(this.m_Runnable_CalculateEditCursor);
    }

    @Override
    public void eventPlayStart(Play p_Play) {
    }

    @Override
    public void eventPlayStop(Play p_Play) {
    }

    @Override
    public void eventPlayPause(Play p_Play) {
    }

    @Override
    public void eventPlayRewind(Play p_Play) {
    }

    @Override
    public void eventPlayFastForward(Play p_Play) {
    }

    @Override
    public void eventPlayFadePossibility(Play p_Play, boolean p_FadeInPossible, boolean p_FadeOutPossible, double p_FadeProgress) {
    }

    @Override
    public void eventPlayFadedIn(Play p_Play, boolean p_FadedIn, double p_FadeProgress) {
    }

    @Override
    public void eventPlayCursorSet(Play p_Play, long p_FramePlayCursor) {
    }

    @Override
    public long eventPlayCheckRead(Play p_Play, long p_FrameStart, long p_FramesToRead) {
        return p_FramesToRead;
    }

    @Override
    public void eventPlayCursor(Play p_Play, long p_OldFramePlayCursor, long p_FramePlayCursor) {
        LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIP;
        if (o_LiveShowVIP == null) {
            return;
        }
        if (p_FramePlayCursor < o_LiveShowVIP.getFrameStart()) {
            p_FramePlayCursor = o_LiveShowVIP.getFrameStart();
        }
        if (p_FramePlayCursor > o_LiveShowVIP.getFrameEnd()) {
            p_FramePlayCursor = o_LiveShowVIP.getFrameEnd();
        }
        this.m_FramePlayCursor = p_OldFramePlayCursor;
        this.calculatePlayCursor();
    }

    @Override
    public void eventPlayError(Play p_Play, Exception p_Exception, String p_Remark) {
    }

    @Override
    public void eventPlayClosing(Play p_Play) {
    }

    @Override
    public void eventPlayTimelineEnd(Play p_Play) {
    }

    @Override
    public void eventVIPEndOfAction(LiveShowVIP p_LiveShowVIP, LiveShowVIP p_ActorLiveShowVIP, boolean p_Success, int p_Action) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventVIPSceneBridgeAdded(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge) {
        if (p_LiveShowSceneBridge == null) {
            return;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        Object object = this.m_SyncBridgeObjects;
        synchronized (object) {
            LiveShowSceneBridgePanel o_LiveShowSceneBridgePanel = new LiveShowSceneBridgePanel(this, p_LiveShowSceneBridge);
            this.m_LiveShowSceneBridgePanels.add(o_LiveShowSceneBridgePanel);
            this.addLiveShowViewListener(o_LiveShowSceneBridgePanel);
            o_LiveShowSceneBridgePanel.eventViewChanged(this.getFrameStart(), this.getFrameEnd(), this.getVisibleFrameStart(), this.getVisibleFrameEnd(), this.getBounds());
            o_LiveShowSceneBridgePanel.setVisible(true);
            this.add(o_LiveShowSceneBridgePanel, o_LiveShowSceneBridgePanel.getAbsoluteConstraints(), 0);
            this.setComponentZOrder(o_LiveShowSceneBridgePanel, 0);
            if (this.m_PlayControlCursor != null) {
                this.setComponentZOrder(this.m_PlayControlCursor, 0);
            }
            if (this.m_EditControlCursor != null) {
                this.setComponentZOrder(this.m_EditControlCursor, 0);
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        if (!SwingUtilities.isEventDispatchThread()) {
            EventQueueHandler.invokeLater(this.m_RunnableRepaint);
        } else {
            this.revalidate();
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventVIPSceneBridgeRemoved(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge) {
        if (p_LiveShowSceneBridge == null) {
            return;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        Object object = this.m_SyncBridgeObjects;
        synchronized (object) {
            int intObjectPanelCount = this.m_LiveShowSceneBridgePanels.size();
            for (int intObject = 0; intObject < intObjectPanelCount; ++intObject) {
                LiveShowSceneBridgePanel o_LiveShowSceneBridgePanel = this.m_LiveShowSceneBridgePanels.get(intObject);
                if (o_LiveShowSceneBridgePanel == null || o_LiveShowSceneBridgePanel.getLiveShowSceneBridge() != p_LiveShowSceneBridge) continue;
                o_LiveShowSceneBridgePanel.setVisible(false);
                this.remove(o_LiveShowSceneBridgePanel);
                this.removeLiveShowViewListener(o_LiveShowSceneBridgePanel);
                o_LiveShowSceneBridgePanel.close();
                this.m_LiveShowSceneBridgePanels.remove(o_LiveShowSceneBridgePanel);
                break;
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        if (!SwingUtilities.isEventDispatchThread()) {
            EventQueueHandler.invokeLater(this.m_RunnableRepaint);
        } else {
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void eventVIPActive(LiveShowVIP p_LiveShowVIP, boolean p_Active) {
        this.m_PlayControlCursor.setVisible(p_Active);
    }

    @Override
    public void eventVIPToFront(LiveShowVIP p_LiveShowVIP) {
    }

    @Override
    public void eventVIPSceneBridgesResorted(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge, ArrayList<LiveShowSceneBridge> p_LiveShowSceneBridges) {
    }

    @Override
    public void eventVIPSceneBridgeCursorChanged(LiveShowVIP p_LiveShowVIP, boolean p_ActualPlaying, boolean p_ActualStopAtStart) {
    }

    @Override
    public void eventVIPSceneBridgeEditCursorChanged(LiveShowVIP p_LiveShowVIP) {
    }

    @Override
    public void eventVIPSceneBridgeStart(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge, boolean p_WillPlay) {
    }

    @Override
    public void eventVIPSceneBridgeEnd(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge) {
    }

    @Override
    public void eventVIPObjectAdded(LiveShowVIP p_LiveShowVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (!SwingUtilities.isEventDispatchThread()) {
            EventQueueHandler.invokeLater(this.m_RunnableRepaint);
        } else {
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void eventVIPObjectRemoved(LiveShowVIP p_LiveShowVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (!SwingUtilities.isEventDispatchThread()) {
            EventQueueHandler.invokeLater(this.m_RunnableRepaint);
        } else {
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void eventVIPObjectParamChanged(LiveShowVIP p_LiveShowVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (p_LiveShowObjectInterface instanceof LiveShowSceneBridge) {
            return;
        }
        EventQueueHandler.invokeLater(this.m_Runnable_RepaintParts);
    }

    @Override
    public void eventVIPObjectShowSettings(LiveShowVIP p_LiveShowVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
    }

    @Override
    public void eventVIPObjectSelection(LiveShowVIP p_LiveShowVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (!SwingUtilities.isEventDispatchThread()) {
            EventQueueHandler.invokeLater(this.m_RunnableRepaint);
        } else {
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void eventVIPEditModeOn(LiveShowVIP p_LiveShowVIP, boolean p_EditModeOn) {
    }

    @Override
    public void eventVIPCursorMode(LiveShowVIP p_LiveShowVIP, int p_EditMode) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculatePaint() {
        Dimension o_Size = this.getSize();
        int intTrackCount = 0;
        Object object = this.m_SyncVIPTracks;
        synchronized (object) {
            intTrackCount = this.m_LiveShowVIPTrackPanels.size();
            if (intTrackCount == 0) {
                return;
            }
            int intTrackHeight = o_Size.height / intTrackCount;
            for (int intTrack = 0; intTrack < intTrackCount; ++intTrack) {
                LiveShowVIPTrackPanel o_LiveShowVIPTrackPanel = this.m_LiveShowVIPTrackPanels.get(intTrack);
                if (o_LiveShowVIPTrackPanel == null) continue;
                AbsoluteConstraints o_AbsoluteConstraints = o_LiveShowVIPTrackPanel.getAbsoluteConstraints();
                o_AbsoluteConstraints.x = 0;
                o_AbsoluteConstraints.y = intTrack * intTrackHeight;
                o_AbsoluteConstraints.width = o_Size.width;
                o_AbsoluteConstraints.height = intTrackHeight;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventVIPTrackAdded(LiveShowVIP p_LiveShowVIP, LiveShowVIPTrack p_LiveShowVIPTrack) {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        Object object = this.m_SyncVIPTracks;
        synchronized (object) {
            LiveShowVIPTrackPanel o_LiveShowVIPTrackPanel = new LiveShowVIPTrackPanel(this, p_LiveShowVIPTrack);
            this.m_LiveShowVIPTrackPanels.add(o_LiveShowVIPTrackPanel);
            o_LiveShowVIPTrackPanel.setVisible(true);
            this.add(o_LiveShowVIPTrackPanel, o_LiveShowVIPTrackPanel.getAbsoluteConstraints(), -1);
            if (this.m_PlayControlCursor != null) {
                this.setComponentZOrder(this.m_PlayControlCursor, 0);
            }
            if (this.m_EditControlCursor != null) {
                this.setComponentZOrder(this.m_EditControlCursor, 0);
            }
            this.calculatePaint();
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        if (!SwingUtilities.isEventDispatchThread()) {
            EventQueueHandler.invokeLater(this.m_RunnableRepaint);
        } else {
            this.revalidate();
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventVIPTrackRemoved(LiveShowVIP p_LiveShowVIP, LiveShowVIPTrack p_LiveShowVIPTrack) {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        Object object = this.m_SyncVIPTracks;
        synchronized (object) {
            int intTrackPanelCount = this.m_LiveShowVIPTrackPanels.size();
            for (int intTrack = 0; intTrack < intTrackPanelCount; ++intTrack) {
                LiveShowVIPTrackPanel o_LiveShowVIPTrackPanel = this.m_LiveShowVIPTrackPanels.get(intTrack);
                if (o_LiveShowVIPTrackPanel == null || o_LiveShowVIPTrackPanel.getLiveShowVIPTrack() != p_LiveShowVIPTrack) continue;
                this.m_LiveShowVIPTrackPanels.remove(o_LiveShowVIPTrackPanel);
                o_LiveShowVIPTrackPanel.setVisible(false);
                this.remove(o_LiveShowVIPTrackPanel);
                this.calculatePaint();
                break;
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        if (!SwingUtilities.isEventDispatchThread()) {
            EventQueueHandler.invokeLater(this.m_RunnableRepaint);
        } else {
            this.revalidate();
            this.repaint();
        }
    }

    public int getLiveShowVIPTrackPanelCount() {
        return this.m_LiveShowVIPTrackPanels.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveShowVIPTrackPanel getLiveShowVIPTrackPanel(int p_VipTrackIndex) {
        if (p_VipTrackIndex < 0) {
            return null;
        }
        Object object = this.m_SyncVIPTracks;
        synchronized (object) {
            if (p_VipTrackIndex >= this.m_LiveShowVIPTrackPanels.size()) {
                return null;
            }
            return this.m_LiveShowVIPTrackPanels.get(p_VipTrackIndex);
        }
    }

    public int getLiveShowSceneBridgePanelCount() {
        return this.m_LiveShowSceneBridgePanels.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveShowSceneBridgePanel getLiveShowSceneBridgePanel(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = this.m_SyncVIPTracks;
        synchronized (object) {
            if (p_Index >= this.m_LiveShowSceneBridgePanels.size()) {
                return null;
            }
            return this.m_LiveShowSceneBridgePanels.get(p_Index);
        }
    }

    @Override
    public void eventVIPFrameMaxObjects(LiveShowVIP p_LiveShowVIP, long p_FrameMaxObjects) {
    }

    @Override
    public void eventVIPMaxFrame(LiveShowVIP p_LiveShowVIP, long p_FrameMax) {
        boolean boolScrollAutomatic = this.m_ScrollAutomaticOn;
        if (boolScrollAutomatic) {
            this.stopScrollAutomatic();
        }
        this.setVisibleRegion(this.m_VisibleFrameStart, this.m_VisibleFrameEnd);
        this.notifyViewListeners_ViewChanged(this.getFrameStart(), this.getFrameEnd(), this.m_VisibleFrameStart, this.m_VisibleFrameEnd, this.getBounds());
        if (boolScrollAutomatic) {
            this.startScrollAutomatic();
        }
    }

    @Override
    public void eventVIPFrameTime(LiveShowVIP p_LiveShowVIP, double p_FrameTime) {
        this.setVisibleRegion(this.m_VisibleFrameStart, this.m_VisibleFrameEnd);
    }

    @Override
    public void eventVIPClosing(LiveShowVIP p_LiveShowVIP) {
        this.close();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        int intHeight;
        int intWidth;
        if (this.getWidth() == this.m_OldSize.width && this.getHeight() == this.m_OldSize.height) {
            return;
        }
        Dimension o_MinimumSize = this.getMinimumSize();
        if (o_MinimumSize.width <= 0) {
            o_MinimumSize.setSize(10, o_MinimumSize.height);
        }
        if (o_MinimumSize.height <= 0) {
            o_MinimumSize.setSize(o_MinimumSize.width, 10);
        }
        if ((intWidth = this.getWidth()) <= 0) {
            intWidth = o_MinimumSize.width;
        }
        if ((intHeight = this.getHeight()) <= 0) {
            intHeight = o_MinimumSize.height;
        }
        this.m_OldSize.setSize(intWidth, intHeight);
        EventQueueHandler.invokeLater(this.m_Runnable_Resized);
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkScroll(int p_Action, boolean p_DragAction, long p_FramePositionOld, long p_FramePositionNew, long p_FramePositionMouseInside, LiveShowObjectInterface p_ActorInterface, LiveShowObjectDescription p_ActorDescription, LiveShowVIP.LiveShowVIPStatus p_LiveShowVIPStatus) {
        if (p_ActorDescription == null) {
            return false;
        }
        long longFrameDifference = 0L;
        long longSnapDistanceFrames = this.getSnapDistanceFrames();
        if (p_DragAction) {
            this.stopScrollAutomatic();
        }
        Object object = this.m_SyncScroll;
        synchronized (object) {
            this.m_ScrollAction = p_Action;
            this.m_ScrollLiveShowObjectInterface = p_ActorInterface;
            this.m_ScrollObjectDescription = p_ActorDescription;
            this.m_ScrollVIPStatus = p_LiveShowVIPStatus;
            if (p_FramePositionOld == p_FramePositionNew) {
                this.m_ScrollFrameDifference = 0L;
                if (!p_DragAction) {
                    this.stopScrollAutomatic();
                }
                return true;
            }
            if (p_FramePositionNew + p_FramePositionMouseInside < this.m_VisibleFrameStart + longSnapDistanceFrames) {
                longFrameDifference = p_FramePositionNew + p_FramePositionMouseInside - (this.m_VisibleFrameStart + longSnapDistanceFrames);
                this.m_ScrollFrameDifference = longFrameDifference >= this.m_ScrollFrameDifference ? 0L : longFrameDifference;
                if (!p_DragAction) {
                    if (this.m_ScrollFrameDifference != 0L) {
                        this.notifyViewListeners_ScrollAutomaticStart();
                        this.startScrollAutomatic();
                    } else {
                        this.stopScrollAutomatic();
                    }
                    return true;
                }
            } else if (p_FramePositionNew + p_FramePositionMouseInside > this.m_VisibleFrameEnd - longSnapDistanceFrames) {
                longFrameDifference = p_FramePositionNew + p_FramePositionMouseInside - (this.m_VisibleFrameEnd - longSnapDistanceFrames);
                this.m_ScrollFrameDifference = longFrameDifference <= this.m_ScrollFrameDifference ? 0L : longFrameDifference;
                if (!p_DragAction) {
                    if (this.m_ScrollFrameDifference != 0L) {
                        this.notifyViewListeners_ScrollAutomaticStart();
                        this.startScrollAutomatic();
                    } else {
                        this.stopScrollAutomatic();
                    }
                    return true;
                }
            } else {
                this.m_ScrollFrameDifference = 0L;
                if (!p_DragAction) {
                    this.stopScrollAutomatic();
                    return false;
                }
            }
        }
        if (longFrameDifference != 0L) {
            long longNewVisibleStart = this.m_VisibleFrameStart + longFrameDifference;
            if (longNewVisibleStart < 0L) {
                longFrameDifference -= longNewVisibleStart;
            }
            longNewVisibleStart = this.m_VisibleFrameStart + longFrameDifference;
            long longNewVisibleEnd = this.m_VisibleFrameEnd + longFrameDifference;
            this.notifyViewListeners_ScrollAutomaticStart();
            this.setVisibleRegion(longNewVisibleStart, longNewVisibleEnd);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopScrollAutomatic() {
        Object object = this.m_SyncScroll;
        synchronized (object) {
            this.m_ScrollAutomaticOn = false;
            this.m_SyncScroll.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startScrollAutomatic() {
        Object object = this.m_SyncScroll;
        synchronized (object) {
            this.m_ScrollAutomaticOn = true;
            this.m_SyncScroll.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeScrollAutomatic() {
        this.m_ScrollAutomatic = false;
        Object object = this.m_SyncScroll;
        synchronized (object) {
            this.m_SyncScroll.notifyAll();
        }
    }

    public void zoomPlus(boolean p_AdjustFramePosition, long p_FramePosition) {
        this.isSettingZoom = true;
        this.notifyViewListeners_ZoomPlus(p_AdjustFramePosition, p_FramePosition);
        EventQueueHandler.invokeLater(this.m_RunnableEndZoom);
    }

    public void zoomMinus(boolean p_AdjustFramePosition, long p_FramePosition) {
        this.isSettingZoom = true;
        this.notifyViewListeners_ZoomMinus(p_AdjustFramePosition, p_FramePosition);
        EventQueueHandler.invokeLater(this.m_RunnableEndZoom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addLiveShowViewListener(LiveShowViewListener p_Listener) {
        if (p_Listener == null) {
            return false;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIP;
        boolean boolAdded = false;
        Object object = this.m_SyncViewListeners;
        synchronized (object) {
            if (this.m_LiveShowViewListeners != null && !this.m_LiveShowViewListeners.contains(p_Listener)) {
                this.m_LiveShowViewListeners.add(p_Listener);
                if (o_LiveShowVIP != null) {
                    p_Listener.eventViewChanged(o_LiveShowVIP.getFrameStart(), o_LiveShowVIP.getFrameEnd(), this.m_VisibleFrameStart, this.m_VisibleFrameEnd, this.getBounds());
                }
                boolAdded = true;
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return boolAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeLiveShowViewListener(LiveShowViewListener p_Listener) {
        if (p_Listener == null) {
            return false;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        boolean boolRemoved = false;
        Object object = this.m_SyncViewListeners;
        synchronized (object) {
            if (this.m_LiveShowViewListeners != null) {
                boolRemoved = this.m_LiveShowViewListeners.remove(p_Listener);
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return boolRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyViewListeners_ViewChanged(long p_FrameStart, long p_FrameEnd, long p_VisibleFrameStart, long p_VisibleFrameEnd, Rectangle p_Bounds) {
        ArrayList<LiveShowViewListener> o_LiveShowViewListeners;
        LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIP;
        if (o_LiveShowVIP != null) {
            o_LiveShowVIP.setSnapFramesDistance((long)(20.0 * this.getFramesPerPoint()));
        }
        Object object = this.m_SyncViewListeners;
        synchronized (object) {
            if (this.m_LiveShowViewListeners == null) {
                return;
            }
            if (this.m_LiveShowViewListeners.size() <= 0) {
                return;
            }
            o_LiveShowViewListeners = new ArrayList<LiveShowViewListener>(this.m_LiveShowViewListeners.size());
            o_LiveShowViewListeners.addAll(this.m_LiveShowViewListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowViewListeners.size(); ++intListener) {
            LiveShowViewListener o_Listener = (LiveShowViewListener)o_LiveShowViewListeners.get(intListener);
            o_Listener.eventViewChanged(p_FrameStart, p_FrameEnd, p_VisibleFrameStart, p_VisibleFrameEnd, p_Bounds);
        }
        o_LiveShowViewListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyViewListeners_ScrollAutomaticStart() {
        ArrayList<LiveShowViewListener> o_LiveShowViewListeners;
        LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIP;
        if (o_LiveShowVIP != null) {
            this.m_LiveShowVIP.setSnapFramesDistance((long)(20.0 * this.getFramesPerPoint()));
        }
        Object object = this.m_SyncViewListeners;
        synchronized (object) {
            if (this.m_LiveShowViewListeners == null) {
                return;
            }
            if (this.m_LiveShowViewListeners.size() <= 0) {
                return;
            }
            o_LiveShowViewListeners = new ArrayList<LiveShowViewListener>(this.m_LiveShowViewListeners.size());
            o_LiveShowViewListeners.addAll(this.m_LiveShowViewListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowViewListeners.size(); ++intListener) {
            LiveShowViewListener o_Listener = (LiveShowViewListener)o_LiveShowViewListeners.get(intListener);
            o_Listener.eventViewScrollAutomaticStart();
        }
        o_LiveShowViewListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyViewListeners_ZoomPlus(boolean p_AdjustFramePosition, long p_FramePosition) {
        ArrayList<LiveShowViewListener> o_LiveShowViewListeners;
        LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIP;
        if (o_LiveShowVIP != null) {
            this.m_LiveShowVIP.setSnapFramesDistance((long)(20.0 * this.getFramesPerPoint()));
        }
        Object object = this.m_SyncViewListeners;
        synchronized (object) {
            if (this.m_LiveShowViewListeners == null) {
                return;
            }
            if (this.m_LiveShowViewListeners.size() <= 0) {
                return;
            }
            o_LiveShowViewListeners = new ArrayList<LiveShowViewListener>(this.m_LiveShowViewListeners.size());
            o_LiveShowViewListeners.addAll(this.m_LiveShowViewListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowViewListeners.size(); ++intListener) {
            LiveShowViewListener o_Listener = (LiveShowViewListener)o_LiveShowViewListeners.get(intListener);
            o_Listener.eventZoomPlus(p_AdjustFramePosition, p_FramePosition);
        }
        o_LiveShowViewListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyViewListeners_ZoomMinus(boolean p_AdjustFramePosition, long p_FramePosition) {
        ArrayList<LiveShowViewListener> o_LiveShowViewListeners;
        LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIP;
        if (o_LiveShowVIP != null) {
            this.m_LiveShowVIP.setSnapFramesDistance((long)(20.0 * this.getFramesPerPoint()));
        }
        Object object = this.m_SyncViewListeners;
        synchronized (object) {
            if (this.m_LiveShowViewListeners == null) {
                return;
            }
            if (this.m_LiveShowViewListeners.size() <= 0) {
                return;
            }
            o_LiveShowViewListeners = new ArrayList<LiveShowViewListener>(this.m_LiveShowViewListeners.size());
            o_LiveShowViewListeners.addAll(this.m_LiveShowViewListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowViewListeners.size(); ++intListener) {
            LiveShowViewListener o_Listener = (LiveShowViewListener)o_LiveShowViewListeners.get(intListener);
            o_Listener.eventZoomMinus(p_AdjustFramePosition, p_FramePosition);
        }
        o_LiveShowViewListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyViewListeners_ZoomReset() {
        ArrayList<LiveShowViewListener> o_LiveShowViewListeners;
        LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIP;
        if (o_LiveShowVIP != null) {
            this.m_LiveShowVIP.setSnapFramesDistance((long)(20.0 * this.getFramesPerPoint()));
        }
        Object object = this.m_SyncViewListeners;
        synchronized (object) {
            if (this.m_LiveShowViewListeners == null) {
                return;
            }
            if (this.m_LiveShowViewListeners.size() <= 0) {
                return;
            }
            o_LiveShowViewListeners = new ArrayList<LiveShowViewListener>(this.m_LiveShowViewListeners.size());
            o_LiveShowViewListeners.addAll(this.m_LiveShowViewListeners);
        }
        for (int intListener = 0; intListener < o_LiveShowViewListeners.size(); ++intListener) {
            LiveShowViewListener o_Listener = (LiveShowViewListener)o_LiveShowViewListeners.get(intListener);
            o_Listener.eventZoomReset();
        }
        o_LiveShowViewListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repaintParts() {
        Object object = this.m_SyncBridgeObjects;
        synchronized (object) {
            for (int intSceneBridge = 0; intSceneBridge < this.m_LiveShowSceneBridgePanels.size(); ++intSceneBridge) {
                LiveShowSceneBridgePanel o_LiveShowSceneBridgePanel = this.m_LiveShowSceneBridgePanels.get(intSceneBridge);
                if (o_LiveShowSceneBridgePanel == null) continue;
                o_LiveShowSceneBridgePanel.repaint();
            }
        }
        this.m_PlayControlCursor.repaint();
    }
}

