/*
 * Decompiled with CFR 0.152.
 */
package LiveShowVirtualPackage;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowObjectPackage.LiveShowObjectDescription;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowObjectPackage.LiveShowObjectListener;
import LiveShowObjectPackage.LiveShowProjectDescription;
import LiveShowObjectPackage.LiveShowUndo;
import LiveShowPlayPackage.Play;
import LiveShowPlayPackage.PlayControlPanel;
import LiveShowPlayPackage.PlayListener;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import LiveShowVirtualPackage.LiveShowSceneBridgeMain;
import LiveShowVirtualPackage.LiveShowTimer;
import LiveShowVirtualPackage.LiveShowTimerDisplay;
import LiveShowVirtualPackage.LiveShowVIP;
import LiveShowVirtualPackage.LiveShowVIPListener;
import LiveShowVirtualPackage.LiveShowVIPTrack;
import LiveShowVirtualPackage.LiveShow_ExportDescription;
import LiveShowVirtualPackage.LiveShow_ImportDescription;
import SwingComponents.MouseAdapter_Delayed;
import SwingToolTipPackage.JLabel_RightClickToolTip;
import SwingToolTipPackage.JTextPane_RightClickToolTip;
import SwingToolTipPackage.PopUpToolTip;
import SynchronizationPackage.EventQueueHandler;
import Text.Export_HTML;
import ToolsGraphics.JLabel_ResizeFrame;
import ToolsGraphics.LiveShowHTMLDocument;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;

public class LiveShowSceneBookPanel
extends JPanel
implements LiveShowVIPListener,
Externalizable {
    public static final int SOFTWAREVERSION = 2;
    public static final String FILESUFFIX = ".lsb";
    public static Color COLOR_BACKGROUND_SCENEBRIDGEPANEL = new Color(0, 0, 0);
    public static Color COLOR_BACKGROUND_TEXTPANE = new Color(0, 0, 0);
    private LiveShowHTMLDocument.TextToolBar m_ToolBar_Text;
    @LiveLanguageString
    public static String s_TOOLTIP_PLAY = "Play";
    @LiveLanguageString
    public static String s_TOOLTIP_JUMP = "Jump to";
    @LiveLanguageString
    public static String s_TOOLTIP_JUMPACTIVE = "Activate/Deactivate Jump";
    @LiveLanguageString
    public static String s_TOOLTIP_ACTIVESCENE = "Activate/Deactivate Scenebridge";
    @LiveLanguageString
    public static String s_TOOLTIP_STOPPER = "Activate/Deactivate stop at start";
    @LiveLanguageString
    public static String s_TOOLTIP_DIRECTION = "<html>To send the text to remoteclients set him between quotes (\").<br>If you mean only one user, set the text as following: \"username#text to send\"</html>";
    public static Font s_DefaultFont = new Font("SansSerif", 0, 16);
    public static Font s_DefaultTimeFont = new Font("SansSerif", 0, 24);
    public static Font s_DefaultLoopFont = new Font("SansSerif", 0, 12);
    public static long s_TimeRestWarningMilliSeconds = 10000L;
    public static Color s_ColorWarningTime = new Color(255, 200, 200);
    public static Color s_ColorWarningStopped = new Color(180, 0, 0);
    private ArrayList<LiveShowVIP> m_LiveShowVIPs;
    private ArrayList<SceneBook_MainPanelSceneBridge> m_SceneBookMainPanels;
    private HashMap<String, LiveShowHTMLDocument> m_SceneBookDocuments;
    private boolean m_SceneBookDocumentsVisible;
    private GridBagLayout m_GridBagLayout;
    private ArrayList<SceneBookColumn> m_SceneBookColumns;
    private SceneBook_MainPanelSceneBridge m_MainSceneBridgePanel_Start;
    private LiveShowProjectDescription m_LiveShowProjectDescription;
    private Play.PlaySynchronisizer m_PlaySynchronisizer;
    private String m_OldTimeRest_String;
    private boolean m_OldWarning;
    private boolean m_OldStopped;
    private LineBorder m_BorderSelected;
    private ArrayList<SceneBook_MainPanelSceneBridge> m_AddedSceneBook_MainPanelSceneBridges;
    private ArrayList<SceneBook_MainPanelSceneBridge> m_ChangedSceneBook_MainPanelSceneBridges;
    private ArrayList<SceneBookItem> m_ChangedSceneBookItems;
    private ArrayList<SceneBook_PanelSceneBridge> m_ChangedSceneBook_PanelSceneBridges;
    private ArrayList<SceneBook_MainPanelSceneBridge> m_RefreshSceneBook_MainPanelSceneBridges;
    private boolean m_NotifyChangedSructure;
    private ArrayList<SceneBookListener> m_SceneBookListeners;
    private final Object m_SyncListeners = new Object();
    private Runnable m_RunnableRepaint_JPanalSceneBook;
    private JButton jButton_Export;
    private JButton jButton_SceneBookDocumentsVisible;
    private JButton jButton_ScrollDMX;
    private JButton jButton_ScrollMedia;
    private JButton jButton_ScrollSound;
    private JLabel_ResizeFrame jLabel_ResizeFrame1;
    private JPanel jPanel_SceneBook;
    private JScrollPane jScrollPane1;
    private JToolBar jToolBar_Scroll;
    private LiveShowTimerDisplay liveShowTimerDisplay1;
    private PlayControlPanel playControlPanel1;
    private ArrayList<SceneBookItem> m_SceneBookItemsLost = new ArrayList();
    private Runnable m_RunnableVIPChangeDone = new Runnable(){

        @Override
        public void run() {
            SceneBook_MainPanelSceneBridge o_SceneBook_MainPanelSceneBridge;
            int intPanel;
            boolean boolRevalidate = false;
            if (LiveShowSceneBookPanel.this.m_AddedSceneBook_MainPanelSceneBridges.size() > 0) {
                SceneBookItem.resortSceneBookItems();
            }
            if (LiveShowSceneBookPanel.this.m_ChangedSceneBook_MainPanelSceneBridges.size() > 0) {
                for (intPanel = 0; intPanel < LiveShowSceneBookPanel.this.m_ChangedSceneBook_MainPanelSceneBridges.size(); ++intPanel) {
                    o_SceneBook_MainPanelSceneBridge = (SceneBook_MainPanelSceneBridge)LiveShowSceneBookPanel.this.m_ChangedSceneBook_MainPanelSceneBridges.get(intPanel);
                    LiveShowSceneBookPanel.this.resortMainSceneBridgePanel(o_SceneBook_MainPanelSceneBridge);
                }
                SceneBookItem.resortSceneBookItems();
                boolRevalidate = true;
            } else {
                if (LiveShowSceneBookPanel.this.m_ChangedSceneBookItems.size() > 0) {
                    for (int intItem = 0; intItem < LiveShowSceneBookPanel.this.m_ChangedSceneBookItems.size(); ++intItem) {
                        SceneBookItem o_SceneBookItem = (SceneBookItem)LiveShowSceneBookPanel.this.m_ChangedSceneBookItems.get(intItem);
                        if (o_SceneBookItem == null) continue;
                        o_SceneBookItem.resortSceneBookItem();
                    }
                }
                boolRevalidate = true;
            }
            if (LiveShowSceneBookPanel.this.m_RefreshSceneBook_MainPanelSceneBridges.size() > 0) {
                for (intPanel = 0; intPanel < LiveShowSceneBookPanel.this.m_RefreshSceneBook_MainPanelSceneBridges.size(); ++intPanel) {
                    o_SceneBook_MainPanelSceneBridge = (SceneBook_MainPanelSceneBridge)LiveShowSceneBookPanel.this.m_RefreshSceneBook_MainPanelSceneBridges.get(intPanel);
                    o_SceneBook_MainPanelSceneBridge.refresh();
                }
                boolRevalidate = true;
            }
            if (LiveShowSceneBookPanel.this.m_ChangedSceneBook_PanelSceneBridges.size() > 0) {
                for (intPanel = 0; intPanel < LiveShowSceneBookPanel.this.m_ChangedSceneBook_PanelSceneBridges.size(); ++intPanel) {
                    SceneBook_PanelSceneBridge o_SceneBook_PanelSceneBridge = (SceneBook_PanelSceneBridge)LiveShowSceneBookPanel.this.m_ChangedSceneBook_PanelSceneBridges.get(intPanel);
                    if (o_SceneBook_PanelSceneBridge == null) continue;
                    o_SceneBook_PanelSceneBridge.refresh();
                }
                boolRevalidate = true;
            }
            LiveShowSceneBookPanel.this.m_AddedSceneBook_MainPanelSceneBridges.clear();
            LiveShowSceneBookPanel.this.m_ChangedSceneBook_MainPanelSceneBridges.clear();
            LiveShowSceneBookPanel.this.m_RefreshSceneBook_MainPanelSceneBridges.clear();
            LiveShowSceneBookPanel.this.m_ChangedSceneBookItems.clear();
            LiveShowSceneBookPanel.this.m_ChangedSceneBook_PanelSceneBridges.clear();
            if (LiveShowSceneBookPanel.this.m_NotifyChangedSructure) {
                LiveShowSceneBookPanel.this.notifyListeners_Changed();
            }
            LiveShowSceneBookPanel.this.m_NotifyChangedSructure = false;
            if (boolRevalidate) {
                LiveShowSceneBookPanel.this.jPanel_SceneBook.revalidate();
                LiveShowSceneBookPanel.this.jPanel_SceneBook.repaint();
            }
        }
    };

    public LiveShowSceneBookPanel() {
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
        LiveLanguage.addLanguageListener(this, null);
    }

    public LiveShowSceneBookPanel(Play.PlaySynchronisizer p_PlaySynchronisizer) {
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
        LiveLanguage.addLanguageListener(this, null);
        this.setPlaySynchronizer(p_PlaySynchronisizer);
    }

    private void initMembers() {
        this.m_SceneBookListeners = new ArrayList();
        this.m_LiveShowVIPs = new ArrayList();
        this.m_SceneBookMainPanels = new ArrayList();
        this.m_SceneBookDocuments = new HashMap();
        this.m_SceneBookDocumentsVisible = true;
        this.m_SceneBookColumns = new ArrayList();
        this.m_AddedSceneBook_MainPanelSceneBridges = new ArrayList();
        this.m_ChangedSceneBook_MainPanelSceneBridges = new ArrayList();
        this.m_ChangedSceneBookItems = new ArrayList();
        this.m_ChangedSceneBook_PanelSceneBridges = new ArrayList();
        this.m_RefreshSceneBook_MainPanelSceneBridges = new ArrayList();
        this.m_NotifyChangedSructure = false;
        this.m_OldTimeRest_String = "";
        this.m_OldStopped = false;
        this.m_OldWarning = false;
        this.m_RunnableRepaint_JPanalSceneBook = new Runnable(){

            @Override
            public void run() {
                LiveShowSceneBookPanel.this.jPanel_SceneBook.revalidate();
                LiveShowSceneBookPanel.this.jPanel_SceneBook.repaint();
            }
        };
    }

    private void initComponents() {
        this.jLabel_ResizeFrame1 = new JLabel_ResizeFrame();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel_SceneBook = new JPanel();
        this.jToolBar_Scroll = new JToolBar();
        this.jButton_ScrollSound = new JButton();
        this.jButton_ScrollDMX = new JButton();
        this.jButton_ScrollMedia = new JButton();
        this.playControlPanel1 = new PlayControlPanel();
        this.jButton_SceneBookDocumentsVisible = new JButton();
        this.liveShowTimerDisplay1 = new LiveShowTimerDisplay();
        this.jButton_Export = new JButton();
        this.setLayout(new GridBagLayout());
        this.jLabel_ResizeFrame1.setToolTipText("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 14;
        this.add((Component)this.jLabel_ResizeFrame1, gridBagConstraints);
        this.jPanel_SceneBook.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.jPanel_SceneBook);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jToolBar_Scroll.setBorder(null);
        this.jToolBar_Scroll.setFloatable(false);
        this.jToolBar_Scroll.setRollover(true);
        this.jButton_ScrollSound.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_ScrollSound.png")));
        this.jButton_ScrollSound.setContentAreaFilled(false);
        this.jButton_ScrollSound.setFocusable(false);
        this.jButton_ScrollSound.setHorizontalTextPosition(0);
        this.jButton_ScrollSound.setVerticalTextPosition(3);
        this.jButton_ScrollSound.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowSceneBookPanel.this.jButton_ScrollSoundActionPerformed(evt);
            }
        });
        this.jToolBar_Scroll.add(this.jButton_ScrollSound);
        this.jButton_ScrollDMX.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_ScrollDMX.png")));
        this.jButton_ScrollDMX.setContentAreaFilled(false);
        this.jButton_ScrollDMX.setFocusable(false);
        this.jButton_ScrollDMX.setHorizontalTextPosition(0);
        this.jButton_ScrollDMX.setVerticalTextPosition(3);
        this.jButton_ScrollDMX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowSceneBookPanel.this.jButton_ScrollDMXActionPerformed(evt);
            }
        });
        this.jToolBar_Scroll.add(this.jButton_ScrollDMX);
        this.jButton_ScrollMedia.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_ScrollMedia.png")));
        this.jButton_ScrollMedia.setContentAreaFilled(false);
        this.jButton_ScrollMedia.setFocusable(false);
        this.jButton_ScrollMedia.setHorizontalTextPosition(0);
        this.jButton_ScrollMedia.setVerticalTextPosition(3);
        this.jButton_ScrollMedia.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowSceneBookPanel.this.jButton_ScrollMediaActionPerformed(evt);
            }
        });
        this.jToolBar_Scroll.add(this.jButton_ScrollMedia);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jToolBar_Scroll, gridBagConstraints);
        this.playControlPanel1.setMinimumSize(new Dimension(215, 38));
        this.playControlPanel1.setPreferredSize(new Dimension(220, 38));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.playControlPanel1, gridBagConstraints);
        this.jButton_SceneBookDocumentsVisible.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/StageOrder.png")));
        this.jButton_SceneBookDocumentsVisible.setToolTipText("show stage orders");
        this.jButton_SceneBookDocumentsVisible.setContentAreaFilled(false);
        this.jButton_SceneBookDocumentsVisible.setFocusable(false);
        this.jButton_SceneBookDocumentsVisible.setHorizontalTextPosition(0);
        this.jButton_SceneBookDocumentsVisible.setVerticalTextPosition(3);
        this.jButton_SceneBookDocumentsVisible.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowSceneBookPanel.this.jButton_SceneBookDocumentsVisibleActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jButton_SceneBookDocumentsVisible, gridBagConstraints);
        this.liveShowTimerDisplay1.setMinimumSize(new Dimension(260, 35));
        this.liveShowTimerDisplay1.setPreferredSize(new Dimension(260, 35));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.liveShowTimerDisplay1, gridBagConstraints);
        this.jButton_Export.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Export_html.png")));
        this.jButton_Export.setToolTipText("Export the scenebook as excel list (xls)");
        this.jButton_Export.setContentAreaFilled(false);
        this.jButton_Export.setFocusable(false);
        this.jButton_Export.setHorizontalTextPosition(0);
        this.jButton_Export.setVerticalTextPosition(3);
        this.jButton_Export.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowSceneBookPanel.this.jButton_ExportActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jButton_Export, gridBagConstraints);
    }

    public void looseFocusTextPanes() {
        this.playControlPanel1.requestFocusInWindow();
    }

    public void setPlaySynchronizer(Play.PlaySynchronisizer p_PlaySynchronisizer) {
        if (this.m_PlaySynchronisizer != null) {
            // empty if block
        }
        this.m_PlaySynchronisizer = p_PlaySynchronisizer;
        this.playControlPanel1.setPlaySynchronisizer(this.m_PlaySynchronisizer);
    }

    private void jButton_ScrollDMXActionPerformed(ActionEvent evt) {
        if (this.m_SceneBookColumns.size() < 2) {
            return;
        }
        SceneBookColumn o_SceneBookColumn = this.getSceneBookColumn(1);
        boolean boolAutoScroll = o_SceneBookColumn.getAutoScroll();
        if (boolAutoScroll) {
            boolAutoScroll = false;
            this.jButton_ScrollDMX.setBorder(null);
            this.jButton_ScrollDMX.setBorderPainted(false);
        } else {
            boolAutoScroll = true;
            this.jButton_ScrollDMX.setBorder(this.m_BorderSelected);
            this.jButton_ScrollDMX.setBorderPainted(true);
        }
        o_SceneBookColumn.setAutoScroll(boolAutoScroll);
    }

    private void jButton_ScrollSoundActionPerformed(ActionEvent evt) {
        if (this.m_SceneBookColumns.size() < 1) {
            return;
        }
        SceneBookColumn o_SceneBookColumn = this.getSceneBookColumn(0);
        boolean boolAutoScroll = o_SceneBookColumn.getAutoScroll();
        if (boolAutoScroll) {
            boolAutoScroll = false;
            this.jButton_ScrollSound.setBorder(null);
            this.jButton_ScrollSound.setBorderPainted(false);
        } else {
            boolAutoScroll = true;
            this.jButton_ScrollSound.setBorder(this.m_BorderSelected);
            this.jButton_ScrollSound.setBorderPainted(true);
        }
        o_SceneBookColumn.setAutoScroll(boolAutoScroll);
    }

    private void jButton_SceneBookDocumentsVisibleActionPerformed(ActionEvent evt) {
        if (this.m_SceneBookDocumentsVisible) {
            this.setSceneBookDocumentsVisible(false);
            this.jButton_SceneBookDocumentsVisible.setBorder(null);
            this.jButton_SceneBookDocumentsVisible.setBorderPainted(false);
        } else {
            this.setSceneBookDocumentsVisible(true);
            this.jButton_SceneBookDocumentsVisible.setBorder(this.m_BorderSelected);
            this.jButton_SceneBookDocumentsVisible.setBorderPainted(true);
        }
    }

    private void jButton_ScrollMediaActionPerformed(ActionEvent evt) {
        if (this.m_SceneBookColumns.size() < 3) {
            return;
        }
        SceneBookColumn o_SceneBookColumn = this.getSceneBookColumn(2);
        boolean boolAutoScroll = o_SceneBookColumn.getAutoScroll();
        if (boolAutoScroll) {
            boolAutoScroll = false;
            this.jButton_ScrollMedia.setBorder(null);
            this.jButton_ScrollMedia.setBorderPainted(false);
        } else {
            boolAutoScroll = true;
            this.jButton_ScrollMedia.setBorder(this.m_BorderSelected);
            this.jButton_ScrollMedia.setBorderPainted(true);
        }
        o_SceneBookColumn.setAutoScroll(boolAutoScroll);
    }

    private void jButton_ExportActionPerformed(ActionEvent evt) {
        if (this.getLiveShowVIPCount() <= 0) {
            return;
        }
        Export_HTML.SceneBookExport(this, this.m_SceneBookDocumentsVisible);
    }

    private void initComponentsFurther() {
        this.jScrollPane1.getViewport().setBackground(Color.BLACK);
        this.jScrollPane1.getVerticalScrollBar().setUnitIncrement(25);
        this.m_BorderSelected = new LineBorder(Color.BLUE, 1);
        this.m_GridBagLayout = (GridBagLayout)this.jPanel_SceneBook.getLayout();
        this.m_ToolBar_Text = LiveShowHTMLDocument.createTextToolBar();
        GridBagConstraints o_GridBagConstraints = new GridBagConstraints();
        o_GridBagConstraints.gridx = 0;
        o_GridBagConstraints.gridy = 2;
        o_GridBagConstraints.weightx = 1.0;
        o_GridBagConstraints.fill = 2;
        o_GridBagConstraints.anchor = 13;
        o_GridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.m_ToolBar_Text, o_GridBagConstraints);
        this.m_ToolBar_Text.setBackground(Color.BLACK);
        this.jButton_SceneBookDocumentsVisible.setBorder(this.m_BorderSelected);
        this.jButton_SceneBookDocumentsVisible.setBorderPainted(true);
        this.jButton_ScrollMedia.setBorder(this.m_BorderSelected);
        this.jButton_ScrollMedia.setBorderPainted(true);
        this.jButton_ScrollDMX.setBorder(this.m_BorderSelected);
        this.jButton_ScrollDMX.setBorderPainted(true);
        this.jButton_ScrollSound.setBorder(this.m_BorderSelected);
        this.jButton_ScrollSound.setBorderPainted(true);
        this.jButton_SceneBookDocumentsVisible.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_Export.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_ScrollMedia.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_ScrollDMX.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_ScrollSound.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.m_MainSceneBridgePanel_Start = new SceneBook_MainPanelSceneBridge(this, null);
        this.addMainSceneBridgePanel(this.m_MainSceneBridgePanel_Start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeProject() {
        this.liveShowTimerDisplay1.close();
        if (this.jLabel_ResizeFrame1 != null) {
            this.jLabel_ResizeFrame1.setContainer(null);
        }
        this.notifyListeners_Close();
        Object object = this.m_SyncListeners;
        synchronized (object) {
            this.m_SceneBookListeners.clear();
        }
        for (int intVIP = this.m_LiveShowVIPs.size() - 1; intVIP >= 0; --intVIP) {
            LiveShowVIP o_LiveShowVIP = this.m_LiveShowVIPs.get(intVIP);
            if (o_LiveShowVIP == null) continue;
            SceneBookColumn o_SceneBookColumn = this.getSceneBookColumn(o_LiveShowVIP);
            if (o_SceneBookColumn != null) {
                this.m_SceneBookColumns.remove(o_SceneBookColumn);
            }
            this.m_LiveShowVIPs.remove(intVIP);
            this.playControlPanel1.removePlay(o_LiveShowVIP.getPlay());
            o_LiveShowVIP.removeLiveShowVIPListener(this);
        }
        for (int intMainPanel = this.m_SceneBookMainPanels.size() - 1; intMainPanel >= 0; --intMainPanel) {
            SceneBook_MainPanelSceneBridge o_SceneBook_MainPanelSceneBridge = this.m_SceneBookMainPanels.get(intMainPanel);
            if (o_SceneBook_MainPanelSceneBridge == null) continue;
            o_SceneBook_MainPanelSceneBridge.closeProject();
            this.m_SceneBookMainPanels.remove(intMainPanel);
        }
        this.m_SceneBookDocuments.clear();
        this.jButton_SceneBookDocumentsVisible.setComponentPopupMenu(null);
        this.jButton_Export.setComponentPopupMenu(null);
        this.jButton_ScrollMedia.setComponentPopupMenu(null);
        this.jButton_ScrollDMX.setComponentPopupMenu(null);
        this.jButton_ScrollSound.setComponentPopupMenu(null);
        this.jButton_SceneBookDocumentsVisible.setComponentPopupMenu(null);
        LiveLanguage.removeLanguageListener(this);
    }

    public static String calculateDocumentID(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge, boolean p_Pre) {
        if (p_LiveShowVIP == null) {
            return null;
        }
        String stringDocumentID = p_LiveShowSceneBridge == null ? LiveShowSceneBookPanel.calculateDocumentID(p_LiveShowVIP.getType(), "null", p_Pre) : LiveShowSceneBookPanel.calculateDocumentID(p_LiveShowVIP.getType(), p_LiveShowSceneBridge.getID(), p_Pre);
        return stringDocumentID;
    }

    public static String calculateDocumentID(String p_LiveShowVIPType, String p_LiveShowSceneBridgeID, boolean p_Pre) {
        if (p_LiveShowVIPType == null) {
            return null;
        }
        String stringDocumentID = p_LiveShowSceneBridgeID == null ? "null" : p_LiveShowSceneBridgeID;
        stringDocumentID = stringDocumentID + p_LiveShowVIPType;
        stringDocumentID = p_Pre ? stringDocumentID + "Pre" : stringDocumentID + "Post";
        return stringDocumentID;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    public void writeExternal_SceneBook(ObjectOutput out, ArrayList<LiveShowSceneBridge> p_LiveShowSceneBridges) throws IOException {
        LiveShowHTMLDocument o_LiveShowEditorDocument;
        String stringDocumentID;
        LiveShowSceneBridge o_LiveShowSceneBridge;
        out.writeInt(2);
        boolean intUsedDocuments = false;
        ArrayList<LiveShowHTMLDocument> o_LiveShowEditorDocuments = new ArrayList<LiveShowHTMLDocument>();
        ArrayList<LiveShowSceneBridge> o_LiveShowSceneBridges = new ArrayList<LiveShowSceneBridge>();
        ArrayList<Boolean> o_Pres = new ArrayList<Boolean>();
        for (int intSceneBridge = 0; intSceneBridge < p_LiveShowSceneBridges.size(); ++intSceneBridge) {
            o_LiveShowSceneBridge = p_LiveShowSceneBridges.get(intSceneBridge);
            if (o_LiveShowSceneBridge == null) continue;
            stringDocumentID = LiveShowSceneBookPanel.calculateDocumentID(o_LiveShowSceneBridge.m_LiveShowVIP, o_LiveShowSceneBridge, true);
            o_LiveShowEditorDocument = this.m_SceneBookDocuments.get(stringDocumentID);
            if (o_LiveShowEditorDocument != null && o_LiveShowEditorDocument.getOwner() != null) {
                o_LiveShowEditorDocuments.add(o_LiveShowEditorDocument);
                o_LiveShowSceneBridges.add(o_LiveShowSceneBridge);
                o_Pres.add(true);
            }
            if ((o_LiveShowEditorDocument = this.m_SceneBookDocuments.get(stringDocumentID = LiveShowSceneBookPanel.calculateDocumentID(o_LiveShowSceneBridge.m_LiveShowVIP, o_LiveShowSceneBridge, false))) == null || o_LiveShowEditorDocument.getOwner() == null) continue;
            o_LiveShowEditorDocuments.add(o_LiveShowEditorDocument);
            o_LiveShowSceneBridges.add(o_LiveShowSceneBridge);
            o_Pres.add(false);
        }
        out.writeInt(o_LiveShowEditorDocuments.size());
        for (int intDocument = 0; intDocument < o_LiveShowEditorDocuments.size(); ++intDocument) {
            o_LiveShowEditorDocument = (LiveShowHTMLDocument)o_LiveShowEditorDocuments.get(intDocument);
            o_LiveShowSceneBridge = (LiveShowSceneBridge)o_LiveShowSceneBridges.get(intDocument);
            if (o_LiveShowSceneBridge == null) continue;
            LiveShowVIP o_LiveShowVIP = o_LiveShowSceneBridge.getLiveShowVIP();
            boolean boolIsPre = (Boolean)o_Pres.get(intDocument);
            stringDocumentID = LiveShowSceneBookPanel.calculateDocumentID(o_LiveShowSceneBridge.getLiveShowVIP(), o_LiveShowSceneBridge, boolIsPre);
            ByteBuffer o_ByteBuffer = LiveShowHTMLDocument.saveDocumentInByteBuffer(o_LiveShowEditorDocument);
            byte[] o_ByteArray = o_ByteBuffer.array();
            out.writeUTF(stringDocumentID);
            out.writeUTF(o_LiveShowVIP.getType());
            out.writeUTF(o_LiveShowSceneBridge.getID());
            out.writeBoolean(boolIsPre);
            out.writeInt(o_ByteArray.length);
            out.write(o_ByteArray);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public void readExternal_SceneBook(ObjectInput in, LiveShow_ImportDescription p_LiveShow_ImportDescription) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        int intDocumentsCount = 0;
        int intReadBytes = -1;
        if (p_LiveShow_ImportDescription.getLoadNewProject()) {
            this.m_SceneBookDocuments.clear();
        }
        intDocumentsCount = in.readInt();
        for (int intDoc = 0; intDoc < intDocumentsCount; ++intDoc) {
            String stringDocumentID = in.readUTF();
            if (intSoftwareVersion >= 2) {
                String stringVIPType = in.readUTF();
                String stringSceneBridgeID = in.readUTF();
                boolean boolIsPre = in.readBoolean();
                stringSceneBridgeID = p_LiveShow_ImportDescription.getReplacedID(stringSceneBridgeID);
                stringDocumentID = LiveShowSceneBookPanel.calculateDocumentID(stringVIPType, stringSceneBridgeID, boolIsPre);
            }
            int intByteArrayLength = in.readInt();
            ByteBuffer o_ByteBuffer = ByteBuffer.allocate(intByteArrayLength);
            for (intReadBytes = 0; intReadBytes < intByteArrayLength; intReadBytes += in.read(o_ByteBuffer.array(), intReadBytes, intByteArrayLength - intReadBytes)) {
            }
            LiveShowHTMLDocument o_LiveShowEditorDocument = LiveShowHTMLDocument.loadDocumentInByteBuffer(o_ByteBuffer);
            if (o_LiveShowEditorDocument == null) continue;
            this.m_SceneBookDocuments.put(stringDocumentID, o_LiveShowEditorDocument);
        }
        this.refreshSceneBookDocuments();
    }

    public static boolean saveLiveShowSceneBookPanel(LiveShowSceneBookPanel p_LiveShowSceneBookPanel, LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ExportDescription p_LiveShow_ExportDescription) {
        if (p_LiveShowSceneBookPanel == null) {
            return false;
        }
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        FileOutputStream o_OutputStream = null;
        ObjectOutput o_ObjectOutput = null;
        ArrayList<LiveShowSceneBridge> o_LiveShowSceneBridges = p_LiveShow_ExportDescription.getLiveShowSceneBridges();
        if (!p_LiveShow_ExportDescription.getSaveProject() && !p_LiveShow_ExportDescription.getExportProjectAll() && o_LiveShowSceneBridges.size() <= 0) {
            LiveShowSceneBookPanel.deleteLiveShowSceneBookPanel(p_LiveShowSceneBookPanel, p_LiveShowProjectDescription);
            return false;
        }
        File o_File = new File(p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX);
        try {
            if (o_File.exists()) {
                o_File.delete();
            }
            o_OutputStream = new FileOutputStream(o_File);
            o_ObjectOutput = new ObjectOutputStream(o_OutputStream);
            o_ObjectOutput.writeInt(2);
            p_LiveShowSceneBookPanel.writeExternal_SceneBook(o_ObjectOutput, o_LiveShowSceneBridges);
            o_ObjectOutput.close();
            ((OutputStream)o_OutputStream).close();
        }
        catch (Exception e) {
            try {
                if (o_ObjectOutput != null) {
                    o_ObjectOutput.close();
                }
                if (o_OutputStream != null) {
                    ((OutputStream)o_OutputStream).close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    public static boolean deleteLiveShowSceneBookPanel(LiveShowSceneBookPanel p_LiveShowSceneBookPanel, LiveShowProjectDescription p_LiveShowProjectDescription) {
        if (p_LiveShowSceneBookPanel == null) {
            return false;
        }
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        boolean boolSuccess = false;
        File o_File = new File(p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX);
        if (o_File.exists()) {
            try {
                boolSuccess = o_File.delete();
            }
            catch (Exception e) {
                boolSuccess = false;
            }
        }
        return boolSuccess;
    }

    public static LiveShowSceneBookPanel loadLiveShowSceneBookPanel(LiveShowSceneBookPanel p_LiveShowSceneBookPanel, LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ImportDescription p_LiveShow_ImportDescription) {
        File o_File;
        if (p_LiveShowProjectDescription == null) {
            return null;
        }
        FileInputStream o_InputStream = null;
        ObjectInput o_ObjectInput = null;
        LiveShowSceneBookPanel o_LiveShowSceneBookPanel = p_LiveShowSceneBookPanel;
        if (p_LiveShowSceneBookPanel == null) {
            o_LiveShowSceneBookPanel = new LiveShowSceneBookPanel();
        }
        if (p_LiveShow_ImportDescription.getLoadNewProject()) {
            o_LiveShowSceneBookPanel = new LiveShowSceneBookPanel();
        }
        if (!(o_File = new File(p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX)).exists()) {
            return o_LiveShowSceneBookPanel;
        }
        try {
            o_InputStream = new FileInputStream(o_File);
            o_ObjectInput = new ObjectInputStream(o_InputStream);
            int intSoftwareVersion = o_ObjectInput.readInt();
            o_LiveShowSceneBookPanel.readExternal_SceneBook(o_ObjectInput, p_LiveShow_ImportDescription);
            o_ObjectInput.close();
            ((InputStream)o_InputStream).close();
        }
        catch (Exception e) {
            try {
                if (o_ObjectInput != null) {
                    o_ObjectInput.close();
                }
                if (o_InputStream != null) {
                    ((InputStream)o_InputStream).close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            e.printStackTrace();
            return null;
        }
        return o_LiveShowSceneBookPanel;
    }

    public JLabel_ResizeFrame getLabel_ResizeFrame() {
        return this.jLabel_ResizeFrame1;
    }

    public LiveShowHTMLDocument.TextToolBar getTextToolBar() {
        return this.m_ToolBar_Text;
    }

    public LiveShowHTMLDocument findLiveShowEditorDocument(String p_DocumentID) {
        LiveShowHTMLDocument o_LiveShowEditorDocument = this.m_SceneBookDocuments.get(p_DocumentID);
        return o_LiveShowEditorDocument;
    }

    public HashMap<String, LiveShowHTMLDocument> getLiveShowEditorDocuments() {
        return this.m_SceneBookDocuments;
    }

    public LiveShowHTMLDocument getLiveShowEditorDocument_Pre(LiveShowSceneBridge p_LiveShowSceneBridge) {
        if (p_LiveShowSceneBridge == null) {
            return null;
        }
        LiveShowHTMLDocument o_LiveShowEditorDocument = null;
        LiveShowVIP o_LiveShowVIP = p_LiveShowSceneBridge.getLiveShowVIP();
        String stringDocumentID = LiveShowSceneBookPanel.calculateDocumentID(o_LiveShowVIP, p_LiveShowSceneBridge, true);
        if (stringDocumentID == null) {
            return null;
        }
        o_LiveShowEditorDocument = this.m_SceneBookDocuments.get(stringDocumentID);
        return o_LiveShowEditorDocument;
    }

    public LiveShowHTMLDocument getLiveShowEditorDocument_Post(LiveShowSceneBridge p_LiveShowSceneBridge) {
        if (p_LiveShowSceneBridge == null) {
            return null;
        }
        LiveShowHTMLDocument o_LiveShowEditorDocument = null;
        LiveShowVIP o_LiveShowVIP = p_LiveShowSceneBridge.getLiveShowVIP();
        String stringDocumentID = LiveShowSceneBookPanel.calculateDocumentID(o_LiveShowVIP, p_LiveShowSceneBridge, false);
        if (stringDocumentID == null) {
            return null;
        }
        o_LiveShowEditorDocument = this.m_SceneBookDocuments.get(stringDocumentID);
        return o_LiveShowEditorDocument;
    }

    public void setSceneBookDocumentsVisible(boolean p_DocumentsVisible) {
        if (this.m_SceneBookDocumentsVisible == p_DocumentsVisible) {
            return;
        }
        this.m_SceneBookDocumentsVisible = p_DocumentsVisible;
        for (int intMainPanel = 0; intMainPanel < this.m_SceneBookMainPanels.size(); ++intMainPanel) {
            SceneBook_MainPanelSceneBridge o_SceneBook_MainPanelSceneBridge = this.m_SceneBookMainPanels.get(intMainPanel);
            if (o_SceneBook_MainPanelSceneBridge == null) continue;
            o_SceneBook_MainPanelSceneBridge.setSceneBookDocumentsVisible(p_DocumentsVisible);
        }
        for (int intColumn = 0; intColumn < this.m_SceneBookColumns.size(); ++intColumn) {
            SceneBookColumn o_SceneBookColumn = this.m_SceneBookColumns.get(intColumn);
            if (o_SceneBookColumn == null) continue;
            o_SceneBookColumn.scroll();
        }
    }

    public boolean getSceneBookDocumentsVisible() {
        return this.m_SceneBookDocumentsVisible;
    }

    public void refreshSceneBookDocuments() {
        for (int intMainPanel = 0; intMainPanel < this.m_SceneBookMainPanels.size(); ++intMainPanel) {
            SceneBook_MainPanelSceneBridge o_SceneBook_MainPanelSceneBridge = this.m_SceneBookMainPanels.get(intMainPanel);
            if (o_SceneBook_MainPanelSceneBridge == null) continue;
            o_SceneBook_MainPanelSceneBridge.refreshSceneBookDocuments();
        }
    }

    public void setProjectDescription(LiveShowProjectDescription p_LiveShowProjectDescription) {
        this.m_LiveShowProjectDescription = p_LiveShowProjectDescription;
        this.m_MainSceneBridgePanel_Start.setLiveShowProjectDescription(p_LiveShowProjectDescription);
    }

    public LiveShowProjectDescription getLiveShowProjectDescription() {
        return this.m_LiveShowProjectDescription;
    }

    public Play.PlaySynchronisizer getPlaySynchronisizer() {
        return this.m_PlaySynchronisizer;
    }

    public void addLiveShowVIP(LiveShowVIP p_LiveShowVIP) {
        SceneBookColumn o_SceneBookColumn;
        if (p_LiveShowVIP == null) {
            return;
        }
        if (this.m_LiveShowVIPs.contains(p_LiveShowVIP)) {
            return;
        }
        this.m_LiveShowVIPs.add(p_LiveShowVIP);
        this.playControlPanel1.addPlay(p_LiveShowVIP.getPlay());
        for (int intColumn = 0; intColumn < this.m_SceneBookColumns.size(); ++intColumn) {
            o_SceneBookColumn = this.m_SceneBookColumns.get(intColumn);
            if (o_SceneBookColumn == null || o_SceneBookColumn.getLiveShowVIP() != p_LiveShowVIP) continue;
            return;
        }
        o_SceneBookColumn = new SceneBookColumn(this, p_LiveShowVIP, this.m_SceneBookColumns.size());
        this.m_SceneBookColumns.add(o_SceneBookColumn);
        this.m_MainSceneBridgePanel_Start.addSceneBookColumn(o_SceneBookColumn);
        for (int intMainPanel = 0; intMainPanel < this.m_SceneBookMainPanels.size(); ++intMainPanel) {
            SceneBook_MainPanelSceneBridge o_MainSceneBridgePanel = this.m_SceneBookMainPanels.get(intMainPanel);
            if (o_MainSceneBridgePanel == null) continue;
            o_MainSceneBridgePanel.addSceneBookColumn(o_SceneBookColumn);
        }
        ArrayList<LiveShowSceneBridge> o_LiveShowSceneBridges = null;
        o_LiveShowSceneBridges = p_LiveShowVIP.getLiveShowSceneBridges(o_LiveShowSceneBridges, false);
        for (int intBridge = 0; intBridge < o_LiveShowSceneBridges.size(); ++intBridge) {
            LiveShowSceneBridge o_LiveShowSceneBridge = o_LiveShowSceneBridges.get(intBridge);
            this.addLiveShowSceneBridge(p_LiveShowVIP, o_LiveShowSceneBridge);
        }
        p_LiveShowVIP.addLiveShowVIPListener(this);
        this.setActualLiveShowSceneBridge(p_LiveShowVIP, p_LiveShowVIP.getLiveShowSceneBridge_Cursor());
        this.eventVIPChangeDone(p_LiveShowVIP);
    }

    public int getLiveShowVIPCount() {
        return this.m_LiveShowVIPs.size();
    }

    public LiveShowVIP getLiveShowVIP(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        if (p_Index >= this.m_LiveShowVIPs.size()) {
            return null;
        }
        return this.m_LiveShowVIPs.get(p_Index);
    }

    public int getSceneBookColumnCount() {
        return this.m_SceneBookColumns.size();
    }

    public SceneBookColumn getSceneBookColumn(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        if (p_Index >= this.m_SceneBookColumns.size()) {
            return null;
        }
        return this.m_SceneBookColumns.get(p_Index);
    }

    public SceneBookColumn getSceneBookColumn(LiveShowVIP p_LiveShowVIP) {
        if (p_LiveShowVIP == null) {
            return null;
        }
        for (int intColumn = 0; intColumn < this.m_SceneBookColumns.size(); ++intColumn) {
            SceneBookColumn o_SceneBookColumn = this.m_SceneBookColumns.get(intColumn);
            if (o_SceneBookColumn == null || o_SceneBookColumn.getLiveShowVIP() != p_LiveShowVIP) continue;
            return o_SceneBookColumn;
        }
        return null;
    }

    public SceneBookColumn getSceneBookColumn(LiveShowSceneBridge p_LiveShowSceneBridge) {
        if (p_LiveShowSceneBridge == null) {
            return null;
        }
        LiveShowVIP o_LiveShowVIP = p_LiveShowSceneBridge.getLiveShowVIP();
        return this.getSceneBookColumn(o_LiveShowVIP);
    }

    public void addMainSceneBridgePanel(SceneBook_MainPanelSceneBridge p_MainSceneBridgePanel) {
        if (p_MainSceneBridgePanel == null) {
            return;
        }
        int intPanelIndex = 0;
        SceneBook_MainPanelSceneBridge o_MainSceneBridgePanelPrior = this.findMainSceneBridgePanelPrior(p_MainSceneBridgePanel.getFrameStart(), null);
        intPanelIndex = o_MainSceneBridgePanelPrior == null ? -1 : this.m_SceneBookMainPanels.indexOf(o_MainSceneBridgePanelPrior);
        GridBagConstraints o_GridBagConstraints = p_MainSceneBridgePanel.getGridBagConstraints();
        o_GridBagConstraints.gridy = intPanelIndex + 1;
        this.jPanel_SceneBook.add((Component)p_MainSceneBridgePanel, o_GridBagConstraints);
        p_MainSceneBridgePanel.setVisible(true);
        this.m_AddedSceneBook_MainPanelSceneBridges.add(p_MainSceneBridgePanel);
        this.moveMainSceneBridgePanelTo(p_MainSceneBridgePanel, intPanelIndex + 1);
        this.m_NotifyChangedSructure = true;
    }

    public void removeMainSceneBridgePanel(SceneBook_MainPanelSceneBridge p_MainSceneBridgePanel) {
        SceneBookItem o_SceneBookItem;
        if (p_MainSceneBridgePanel == null) {
            return;
        }
        int intPanelIndex = this.m_SceneBookMainPanels.indexOf(p_MainSceneBridgePanel);
        if (intPanelIndex < 0) {
            return;
        }
        this.m_SceneBookItemsLost.clear();
        for (int intRow = 0; intRow < p_MainSceneBridgePanel.getSceneBookRowCount(); ++intRow) {
            SceneBookRow o_SceneBookRow = p_MainSceneBridgePanel.getSceneBookRow(intRow);
            if (o_SceneBookRow == null) continue;
            for (int intSceneBookItem = 0; intSceneBookItem < o_SceneBookRow.getSceneBookItemCount(); ++intSceneBookItem) {
                o_SceneBookItem = o_SceneBookRow.getSceneBookItem(intSceneBookItem);
                if (o_SceneBookItem == null) continue;
                this.m_SceneBookItemsLost.add(o_SceneBookItem);
            }
        }
        this.m_SceneBookMainPanels.remove(p_MainSceneBridgePanel);
        p_MainSceneBridgePanel.setVisible(false);
        this.jPanel_SceneBook.remove(p_MainSceneBridgePanel);
        p_MainSceneBridgePanel.closeSingle();
        for (int intMainBridge = intPanelIndex; intMainBridge < this.m_SceneBookMainPanels.size(); ++intMainBridge) {
            SceneBook_MainPanelSceneBridge o_MainSceneBridgePanel = this.m_SceneBookMainPanels.get(intMainBridge);
            if (o_MainSceneBridgePanel == null) continue;
            GridBagConstraints o_GridBagConstraints = o_MainSceneBridgePanel.getGridBagConstraints();
            --o_GridBagConstraints.gridy;
            this.m_GridBagLayout.setConstraints(o_MainSceneBridgePanel, o_GridBagConstraints);
        }
        for (int intSceneBookItem = 0; intSceneBookItem < this.m_SceneBookItemsLost.size(); ++intSceneBookItem) {
            o_SceneBookItem = this.m_SceneBookItemsLost.get(intSceneBookItem);
            o_SceneBookItem.resortSceneBookItem();
        }
        this.m_SceneBookItemsLost.clear();
        this.m_NotifyChangedSructure = true;
        this.revalidate();
        this.repaint();
    }

    public int getMainPanelSceneBridgeCount() {
        return this.m_SceneBookMainPanels.size();
    }

    public SceneBook_MainPanelSceneBridge getMainPanelSceneBridge(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        if (p_Index >= this.m_SceneBookMainPanels.size()) {
            return null;
        }
        try {
            return this.m_SceneBookMainPanels.get(p_Index);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void resortMainSceneBridgePanel(SceneBook_MainPanelSceneBridge p_MainSceneBridgePanel) {
        if (p_MainSceneBridgePanel == null) {
            return;
        }
        int intOldPanelIndex = this.m_SceneBookMainPanels.indexOf(p_MainSceneBridgePanel);
        if (intOldPanelIndex < 0) {
            return;
        }
        SceneBook_MainPanelSceneBridge o_MainSceneBridgePanelPrior = null;
        o_MainSceneBridgePanelPrior = this.findMainSceneBridgePanelPrior(p_MainSceneBridgePanel.getFrameStart(), p_MainSceneBridgePanel);
        int intPanelIndexPreviousMainBridge = o_MainSceneBridgePanelPrior == null ? -1 : this.m_SceneBookMainPanels.indexOf(o_MainSceneBridgePanelPrior);
        int intNewPanelIndex = intOldPanelIndex <= intPanelIndexPreviousMainBridge ? intPanelIndexPreviousMainBridge : intPanelIndexPreviousMainBridge + 1;
        if (intOldPanelIndex != intNewPanelIndex) {
            this.moveMainSceneBridgePanelTo(p_MainSceneBridgePanel, intNewPanelIndex);
        }
    }

    public SceneBook_MainPanelSceneBridge getMainSceneBridgePanel_Start() {
        return this.m_MainSceneBridgePanel_Start;
    }

    public SceneBook_MainPanelSceneBridge getMainSceneBridgePanel(LiveShowSceneBridgeMain p_LiveShowSceneBridgeMain) {
        if (p_LiveShowSceneBridgeMain == null) {
            return null;
        }
        for (int intMainBridge = 0; intMainBridge < this.m_SceneBookMainPanels.size(); ++intMainBridge) {
            SceneBook_MainPanelSceneBridge o_MainSceneBridgePanel = this.m_SceneBookMainPanels.get(intMainBridge);
            if (o_MainSceneBridgePanel == null || o_MainSceneBridgePanel.getLiveShowSceneBridgeMain() != p_LiveShowSceneBridgeMain) continue;
            return o_MainSceneBridgePanel;
        }
        return null;
    }

    public SceneBook_MainPanelSceneBridge findMainSceneBridgePanelPrior(long p_FrameStart, SceneBook_MainPanelSceneBridge p_ExludedMainSceneBridgePanel) {
        if (p_FrameStart < 0L) {
            return null;
        }
        SceneBook_MainPanelSceneBridge o_MainSceneBridgePanel = null;
        SceneBook_MainPanelSceneBridge o_MainSceneBridgePanelResult = null;
        for (int intMainBridge = 0; intMainBridge < this.m_SceneBookMainPanels.size(); ++intMainBridge) {
            o_MainSceneBridgePanel = this.m_SceneBookMainPanels.get(intMainBridge);
            if (o_MainSceneBridgePanel == null || o_MainSceneBridgePanel == p_ExludedMainSceneBridgePanel || p_FrameStart < o_MainSceneBridgePanel.getFrameStart()) continue;
            if (o_MainSceneBridgePanelResult == null) {
                o_MainSceneBridgePanelResult = o_MainSceneBridgePanel;
                continue;
            }
            if (o_MainSceneBridgePanel.getFrameStart() <= o_MainSceneBridgePanelResult.getFrameStart()) continue;
            o_MainSceneBridgePanelResult = o_MainSceneBridgePanel;
        }
        return o_MainSceneBridgePanelResult;
    }

    public void moveMainSceneBridgePanelTo(SceneBook_MainPanelSceneBridge p_MainSceneBridgePanel, int p_IndexNew) {
        GridBagConstraints o_GridBagConstraints;
        SceneBook_MainPanelSceneBridge o_MainSceneBridgePanel;
        int intIndex;
        if (p_MainSceneBridgePanel == null) {
            return;
        }
        int intIndexOld = this.m_SceneBookMainPanels.indexOf(p_MainSceneBridgePanel);
        if (intIndexOld == p_IndexNew) {
            return;
        }
        this.m_NotifyChangedSructure = true;
        if (intIndexOld >= 0) {
            this.m_SceneBookMainPanels.remove(p_MainSceneBridgePanel);
        } else {
            intIndexOld = this.m_SceneBookMainPanels.size();
        }
        for (intIndex = intIndexOld; intIndex < this.m_SceneBookMainPanels.size(); ++intIndex) {
            o_MainSceneBridgePanel = this.m_SceneBookMainPanels.get(intIndex);
            if (o_MainSceneBridgePanel == null) continue;
            o_GridBagConstraints = o_MainSceneBridgePanel.getGridBagConstraints();
            --o_GridBagConstraints.gridy;
            this.m_GridBagLayout.setConstraints(o_MainSceneBridgePanel, o_GridBagConstraints);
        }
        if (this.m_SceneBookMainPanels.size() <= 0) {
            p_IndexNew = 0;
        } else if (p_IndexNew > this.m_SceneBookMainPanels.size()) {
            p_IndexNew = this.m_SceneBookMainPanels.size();
        }
        o_GridBagConstraints = p_MainSceneBridgePanel.getGridBagConstraints();
        o_GridBagConstraints.gridy = p_IndexNew;
        this.m_GridBagLayout.setConstraints(p_MainSceneBridgePanel, o_GridBagConstraints);
        this.m_SceneBookMainPanels.add(p_IndexNew, p_MainSceneBridgePanel);
        for (intIndex = p_IndexNew + 1; intIndex < this.m_SceneBookMainPanels.size(); ++intIndex) {
            o_MainSceneBridgePanel = this.m_SceneBookMainPanels.get(intIndex);
            if (o_MainSceneBridgePanel == null) continue;
            o_GridBagConstraints = o_MainSceneBridgePanel.getGridBagConstraints();
            ++o_GridBagConstraints.gridy;
            this.m_GridBagLayout.setConstraints(o_MainSceneBridgePanel, o_GridBagConstraints);
        }
    }

    public void addLiveShowSceneBridge(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge) {
        if (p_LiveShowSceneBridge == null) {
            return;
        }
        if (p_LiveShowSceneBridge.getIsMainBridge()) {
            LiveShowSceneBridgeMain.MainBridgeContainer o_MainBridgeContainer = LiveShowSceneBridgeMain.getMainBridgeContainer();
            LiveShowSceneBridgeMain o_LiveShowSceneBridgeMain = o_MainBridgeContainer.findLiveShowSceneBridgeMain(p_LiveShowSceneBridge.getID());
            SceneBook_MainPanelSceneBridge o_MainSceneBridgePanel = this.getMainSceneBridgePanel(o_LiveShowSceneBridgeMain);
            if (o_MainSceneBridgePanel == null) {
                o_MainSceneBridgePanel = new SceneBook_MainPanelSceneBridge(this, o_LiveShowSceneBridgeMain);
                this.addMainSceneBridgePanel(o_MainSceneBridgePanel);
            }
            o_MainSceneBridgePanel.addLiveShowSceneBridge_Main(p_LiveShowSceneBridge);
            this.m_NotifyChangedSructure = true;
            this.eventRefreshMainPanelSceneBridge(o_MainSceneBridgePanel);
            return;
        }
        SceneBookItem o_SceneBookItem = this.getSceneBookItem(p_LiveShowSceneBridge);
        if (o_SceneBookItem == null) {
            o_SceneBookItem = new SceneBookItem(this, this.getSceneBookColumn(p_LiveShowSceneBridge), p_LiveShowSceneBridge);
            SceneBook_MainPanelSceneBridge o_MainSceneBridgePanelPrior = this.findMainSceneBridgePanelPrior(p_LiveShowSceneBridge.getFrameStart(), null);
            if (o_MainSceneBridgePanelPrior == null) {
                return;
            }
            o_MainSceneBridgePanelPrior.addSceneBookItem(o_SceneBookItem);
        }
        this.eventChengedSceneBookItem(o_SceneBookItem);
    }

    public void removeLiveShowSceneBridge(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge) {
        if (p_LiveShowSceneBridge == null) {
            return;
        }
        if (p_LiveShowSceneBridge.getIsMainBridge()) {
            LiveShowSceneBridgeMain.MainBridgeContainer o_MainBridgeContainer = LiveShowSceneBridgeMain.getMainBridgeContainer();
            LiveShowSceneBridgeMain o_LiveShowSceneBridgeMain = o_MainBridgeContainer.findLiveShowSceneBridgeMain(p_LiveShowSceneBridge.getID());
            SceneBook_MainPanelSceneBridge o_MainSceneBridgePanel = this.getMainSceneBridgePanel(o_LiveShowSceneBridgeMain);
            if (o_MainSceneBridgePanel == null) {
                return;
            }
            this.removeMainSceneBridgePanel(o_MainSceneBridgePanel);
            o_MainSceneBridgePanel.removeLiveShowSceneBridge_Main(p_LiveShowSceneBridge);
            o_MainSceneBridgePanel.closeSingle();
            this.m_NotifyChangedSructure = true;
            return;
        }
        SceneBookItem o_SceneBookItem = this.getSceneBookItem(p_LiveShowSceneBridge);
        if (o_SceneBookItem == null) {
            return;
        }
        SceneBook_MainPanelSceneBridge o_MainSceneBridgePanel = o_SceneBookItem.getMainSceneBridgePanel();
        if (o_MainSceneBridgePanel != null) {
            o_MainSceneBridgePanel.removeSceneBookItem(o_SceneBookItem);
        }
        o_SceneBookItem.closeSingle();
    }

    public void eventRefreshMainPanelSceneBridge(SceneBook_MainPanelSceneBridge p_SceneBook_MainPanelSceneBridge) {
        if (p_SceneBook_MainPanelSceneBridge == null) {
            return;
        }
        if (this.m_RefreshSceneBook_MainPanelSceneBridges.contains(p_SceneBook_MainPanelSceneBridge)) {
            return;
        }
        this.m_RefreshSceneBook_MainPanelSceneBridges.add(p_SceneBook_MainPanelSceneBridge);
    }

    public void eventChangedMainPanelSceneBridge(SceneBook_MainPanelSceneBridge p_SceneBook_MainPanelSceneBridge, LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (p_SceneBook_MainPanelSceneBridge == null) {
            return;
        }
        if (this.m_ChangedSceneBook_MainPanelSceneBridges.contains(p_SceneBook_MainPanelSceneBridge)) {
            return;
        }
        this.m_ChangedSceneBook_MainPanelSceneBridges.add(p_SceneBook_MainPanelSceneBridge);
    }

    public void eventChengedSceneBookItem(SceneBookItem p_SceneBookItem) {
        if (p_SceneBookItem == null) {
            return;
        }
        if (this.m_ChangedSceneBookItems.contains(p_SceneBookItem)) {
            return;
        }
        this.m_ChangedSceneBookItems.add(p_SceneBookItem);
    }

    public void eventChangedSceneBook_PanelSceneBridge(SceneBook_PanelSceneBridge p_SceneBook_PanelSceneBridge) {
        if (p_SceneBook_PanelSceneBridge == null) {
            return;
        }
        if (this.m_ChangedSceneBook_PanelSceneBridges.contains(p_SceneBook_PanelSceneBridge)) {
            return;
        }
        this.m_ChangedSceneBook_PanelSceneBridges.add(p_SceneBook_PanelSceneBridge);
    }

    public void setChangedStructure(boolean p_ChangedStructure) {
        this.m_NotifyChangedSructure = p_ChangedStructure;
    }

    @Override
    public void eventVIPActive(LiveShowVIP p_LiveShowVIP, boolean p_Active) {
        for (int intMainPanel = 0; intMainPanel < this.m_SceneBookMainPanels.size(); ++intMainPanel) {
            SceneBook_MainPanelSceneBridge o_SceneBook_MainPanelSceneBridge = this.m_SceneBookMainPanels.get(intMainPanel);
            if (o_SceneBook_MainPanelSceneBridge == null) continue;
            o_SceneBook_MainPanelSceneBridge.refresh();
        }
        SceneBookColumn o_SceneBookColumn = this.getSceneBookColumn(p_LiveShowVIP);
        if (o_SceneBookColumn != null) {
            int intIndex = o_SceneBookColumn.getColumnIndex();
            switch (intIndex) {
                case 0: {
                    this.jButton_ScrollSound.setVisible(p_Active);
                    break;
                }
                case 1: {
                    this.jButton_ScrollDMX.setVisible(p_Active);
                    break;
                }
                case 2: {
                    this.jButton_ScrollMedia.setVisible(p_Active);
                }
            }
        }
    }

    public void eventVIPChangeDone(LiveShowVIP p_LiveShowVIP) {
        EventQueueHandler.invokeLater(this.m_RunnableVIPChangeDone);
    }

    public void setActualLiveShowSceneBridge(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge) {
        for (int intMainPanel = 0; intMainPanel < this.m_SceneBookMainPanels.size(); ++intMainPanel) {
            SceneBook_MainPanelSceneBridge o_MainSceneBridgePanel = this.m_SceneBookMainPanels.get(intMainPanel);
            if (o_MainSceneBridgePanel == null) continue;
            o_MainSceneBridgePanel.setActualScene(p_LiveShowVIP, p_LiveShowSceneBridge);
        }
    }

    public SceneBookItem getSceneBookItem(LiveShowSceneBridge p_LiveShowSceneBridge) {
        if (p_LiveShowSceneBridge == null) {
            return null;
        }
        for (int intMainBridgePanel = 0; intMainBridgePanel < this.m_SceneBookMainPanels.size(); ++intMainBridgePanel) {
            SceneBookItem o_SceneBookItem;
            SceneBook_MainPanelSceneBridge o_MainSceneBridgePanel = this.m_SceneBookMainPanels.get(intMainBridgePanel);
            if (o_MainSceneBridgePanel == null || (o_SceneBookItem = o_MainSceneBridgePanel.getSceneBookItem(p_LiveShowSceneBridge)) == null) continue;
            return o_SceneBookItem;
        }
        return null;
    }

    public void scrollToRectangle(Rectangle p_Rectangle) {
        if (p_Rectangle == null) {
            return;
        }
        p_Rectangle.y -= 100;
        p_Rectangle.height += 200;
        this.jPanel_SceneBook.scrollRectToVisible(p_Rectangle);
    }

    @Override
    public void eventVIPToFront(LiveShowVIP p_LiveShowVIP) {
    }

    @Override
    public void eventVIPTrackAdded(LiveShowVIP p_LiveShowSoundVIP, LiveShowVIPTrack p_LiveShowVIPTrack) {
    }

    @Override
    public void eventVIPTrackRemoved(LiveShowVIP p_LiveShowSoundVIP, LiveShowVIPTrack p_LiveShowVIPTrack) {
    }

    @Override
    public void eventVIPFrameMaxObjects(LiveShowVIP p_LiveShowVIP, long p_FrameMaxObjects) {
    }

    @Override
    public void eventVIPMaxFrame(LiveShowVIP p_LiveShowVIP, long p_FrameMax) {
    }

    @Override
    public void eventVIPFrameTime(LiveShowVIP p_LiveShowVIP, double p_FrameTime) {
    }

    @Override
    public void eventVIPClosing(LiveShowVIP p_LiveShowSoundVIP) {
    }

    @Override
    public void eventVIPSceneBridgeAdded(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge) {
        this.addLiveShowSceneBridge(p_LiveShowVIP, p_LiveShowSceneBridge);
    }

    @Override
    public void eventVIPSceneBridgeRemoved(LiveShowVIP p_LiveShowSoundVIP, LiveShowSceneBridge p_LiveShowSceneBridge) {
        this.removeLiveShowSceneBridge(p_LiveShowSoundVIP, p_LiveShowSceneBridge);
    }

    @Override
    public void eventVIPSceneBridgesResorted(LiveShowVIP p_LiveShowSoundVIP, LiveShowSceneBridge p_LiveShowSceneBridge, ArrayList<LiveShowSceneBridge> p_LiveShowSceneBridges) {
    }

    @Override
    public void eventVIPSceneBridgeCursorChanged(LiveShowVIP p_LiveShowVIP, boolean p_ActualPlaying, boolean p_ActualStopAtStart) {
        this.setActualLiveShowSceneBridge(p_LiveShowVIP, p_LiveShowVIP.getLiveShowSceneBridge_Cursor());
    }

    @Override
    public void eventVIPSceneBridgeEditCursorChanged(LiveShowVIP p_LiveShowVIP) {
    }

    @Override
    public void eventVIPSceneBridgeStart(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge, boolean p_WillPlay) {
    }

    @Override
    public void eventVIPSceneBridgeEnd(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge) {
    }

    @Override
    public void eventVIPObjectAdded(LiveShowVIP p_LiveShowSoundVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
    }

    @Override
    public void eventVIPObjectRemoved(LiveShowVIP p_LiveShowSoundVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
    }

    @Override
    public void eventVIPObjectParamChanged(LiveShowVIP p_LiveShowSoundVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
    }

    @Override
    public void eventVIPObjectShowSettings(LiveShowVIP p_LiveShowSoundVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
    }

    @Override
    public void eventVIPObjectSelection(LiveShowVIP p_LiveShowSoundVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
    }

    @Override
    public void eventVIPEditModeOn(LiveShowVIP p_LiveShowVIP, boolean p_EditModeOn) {
    }

    @Override
    public void eventVIPCursorMode(LiveShowVIP p_LiveShowSoundVIP, int p_EditMode) {
    }

    @Override
    public void eventVIPEndOfAction(LiveShowVIP p_LiveShowVIP, LiveShowVIP p_ActorLiveShowVIP, boolean p_Success, int p_Action) {
        this.eventVIPChangeDone(p_LiveShowVIP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSceneBookListener(SceneBookListener p_SceneBookListener) {
        if (p_SceneBookListener == null) {
            return;
        }
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_SceneBookListeners.contains(p_SceneBookListener)) {
                return;
            }
            this.m_SceneBookListeners.add(p_SceneBookListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSceneBookListener(SceneBookListener p_SceneBookListener) {
        if (p_SceneBookListener == null) {
            return;
        }
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (!this.m_SceneBookListeners.contains(p_SceneBookListener)) {
                return;
            }
            this.m_SceneBookListeners.remove(p_SceneBookListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners_Changed() {
        ArrayList<SceneBookListener> o_SceneBookListeners;
        Object object = this.m_SyncListeners;
        synchronized (object) {
            o_SceneBookListeners = new ArrayList<SceneBookListener>(this.m_SceneBookListeners.size());
            o_SceneBookListeners.addAll(this.m_SceneBookListeners);
        }
        for (int intListener = 0; intListener < o_SceneBookListeners.size(); ++intListener) {
            SceneBookListener o_SceneBookListener = (SceneBookListener)o_SceneBookListeners.get(intListener);
            o_SceneBookListener.eventSceneBookChanged(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners_Close() {
        ArrayList<SceneBookListener> o_SceneBookListeners;
        Object object = this.m_SyncListeners;
        synchronized (object) {
            o_SceneBookListeners = new ArrayList<SceneBookListener>(this.m_SceneBookListeners.size());
            o_SceneBookListeners.addAll(this.m_SceneBookListeners);
        }
        for (int intListener = 0; intListener < o_SceneBookListeners.size(); ++intListener) {
            SceneBookListener o_SceneBookListener = (SceneBookListener)o_SceneBookListeners.get(intListener);
            o_SceneBookListener.eventSceneBookClose(this);
        }
    }

    public static class SceneBook_PanelSceneBridge
    implements LiveShowObjectListener,
    PlayListener,
    LiveShowTimer.LiveShowTimerListener_SceneBridge {
        public static Icon s_IconPlay = new ImageIcon(SceneBook_PanelSceneBridge.class.getResource("/IconsPackage/PlayStart32.png"));
        private LiveShowSceneBookPanel m_LiveShowSceneBookPanel;
        private SceneBookColumn m_SceneBookColumn;
        private LiveShowSceneBridge m_LiveShowSceneBridge;
        private Play m_Play;
        private boolean m_IsActualScene;
        private boolean m_IsPlaying;
        private long m_TimeFramesRest;
        private JPanel m_ParentPanel;
        private JPanel jPanelSceneBridge;
        private JLabel_RightClickToolTip jLabelSceneBridge;
        private JLabel jLabelSceneBridgeTime;
        private JLabel jLabelJumpSceneBridge;
        private JLabel jLabelJumpActive;
        private JLabel jLabelPlay;
        private JLabel jLabelStopper;
        private JLabel jLabelActive;
        private JTextPane_RightClickToolTip jTextPanePre;
        private LiveShowHTMLDocument m_DocumentPre;
        private JTextPane_RightClickToolTip jTextPanePost;
        private LiveShowHTMLDocument m_DocumentPost;
        private Border m_BorderActualScene;
        private Border m_BorderActualScene_Stopped;
        private Color m_ColorMainSceneBridge;
        private Color m_ColorMainSceneBridge_InActive;
        private Color m_ColorSceneBridge;
        private Color m_ColorSceneBridge_InActive;
        private Color m_ColorStart;
        private Color m_ColorPlay;
        private Color m_ColorSceneBridgeStopper;
        private Color m_ColorSceneBridgeActive;
        private Icon Icon_Jump;
        private Icon Icon_JumpDisabled;
        private Rectangle m_BoundsAbsolute;
        private MouseAdapter_Delayed m_MouseAdapter_Delayed;
        private SceneBook_PanelSceneBridge m_SelfReference;
        private Runnable m_RunnableRefresh = new Runnable(){

            @Override
            public void run() {
                try {
                    LiveShowVIP o_LiveShowVIP;
                    boolean boolActive = true;
                    boolean boolVIPActive = false;
                    if (m_LiveShowSceneBridge != null && (o_LiveShowVIP = m_LiveShowSceneBridge.getLiveShowVIP()) != null) {
                        boolVIPActive = o_LiveShowVIP.getActive();
                    }
                    jLabelSceneBridge.setVisible(true);
                    jLabelPlay.setVisible(true);
                    if (m_IsActualScene) {
                        if (m_IsPlaying) {
                            jLabelSceneBridge.setBorder(m_BorderActualScene);
                            jLabelSceneBridgeTime.setBorder(m_BorderActualScene);
                        } else {
                            jLabelSceneBridge.setBorder(m_BorderActualScene_Stopped);
                            jLabelSceneBridgeTime.setBorder(m_BorderActualScene_Stopped);
                        }
                        jLabelPlay.setOpaque(true);
                        m_SceneBookColumn.setActualSceneBookPanel_SceneBridge(m_SelfReference);
                    } else {
                        jLabelSceneBridge.setBorder(null);
                        jLabelSceneBridgeTime.setBorder(null);
                        jLabelPlay.setOpaque(false);
                    }
                    if (m_LiveShowSceneBridge == null) {
                        jTextPanePre.setVisible(false);
                        jTextPanePost.setVisible(false);
                        LiveShowProjectDescription o_LiveShowProjectDescription = m_LiveShowSceneBookPanel.getLiveShowProjectDescription();
                        if (o_LiveShowProjectDescription != null) {
                            jLabelSceneBridge.setText(o_LiveShowProjectDescription.getProjectName());
                        } else {
                            jLabelSceneBridge.setText("-");
                        }
                        jLabelSceneBridge.setToolTipText_RightClick(null);
                        jLabelStopper.setVisible(false);
                        jLabelActive.setVisible(false);
                        jLabelJumpSceneBridge.setText("");
                    } else {
                        if (m_LiveShowSceneBookPanel.getSceneBookDocumentsVisible() && boolVIPActive) {
                            jTextPanePre.setVisible(true);
                            jTextPanePost.setVisible(true);
                        } else {
                            jTextPanePre.setVisible(false);
                            jTextPanePost.setVisible(false);
                        }
                        jLabelSceneBridge.setText(m_LiveShowSceneBridge.getName());
                        jLabelSceneBridge.setToolTipText_RightClick(m_LiveShowSceneBridge.getName());
                        if (m_LiveShowSceneBridge.getJumpSceneBridge() == null) {
                            jLabelJumpSceneBridge.setOpaque(false);
                            jLabelJumpSceneBridge.setText("---");
                            jLabelJumpSceneBridge.setVisible(false);
                            jLabelJumpActive.setVisible(false);
                        } else {
                            if (m_LiveShowSceneBridge.getJumpSceneBridge().getIsMainBridge()) {
                                jLabelJumpSceneBridge.setBackground(LiveShowSceneBridge.s_ColorMainSceneBridge);
                            } else {
                                jLabelJumpSceneBridge.setBackground(LiveShowSceneBridge.s_ColorSceneBridge);
                            }
                            jLabelJumpSceneBridge.setOpaque(true);
                            jLabelJumpSceneBridge.setText(m_LiveShowSceneBridge.getJumpSceneBridge().getName());
                            if (m_LiveShowSceneBridge.getJumpActive()) {
                                jLabelJumpActive.setIcon(Icon_Jump);
                            } else {
                                jLabelJumpActive.setIcon(Icon_JumpDisabled);
                            }
                            jLabelJumpSceneBridge.setVisible(true);
                            jLabelJumpActive.setVisible(true);
                            if (m_LiveShowSceneBridge.getJumpPossible()) {
                                jLabelJumpActive.setEnabled(true);
                            } else {
                                jLabelJumpActive.setEnabled(false);
                            }
                        }
                        jLabelStopper.setVisible(true);
                        if (m_LiveShowSceneBridge.getStopAtStart()) {
                            jLabelStopper.setOpaque(true);
                        } else {
                            jLabelStopper.setOpaque(false);
                        }
                        if (m_IsActualScene) {
                            if (m_IsPlaying) {
                                jLabelPlay.setEnabled(false);
                            } else {
                                jLabelPlay.setEnabled(true);
                            }
                        } else {
                            jLabelPlay.setEnabled(true);
                        }
                        jLabelActive.setVisible(true);
                        if (m_LiveShowSceneBridge.getActive()) {
                            jLabelActive.setOpaque(true);
                        } else {
                            jLabelActive.setOpaque(false);
                            jLabelPlay.setEnabled(false);
                        }
                    }
                    if (m_ParentPanel != null) {
                        if (m_LiveShowSceneBridge != null) {
                            boolActive = this.checkActive();
                            if (m_LiveShowSceneBridge != null) {
                                if (m_LiveShowSceneBridge.getIsMainBridge()) {
                                    if (boolActive) {
                                        jLabelSceneBridge.setBackground(m_ColorMainSceneBridge);
                                        jLabelSceneBridge.setForeground(Color.white);
                                    } else {
                                        jLabelSceneBridge.setBackground(m_ColorMainSceneBridge_InActive);
                                        jLabelSceneBridge.setForeground(Color.GRAY);
                                        jLabelPlay.setEnabled(false);
                                    }
                                } else if (boolActive) {
                                    jLabelSceneBridge.setBackground(m_ColorSceneBridge);
                                    jLabelSceneBridge.setForeground(Color.white);
                                } else {
                                    jLabelSceneBridge.setBackground(m_ColorSceneBridge_InActive);
                                    jLabelSceneBridge.setForeground(Color.GRAY);
                                    jLabelPlay.setEnabled(false);
                                }
                            }
                        }
                        m_ParentPanel.revalidate();
                        m_ParentPanel.repaint();
                    }
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        };

        public SceneBook_PanelSceneBridge(LiveShowSceneBookPanel p_LiveShowSceneBookPanel, SceneBookColumn p_SceneBookColumn, LiveShowSceneBridge p_LiveShowSceneBridge) {
            this.initMembers();
            this.m_LiveShowSceneBookPanel = p_LiveShowSceneBookPanel;
            this.m_SceneBookColumn = p_SceneBookColumn;
            this.m_LiveShowSceneBridge = p_LiveShowSceneBridge;
            this.initComponents();
            if (this.m_LiveShowSceneBridge != null) {
                this.m_LiveShowSceneBridge.addLiveShowObjectListener(this);
                this.m_Play = this.m_SceneBookColumn.getLiveShowVIP().getPlay();
                this.m_Play.addPlayListener(this);
                if (this.m_Play.isRunning()) {
                    this.m_IsPlaying = true;
                }
            } else {
                this.m_Play = this.m_SceneBookColumn.getLiveShowVIP().getPlay();
                this.m_Play.addPlayListener(this);
                if (this.m_Play.isRunning()) {
                    this.m_IsPlaying = true;
                }
            }
            this.refresh();
            LiveShowTimer.selfReference().addLiveShowTimerListener_SceneBridge(this, this.m_SceneBookColumn.getLiveShowVIP(), p_LiveShowSceneBridge);
        }

        private void initMembers() {
            this.m_SelfReference = this;
            this.m_BoundsAbsolute = new Rectangle(0, 0, 0, 0);
            this.m_ColorStart = new Color(0, 255, 0, 100);
            this.m_ColorMainSceneBridge = new Color(255, 0, 0, 100);
            this.m_ColorMainSceneBridge_InActive = new Color(100, 0, 0, 50);
            this.m_ColorSceneBridge = new Color(200, 200, 200, 100);
            this.m_ColorSceneBridge_InActive = new Color(100, 100, 100, 50);
            this.m_ColorSceneBridgeStopper = new Color(150, 0, 0);
            this.m_ColorSceneBridgeActive = new Color(0, 150, 0);
            this.m_IsActualScene = false;
            this.m_IsPlaying = false;
            this.m_Play = null;
            this.m_TimeFramesRest = Long.MIN_VALUE;
        }

        private void initComponents() {
            this.Icon_Jump = new ImageIcon(this.getClass().getResource("/IconsPackage/Scenebridge_Jump.png"));
            this.Icon_JumpDisabled = new ImageIcon(this.getClass().getResource("/IconsPackage/Scenebridge_JumpDisabled.png"));
            this.createMouseAdapter_Delayed();
            GridBagConstraints o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridy = 1;
            o_GridBagConstraints.insets = new Insets(2, 2, 2, 2);
            this.m_ColorPlay = this.m_SceneBookColumn.getLiveShowVIP().getPlay().getColor();
            this.m_BorderActualScene = new LineBorder(this.m_ColorPlay, 2);
            this.m_BorderActualScene_Stopped = new LineBorder(Color.ORANGE, 2);
            this.jPanelSceneBridge = new JPanel();
            this.jPanelSceneBridge.setLayout(new GridBagLayout());
            this.jPanelSceneBridge.setBorder(null);
            this.jPanelSceneBridge.setBackground(COLOR_BACKGROUND_SCENEBRIDGEPANEL);
            this.jPanelSceneBridge.setOpaque(true);
            this.jTextPanePre = new JTextPane_RightClickToolTip();
            this.jTextPanePre.setFocusable(true);
            this.jTextPanePre.setBackground(COLOR_BACKGROUND_TEXTPANE);
            this.jTextPanePre.setBorder(null);
            this.jTextPanePre.setCursor(Cursor.getPredefinedCursor(2));
            this.jTextPanePre.setCaretColor(Color.WHITE);
            this.jTextPanePre.setToolTipText_RightClick(s_TOOLTIP_DIRECTION);
            this.jTextPanePre.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
            this.jTextPanePre.setEditorKit((EditorKit)LiveShowHTMLDocument.getHTMLEditorKit());
            try {
                this.searchDocument_Pre();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.jTextPanePre.addMouseListener((MouseListener)this.m_MouseAdapter_Delayed);
            this.jTextPanePost = new JTextPane_RightClickToolTip();
            this.jTextPanePost.setFocusable(true);
            this.jTextPanePost.setBackground(COLOR_BACKGROUND_SCENEBRIDGEPANEL);
            this.jTextPanePost.setBorder(null);
            this.jTextPanePost.setCursor(Cursor.getPredefinedCursor(12));
            this.jTextPanePost.setCaretColor(Color.WHITE);
            this.jTextPanePost.setToolTipText_RightClick(s_TOOLTIP_DIRECTION);
            this.jTextPanePost.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
            this.jTextPanePost.setEditorKit((EditorKit)LiveShowHTMLDocument.getHTMLEditorKit());
            try {
                this.searchDocument_Post();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.jTextPanePost.addMouseListener((MouseListener)this.m_MouseAdapter_Delayed);
            this.jLabelSceneBridge = new JLabel_RightClickToolTip();
            this.jLabelSceneBridge.setFont(s_DefaultFont);
            this.jLabelSceneBridgeTime = new JLabel();
            this.jLabelSceneBridgeTime.setHorizontalAlignment(0);
            this.jLabelSceneBridgeTime.setFont(s_DefaultFont);
            if (this.m_LiveShowSceneBridge == null) {
                this.jLabelSceneBridge.setBackground(this.m_ColorStart);
                this.jLabelSceneBridgeTime.setBackground(this.m_ColorStart);
            } else if (this.m_LiveShowSceneBridge.getIsMainBridge()) {
                this.jLabelSceneBridge.setBackground(this.m_ColorMainSceneBridge);
                this.jLabelSceneBridgeTime.setBackground(this.m_ColorMainSceneBridge);
            } else {
                this.jLabelSceneBridge.setBackground(this.m_ColorSceneBridge);
                this.jLabelSceneBridgeTime.setBackground(this.m_ColorSceneBridge);
            }
            this.jLabelSceneBridge.setOpaque(true);
            this.jLabelSceneBridge.setIcon((Icon)this.m_SceneBookColumn.getLiveShowVIP().getImageIcon());
            this.jLabelSceneBridge.setPreferredSize(new Dimension(100, 24));
            this.jLabelSceneBridge.setForeground(Color.white);
            this.jLabelSceneBridge.addMouseListener((MouseListener)this.m_MouseAdapter_Delayed);
            this.jLabelSceneBridge.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
            this.jLabelSceneBridgeTime.setOpaque(false);
            this.jLabelSceneBridgeTime.setPreferredSize(new Dimension(90, 24));
            this.jLabelSceneBridgeTime.setForeground(Color.white);
            this.jLabelJumpSceneBridge = new JLabel_RightClickToolTip();
            this.jLabelJumpSceneBridge.setVisible(false);
            this.jLabelJumpSceneBridge.setFont(s_DefaultLoopFont);
            this.jLabelJumpSceneBridge.setForeground(Color.white);
            this.jLabelJumpSceneBridge.setBorder(null);
            this.jLabelJumpSceneBridge.setOpaque(false);
            this.jLabelJumpSceneBridge.addMouseListener(this.m_MouseAdapter_Delayed);
            this.jLabelJumpSceneBridge.setToolTipText(s_TOOLTIP_JUMP);
            this.jLabelJumpSceneBridge.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
            this.jLabelJumpActive = new JLabel_RightClickToolTip();
            this.jLabelJumpActive.setVisible(false);
            this.jLabelJumpActive.setOpaque(false);
            this.jLabelJumpActive.setPreferredSize(new Dimension(20, 20));
            this.jLabelJumpActive.setBackground(Color.GREEN);
            this.jLabelJumpActive.setBorder(null);
            this.jLabelJumpActive.addMouseListener(this.m_MouseAdapter_Delayed);
            this.jLabelJumpActive.setToolTipText(s_TOOLTIP_JUMPACTIVE);
            this.jLabelJumpActive.setCursor(Cursor.getPredefinedCursor(12));
            this.jLabelJumpActive.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
            this.jLabelActive = new JLabel_RightClickToolTip();
            this.jLabelActive.setOpaque(false);
            this.jLabelActive.setPreferredSize(new Dimension(20, 20));
            this.jLabelActive.setBackground(this.m_ColorSceneBridgeActive);
            this.jLabelActive.setBorder(new EtchedBorder(1, Color.WHITE, Color.GREEN));
            this.jLabelActive.addMouseListener(this.m_MouseAdapter_Delayed);
            o_GridBagConstraints.gridx = 3;
            o_GridBagConstraints.fill = 0;
            this.jLabelActive.setToolTipText(s_TOOLTIP_ACTIVESCENE);
            this.jPanelSceneBridge.add((Component)this.jLabelActive, o_GridBagConstraints);
            this.jLabelActive.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
            this.jLabelActive.setCursor(Cursor.getPredefinedCursor(12));
            this.jLabelPlay = new JLabel_RightClickToolTip(s_IconPlay);
            this.jLabelPlay.setOpaque(false);
            this.jLabelPlay.setEnabled(true);
            this.jLabelPlay.setPreferredSize(new Dimension(32, 32));
            this.jLabelPlay.setBackground(this.m_ColorPlay);
            this.jLabelPlay.setFocusable(true);
            this.jLabelPlay.addMouseListener(this.m_MouseAdapter_Delayed);
            this.jLabelPlay.addMouseMotionListener(this.m_MouseAdapter_Delayed);
            o_GridBagConstraints.gridx = 0;
            o_GridBagConstraints.fill = 0;
            this.jPanelSceneBridge.add((Component)this.jLabelPlay, o_GridBagConstraints);
            this.jLabelPlay.setCursor(Cursor.getPredefinedCursor(12));
            this.jLabelPlay.setToolTipText(s_TOOLTIP_PLAY);
            this.jLabelPlay.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
            this.jLabelStopper = new JLabel_RightClickToolTip();
            this.jLabelStopper.setOpaque(false);
            this.jLabelStopper.setPreferredSize(new Dimension(20, 20));
            this.jLabelStopper.setBackground(this.m_ColorSceneBridgeStopper);
            this.jLabelStopper.setBorder(new EtchedBorder(1, Color.WHITE, Color.RED));
            this.jLabelStopper.addMouseListener(this.m_MouseAdapter_Delayed);
            o_GridBagConstraints.gridx = 2;
            o_GridBagConstraints.fill = 0;
            this.jPanelSceneBridge.add((Component)this.jLabelStopper, o_GridBagConstraints);
            this.jLabelStopper.setToolTipText(s_TOOLTIP_STOPPER);
            this.jLabelStopper.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
            this.jLabelStopper.setCursor(Cursor.getPredefinedCursor(12));
            o_GridBagConstraints.gridx = 1;
            o_GridBagConstraints.weightx = 1.0;
            o_GridBagConstraints.fill = 2;
            this.jPanelSceneBridge.add((Component)this.jLabelSceneBridge, o_GridBagConstraints);
            o_GridBagConstraints.gridx = 4;
            o_GridBagConstraints.weightx = 0.0;
            o_GridBagConstraints.anchor = 13;
            o_GridBagConstraints.fill = 2;
            this.jPanelSceneBridge.add((Component)this.jLabelSceneBridgeTime, o_GridBagConstraints);
            o_GridBagConstraints.anchor = 10;
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.gridx = 0;
            o_GridBagConstraints.weightx = 0.0;
            o_GridBagConstraints.fill = 0;
            this.jPanelSceneBridge.add((Component)this.jLabelJumpActive, o_GridBagConstraints);
            o_GridBagConstraints.gridx = 1;
            o_GridBagConstraints.gridwidth = 3;
            o_GridBagConstraints.weightx = 1.0;
            o_GridBagConstraints.fill = 2;
            this.jPanelSceneBridge.add((Component)this.jLabelJumpSceneBridge, o_GridBagConstraints);
        }

        public void closeProject() {
            this.closeSingle();
        }

        public void closeSingle() {
            LiveShowTimer.selfReference().removeLiveShowTimerListener_SceneBridge(this, this.m_SceneBookColumn.getLiveShowVIP(), this.m_LiveShowSceneBridge);
            EventQueueHandler.removeRunnable(this.m_RunnableRefresh);
            this.m_IsActualScene = false;
            this.m_IsPlaying = false;
            if (this.m_Play != null) {
                this.m_Play.removePlayListener(this);
                this.m_Play = null;
            }
            if (this.m_LiveShowSceneBridge != null) {
                this.m_LiveShowSceneBridge.removeLiveShowObjectListener(this);
            }
            this.jLabelSceneBridge.removeMouseListener((MouseListener)this.m_MouseAdapter_Delayed);
            this.jLabelSceneBridge.setComponentPopupMenu(null);
            this.jLabelPlay.removeMouseListener(this.m_MouseAdapter_Delayed);
            this.jLabelStopper.removeMouseListener(this.m_MouseAdapter_Delayed);
            this.jLabelActive.removeMouseListener(this.m_MouseAdapter_Delayed);
            this.m_DocumentPre.setOwner(null);
            this.m_DocumentPost.setOwner(null);
            this.setParentPanel(null);
            this.m_SelfReference = null;
        }

        public void setParentPanel(JPanel p_Panel) {
            if (p_Panel == this.m_ParentPanel) {
                return;
            }
            if (this.m_ParentPanel != null) {
                this.jPanelSceneBridge.setVisible(false);
                this.m_ParentPanel.remove(this.jPanelSceneBridge);
                this.jTextPanePre.setVisible(false);
                this.m_ParentPanel.remove((Component)this.jTextPanePre);
                this.jTextPanePost.setVisible(false);
                this.m_ParentPanel.remove((Component)this.jTextPanePost);
            }
            this.m_ParentPanel = p_Panel;
            if (this.m_ParentPanel != null) {
                GridBagConstraints o_GridBagConstraints = new GridBagConstraints();
                o_GridBagConstraints.insets = new Insets(3, 3, 3, 3);
                o_GridBagConstraints.gridx = this.m_SceneBookColumn.getColumnIndex();
                o_GridBagConstraints.weightx = 1.0;
                o_GridBagConstraints.fill = 2;
                o_GridBagConstraints.gridy = 0;
                this.jTextPanePre.setVisible(true);
                this.m_ParentPanel.add((Component)this.jTextPanePre, o_GridBagConstraints, 0);
                o_GridBagConstraints.gridy = 2;
                this.jTextPanePost.setVisible(true);
                this.m_ParentPanel.add((Component)this.jTextPanePost, o_GridBagConstraints, 0);
                o_GridBagConstraints.gridy = 1;
                this.jPanelSceneBridge.setVisible(true);
                this.m_ParentPanel.add(this.jPanelSceneBridge, o_GridBagConstraints, 0);
                this.refresh();
            }
        }

        public JPanel getParentPanel() {
            return this.m_ParentPanel;
        }

        public void setVisible(boolean p_Visible) {
            if (this.jPanelSceneBridge != null) {
                this.jPanelSceneBridge.setVisible(p_Visible);
            }
        }

        public JTextPane getTextPanePre() {
            return this.jTextPanePre;
        }

        public JTextPane getTextPanePost() {
            return this.jTextPanePost;
        }

        public Rectangle getBounds_Absolute() {
            this.m_BoundsAbsolute.setBounds(0, 0, 0, 0);
            if (this.m_ParentPanel == null) {
                return this.m_BoundsAbsolute;
            }
            SceneBookRow o_SceneBookRow = null;
            SceneBook_MainPanelSceneBridge o_SceneBook_MainPanelSceneBridge = null;
            boolean intPosY = false;
            if (this.m_ParentPanel instanceof SceneBook_MainPanelSceneBridge) {
                o_SceneBook_MainPanelSceneBridge = (SceneBook_MainPanelSceneBridge)this.m_ParentPanel;
                Rectangle o_BoundsParent = o_SceneBook_MainPanelSceneBridge.getBounds();
                this.m_BoundsAbsolute.setBounds(o_BoundsParent);
            } else if (this.m_ParentPanel instanceof SceneBookRow) {
                o_SceneBookRow = (SceneBookRow)this.m_ParentPanel;
                o_SceneBook_MainPanelSceneBridge = o_SceneBookRow.getMainSceneBridgePanel();
                if (o_SceneBook_MainPanelSceneBridge == null) {
                    return this.m_BoundsAbsolute;
                }
                Rectangle o_BoundsParent = o_SceneBook_MainPanelSceneBridge.getSceneBookRowBounds(o_SceneBookRow);
                this.m_BoundsAbsolute.setBounds(o_BoundsParent);
            }
            if (this.m_LiveShowSceneBookPanel.getSceneBookDocumentsVisible()) {
                if (this.m_LiveShowSceneBridge != null) {
                    this.m_BoundsAbsolute.y += this.jTextPanePre.getHeight();
                }
                this.m_BoundsAbsolute.height -= this.jTextPanePre.getHeight();
            }
            return this.m_BoundsAbsolute;
        }

        public boolean checkActive() {
            if (this.m_SceneBookColumn == null) {
                return false;
            }
            boolean boolActive = true;
            LiveShowSceneBridge o_LiveShowSceneBridge = this.m_LiveShowSceneBridge;
            if (o_LiveShowSceneBridge != null) {
                LiveShowSceneBridgeMain o_LiveShowSceneBridgeMain;
                SceneBook_MainPanelSceneBridge o_SceneBook_MainPanelSceneBridge;
                if (o_LiveShowSceneBridge.getIsMainBridge()) {
                    return o_LiveShowSceneBridge.getActive();
                }
                SceneBookItem o_SceneBookItem = this.m_SceneBookColumn.getLiveShowSceneBookPanel().getSceneBookItem(o_LiveShowSceneBridge);
                if (o_SceneBookItem != null && (o_SceneBook_MainPanelSceneBridge = o_SceneBookItem.getMainSceneBridgePanel()) != null && (o_LiveShowSceneBridgeMain = o_SceneBook_MainPanelSceneBridge.getLiveShowSceneBridgeMain()) != null && !o_LiveShowSceneBridgeMain.getActive()) {
                    boolActive = false;
                }
            }
            return boolActive;
        }

        public void refreshDocuments() {
            try {
                this.searchDocument_Pre();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.searchDocument_Post();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void refresh() {
            EventQueueHandler.invokeLater(this.m_RunnableRefresh);
        }

        public SceneBookColumn getSceneBookColumn() {
            return this.m_SceneBookColumn;
        }

        public LiveShowSceneBridge getLiveShowSceneBridge() {
            return this.m_LiveShowSceneBridge;
        }

        public LiveShowHTMLDocument searchDocument_Pre() {
            LiveShowHTMLDocument o_LiveShowEditorDocument = null;
            String stringDocumentID = LiveShowSceneBookPanel.calculateDocumentID(this.m_SceneBookColumn.getLiveShowVIP(), this.m_LiveShowSceneBridge, true);
            HashMap<String, LiveShowHTMLDocument> o_SceneBookDocuments = this.m_LiveShowSceneBookPanel.getLiveShowEditorDocuments();
            o_LiveShowEditorDocument = o_SceneBookDocuments.get(stringDocumentID);
            if (o_LiveShowEditorDocument == null) {
                o_LiveShowEditorDocument = new LiveShowHTMLDocument();
                o_LiveShowEditorDocument.addFontRule_White();
                o_SceneBookDocuments.put(stringDocumentID, o_LiveShowEditorDocument);
            }
            if (this.m_DocumentPre != null && this.m_DocumentPre != o_LiveShowEditorDocument) {
                this.m_DocumentPre.setOwner(null);
            }
            this.m_DocumentPre = o_LiveShowEditorDocument;
            try {
                this.jTextPanePre.setDocument((Document)this.m_DocumentPre);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_DocumentPre.setOwner((JTextComponent)this.jTextPanePre);
            return o_LiveShowEditorDocument;
        }

        public LiveShowHTMLDocument searchDocument_Post() {
            LiveShowHTMLDocument o_LiveShowEditorDocument = null;
            String stringDocumentID = LiveShowSceneBookPanel.calculateDocumentID(this.m_SceneBookColumn.getLiveShowVIP(), this.m_LiveShowSceneBridge, false);
            HashMap<String, LiveShowHTMLDocument> o_SceneBookDocuments = this.m_LiveShowSceneBookPanel.getLiveShowEditorDocuments();
            o_LiveShowEditorDocument = o_SceneBookDocuments.get(stringDocumentID);
            if (o_LiveShowEditorDocument == null) {
                o_LiveShowEditorDocument = new LiveShowHTMLDocument();
                o_LiveShowEditorDocument.addFontRule_White();
                o_SceneBookDocuments.put(stringDocumentID, o_LiveShowEditorDocument);
            }
            if (this.m_DocumentPost != null && this.m_DocumentPost != o_LiveShowEditorDocument) {
                this.m_DocumentPost.setOwner(null);
            }
            this.m_DocumentPost = o_LiveShowEditorDocument;
            try {
                this.jTextPanePost.setDocument((Document)this.m_DocumentPost);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_DocumentPost.setOwner((JTextComponent)this.jTextPanePost);
            return o_LiveShowEditorDocument;
        }

        public LiveShowHTMLDocument getLiveShowEditorDocument_Post() {
            return this.m_DocumentPost;
        }

        public void setActualScene(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge) {
            if (p_LiveShowVIP == null) {
                return;
            }
            if (this.m_SceneBookColumn.getLiveShowVIP() != p_LiveShowVIP) {
                return;
            }
            this.m_IsActualScene = this.m_LiveShowSceneBridge == p_LiveShowSceneBridge;
            this.refresh();
        }

        public void startUndoAction(int p_Action, String p_ActionString) {
            LiveShowUndo o_LiveShowUndo = null;
            LiveShowSceneBridge o_LiveShowSceneBridge = this.m_LiveShowSceneBridge;
            if (o_LiveShowSceneBridge == null) {
                return;
            }
            LiveShowVIP o_LiveShowVIP = o_LiveShowSceneBridge.getLiveShowVIP();
            if (o_LiveShowVIP == null) {
                return;
            }
            o_LiveShowUndo = o_LiveShowVIP.getLiveShowUndo();
            if (o_LiveShowUndo == null) {
                return;
            }
            if (o_LiveShowUndo.checkStartAction(p_Action)) {
                LiveShowVIP.LiveShowVIPStatus o_LiveShowVIPStatus = new LiveShowVIP.LiveShowVIPStatus();
                o_LiveShowVIPStatus.addLiveShowSceneBridge_Cloned(o_LiveShowSceneBridge);
                o_LiveShowUndo.startAction(p_Action, p_ActionString, o_LiveShowVIP, o_LiveShowVIPStatus);
            }
        }

        public void endUndoAction(int p_Action, boolean p_Success) {
            LiveShowUndo o_LiveShowUndo = null;
            LiveShowSceneBridge o_LiveShowSceneBridge = this.m_LiveShowSceneBridge;
            if (o_LiveShowSceneBridge == null) {
                return;
            }
            LiveShowVIP o_LiveShowVIP = o_LiveShowSceneBridge.getLiveShowVIP();
            if (o_LiveShowVIP == null) {
                return;
            }
            o_LiveShowUndo = o_LiveShowVIP.getLiveShowUndo();
            if (o_LiveShowUndo == null) {
                return;
            }
            if (o_LiveShowUndo.checkEndAction(p_Action)) {
                LiveShowVIP.LiveShowVIPStatus o_LiveShowVIPStatus = new LiveShowVIP.LiveShowVIPStatus();
                o_LiveShowVIPStatus.addLiveShowSceneBridge_Cloned(o_LiveShowSceneBridge);
                o_LiveShowUndo.endAction(p_Success, p_Action, o_LiveShowVIP, o_LiveShowVIPStatus);
            }
        }

        private void createMouseAdapter_Delayed() {
            this.m_MouseAdapter_Delayed = new MouseAdapter_Delayed(){
                private int m_LastX = 0;
                private int m_LastY = 0;
                private boolean m_DoAction;

                @Override
                public void mouseClicked_Delayed(MouseEvent e) {
                    if (e.getSource() == jTextPanePre) {
                        jTextPanePre.requestFocusInWindow();
                    }
                    if (e.getSource() == jTextPanePost) {
                        jTextPanePost.requestFocusInWindow();
                    }
                    if (e.getSource() instanceof JLabel) {
                        if ((e.getSource() == jLabelSceneBridge || e.getSource() == jLabelJumpSceneBridge) && e.getClickCount() > 1) {
                            if (m_LiveShowSceneBridge == null) {
                                return;
                            }
                            m_LiveShowSceneBridge.getLiveShowVIP().notifyLiveShowVIPListeners_ShowObjectSettings(m_LiveShowSceneBridge);
                            return;
                        }
                        if (e.getSource() == jLabelJumpActive) {
                            if (!jLabelJumpActive.isEnabled()) {
                                return;
                            }
                            if (m_LiveShowSceneBridge == null) {
                                return;
                            }
                            this.startUndoAction(112, LiveShowUndo.ACTION_OBJECTJUMP_STRING);
                            if (m_LiveShowSceneBridge.getJumpActive()) {
                                m_LiveShowSceneBridge.setJumpActive(false);
                            } else {
                                m_LiveShowSceneBridge.setJumpActive(true);
                            }
                            this.endUndoAction(112, true);
                            return;
                        }
                        if (e.getSource() == jLabelStopper) {
                            if (m_LiveShowSceneBridge == null) {
                                return;
                            }
                            this.startUndoAction(110, LiveShowUndo.ACTION_OBJECTSTOPPER_STRING);
                            if (m_LiveShowSceneBridge.getStopAtStart()) {
                                m_LiveShowSceneBridge.setStopAtStart(false);
                            } else {
                                m_LiveShowSceneBridge.setStopAtStart(true);
                            }
                            this.endUndoAction(110, true);
                            return;
                        }
                        if (e.getSource() == jLabelActive) {
                            if (m_LiveShowSceneBridge == null) {
                                return;
                            }
                            this.startUndoAction(111, LiveShowUndo.ACTION_OBJECTACTIVE_STRING);
                            if (m_LiveShowSceneBridge.getActive()) {
                                m_LiveShowSceneBridge.setActive(false);
                            } else {
                                m_LiveShowSceneBridge.setActive(true);
                            }
                            this.endUndoAction(111, true);
                            return;
                        }
                        return;
                    }
                }

                @Override
                public void mousePressed_Delayed(MouseEvent e) {
                    if (e.getButton() != 1) {
                        return;
                    }
                    this.m_LastX = e.getX();
                    this.m_LastY = e.getY();
                    this.m_DoAction = true;
                }

                @Override
                public void mouseDragged_Delayed(MouseEvent e) {
                    if (Math.abs(this.m_LastX - e.getX()) >= 32) {
                        this.m_DoAction = false;
                    }
                    if (Math.abs(this.m_LastY - e.getY()) >= 32) {
                        this.m_DoAction = false;
                    }
                }

                @Override
                public void mouseReleased_Delayed(MouseEvent e) {
                    if (e.getButton() != 1) {
                        return;
                    }
                    if (e.getSource() instanceof JLabel && e.getSource() == jLabelPlay) {
                        if (!this.m_DoAction) {
                            return;
                        }
                        if (m_LiveShowSceneBookPanel == null) {
                            return;
                        }
                        Play.PlaySynchronisizer o_PlaySynchronisizer = m_LiveShowSceneBookPanel.getPlaySynchronisizer();
                        if (o_PlaySynchronisizer == null) {
                            return;
                        }
                        o_PlaySynchronisizer.clearPlaysTriggerSceneBridge();
                        if (m_LiveShowSceneBridge == null) {
                            o_PlaySynchronisizer.actionPlayRewind();
                            o_PlaySynchronisizer.actionPlayStart();
                        } else {
                            LiveShowVIP o_LiveShowVIP;
                            boolean boolActive = true;
                            boolActive = !m_LiveShowSceneBridge.getActive() ? false : this.checkActive();
                            if (boolActive && (o_LiveShowVIP = m_LiveShowSceneBridge.getLiveShowVIP()) != null) {
                                o_LiveShowVIP.gotoSceneBridge(m_LiveShowSceneBridge, false);
                                if (m_LiveShowSceneBridge.getIsMainBridge()) {
                                    // empty if block
                                }
                                o_PlaySynchronisizer.actionStartPlaysSceneBridge();
                            }
                        }
                        return;
                    }
                }

                @Override
                public void mouseEntered_Delayed(MouseEvent e) {
                }

                @Override
                public void mouseExited_Delayed(MouseEvent e) {
                }
            };
        }

        @Override
        public void eventObjectParameterChanged(LiveShowObjectInterface p_LiveShowObjectInterface, LiveShowObjectDescription p_SoundObjectDescription) {
            this.m_LiveShowSceneBookPanel.eventChangedSceneBook_PanelSceneBridge(this);
        }

        @Override
        public void eventObjectVolumeChanged(LiveShowObjectInterface p_LiveShowObjectInterface, float p_Volume) {
        }

        @Override
        public void eventObjectAdditionalChanged(LiveShowObjectInterface p_LiveShowObjectInterface, LiveShowObjectDescription p_LiveShowObjectDescription) {
        }

        @Override
        public void eventObjectClosed(LiveShowObjectInterface p_LiveShowObjectInterface) {
        }

        @Override
        public void eventObjectSelection(LiveShowObjectInterface p_LiveShowObjectInterface, boolean p_IsSelected, boolean p_Added) {
        }

        @Override
        public void eventPlayStart(Play p_Play) {
            this.m_IsPlaying = true;
            this.refresh();
        }

        @Override
        public void eventPlayStop(Play p_Play) {
            this.m_IsPlaying = false;
            this.refresh();
        }

        @Override
        public void eventPlayPause(Play p_Play) {
            this.m_IsPlaying = false;
            this.refresh();
        }

        @Override
        public void eventPlayRewind(Play p_Play) {
        }

        @Override
        public void eventPlayFastForward(Play p_Play) {
        }

        @Override
        public void eventPlayFadePossibility(Play p_Play, boolean p_FadeInPossible, boolean p_FadeOutPossible, double p_FadeProgress) {
        }

        @Override
        public void eventPlayFadedIn(Play p_Play, boolean p_FadedIn, double p_FadeProgress) {
        }

        @Override
        public long eventPlayCheckRead(Play p_Play, long p_FrameStart, long p_FramesToRead) {
            return p_FramesToRead;
        }

        @Override
        public void eventEditModeOn(Play p_Play, boolean p_EditModeOn) {
        }

        @Override
        public void eventEditCursorSet(Play p_Play, long p_PlayCursor) {
        }

        @Override
        public void eventPlayCursorSet(Play p_Play, long p_PlayCursor) {
        }

        @Override
        public void eventPlayCursor(Play p_Play, long p_OldPlayCursor, long p_PlayCursor) {
        }

        @Override
        public void eventPlayClosing(Play p_Play) {
        }

        @Override
        public void eventPlayError(Play p_Play, Exception p_Exception, String p_Remark) {
        }

        @Override
        public void eventPlayTimelineEnd(Play p_Play) {
        }

        @Override
        public void eventSceneBridgeTime(LiveShowTimer p_LiveShowTimer, LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge, long p_TimeFramesRest, String p_TimeString, boolean p_TimeRecorded, Color p_ColorForeground) {
            if (p_LiveShowSceneBridge != this.m_LiveShowSceneBridge || p_LiveShowVIP != this.m_SceneBookColumn.getLiveShowVIP()) {
                return;
            }
            if (p_TimeFramesRest == this.m_TimeFramesRest && p_ColorForeground.equals(this.jLabelSceneBridgeTime.getForeground())) {
                return;
            }
            this.m_TimeFramesRest = p_TimeFramesRest;
            this.jLabelSceneBridgeTime.setForeground(p_ColorForeground);
            this.jLabelSceneBridgeTime.setText(p_TimeString);
            this.jLabelSceneBridgeTime.repaint();
        }
    }

    public static class SceneBookItem
    implements LiveShowObjectListener {
        private static ArrayList<SceneBookItem> s_SceneBookItems = new ArrayList();
        private LiveShowSceneBookPanel m_LiveShowSceneBookPanel;
        private SceneBookColumn m_SceneBookColumn;
        private SceneBook_MainPanelSceneBridge m_MainSceneBridgePanel;
        private SceneBookRow m_SceneBookRow;
        private LiveShowSceneBridge m_LiveShowSceneBridge;
        private SceneBook_PanelSceneBridge m_SceneBook_PanelSceneBridge;

        public SceneBookItem(LiveShowSceneBookPanel p_LiveShowSceneBookPanel, SceneBookColumn p_SceneBookColumn, LiveShowSceneBridge p_LiveShowSceneBridge) {
            this.initMembers();
            this.m_LiveShowSceneBookPanel = p_LiveShowSceneBookPanel;
            this.m_SceneBookColumn = p_SceneBookColumn;
            this.m_LiveShowSceneBridge = p_LiveShowSceneBridge;
            this.initComponents();
            this.m_LiveShowSceneBridge.addLiveShowObjectListener(this);
            s_SceneBookItems.add(this);
        }

        private void initMembers() {
            this.m_MainSceneBridgePanel = null;
        }

        private void initComponents() {
            this.m_SceneBook_PanelSceneBridge = new SceneBook_PanelSceneBridge(this.m_LiveShowSceneBookPanel, this.m_SceneBookColumn, this.m_LiveShowSceneBridge);
        }

        public void closeSingle() {
            if (s_SceneBookItems != null) {
                s_SceneBookItems.remove(this);
            }
            if (this.m_SceneBook_PanelSceneBridge != null) {
                this.m_SceneBook_PanelSceneBridge.closeSingle();
            }
            if (this.m_SceneBookRow != null) {
                this.m_SceneBookRow.removeSceneBookItem(this);
                this.m_SceneBookRow = null;
            }
            if (this.m_LiveShowSceneBridge != null) {
                this.m_LiveShowSceneBridge.removeLiveShowObjectListener(this);
                this.m_LiveShowSceneBridge = null;
            }
        }

        public void closeProject() {
            if (s_SceneBookItems != null) {
                s_SceneBookItems.remove(this);
            }
            if (this.m_SceneBook_PanelSceneBridge != null) {
                this.m_SceneBook_PanelSceneBridge.closeProject();
            }
            this.m_SceneBookRow = null;
            if (this.m_LiveShowSceneBridge != null) {
                this.m_LiveShowSceneBridge.removeLiveShowObjectListener(this);
                this.m_LiveShowSceneBridge = null;
            }
        }

        public void setVisible(boolean p_Visisble) {
            if (this.m_SceneBook_PanelSceneBridge == null) {
                return;
            }
            this.m_SceneBook_PanelSceneBridge.setVisible(p_Visisble);
        }

        public void setMainSceneBridgePanel(SceneBook_MainPanelSceneBridge p_MainSceneBridgePanel) {
            this.m_MainSceneBridgePanel = p_MainSceneBridgePanel;
        }

        public SceneBook_MainPanelSceneBridge getMainSceneBridgePanel() {
            return this.m_MainSceneBridgePanel;
        }

        public void setSceneBookRow(SceneBookRow p_SceneBookRow) {
            this.m_SceneBookRow = p_SceneBookRow;
            this.m_SceneBook_PanelSceneBridge.setParentPanel(this.m_SceneBookRow);
        }

        public SceneBookRow getSceneBookRow() {
            return this.m_SceneBookRow;
        }

        public SceneBookColumn getSceneBookColumn() {
            return this.m_SceneBookColumn;
        }

        public LiveShowSceneBridge getLiveShowSceneBridge() {
            return this.m_LiveShowSceneBridge;
        }

        public SceneBook_PanelSceneBridge getSceneBook_PanelSceneBridge() {
            return this.m_SceneBook_PanelSceneBridge;
        }

        public void setActualScene(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge) {
            if (p_LiveShowVIP == null) {
                return;
            }
            this.m_SceneBook_PanelSceneBridge.setActualScene(p_LiveShowVIP, p_LiveShowSceneBridge);
        }

        public long getFrameStart() {
            if (this.m_LiveShowSceneBridge == null) {
                return -1L;
            }
            return this.m_LiveShowSceneBridge.getFrameStart();
        }

        public static void resortSceneBookItems() {
            for (int intItem = 0; intItem < s_SceneBookItems.size(); ++intItem) {
                SceneBookItem o_SceneBookItem = s_SceneBookItems.get(intItem);
                if (o_SceneBookItem == null) continue;
                o_SceneBookItem.resortSceneBookItem();
            }
        }

        public void resortSceneBookItem() {
            SceneBook_MainPanelSceneBridge o_MainPanelSceneBridge = this.m_MainSceneBridgePanel;
            SceneBook_MainPanelSceneBridge o_MainPanelSceneBridgeFound = this.m_LiveShowSceneBookPanel.findMainSceneBridgePanelPrior(this.getFrameStart(), null);
            if (o_MainPanelSceneBridgeFound != o_MainPanelSceneBridge) {
                if (o_MainPanelSceneBridge != null) {
                    o_MainPanelSceneBridge.removeSceneBookItem(this);
                }
                if (o_MainPanelSceneBridgeFound != null) {
                    o_MainPanelSceneBridgeFound.addSceneBookItem(this);
                }
            } else {
                if (o_MainPanelSceneBridge == null) {
                    return;
                }
                o_MainPanelSceneBridge.resortSceneBookItem(this);
            }
        }

        @Override
        public void eventObjectParameterChanged(LiveShowObjectInterface p_LiveShowObjectInterface, LiveShowObjectDescription p_SoundObjectDescription) {
            this.m_LiveShowSceneBookPanel.eventChengedSceneBookItem(this);
        }

        @Override
        public void eventObjectVolumeChanged(LiveShowObjectInterface p_LiveShowObjectInterface, float p_Volume) {
        }

        @Override
        public void eventObjectAdditionalChanged(LiveShowObjectInterface p_LiveShowObjectInterface, LiveShowObjectDescription p_LiveShowObjectDescription) {
        }

        @Override
        public void eventObjectClosed(LiveShowObjectInterface p_LiveShowObjectInterface) {
        }

        @Override
        public void eventObjectSelection(LiveShowObjectInterface p_LiveShowObjectInterface, boolean p_IsSelected, boolean p_Added) {
        }
    }

    public static class SceneBookRow
    extends JPanel {
        private static ArrayList<SceneBookRow> s_SceneBookRows = new ArrayList();
        private static int s_SceneBookRows_MaxSize = 500;
        private LiveShowSceneBookPanel m_LiveShowSceneBookPanel;
        private SceneBook_MainPanelSceneBridge m_MainSceneBridgePanel;
        private ArrayList<SceneBookItem> m_SceneBookItems;
        private ArrayList<JLabel> m_LabelsFill;
        private GridBagConstraints m_GridBagConstraints;
        private LineBorder m_Border;
        private Runnable m_RunnableRepaint;

        public SceneBookRow(SceneBook_MainPanelSceneBridge p_MainSceneBridgePanel) {
            this.initMembers();
            this.m_MainSceneBridgePanel = p_MainSceneBridgePanel;
            this.m_LiveShowSceneBookPanel = this.m_MainSceneBridgePanel.getLiveShowSceneBookPanel();
            this.initComponents();
        }

        private void initMembers() {
            this.m_SceneBookItems = new ArrayList();
            this.m_LabelsFill = new ArrayList();
            this.m_RunnableRepaint = new Runnable(){

                @Override
                public void run() {
                    this.revalidate();
                    this.repaint();
                }
            };
        }

        private void initComponents() {
            this.setLayout(new GridBagLayout());
            this.m_GridBagConstraints = new GridBagConstraints();
            this.m_GridBagConstraints.gridx = 0;
            this.m_GridBagConstraints.weightx = 1.0;
            this.m_GridBagConstraints.gridwidth = 1;
            this.m_GridBagConstraints.fill = 2;
            this.m_GridBagConstraints.insets = new Insets(3, 3, 3, 3);
            this.setBackground(COLOR_BACKGROUND_SCENEBRIDGEPANEL);
            this.setOpaque(true);
            this.setBorder(null);
        }

        public void closeSingle() {
            if (this.m_SceneBookItems != null) {
                int intItemCount = this.m_SceneBookItems.size();
                for (int intItem = intItemCount - 1; intItem >= 0; --intItem) {
                    SceneBookItem o_SceneBookItem = this.getSceneBookItem(intItem);
                    if (o_SceneBookItem == null) continue;
                    this.m_SceneBookItems.remove(intItem);
                }
            }
            if (this.m_MainSceneBridgePanel != null) {
                this.m_MainSceneBridgePanel.removeSceneBookRow(this);
                this.m_MainSceneBridgePanel = null;
            }
        }

        public void closeProject() {
            if (this.m_SceneBookItems != null) {
                int intItemCount = this.m_SceneBookItems.size();
                for (int intItem = intItemCount - 1; intItem >= 0; --intItem) {
                    SceneBookItem o_SceneBookItem = this.getSceneBookItem(intItem);
                    if (o_SceneBookItem == null) continue;
                    this.m_SceneBookItems.remove(intItem);
                    o_SceneBookItem.closeProject();
                }
            }
            this.m_MainSceneBridgePanel = null;
            this.m_LiveShowSceneBookPanel = null;
        }

        public static SceneBookRow getEmptySceneBookRow(SceneBook_MainPanelSceneBridge p_MainSceneBridgePanel) {
            SceneBookRow o_SceneBookRow = null;
            if (s_SceneBookRows.size() > 0) {
                o_SceneBookRow = s_SceneBookRows.get(0);
                s_SceneBookRows.remove(0);
                o_SceneBookRow.setMainSceneBridgePanel(p_MainSceneBridgePanel);
            }
            if (o_SceneBookRow == null) {
                o_SceneBookRow = new SceneBookRow(p_MainSceneBridgePanel);
            }
            return o_SceneBookRow;
        }

        public static void addEmptySceneBookRow(SceneBookRow p_SceneBookRow) {
            if (s_SceneBookRows.size() >= s_SceneBookRows_MaxSize) {
                return;
            }
            s_SceneBookRows.add(p_SceneBookRow);
        }

        public void refresh() {
            if (this.m_SceneBookItems != null) {
                for (int intItem = 0; intItem < this.m_SceneBookItems.size(); ++intItem) {
                    SceneBookColumn o_SceneBookColumn;
                    SceneBookItem o_SceneBookItem = this.m_SceneBookItems.get(intItem);
                    if (o_SceneBookItem == null || (o_SceneBookColumn = o_SceneBookItem.getSceneBookColumn()) == null) continue;
                    if (o_SceneBookColumn.getVIPActive()) {
                        o_SceneBookItem.setVisible(true);
                    } else {
                        o_SceneBookItem.setVisible(false);
                    }
                    SceneBook_PanelSceneBridge o_SceneBook_PanelSceneBridge = o_SceneBookItem.getSceneBook_PanelSceneBridge();
                    if (o_SceneBook_PanelSceneBridge == null) continue;
                    o_SceneBook_PanelSceneBridge.refresh();
                }
            }
        }

        public void setMainSceneBridgePanel(SceneBook_MainPanelSceneBridge p_MainSceneBridgePanel) {
            this.m_MainSceneBridgePanel = p_MainSceneBridgePanel;
            if (this.m_MainSceneBridgePanel != null) {
                this.m_LiveShowSceneBookPanel = p_MainSceneBridgePanel.getLiveShowSceneBookPanel();
            }
        }

        public SceneBook_MainPanelSceneBridge getMainSceneBridgePanel() {
            return this.m_MainSceneBridgePanel;
        }

        public GridBagConstraints getGridBagConstraints() {
            return this.m_GridBagConstraints;
        }

        public LiveShowSceneBookPanel getLiveShowSceneBookPanel() {
            return this.m_LiveShowSceneBookPanel;
        }

        public void addSceneBookColumn(SceneBookColumn p_SceneBookColumn) {
            this.checkFiller();
        }

        public void removeSceneBookColumn(SceneBookColumn p_SceneBookColumn) {
            this.checkFiller();
        }

        public void checkFiller() {
            LiveShowSceneBookPanel o_LiveShowSceneBookPanel = this.m_LiveShowSceneBookPanel;
            if (o_LiveShowSceneBookPanel == null) {
                return;
            }
            int intColumnCount = o_LiveShowSceneBookPanel.getSceneBookColumnCount();
            if (this.m_LabelsFill.size() != intColumnCount) {
                if (this.m_LabelsFill.size() > intColumnCount) {
                    for (int intColumn = this.m_LabelsFill.size() - 1; intColumn >= intColumnCount; --intColumn) {
                        JLabel o_Label = this.m_LabelsFill.get(intColumn);
                        this.m_LabelsFill.remove(intColumn);
                        if (o_Label == null) continue;
                        o_Label.setVisible(false);
                        this.remove(o_Label);
                    }
                    return;
                }
                if (this.m_LabelsFill.size() < intColumnCount) {
                    GridBagConstraints o_GridBagConstraints = new GridBagConstraints();
                    o_GridBagConstraints.gridy = 0;
                    o_GridBagConstraints.gridheight = 3;
                    o_GridBagConstraints.gridwidth = 1;
                    o_GridBagConstraints.weightx = 1.0;
                    o_GridBagConstraints.fill = 1;
                    o_GridBagConstraints.insets = new Insets(3, 3, 3, 3);
                    int intColumn = this.m_LabelsFill.size();
                    while (intColumn < intColumnCount) {
                        JLabel o_Label = new JLabel();
                        o_Label.setOpaque(false);
                        o_Label.setBorder(null);
                        o_Label.setVisible(true);
                        o_GridBagConstraints.gridx = intColumn++;
                        this.add((Component)o_Label, o_GridBagConstraints);
                    }
                }
            }
        }

        public void addSceneBookItem(SceneBookItem p_SceneBookItem) {
            this.checkFiller();
            if (p_SceneBookItem == null) {
                return;
            }
            if (this.m_SceneBookItems.contains(p_SceneBookItem)) {
                return;
            }
            SceneBookRow o_SceneBookRow = p_SceneBookItem.getSceneBookRow();
            if (o_SceneBookRow != null) {
                o_SceneBookRow.removeSceneBookItem(p_SceneBookItem);
            }
            p_SceneBookItem.setSceneBookRow(this);
            this.m_SceneBookItems.add(p_SceneBookItem);
            this.refresh();
            EventQueueHandler.invokeLater(this.m_RunnableRepaint);
        }

        public void removeSceneBookItem(SceneBookItem p_SceneBookItem) {
            if (p_SceneBookItem == null) {
                return;
            }
            boolean boolRemoved = this.m_SceneBookItems.remove(p_SceneBookItem);
            if (!boolRemoved) {
                return;
            }
            this.refresh();
            EventQueueHandler.invokeLater(this.m_RunnableRepaint);
            if (this.m_SceneBookItems.size() <= 0) {
                this.m_MainSceneBridgePanel.removeSceneBookRow(this);
            }
        }

        public boolean contains(SceneBookItem p_SceneBookItem) {
            return this.m_SceneBookItems.contains(p_SceneBookItem);
        }

        public int getSceneBookItemCount() {
            return this.m_SceneBookItems.size();
        }

        public SceneBookItem getSceneBookItem(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            if (p_Index >= this.m_SceneBookItems.size()) {
                return null;
            }
            return this.m_SceneBookItems.get(p_Index);
        }

        public SceneBookItem getSceneBookItem(LiveShowSceneBridge p_LiveShowSceneBridge) {
            if (p_LiveShowSceneBridge == null) {
                return null;
            }
            for (int intItem = 0; intItem < this.m_SceneBookItems.size(); ++intItem) {
                SceneBookItem o_SceneBookItem = this.m_SceneBookItems.get(intItem);
                if (o_SceneBookItem == null || o_SceneBookItem.getLiveShowSceneBridge() != p_LiveShowSceneBridge) continue;
                return o_SceneBookItem;
            }
            return null;
        }

        public void setActualScene(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge) {
            for (int intItem = 0; intItem < this.m_SceneBookItems.size(); ++intItem) {
                SceneBookItem o_SceneBookItem = this.m_SceneBookItems.get(intItem);
                if (o_SceneBookItem == null) continue;
                o_SceneBookItem.setActualScene(p_LiveShowVIP, p_LiveShowSceneBridge);
            }
        }

        public long getFrameStart() {
            if (this.m_SceneBookItems.size() <= 0) {
                return -1L;
            }
            SceneBookItem o_SceneBookItem = this.m_SceneBookItems.get(0);
            LiveShowSceneBridge o_LiveShowSceneBridge = o_SceneBookItem.getLiveShowSceneBridge();
            return o_LiveShowSceneBridge.getFrameStart();
        }
    }

    public static class SceneBook_MainPanelSceneBridge
    extends JPanel
    implements LiveShowObjectListener {
        private LiveShowSceneBridgeMain m_LiveShowSceneBridgeMain;
        private LiveShowSceneBookPanel m_LiveShowSceneBookPanel;
        private ArrayList<SceneBookRow> m_SceneBookRows;
        private ArrayList<SceneBook_PanelSceneBridge> m_SceneBook_PanelSceneBridges;
        private JPanel jPanelRows;
        private LineBorder m_Border;
        private GridBagLayout m_GridBagLayout;
        private GridBagConstraints m_GridBagConstraints;
        private GridBagLayout m_GridBagLayoutPanelRows;
        private Rectangle m_Bounds;
        private Rectangle m_Bounds_PanelRows;
        private Rectangle m_Bounds_SceneBookRow;
        private SceneBook_MainPanelSceneBridge m_Selfreference;
        private Runnable m_RunnableRepaint = new Runnable(){

            @Override
            public void run() {
                this.revalidate();
                this.repaint();
            }
        };
        private Runnable m_RunnableRepaint_SceneBookRows = new Runnable(){

            @Override
            public void run() {
                jPanelRows.revalidate();
                jPanelRows.repaint();
            }
        };

        public SceneBook_MainPanelSceneBridge(LiveShowSceneBookPanel p_LiveShowSceneBookPanel, LiveShowSceneBridgeMain p_LiveShowSceneBridgeMain) {
            this.initMembers();
            this.m_LiveShowSceneBridgeMain = p_LiveShowSceneBridgeMain;
            this.m_LiveShowSceneBookPanel = p_LiveShowSceneBookPanel;
            this.initComponents();
            if (this.m_LiveShowSceneBridgeMain != null) {
                this.m_LiveShowSceneBridgeMain.addLiveShowObjectListener(this);
            }
        }

        private void initMembers() {
            this.m_SceneBookRows = new ArrayList();
            this.m_SceneBook_PanelSceneBridges = new ArrayList();
            this.m_Selfreference = this;
        }

        private void initComponents() {
            this.m_GridBagLayout = new GridBagLayout();
            this.setLayout(this.m_GridBagLayout);
            this.m_GridBagConstraints = new GridBagConstraints();
            this.m_GridBagConstraints.gridx = 0;
            this.m_GridBagConstraints.gridy = 0;
            this.m_GridBagConstraints.weightx = 1.0;
            this.m_GridBagConstraints.weighty = 0.0;
            this.m_GridBagConstraints.fill = 2;
            this.m_GridBagConstraints.insets = new Insets(3, 3, 3, 3);
            this.setBackground(COLOR_BACKGROUND_SCENEBRIDGEPANEL);
            this.setOpaque(true);
            this.m_Border = new LineBorder(Color.BLACK, 1);
            this.setBorder(this.m_Border);
            GridBagConstraints o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 0;
            o_GridBagConstraints.gridwidth = this.m_LiveShowSceneBookPanel.getSceneBookColumnCount();
            o_GridBagConstraints.weightx = 1.0;
            o_GridBagConstraints.fill = 2;
            o_GridBagConstraints.insets = new Insets(1, 1, 1, 1);
            this.jPanelRows = new JPanel();
            this.m_GridBagLayoutPanelRows = new GridBagLayout();
            this.jPanelRows.setLayout(this.m_GridBagLayoutPanelRows);
            this.jPanelRows.setBackground(Color.WHITE);
            this.jPanelRows.setOpaque(false);
            this.jPanelRows.setVisible(true);
            o_GridBagConstraints.gridy = 3;
            o_GridBagConstraints.insets = new Insets(3, 10, 3, 3);
            this.add((Component)this.jPanelRows, o_GridBagConstraints);
            for (int intColumn = 0; intColumn < this.m_LiveShowSceneBookPanel.getSceneBookColumnCount(); ++intColumn) {
                SceneBookColumn o_SceneBookColumn = this.m_LiveShowSceneBookPanel.getSceneBookColumn(intColumn);
                this.addSceneBookColumn(o_SceneBookColumn);
            }
        }

        public void closeSingle() {
            if (this.m_LiveShowSceneBridgeMain != null) {
                this.m_LiveShowSceneBridgeMain.removeLiveShowObjectListener(this);
            }
            if (this.m_SceneBook_PanelSceneBridges != null) {
                int intPanelsCount = this.m_SceneBook_PanelSceneBridges.size();
                for (int intPanel = intPanelsCount - 1; intPanel >= 0; --intPanel) {
                    SceneBook_PanelSceneBridge o_SceneBook_PanelSceneBridge = this.m_SceneBook_PanelSceneBridges.get(intPanel);
                    if (o_SceneBook_PanelSceneBridge == null) continue;
                    this.removeLiveShowSceneBridge_Main(o_SceneBook_PanelSceneBridge.getLiveShowSceneBridge());
                    o_SceneBook_PanelSceneBridge.closeSingle();
                }
                this.m_SceneBook_PanelSceneBridges.clear();
            }
            while (this.m_SceneBookRows.size() > 0) {
                SceneBookRow o_SceneBookRow = this.m_SceneBookRows.get(0);
                this.removeSceneBookRow(o_SceneBookRow);
                o_SceneBookRow.closeSingle();
            }
            this.m_Selfreference = null;
        }

        public void closeProject() {
            if (this.m_LiveShowSceneBridgeMain != null) {
                this.m_LiveShowSceneBridgeMain.removeLiveShowObjectListener(this);
            }
            if (this.m_SceneBook_PanelSceneBridges != null) {
                int intPanelsCount = this.m_SceneBook_PanelSceneBridges.size();
                for (int intPanel = intPanelsCount - 1; intPanel >= 0; --intPanel) {
                    SceneBook_PanelSceneBridge o_SceneBook_PanelSceneBridge = this.m_SceneBook_PanelSceneBridges.get(intPanel);
                    if (o_SceneBook_PanelSceneBridge == null) continue;
                    this.removeLiveShowSceneBridge_Main(o_SceneBook_PanelSceneBridge.getLiveShowSceneBridge());
                    o_SceneBook_PanelSceneBridge.closeProject();
                }
                this.m_SceneBook_PanelSceneBridges.clear();
            }
            while (this.m_SceneBookRows.size() > 0) {
                SceneBookRow o_SceneBookRow = this.m_SceneBookRows.get(0);
                this.m_SceneBookRows.remove(0);
                o_SceneBookRow.setVisible(false);
                this.jPanelRows.remove(o_SceneBookRow);
                SceneBookRow.addEmptySceneBookRow(o_SceneBookRow);
                o_SceneBookRow.closeProject();
            }
            this.m_Selfreference = null;
        }

        public void refresh() {
            if (this.m_SceneBook_PanelSceneBridges != null) {
                for (int intBridgePanel = 0; intBridgePanel < this.m_SceneBook_PanelSceneBridges.size(); ++intBridgePanel) {
                    SceneBook_PanelSceneBridge o_SceneBook_PanelSceneBridge = this.m_SceneBook_PanelSceneBridges.get(intBridgePanel);
                    if (o_SceneBook_PanelSceneBridge == null || o_SceneBook_PanelSceneBridge.getSceneBookColumn() == null) continue;
                    if (o_SceneBook_PanelSceneBridge.getSceneBookColumn().getVIPActive()) {
                        o_SceneBook_PanelSceneBridge.setVisible(true);
                        o_SceneBook_PanelSceneBridge.refresh();
                        continue;
                    }
                    o_SceneBook_PanelSceneBridge.setVisible(false);
                    o_SceneBook_PanelSceneBridge.refresh();
                }
            }
            if (this.m_SceneBookRows != null) {
                for (int intRow = 0; intRow < this.m_SceneBookRows.size(); ++intRow) {
                    SceneBookRow o_SceneBookRow = this.m_SceneBookRows.get(intRow);
                    if (o_SceneBookRow == null) continue;
                    o_SceneBookRow.refresh();
                }
            }
        }

        public void addSceneBookColumn(SceneBookColumn p_SceneBookColumn) {
            if (p_SceneBookColumn == null) {
                return;
            }
            if (p_SceneBookColumn.getColumnIndex() >= this.m_SceneBook_PanelSceneBridges.size()) {
                for (int intColumn = this.m_SceneBook_PanelSceneBridges.size(); intColumn <= p_SceneBookColumn.getColumnIndex(); ++intColumn) {
                    this.m_SceneBook_PanelSceneBridges.add(null);
                }
            }
            GridBagConstraints o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 0;
            o_GridBagConstraints.gridy = 3;
            o_GridBagConstraints.gridwidth = this.m_LiveShowSceneBookPanel.getSceneBookColumnCount();
            o_GridBagConstraints.weightx = 1.0;
            o_GridBagConstraints.fill = 2;
            o_GridBagConstraints.insets = new Insets(1, 1, 1, 1);
            this.m_GridBagLayout.setConstraints(this.jPanelRows, o_GridBagConstraints);
            if (this.m_LiveShowSceneBridgeMain == null) {
                SceneBook_PanelSceneBridge o_SceneBook_PanelSceneBridge = new SceneBook_PanelSceneBridge(this.m_LiveShowSceneBookPanel, p_SceneBookColumn, null);
                o_SceneBook_PanelSceneBridge.setParentPanel(this);
                this.m_SceneBook_PanelSceneBridges.set(p_SceneBookColumn.getColumnIndex(), o_SceneBook_PanelSceneBridge);
            }
            for (int intRow = 0; intRow < this.m_SceneBookRows.size(); ++intRow) {
                SceneBookRow o_SceneBookRow = this.m_SceneBookRows.get(intRow);
                if (o_SceneBookRow == null) continue;
                o_SceneBookRow.addSceneBookColumn(p_SceneBookColumn);
            }
            if (this.m_LiveShowSceneBookPanel != null) {
                this.m_LiveShowSceneBookPanel.eventRefreshMainPanelSceneBridge(this);
            }
            EventQueueHandler.invokeLater(this.m_RunnableRepaint);
        }

        public void removeSceneBookColumn(SceneBookColumn p_SceneBookColumn) {
            SceneBookItem o_SceneBookItem;
            if (p_SceneBookColumn == null) {
                return;
            }
            GridBagConstraints o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 0;
            o_GridBagConstraints.gridy = 3;
            o_GridBagConstraints.gridwidth = this.m_LiveShowSceneBookPanel.getSceneBookColumnCount();
            o_GridBagConstraints.weightx = 1.0;
            o_GridBagConstraints.fill = 2;
            o_GridBagConstraints.insets = new Insets(1, 1, 1, 1);
            this.m_GridBagLayout.setConstraints(this.jPanelRows, o_GridBagConstraints);
            SceneBook_PanelSceneBridge o_SceneBook_PanelSceneBridge = this.m_SceneBook_PanelSceneBridges.get(p_SceneBookColumn.getColumnIndex());
            if (o_SceneBook_PanelSceneBridge != null) {
                o_SceneBook_PanelSceneBridge.setParentPanel(null);
                o_SceneBook_PanelSceneBridge.closeSingle();
            }
            this.m_SceneBook_PanelSceneBridges.set(p_SceneBookColumn.getColumnIndex(), null);
            ArrayList<SceneBookItem> o_SceneBookItems = new ArrayList<SceneBookItem>();
            for (int intRow = 0; intRow < this.m_SceneBookRows.size(); ++intRow) {
                SceneBookRow o_SceneBookRow = this.m_SceneBookRows.get(intRow);
                if (o_SceneBookRow == null || (o_SceneBookItem = o_SceneBookRow.getSceneBookItem(p_SceneBookColumn.getColumnIndex())) == null) continue;
                o_SceneBookRow.removeSceneBookColumn(p_SceneBookColumn);
                o_SceneBookItems.add(o_SceneBookItem);
            }
            for (int intSceneBookItem = o_SceneBookItems.size() - 1; intSceneBookItem >= 0; --intSceneBookItem) {
                o_SceneBookItem = (SceneBookItem)o_SceneBookItems.get(intSceneBookItem);
                if (o_SceneBookItem == null) continue;
                o_SceneBookItem.closeSingle();
            }
            if (this.m_LiveShowSceneBookPanel != null) {
                this.m_LiveShowSceneBookPanel.eventRefreshMainPanelSceneBridge(this);
            }
            this.revalidate();
            EventQueueHandler.invokeLater(this.m_RunnableRepaint);
        }

        public LiveShowSceneBookPanel getLiveShowSceneBookPanel() {
            return this.m_LiveShowSceneBookPanel;
        }

        public GridBagConstraints getGridBagConstraints() {
            return this.m_GridBagConstraints;
        }

        public long getFrameStart() {
            if (this.m_LiveShowSceneBridgeMain == null) {
                return -1L;
            }
            return this.m_LiveShowSceneBridgeMain.getFrameStart();
        }

        @Override
        public String getName() {
            if (this.m_LiveShowSceneBridgeMain == null) {
                return "-";
            }
            return this.m_LiveShowSceneBridgeMain.getName();
        }

        public LiveShowSceneBridgeMain getLiveShowSceneBridgeMain() {
            return this.m_LiveShowSceneBridgeMain;
        }

        public void addLiveShowSceneBridge_Main(LiveShowSceneBridge p_LiveShowSceneBridge) {
            if (p_LiveShowSceneBridge == null) {
                return;
            }
            SceneBookColumn o_SceneBookColumn = this.m_LiveShowSceneBookPanel.getSceneBookColumn(p_LiveShowSceneBridge);
            if (o_SceneBookColumn == null) {
                return;
            }
            SceneBook_PanelSceneBridge o_SceneBook_PanelSceneBridge = new SceneBook_PanelSceneBridge(this.m_LiveShowSceneBookPanel, o_SceneBookColumn, p_LiveShowSceneBridge);
            o_SceneBook_PanelSceneBridge.setParentPanel(this);
            this.m_SceneBook_PanelSceneBridges.set(o_SceneBookColumn.getColumnIndex(), o_SceneBook_PanelSceneBridge);
        }

        public void removeLiveShowSceneBridge_Main(LiveShowSceneBridge p_LiveShowSceneBridge) {
            if (p_LiveShowSceneBridge == null) {
                return;
            }
            SceneBookColumn o_SceneBookColumn = this.m_LiveShowSceneBookPanel.getSceneBookColumn(p_LiveShowSceneBridge);
            if (o_SceneBookColumn == null) {
                return;
            }
            if (o_SceneBookColumn.getColumnIndex() >= this.m_SceneBook_PanelSceneBridges.size()) {
                return;
            }
            SceneBook_PanelSceneBridge o_SceneBook_PanelSceneBridge = this.m_SceneBook_PanelSceneBridges.get(o_SceneBookColumn.getColumnIndex());
            if (o_SceneBook_PanelSceneBridge == null) {
                return;
            }
            o_SceneBook_PanelSceneBridge.closeSingle();
            this.m_SceneBook_PanelSceneBridges.set(o_SceneBookColumn.getColumnIndex(), null);
        }

        public int getSceneBook_PanelSceneBridgeCount() {
            return this.m_SceneBook_PanelSceneBridges.size();
        }

        public SceneBook_PanelSceneBridge getSceneBook_PanelSceneBridge(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            if (p_Index >= this.m_SceneBook_PanelSceneBridges.size()) {
                return null;
            }
            return this.m_SceneBook_PanelSceneBridges.get(p_Index);
        }

        public void setLiveShowProjectDescription(LiveShowProjectDescription p_LiveShowProjectDescription) {
            for (int intColumn = 0; intColumn < this.m_LiveShowSceneBookPanel.getSceneBookColumnCount(); ++intColumn) {
                SceneBook_PanelSceneBridge o_SceneBook_PanelSceneBridge = this.m_SceneBook_PanelSceneBridges.get(intColumn);
                if (o_SceneBook_PanelSceneBridge == null) continue;
                o_SceneBook_PanelSceneBridge.refresh();
            }
        }

        public void setActualScene(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge) {
            if (p_LiveShowVIP == null) {
                return;
            }
            SceneBookColumn o_SceneBookColumn = this.m_LiveShowSceneBookPanel.getSceneBookColumn(p_LiveShowVIP);
            if (o_SceneBookColumn == null) {
                return;
            }
            for (int intPanel = 0; intPanel < this.m_SceneBook_PanelSceneBridges.size(); ++intPanel) {
                SceneBook_PanelSceneBridge o_SceneBook_PanelSceneBridge = this.m_SceneBook_PanelSceneBridges.get(intPanel);
                if (o_SceneBook_PanelSceneBridge == null) continue;
                o_SceneBook_PanelSceneBridge.setActualScene(p_LiveShowVIP, p_LiveShowSceneBridge);
            }
            for (int intRow = 0; intRow < this.m_SceneBookRows.size(); ++intRow) {
                SceneBookRow o_SceneBookRow = this.m_SceneBookRows.get(intRow);
                o_SceneBookRow.setActualScene(p_LiveShowVIP, p_LiveShowSceneBridge);
            }
            EventQueueHandler.invokeLater(this.m_RunnableRepaint);
        }

        public SceneBookRow addSceneBookRow(SceneBookRow p_SceneBookRow) {
            SceneBookRow o_SceneBookRow;
            int intRow;
            if (p_SceneBookRow == null) {
                return null;
            }
            if (this.m_SceneBookRows.contains(p_SceneBookRow)) {
                return p_SceneBookRow;
            }
            for (intRow = 0; intRow < this.m_SceneBookRows.size() && ((o_SceneBookRow = this.m_SceneBookRows.get(intRow)) == null || o_SceneBookRow.getFrameStart() <= p_SceneBookRow.getFrameStart()); ++intRow) {
            }
            GridBagConstraints o_GridBagConstraints = p_SceneBookRow.getGridBagConstraints();
            o_GridBagConstraints.gridy = intRow;
            this.jPanelRows.add((Component)p_SceneBookRow, o_GridBagConstraints);
            p_SceneBookRow.setVisible(true);
            this.m_SceneBookRows.add(intRow, p_SceneBookRow);
            ++intRow;
            while (intRow < this.m_SceneBookRows.size()) {
                o_SceneBookRow = this.m_SceneBookRows.get(intRow);
                if (o_SceneBookRow == null) continue;
                o_GridBagConstraints = o_SceneBookRow.getGridBagConstraints();
                ++o_GridBagConstraints.gridy;
                this.m_GridBagLayoutPanelRows.setConstraints(o_SceneBookRow, o_GridBagConstraints);
                ++intRow;
            }
            if (this.m_LiveShowSceneBookPanel != null) {
                this.m_LiveShowSceneBookPanel.eventRefreshMainPanelSceneBridge(this);
            }
            EventQueueHandler.invokeLater(this.m_RunnableRepaint_SceneBookRows);
            return p_SceneBookRow;
        }

        public SceneBookRow removeSceneBookRow(SceneBookRow p_SceneBookRow) {
            if (p_SceneBookRow == null) {
                return null;
            }
            int intRow = this.m_SceneBookRows.indexOf(p_SceneBookRow);
            if (intRow < 0) {
                return null;
            }
            this.m_SceneBookRows.remove(p_SceneBookRow);
            p_SceneBookRow.setVisible(false);
            this.jPanelRows.remove(p_SceneBookRow);
            SceneBookRow.addEmptySceneBookRow(p_SceneBookRow);
            while (intRow < this.m_SceneBookRows.size()) {
                SceneBookRow o_SceneBookRow = this.m_SceneBookRows.get(intRow);
                GridBagConstraints o_GridBagConstraints = o_SceneBookRow.getGridBagConstraints();
                --o_GridBagConstraints.gridy;
                this.m_GridBagLayoutPanelRows.setConstraints(o_SceneBookRow, o_GridBagConstraints);
                ++intRow;
            }
            if (this.m_LiveShowSceneBookPanel != null) {
                this.m_LiveShowSceneBookPanel.eventRefreshMainPanelSceneBridge(this);
            }
            EventQueueHandler.invokeLater(this.m_RunnableRepaint_SceneBookRows);
            return p_SceneBookRow;
        }

        public SceneBookRow findSceneBookRowPrior(SceneBookItem p_SceneBookItem) {
            SceneBookRow o_SceneBookRowResult = null;
            SceneBookRow o_SceneBookRow = null;
            for (int intRow = 0; intRow < this.m_SceneBookRows.size(); ++intRow) {
                o_SceneBookRow = this.m_SceneBookRows.get(intRow);
                if (o_SceneBookRow == null || o_SceneBookRow.getFrameStart() > p_SceneBookItem.getFrameStart()) continue;
                if (o_SceneBookRow.getFrameStart() == p_SceneBookItem.getFrameStart()) {
                    return o_SceneBookRow;
                }
                if (o_SceneBookRowResult == null) {
                    o_SceneBookRowResult = o_SceneBookRow;
                    continue;
                }
                if (o_SceneBookRow.getFrameStart() <= o_SceneBookRowResult.getFrameStart()) continue;
                o_SceneBookRowResult = o_SceneBookRow;
            }
            return o_SceneBookRowResult;
        }

        public int getSceneBookRowCount() {
            return this.m_SceneBookRows.size();
        }

        public SceneBookRow getSceneBookRow(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            if (p_Index >= this.m_SceneBookRows.size()) {
                return null;
            }
            return this.m_SceneBookRows.get(p_Index);
        }

        @Override
        public Rectangle getBounds() {
            this.m_Bounds = super.getBounds(this.m_Bounds);
            return this.m_Bounds;
        }

        public Rectangle getSceneBookRowBounds(SceneBookRow p_SceneBookRow) {
            this.m_Bounds = this.getBounds(this.m_Bounds);
            this.m_Bounds_PanelRows = this.jPanelRows.getBounds(this.m_Bounds_PanelRows);
            this.m_Bounds_SceneBookRow = p_SceneBookRow.getBounds(this.m_Bounds_SceneBookRow);
            this.m_Bounds_SceneBookRow.x += this.m_Bounds_PanelRows.x + this.m_Bounds.x;
            this.m_Bounds_SceneBookRow.y += this.m_Bounds_PanelRows.y + this.m_Bounds.y;
            return this.m_Bounds_SceneBookRow;
        }

        public void setSceneBookDocumentsVisible(boolean p_DocumentsVisible) {
            SceneBook_PanelSceneBridge o_SceneBook_PanelSceneBridge;
            SceneBookRow o_SceneBookRow = null;
            for (int intColumn = 0; intColumn < this.m_SceneBook_PanelSceneBridges.size(); ++intColumn) {
                o_SceneBook_PanelSceneBridge = this.m_SceneBook_PanelSceneBridges.get(intColumn);
                if (o_SceneBook_PanelSceneBridge == null) continue;
                o_SceneBook_PanelSceneBridge.refresh();
            }
            for (int intRow = 0; intRow < this.m_SceneBookRows.size(); ++intRow) {
                o_SceneBookRow = this.m_SceneBookRows.get(intRow);
                if (o_SceneBookRow == null) continue;
                for (int intItem = 0; intItem < o_SceneBookRow.getSceneBookItemCount(); ++intItem) {
                    SceneBookItem o_SceneBookItem = o_SceneBookRow.getSceneBookItem(intItem);
                    if (o_SceneBookItem == null || (o_SceneBook_PanelSceneBridge = o_SceneBookItem.getSceneBook_PanelSceneBridge()) == null) continue;
                    o_SceneBook_PanelSceneBridge.refresh();
                }
            }
        }

        public void refreshSceneBookDocuments() {
            SceneBook_PanelSceneBridge o_SceneBook_PanelSceneBridge;
            SceneBookRow o_SceneBookRow = null;
            for (int intColumn = 0; intColumn < this.m_SceneBook_PanelSceneBridges.size(); ++intColumn) {
                o_SceneBook_PanelSceneBridge = this.m_SceneBook_PanelSceneBridges.get(intColumn);
                if (o_SceneBook_PanelSceneBridge == null) continue;
                o_SceneBook_PanelSceneBridge.refreshDocuments();
            }
            for (int intRow = 0; intRow < this.m_SceneBookRows.size(); ++intRow) {
                o_SceneBookRow = this.m_SceneBookRows.get(intRow);
                for (int intItem = 0; intItem < o_SceneBookRow.getSceneBookItemCount(); ++intItem) {
                    SceneBookItem o_SceneBookItem = o_SceneBookRow.getSceneBookItem(intItem);
                    if (o_SceneBookItem == null || (o_SceneBook_PanelSceneBridge = o_SceneBookItem.getSceneBook_PanelSceneBridge()) == null) continue;
                    o_SceneBook_PanelSceneBridge.refreshDocuments();
                }
            }
        }

        public void addSceneBookItem(SceneBookItem p_SceneBookItem) {
            if (p_SceneBookItem == null) {
                return;
            }
            p_SceneBookItem.setMainSceneBridgePanel(this);
            SceneBookRow o_SceneBookRow = null;
            for (int intRow = 0; intRow < this.m_SceneBookRows.size(); ++intRow) {
                o_SceneBookRow = this.m_SceneBookRows.get(intRow);
                if (o_SceneBookRow == null) continue;
                if (o_SceneBookRow.getFrameStart() == p_SceneBookItem.getFrameStart()) break;
                o_SceneBookRow = null;
            }
            if (o_SceneBookRow == null) {
                o_SceneBookRow = SceneBookRow.getEmptySceneBookRow(this);
            }
            o_SceneBookRow.addSceneBookItem(p_SceneBookItem);
            this.addSceneBookRow(o_SceneBookRow);
            this.m_LiveShowSceneBookPanel.setChangedStructure(true);
        }

        public void removeSceneBookItem(SceneBookItem p_SceneBookItem) {
            if (p_SceneBookItem == null) {
                return;
            }
            SceneBookRow o_SceneBookRow = p_SceneBookItem.getSceneBookRow();
            if (o_SceneBookRow == null) {
                return;
            }
            o_SceneBookRow.removeSceneBookItem(p_SceneBookItem);
            p_SceneBookItem.setMainSceneBridgePanel(null);
            this.m_LiveShowSceneBookPanel.setChangedStructure(true);
        }

        public SceneBookItem getSceneBookItem(LiveShowSceneBridge p_LiveShowSceneBridge) {
            if (p_LiveShowSceneBridge == null) {
                return null;
            }
            for (int intRow = 0; intRow < this.m_SceneBookRows.size(); ++intRow) {
                SceneBookItem o_SceneBookItem;
                SceneBookRow o_SceneBookRow = this.m_SceneBookRows.get(intRow);
                if (o_SceneBookRow == null || (o_SceneBookItem = o_SceneBookRow.getSceneBookItem(p_LiveShowSceneBridge)) == null) continue;
                return o_SceneBookItem;
            }
            return null;
        }

        public void resortSceneBookItem(SceneBookItem p_SceneBookItem) {
            SceneBookRow o_SceneBookRow = null;
            SceneBookRow o_SceneBookRowSelf = null;
            for (int intRow = 0; intRow < this.m_SceneBookRows.size(); ++intRow) {
                o_SceneBookRow = this.m_SceneBookRows.get(intRow);
                if (o_SceneBookRow == null) continue;
                if (o_SceneBookRow.contains(p_SceneBookItem)) {
                    o_SceneBookRowSelf = o_SceneBookRow;
                    try {
                        for (int intItem = 0; intItem < o_SceneBookRowSelf.getSceneBookItemCount(); ++intItem) {
                            SceneBookItem o_SceneBookItem = o_SceneBookRowSelf.getSceneBookItem(intItem);
                            if (o_SceneBookItem == null || o_SceneBookItem == p_SceneBookItem || o_SceneBookItem.getFrameStart() == p_SceneBookItem.getFrameStart()) continue;
                            this.removeSceneBookItem(p_SceneBookItem);
                            this.addSceneBookItem(p_SceneBookItem);
                            return;
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                if (o_SceneBookRowSelf == null) {
                    if (o_SceneBookRow.getFrameStart() < p_SceneBookItem.getFrameStart()) continue;
                    this.removeSceneBookItem(p_SceneBookItem);
                    this.addSceneBookItem(p_SceneBookItem);
                    return;
                }
                if (o_SceneBookRow.getFrameStart() <= p_SceneBookItem.getFrameStart()) {
                    this.removeSceneBookItem(p_SceneBookItem);
                    this.addSceneBookItem(p_SceneBookItem);
                    return;
                }
                return;
            }
        }

        @Override
        public void eventObjectParameterChanged(LiveShowObjectInterface p_LiveShowObjectInterface, LiveShowObjectDescription p_LiveShowObjectDescription) {
            if (p_LiveShowObjectInterface == null) {
                return;
            }
            if (p_LiveShowObjectInterface instanceof LiveShowSceneBridge) {
                this.m_LiveShowSceneBookPanel.eventChangedMainPanelSceneBridge(this, p_LiveShowObjectInterface);
                if (this.m_SceneBookRows != null) {
                    int intRowCount = this.getSceneBookRowCount();
                    for (int intRow = 0; intRow < intRowCount; ++intRow) {
                        SceneBookRow o_SceneBookRow = this.getSceneBookRow(intRow);
                        if (o_SceneBookRow == null) continue;
                        int intItemCount = o_SceneBookRow.getSceneBookItemCount();
                        for (int intItem = 0; intItem < intItemCount; ++intItem) {
                            SceneBookItem o_SceneBookItem = o_SceneBookRow.getSceneBookItem(intItem);
                            if (o_SceneBookItem == null) continue;
                            this.m_LiveShowSceneBookPanel.eventChangedSceneBook_PanelSceneBridge(o_SceneBookItem.getSceneBook_PanelSceneBridge());
                        }
                    }
                }
            }
        }

        @Override
        public void eventObjectVolumeChanged(LiveShowObjectInterface p_LiveShowObjectInterface, float p_Volume) {
        }

        @Override
        public void eventObjectAdditionalChanged(LiveShowObjectInterface p_LiveShowObjectInterface, LiveShowObjectDescription p_LiveShowObjectDescription) {
        }

        @Override
        public void eventObjectClosed(LiveShowObjectInterface p_LiveShowObjectInterface) {
        }

        @Override
        public void eventObjectSelection(LiveShowObjectInterface p_LiveShowObjectInterface, boolean p_IsSelected, boolean p_Added) {
        }
    }

    public static class SceneBookColumn {
        private LiveShowSceneBookPanel m_LiveShowSceneBookPanel;
        private LiveShowVIP m_LiveShowVIP;
        private int m_ColumnIndex;
        private SceneBook_PanelSceneBridge m_ActualPanelSceneBridge;
        private boolean m_AutoScroll;
        private Runnable m_RunnableScroll;
        private long m_PlayFramesRest;
        private String m_PlayTimeRest;

        public SceneBookColumn(LiveShowSceneBookPanel p_LiveShowSceneBookPanel, LiveShowVIP p_LiveShowVIP, int p_ColumnIndex) {
            this.initMembers();
            this.m_LiveShowSceneBookPanel = p_LiveShowSceneBookPanel;
            this.m_LiveShowVIP = p_LiveShowVIP;
            this.m_ColumnIndex = p_ColumnIndex;
        }

        private void initMembers() {
            this.m_AutoScroll = true;
            this.m_RunnableScroll = new Runnable(){

                @Override
                public void run() {
                    if (m_AutoScroll && m_ActualPanelSceneBridge != null && this.getVIPActive()) {
                        m_LiveShowSceneBookPanel.scrollToRectangle(m_ActualPanelSceneBridge.getBounds_Absolute());
                    }
                }
            };
        }

        public LiveShowSceneBookPanel getLiveShowSceneBookPanel() {
            return this.m_LiveShowSceneBookPanel;
        }

        public LiveShowVIP getLiveShowVIP() {
            return this.m_LiveShowVIP;
        }

        public boolean getVIPActive() {
            if (this.m_LiveShowVIP == null) {
                return false;
            }
            return this.m_LiveShowVIP.getActive();
        }

        public Play getPlay() {
            return this.m_LiveShowVIP.getPlay();
        }

        public int getColumnIndex() {
            return this.m_ColumnIndex;
        }

        public void setActualSceneBookPanel_SceneBridge(SceneBook_PanelSceneBridge p_SceneBook_PanelSceneBridge) {
            if (this.m_ActualPanelSceneBridge == p_SceneBook_PanelSceneBridge) {
                return;
            }
            this.m_ActualPanelSceneBridge = p_SceneBook_PanelSceneBridge;
            if (this.m_ActualPanelSceneBridge == null) {
                return;
            }
            this.scroll();
        }

        public SceneBook_PanelSceneBridge getActualSceneBook_PanelSceneBridge() {
            return this.m_ActualPanelSceneBridge;
        }

        public void setAutoScroll(boolean p_AutoScroll) {
            if (this.m_AutoScroll == p_AutoScroll) {
                return;
            }
            this.m_AutoScroll = p_AutoScroll;
            this.scroll();
        }

        public void scroll() {
            EventQueueHandler.invokeLater(this.m_RunnableScroll);
        }

        public boolean getAutoScroll() {
            return this.m_AutoScroll;
        }

        public void setTimesRest(long p_FramesRest, String p_TimeRest) {
            this.m_PlayFramesRest = p_FramesRest;
            this.m_PlayTimeRest = p_TimeRest;
        }

        public long getTimeRest_Frames() {
            return this.m_PlayFramesRest;
        }

        public String getTimeRest_String() {
            return this.m_PlayTimeRest;
        }
    }

    public static interface SceneBookListener {
        public void eventSceneBookChanged(LiveShowSceneBookPanel var1);

        public void eventSceneBookClose(LiveShowSceneBookPanel var1);
    }
}

