/*
 * Decompiled with CFR 0.152.
 */
package LiveShowScrollPackage;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LiveShowPlayPackage.Playable;
import LiveShowScrollPackage.LiveShowTimeBar;
import SwingToolTipPackage.PopUpToolTip;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LiveShowMarkSettingsPanel
extends JPanel
implements LiveShowTimeBar.MarkListener,
DocumentListener {
    public static final String PROP_PARAMSCHANGED = "paramsChanged";
    public static final int UNIT_TIME = 0;
    public static final int UNIT_FRAMES = 1;
    private int m_SelectedUnit;
    private Playable m_Playable;
    private LiveShowTimeBar.Mark m_Mark;
    private boolean m_InternalChange;
    private boolean m_Changed_ObjectName;
    private boolean m_Changed_Start;
    private ButtonGroup buttonGroup_Unit;
    private JButton jButton_Cancel;
    private JButton jButton_Save;
    private JLabel jLabel_MarkIcon;
    private JLabel jLabel_ObjectName;
    private JLabel jLabel_Start;
    private JRadioButton jRadioButton_UnitFrames;
    private JRadioButton jRadioButton_UnitTime;
    private JSeparator jSeparator1;
    private JTextField jTextField_MarkName;
    private JTextField jTextField_Start;

    public LiveShowMarkSettingsPanel() {
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
        LiveLanguage.addLanguageListener(this, null);
    }

    private void initMembers() {
        this.m_SelectedUnit = 0;
        this.m_Changed_ObjectName = false;
        this.m_Changed_Start = false;
    }

    private void initComponents() {
        this.buttonGroup_Unit = new ButtonGroup();
        this.jLabel_ObjectName = new JLabel();
        this.jTextField_MarkName = new JTextField();
        this.jLabel_Start = new JLabel();
        this.jTextField_Start = new JTextField();
        this.jLabel_MarkIcon = new JLabel();
        this.jRadioButton_UnitFrames = new JRadioButton();
        this.jRadioButton_UnitTime = new JRadioButton();
        this.jSeparator1 = new JSeparator();
        this.jButton_Save = new JButton();
        this.jButton_Cancel = new JButton();
        this.setMinimumSize(new Dimension(300, 150));
        this.setPreferredSize(new Dimension(300, 150));
        this.setLayout(new GridBagLayout());
        this.jLabel_ObjectName.setHorizontalAlignment(0);
        this.jLabel_ObjectName.setText("Name");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.add((Component)this.jLabel_ObjectName, gridBagConstraints);
        this.jTextField_MarkName.setHorizontalAlignment(0);
        this.jTextField_MarkName.setText("jTextField1");
        this.jTextField_MarkName.setMinimumSize(new Dimension(100, 20));
        this.jTextField_MarkName.setPreferredSize(new Dimension(150, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.add((Component)this.jTextField_MarkName, gridBagConstraints);
        this.jLabel_Start.setText("Start");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.add((Component)this.jLabel_Start, gridBagConstraints);
        this.jTextField_Start.setHorizontalAlignment(0);
        this.jTextField_Start.setText("jTextField1");
        this.jTextField_Start.setMinimumSize(new Dimension(100, 20));
        this.jTextField_Start.setPreferredSize(new Dimension(150, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.add((Component)this.jTextField_Start, gridBagConstraints);
        this.jLabel_MarkIcon.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Mark.png")));
        this.jLabel_MarkIcon.setText("jLabel1");
        this.jLabel_MarkIcon.setMaximumSize(new Dimension(24, 24));
        this.jLabel_MarkIcon.setMinimumSize(new Dimension(24, 24));
        this.jLabel_MarkIcon.setPreferredSize(new Dimension(24, 24));
        this.jLabel_MarkIcon.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_MarkIcon, gridBagConstraints);
        this.buttonGroup_Unit.add(this.jRadioButton_UnitFrames);
        this.jRadioButton_UnitFrames.setText("Frames");
        this.jRadioButton_UnitFrames.setOpaque(false);
        this.jRadioButton_UnitFrames.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowMarkSettingsPanel.this.jRadioButton_UnitFramesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jRadioButton_UnitFrames, gridBagConstraints);
        this.buttonGroup_Unit.add(this.jRadioButton_UnitTime);
        this.jRadioButton_UnitTime.setSelected(true);
        this.jRadioButton_UnitTime.setText("Time");
        this.jRadioButton_UnitTime.setOpaque(false);
        this.jRadioButton_UnitTime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowMarkSettingsPanel.this.jRadioButton_UnitTimeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jRadioButton_UnitTime, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.jButton_Save.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_OK.png")));
        this.jButton_Save.setContentAreaFilled(false);
        this.jButton_Save.setMargin(new Insets(-1, -1, -1, -1));
        this.jButton_Save.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_Save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowMarkSettingsPanel.this.jButton_SaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.3;
        this.add((Component)this.jButton_Save, gridBagConstraints);
        this.jButton_Cancel.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Cancel.png")));
        this.jButton_Cancel.setContentAreaFilled(false);
        this.jButton_Cancel.setMargin(new Insets(-1, -1, -1, -1));
        this.jButton_Cancel.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_Cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowMarkSettingsPanel.this.jButton_CancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.3;
        this.add((Component)this.jButton_Cancel, gridBagConstraints);
    }

    private void jRadioButton_UnitFramesActionPerformed(ActionEvent evt) {
        if (this.jRadioButton_UnitFrames.isSelected()) {
            this.setSelectedUnit(1);
        }
    }

    private void jRadioButton_UnitTimeActionPerformed(ActionEvent evt) {
        if (this.jRadioButton_UnitTime.isSelected()) {
            this.setSelectedUnit(0);
        }
    }

    private void jButton_CancelActionPerformed(ActionEvent evt) {
        this.refreahContent();
        this.hideParent();
    }

    private void jButton_SaveActionPerformed(ActionEvent evt) {
        this.save();
        this.hideParent();
    }

    private void initComponentsFurther() {
        this.jTextField_MarkName.getDocument().addDocumentListener(this);
        this.jTextField_Start.getDocument().addDocumentListener(this);
        this.jButton_Save.setEnabled(false);
        this.jButton_Cancel.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_Save.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
    }

    public void hideParent() {
        if (this.m_Mark != null) {
            this.m_Mark.removeMarkListener(this);
        }
        this.m_Playable = null;
        if (this.getRootPane().getParent() instanceof JInternalFrame) {
            ((JInternalFrame)this.getRootPane().getParent()).setVisible(false);
        }
        if (this.getRootPane().getParent() instanceof JInternalFrame) {
            ((JInternalFrame)this.getRootPane().getParent()).setVisible(false);
        }
    }

    public void setMark(LiveShowTimeBar.Mark p_Mark, Playable p_Playable) {
        if (this.m_Mark != null) {
            this.m_Mark.removeMarkListener(this);
        }
        this.m_Playable = p_Playable;
        this.m_Mark = p_Mark;
        this.m_Changed_ObjectName = false;
        this.m_Changed_Start = false;
        this.refreahContent();
        this.refreshComponents();
        if (this.m_Mark != null) {
            this.m_Mark.addMarkListener(this);
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            System.out.println(this.getClass().getName() + "setMark");
        }
        this.repaint();
    }

    public void setSelectedUnit(int p_SelectedUnit) {
        if (p_SelectedUnit != 1 && p_SelectedUnit != 0) {
            return;
        }
        this.m_SelectedUnit = p_SelectedUnit;
        this.refreahContent();
    }

    @Override
    public void setForeground(Color p_Color) {
        super.setForeground(p_Color);
        if (this.jLabel_ObjectName != null) {
            this.jLabel_ObjectName.setForeground(p_Color);
        }
        if (this.jLabel_Start != null) {
            this.jLabel_Start.setForeground(p_Color);
        }
    }

    private void refreshComponents() {
        if (this.m_Mark == null || this.m_Playable == null) {
            this.jTextField_MarkName.setEnabled(false);
            this.jTextField_Start.setEnabled(false);
            this.jButton_Cancel.setEnabled(false);
            this.jButton_Save.setEnabled(false);
            return;
        }
        if (this.m_Changed_ObjectName || this.m_Changed_Start) {
            this.jButton_Save.setEnabled(true);
        } else {
            this.jButton_Save.setEnabled(false);
        }
        this.jButton_Cancel.setEnabled(true);
        this.jTextField_Start.setEnabled(true);
        this.jTextField_MarkName.setEnabled(true);
    }

    public void refreahContent() {
        this.m_InternalChange = true;
        if (this.m_Mark == null || this.m_Playable == null) {
            this.jTextField_MarkName.setText("");
            this.jTextField_Start.setText("");
            this.m_InternalChange = false;
            return;
        }
        double doubleFrameTime = this.m_Playable.getFrameTime();
        this.jTextField_MarkName.setText(this.m_Mark.getName());
        this.jTextField_Start.setText(this.getString(this.m_Mark.getFramePosition(), doubleFrameTime));
        this.m_InternalChange = false;
        this.firePropertyChange(PROP_PARAMSCHANGED, true, false);
    }

    public String getString(long p_Frames, double p_FrameTime) {
        if (this.m_Mark == null) {
            return "";
        }
        if (this.m_SelectedUnit == 0) {
            return this.getTimeStringFromMillis((long)((double)p_Frames * p_FrameTime));
        }
        return String.valueOf(p_Frames);
    }

    private String getTimeStringFromMillis(long p_Milliseconds) {
        String stringTemp;
        String stringTime = "";
        boolean boolSetString = false;
        int intHours = (int)(p_Milliseconds / 3600000L);
        p_Milliseconds -= (long)(intHours * 3600000);
        if (boolSetString || intHours > 0) {
            stringTemp = "00";
            stringTemp = stringTemp + String.valueOf(intHours);
            stringTime = stringTime + stringTemp.substring(stringTemp.length() - 2, stringTemp.length()) + ":";
            boolSetString = true;
        }
        int intMinutes = (int)(p_Milliseconds / 60000L);
        p_Milliseconds -= (long)(intMinutes * 60000);
        if (boolSetString || intMinutes > 0) {
            stringTemp = "00";
            stringTemp = stringTemp + String.valueOf(intMinutes);
            stringTime = stringTime + stringTemp.substring(stringTemp.length() - 2, stringTemp.length()) + ":";
        }
        int intSeconds = (int)(p_Milliseconds / 1000L);
        p_Milliseconds -= (long)(intSeconds * 1000);
        if (boolSetString || intSeconds > 0) {
            stringTemp = "00";
            stringTemp = stringTemp + String.valueOf(intSeconds);
            stringTime = stringTime + stringTemp.substring(stringTemp.length() - 2, stringTemp.length()) + ":";
        }
        int intMilliseconds = (int)p_Milliseconds;
        stringTemp = "000";
        stringTemp = stringTemp + String.valueOf(intMilliseconds);
        stringTime = stringTime + stringTemp.substring(stringTemp.length() - 3, stringTemp.length());
        return stringTime;
    }

    private long getFramesFromString(String p_TimeString, double p_FrameTime) {
        if (p_TimeString == null || p_TimeString.length() <= 0) {
            return 0L;
        }
        if (p_FrameTime <= 0.0) {
            return 0L;
        }
        try {
            if (this.m_SelectedUnit == 1) {
                return Long.valueOf(p_TimeString);
            }
            long longFrames = 0L;
            int intMilliseconds = 0;
            int intSeconds = 0;
            int intMinutes = 0;
            int intHours = 0;
            String[] arrayTimeString = p_TimeString.split(":");
            if (arrayTimeString.length >= 1) {
                intMilliseconds = Integer.valueOf(arrayTimeString[arrayTimeString.length - 1].trim());
                longFrames = (long)((double)longFrames + (double)intMilliseconds / p_FrameTime);
            }
            if (arrayTimeString.length >= 2) {
                intSeconds = Integer.valueOf(arrayTimeString[arrayTimeString.length - 2].trim());
                longFrames = (long)((double)longFrames + (double)(intSeconds * 1000) / p_FrameTime);
            }
            if (arrayTimeString.length >= 3) {
                intMinutes = Integer.valueOf(arrayTimeString[arrayTimeString.length - 3].trim());
                longFrames = (long)((double)longFrames + (double)(intMinutes * 60000) / p_FrameTime);
            }
            if (arrayTimeString.length >= 4) {
                intHours = Integer.valueOf(arrayTimeString[arrayTimeString.length - 4].trim());
                longFrames = (long)((double)longFrames + (double)(intHours * 3600000) / p_FrameTime);
            }
            return longFrames;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public void save() {
        if (this.m_Mark == null) {
            return;
        }
        double doubleFrameTime = this.m_Playable.getFrameTime();
        String stringName = this.m_Mark.getName();
        long longFrameStart = this.m_Mark.getFramePosition();
        if (this.m_Changed_ObjectName) {
            stringName = this.jTextField_MarkName.getText();
            this.m_Mark.setName(stringName);
        }
        if (this.m_Changed_Start) {
            longFrameStart = this.getFramesFromString(this.jTextField_Start.getText(), doubleFrameTime);
            this.m_Mark.setFramePosition(longFrameStart);
        }
        this.m_Changed_ObjectName = false;
        this.m_Changed_Start = false;
        this.firePropertyChange(PROP_PARAMSCHANGED, true, false);
        this.refreahContent();
        this.refreshComponents();
    }

    @Override
    public void eventMarkParameterChanged(LiveShowTimeBar.Mark p_Mark, String p_Name, long p_FramePosition) {
        this.m_Changed_Start = false;
        this.refreshComponents();
        this.refreahContent();
    }

    @Override
    public void eventMarkClosed(LiveShowTimeBar.Mark p_Mark) {
        if (p_Mark == this.m_Mark) {
            this.setMark(null, null);
        }
    }

    @Override
    public void eventMarkSelection(LiveShowTimeBar.Mark p_Mark, boolean p_IsSelected) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changedText(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changedText(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.changedText(e);
    }

    private void changedText(DocumentEvent e) {
        if (e.getDocument() == this.jTextField_MarkName.getDocument()) {
            this.m_Changed_ObjectName = true;
        }
        if (e.getDocument() == this.jTextField_Start.getDocument()) {
            this.m_Changed_Start = true;
        }
        if (!this.m_InternalChange) {
            this.firePropertyChange(PROP_PARAMSCHANGED, false, true);
        }
        this.refreshComponents();
    }
}

