/*
 * Decompiled with CFR 0.152.
 */
package LiveShowPlayPackage;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowObjectPackage.LiveShowProjectDescription;
import LiveShowObjectPackage.SinglePropertyChangeSupport;
import LiveShowPlayPackage.PlayRemoteActionConfiguration;
import LiveShowPlayPackage.PlayRemoteActionHandler;
import LiveShowPlayPackage.PlayRemoteMouseActionDialog;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import LiveShowVirtualPackage.LiveShowSceneBridgeMain;
import LiveShowVirtualPackage.LiveShow_ExportDescription;
import LiveShowVirtualPackage.LiveShow_ImportDescription;
import OS.OSChecker;
import SwingComponents.KeyAdapter_Delayed;
import SwingComponents.KeyEventInterpreter;
import SwingComponents.MouseAdapter_Delayed;
import SwingModelPackage.TableAndListModel;
import SwingToolTipPackage.PopUpToolTip;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;

public class PlayRemoteActions {
    public static final int SOFTWAREVERSION = 1;
    public static final String FILESUFFIX = ".mra";
    public static final String INIFILE_NAME = OSChecker.getPathUserHomeConfigDirectory() + "/MouseRemotePlayControl.ini";
    public static final String INIFILE_FIELDSEPERATOR = "=";
    public static boolean DOACTIONONPRESSED = true;
    public static final String ACTIONGROUP_GLOBAL = "";
    public static final String ACTIONGROUP_JINGLE = "Jingle";
    public static final String ACTIONGROUP_JINGLEGROUP = "JingleGroup";
    public static final String ACTIONGROUP_MAINBRIDGE = "MainBridge";
    public static final String ACTIONGROUP_SCENEBRIDGE = "SceneBridge";
    @LiveLanguageString
    public static String ACTIONGROUPNAME_GLOBAL = "";
    @LiveLanguageString
    public static String ACTIONGROUPNAME_JINGLE = "Jingle";
    @LiveLanguageString
    public static String ACTIONGROUPNAME_JINGLEGROUP = "JingleGroup";
    public static final String ACTIONID_OBJECT_PLAY = "actionPlay";
    public static final String ACTIONID_OBJECT_PLAYSTOP = "actionPlayStop";
    public static final String ACTIONID_OBJECT_PLAYPAUSE = "actionPlayPause";
    public static final String ACTIONID_OBJECT_FADEINOUT = "actionFadeInOut";
    public static final String ACTIONID_OBJECT_FADE = "actionFadet";
    public static final String ACTIONID_OBJECT_PLAYFADEOUT = "actionPlayFadeOut";
    public static final String ACTIONID_OBJECT_UP = "actionUp";
    public static final String ACTIONID_OBJECT_DOWN = "actionDown";
    public static double VALUEFACTOR_UPDOWN_PERCENT = 0.05;
    @LiveLanguageString
    public static String ACTIONNAME_PLAY = "Play";
    @LiveLanguageString
    public static String ACTIONNAME_PLAYSTOP = "Play / Stop";
    @LiveLanguageString
    public static String ACTIONNAME_PLAYPAUSE = "Play / Pause";
    @LiveLanguageString
    public static String ACTIONNAME_FADEINOUT = "Fade In/Out";
    @LiveLanguageString
    public static String ACTIONNAME_PLAYFADEOUT = "Play / Fade Out";
    @LiveLanguageString
    public static String ACTIONNAME_FADE = "Fade";
    @LiveLanguageString
    public static String ACTIONNAME_UP = "Up";
    @LiveLanguageString
    public static String ACTIONNAME_DOWN = "Down";
    public static final String SOURCEID_TIMELINEPLAYPAUSE = "sourceIDTimelinePlayStop";
    public static final String SOURCEID_TIMELINENEXTSCENE = "sourceIDTimelineNextScene";
    public static final String SOURCEID_TIMELINENEXTMAINSCENE = "sourceIDTimelineNextMainScene";
    public static final String SOURCEID_TIMELINEPREVIOUSSCENE = "sourceIDTimelinePreviousScene";
    public static final String SOURCEID_TIMELINEPREVIOUSMAINSCENE = "sourceIDTimelinePreviousMainScene";
    public static final String SOURCEID_SELECTEDJINGLES = "sourceIDSelectedJingles";
    public static final String SOURCEID_SELECTEDJINGLEGROUPS = "sourceIDSelectedJingleGroups";
    public static final String SOURCEID_MAINSOUNDVOLUME = "sourceIDMainSoundVolume";
    @LiveLanguageString
    public static String SOURCENAME_TIMELINE = "Timeline";
    @LiveLanguageString
    public static String MOUSEBUTTON = "Mouse";
    public static RemoteActionTableModel s_RemoteActionTableModel = new RemoteActionTableModel();
    public static ArrayList<RemoteAction> s_RemovedRemoteActions = new ArrayList();
    public static final Object s_SyncRemoteActions = new Object();
    public static RemoteAction s_LearningDMXRemoteAction = null;
    public static boolean s_SearchingDMXRemaoteAction = false;
    private static HashMap<String, RemoteActionTrigger> s_RemoteTriggers_DMX = new HashMap();
    public static final Object s_SyncRemoteTriggers = new Object();
    public static PlayRemoteActionConfiguration s_PlayRemoteActionConfiguration = new PlayRemoteActionConfiguration(null, false);
    public static boolean s_GlobalListenersStarted = false;
    public static boolean s_GlobalDialogStarted = false;
    private static AWTEventListener s_AWTEventListener = null;
    private static WindowFocusListener s_MainFrame_WindowsFocusListener = null;
    private static MouseListener s_MainFrame_GlasPaneMouseListener = null;
    private static ComponentListener s_MainFrame_ComponentListener;
    private static JFrame s_MainFrame;
    private static boolean s_MainFrame_HasFocus;
    private static boolean s_MainFrame_MouseInside;
    public static PlayRemoteMouseActionDialog s_JDialogRemoteGlobal;
    public static boolean s_JDialog_HasFocus;
    public static boolean s_JDialog_MouseInside;
    private static long eventMask;
    public static SinglePropertyChangeSupport s_PropertyChangeSupport;
    public static KeyAdapter_Delayed s_KeyAdapter_Delayed;
    public static MouseAdapter_Delayed s_MouseAdapter_Delayed;
    public static final Object s_SyncWriteIni;
    public static ArrayList<String> s_ExportedSourceIDs;
    public static GlassPane_Translucent s_GlassPane_Translucent;

    public static void loadLanguage() {
        LiveLanguage.addLanguageListener(PlayRemoteActions.class, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeProject() {
        if (s_PlayRemoteActionConfiguration != null) {
            s_PlayRemoteActionConfiguration.closeProject();
        }
        Object object = s_SyncRemoteActions;
        synchronized (object) {
            for (int intAction = s_RemovedRemoteActions.size() - 1; intAction >= 0; --intAction) {
                RemoteAction o_RemoteAction = s_RemovedRemoteActions.get(intAction);
                if (o_RemoteAction == null) continue;
                o_RemoteAction.close();
            }
            s_RemovedRemoteActions.clear();
        }
    }

    public static void closePlayRemoteActionDialog() {
        if (s_JDialogRemoteGlobal != null) {
            s_JDialogRemoteGlobal.close();
        }
    }

    public static void close() {
        PlayRemoteActions.stopGlobalEvents();
        PlayRemoteActions.closeProject();
        PlayRemoteActionHandler.close(0L);
        for (int intAction = s_RemoteActionTableModel.size() - 1; intAction >= 0; --intAction) {
            RemoteAction o_RemoteAction = (RemoteAction)s_RemoteActionTableModel.get(intAction);
            if (o_RemoteAction == null) continue;
            o_RemoteAction.close();
        }
        s_MouseAdapter_Delayed.close();
    }

    public static void addRemoteAction(RemoteAction p_RemoteAction) {
        if (p_RemoteAction == null) {
            return;
        }
        s_RemoteActionTableModel.add(p_RemoteAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeRemoteAction(RemoteAction p_RemoteAction) {
        if (p_RemoteAction == null) {
            return;
        }
        s_RemoteActionTableModel.remove(p_RemoteAction);
        Object object = s_SyncRemoteActions;
        synchronized (object) {
            if (ACTIONGROUP_MAINBRIDGE.equals(p_RemoteAction.getActionGroupID()) || ACTIONGROUP_SCENEBRIDGE.equals(p_RemoteAction.getActionGroupID())) {
                s_RemovedRemoteActions.add(p_RemoteAction);
            }
        }
    }

    public static RemoteAction getRemoteAction(String p_SourceID, String p_ActionID) {
        return s_RemoteActionTableModel.get(p_SourceID, p_ActionID);
    }

    public static int getRemoteActionCount() {
        return s_RemoteActionTableModel.size();
    }

    public static RemoteAction getRemoteAction(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        return (RemoteAction)s_RemoteActionTableModel.get(p_Index);
    }

    public static void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        s_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
    }

    public static void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        s_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
    }

    private static void notifyRemoteActionChanged(String p_PropertyName, RemoteAction p_RemoteAction) {
        if (p_PropertyName == null) {
            return;
        }
        if (p_RemoteAction == null) {
            return;
        }
        s_PropertyChangeSupport.firePropertyChange(p_PropertyName, null, p_RemoteAction);
    }

    public static void setLearningDMXRemoteAction(RemoteAction p_RemoteAction) {
        s_LearningDMXRemoteAction = p_RemoteAction;
        if (s_LearningDMXRemoteAction != null) {
            s_LearningDMXRemoteAction.setDMXChannelArmed(false);
        }
    }

    public static void setSearchingDMXRemoteAction(boolean p_Search) {
        s_SearchingDMXRemaoteAction = p_Search;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRemoteActionTrigger_DMX(RemoteActionTrigger p_RemoteActionTrigger) {
        if (p_RemoteActionTrigger == null) {
            return;
        }
        Object object = s_SyncRemoteTriggers;
        synchronized (object) {
            s_RemoteTriggers_DMX.put(p_RemoteActionTrigger.getID(), p_RemoteActionTrigger);
        }
        for (int intAction = 0; intAction < s_RemoteActionTableModel.size(); ++intAction) {
            RemoteAction o_RemoteAction = (RemoteAction)s_RemoteActionTableModel.get(intAction);
            if (o_RemoteAction == null || o_RemoteAction.getDMXRemoteActionTrigger() != p_RemoteActionTrigger) continue;
            s_RemoteActionTableModel.changed(o_RemoteAction, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeRemoteActionTrigger_DMX(RemoteActionTrigger p_RemoteActionTrigger) {
        if (p_RemoteActionTrigger == null) {
            return;
        }
        for (int intAction = 0; intAction < s_RemoteActionTableModel.size(); ++intAction) {
            RemoteAction o_RemoteAction = (RemoteAction)s_RemoteActionTableModel.get(intAction);
            if (o_RemoteAction == null || o_RemoteAction.getDMXRemoteActionTrigger() != p_RemoteActionTrigger) continue;
            o_RemoteAction.setDMXRemoteActionTrigger(null, -1);
        }
        Object object = s_SyncRemoteTriggers;
        synchronized (object) {
            s_RemoteTriggers_DMX.remove(p_RemoteActionTrigger.getID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RemoteActionTrigger getRemoteActionTrigger_DMX(String p_ID) {
        if (p_ID == null) {
            return null;
        }
        Object object = s_SyncRemoteTriggers;
        synchronized (object) {
            return s_RemoteTriggers_DMX.get(p_ID);
        }
    }

    public static void doAction(final RemoteActionListener p_RemoteActionListener, final RemoteAction p_RemoteAction, final double p_Value) {
        if (p_RemoteActionListener == null) {
            return;
        }
        if (p_RemoteAction == null) {
            return;
        }
        PlayRemoteActionHandler.addJob(new Runnable(){

            @Override
            public void run() {
                p_RemoteActionListener.doAction(p_RemoteAction, p_Value);
            }
        });
    }

    public static void setDelay(int p_DelayMilliseconds) {
        if (p_DelayMilliseconds < 50 || p_DelayMilliseconds > 1000) {
            return;
        }
        if (s_MouseAdapter_Delayed.getDelay() == p_DelayMilliseconds) {
            return;
        }
        s_MouseAdapter_Delayed.setDelay(p_DelayMilliseconds);
        s_KeyAdapter_Delayed.setDelay(p_DelayMilliseconds);
        if (s_PlayRemoteActionConfiguration != null) {
            s_PlayRemoteActionConfiguration.refresh();
        }
    }

    public static int getDelay() {
        return s_MouseAdapter_Delayed.getDelay();
    }

    public static void setDoActionOnPressed(boolean p_ActionWhenMousePressed) {
        if (DOACTIONONPRESSED == p_ActionWhenMousePressed) {
            return;
        }
        DOACTIONONPRESSED = p_ActionWhenMousePressed;
        if (s_PlayRemoteActionConfiguration != null) {
            s_PlayRemoteActionConfiguration.refresh();
        }
    }

    public static boolean getDoActionOnPressed() {
        return DOACTIONONPRESSED;
    }

    public static void DMXChanged(RemoteActionTrigger p_RemoteActionTrigger) {
        if (p_RemoteActionTrigger == null) {
            return;
        }
        for (int intAction = 0; intAction < s_RemoteActionTableModel.size(); ++intAction) {
            RemoteAction o_RemoteAction = (RemoteAction)s_RemoteActionTableModel.get(intAction);
            if (o_RemoteAction == null || o_RemoteAction.getDMXRemoteActionTrigger() != p_RemoteActionTrigger) continue;
            s_RemoteActionTableModel.changed(o_RemoteAction, false);
        }
    }

    public static void DMXEvent(RemoteActionTrigger p_RemoteActionTrigger, int p_FirstChangedChannel, int[] p_Values) {
        if (s_SearchingDMXRemaoteAction) {
            if (p_RemoteActionTrigger == null) {
                PlayRemoteActionConfiguration.getSelfReference().searchDMXRemoteAction(null, -1);
            } else {
                RemoteAction o_RemoteAction = s_RemoteActionTableModel.getRemoteAction_DMXEvent(p_RemoteActionTrigger.getID(), p_FirstChangedChannel);
                if (o_RemoteAction == null) {
                    PlayRemoteActionConfiguration.getSelfReference().searchDMXRemoteAction(null, -1);
                } else {
                    o_RemoteAction.eventDMXValue(p_RemoteActionTrigger, p_FirstChangedChannel, p_Values);
                }
            }
            return;
        }
        RemoteAction o_RemoteAction = s_LearningDMXRemoteAction;
        if (o_RemoteAction != null) {
            if (p_FirstChangedChannel >= 0 && p_FirstChangedChannel < p_Values.length) {
                o_RemoteAction.eventDMXValue(p_RemoteActionTrigger, p_FirstChangedChannel, p_Values);
            }
            return;
        }
        for (int intAction = 0; intAction <= s_RemoteActionTableModel.size(); ++intAction) {
            int intChannel;
            o_RemoteAction = (RemoteAction)s_RemoteActionTableModel.get(intAction);
            if (o_RemoteAction == null || (intChannel = o_RemoteAction.getDMXChannel()) < 0 || intChannel >= p_Values.length || o_RemoteAction.getDMXRemoteActionTrigger() != p_RemoteActionTrigger) continue;
            o_RemoteAction.eventDMXValue(p_RemoteActionTrigger, p_FirstChangedChannel, p_Values);
        }
    }

    public static boolean readIni() {
        File o_FileIni = new File(INIFILE_NAME);
        if (!o_FileIni.exists()) {
            return false;
        }
        boolean boolIni = false;
        FileReader o_FileReaderIni = null;
        BufferedReader o_BufferedReader = null;
        try {
            o_FileReaderIni = new FileReader(o_FileIni);
            o_BufferedReader = new BufferedReader(o_FileReaderIni);
            boolIni = true;
            String stringLine = o_BufferedReader.readLine();
            while (stringLine != null) {
                String[] stringValuePair = stringLine.split(INIFILE_FIELDSEPERATOR);
                if (stringValuePair == null) {
                    stringLine = o_BufferedReader.readLine();
                    continue;
                }
                if (stringValuePair.length < 2) {
                    stringLine = o_BufferedReader.readLine();
                    continue;
                }
                if (stringValuePair[1].trim().length() > 0) {
                    RemoteAction o_RemoteAction;
                    int intValue;
                    String stringPropertyName = stringValuePair[0].trim();
                    String stringPropertyValue = stringValuePair[1].trim();
                    if (stringPropertyName.trim().equals("Mouse_Delay")) {
                        try {
                            intValue = Integer.valueOf(stringPropertyValue.trim());
                            if (intValue < 50) {
                                intValue = 50;
                            }
                            if (intValue >= 0 && intValue <= 1000) {
                                PlayRemoteActions.setDelay(intValue);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (stringPropertyName.trim().equals("DoActionOnClick")) {
                        boolean boolValue = Boolean.valueOf(stringPropertyValue.trim());
                        PlayRemoteActions.setDoActionOnPressed(boolValue);
                    }
                    if (stringPropertyName.trim().equals("PlayStartPause_Button") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_TIMELINEPLAYPAUSE, ACTIONID_OBJECT_PLAYPAUSE)) != null && (intValue = Integer.valueOf(stringPropertyValue.trim()).intValue()) >= 0) {
                        o_RemoteAction.setMouseButton(intValue);
                    }
                    if (stringPropertyName.trim().equals("PlayStartPause_ClickCount") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_TIMELINEPLAYPAUSE, ACTIONID_OBJECT_PLAYPAUSE)) != null && (intValue = Integer.valueOf(stringPropertyValue.trim()).intValue()) >= 0 && intValue <= 3) {
                        o_RemoteAction.setMouseClickCount(intValue);
                    }
                    if (stringPropertyName.trim().equals("PlayStartPause_KeyCode") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_TIMELINEPLAYPAUSE, ACTIONID_OBJECT_PLAYPAUSE)) != null) {
                        intValue = Integer.valueOf(stringPropertyValue.trim());
                        o_RemoteAction.setKeyCode(intValue);
                    }
                    if (stringPropertyName.trim().equals("PlayStartPause_KeyClickCount") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_TIMELINEPLAYPAUSE, ACTIONID_OBJECT_PLAYPAUSE)) != null) {
                        intValue = Integer.valueOf(stringPropertyValue.trim());
                        o_RemoteAction.setKeyClickCount(intValue);
                    }
                    if (stringPropertyName.trim().equals("NextScene_Button") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_TIMELINENEXTSCENE, ACTIONID_OBJECT_PLAY)) != null && (intValue = Integer.valueOf(stringPropertyValue.trim()).intValue()) >= 0) {
                        o_RemoteAction.setMouseButton(intValue);
                    }
                    if (stringPropertyName.trim().equals("NextScene_ClickCount") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_TIMELINENEXTSCENE, ACTIONID_OBJECT_PLAY)) != null && (intValue = Integer.valueOf(stringPropertyValue.trim()).intValue()) >= 0 && intValue <= 3) {
                        o_RemoteAction.setMouseClickCount(intValue);
                    }
                    if (stringPropertyName.trim().equals("NextScene_KeyCode") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_TIMELINENEXTSCENE, ACTIONID_OBJECT_PLAY)) != null) {
                        intValue = Integer.valueOf(stringPropertyValue.trim());
                        o_RemoteAction.setKeyCode(intValue);
                    }
                    if (stringPropertyName.trim().equals("NextScene_KeyClickCount") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_TIMELINENEXTSCENE, ACTIONID_OBJECT_PLAY)) != null) {
                        intValue = Integer.valueOf(stringPropertyValue.trim());
                        o_RemoteAction.setKeyClickCount(intValue);
                    }
                    if (stringPropertyName.trim().equals("NextMainScene_Button") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_TIMELINENEXTMAINSCENE, ACTIONID_OBJECT_PLAY)) != null && (intValue = Integer.valueOf(stringPropertyValue.trim()).intValue()) >= 0) {
                        o_RemoteAction.setMouseButton(intValue);
                    }
                    if (stringPropertyName.trim().equals("NextMainScene_ClickCount") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_TIMELINENEXTMAINSCENE, ACTIONID_OBJECT_PLAY)) != null && (intValue = Integer.valueOf(stringPropertyValue.trim()).intValue()) >= 0 && intValue <= 3) {
                        o_RemoteAction.setMouseClickCount(intValue);
                    }
                    if (stringPropertyName.trim().equals("NextMainScene_KeyCode") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_TIMELINENEXTMAINSCENE, ACTIONID_OBJECT_PLAY)) != null) {
                        intValue = Integer.valueOf(stringPropertyValue.trim());
                        o_RemoteAction.setKeyCode(intValue);
                    }
                    if (stringPropertyName.trim().equals("NextMainScene_KeyClickCount") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_TIMELINENEXTMAINSCENE, ACTIONID_OBJECT_PLAY)) != null) {
                        intValue = Integer.valueOf(stringPropertyValue.trim());
                        o_RemoteAction.setKeyClickCount(intValue);
                    }
                    if (stringPropertyName.trim().equals("PreviousScene_Button") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_TIMELINEPREVIOUSSCENE, ACTIONID_OBJECT_PLAY)) != null && (intValue = Integer.valueOf(stringPropertyValue.trim()).intValue()) >= 0) {
                        o_RemoteAction.setMouseButton(intValue);
                    }
                    if (stringPropertyName.trim().equals("PreviousScene_ClickCount") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_TIMELINEPREVIOUSSCENE, ACTIONID_OBJECT_PLAY)) != null && (intValue = Integer.valueOf(stringPropertyValue.trim()).intValue()) >= 0 && intValue <= 3) {
                        o_RemoteAction.setMouseClickCount(intValue);
                    }
                    if (stringPropertyName.trim().equals("PreviousScene_KeyCode") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_TIMELINEPREVIOUSSCENE, ACTIONID_OBJECT_PLAY)) != null) {
                        intValue = Integer.valueOf(stringPropertyValue.trim());
                        o_RemoteAction.setKeyCode(intValue);
                    }
                    if (stringPropertyName.trim().equals("PreviousScene_KeyClickCount") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_TIMELINEPREVIOUSSCENE, ACTIONID_OBJECT_PLAY)) != null) {
                        intValue = Integer.valueOf(stringPropertyValue.trim());
                        o_RemoteAction.setKeyClickCount(intValue);
                    }
                    if (stringPropertyName.trim().equals("PreviousMainScene_Button") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_TIMELINEPREVIOUSMAINSCENE, ACTIONID_OBJECT_PLAY)) != null && (intValue = Integer.valueOf(stringPropertyValue.trim()).intValue()) >= 0) {
                        o_RemoteAction.setMouseButton(intValue);
                    }
                    if (stringPropertyName.trim().equals("PreviousMainScene_ClickCount") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_TIMELINEPREVIOUSMAINSCENE, ACTIONID_OBJECT_PLAY)) != null && (intValue = Integer.valueOf(stringPropertyValue.trim()).intValue()) >= 0 && intValue <= 3) {
                        o_RemoteAction.setMouseClickCount(intValue);
                    }
                    if (stringPropertyName.trim().equals("PreviousMainScene_KeyCode") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_TIMELINEPREVIOUSMAINSCENE, ACTIONID_OBJECT_PLAY)) != null) {
                        intValue = Integer.valueOf(stringPropertyValue.trim());
                        o_RemoteAction.setKeyCode(intValue);
                    }
                    if (stringPropertyName.trim().equals("PreviousMainScene_KeyClickCount") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_TIMELINEPREVIOUSMAINSCENE, ACTIONID_OBJECT_PLAY)) != null) {
                        intValue = Integer.valueOf(stringPropertyValue.trim());
                        o_RemoteAction.setKeyClickCount(intValue);
                    }
                    if (stringPropertyName.trim().equals("StartSelectedJingles_Button") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_SELECTEDJINGLES, ACTIONID_OBJECT_PLAYSTOP)) != null && (intValue = Integer.valueOf(stringPropertyValue.trim()).intValue()) >= 0) {
                        o_RemoteAction.setMouseButton(intValue);
                    }
                    if (stringPropertyName.trim().equals("StartSelectedJingles_ClickCount") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_SELECTEDJINGLES, ACTIONID_OBJECT_PLAYSTOP)) != null && (intValue = Integer.valueOf(stringPropertyValue.trim()).intValue()) >= 0 && intValue <= 3) {
                        o_RemoteAction.setMouseClickCount(intValue);
                    }
                    if (stringPropertyName.trim().equals("StartSelectedJingles_KeyCode") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_SELECTEDJINGLES, ACTIONID_OBJECT_PLAYSTOP)) != null) {
                        intValue = Integer.valueOf(stringPropertyValue.trim());
                        o_RemoteAction.setKeyCode(intValue);
                    }
                    if (stringPropertyName.trim().equals("StartSelectedJingles_KeyClickCount") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_SELECTEDJINGLES, ACTIONID_OBJECT_PLAYSTOP)) != null) {
                        intValue = Integer.valueOf(stringPropertyValue.trim());
                        o_RemoteAction.setKeyClickCount(intValue);
                    }
                    if (stringPropertyName.trim().equals("StartSelectedJingles_PlayFadeOut_Button") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_SELECTEDJINGLES, ACTIONID_OBJECT_PLAYFADEOUT)) != null && (intValue = Integer.valueOf(stringPropertyValue.trim()).intValue()) >= 0) {
                        o_RemoteAction.setMouseButton(intValue);
                    }
                    if (stringPropertyName.trim().equals("StartSelectedJingles_PlayFadeOut_ClickCount") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_SELECTEDJINGLES, ACTIONID_OBJECT_PLAYFADEOUT)) != null && (intValue = Integer.valueOf(stringPropertyValue.trim()).intValue()) >= 0 && intValue <= 3) {
                        o_RemoteAction.setMouseClickCount(intValue);
                    }
                    if (stringPropertyName.trim().equals("StartSelectedJingles_PlayFadeOut_KeyCode") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_SELECTEDJINGLES, ACTIONID_OBJECT_PLAYFADEOUT)) != null) {
                        intValue = Integer.valueOf(stringPropertyValue.trim());
                        o_RemoteAction.setKeyCode(intValue);
                    }
                    if (stringPropertyName.trim().equals("StartSelectedJingles_PlayFadeOut_KeyClickCount") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_SELECTEDJINGLES, ACTIONID_OBJECT_PLAYFADEOUT)) != null) {
                        intValue = Integer.valueOf(stringPropertyValue.trim());
                        o_RemoteAction.setKeyClickCount(intValue);
                    }
                    if (stringPropertyName.trim().equals("StartSelectedJingleGroups_Button") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_SELECTEDJINGLEGROUPS, ACTIONID_OBJECT_PLAYSTOP)) != null && (intValue = Integer.valueOf(stringPropertyValue.trim()).intValue()) >= 0) {
                        o_RemoteAction.setMouseButton(intValue);
                    }
                    if (stringPropertyName.trim().equals("StartSelectedJingleGroups_ClickCount") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_SELECTEDJINGLEGROUPS, ACTIONID_OBJECT_PLAYSTOP)) != null && (intValue = Integer.valueOf(stringPropertyValue.trim()).intValue()) >= 0 && intValue <= 3) {
                        o_RemoteAction.setMouseClickCount(intValue);
                    }
                    if (stringPropertyName.trim().equals("StartSelectedJingleGroups_KeyCode") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_SELECTEDJINGLEGROUPS, ACTIONID_OBJECT_PLAYSTOP)) != null) {
                        intValue = Integer.valueOf(stringPropertyValue.trim());
                        o_RemoteAction.setKeyCode(intValue);
                    }
                    if (stringPropertyName.trim().equals("StartSelectedJingleGroups_KeyClickCount") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_SELECTEDJINGLEGROUPS, ACTIONID_OBJECT_PLAYSTOP)) != null) {
                        intValue = Integer.valueOf(stringPropertyValue.trim());
                        o_RemoteAction.setKeyClickCount(intValue);
                    }
                    if (stringPropertyName.trim().equals("StartSelectedJingleGroups_PlayFadeOut_Button") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_SELECTEDJINGLEGROUPS, ACTIONID_OBJECT_PLAYFADEOUT)) != null && (intValue = Integer.valueOf(stringPropertyValue.trim()).intValue()) >= 0) {
                        o_RemoteAction.setMouseButton(intValue);
                    }
                    if (stringPropertyName.trim().equals("StartSelectedJingleGroups_PlayFadeOut_ClickCount") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_SELECTEDJINGLEGROUPS, ACTIONID_OBJECT_PLAYFADEOUT)) != null && (intValue = Integer.valueOf(stringPropertyValue.trim()).intValue()) >= 0 && intValue <= 3) {
                        o_RemoteAction.setMouseClickCount(intValue);
                    }
                    if (stringPropertyName.trim().equals("StartSelectedJingleGroups_PlayFadeOut_KeyCode") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_SELECTEDJINGLEGROUPS, ACTIONID_OBJECT_PLAYFADEOUT)) != null) {
                        intValue = Integer.valueOf(stringPropertyValue.trim());
                        o_RemoteAction.setKeyCode(intValue);
                    }
                    if (stringPropertyName.trim().equals("StartSelectedJingleGroups_PlayFadeOut_KeyClickCount") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_SELECTEDJINGLEGROUPS, ACTIONID_OBJECT_PLAYFADEOUT)) != null) {
                        intValue = Integer.valueOf(stringPropertyValue.trim());
                        o_RemoteAction.setKeyClickCount(intValue);
                    }
                    if (stringPropertyName.trim().equals("MainSoundVolume_Up_Button") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_MAINSOUNDVOLUME, ACTIONID_OBJECT_UP)) != null && (intValue = Integer.valueOf(stringPropertyValue.trim()).intValue()) >= 0) {
                        o_RemoteAction.setMouseButton(intValue);
                    }
                    if (stringPropertyName.trim().equals("MainSoundVolume_Up_ClickCount") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_MAINSOUNDVOLUME, ACTIONID_OBJECT_UP)) != null && (intValue = Integer.valueOf(stringPropertyValue.trim()).intValue()) >= 0 && intValue <= 3) {
                        o_RemoteAction.setMouseClickCount(intValue);
                    }
                    if (stringPropertyName.trim().equals("MainSoundVolume_Up_KeyCode") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_MAINSOUNDVOLUME, ACTIONID_OBJECT_UP)) != null) {
                        intValue = Integer.valueOf(stringPropertyValue.trim());
                        o_RemoteAction.setKeyCode(intValue);
                    }
                    if (stringPropertyName.trim().equals("MainSoundVolume_Up_KeyClickCount") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_MAINSOUNDVOLUME, ACTIONID_OBJECT_UP)) != null) {
                        intValue = Integer.valueOf(stringPropertyValue.trim());
                        o_RemoteAction.setKeyClickCount(intValue);
                    }
                    if (stringPropertyName.trim().equals("MainSoundVolume_Down_Button") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_MAINSOUNDVOLUME, ACTIONID_OBJECT_DOWN)) != null && (intValue = Integer.valueOf(stringPropertyValue.trim()).intValue()) >= 0) {
                        o_RemoteAction.setMouseButton(intValue);
                    }
                    if (stringPropertyName.trim().equals("MainSoundVolume_Down_ClickCount") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_MAINSOUNDVOLUME, ACTIONID_OBJECT_DOWN)) != null && (intValue = Integer.valueOf(stringPropertyValue.trim()).intValue()) >= 0 && intValue <= 3) {
                        o_RemoteAction.setMouseClickCount(intValue);
                    }
                    if (stringPropertyName.trim().equals("MainSoundVolume_Down_KeyCode") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_MAINSOUNDVOLUME, ACTIONID_OBJECT_DOWN)) != null) {
                        intValue = Integer.valueOf(stringPropertyValue.trim());
                        o_RemoteAction.setKeyCode(intValue);
                    }
                    if (stringPropertyName.trim().equals("MainSoundVolume_Down_KeyClickCount") && (o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_MAINSOUNDVOLUME, ACTIONID_OBJECT_DOWN)) != null) {
                        intValue = Integer.valueOf(stringPropertyValue.trim());
                        o_RemoteAction.setKeyClickCount(intValue);
                    }
                    if (stringPropertyName.trim().equals("MainSoundVolume_Change_Percent")) {
                        intValue = Integer.valueOf(stringPropertyValue.trim());
                        VALUEFACTOR_UPDOWN_PERCENT = (double)intValue / 100.0;
                    }
                }
                stringLine = o_BufferedReader.readLine();
            }
        }
        catch (IOException e_IOException) {
            boolIni = false;
        }
        try {
            if (o_BufferedReader != null) {
                o_BufferedReader.close();
            }
            if (o_FileReaderIni != null) {
                o_FileReaderIni.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return boolIni;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeIni() {
        Object object = s_SyncWriteIni;
        synchronized (object) {
            File o_FileIni;
            boolean boolOK = true;
            try {
                o_FileIni = new File(INIFILE_NAME);
                if (o_FileIni.exists()) {
                    boolOK = o_FileIni.delete();
                }
                if (!boolOK) {
                    return false;
                }
                o_FileIni = new File(INIFILE_NAME);
                o_FileIni.createNewFile();
            }
            catch (Exception p_Exception) {
                return false;
            }
            boolean boolIni = false;
            FileWriter o_FileWriterIni = null;
            BufferedWriter o_BufferedWriter = null;
            try {
                boolIni = true;
                o_FileWriterIni = new FileWriter(o_FileIni);
                o_BufferedWriter = new BufferedWriter(o_FileWriterIni);
                String stringLine = "Mouse_Delay=" + s_MouseAdapter_Delayed.getDelay();
                o_BufferedWriter.write(stringLine);
                o_BufferedWriter.write("\n");
                stringLine = "DoActionOnClick=" + DOACTIONONPRESSED;
                stringLine = stringLine + INIFILE_FIELDSEPERATOR + " true: actionwhen mousebutton is pressed, false: action when mousebutton is released";
                o_BufferedWriter.write(stringLine);
                o_BufferedWriter.write("\n");
                RemoteAction o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_TIMELINEPLAYPAUSE, ACTIONID_OBJECT_PLAYPAUSE);
                if (o_RemoteAction != null) {
                    stringLine = "PlayStartPause_Button=" + o_RemoteAction.getMouseButton();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                    stringLine = "PlayStartPause_ClickCount=" + o_RemoteAction.getMouseClickCount();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                    stringLine = "PlayStartPause_KeyCode=" + o_RemoteAction.getKeyCode();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                    stringLine = "PlayStartPause_KeyClickCount=" + o_RemoteAction.getKeyClickCount();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                }
                if ((o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_TIMELINENEXTSCENE, ACTIONID_OBJECT_PLAY)) != null) {
                    stringLine = "NextScene_Button=" + o_RemoteAction.getMouseButton();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                    stringLine = "NextScene_ClickCount=" + o_RemoteAction.getMouseClickCount();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                    stringLine = "NextScene_KeyCode=" + o_RemoteAction.getKeyCode();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                    stringLine = "NextScene_KeyClickCount=" + o_RemoteAction.getKeyClickCount();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                }
                if ((o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_TIMELINENEXTMAINSCENE, ACTIONID_OBJECT_PLAY)) != null) {
                    stringLine = "NextMainScene_Button=" + o_RemoteAction.getMouseButton();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                    stringLine = "NextMainScene_ClickCount=" + o_RemoteAction.getMouseClickCount();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                    stringLine = "NextMainScene_KeyCode=" + o_RemoteAction.getKeyCode();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                    stringLine = "NextMainScene_KeyClickCount=" + o_RemoteAction.getKeyClickCount();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                }
                if ((o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_TIMELINEPREVIOUSSCENE, ACTIONID_OBJECT_PLAY)) != null) {
                    stringLine = "PreviousScene_Button=" + o_RemoteAction.getMouseButton();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                    stringLine = "PreviousScene_ClickCount=" + o_RemoteAction.getMouseClickCount();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                    stringLine = "PreviousScene_KeyCode=" + o_RemoteAction.getKeyCode();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                    stringLine = "PreviousScene_KeyClickCount=" + o_RemoteAction.getKeyClickCount();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                }
                if ((o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_TIMELINEPREVIOUSMAINSCENE, ACTIONID_OBJECT_PLAY)) != null) {
                    stringLine = "PreviousMainScene_Button=" + o_RemoteAction.getMouseButton();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                    stringLine = "PreviousMainScene_ClickCount=" + o_RemoteAction.getMouseClickCount();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                    stringLine = "PreviousMainScene_KeyCode=" + o_RemoteAction.getKeyCode();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                    stringLine = "PreviousMainScene_KeyClickCount=" + o_RemoteAction.getKeyClickCount();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                }
                if ((o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_SELECTEDJINGLES, ACTIONID_OBJECT_PLAYSTOP)) != null) {
                    stringLine = "StartSelectedJingles_Button=" + o_RemoteAction.getMouseButton();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                    stringLine = "StartSelectedJingles_ClickCount=" + o_RemoteAction.getMouseClickCount();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                    stringLine = "StartSelectedJingles_KeyCode=" + o_RemoteAction.getKeyCode();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                    stringLine = "StartSelectedJingles_KeyClickCount=" + o_RemoteAction.getKeyClickCount();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                }
                if ((o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_SELECTEDJINGLES, ACTIONID_OBJECT_PLAYFADEOUT)) != null) {
                    stringLine = "StartSelectedJingles_PlayFadeOut_Button=" + o_RemoteAction.getMouseButton();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                    stringLine = "StartSelectedJingles_PlayFadeOut_ClickCount=" + o_RemoteAction.getMouseClickCount();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                    stringLine = "StartSelectedJingles_PlayFadeOut_KeyCode=" + o_RemoteAction.getKeyCode();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                    stringLine = "StartSelectedJingles_PlayFadeOut_KeyClickCount=" + o_RemoteAction.getKeyClickCount();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                }
                if ((o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_SELECTEDJINGLEGROUPS, ACTIONID_OBJECT_PLAYSTOP)) != null) {
                    stringLine = "StartSelectedJingleGroups_Button=" + o_RemoteAction.getMouseButton();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                    stringLine = "StartSelectedJingleGroups_ClickCount=" + o_RemoteAction.getMouseClickCount();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                    stringLine = "StartSelectedJingleGroups_KeyCode=" + o_RemoteAction.getKeyCode();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                    stringLine = "StartSelectedJingleGroups_KeyClickCount=" + o_RemoteAction.getKeyClickCount();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                }
                if ((o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_SELECTEDJINGLEGROUPS, ACTIONID_OBJECT_PLAYFADEOUT)) != null) {
                    stringLine = "StartSelectedJingleGroups_PlayFadeOut_Button=" + o_RemoteAction.getMouseButton();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                    stringLine = "StartSelectedJingleGroups_PlayFadeOut_ClickCount=" + o_RemoteAction.getMouseClickCount();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                    stringLine = "StartSelectedJingleGroups_PlayFadeOut_KeyCode=" + o_RemoteAction.getKeyCode();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                    stringLine = "StartSelectedJingleGroups_PlayFadeOut_KeyClickCount=" + o_RemoteAction.getKeyClickCount();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                }
                if ((o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_MAINSOUNDVOLUME, ACTIONID_OBJECT_UP)) != null) {
                    stringLine = "MainSoundVolume_Up_Button=" + o_RemoteAction.getMouseButton();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                    stringLine = "MainSoundVolume_Up_ClickCount=" + o_RemoteAction.getMouseClickCount();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                    stringLine = "MainSoundVolume_Up_KeyCode=" + o_RemoteAction.getKeyCode();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                    stringLine = "MainSoundVolume_Up_KeyClickCount=" + o_RemoteAction.getKeyClickCount();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                }
                if ((o_RemoteAction = s_RemoteActionTableModel.get(SOURCEID_MAINSOUNDVOLUME, ACTIONID_OBJECT_DOWN)) != null) {
                    stringLine = "MainSoundVolume_Down_Button=" + o_RemoteAction.getMouseButton();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                    stringLine = "MainSoundVolume_Down_ClickCount=" + o_RemoteAction.getMouseClickCount();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                    stringLine = "MainSoundVolume_Down_KeyCode=" + o_RemoteAction.getKeyCode();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                    stringLine = "MainSoundVolume_Down_KeyClickCount=" + o_RemoteAction.getKeyClickCount();
                    o_BufferedWriter.write(stringLine);
                    o_BufferedWriter.write("\n");
                }
                stringLine = "MainSoundVolume_Change_Percent=" + (int)(VALUEFACTOR_UPDOWN_PERCENT * 100.0);
                stringLine = stringLine + INIFILE_FIELDSEPERATOR + " Factor in percent by which the volume is changed";
                o_BufferedWriter.write(stringLine);
                o_BufferedWriter.write("\n");
            }
            catch (IOException e_IOException) {
                boolIni = false;
            }
            try {
                if (o_BufferedWriter != null) {
                    o_BufferedWriter.close();
                }
                if (o_FileWriterIni != null) {
                    o_FileWriterIni.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return boolIni;
        }
    }

    public static void loadProject(LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ImportDescription p_LiveShow_ImportDescription) {
        if (p_LiveShowProjectDescription == null) {
            return;
        }
        FileInputStream o_InputStream = null;
        ObjectInput o_ObjectInput = null;
        int intRemoteActionCount = 0;
        File o_File = new File(p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX);
        if (!o_File.exists()) {
            return;
        }
        try {
            o_InputStream = new FileInputStream(o_File);
            o_ObjectInput = new ObjectInputStream(o_InputStream);
            int intSoftwareVersion = o_ObjectInput.readInt();
            intRemoteActionCount = o_ObjectInput.readInt();
            for (int intAction = 0; intAction < intRemoteActionCount; ++intAction) {
                RemoteAction o_RemoteActionEvent;
                RemoteAction o_TempRemoteAction = new RemoteAction();
                o_TempRemoteAction.readExternal(o_ObjectInput);
                RemoteAction o_RemoteActionFound = s_RemoteActionTableModel.get(o_TempRemoteAction.getSourceID(), o_TempRemoteAction.getActionID());
                if (o_RemoteActionFound == null) continue;
                if (p_LiveShow_ImportDescription == null || p_LiveShow_ImportDescription.getLoadNewProject()) {
                    if (!ACTIONGROUPNAME_GLOBAL.equals(o_RemoteActionFound.getActionGroupID())) {
                        o_RemoteActionFound.setMouseEvent(o_TempRemoteAction.getMouseButton(), o_TempRemoteAction.getMouseClickCount());
                        o_RemoteActionFound.setKeyEvent(o_TempRemoteAction.getKeyCode(), o_TempRemoteAction.getKeyClickCount());
                    }
                    o_RemoteActionFound.setDMXEvent(o_TempRemoteAction.getDMXUniverseID(), o_TempRemoteAction.getDMXChannel());
                    continue;
                }
                if (!ACTIONGROUPNAME_GLOBAL.equals(o_TempRemoteAction.getActionGroupID())) {
                    if (o_TempRemoteAction.getKeyCode() != 0 && (o_RemoteActionEvent = s_RemoteActionTableModel.getRemoteAction_KeyEvent(o_TempRemoteAction.getKeyCode(), o_TempRemoteAction.getKeyClickCount())) == null) {
                        o_RemoteActionFound.setKeyCode(o_TempRemoteAction.getKeyCode());
                    }
                    if (o_TempRemoteAction.getMouseButton() != 0 && o_TempRemoteAction.getMouseClickCount() != 0 && (o_RemoteActionEvent = s_RemoteActionTableModel.getRemoteAction_MouseEvent(o_TempRemoteAction.getMouseButton(), o_TempRemoteAction.getMouseClickCount())) == null) {
                        o_RemoteActionFound.setMouseEvent(o_TempRemoteAction.getMouseButton(), o_TempRemoteAction.getMouseClickCount());
                    }
                }
                if (o_TempRemoteAction.getDMXUniverseID() == null || o_TempRemoteAction.getDMXChannel() < 0 || (o_RemoteActionEvent = s_RemoteActionTableModel.getRemoteAction_DMXEvent(o_TempRemoteAction.getDMXUniverseID(), o_TempRemoteAction.getDMXChannel())) != null) continue;
                o_RemoteActionFound.setDMXEvent(o_TempRemoteAction.getDMXUniverseID(), o_TempRemoteAction.getDMXChannel());
            }
            ((InputStream)o_InputStream).close();
            o_ObjectInput.close();
        }
        catch (Exception e) {
            try {
                if (o_InputStream != null) {
                    ((InputStream)o_InputStream).close();
                }
                if (o_ObjectInput != null) {
                    o_ObjectInput.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void clearExportedSourceIDs() {
        s_ExportedSourceIDs.clear();
    }

    public static void addExportedSourceID(String p_SourceID) {
        if (p_SourceID == null) {
            return;
        }
        if (s_ExportedSourceIDs.contains(p_SourceID)) {
            return;
        }
        s_ExportedSourceIDs.add(p_SourceID);
    }

    public static boolean saveProject(LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ExportDescription p_LiveShowExportDescription) {
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        if (p_LiveShowExportDescription == null) {
            return false;
        }
        OutputStream o_OutputStream = null;
        ObjectOutput o_ObjectOutput = null;
        int intRemoteActionCount = 0;
        File o_File = new File(p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX);
        try {
            RemoteAction o_RemoteAction;
            int intAction;
            if (o_File.exists()) {
                o_File.delete();
            }
            ArrayList<RemoteAction> o_RemoteActions = new ArrayList<RemoteAction>();
            if (p_LiveShowExportDescription.getSaveProject() || p_LiveShowExportDescription.getExportProjectAll()) {
                intRemoteActionCount = s_RemoteActionTableModel.size();
                for (intAction = 0; intAction < intRemoteActionCount; ++intAction) {
                    o_RemoteAction = (RemoteAction)s_RemoteActionTableModel.get(intAction);
                    if (o_RemoteAction == null || o_RemoteAction.getKeyCode() == 0 && o_RemoteAction.getMouseClickCount() == 0 && (o_RemoteAction.getDMXUniverseID() == null || o_RemoteAction.getDMXChannel() < 0)) continue;
                    o_RemoteActions.add(o_RemoteAction);
                }
            } else {
                for (int intSourceID = 0; intSourceID < s_ExportedSourceIDs.size(); ++intSourceID) {
                    String stringSourceID = s_ExportedSourceIDs.get(intSourceID);
                    for (int intAction2 = 0; intAction2 < s_RemoteActionTableModel.size(); ++intAction2) {
                        o_RemoteAction = (RemoteAction)s_RemoteActionTableModel.get(intAction2);
                        if (o_RemoteAction == null || o_RemoteAction.getKeyCode() == 0 && o_RemoteAction.getMouseClickCount() == 0 && (o_RemoteAction.getDMXUniverseID() == null || o_RemoteAction.getDMXChannel() < 0) || !stringSourceID.equals(o_RemoteAction.getSourceID())) continue;
                        o_RemoteActions.add(o_RemoteAction);
                    }
                }
            }
            s_ExportedSourceIDs.clear();
            if (o_RemoteActions.size() <= 0) {
                return true;
            }
            o_File.createNewFile();
            o_OutputStream = new FileOutputStream(o_File);
            o_ObjectOutput = new ObjectOutputStream(o_OutputStream);
            o_ObjectOutput.writeInt(1);
            o_ObjectOutput.writeInt(o_RemoteActions.size());
            for (intAction = 0; intAction < o_RemoteActions.size(); ++intAction) {
                o_RemoteAction = (RemoteAction)o_RemoteActions.get(intAction);
                o_RemoteAction.writeExternal(o_ObjectOutput);
            }
            o_ObjectOutput.close();
            o_OutputStream.close();
        }
        catch (Exception e) {
            try {
                s_ExportedSourceIDs.clear();
                if (o_ObjectOutput != null) {
                    o_ObjectOutput.close();
                }
                if (o_OutputStream != null) {
                    o_OutputStream.close();
                }
                o_File.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    public static void setMainFrame(JFrame p_JFrame) {
        s_MainFrame = p_JFrame;
        s_MainFrame_HasFocus = p_JFrame.hasFocus();
    }

    public static Rectangle calculateMainBounds() {
        Rectangle o_Rectangle = new Rectangle(0, 0, 0, 0);
        if (s_MainFrame != null) {
            o_Rectangle = s_MainFrame.getBounds(o_Rectangle);
            Insets o_Insets = s_MainFrame.getInsets();
            int intExtendedState = s_MainFrame.getExtendedState();
            if (intExtendedState == 6 || intExtendedState == 2) {
                o_Rectangle.width = o_Rectangle.width - o_Insets.left - o_Insets.right;
                o_Rectangle.x += o_Insets.left;
                o_Rectangle.y = 0;
            }
            if (s_JDialogRemoteGlobal != null && o_Rectangle.height != 0) {
                o_Rectangle.height = 100;
                if (o_Rectangle.width != 0) {
                    s_JDialogRemoteGlobal.setBounds(o_Rectangle);
                    s_JDialogRemoteGlobal.revalidate();
                }
            }
        }
        return o_Rectangle;
    }

    public static void startGlobalEvents() {
        s_MainFrame.setGlassPane(s_GlassPane_Translucent);
        PlayRemoteActions.startGlobalListeners();
        PlayRemoteActions.startGlobalDialog();
    }

    public static void startGlobalListeners() {
        if (s_GlobalListenersStarted) {
            return;
        }
        if (s_AWTEventListener == null) {
            s_AWTEventListener = new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent e) {
                    if (e instanceof KeyEvent) {
                        if (s_KeyAdapter_Delayed == null) {
                            return;
                        }
                        switch (e.getID()) {
                            case 400: {
                                s_KeyAdapter_Delayed.keyTyped((KeyEvent)e);
                                ((KeyEvent)e).consume();
                                break;
                            }
                            case 401: {
                                s_KeyAdapter_Delayed.keyPressed((KeyEvent)e);
                                ((KeyEvent)e).consume();
                                break;
                            }
                            case 402: {
                                s_KeyAdapter_Delayed.keyReleased((KeyEvent)e);
                                ((KeyEvent)e).consume();
                                break;
                            }
                        }
                    } else if (e instanceof MouseEvent) {
                        if (s_MouseAdapter_Delayed == null) {
                            return;
                        }
                        switch (e.getID()) {
                            case 500: {
                                s_MouseAdapter_Delayed.mouseClicked((MouseEvent)e);
                                ((MouseEvent)e).consume();
                                break;
                            }
                            case 501: {
                                s_MouseAdapter_Delayed.mousePressed((MouseEvent)e);
                                ((MouseEvent)e).consume();
                                break;
                            }
                            case 502: {
                                s_MouseAdapter_Delayed.mouseReleased((MouseEvent)e);
                                ((MouseEvent)e).consume();
                                break;
                            }
                        }
                    }
                }
            };
        }
        if (s_MainFrame_WindowsFocusListener == null) {
            s_MainFrame_WindowsFocusListener = new WindowFocusListener(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                    PlayRemoteActions.setMainFrame_HasFocus(true);
                }

                @Override
                public void windowLostFocus(WindowEvent e) {
                    PlayRemoteActions.setMainFrame_HasFocus(false);
                }
            };
        }
        if (s_MainFrame_GlasPaneMouseListener == null) {
            s_MainFrame_GlasPaneMouseListener = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    PlayRemoteActions.setMainFrame_MouseInside(true);
                    s_JDialogRemoteGlobal.requestFocusInWindow();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    PlayRemoteActions.setMainFrame_MouseInside(false);
                }
            };
        }
        if (s_MainFrame_ComponentListener == null) {
            s_MainFrame_ComponentListener = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (s_GlobalDialogStarted) {
                        try {
                            Thread.currentThread().wait(10L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        PlayRemoteActions.calculateMainBounds();
                    }
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                    if (s_GlobalDialogStarted) {
                        try {
                            Thread.currentThread().wait(10L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        PlayRemoteActions.calculateMainBounds();
                    }
                }
            };
        }
        Toolkit.getDefaultToolkit().addAWTEventListener(s_AWTEventListener, eventMask);
        if (s_MainFrame != null) {
            s_MainFrame.addWindowFocusListener(s_MainFrame_WindowsFocusListener);
            s_MainFrame.addComponentListener(s_MainFrame_ComponentListener);
            s_GlassPane_Translucent.addMouseListener(s_MainFrame_GlasPaneMouseListener);
        }
        s_GlobalListenersStarted = true;
    }

    public static void startGlobalDialog() {
        s_GlassPane_Translucent.setVisible(true);
        if (s_JDialogRemoteGlobal == null) {
            s_JDialogRemoteGlobal = new PlayRemoteMouseActionDialog(null, false);
        }
        PlayRemoteActions.calculateMainBounds();
        s_JDialogRemoteGlobal.eventStartGlobalEvents();
        s_JDialogRemoteGlobal.setVisible(true);
        s_JDialogRemoteGlobal.toFront();
        s_JDialogRemoteGlobal.setAlwaysOnTop(true);
        if (s_JDialogRemoteGlobal.getMousePosition() != null) {
            PlayRemoteActions.setJDialog_MouseInside(true);
        } else {
            PlayRemoteActions.setJDialog_MouseInside(false);
        }
        if (s_MainFrame != null && s_MainFrame.getMousePosition() != null) {
            PlayRemoteActions.setMainFrame_MouseInside(true);
        } else {
            PlayRemoteActions.setMainFrame_MouseInside(false);
        }
        s_GlobalDialogStarted = true;
    }

    public static void stopGlobalEvents() {
        PlayRemoteActions.stopGlobalListeners();
        PlayRemoteActions.stopGlobalDialog();
    }

    public static void stopGlobalListeners() {
        if (!s_GlobalListenersStarted) {
            return;
        }
        s_GlobalListenersStarted = false;
        Toolkit.getDefaultToolkit().removeAWTEventListener(s_AWTEventListener);
        if (s_MainFrame != null) {
            s_MainFrame.removeWindowFocusListener(s_MainFrame_WindowsFocusListener);
            s_GlassPane_Translucent.removeMouseListener(s_MainFrame_GlasPaneMouseListener);
            PlayRemoteActions.setMainFrame_MouseInside(false);
            s_MainFrame.requestFocus();
            s_MainFrame.toFront();
            s_MainFrame.repaint();
        }
    }

    public static void stopGlobalDialog() {
        if (!s_GlobalDialogStarted) {
            return;
        }
        s_GlobalDialogStarted = false;
        s_GlassPane_Translucent.setVisible(false);
        if (s_JDialogRemoteGlobal != null) {
            s_JDialogRemoteGlobal.setAlwaysOnTop(false);
            s_JDialogRemoteGlobal.setVisible(false);
        }
    }

    public static void setMainFrame_HasFocus(boolean p_MainFrame_HasFocus) {
        if (s_MainFrame_HasFocus == p_MainFrame_HasFocus) {
            return;
        }
        s_MainFrame_HasFocus = p_MainFrame_HasFocus;
        if (s_JDialogRemoteGlobal != null) {
            s_JDialogRemoteGlobal.refresh();
        }
    }

    public static void setMainFrame_MouseInside(boolean p_MainFrame_MouseInside) {
        if (s_MainFrame_MouseInside == p_MainFrame_MouseInside) {
            return;
        }
        s_MainFrame_MouseInside = p_MainFrame_MouseInside;
        if (s_JDialogRemoteGlobal != null) {
            s_JDialogRemoteGlobal.refresh();
        }
    }

    public static void setJDialog_HasFocus(boolean p_JDialog_HasFocus) {
        if (s_JDialog_HasFocus == p_JDialog_HasFocus) {
            return;
        }
        s_JDialog_HasFocus = p_JDialog_HasFocus;
        if (s_JDialogRemoteGlobal != null) {
            s_JDialogRemoteGlobal.refresh();
        }
    }

    public static void toFrontMainFrame() {
        if (s_MainFrame != null) {
            s_MainFrame.toFront();
        }
    }

    public static void setJDialog_MouseInside(boolean p_JDialog_MouseInside) {
        if (s_JDialog_MouseInside == p_JDialog_MouseInside) {
            return;
        }
        s_JDialog_MouseInside = p_JDialog_MouseInside;
        if (s_JDialogRemoteGlobal != null) {
            s_JDialogRemoteGlobal.refresh();
        }
    }

    public static boolean checkHasFocus() {
        if (!s_MainFrame_HasFocus && !s_JDialog_HasFocus) {
            return false;
        }
        return s_MainFrame_MouseInside || s_JDialog_MouseInside;
    }

    public static void checkMouseEvents(RemoteAction p_RemoteMouseAction, boolean p_NewSet) {
        if (p_RemoteMouseAction == null) {
            return;
        }
        if (p_RemoteMouseAction.getMouseClickCount() == 0) {
            return;
        }
        if (p_RemoteMouseAction.getMouseButton() == 0) {
            return;
        }
        for (int intAction = 0; intAction < s_RemoteActionTableModel.size(); ++intAction) {
            RemoteAction o_RemoteMouseAction = (RemoteAction)s_RemoteActionTableModel.get(intAction);
            if (o_RemoteMouseAction == null || o_RemoteMouseAction == p_RemoteMouseAction || o_RemoteMouseAction.getMouseButton() != p_RemoteMouseAction.getMouseButton() || o_RemoteMouseAction.getMouseClickCount() != p_RemoteMouseAction.getMouseClickCount()) continue;
            if (p_NewSet) {
                o_RemoteMouseAction.setMouseButton(0);
                o_RemoteMouseAction.setMouseClickCount(0);
                continue;
            }
            p_RemoteMouseAction.setMouseButton(0);
            p_RemoteMouseAction.setMouseClickCount(0);
        }
    }

    public static void checkKeyEvents(RemoteAction p_RemoteMouseAction, boolean p_NewSet) {
        if (p_RemoteMouseAction == null) {
            return;
        }
        if (p_RemoteMouseAction.getKeyCode() == 0) {
            return;
        }
        for (int intAction = 0; intAction < s_RemoteActionTableModel.size(); ++intAction) {
            RemoteAction o_RemoteMouseAction = (RemoteAction)s_RemoteActionTableModel.get(intAction);
            if (o_RemoteMouseAction == null || o_RemoteMouseAction == p_RemoteMouseAction || o_RemoteMouseAction.getKeyCode() != p_RemoteMouseAction.getKeyCode() || o_RemoteMouseAction.getKeyClickCount() != p_RemoteMouseAction.getKeyClickCount()) continue;
            if (p_NewSet) {
                o_RemoteMouseAction.setKeyCode(0);
                o_RemoteMouseAction.setKeyClickCount(0);
                continue;
            }
            p_RemoteMouseAction.setKeyCode(0);
            p_RemoteMouseAction.setKeyClickCount(0);
        }
    }

    public static void checkDMXEvents(RemoteAction p_RemoteAction, boolean p_NewSet) {
        if (p_RemoteAction == null) {
            return;
        }
        if (p_RemoteAction.getDMXRemoteActionTrigger() == null) {
            return;
        }
        if (p_RemoteAction.getDMXChannel() < 0) {
            return;
        }
        for (int intAction = 0; intAction < s_RemoteActionTableModel.size(); ++intAction) {
            RemoteAction o_RemoteAction = (RemoteAction)s_RemoteActionTableModel.get(intAction);
            if (o_RemoteAction == null || o_RemoteAction == p_RemoteAction || o_RemoteAction.getDMXRemoteActionTrigger() != p_RemoteAction.getDMXRemoteActionTrigger() || o_RemoteAction.getDMXChannel() != p_RemoteAction.getDMXChannel()) continue;
            if (p_NewSet) {
                o_RemoteAction.setDMXRemoteActionTrigger(null, -1);
                continue;
            }
            p_RemoteAction.setDMXRemoteActionTrigger(null, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RemoteAction getRemovedRemoteAction(String p_SourceID, String p_ActionID) {
        Object object = s_SyncRemoteActions;
        synchronized (object) {
            for (int intAction = 0; intAction < s_RemovedRemoteActions.size(); ++intAction) {
                RemoteAction o_RemoteAction = s_RemovedRemoteActions.get(intAction);
                if (o_RemoteAction == null || !o_RemoteAction.getSourceID().equals(p_SourceID) || !o_RemoteAction.getActionID().equals(p_ActionID)) continue;
                return o_RemoteAction;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RemoteAction createRemoteAction(RemoteActionListener p_RemoteActionListener, ImageIcon p_Icon, String p_ActionGroupID, String p_ActionID, String p_SourceID, String p_SourceName, long p_SourcePosition) {
        RemoteAction o_RemoteAction;
        if (p_RemoteActionListener == null) {
            return null;
        }
        if (p_SourceID == null) {
            return null;
        }
        if (p_ActionGroupID == null) {
            return null;
        }
        if (p_ActionID == null) {
            return null;
        }
        if (p_SourceName == null) {
            p_SourceName = ACTIONGROUP_GLOBAL;
        }
        if ((o_RemoteAction = PlayRemoteActions.getRemoteAction(p_SourceID, p_ActionID)) == null) {
            o_RemoteAction = PlayRemoteActions.getRemovedRemoteAction(p_SourceID, p_ActionID);
            Object object = s_SyncRemoteActions;
            synchronized (object) {
                s_RemovedRemoteActions.remove(o_RemoteAction);
            }
            if (o_RemoteAction != null) {
                PlayRemoteActions.checkMouseEvents(o_RemoteAction, false);
                PlayRemoteActions.checkKeyEvents(o_RemoteAction, false);
                PlayRemoteActions.checkDMXEvents(o_RemoteAction, false);
            }
        }
        if (o_RemoteAction != null) {
            o_RemoteAction.setRemoteActionListener(p_RemoteActionListener);
            o_RemoteAction.setIcon(p_Icon);
            o_RemoteAction.setActionGroupID(p_ActionGroupID);
            o_RemoteAction.setSourcePosition(p_SourcePosition);
            o_RemoteAction.setSourceName(p_SourceName);
            PlayRemoteActions.addRemoteAction(o_RemoteAction);
        } else {
            o_RemoteAction = new RemoteAction(p_RemoteActionListener, p_Icon, p_ActionGroupID, p_ActionID, p_SourceID, p_SourceName, p_SourcePosition);
        }
        return o_RemoteAction;
    }

    public static GlassPane_Translucent getGlassPane() {
        return s_GlassPane_Translucent;
    }

    static {
        s_MainFrame_HasFocus = false;
        s_MainFrame_MouseInside = false;
        s_JDialogRemoteGlobal = null;
        s_JDialog_HasFocus = false;
        s_JDialog_MouseInside = false;
        eventMask = 56L;
        s_PropertyChangeSupport = new SinglePropertyChangeSupport(PlayRemoteActions.class);
        s_KeyAdapter_Delayed = new KeyAdapter_Delayed(){
            int intKeyCode;
            RemoteAction o_RemoteAction;
            RemoteActionListener o_RemoteActionListener;

            @Override
            public void keyTyped_Delayed(KeyEvent e, int p_KeyClickCount) {
                e.consume();
            }

            @Override
            public void keyPressed_Delayed(KeyEvent e, int p_KeyClickCount) {
                if (!DOACTIONONPRESSED) {
                    return;
                }
                this.intKeyCode = e.getKeyCode();
                if (this.intKeyCode == 0) {
                    this.intKeyCode = KeyEventInterpreter.getRawCode(e);
                }
                e.consume();
                if (this.intKeyCode == 0) {
                    return;
                }
                if (this.intKeyCode == 144) {
                    return;
                }
                for (int intAction = 0; intAction < s_RemoteActionTableModel.size(); ++intAction) {
                    this.o_RemoteAction = (RemoteAction)s_RemoteActionTableModel.get(intAction);
                    if (this.o_RemoteAction == null) break;
                    if (this.o_RemoteAction.getKeyCode() != this.intKeyCode || this.o_RemoteAction.getKeyClickCount() != p_KeyClickCount) continue;
                    this.o_RemoteActionListener = this.o_RemoteAction.getRemoteActionListener();
                    if (this.o_RemoteActionListener == null) break;
                    PlayRemoteActions.doAction(this.o_RemoteActionListener, this.o_RemoteAction, -1.0);
                    break;
                }
            }

            @Override
            public void keyReleased_Delayed(KeyEvent e, int p_KeyClickCount) {
                if (DOACTIONONPRESSED) {
                    return;
                }
                this.intKeyCode = e.getKeyCode();
                if (this.intKeyCode == 0) {
                    this.intKeyCode = KeyEventInterpreter.getRawCode(e);
                }
                e.consume();
                if (this.intKeyCode == 0) {
                    return;
                }
                if (this.intKeyCode == 144) {
                    return;
                }
                for (int intAction = 0; intAction < s_RemoteActionTableModel.size(); ++intAction) {
                    this.o_RemoteAction = (RemoteAction)s_RemoteActionTableModel.get(intAction);
                    if (this.o_RemoteAction == null) break;
                    if (this.o_RemoteAction.getKeyCode() != this.intKeyCode || this.o_RemoteAction.getKeyClickCount() != p_KeyClickCount) continue;
                    this.o_RemoteActionListener = this.o_RemoteAction.getRemoteActionListener();
                    if (this.o_RemoteActionListener == null) break;
                    PlayRemoteActions.doAction(this.o_RemoteActionListener, this.o_RemoteAction, -1.0);
                    break;
                }
            }
        };
        s_MouseAdapter_Delayed = new MouseAdapter_Delayed(){
            RemoteAction o_RemoteAction;
            RemoteActionListener o_RemoteActionListener;

            @Override
            public void mousePressed_Delayed(MouseEvent e) {
                if (!DOACTIONONPRESSED) {
                    return;
                }
                for (int intAction = 0; intAction < s_RemoteActionTableModel.size(); ++intAction) {
                    this.o_RemoteAction = (RemoteAction)s_RemoteActionTableModel.get(intAction);
                    if (this.o_RemoteAction == null) break;
                    if (this.o_RemoteAction.getMouseButton() != e.getButton() || this.o_RemoteAction.getMouseClickCount() != e.getClickCount()) continue;
                    this.o_RemoteActionListener = this.o_RemoteAction.getRemoteActionListener();
                    if (this.o_RemoteActionListener == null) break;
                    PlayRemoteActions.doAction(this.o_RemoteActionListener, this.o_RemoteAction, -1.0);
                    break;
                }
                e.consume();
            }

            @Override
            public void mouseReleased_Delayed(MouseEvent e) {
                if (DOACTIONONPRESSED) {
                    return;
                }
                for (int intAction = 0; intAction < s_RemoteActionTableModel.size(); ++intAction) {
                    this.o_RemoteAction = (RemoteAction)s_RemoteActionTableModel.get(intAction);
                    if (this.o_RemoteAction == null) break;
                    if (this.o_RemoteAction.getMouseButton() != e.getButton() || this.o_RemoteAction.getMouseClickCount() != e.getClickCount()) continue;
                    this.o_RemoteActionListener = this.o_RemoteAction.getRemoteActionListener();
                    if (this.o_RemoteActionListener == null) break;
                    PlayRemoteActions.doAction(this.o_RemoteActionListener, this.o_RemoteAction, -1.0);
                    break;
                }
                e.consume();
            }

            @Override
            public void mouseClicked_Delayed(MouseEvent e) {
                e.consume();
            }

            @Override
            public void mouseEntered_Delayed(MouseEvent e) {
            }

            @Override
            public void mouseExited_Delayed(MouseEvent e) {
            }
        };
        s_SyncWriteIni = new Object();
        s_ExportedSourceIDs = new ArrayList();
        s_GlassPane_Translucent = new GlassPane_Translucent();
    }

    public static class GlassPane_Translucent
    extends JComponent {
        protected Color m_Background = new Color(0.6f, 0.5f, 0.5f, 0.5f);
        protected Rectangle m_Bounds = new Rectangle();

        public void setGlassBackground(Color p_Color) {
            if (p_Color == null) {
                return;
            }
            this.m_Background = p_Color;
        }

        public Color getGlassBackground() {
            return this.m_Background;
        }

        @Override
        public void paintComponent(Graphics g) {
            Rectangle rect = this.getBounds(this.m_Bounds);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(this.m_Background);
            g2d.fillRect(rect.x, rect.y, rect.width, rect.height);
        }
    }

    public static class RemoteActionTableCellRenderer_SourceName
    extends TableAndListModel.TableCellEditorRenderer_String {
        private static final Border DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(2, 2, 2, 2);
        protected Border m_NoFocusBorder = DEFAULT_NO_FOCUS_BORDER;
        protected Border m_FailureBorder = new LineBorder(Color.ORANGE, 2);
        private Color m_UnselectedForeground;
        private Color m_UnselectedBackground;

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            RemoteAction o_RemoteAction = null;
            JLabel o_JLabel = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            try {
                int intRowModel = table.convertRowIndexToModel(row);
                o_RemoteAction = (RemoteAction)((RemoteActionTableModel)((Object)table.getModel())).get(intRowModel);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (o_RemoteAction != null) {
                o_JLabel.setIcon(o_RemoteAction.getIcon());
            } else {
                this.setIcon(null);
            }
            return o_JLabel;
        }
    }

    public static class RemoteActionRowFilter
    extends RowFilter<RemoteAction, Integer> {
        private RemoteActionTableModel m_RemoteActionTableModel;
        private String m_FilterString;

        public RemoteActionRowFilter(RemoteActionTableModel p_RemoteActionTableModel) {
            this.initMembers();
            this.m_RemoteActionTableModel = p_RemoteActionTableModel;
        }

        private void initMembers() {
            this.m_FilterString = null;
        }

        public void setFilterString(String p_FilterString) {
            this.m_FilterString = p_FilterString == null ? PlayRemoteActions.ACTIONGROUP_GLOBAL : p_FilterString.toLowerCase();
            if (this.m_RemoteActionTableModel != null) {
                this.m_RemoteActionTableModel.fireTableDataChanged();
            }
        }

        @Override
        public boolean include(RowFilter.Entry entry) {
            if (this.m_RemoteActionTableModel == null) {
                return false;
            }
            if (this.m_FilterString == null) {
                return true;
            }
            if (this.m_FilterString.length() <= 0) {
                return true;
            }
            int intRow = (Integer)entry.getIdentifier();
            RemoteAction o_RemoteAction = (RemoteAction)this.m_RemoteActionTableModel.get(intRow);
            if (o_RemoteAction == null) {
                return false;
            }
            if (o_RemoteAction.getSourceName().toLowerCase().contains(this.m_FilterString)) {
                return true;
            }
            if (o_RemoteAction.getActionGroupName().toLowerCase().contains(this.m_FilterString)) {
                return true;
            }
            return o_RemoteAction.getActionName().toLowerCase().contains(this.m_FilterString);
        }
    }

    public static class RemoteActionTableModel
    extends TableAndListModel<RemoteAction> {
        public static final int COLUMNCOUNT = 6;
        public static final int COLUMNINDEX_ACTIONGROUP = 0;
        public static final int COLUMNINDEX_SOURCENAME = 1;
        public static final int COLUMNINDEX_ACTIONNAME = 2;
        public static final int COLUMNINDEX_MOUSEEVENT = 3;
        public static final int COLUMNINDEX_KEYEVENT = 4;
        public static final int COLUMNINDEX_DMXEVENT = 5;
        @LiveLanguageString
        public static String COLUMN_ACTIONGROUP = "Group";
        @LiveLanguageString
        public static String COLUMN_SOURCENAME = "Name";
        @LiveLanguageString
        public static String COLUMN_ACTIONNAME = "Action";
        @LiveLanguageString
        public static String COLUMN_MOUSEEVENT = "Mouse";
        @LiveLanguageString
        public static String COLUMN_KEYEVENT = "Key";
        @LiveLanguageString
        public static String COLUMN_DMXEVENT = "DMX";
        private TableRowSorter m_TableRowSorter;
        private RemoteActionRowFilter m_RemoteActionRowFilter;
        private final Object m_SyncObject = new Object();

        public RemoteActionTableModel() {
            super(false);
            PlayRemoteActions.loadLanguage();
            this.initMembers();
            LiveLanguage.addLanguageListener((Object)this, null);
        }

        private void initMembers() {
            this.m_RemoteActionRowFilter = new RemoteActionRowFilter(this);
            this.m_TableRowSorter = new TableRowSorter<RemoteActionTableModel>(this);
        }

        public void finishJTable(JTable p_JTable) {
            RemoteActionTableCellRenderer_SourceName o_TableCellEditorRenderer_String;
            if (p_JTable == null) {
                return;
            }
            super.finishJTable(p_JTable, this.m_TableRowSorter, (RowFilter)this.m_RemoteActionRowFilter);
            TableColumnModel o_TableColumnModel = p_JTable.getColumnModel();
            TableColumn o_TableColumn = o_TableColumnModel.getColumn(1);
            if (o_TableColumn != null) {
                o_TableColumn.setPreferredWidth(150);
                o_TableCellEditorRenderer_String = new RemoteActionTableCellRenderer_SourceName();
                o_TableCellEditorRenderer_String.setHorizontalAlignment(10);
                o_TableCellEditorRenderer_String.setToolTipText_Automatic(1);
                o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
                o_TableColumn.setCellEditor((TableCellEditor)((Object)o_TableCellEditorRenderer_String));
                o_TableColumn.setCellRenderer((TableCellRenderer)((Object)o_TableCellEditorRenderer_String));
            }
            if ((o_TableColumn = o_TableColumnModel.getColumn(0)) != null) {
                o_TableColumn.setPreferredWidth(80);
                o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
                o_TableCellEditorRenderer_String.setHorizontalAlignment(10);
                o_TableCellEditorRenderer_String.setToolTipText_Automatic(1);
                o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
                o_TableColumn.setCellEditor((TableCellEditor)((Object)o_TableCellEditorRenderer_String));
                o_TableColumn.setCellRenderer((TableCellRenderer)((Object)o_TableCellEditorRenderer_String));
            }
            if ((o_TableColumn = o_TableColumnModel.getColumn(2)) != null) {
                o_TableColumn.setPreferredWidth(60);
                o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
                o_TableCellEditorRenderer_String.setHorizontalAlignment(10);
                o_TableCellEditorRenderer_String.setToolTipText_Automatic(1);
                o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
                o_TableColumn.setCellEditor((TableCellEditor)((Object)o_TableCellEditorRenderer_String));
                o_TableColumn.setCellRenderer((TableCellRenderer)((Object)o_TableCellEditorRenderer_String));
            }
            if ((o_TableColumn = o_TableColumnModel.getColumn(5)) != null) {
                o_TableColumn.setPreferredWidth(60);
                o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
                o_TableCellEditorRenderer_String.setHorizontalAlignment(10);
                o_TableCellEditorRenderer_String.setToolTipText_Automatic(1);
                o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
                o_TableColumn.setCellEditor((TableCellEditor)((Object)o_TableCellEditorRenderer_String));
                o_TableColumn.setCellRenderer((TableCellRenderer)((Object)o_TableCellEditorRenderer_String));
            }
            if ((o_TableColumn = o_TableColumnModel.getColumn(4)) != null) {
                o_TableColumn.setPreferredWidth(70);
                o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
                o_TableCellEditorRenderer_String.setHorizontalAlignment(10);
                o_TableCellEditorRenderer_String.setToolTipText_Automatic(1);
                o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
                o_TableColumn.setCellEditor((TableCellEditor)((Object)o_TableCellEditorRenderer_String));
                o_TableColumn.setCellRenderer((TableCellRenderer)((Object)o_TableCellEditorRenderer_String));
            }
            if ((o_TableColumn = o_TableColumnModel.getColumn(3)) != null) {
                o_TableColumn.setPreferredWidth(60);
                o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
                o_TableCellEditorRenderer_String.setHorizontalAlignment(10);
                o_TableCellEditorRenderer_String.setToolTipText_Automatic(1);
                o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
                o_TableColumn.setCellEditor((TableCellEditor)((Object)o_TableCellEditorRenderer_String));
                o_TableColumn.setCellRenderer((TableCellRenderer)((Object)o_TableCellEditorRenderer_String));
            }
            p_JTable.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(RemoteAction p_RemoteAction) {
            boolean boolAdded;
            if (p_RemoteAction == null) {
                return false;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                boolAdded = super.add((Object)p_RemoteAction);
            }
            if (boolAdded) {
                this.resortRemoteAction(p_RemoteAction, true);
            }
            return boolAdded;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.m_SyncObject;
            synchronized (object) {
                super.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void resortRemoteAction(RemoteAction p_RemoteAction, boolean p_Add) {
            RemoteAction o_RemoteActionSelected;
            int intPositionAdd = -1;
            Object object = this.m_SyncObject;
            synchronized (object) {
                int intAction;
                o_RemoteActionSelected = this.getSelectedRemoteAction(s_PlayRemoteActionConfiguration);
                this.clearSelected(s_PlayRemoteActionConfiguration);
                int intRow = this.indexOf(p_RemoteAction);
                if (intRow >= 0) {
                    p_Add = false;
                } else if (!p_Add) {
                    return;
                }
                block15: for (intAction = 0; intAction < this.size(); ++intAction) {
                    RemoteAction o_RemoteAction = (RemoteAction)this.get(intAction);
                    if (o_RemoteAction == null || o_RemoteAction == p_RemoteAction) continue;
                    switch (p_RemoteAction.getActionGroupID()) {
                        case "": {
                            if (o_RemoteAction.getActionGroupID().equals(PlayRemoteActions.ACTIONGROUP_GLOBAL)) continue block15;
                            intPositionAdd = intAction;
                            break;
                        }
                        case "JingleGroup": {
                            if (o_RemoteAction.getActionGroupID().equals(PlayRemoteActions.ACTIONGROUP_GLOBAL)) continue block15;
                            if (!o_RemoteAction.getActionGroupID().equals(PlayRemoteActions.ACTIONGROUP_JINGLEGROUP)) {
                                intPositionAdd = intAction;
                                break;
                            }
                            if (o_RemoteAction.getSourceName().compareTo(p_RemoteAction.getSourceName()) < 0) continue block15;
                            if (o_RemoteAction.getSourceName().equals(p_RemoteAction.getSourceName()) && o_RemoteAction.getSourceID().equals(p_RemoteAction.getSourceID())) {
                                if (o_RemoteAction.getActionName().compareTo(p_RemoteAction.getActionName()) < 0) continue block15;
                                intPositionAdd = intAction;
                                break;
                            }
                            intPositionAdd = intAction;
                            break;
                        }
                        case "Jingle": {
                            if (o_RemoteAction.getActionGroupID().equals(PlayRemoteActions.ACTIONGROUP_GLOBAL) || o_RemoteAction.getActionGroupID().equals(PlayRemoteActions.ACTIONGROUP_JINGLEGROUP)) continue block15;
                            if (!o_RemoteAction.getActionGroupID().equals(PlayRemoteActions.ACTIONGROUP_JINGLE)) {
                                intPositionAdd = intAction;
                                break;
                            }
                            if (o_RemoteAction.getSourceName().compareTo(p_RemoteAction.getSourceName()) < 0) continue block15;
                            if (o_RemoteAction.getSourceName().equals(p_RemoteAction.getSourceName()) && o_RemoteAction.getSourceID().equals(p_RemoteAction.getSourceID())) {
                                if (o_RemoteAction.getActionName().compareTo(p_RemoteAction.getActionName()) < 0) continue block15;
                                intPositionAdd = intAction;
                                break;
                            }
                            intPositionAdd = intAction;
                            break;
                        }
                        case "SceneBridge": 
                        case "MainBridge": {
                            if (o_RemoteAction.getActionGroupID().equals(PlayRemoteActions.ACTIONGROUP_GLOBAL) || o_RemoteAction.getActionGroupID().equals(PlayRemoteActions.ACTIONGROUP_JINGLEGROUP) || o_RemoteAction.getActionGroupID().equals(PlayRemoteActions.ACTIONGROUP_JINGLE)) continue block15;
                            if (!o_RemoteAction.getActionGroupID().equals(PlayRemoteActions.ACTIONGROUP_MAINBRIDGE) && !o_RemoteAction.getActionGroupID().equals(PlayRemoteActions.ACTIONGROUP_SCENEBRIDGE)) {
                                intPositionAdd = intAction;
                                break;
                            }
                            if (o_RemoteAction.getSourcePosition() < p_RemoteAction.getSourcePosition()) continue block15;
                            intPositionAdd = intAction;
                        }
                    }
                    if (intPositionAdd >= 0) break;
                }
                if (intPositionAdd < 0) {
                    intPositionAdd = intAction;
                }
                if (p_Add) {
                    this.add(intPositionAdd, p_RemoteAction);
                } else if (intRow >= 0 && intRow != intPositionAdd) {
                    this.remove(intRow);
                    if (intRow < intPositionAdd) {
                        --intPositionAdd;
                    }
                    this.add(intPositionAdd, p_RemoteAction);
                }
            }
            this.setSelected(s_PlayRemoteActionConfiguration, o_RemoteActionSelected);
        }

        public void changed(RemoteAction p_RemoteAction, boolean p_Resort) {
            if (p_RemoteAction == null) {
                return;
            }
            this.changedElement(p_RemoteAction);
            if (p_Resort) {
                this.resortRemoteAction(p_RemoteAction, false);
            }
        }

        public void setSelected(PlayRemoteActionConfiguration p_PlayRemoteActionConfiguration, RemoteAction p_RemoteAction) {
            if (p_PlayRemoteActionConfiguration == null) {
                return;
            }
            JTable o_JTable = p_PlayRemoteActionConfiguration.getJTable();
            if (o_JTable == null) {
                return;
            }
            if (p_RemoteAction == null) {
                return;
            }
            this.setSelectedElement(o_JTable, p_RemoteAction);
        }

        public RemoteAction getSelectedRemoteAction(PlayRemoteActionConfiguration p_PlayRemoteActionConfiguration) {
            if (p_PlayRemoteActionConfiguration == null) {
                return null;
            }
            return p_PlayRemoteActionConfiguration.getSelectedRemoteAction();
        }

        public void removeSelected(PlayRemoteActionConfiguration p_PlayRemoteActionConfiguration, RemoteAction p_RemoteAction) {
            if (p_PlayRemoteActionConfiguration == null) {
                return;
            }
            JTable o_JTable = p_PlayRemoteActionConfiguration.getJTable();
            if (o_JTable == null) {
                return;
            }
            if (p_RemoteAction == null) {
                return;
            }
            this.removeSelectedElement(o_JTable, p_RemoteAction);
        }

        public void clearSelected(PlayRemoteActionConfiguration p_PlayRemoteActionConfiguration) {
            if (p_PlayRemoteActionConfiguration == null) {
                return;
            }
            JTable o_JTable = p_PlayRemoteActionConfiguration.getJTable();
            if (o_JTable == null) {
                return;
            }
            this.clearSelection(o_JTable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RemoteAction get(String p_SourceID, String p_ActionID) {
            if (p_SourceID == null) {
                return null;
            }
            if (p_ActionID == null) {
                return null;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                for (int intAction = 0; intAction < this.size(); ++intAction) {
                    RemoteAction o_RemoteAction = (RemoteAction)this.get(intAction);
                    if (!p_SourceID.equals(o_RemoteAction.getSourceID()) || !p_ActionID.equals(o_RemoteAction.getActionID())) continue;
                    return o_RemoteAction;
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RemoteAction getRemoteAction_MouseEvent(int p_MouseButton, int p_ClickCount) {
            if (p_MouseButton <= 0 || p_ClickCount <= 0) {
                return null;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                for (int intAction = 0; intAction < this.size(); ++intAction) {
                    RemoteAction o_RemoteAction = (RemoteAction)this.get(intAction);
                    if (o_RemoteAction == null || o_RemoteAction.getMouseButton() != p_MouseButton || o_RemoteAction.getMouseClickCount() != p_ClickCount) continue;
                    return o_RemoteAction;
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RemoteAction getRemoteAction_KeyEvent(int p_KeyCode, int p_ClickCount) {
            if (p_KeyCode <= 0) {
                return null;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                for (int intAction = 0; intAction < this.size(); ++intAction) {
                    RemoteAction o_RemoteAction = (RemoteAction)this.get(intAction);
                    if (o_RemoteAction == null || o_RemoteAction.getKeyCode() != p_KeyCode || o_RemoteAction.getKeyClickCount() != p_ClickCount) continue;
                    return o_RemoteAction;
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RemoteAction getRemoteAction_DMXEvent(String p_DMXUniverseID, int p_DMXChannel) {
            if (p_DMXUniverseID == null || p_DMXChannel < 0) {
                return null;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                for (int intAction = 0; intAction < this.size(); ++intAction) {
                    RemoteAction o_RemoteAction = (RemoteAction)this.get(intAction);
                    if (o_RemoteAction == null || !p_DMXUniverseID.equals(o_RemoteAction.getDMXUniverseID()) || o_RemoteAction.getDMXChannel() != p_DMXChannel) continue;
                    return o_RemoteAction;
                }
                return null;
            }
        }

        public int getColumnCount() {
            return 6;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return COLUMN_ACTIONGROUP;
                }
                case 1: {
                    return COLUMN_SOURCENAME;
                }
                case 2: {
                    return COLUMN_ACTIONNAME;
                }
                case 3: {
                    return COLUMN_MOUSEEVENT;
                }
                case 4: {
                    return COLUMN_KEYEVENT;
                }
                case 5: {
                    return COLUMN_DMXEVENT;
                }
            }
            return PlayRemoteActions.ACTIONGROUP_GLOBAL;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getValue(RemoteAction p_RemoteAction, int columnIndex) {
            String stringValue = PlayRemoteActions.ACTIONGROUP_GLOBAL;
            StringBuilder o_StringBuilder = new StringBuilder();
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_RemoteAction == null) {
                    return PlayRemoteActions.ACTIONGROUP_GLOBAL;
                }
                switch (columnIndex) {
                    case 0: {
                        stringValue = p_RemoteAction.getActionGroupName();
                        break;
                    }
                    case 1: {
                        stringValue = p_RemoteAction.getSourceName();
                        break;
                    }
                    case 2: {
                        stringValue = p_RemoteAction.getActionName();
                        break;
                    }
                    case 3: {
                        o_StringBuilder.delete(0, o_StringBuilder.length());
                        if (p_RemoteAction.getMouseClickCount() <= 0 || p_RemoteAction.getMouseButton() <= 0) {
                            stringValue = PlayRemoteActions.ACTIONGROUP_GLOBAL;
                            break;
                        }
                        o_StringBuilder.append(p_RemoteAction.getMouseClickCount());
                        o_StringBuilder.append("x ");
                        o_StringBuilder.append(MOUSEBUTTON);
                        o_StringBuilder.append("_");
                        o_StringBuilder.append(p_RemoteAction.getMouseButton());
                        stringValue = o_StringBuilder.toString();
                        break;
                    }
                    case 4: {
                        o_StringBuilder.delete(0, o_StringBuilder.length());
                        int intKeyCode = p_RemoteAction.getKeyCode();
                        if (intKeyCode == 0) {
                            o_StringBuilder.append(PlayRemoteActions.ACTIONGROUP_GLOBAL);
                        } else {
                            o_StringBuilder.append(p_RemoteAction.getKeyClickCount());
                            o_StringBuilder.append("x ");
                            String stringKeyText = KeyEvent.getKeyText(intKeyCode);
                            if (stringKeyText.contains("0x")) {
                                stringKeyText = PlayRemoteActions.ACTIONGROUP_GLOBAL;
                            }
                            o_StringBuilder.append(intKeyCode);
                            if (stringKeyText.length() > 0) {
                                o_StringBuilder.append(" (");
                                o_StringBuilder.append(stringKeyText);
                                o_StringBuilder.append(")");
                            }
                        }
                        stringValue = o_StringBuilder.toString();
                        break;
                    }
                    case 5: {
                        o_StringBuilder.delete(0, o_StringBuilder.length());
                        int intChannel = p_RemoteAction.getDMXChannel();
                        RemoteActionTrigger o_RemoteActionTrigger = p_RemoteAction.getDMXRemoteActionTrigger();
                        if (intChannel < 0 || o_RemoteActionTrigger == null) {
                            o_StringBuilder.append(PlayRemoteActions.ACTIONGROUP_GLOBAL);
                        } else {
                            o_StringBuilder.append(intChannel + 1);
                            o_StringBuilder.append(" - ");
                            o_StringBuilder.append(o_RemoteActionTrigger.getName());
                        }
                        stringValue = o_StringBuilder.toString();
                    }
                }
                return stringValue;
            }
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public void setValue(RemoteAction p_RemoteAction, Object value, int col) {
        }

        public void filter(String p_FilterString) {
            if (this.m_RemoteActionRowFilter == null) {
                return;
            }
            this.m_RemoteActionRowFilter.setFilterString(p_FilterString);
        }
    }

    public static class RemoteAction
    implements Externalizable {
        public static final int SOFTWAREVERSION = 3;
        public static final String PROP_DMXEVENT = "propDmxEvent";
        public static final String PROP_REMOTESOURCE = "propRemoteSource";
        private RemoteActionListener m_RemoteActionListener;
        private ImageIcon m_Icon;
        private String m_ActionGroupID;
        private String m_ActionID;
        private String m_SourceName;
        private String m_SourceID;
        private long m_SourcePosition;
        private int m_MouseButton;
        private int m_MouseClickCount;
        private int m_KeyCode;
        private int m_KeyClickCount;
        private String m_DMXUniverseID;
        private int m_DMXChannel;
        private boolean m_DMXChannelArmed;
        private double m_DMXValue_Old;

        public RemoteAction() {
            this.initMembers();
        }

        public RemoteAction(RemoteActionListener p_RemoteActionListener, ImageIcon p_Icon, String p_ActionGroupID, String p_ActionID, String p_SourceID, String p_SourceName, long p_SourcePosition) {
            this.initMembers();
            this.m_RemoteActionListener = p_RemoteActionListener;
            this.m_Icon = p_Icon;
            this.m_ActionID = p_ActionID;
            this.m_ActionGroupID = p_ActionGroupID;
            this.m_SourceID = p_SourceID;
            this.m_SourceName = p_SourceName;
            this.m_SourcePosition = p_SourcePosition;
            PlayRemoteActions.addRemoteAction(this);
        }

        private void initMembers() {
            this.m_RemoteActionListener = null;
            this.m_ActionGroupID = PlayRemoteActions.ACTIONGROUP_GLOBAL;
            this.m_ActionID = PlayRemoteActions.ACTIONGROUP_GLOBAL;
            this.m_SourceName = PlayRemoteActions.ACTIONGROUP_GLOBAL;
            this.m_SourceID = PlayRemoteActions.ACTIONGROUP_GLOBAL;
            this.m_SourcePosition = 0L;
            this.m_MouseButton = 0;
            this.m_MouseClickCount = 0;
            this.m_KeyCode = 0;
            this.m_KeyClickCount = 1;
            this.m_DMXUniverseID = null;
            this.m_DMXChannel = -1;
            this.m_DMXChannelArmed = false;
            this.m_DMXValue_Old = 0.0;
        }

        public void close() {
            PlayRemoteActions.removeRemoteAction(this);
            this.m_MouseButton = 0;
            this.m_MouseClickCount = 0;
            this.m_KeyCode = 0;
            this.m_KeyClickCount = 1;
            this.m_DMXUniverseID = null;
            this.m_DMXChannel = -1;
            this.m_RemoteActionListener = null;
        }

        public void setRemoteActionListener(RemoteActionListener p_RemoteActionListener) {
            if (p_RemoteActionListener == null) {
                return;
            }
            if (this.m_RemoteActionListener == p_RemoteActionListener) {
                return;
            }
            this.m_RemoteActionListener = p_RemoteActionListener;
            s_RemoteActionTableModel.changed(this, true);
        }

        public RemoteActionListener getRemoteActionListener() {
            return this.m_RemoteActionListener;
        }

        public void setIcon(ImageIcon p_ImageIcon) {
            this.m_Icon = p_ImageIcon;
            s_RemoteActionTableModel.changed(this, false);
        }

        public ImageIcon getIcon() {
            return this.m_Icon;
        }

        public boolean setActionGroupID(String p_ActionGroup) {
            if (p_ActionGroup == null) {
                return false;
            }
            if (p_ActionGroup.equals(this.m_ActionGroupID)) {
                return false;
            }
            this.m_ActionGroupID = p_ActionGroup;
            s_RemoteActionTableModel.changed(this, true);
            return true;
        }

        public String getActionGroupID() {
            return this.m_ActionGroupID;
        }

        public boolean setActionID(String p_ActionName) {
            if (p_ActionName == null) {
                return false;
            }
            if (p_ActionName.equals(this.m_ActionID)) {
                return false;
            }
            this.m_ActionID = p_ActionName;
            s_RemoteActionTableModel.changed(this, false);
            return true;
        }

        public String getActionID() {
            return this.m_ActionID;
        }

        public String getActionGroupName() {
            if (PlayRemoteActions.ACTIONGROUP_GLOBAL.equals(this.m_ActionGroupID)) {
                return PlayRemoteActions.ACTIONGROUP_GLOBAL;
            }
            if (PlayRemoteActions.ACTIONGROUP_JINGLE.equals(this.m_ActionGroupID)) {
                return ACTIONGROUPNAME_JINGLE;
            }
            if (PlayRemoteActions.ACTIONGROUP_JINGLEGROUP.equals(this.m_ActionGroupID)) {
                return ACTIONGROUPNAME_JINGLEGROUP;
            }
            if (PlayRemoteActions.ACTIONGROUP_MAINBRIDGE.equals(this.m_ActionGroupID)) {
                return LiveShowSceneBridgeMain.s_MainBridgeRemoteGroupName;
            }
            if (PlayRemoteActions.ACTIONGROUP_SCENEBRIDGE.equals(this.m_ActionGroupID)) {
                if (this.m_RemoteActionListener == null) {
                    return PlayRemoteActions.ACTIONGROUP_GLOBAL;
                }
                LiveShowSceneBridge o_LiveShowSceneBridge = (LiveShowSceneBridge)this.getRemoteActionListener();
                return o_LiveShowSceneBridge.getRemoteGroupName();
            }
            return PlayRemoteActions.ACTIONGROUP_GLOBAL;
        }

        public String getActionName() {
            if (PlayRemoteActions.ACTIONID_OBJECT_PLAY.equals(this.m_ActionID)) {
                return ACTIONNAME_PLAY;
            }
            if (PlayRemoteActions.ACTIONID_OBJECT_PLAYSTOP.equals(this.m_ActionID)) {
                return ACTIONNAME_PLAYSTOP;
            }
            if (PlayRemoteActions.ACTIONID_OBJECT_PLAYPAUSE.equals(this.m_ActionID)) {
                return ACTIONNAME_PLAYPAUSE;
            }
            if (PlayRemoteActions.ACTIONID_OBJECT_FADEINOUT.equals(this.m_ActionID)) {
                return ACTIONNAME_FADEINOUT;
            }
            if (PlayRemoteActions.ACTIONID_OBJECT_PLAYFADEOUT.equals(this.m_ActionID)) {
                return ACTIONNAME_PLAYFADEOUT;
            }
            if (PlayRemoteActions.ACTIONID_OBJECT_FADE.equals(this.m_ActionID)) {
                return ACTIONNAME_FADE;
            }
            if (PlayRemoteActions.ACTIONID_OBJECT_UP.equals(this.m_ActionID)) {
                return ACTIONNAME_UP;
            }
            if (PlayRemoteActions.ACTIONID_OBJECT_DOWN.equals(this.m_ActionID)) {
                return ACTIONNAME_DOWN;
            }
            return PlayRemoteActions.ACTIONGROUP_GLOBAL;
        }

        public boolean setSourceName(String p_SourceName) {
            if (p_SourceName == null) {
                return false;
            }
            if (p_SourceName.equals(this.m_SourceName)) {
                return false;
            }
            String stringOldSourceName = this.m_SourceName;
            this.m_SourceName = p_SourceName;
            s_RemoteActionTableModel.changed(this, true);
            PlayRemoteActions.notifyRemoteActionChanged(PROP_REMOTESOURCE, this);
            return true;
        }

        public String getSourceName() {
            return this.m_SourceName;
        }

        public boolean setSourceID(String p_SourceID) {
            if (p_SourceID == null) {
                return false;
            }
            if (p_SourceID.equals(this.m_SourceID)) {
                return false;
            }
            this.m_SourceID = p_SourceID;
            s_RemoteActionTableModel.changed(this, false);
            return true;
        }

        public String getSourceID() {
            return this.m_SourceID;
        }

        public boolean setSourcePosition(long p_SourcePosition) {
            if (p_SourcePosition < 0L) {
                return false;
            }
            if (p_SourcePosition == this.m_SourcePosition) {
                return false;
            }
            this.m_SourcePosition = p_SourcePosition;
            s_RemoteActionTableModel.changed(this, true);
            return true;
        }

        public long getSourcePosition() {
            return this.m_SourcePosition;
        }

        public boolean setMouseEvent(int p_MouseButton, int p_ClickCount) {
            if (this.m_MouseButton == p_MouseButton && this.m_MouseClickCount == p_ClickCount) {
                return false;
            }
            if (PlayRemoteActions.ACTIONID_OBJECT_FADE.equals(this.m_ActionID)) {
                return false;
            }
            this.m_MouseButton = p_MouseButton;
            this.m_MouseClickCount = p_ClickCount;
            s_RemoteActionTableModel.changed(this, false);
            PlayRemoteActions.checkMouseEvents(this, true);
            return true;
        }

        public boolean setMouseButton(int p_MouseButton) {
            if (this.m_MouseButton == p_MouseButton) {
                return false;
            }
            if (PlayRemoteActions.ACTIONID_OBJECT_FADE.equals(this.m_ActionID)) {
                return false;
            }
            this.m_MouseButton = p_MouseButton;
            s_RemoteActionTableModel.changed(this, false);
            return true;
        }

        public int getMouseButton() {
            return this.m_MouseButton;
        }

        public boolean setMouseClickCount(int p_MouseClickCount) {
            if (this.m_MouseClickCount == p_MouseClickCount) {
                return false;
            }
            if (PlayRemoteActions.ACTIONID_OBJECT_FADE.equals(this.m_ActionID)) {
                return false;
            }
            this.m_MouseClickCount = p_MouseClickCount;
            s_RemoteActionTableModel.changed(this, false);
            return true;
        }

        public int getMouseClickCount() {
            return this.m_MouseClickCount;
        }

        public boolean setKeyEvent(int p_KeyCode, int p_KeyClickCount) {
            if (this.m_KeyCode == p_KeyCode && this.m_KeyClickCount == p_KeyClickCount) {
                return false;
            }
            if (PlayRemoteActions.ACTIONID_OBJECT_FADE.equals(this.m_ActionID)) {
                return false;
            }
            this.m_KeyCode = p_KeyCode;
            this.m_KeyClickCount = p_KeyClickCount;
            s_RemoteActionTableModel.changed(this, false);
            PlayRemoteActions.checkKeyEvents(this, true);
            return true;
        }

        public boolean setKeyCode(int p_KeyCode) {
            if (this.m_KeyCode == p_KeyCode) {
                return false;
            }
            if (PlayRemoteActions.ACTIONID_OBJECT_FADE.equals(this.m_ActionID)) {
                return false;
            }
            this.m_KeyCode = p_KeyCode;
            s_RemoteActionTableModel.changed(this, false);
            return true;
        }

        public int getKeyCode() {
            return this.m_KeyCode;
        }

        public boolean setKeyClickCount(int p_KeyClickCount) {
            if (this.m_KeyClickCount == p_KeyClickCount) {
                return false;
            }
            if (PlayRemoteActions.ACTIONID_OBJECT_FADE.equals(this.m_ActionID)) {
                return false;
            }
            this.m_KeyClickCount = p_KeyClickCount;
            s_RemoteActionTableModel.changed(this, false);
            return true;
        }

        public int getKeyClickCount() {
            return this.m_KeyClickCount;
        }

        public boolean setDMXEvent(String p_DMXUniverseID, int p_DMXChannel) {
            if (p_DMXUniverseID == null || p_DMXChannel < 0) {
                p_DMXUniverseID = null;
                p_DMXChannel = -1;
            }
            if (this.getDMXRemoteActionTrigger() == PlayRemoteActions.getRemoteActionTrigger_DMX(p_DMXUniverseID) && this.m_DMXChannel == p_DMXChannel) {
                return false;
            }
            this.m_DMXUniverseID = p_DMXUniverseID;
            this.m_DMXChannel = p_DMXChannel;
            s_RemoteActionTableModel.changed(this, false);
            PlayRemoteActions.notifyRemoteActionChanged(PROP_DMXEVENT, this);
            PlayRemoteActions.checkDMXEvents(this, true);
            this.m_DMXValue_Old = 0.0;
            return true;
        }

        public boolean setDMXRemoteActionTrigger(RemoteActionTrigger p_RemoteActionTrigger, int p_DMXChannel) {
            if (p_RemoteActionTrigger == null || p_DMXChannel < 0) {
                p_RemoteActionTrigger = null;
                p_DMXChannel = -1;
            }
            if (this.getDMXRemoteActionTrigger() == p_RemoteActionTrigger && this.m_DMXChannel == p_DMXChannel) {
                return false;
            }
            this.m_DMXUniverseID = p_RemoteActionTrigger == null ? null : p_RemoteActionTrigger.getID();
            this.m_DMXChannel = p_DMXChannel;
            s_RemoteActionTableModel.changed(this, false);
            PlayRemoteActions.notifyRemoteActionChanged(PROP_DMXEVENT, this);
            this.m_DMXValue_Old = 0.0;
            return true;
        }

        public String getDMXUniverseID() {
            return this.m_DMXUniverseID;
        }

        public RemoteActionTrigger getDMXRemoteActionTrigger() {
            return PlayRemoteActions.getRemoteActionTrigger_DMX(this.m_DMXUniverseID);
        }

        public int getDMXChannel() {
            return this.m_DMXChannel;
        }

        public void setDMXChannelArmed(boolean p_Armed) {
            this.m_DMXChannelArmed = false;
        }

        public void eventDMXValue(RemoteActionTrigger p_RemoteActionTrigger, int p_FirstChangedChannel, int[] p_DMXValues) {
            if (p_RemoteActionTrigger == null) {
                return;
            }
            if (PlayRemoteActions.ACTIONID_OBJECT_FADE.equals(this.m_ActionID)) {
                if (s_SearchingDMXRemaoteAction) {
                    PlayRemoteActionConfiguration.getSelfReference().searchDMXRemoteAction(this.m_DMXUniverseID, this.m_DMXChannel);
                } else if (s_LearningDMXRemoteAction != null) {
                    this.setDMXEvent(p_RemoteActionTrigger.getID(), p_FirstChangedChannel);
                } else if (this.getDMXRemoteActionTrigger() == p_RemoteActionTrigger) {
                    int intDMXChannel = this.getDMXChannel();
                    if (intDMXChannel < 0 || intDMXChannel >= p_DMXValues.length) {
                        return;
                    }
                    double doubleDMXValue = p_DMXValues[intDMXChannel];
                    if (doubleDMXValue == this.m_DMXValue_Old) {
                        return;
                    }
                    this.m_DMXValue_Old = doubleDMXValue;
                    RemoteActionListener o_RemoteActionListener = this.getRemoteActionListener();
                    if (o_RemoteActionListener != null) {
                        PlayRemoteActions.doAction(o_RemoteActionListener, this, doubleDMXValue / 255.0);
                    }
                }
                return;
            }
            if (s_SearchingDMXRemaoteAction) {
                PlayRemoteActionConfiguration.getSelfReference().searchDMXRemoteAction(this.m_DMXUniverseID, this.m_DMXChannel);
            } else if (s_LearningDMXRemoteAction != null) {
                this.setDMXEvent(p_RemoteActionTrigger.getID(), p_FirstChangedChannel);
            } else {
                int intDMXChannel = this.getDMXChannel();
                if (intDMXChannel < 0 || intDMXChannel >= p_DMXValues.length) {
                    return;
                }
                double doubleDMXValue = p_DMXValues[intDMXChannel];
                if (doubleDMXValue == this.m_DMXValue_Old) {
                    return;
                }
                this.m_DMXValue_Old = doubleDMXValue;
                if (doubleDMXValue < 128.0) {
                    this.m_DMXChannelArmed = true;
                } else {
                    RemoteActionListener o_RemoteActionListener;
                    if (this.m_DMXChannelArmed && this.getDMXRemoteActionTrigger() == p_RemoteActionTrigger && (o_RemoteActionListener = this.getRemoteActionListener()) != null) {
                        PlayRemoteActions.doAction(o_RemoteActionListener, this, doubleDMXValue / 255.0);
                    }
                    this.m_DMXChannelArmed = false;
                }
            }
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(3);
            out.writeUTF(this.m_ActionGroupID);
            out.writeUTF(this.m_ActionID);
            out.writeUTF(this.m_SourceID);
            out.writeInt(this.m_MouseButton);
            out.writeInt(this.m_MouseClickCount);
            out.writeInt(this.m_KeyCode);
            out.writeInt(this.m_KeyClickCount);
            if (this.m_DMXUniverseID == null) {
                out.writeUTF(PlayRemoteActions.ACTIONGROUP_GLOBAL);
            } else {
                out.writeUTF(this.m_DMXUniverseID);
            }
            out.writeInt(this.m_DMXChannel);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int intSOftwareVersion = in.readInt();
            this.m_ActionGroupID = in.readUTF();
            this.m_ActionID = in.readUTF();
            this.m_SourceID = in.readUTF();
            if (ACTIONGROUPNAME_GLOBAL.equals(this.m_ActionGroupID)) {
                in.readInt();
                in.readInt();
                in.readInt();
                if (intSOftwareVersion >= 3) {
                    in.readInt();
                }
            } else {
                this.m_MouseButton = in.readInt();
                this.m_MouseClickCount = in.readInt();
                this.m_KeyCode = in.readInt();
                this.m_KeyClickCount = intSOftwareVersion >= 3 ? in.readInt() : 1;
            }
            if (intSOftwareVersion >= 2) {
                this.m_DMXUniverseID = in.readUTF();
                if (this.m_DMXUniverseID.length() <= 0) {
                    this.m_DMXUniverseID = null;
                }
                this.m_DMXChannel = in.readInt();
            }
        }
    }

    public static class RemoteActionSettingsPanel
    extends JPanel {
        private JButton jButton_Settings;

        public RemoteActionSettingsPanel() {
            this.initComponentsFurther();
            LiveLanguage.addLanguageListener(this, null);
        }

        private void initComponentsFurther() {
            this.setOpaque(false);
            this.setLayout(new GridBagLayout());
            this.jButton_Settings = new JButton();
            this.jButton_Settings.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit.png")));
            this.jButton_Settings.setText("Mouse and keyboard remote settings");
            this.jButton_Settings.setHorizontalAlignment(0);
            this.jButton_Settings.setContentAreaFilled(false);
            MouseAdapter o_MouseAdapter = new MouseAdapter(){
                LineBorder o_FocusBorder = new LineBorder(Color.BLUE, 1);

                @Override
                public void mousePressed(MouseEvent e) {
                    e.consume();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.getButton() != 1) {
                        return;
                    }
                    e.consume();
                    s_PlayRemoteActionConfiguration.setVisible(true);
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    e.consume();
                }
            };
            this.jButton_Settings.addMouseListener(o_MouseAdapter);
            GridBagConstraints o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 0;
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.weightx = 1.0;
            o_GridBagConstraints.fill = 2;
            o_GridBagConstraints.anchor = 17;
            this.add((Component)this.jButton_Settings, o_GridBagConstraints);
            this.jButton_Settings.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        }
    }

    public static class RemoteGlobalStartPanel
    extends JPanel {
        private JButton jButton_StartGlobalEvents;

        public RemoteGlobalStartPanel() {
            this.initComponentsFurther();
            LiveLanguage.addLanguageListener(this, null);
        }

        private void initComponentsFurther() {
            this.setOpaque(false);
            this.setLayout(new GridBagLayout());
            this.jButton_StartGlobalEvents = new JButton();
            this.jButton_StartGlobalEvents.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Mouse.png")));
            this.jButton_StartGlobalEvents.setText("Start Remote Global");
            this.jButton_StartGlobalEvents.setHorizontalAlignment(0);
            this.jButton_StartGlobalEvents.setContentAreaFilled(false);
            MouseAdapter o_MouseAdapter = new MouseAdapter(){
                LineBorder o_FocusBorder = new LineBorder(Color.BLUE, 1);

                @Override
                public void mousePressed(MouseEvent e) {
                    e.consume();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.getButton() != 1) {
                        return;
                    }
                    e.consume();
                    PlayRemoteActions.startGlobalEvents();
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    e.consume();
                }
            };
            this.jButton_StartGlobalEvents.addMouseListener(o_MouseAdapter);
            GridBagConstraints o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 0;
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.weightx = 1.0;
            o_GridBagConstraints.fill = 2;
            o_GridBagConstraints.anchor = 17;
            this.add((Component)this.jButton_StartGlobalEvents, o_GridBagConstraints);
            this.jButton_StartGlobalEvents.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        }
    }

    public static interface RemoteActionListener {
        public void doAction(RemoteAction var1, double var2);
    }

    public static interface RemoteActionTrigger {
        public String getID();

        public String getName();
    }
}

