/*
 * Decompiled with CFR 0.152.
 */
package LiveShowPlayPackage;

import LiveShowPlayPackage.Play;
import LiveShowPlayPackage.PlayListener;
import LiveShowPlayPackage.PlaySceneBridgePanel;
import LiveShowPlayPackage.Playable;
import LiveShowVirtualPackage.LiveShowVIP;
import SwingToolTipPackage.PopUpToolTip;
import SynchronizationPackage.EventQueueHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class PlayControlTimePanel
extends JPanel
implements PlayListener,
ComponentListener {
    public static int BUTTONSIZE = 24;
    private Play m_Play;
    private Dimension m_Size;
    private boolean m_ActualScenebridgeVisible;
    private PlaySceneBridgePanel m_PlaySceneBridgePanel;
    private GridBagConstraints m_ConstraintsButton_PlaySceneBridgePanel;
    private boolean m_PlayButtonsVisible;
    private JLabel m_Button_PlayStart;
    private GridBagConstraints m_ConstraintsButton_PlayStart;
    private JLabel m_Button_PlayPause;
    private GridBagConstraints m_ConstraintsButton_PlayPause;
    private JLabel m_Label_PlayTime;
    private String m_PlayTime_String;
    private Dimension m_Old_m_Label_PlayTime_Size;
    private StringBuilder m_StringBuilderTime;
    private final Object m_SyncStingBuilder = new Object();
    private GridBagConstraints m_ConstraintsLabel_PlayTime;
    private long m_FramePlayCursor;
    private long m_FrameEditCursor;
    private boolean m_FontResizable;
    private int m_OriginFontSize;
    private Runnable m_Runnable_TimeEditCursor = new Runnable(){

        @Override
        public void run() {
            try {
                PlayControlTimePanel.this.m_Label_PlayTime.setText(PlayControlTimePanel.this.m_PlayTime_String);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    };
    private Runnable m_Runnable_TimePlayCursor = new Runnable(){

        @Override
        public void run() {
            try {
                PlayControlTimePanel.this.m_Label_PlayTime.setText(PlayControlTimePanel.this.m_PlayTime_String);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    };

    public PlayControlTimePanel() {
        this(null, false, false);
    }

    public PlayControlTimePanel(Play p_Play, boolean p_PlayButtonVisible, boolean p_ActualSceneBridgeVisible) {
        this.initMembers();
        this.m_PlayButtonsVisible = p_PlayButtonVisible;
        this.m_ActualScenebridgeVisible = p_ActualSceneBridgeVisible;
        this.initComponents();
        this.setPlay(p_Play);
        this.calculateFont();
    }

    private void initMembers() {
        this.m_StringBuilderTime = new StringBuilder();
        this.m_PlayTime_String = "";
        this.m_PlayButtonsVisible = false;
        this.m_ActualScenebridgeVisible = false;
        this.m_Old_m_Label_PlayTime_Size = new Dimension(0, 0);
        this.m_OriginFontSize = 24;
        this.m_FontResizable = true;
    }

    private void initComponents() {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.m_PlaySceneBridgePanel = new PlaySceneBridgePanel();
        this.m_PlaySceneBridgePanel.setPreferredSize(new Dimension(50, 20));
        this.m_ConstraintsButton_PlaySceneBridgePanel = new GridBagConstraints();
        this.m_ConstraintsButton_PlaySceneBridgePanel.gridx = 0;
        this.m_ConstraintsButton_PlaySceneBridgePanel.gridy = 0;
        this.m_ConstraintsButton_PlaySceneBridgePanel.insets = new Insets(3, 3, 3, 3);
        this.m_ConstraintsButton_PlaySceneBridgePanel.gridwidth = 2;
        this.m_ConstraintsButton_PlaySceneBridgePanel.weightx = 1.0;
        this.m_ConstraintsButton_PlaySceneBridgePanel.fill = 2;
        this.add((Component)this.m_PlaySceneBridgePanel, this.m_ConstraintsButton_PlaySceneBridgePanel);
        if (!this.m_ActualScenebridgeVisible) {
            this.m_PlaySceneBridgePanel.setVisible(false);
            this.m_Size = new Dimension(80, 32);
        } else {
            this.m_PlaySceneBridgePanel.setVisible(true);
            this.m_Size = new Dimension(80, 56);
        }
        this.m_Button_PlayStart = new JLabel();
        this.m_Button_PlayStart.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/PlayStart24.png")));
        this.m_Button_PlayStart.setBorder(null);
        this.m_Button_PlayStart.setPreferredSize(new Dimension(BUTTONSIZE + 2, BUTTONSIZE + 2));
        this.m_Button_PlayStart.setMaximumSize(new Dimension(BUTTONSIZE + 2, BUTTONSIZE + 2));
        this.m_Button_PlayStart.setOpaque(false);
        this.m_Button_PlayStart.setVisible(true);
        this.m_Button_PlayStart.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                PlayControlTimePanel.this.actionPlayStart();
            }
        });
        this.m_ConstraintsButton_PlayStart = new GridBagConstraints();
        this.m_ConstraintsButton_PlayStart.gridx = 0;
        this.m_ConstraintsButton_PlayStart.gridy = 1;
        this.m_ConstraintsButton_PlayStart.fill = 0;
        this.add((Component)this.m_Button_PlayStart, this.m_ConstraintsButton_PlayStart);
        this.m_Button_PlayPause = new JLabel();
        this.m_Button_PlayPause.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/PlayPause24.png")));
        this.m_Button_PlayPause.setBorder(null);
        this.m_Button_PlayPause.setPreferredSize(new Dimension(BUTTONSIZE + 2, BUTTONSIZE + 2));
        this.m_Button_PlayPause.setMaximumSize(new Dimension(BUTTONSIZE + 2, BUTTONSIZE + 2));
        this.m_Button_PlayPause.setOpaque(false);
        this.m_Button_PlayPause.setVisible(false);
        this.m_Button_PlayPause.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                PlayControlTimePanel.this.actionPlayPause();
            }
        });
        this.m_ConstraintsButton_PlayPause = new GridBagConstraints();
        this.m_ConstraintsButton_PlayPause.gridx = 0;
        this.m_ConstraintsButton_PlayPause.gridy = 1;
        this.m_ConstraintsButton_PlayPause.fill = 0;
        this.add((Component)this.m_Button_PlayPause, this.m_ConstraintsButton_PlayPause);
        this.m_Label_PlayTime = new JLabel("-");
        this.m_Label_PlayTime.setFont(new Font("Tahoma", 0, this.m_OriginFontSize));
        this.m_Label_PlayTime.setBackground(Color.BLACK);
        this.m_Label_PlayTime.setForeground(Color.WHITE);
        this.m_Label_PlayTime.setOpaque(true);
        this.m_Label_PlayTime.setVerticalAlignment(0);
        this.m_Label_PlayTime.setHorizontalAlignment(0);
        this.m_Label_PlayTime.setVisible(true);
        this.m_ConstraintsLabel_PlayTime = new GridBagConstraints();
        this.m_ConstraintsLabel_PlayTime.gridx = 1;
        this.m_ConstraintsLabel_PlayTime.gridy = 1;
        this.m_ConstraintsLabel_PlayTime.weightx = 1.0;
        this.m_ConstraintsLabel_PlayTime.weighty = 1.0;
        this.m_ConstraintsLabel_PlayTime.insets = new Insets(1, 3, 3, 3);
        this.m_ConstraintsLabel_PlayTime.fill = 1;
        this.add((Component)this.m_Label_PlayTime, this.m_ConstraintsLabel_PlayTime);
        this.setPreferredSize(this.m_Size);
        this.m_Label_PlayTime.addComponentListener(this);
        this.calculateFont();
        this.m_Button_PlayPause.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.m_Button_PlayStart.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
    }

    public void close() {
        this.m_Button_PlayPause.setComponentPopupMenu(null);
        this.m_Button_PlayStart.setComponentPopupMenu(null);
        EventQueueHandler.removeRunnable(this.m_Runnable_TimeEditCursor);
        EventQueueHandler.removeRunnable(this.m_Runnable_TimePlayCursor);
        this.m_PlaySceneBridgePanel.close();
        this.m_Label_PlayTime.removeComponentListener(this);
        if (this.m_Play != null) {
            this.m_Play.removePlayListener(this);
        }
    }

    public void setPlay(Play p_Play) {
        if (this.m_Play == p_Play) {
            return;
        }
        if (this.m_Play != null) {
            this.m_Play.removePlayListener(this);
            this.m_Play = null;
        }
        if (p_Play != null) {
            this.m_Play = p_Play;
            this.m_Play.addPlayListener(this);
            this.m_FramePlayCursor = this.m_Play.getPlayCursor();
            this.calculateTime_PlayCursor();
            this.m_Label_PlayTime.setForeground(p_Play.getColor());
            if (p_Play.getPlayable() instanceof LiveShowVIP) {
                this.m_PlaySceneBridgePanel.setLiveShowVIP((LiveShowVIP)p_Play.getPlayable());
            }
        }
        this.refreshPlayStatus();
    }

    public Play getPlay() {
        return this.m_Play;
    }

    private String calculateTime_PlayCursor() {
        return this.calculateTime(this.m_FramePlayCursor);
    }

    private String calculateTime_EditCursor() {
        return this.calculateTime(this.m_FrameEditCursor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String calculateTime(long p_Frame) {
        Playable o_Playable = null;
        Object object = this.m_SyncStingBuilder;
        synchronized (object) {
            this.m_StringBuilderTime.delete(0, this.m_StringBuilderTime.length());
            Play o_Play = this.m_Play;
            if (o_Play != null) {
                o_Playable = o_Play.getPlayable();
            }
            if (o_Play == null || o_Playable == null) {
                return "-";
            }
            double doubleMilliSeconds = (double)p_Frame * o_Playable.getFrameTime();
            if (doubleMilliSeconds < 0.0) {
                this.m_StringBuilderTime.append("-");
                doubleMilliSeconds *= -1.0;
                return this.m_StringBuilderTime.toString();
            }
            int intHours = (int)(doubleMilliSeconds / 3600000.0);
            int intMinutes = (int)((doubleMilliSeconds -= (double)(intHours * 3600000)) / 60000.0);
            int intSeconds = (int)((doubleMilliSeconds -= (double)(intMinutes * 60000)) / 1000.0);
            int intMilliseconds = (int)(doubleMilliSeconds -= (double)(intSeconds * 1000));
            this.m_StringBuilderTime.delete(0, this.m_StringBuilderTime.length());
            if (intHours < 10) {
                this.m_StringBuilderTime.append("0");
            }
            this.m_StringBuilderTime.append(intHours);
            this.m_StringBuilderTime.append(":");
            if (intMinutes < 10) {
                this.m_StringBuilderTime.append("0");
            }
            this.m_StringBuilderTime.append(intMinutes);
            this.m_StringBuilderTime.append(":");
            if (intSeconds < 10) {
                this.m_StringBuilderTime.append("0");
            }
            this.m_StringBuilderTime.append(intSeconds);
            this.m_StringBuilderTime.append(":");
            intMilliseconds = (int)((double)intMilliseconds / 100.0);
            this.m_StringBuilderTime.append(intMilliseconds);
            return this.m_StringBuilderTime.toString();
        }
    }

    public void setPlayButtonsVisible(boolean p_Visible) {
        this.refreshPlayStatus();
    }

    private void actionPlayStart() {
        Play o_Play = this.m_Play;
        if (o_Play == null) {
            return;
        }
        if (o_Play.getStatus() == 9) {
            return;
        }
        if (o_Play.getStatus() == 3 || o_Play.getStatus() == 2) {
            return;
        }
        Play.PlaySynchronisizer o_PlaySynchronisizer = o_Play.getPlaySynchronizer();
        if (o_PlaySynchronisizer != null) {
            o_PlaySynchronisizer.addPlayTriggerStart(o_Play);
            o_Play.start();
        }
    }

    private void actionPlayPause() {
        Play.PlaySynchronisizer o_PlaySynchronisizer;
        Play o_Play = this.m_Play;
        if (o_Play == null) {
            return;
        }
        if (o_Play.getStatus() == 9) {
            return;
        }
        if (o_Play.isRunning() && (o_PlaySynchronisizer = o_Play.getPlaySynchronizer()) != null) {
            o_PlaySynchronisizer.addPlayTriggerStop(o_Play);
        }
        o_Play.pause();
    }

    private void refreshPlayStatus() {
        Play o_Play = this.m_Play;
        if (!this.m_PlayButtonsVisible || o_Play == null) {
            this.m_Button_PlayStart.setVisible(false);
            this.m_Button_PlayPause.setVisible(false);
        } else if (o_Play.isRunning()) {
            this.m_Button_PlayStart.setVisible(false);
            this.m_Button_PlayPause.setVisible(true);
        } else {
            this.m_Button_PlayStart.setVisible(true);
            this.m_Button_PlayPause.setVisible(false);
        }
    }

    @Override
    public void eventPlayStart(Play p_Play) {
        this.refreshPlayStatus();
    }

    @Override
    public void eventPlayStop(Play p_Play) {
        this.refreshPlayStatus();
    }

    @Override
    public void eventPlayPause(Play p_Play) {
        this.refreshPlayStatus();
    }

    @Override
    public void eventPlayRewind(Play p_Play) {
    }

    @Override
    public void eventPlayFastForward(Play p_Play) {
    }

    @Override
    public void eventPlayFadePossibility(Play p_Play, boolean p_FadeInPossible, boolean p_FadeOutPossible, double p_FadeProgress) {
    }

    @Override
    public void eventPlayFadedIn(Play p_Play, boolean p_FadedIn, double p_FadeProgress) {
    }

    @Override
    public void eventPlayCursorSet(Play p_Play, long p_PlayCursor) {
    }

    @Override
    public void eventEditModeOn(Play p_Play, boolean p_EditModeOn) {
        if (p_Play == null) {
            return;
        }
        Play o_Play = this.m_Play;
        if (p_EditModeOn) {
            this.m_Label_PlayTime.setForeground(Color.RED);
            this.m_FrameEditCursor = p_Play.getEditCursor();
            this.m_Label_PlayTime.setText(this.calculateTime_EditCursor());
        } else {
            if (o_Play != null) {
                this.m_Label_PlayTime.setForeground(o_Play.getColor());
            }
            this.m_FramePlayCursor = p_Play.getPlayCursor();
            this.m_Label_PlayTime.setText(this.calculateTime_PlayCursor());
        }
    }

    @Override
    public void eventEditCursorSet(Play p_Play, long p_EditCursor) {
        if (!p_Play.getEditModeOn()) {
            return;
        }
        if (this.m_FrameEditCursor == p_EditCursor) {
            return;
        }
        this.m_FrameEditCursor = p_EditCursor;
        this.m_PlayTime_String = this.calculateTime_EditCursor();
        if (this.m_Label_PlayTime != null && !this.m_PlayTime_String.equals(this.m_Label_PlayTime.getText())) {
            EventQueueHandler.invokeLater(this.m_Runnable_TimeEditCursor);
        }
    }

    @Override
    public long eventPlayCheckRead(Play p_Play, long p_FrameStart, long p_FramesToRead) {
        return p_FramesToRead;
    }

    @Override
    public void eventPlayCursor(Play p_Play, long p_OldPlayCursor, long p_PlayCursor) {
        if (p_Play.getEditModeOn()) {
            return;
        }
        if (this.m_FramePlayCursor == p_OldPlayCursor) {
            return;
        }
        this.m_FramePlayCursor = p_OldPlayCursor;
        this.m_PlayTime_String = this.calculateTime_PlayCursor();
        if (this.m_Label_PlayTime != null && !this.m_PlayTime_String.equals(this.m_Label_PlayTime.getText())) {
            EventQueueHandler.invokeLater(this.m_Runnable_TimePlayCursor);
        }
    }

    @Override
    public void eventPlayClosing(Play p_Play) {
    }

    @Override
    public void eventPlayError(Play p_Play, Exception p_Exception, String p_Remark) {
    }

    @Override
    public void eventPlayTimelineEnd(Play p_Play) {
    }

    public void setFontResizable(boolean p_Resizable) {
        if (this.m_FontResizable == p_Resizable) {
            return;
        }
        Font o_Font = this.m_Label_PlayTime.getFont();
        this.m_FontResizable = p_Resizable;
        this.m_FontResizable = false;
        if (false) {
            Font o_NewFont = o_Font.deriveFont(this.m_OriginFontSize);
            this.m_Label_PlayTime.setFont(o_NewFont);
        }
    }

    private void calculateFont() {
        if (!this.m_FontResizable) {
            return;
        }
        Font o_Font = this.m_Label_PlayTime.getFont();
        FontMetrics o_FontMetrics = this.m_Label_PlayTime.getFontMetrics(o_Font);
        int intFontWidth = o_FontMetrics.stringWidth("00:00:00:000");
        float floatWidth = this.m_Label_PlayTime.getWidth() - 2;
        float floatHeight = this.m_Label_PlayTime.getHeight();
        if (floatHeight == 0.0f || floatWidth == 0.0f || intFontWidth == 0) {
            return;
        }
        Font o_NewFont = o_Font.deriveFont(Math.min(floatWidth / (float)intFontWidth * (float)o_Font.getSize(), floatHeight));
        this.m_Label_PlayTime.setFont(o_NewFont);
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (e.getComponent() == this.m_Label_PlayTime) {
            boolean boolRecalculate = false;
            if (Math.abs((double)this.m_Label_PlayTime.getWidth() - this.m_Old_m_Label_PlayTime_Size.getWidth()) > 6.0) {
                boolRecalculate = true;
            }
            if (Math.abs((double)this.m_Label_PlayTime.getHeight() - this.m_Old_m_Label_PlayTime_Size.getHeight()) > 6.0) {
                boolRecalculate = true;
            }
            if (!boolRecalculate) {
                return;
            }
            this.m_Old_m_Label_PlayTime_Size = this.m_Label_PlayTime.getSize();
            this.calculateFont();
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }
}

