/*
 * Decompiled with CFR 0.152.
 */
package LiveShowObjectPackage;

import LiveShowObjectPackage.LiveShowDragDrop;
import LiveShowObjectPackage.LiveShowObject;
import LiveShowObjectPackage.LiveShowObjectDescription;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowObjectPackage.LiveShowObjectListener;
import LiveShowObjectPackage.LiveShowUndo;
import LiveShowScrollPackage.LiveShowViewListener;
import LiveShowVirtualPackage.LiveShowVIP;
import LiveShowVirtualPackage.LiveShowVIPPanel;
import LiveShowVirtualPackage.LiveShowVIPTrackPanel;
import SwingComponents.MouseAdapter_Delayed;
import SwingToolTipPackage.PopUpToolTip;
import SynchronizationPackage.EventQueueHandler;
import SynchronizationPackage.LiveCloseSemaphore;
import ToolsGraphics.GraphicsTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public abstract class LiveShowObjectPanel
extends JPanel
implements LiveShowObjectListener,
LiveShowViewListener,
PopUpToolTip.ComponentRightClickToolTip {
    protected LiveShowObjectInterface m_LiveShowObjectInterface;
    public static Color s_Color_Normal = new Color(255, 255, 0);
    public static Color s_Color_Jingle = Color.MAGENTA;
    public static Border s_Border_Normal = new LineBorder(s_Color_Normal, 1);
    public static Border s_Border_Jingle = new LineBorder(s_Color_Jingle, 1);
    protected Color m_ColorBackground_Transparent;
    protected Color m_ColorBackgroundSelected;
    protected Color m_ColorBackgroundSelected_Transparent;
    protected Color m_ColorForeground;
    protected Color m_ColorFill;
    protected Color m_ColorFill_Transparent;
    protected Color m_ColorOutline;
    protected Color m_ColorBorder;
    protected Color m_ColorBorderSelected;
    protected Border m_Border_Normal;
    protected Border m_Border_NormalJingle;
    protected Border m_Border_Selected;
    protected Border m_Border_Failure;
    protected Border m_Border_FailureSelected;
    protected boolean m_IsVisible;
    protected int m_VisibleStartX;
    protected int m_VisibleEndX;
    protected long m_VisibleFrameStart;
    protected long m_VisibleFrameEnd;
    protected long m_ContainerVisibleFrameStart;
    protected long m_ContainerVisibleFrameEnd;
    protected int m_ContainerViewWidth;
    protected int m_ContainerViewHeight;
    protected long m_ObjectStartFrame;
    protected long m_ObjectOffset;
    protected long m_ObjectFrameLength;
    protected boolean m_RedrawWidth;
    protected boolean m_RedrawHeight;
    protected AbsoluteConstraints m_AbsoluteConstraints;
    protected boolean m_IsSelected;
    protected boolean m_IsFailure;
    protected boolean m_MouseResizeEast;
    protected boolean m_MouseResizeWest;
    protected boolean m_IsResizable;
    protected LabelFade m_LabelFadeIn;
    protected LabelFade m_LabelFadeOut;
    protected LabelFade m_LabelFadeVolume;
    protected LabelFade m_LabelResizeWest;
    protected LabelFade m_LabelResizeEast;
    protected StringBuilder m_StringBuffer;
    protected LiveShowDragDrop.LiveShowGestureRecognizer m_GestureRecognizer;
    protected LiveCloseSemaphore m_LiveCloseSemaphore;
    protected final Object m_SyncPainting = new Object();
    protected long m_NewVisibleFrameStart;
    protected long m_NewVisibleFrameEnd;
    protected int m_NewWidth;
    protected int m_NewHeight;
    protected Font m_Font;
    private Rectangle m_RectSize;
    private Rectangle m_ExternalMouseBounds;
    private boolean m_ExternalMouseWasInside;
    protected String m_ToolTipText_RightClick;
    private Runnable m_RunnableRepaint;

    public LiveShowObjectPanel(LiveShowObjectInterface p_LiveShowObjectInterface, boolean p_Resizable) {
        this.initMembers();
        this.m_LiveShowObjectInterface = p_LiveShowObjectInterface;
        this.m_IsResizable = p_Resizable;
        this.m_LiveShowObjectInterface.addLiveShowObjectListener(this);
        this.m_ObjectStartFrame = p_LiveShowObjectInterface.getFrameStart();
        this.m_ObjectOffset = p_LiveShowObjectInterface.getFrameStartOffset();
        this.m_ObjectFrameLength = p_LiveShowObjectInterface.getFrameLength();
        this.initComponents();
    }

    private void initMembers() {
        this.m_LiveCloseSemaphore = new LiveCloseSemaphore(this.getClass().getSimpleName());
        this.m_StringBuffer = new StringBuilder();
        this.m_ContainerVisibleFrameStart = 0L;
        this.m_ContainerVisibleFrameEnd = 0L;
        this.m_ContainerViewWidth = 0;
        this.m_ContainerViewHeight = 0;
        this.m_ObjectStartFrame = 0L;
        this.m_ObjectOffset = 0L;
        this.m_ObjectFrameLength = 0L;
        this.m_RedrawWidth = false;
        this.m_RedrawHeight = false;
        this.m_VisibleFrameStart = 0L;
        this.m_VisibleFrameEnd = 0L;
        this.m_IsVisible = false;
        this.m_IsSelected = false;
        this.m_IsFailure = false;
        this.m_MouseResizeWest = false;
        this.m_MouseResizeEast = false;
        this.m_ColorFill = new Color(255, 200, 0);
        this.m_ColorFill_Transparent = GraphicsTools.newColorSave(this.m_ColorFill.getRed(), this.m_ColorFill.getGreen(), this.m_ColorFill.getBlue(), 200);
        this.m_ColorOutline = new Color(255, 50, 0);
        this.m_ColorBorder = s_Color_Normal;
        this.m_ColorBorderSelected = new Color(0, 0, 255);
        this.m_ColorForeground = new Color(255, 255, 255);
        this.m_ColorBackgroundSelected = new Color(0, 0, 255);
        this.m_RectSize = new Rectangle();
        this.m_Font = new Font("Times New Roman", 0, 16);
        this.m_RunnableRepaint = new Runnable(){

            @Override
            public void run() {
                LiveShowObjectPanel.this.revalidate();
                LiveShowObjectPanel.this.repaint();
            }
        };
    }

    private void initComponents() {
        LiveShowObjectInterface o_LiveShowObjectInterface = this.m_LiveShowObjectInterface;
        this.setLayout(new AbsoluteLayout());
        super.setOpaque(false);
        this.setDoubleBuffered(false);
        this.setBackground(new Color(100, 100, 100));
        this.setColorBackgroundSelected(this.m_ColorBackgroundSelected);
        this.setColorForegroud(this.m_ColorForeground);
        this.m_AbsoluteConstraints = new AbsoluteConstraints(0, 0, 0, 0);
        this.m_Border_Normal = s_Border_Normal;
        this.m_Border_NormalJingle = s_Border_Jingle;
        this.m_Border_Selected = new LineBorder(this.m_ColorBorderSelected, 1);
        this.m_Border_Failure = new LineBorder(Color.RED, 2);
        this.m_Border_FailureSelected = new CompoundBorder(this.m_Border_Selected, this.m_Border_Failure);
        if (this.m_IsResizable) {
            this.m_LabelResizeWest = new LabelFade(4);
            this.add((Component)this.m_LabelResizeWest, this.m_LabelResizeWest.getAbsoluteConstraints());
            this.m_LabelResizeEast = new LabelFade(5);
            this.add((Component)this.m_LabelResizeEast, this.m_LabelResizeEast.getAbsoluteConstraints());
        }
        if (o_LiveShowObjectInterface != null) {
            if (o_LiveShowObjectInterface.getDescription().getChangeable_Volume()) {
                this.m_LabelFadeVolume = new LabelFade(3);
                this.add(this.m_LabelFadeVolume, this.m_LabelFadeVolume.getAbsoluteConstraints(), 0);
            }
            if (o_LiveShowObjectInterface.getDescription().getChangeable_FadeOut()) {
                this.m_LabelFadeOut = new LabelFade(2);
                this.add(this.m_LabelFadeOut, this.m_LabelFadeOut.getAbsoluteConstraints(), 0);
            }
            if (o_LiveShowObjectInterface.getDescription().getChangeable_FadeIn()) {
                this.m_LabelFadeIn = new LabelFade(1);
                this.add(this.m_LabelFadeIn, this.m_LabelFadeIn.getAbsoluteConstraints(), 0);
            }
            this.m_IsSelected = o_LiveShowObjectInterface.getSelected();
        }
        this.createToolTipText();
        this.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.resetBorder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.m_LiveCloseSemaphore.enterCloseSection()) {
            return;
        }
        this.setComponentPopupMenu(null);
        Object object = this.m_SyncPainting;
        synchronized (object) {
            if (this.m_LiveShowObjectInterface != null) {
                this.m_LiveShowObjectInterface.removeLiveShowObjectListener(this);
                this.m_LiveShowObjectInterface = null;
            }
        }
        this.m_LiveCloseSemaphore.leaveCloseSection();
    }

    public LiveShowObjectInterface getLiveShowObjectInterface() {
        return this.m_LiveShowObjectInterface;
    }

    public String createToolTipText() {
        String stringToolTipText;
        this.setToolTipText(null);
        LiveShowObjectInterface o_LiveShowObjectInterface = this.m_LiveShowObjectInterface;
        if (o_LiveShowObjectInterface == null) {
            this.m_ToolTipText_RightClick = null;
            return null;
        }
        this.m_ToolTipText_RightClick = stringToolTipText = o_LiveShowObjectInterface.createToolTipText(true);
        return stringToolTipText;
    }

    public String getToolTipText_RightClick() {
        return this.createToolTipText();
    }

    public AbsoluteConstraints getAbsoluteConstraints() {
        return this.m_AbsoluteConstraints;
    }

    @Override
    public void setBackground(Color p_BackgroundColor) {
        super.setBackground(p_BackgroundColor);
        this.m_ColorBackground_Transparent = GraphicsTools.newColorSave(p_BackgroundColor.getRed(), p_BackgroundColor.getGreen(), p_BackgroundColor.getBlue(), 100);
    }

    public void setDirty() {
        this.m_RedrawWidth = true;
        if (!SwingUtilities.isEventDispatchThread()) {
            EventQueueHandler.invokeLater(this.m_RunnableRepaint);
        } else {
            this.repaint();
        }
    }

    public void setColorBackgroundSelected(Color p_Color) {
        this.m_ColorBackgroundSelected = p_Color;
        this.m_ColorBackgroundSelected_Transparent = GraphicsTools.newColorSave(this.m_ColorBackgroundSelected.getRed(), this.m_ColorBackgroundSelected.getGreen(), this.m_ColorBackgroundSelected.getBlue(), 100);
        if (this.m_IsSelected) {
            if (!SwingUtilities.isEventDispatchThread()) {
                EventQueueHandler.invokeLater(this.m_RunnableRepaint);
            } else {
                this.repaint();
            }
        }
    }

    public Color getColorBackgroundSelected() {
        return this.m_ColorBackgroundSelected;
    }

    public Color getColorBackgroundSelected_Transparent() {
        return this.m_ColorBackgroundSelected_Transparent;
    }

    public void setColorForegroud(Color p_Color) {
        if (p_Color == null) {
            return;
        }
        if (this.m_ColorForeground.equals(p_Color)) {
            return;
        }
        this.m_ColorForeground = p_Color;
        super.setForeground(this.m_ColorForeground);
        if (!SwingUtilities.isEventDispatchThread()) {
            EventQueueHandler.invokeLater(this.m_RunnableRepaint);
        } else {
            this.repaint();
        }
    }

    public Color getColorForeground() {
        return this.m_ColorForeground;
    }

    public void setColorFill(Color p_Color) {
        if (this.m_ColorFill.equals(p_Color)) {
            return;
        }
        this.m_ColorFill = p_Color;
        this.m_ColorFill_Transparent = GraphicsTools.newColorSave(this.m_ColorFill.getRed(), this.m_ColorFill.getGreen(), this.m_ColorFill.getBlue(), 200);
        if (!SwingUtilities.isEventDispatchThread()) {
            EventQueueHandler.invokeLater(this.m_RunnableRepaint);
        } else {
            this.repaint();
        }
    }

    public Color getColorFill() {
        return this.m_ColorFill;
    }

    public Color getColorFill_Transparent() {
        return this.m_ColorFill_Transparent;
    }

    public void setColorOutline(Color p_Color) {
        if (this.m_ColorOutline.equals(p_Color)) {
            return;
        }
        this.m_ColorOutline = p_Color;
        if (!SwingUtilities.isEventDispatchThread()) {
            EventQueueHandler.invokeLater(this.m_RunnableRepaint);
        } else {
            this.repaint();
        }
    }

    public Color getColorOutline() {
        return this.m_ColorOutline;
    }

    public void setColorBorder(Color p_Color) {
        if (this.m_ColorBorder.equals(p_Color)) {
            return;
        }
        this.m_ColorBorder = p_Color;
        this.m_Border_Normal = new LineBorder(this.m_ColorBorder, 1);
        this.resetBorder();
        if (!SwingUtilities.isEventDispatchThread()) {
            EventQueueHandler.invokeLater(this.m_RunnableRepaint);
        } else {
            this.repaint();
        }
    }

    public Color getColorBorder() {
        return this.m_ColorBorder;
    }

    public int getInsidePositionX(long p_Frame) {
        LiveShowObjectInterface o_LiveShowObjectInterface = this.m_LiveShowObjectInterface;
        if (o_LiveShowObjectInterface == null) {
            return 0;
        }
        int intX = this.getFramesPerPoint() == 0.0 ? 0 : (int)((double)(p_Frame - o_LiveShowObjectInterface.getFrameStartOffset()) / this.getFramesPerPoint());
        return intX;
    }

    public long getPositionFrame(int p_X) {
        LiveShowObjectInterface o_LiveShowObjectInterface = this.m_LiveShowObjectInterface;
        if (o_LiveShowObjectInterface == null) {
            return 0L;
        }
        int intWidth = this.m_AbsoluteConstraints.width;
        if (intWidth <= 0) {
            return 0L;
        }
        long longFrame = (long)((double)p_X * this.getFramesPerPoint()) + o_LiveShowObjectInterface.getFrameStartOffset();
        return longFrame;
    }

    public double getFramesPerPoint() {
        LiveShowObjectInterface o_LiveShowObjectInterface = this.m_LiveShowObjectInterface;
        if (o_LiveShowObjectInterface == null) {
            return 0.0;
        }
        int intWidth = this.m_AbsoluteConstraints.width;
        if (intWidth <= 0) {
            return 0.0;
        }
        return (double)o_LiveShowObjectInterface.getFrameLength() / (double)intWidth;
    }

    public boolean externalMouseSelect(int p_LastX, int p_LastY, int p_X, int p_Y) {
        int intTolerance = 2;
        this.m_ExternalMouseBounds = this.getBounds(this.m_ExternalMouseBounds);
        if (p_LastX > p_X) {
            int intLeftX = p_X;
            int intRightX = p_LastX;
        } else {
            int intLeftX = p_LastX;
            int intRightX = p_X;
        }
        if (p_LastY > p_Y) {
            int intLowerY = p_Y;
            int intUpperY = p_LastY;
        } else {
            int intLowerY = p_LastY;
            int intUpperY = p_Y;
        }
        if (!(p_LastX <= this.m_AbsoluteConstraints.x && p_X <= this.m_AbsoluteConstraints.x || p_LastX >= this.m_AbsoluteConstraints.x + this.m_ExternalMouseBounds.width && p_X >= this.m_AbsoluteConstraints.x + this.m_ExternalMouseBounds.width || p_LastY <= this.m_AbsoluteConstraints.y && p_Y <= this.m_AbsoluteConstraints.y || p_LastY >= this.m_AbsoluteConstraints.y + this.m_ExternalMouseBounds.height && p_Y >= this.m_AbsoluteConstraints.y + this.m_ExternalMouseBounds.height)) {
            if (this.m_ExternalMouseWasInside) {
                return false;
            }
            this.m_ExternalMouseWasInside = true;
            return true;
        }
        this.m_ExternalMouseWasInside = false;
        return false;
    }

    public void externalMouseReleased(int p_X, int p_Y) {
        this.m_ExternalMouseWasInside = false;
    }

    @Override
    public void eventViewChanged(long p_FrameStart, long p_FrameEnd, long p_VisibleFrameStart, long p_VisibleFrameEnd, Rectangle p_Bounds) {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.calculatePaint(p_VisibleFrameStart, p_VisibleFrameEnd, p_Bounds.width, p_Bounds.height);
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    @Override
    public void eventViewScrollAutomaticStart() {
    }

    @Override
    public void eventZoomPlus(boolean p_AdjustFramePosition, long p_FramePosition) {
    }

    @Override
    public void eventZoomMinus(boolean p_AdjustFramePosition, long p_FramePosition) {
    }

    @Override
    public void eventZoomReset() {
    }

    @Override
    public void eventObjectParameterChanged(LiveShowObjectInterface p_LiveShowObjectInterface, LiveShowObjectDescription p_LiveShowObjectDescription) {
        if (p_LiveShowObjectInterface == null) {
            return;
        }
        if (this.m_LiveShowObjectInterface != p_LiveShowObjectInterface) {
            return;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        if (this.m_ObjectStartFrame != p_LiveShowObjectDescription.getFrameStart() && (this.m_ObjectStartFrame <= this.m_ContainerVisibleFrameStart || this.m_ObjectStartFrame + p_LiveShowObjectDescription.getFrameLength() >= this.m_ContainerVisibleFrameEnd)) {
            this.m_RedrawWidth = true;
        }
        this.m_ObjectStartFrame = p_LiveShowObjectInterface.getFrameStart();
        if (this.m_ObjectOffset != p_LiveShowObjectDescription.getFrameStartOffset()) {
            this.m_RedrawWidth = true;
        }
        this.m_ObjectOffset = p_LiveShowObjectDescription.getFrameStartOffset();
        if (this.m_ObjectFrameLength != p_LiveShowObjectDescription.getFrameLength()) {
            this.m_RedrawWidth = true;
        }
        this.m_ObjectFrameLength = p_LiveShowObjectInterface.getFrameLength();
        this.calculatePaint(this.m_ContainerVisibleFrameStart, this.m_ContainerVisibleFrameEnd, this.m_ContainerViewWidth, this.m_ContainerViewHeight);
        this.createToolTipText();
        this.setSelected(p_LiveShowObjectInterface.getSelected());
        this.resetBorder();
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    @Override
    public void eventObjectVolumeChanged(LiveShowObjectInterface p_LiveShowObjectInterface, float p_Volume) {
    }

    @Override
    public void eventObjectClosed(LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (this.m_LiveShowObjectInterface != p_LiveShowObjectInterface) {
            return;
        }
    }

    @Override
    public void eventObjectSelection(LiveShowObjectInterface p_LiveShowObjectInterface, boolean p_IsSelected, boolean p_Added) {
        if (this.m_LiveShowObjectInterface != p_LiveShowObjectInterface) {
            return;
        }
        this.setSelected(p_IsSelected);
    }

    @Override
    public void eventObjectAdditionalChanged(LiveShowObjectInterface p_LiveShowObjectInterface, LiveShowObjectDescription p_LiveShowObjectDescription) {
        if (!SwingUtilities.isEventDispatchThread()) {
            EventQueueHandler.invokeLater(this.m_RunnableRepaint);
        } else {
            this.revalidate();
            this.repaint();
        }
    }

    public void resetBorder() {
        if (this.m_IsFailure) {
            if (this.m_IsSelected) {
                this.setBorder(this.m_Border_FailureSelected);
            } else {
                this.setBorder(this.m_Border_Failure);
            }
        } else if (!this.m_IsSelected) {
            if (this.m_LiveShowObjectInterface != null && this.m_LiveShowObjectInterface.getIsJingle()) {
                this.setBorder(this.m_Border_NormalJingle);
            } else {
                this.setBorder(this.m_Border_Normal);
            }
        } else {
            this.setBorder(this.m_Border_Selected);
        }
    }

    protected void setSelected(boolean p_Selected) {
        if (this.m_IsSelected == p_Selected) {
            return;
        }
        this.m_IsSelected = p_Selected;
        this.resetBorder();
        if (this.m_IsSelected) {
            this.m_LabelFadeVolume.setToolTipText(LiveShowObject.TOOLTIP_VOLUME_SELECTEDOBJECT);
        } else {
            this.m_LabelFadeVolume.setToolTipText(LiveShowObject.TOOLTIP_VOLUME);
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            EventQueueHandler.invokeLater(this.m_RunnableRepaint);
        } else {
            this.repaint();
        }
    }

    public boolean getSelected() {
        LiveShowObjectInterface o_LiveShowObjectInterface = this.m_LiveShowObjectInterface;
        if (o_LiveShowObjectInterface == null) {
            return false;
        }
        return o_LiveShowObjectInterface.getSelected();
    }

    public void setFailure(boolean p_Failure) {
        if (this.m_IsFailure == p_Failure) {
            return;
        }
        this.m_IsFailure = p_Failure;
        this.resetBorder();
        if (!SwingUtilities.isEventDispatchThread()) {
            EventQueueHandler.invokeLater(this.m_RunnableRepaint);
        } else {
            this.repaint();
        }
    }

    public boolean getFailure() {
        return this.m_IsFailure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void calculatePaint(long p_ViewVisibleFrameStart, long p_ViewVisibleFrameEnd, int p_ViewWidth, int p_ViewHeigth) {
        LiveShowObjectInterface o_LiveShowObjectInterface = this.m_LiveShowObjectInterface;
        if (o_LiveShowObjectInterface == null) {
            return;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        Object object = this.m_SyncPainting;
        synchronized (object) {
            if (this.m_ContainerVisibleFrameStart != p_ViewVisibleFrameStart) {
                this.m_RedrawWidth = true;
                this.m_ContainerVisibleFrameStart = p_ViewVisibleFrameStart;
            }
            if (this.m_ContainerVisibleFrameEnd != p_ViewVisibleFrameEnd) {
                this.m_RedrawWidth = true;
                this.m_ContainerVisibleFrameEnd = p_ViewVisibleFrameEnd;
            }
            if (this.m_ContainerViewWidth != p_ViewWidth) {
                this.m_RedrawWidth = true;
                this.m_ContainerViewWidth = p_ViewWidth;
            }
            if (this.m_ContainerViewHeight != p_ViewHeigth) {
                this.m_RedrawHeight = true;
                this.m_ContainerViewHeight = p_ViewHeigth;
            }
            if (this.m_ContainerViewWidth < 1 || this.m_ContainerViewHeight < 1) {
                this.m_LiveCloseSemaphore.leaveWorkerSection();
                return;
            }
            if (this.m_ContainerVisibleFrameEnd == this.m_ContainerVisibleFrameStart) {
                this.m_LiveCloseSemaphore.leaveWorkerSection();
                return;
            }
            double doubleFramesPerPoint = (double)(this.m_ContainerVisibleFrameEnd - this.m_ContainerVisibleFrameStart) / (double)this.m_ContainerViewWidth;
            if (this.m_RedrawHeight) {
                this.m_AbsoluteConstraints.height = this.m_ContainerViewHeight;
                this.m_AbsoluteConstraints.y = 0;
            }
            this.m_AbsoluteConstraints.width = (int)((double)o_LiveShowObjectInterface.getFrameLength() / doubleFramesPerPoint);
            if (this.m_AbsoluteConstraints.width < 3) {
                this.m_AbsoluteConstraints.width = 3;
            }
            this.m_AbsoluteConstraints.x = (int)((double)(o_LiveShowObjectInterface.getFrameStart() - this.m_ContainerVisibleFrameStart) / doubleFramesPerPoint);
            this.m_IsVisible = true;
            if (this.m_AbsoluteConstraints.x + this.m_AbsoluteConstraints.width < 0) {
                this.m_IsVisible = false;
            }
            if (this.m_AbsoluteConstraints.x > this.m_ContainerViewWidth) {
                this.m_IsVisible = false;
            }
            if (this.m_IsVisible) {
                this.m_VisibleStartX = this.m_AbsoluteConstraints.x < 0 ? 0 - this.m_AbsoluteConstraints.x : 0;
                this.m_VisibleEndX = this.m_AbsoluteConstraints.x + this.m_AbsoluteConstraints.width > this.m_ContainerViewWidth ? this.m_ContainerViewWidth - this.m_AbsoluteConstraints.x : this.m_AbsoluteConstraints.width;
                this.m_VisibleFrameStart = (long)((double)o_LiveShowObjectInterface.getFrameStartOffset() + (double)this.m_VisibleStartX * doubleFramesPerPoint);
                this.m_VisibleFrameEnd = (long)((double)o_LiveShowObjectInterface.getFrameStartOffset() + (double)this.m_VisibleEndX * doubleFramesPerPoint);
            }
            if (this.m_RedrawHeight || this.m_RedrawWidth) {
                // empty if block
            }
            if (o_LiveShowObjectInterface.getDescription().getChangeable_FadeIn()) {
                this.m_LabelFadeIn.calculatePosition();
            }
            if (o_LiveShowObjectInterface.getDescription().getChangeable_FadeOut()) {
                this.m_LabelFadeOut.calculatePosition();
            }
            if (o_LiveShowObjectInterface.getDescription().getChangeable_Volume()) {
                this.m_LabelFadeVolume.calculatePosition();
            }
            if (this.m_IsResizable) {
                this.m_LabelResizeWest.calculatePosition();
                this.m_LabelResizeEast.calculatePosition();
            }
            if (!SwingUtilities.isEventDispatchThread()) {
                EventQueueHandler.invokeLater(this.m_RunnableRepaint);
            } else {
                this.revalidate();
                this.repaint();
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    public void setGestureRecognizer(LiveShowDragDrop.LiveShowGestureRecognizer p_GestureRecognizer) {
        this.m_GestureRecognizer = p_GestureRecognizer;
    }

    public void removeGestureRecognizer() {
        if (this.m_GestureRecognizer != null) {
            this.m_GestureRecognizer.close();
            this.m_GestureRecognizer = null;
        }
    }

    public LiveShowDragDrop.LiveShowGestureRecognizer getGestureRecognizer() {
        return this.m_GestureRecognizer;
    }

    protected abstract void paintData(Graphics2D var1, int var2, int var3, int var4, int var5, long var6, long var8, boolean var10, boolean var11);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics p_Graphics) {
        Graphics2D g2d;
        if (p_Graphics == null) {
            return;
        }
        super.paintComponent(p_Graphics);
        LiveShowObjectInterface o_LiveShowObjectInterface = this.m_LiveShowObjectInterface;
        if (o_LiveShowObjectInterface == null) {
            return;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        Object object = this.m_SyncPainting;
        synchronized (object) {
            Rectangle2D o_RectangleString;
            if (!this.m_IsVisible) {
                return;
            }
            if (this.m_AbsoluteConstraints.height < 2 || this.m_AbsoluteConstraints.width < 2) {
                super.paintBorder(p_Graphics);
                return;
            }
            if (o_LiveShowObjectInterface == null) {
                return;
            }
            g2d = (Graphics2D)p_Graphics;
            this.m_RectSize.setBounds(this.m_VisibleStartX, 0, this.m_ContainerViewWidth, this.m_AbsoluteConstraints.height);
            Color o_ColorBackground = o_LiveShowObjectInterface.getSelected() ? this.m_ColorBackgroundSelected_Transparent : this.m_ColorBackground_Transparent;
            g2d.setColor(o_ColorBackground);
            g2d.fillRect(this.m_RectSize.x, this.m_RectSize.y, this.m_RectSize.width, this.m_RectSize.height);
            this.paintData(g2d, this.m_ContainerViewWidth, this.m_AbsoluteConstraints.height, this.m_VisibleStartX, this.m_VisibleEndX, this.m_VisibleFrameStart, this.m_VisibleFrameEnd, this.m_RedrawWidth, this.m_RedrawHeight);
            this.m_RedrawHeight = false;
            this.m_RedrawWidth = false;
            this.m_StringBuffer.delete(0, this.m_StringBuffer.length());
            if (o_LiveShowObjectInterface.getName() != null && o_LiveShowObjectInterface.getName().length() > 0) {
                this.m_StringBuffer.append(o_LiveShowObjectInterface.getName());
            }
            if (this.m_StringBuffer.length() > 0) {
                g2d.setColor(this.m_ColorForeground);
                g2d.setFont(this.m_Font);
                o_RectangleString = g2d.getFontMetrics().getStringBounds(this.m_StringBuffer.toString(), g2d);
                g2d.drawString(this.m_StringBuffer.toString(), (float)((double)this.m_VisibleStartX + ((double)(this.m_VisibleEndX - this.m_VisibleStartX) - o_RectangleString.getWidth()) / 2.0), (float)((double)(this.m_AbsoluteConstraints.getHeight() / 2) - o_RectangleString.getHeight() / 2.0));
            }
            this.m_StringBuffer.delete(0, this.m_StringBuffer.length());
            if (o_LiveShowObjectInterface.getEffectName() != null && o_LiveShowObjectInterface.getEffectName().length() > 0) {
                this.m_StringBuffer.append(o_LiveShowObjectInterface.getEffectName());
            }
            if (o_LiveShowObjectInterface.getSourceName() != null) {
                if (this.m_StringBuffer.length() > 0) {
                    this.m_StringBuffer.append(" / ");
                }
                this.m_StringBuffer.append(o_LiveShowObjectInterface.getSourceName());
            }
            if (this.m_StringBuffer.length() > 0) {
                g2d.setColor(this.m_ColorForeground);
                g2d.setFont(this.m_Font);
                o_RectangleString = g2d.getFontMetrics().getStringBounds(this.m_StringBuffer.toString(), g2d);
                g2d.drawString(this.m_StringBuffer.toString(), (float)((double)this.m_VisibleStartX + ((double)(this.m_VisibleEndX - this.m_VisibleStartX) - o_RectangleString.getWidth()) / 2.0), (float)((double)this.m_AbsoluteConstraints.getHeight() - o_RectangleString.getHeight() / 2.0));
            }
            g2d.setColor(this.m_ColorForeground);
            int intY = (int)((float)this.m_AbsoluteConstraints.height - (float)(this.m_AbsoluteConstraints.height / 2) * o_LiveShowObjectInterface.getVolumeFactor());
            int intFadeInX = this.getInsidePositionX(o_LiveShowObjectInterface.getFrameStartOffset() + o_LiveShowObjectInterface.getFrameFadeInLength());
            int intFadeOutX = this.getInsidePositionX(o_LiveShowObjectInterface.getFrameStartOffset() + o_LiveShowObjectInterface.getFrameLength() - o_LiveShowObjectInterface.getFrameFadeOutLength());
            if (o_LiveShowObjectInterface.getDescription().getChangeable_FadeIn()) {
                g2d.drawLine(this.getInsidePositionX(o_LiveShowObjectInterface.getFrameStartOffset()), this.m_AbsoluteConstraints.height, intFadeInX, intY);
            }
            if (o_LiveShowObjectInterface.getDescription().getChangeable_FadeOut()) {
                g2d.drawLine(intFadeOutX, intY, this.getInsidePositionX(o_LiveShowObjectInterface.getFrameStartOffset() + o_LiveShowObjectInterface.getFrameLength()), this.m_AbsoluteConstraints.height);
            }
            if (o_LiveShowObjectInterface.getDescription().getChangeable_Volume()) {
                g2d.drawLine(intFadeInX, intY, intFadeOutX, intY);
            }
        }
        if (!o_LiveShowObjectInterface.isEqualDefaultSettings()) {
            Stroke o_StrokeOld = g2d.getStroke();
            g2d.setStroke(LiveShowObjectDescription.s_BasicStroke_NotDefault);
            g2d.setColor(LiveShowObjectDescription.s_ColorNotDefault);
            int intWidth = this.m_AbsoluteConstraints.width;
            int intX = 0;
            g2d.drawRect(intX + 2, this.m_RectSize.y + 2, intWidth - 4, this.m_RectSize.height - 4);
            g2d.setStroke(o_StrokeOld);
        }
        super.paintBorder(p_Graphics);
    }

    public Component getComponentFrom_MousePosition(Point p_MousePosition) {
        Rectangle o_Rectangle = new Rectangle(0, 0, 0, 0);
        if ((o_Rectangle = this.m_LabelFadeIn.getBounds(o_Rectangle)).contains(p_MousePosition)) {
            return this.m_LabelFadeIn;
        }
        if ((o_Rectangle = this.m_LabelFadeOut.getBounds(o_Rectangle)).contains(p_MousePosition)) {
            return this.m_LabelFadeOut;
        }
        if ((o_Rectangle = this.m_LabelFadeVolume.getBounds(o_Rectangle)).contains(p_MousePosition)) {
            return this.m_LabelFadeVolume;
        }
        if ((o_Rectangle = this.m_LabelResizeEast.getBounds(o_Rectangle)).contains(p_MousePosition)) {
            return this.m_LabelResizeEast;
        }
        if ((o_Rectangle = this.m_LabelResizeWest.getBounds(o_Rectangle)).contains(p_MousePosition)) {
            return this.m_LabelResizeWest;
        }
        return this;
    }

    public LiveShowVIP getLiveShowVIP() {
        LiveShowVIP o_LiveShowVIP = null;
        LiveShowVIPPanel o_LiveShowVIPPanel = this.getLiveShowVIPPanel();
        if (o_LiveShowVIPPanel != null) {
            o_LiveShowVIP = o_LiveShowVIPPanel.getLiveShowVIP();
        }
        return o_LiveShowVIP;
    }

    public LiveShowVIPPanel getLiveShowVIPPanel() {
        LiveShowVIPPanel o_LiveShowVIPPanel = null;
        Container o_Container = this.getParent();
        if (o_Container == null) {
            return null;
        }
        if (o_Container instanceof LiveShowVIPTrackPanel) {
            o_LiveShowVIPPanel = ((LiveShowVIPTrackPanel)o_Container).getLiveShowVIPPanel();
        }
        return o_LiveShowVIPPanel;
    }

    public Cursor getCursor(int intX, int intY) {
        LiveShowVIP o_LiveShowVIP = this.getLiveShowVIP();
        if (o_LiveShowVIP == null) {
            return Cursor.getDefaultCursor();
        }
        switch (o_LiveShowVIP.getMouseCursorMode(intX, intY, this)) {
            case 1: {
                return LiveShowVIP.CURSOR_PLAYCURSOR;
            }
            case 2: {
                return LiveShowVIP.CURSOR_SELECTOBJECT;
            }
            case 3: {
                return LiveShowVIP.CURSOR_SELECTPLUS;
            }
            case 4: {
                return LiveShowVIP.CURSOR_SELECTMINUS;
            }
            case 5: {
                return LiveShowVIP.CURSOR_SELECTFROM;
            }
            case 6: {
                return LiveShowVIP.CURSOR_SELECTFROMPLUS;
            }
            case 7: {
                return LiveShowVIP.CURSOR_SELECTFROMMINUS;
            }
            case 8: {
                return LiveShowVIP.CURSOR_ZOOMPLUS;
            }
            case 9: {
                return LiveShowVIP.CURSOR_ZOOMMINUS;
            }
        }
        return Cursor.getDefaultCursor();
    }

    public class LabelFade
    extends JLabel {
        public int SIZE = 17;
        public static final int OVALSIZE = 13;
        private AbsoluteConstraints m_Constraints;
        private int m_FadeType;
        private MouseAdapter_Delayed m_MouseAdapter_Delayed;

        public LabelFade(int p_FadeType) {
            this.m_FadeType = p_FadeType;
            this.initComponents();
            this.addMouseMotionListener(this.m_MouseAdapter_Delayed);
            this.addMouseListener(this.m_MouseAdapter_Delayed);
        }

        private void initComponents() {
            this.createMouseAdapter_Delayed();
            this.m_Constraints = new AbsoluteConstraints(0, 0, 0, 0);
            switch (this.m_FadeType) {
                case 1: {
                    this.setCursor(Cursor.getPredefinedCursor(4));
                    this.setToolTipText(LiveShowObject.TOOLTIP_FADEIN);
                    break;
                }
                case 2: {
                    this.setCursor(Cursor.getPredefinedCursor(6));
                    this.setToolTipText(LiveShowObject.TOOLTIP_FADEOUT);
                    break;
                }
                case 3: {
                    this.setCursor(Cursor.getPredefinedCursor(8));
                    this.setToolTipText(LiveShowObject.TOOLTIP_VOLUME);
                    break;
                }
                case 4: {
                    this.setCursor(Cursor.getPredefinedCursor(10));
                    break;
                }
                case 5: {
                    this.setCursor(Cursor.getPredefinedCursor(11));
                }
            }
        }

        public void calculatePosition() {
            LiveShowObjectInterface o_LiveShowObjectInterface = LiveShowObjectPanel.this.m_LiveShowObjectInterface;
            if (o_LiveShowObjectInterface == null) {
                return;
            }
            this.m_Constraints.width = this.SIZE;
            this.m_Constraints.height = this.SIZE;
            int intY = (int)((float)LiveShowObjectPanel.this.m_AbsoluteConstraints.height - (float)(LiveShowObjectPanel.this.m_AbsoluteConstraints.height / 2) * o_LiveShowObjectInterface.getVolumeFactor());
            switch (this.m_FadeType) {
                case 1: {
                    this.m_Constraints.x = LiveShowObjectPanel.this.getInsidePositionX(o_LiveShowObjectInterface.getFrameStartOffset() + o_LiveShowObjectInterface.getFrameFadeInLength()) - this.SIZE / 2;
                    this.m_Constraints.y = intY - this.SIZE / 2;
                    break;
                }
                case 2: {
                    this.m_Constraints.x = LiveShowObjectPanel.this.getInsidePositionX(o_LiveShowObjectInterface.getFrameStartOffset() + o_LiveShowObjectInterface.getFrameLength() - o_LiveShowObjectInterface.getFrameFadeOutLength()) - this.SIZE / 2;
                    this.m_Constraints.y = intY - this.SIZE / 2;
                    break;
                }
                case 3: {
                    this.m_Constraints.x = LiveShowObjectPanel.this.getInsidePositionX(o_LiveShowObjectInterface.getFrameStartOffset() + o_LiveShowObjectInterface.getFrameFadeInLength() + (o_LiveShowObjectInterface.getFrameLength() - o_LiveShowObjectInterface.getFrameFadeOutLength() - o_LiveShowObjectInterface.getFrameFadeInLength()) / 2L) - this.SIZE / 2;
                    this.m_Constraints.y = intY - this.SIZE / 2;
                    break;
                }
                case 4: {
                    this.m_Constraints.x = LiveShowObjectPanel.this.getInsidePositionX(o_LiveShowObjectInterface.getFrameStartOffset());
                    this.m_Constraints.y = 0;
                    this.m_Constraints.height = LiveShowObjectPanel.this.m_AbsoluteConstraints.height / 2;
                    break;
                }
                case 5: {
                    this.m_Constraints.x = LiveShowObjectPanel.this.getInsidePositionX(o_LiveShowObjectInterface.getFrameStartOffset() + o_LiveShowObjectInterface.getFrameLength()) - this.SIZE;
                    this.m_Constraints.y = 0;
                    this.m_Constraints.height = LiveShowObjectPanel.this.m_AbsoluteConstraints.height / 2;
                }
            }
        }

        public AbsoluteConstraints getAbsoluteConstraints() {
            return this.m_Constraints;
        }

        @Override
        public void paintComponent(Graphics p_Graphics) {
            if (p_Graphics == null) {
                return;
            }
            Graphics2D o_Graphics2D = (Graphics2D)p_Graphics;
            Color o_OldColor = p_Graphics.getColor();
            switch (this.m_FadeType) {
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 7: {
                    o_Graphics2D.setColor(Color.BLACK);
                    o_Graphics2D.drawOval((this.SIZE - 13) / 2 + 1, (this.SIZE - 13) / 2 + 1, 12, 12);
                    o_Graphics2D.setColor(Color.WHITE);
                    o_Graphics2D.drawOval((this.SIZE - 13) / 2, (this.SIZE - 13) / 2, 12, 12);
                    if (!this.isOpaque()) break;
                    o_Graphics2D.fillOval((this.SIZE - 13) / 2, (this.SIZE - 13) / 2, 12, 12);
                    break;
                }
                default: {
                    super.paintComponent(p_Graphics);
                }
            }
            o_Graphics2D.setColor(o_OldColor);
            super.paintBorder(p_Graphics);
            p_Graphics.dispose();
        }

        public LiveShowVIP getLiveShowVIP() {
            LiveShowVIP o_LiveShowVIP = null;
            LiveShowVIPPanel o_LiveShowVIPPanel = this.getLiveShowVIPPanel();
            if (o_LiveShowVIPPanel != null) {
                o_LiveShowVIP = o_LiveShowVIPPanel.getLiveShowVIP();
            }
            return o_LiveShowVIP;
        }

        public LiveShowVIPPanel getLiveShowVIPPanel() {
            LiveShowVIPPanel o_LiveShowVIPPanel = null;
            Container o_Container = this.getParent();
            if (o_Container == null) {
                return null;
            }
            if ((o_Container = o_Container.getParent()) == null) {
                return null;
            }
            if (o_Container instanceof LiveShowVIPTrackPanel) {
                o_LiveShowVIPPanel = ((LiveShowVIPTrackPanel)o_Container).getLiveShowVIPPanel();
            }
            return o_LiveShowVIPPanel;
        }

        public void startUndoAction_Volume(int p_Action, String p_ActionString) {
            LiveShowObjectInterface o_LiveShowObjectInterface = LiveShowObjectPanel.this.m_LiveShowObjectInterface;
            if (o_LiveShowObjectInterface == null) {
                return;
            }
            if (!o_LiveShowObjectInterface.getSelected()) {
                this.startUndoAction(p_Action, p_ActionString);
                return;
            }
            LiveShowVIP o_LiveShowVIP = this.getLiveShowVIP();
            if (o_LiveShowVIP == null) {
                return;
            }
            o_LiveShowVIP.startUndoAction_VolumeChange(o_LiveShowObjectInterface, p_Action, p_ActionString);
        }

        public void startUndoAction(int p_Action, String p_ActionString) {
            LiveShowUndo o_LiveShowUndo = null;
            LiveShowObjectInterface o_LiveShowObjectInterface = LiveShowObjectPanel.this.m_LiveShowObjectInterface;
            if (o_LiveShowObjectInterface == null) {
                return;
            }
            LiveShowVIP o_LiveShowVIP = this.getLiveShowVIP();
            if (o_LiveShowVIP == null) {
                return;
            }
            o_LiveShowUndo = o_LiveShowVIP.getLiveShowUndo();
            if (o_LiveShowUndo == null) {
                return;
            }
            if (o_LiveShowUndo.checkStartAction(p_Action)) {
                LiveShowVIP.LiveShowVIPStatus o_LiveShowVIPStatus = new LiveShowVIP.LiveShowVIPStatus();
                o_LiveShowVIPStatus.addLiveShowObject_Cloned(o_LiveShowObjectInterface);
                o_LiveShowUndo.startAction(p_Action, p_ActionString, o_LiveShowVIP, o_LiveShowVIPStatus);
            }
        }

        public void endUndoAction_Volume(int p_Action, boolean p_Success) {
            LiveShowObjectInterface o_LiveShowObjectInterface = LiveShowObjectPanel.this.m_LiveShowObjectInterface;
            if (o_LiveShowObjectInterface == null) {
                return;
            }
            if (!o_LiveShowObjectInterface.getSelected()) {
                this.endUndoAction(p_Action, p_Success);
                return;
            }
            LiveShowVIP o_LiveShowVIP = this.getLiveShowVIP();
            if (o_LiveShowVIP == null) {
                return;
            }
            o_LiveShowVIP.endUndoAction_VolumeChange(o_LiveShowObjectInterface, p_Action, p_Success);
        }

        public void endUndoAction(int p_Action, boolean p_Success) {
            LiveShowUndo o_LiveShowUndo = null;
            LiveShowObjectInterface o_LiveShowObjectInterface = LiveShowObjectPanel.this.m_LiveShowObjectInterface;
            if (o_LiveShowObjectInterface == null) {
                return;
            }
            LiveShowVIP o_LiveShowVIP = this.getLiveShowVIP();
            if (o_LiveShowVIP == null) {
                return;
            }
            o_LiveShowUndo = o_LiveShowVIP.getLiveShowUndo();
            if (o_LiveShowUndo == null) {
                return;
            }
            if (o_LiveShowUndo.checkEndAction(p_Action)) {
                LiveShowVIP.LiveShowVIPStatus o_LiveShowVIPStatus = new LiveShowVIP.LiveShowVIPStatus();
                o_LiveShowVIPStatus.addLiveShowObject_Cloned(o_LiveShowObjectInterface);
                o_LiveShowUndo.endAction(p_Success, p_Action, o_LiveShowVIP, o_LiveShowVIPStatus);
            }
        }

        public void createMouseAdapter_Delayed() {
            this.m_MouseAdapter_Delayed = new MouseAdapter_Delayed(){

                @Override
                public void mouseDragged_Delayed(MouseEvent e) {
                    LiveShowObjectInterface o_LiveShowObjectInterface = LiveShowObjectPanel.this.m_LiveShowObjectInterface;
                    if (o_LiveShowObjectInterface == null) {
                        return;
                    }
                    this.sleep(30L);
                    int intX = e.getPoint().x;
                    int intY = e.getPoint().y;
                    int intTransferredX = intX + ((LabelFade)LabelFade.this).m_Constraints.x;
                    int intTransferredY = ((LabelFade)LabelFade.this).m_Constraints.y + intY;
                    long longPositionFrame = -1L;
                    long longNewFramePosition = 0L;
                    LiveShowVIP o_LiveShowVIP = LabelFade.this.getLiveShowVIP();
                    LiveShowVIPPanel o_LiveShowVIPPanel = LabelFade.this.getLiveShowVIPPanel();
                    switch (LabelFade.this.m_FadeType) {
                        case 1: {
                            long longCheckedFramePosition;
                            longPositionFrame = LiveShowObjectPanel.this.getPositionFrame(intTransferredX);
                            long longNewValue = longPositionFrame - o_LiveShowObjectInterface.getFrameStartOffset();
                            if (o_LiveShowObjectInterface.getFrameFadeInLength() == longNewValue) {
                                return;
                            }
                            longNewFramePosition = o_LiveShowObjectInterface.getFrameStart() - o_LiveShowObjectInterface.getFrameStartOffset() + longPositionFrame;
                            if (o_LiveShowVIP != null && (longCheckedFramePosition = o_LiveShowVIP.checkSnapping(1, o_LiveShowObjectInterface.getDescription(), null, longNewFramePosition, true)) >= 0L) {
                                longNewValue = longCheckedFramePosition - o_LiveShowObjectInterface.getFrameStart();
                            }
                            LabelFade.this.startUndoAction(14, LiveShowUndo.ACTION_PARAMCHANGE_STRING);
                            o_LiveShowObjectInterface.setFrameFadeInLength(longNewValue);
                            break;
                        }
                        case 2: {
                            long longCheckedFramePosition;
                            longPositionFrame = LiveShowObjectPanel.this.getPositionFrame(intTransferredX);
                            long longNewValue = o_LiveShowObjectInterface.getFrameLength() - (longPositionFrame - o_LiveShowObjectInterface.getFrameStartOffset());
                            if (o_LiveShowObjectInterface.getFrameFadeOutLength() == longNewValue) {
                                return;
                            }
                            longNewFramePosition = o_LiveShowObjectInterface.getFrameStart() - o_LiveShowObjectInterface.getFrameStartOffset() + longPositionFrame;
                            if (o_LiveShowVIP != null && (longCheckedFramePosition = o_LiveShowVIP.checkSnapping(2, o_LiveShowObjectInterface.getDescription(), null, longNewFramePosition, true)) >= 0L) {
                                longNewValue = o_LiveShowObjectInterface.getFrameLength() - (longCheckedFramePosition - o_LiveShowObjectInterface.getFrameStart());
                            }
                            LabelFade.this.startUndoAction(14, LiveShowUndo.ACTION_PARAMCHANGE_STRING);
                            o_LiveShowObjectInterface.setFrameFadeOutLength(longNewValue);
                            break;
                        }
                        case 3: {
                            if (LiveShowObjectPanel.this.m_AbsoluteConstraints.getHeight() <= 0) break;
                            float floatVolume = ((float)LiveShowObjectPanel.this.m_AbsoluteConstraints.getHeight() - (float)intTransferredY) / ((float)LiveShowObjectPanel.this.m_AbsoluteConstraints.getHeight() / 2.0f);
                            if (floatVolume < 0.0f) {
                                floatVolume = 0.0f;
                            }
                            if (floatVolume > 2.0f) {
                                floatVolume = 2.0f;
                            }
                            if (o_LiveShowObjectInterface.getVolumeFactor() == floatVolume) {
                                return;
                            }
                            LabelFade.this.startUndoAction_Volume(14, LiveShowUndo.ACTION_PARAMCHANGE_STRING);
                            o_LiveShowObjectInterface.setVolumeFactor(floatVolume, true);
                            break;
                        }
                        case 4: {
                            long longCheckedFramePosition;
                            longPositionFrame = LiveShowObjectPanel.this.getPositionFrame(intTransferredX);
                            long longOldFramePosition = o_LiveShowObjectInterface.getFrameStart();
                            longNewFramePosition = o_LiveShowObjectInterface.getFrameStart() - o_LiveShowObjectInterface.getFrameStartOffset() + longPositionFrame;
                            if (o_LiveShowVIP != null && (longCheckedFramePosition = o_LiveShowVIP.checkSnapping(4, o_LiveShowObjectInterface.getDescription(), null, longNewFramePosition, true)) >= 0L) {
                                longNewFramePosition = longCheckedFramePosition;
                            }
                            if (o_LiveShowObjectInterface.getFrameStart() == longNewFramePosition) {
                                return;
                            }
                            LabelFade.this.startUndoAction(14, LiveShowUndo.ACTION_PARAMCHANGE_STRING);
                            if (o_LiveShowVIPPanel == null || o_LiveShowVIPPanel.checkScroll(4, false, longOldFramePosition, longNewFramePosition, 0L, o_LiveShowObjectInterface, o_LiveShowObjectInterface.getDescription(), null)) break;
                            o_LiveShowObjectInterface.setFrameStartResize(longNewFramePosition);
                            break;
                        }
                        case 5: {
                            long longCheckedFramePosition;
                            longPositionFrame = LiveShowObjectPanel.this.getPositionFrame(intTransferredX);
                            long longOldFramePosition = o_LiveShowObjectInterface.getFrameStart() + o_LiveShowObjectInterface.getFrameLength();
                            longNewFramePosition = o_LiveShowObjectInterface.getFrameStart() - o_LiveShowObjectInterface.getFrameStartOffset() + longPositionFrame;
                            if (o_LiveShowVIP != null && (longCheckedFramePosition = o_LiveShowVIP.checkSnapping(5, o_LiveShowObjectInterface.getDescription(), null, longNewFramePosition, true)) >= 0L) {
                                longNewFramePosition = longCheckedFramePosition;
                            }
                            if (o_LiveShowObjectInterface.getFrameLength() == longNewFramePosition - o_LiveShowObjectInterface.getFrameStart()) {
                                return;
                            }
                            LabelFade.this.startUndoAction(14, LiveShowUndo.ACTION_PARAMCHANGE_STRING);
                            if (o_LiveShowVIPPanel == null || o_LiveShowVIPPanel.checkScroll(5, false, longOldFramePosition, longNewFramePosition, 0L, o_LiveShowObjectInterface, o_LiveShowObjectInterface.getDescription(), null)) break;
                            o_LiveShowObjectInterface.setFrameLength(longNewFramePosition - o_LiveShowObjectInterface.getFrameStart());
                        }
                    }
                }

                @Override
                public void mouseMoved_Delayed(MouseEvent e) {
                }

                @Override
                public void mouseClicked_Delayed(MouseEvent e) {
                    LiveShowObjectInterface o_LiveShowObjectInterface = LiveShowObjectPanel.this.m_LiveShowObjectInterface;
                    if (o_LiveShowObjectInterface == null) {
                        return;
                    }
                    if (e.getClickCount() > 1) {
                        LiveShowVIP o_LiveShowVIP = LabelFade.this.getLiveShowVIP();
                        switch (LabelFade.this.m_FadeType) {
                            case 1: {
                                if (o_LiveShowObjectInterface.getFrameFadeInLength() == 0L) {
                                    return;
                                }
                                LabelFade.this.startUndoAction(14, LiveShowUndo.ACTION_PARAMCHANGE_STRING);
                                o_LiveShowObjectInterface.setFrameFadeInLength(0L);
                                LabelFade.this.endUndoAction(14, true);
                                break;
                            }
                            case 2: {
                                if (o_LiveShowObjectInterface.getFrameFadeOutLength() == 0L) {
                                    return;
                                }
                                LabelFade.this.startUndoAction(14, LiveShowUndo.ACTION_PARAMCHANGE_STRING);
                                o_LiveShowObjectInterface.setFrameFadeOutLength(0L);
                                LabelFade.this.endUndoAction(14, true);
                                break;
                            }
                            case 3: {
                                if (o_LiveShowObjectInterface.getVolumeFactor() == 1.0f) {
                                    return;
                                }
                                LabelFade.this.startUndoAction_Volume(14, LiveShowUndo.ACTION_PARAMCHANGE_STRING);
                                o_LiveShowObjectInterface.setVolumeFactor(1.0f, true);
                                LabelFade.this.endUndoAction_Volume(14, true);
                            }
                        }
                    }
                }

                @Override
                public void mousePressed_Delayed(MouseEvent e) {
                }

                @Override
                public void mouseReleased_Delayed(MouseEvent e) {
                    LiveShowVIP o_LiveShowVIP = LabelFade.this.getLiveShowVIP();
                    LiveShowVIPPanel o_LiveShowVIPPanel = LabelFade.this.getLiveShowVIPPanel();
                    switch (LabelFade.this.m_FadeType) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 5: {
                            LabelFade.this.endUndoAction(14, true);
                            if (o_LiveShowVIPPanel == null) break;
                            o_LiveShowVIPPanel.stopScrollAutomatic();
                            break;
                        }
                        case 3: {
                            LabelFade.this.endUndoAction_Volume(14, true);
                            if (o_LiveShowVIPPanel == null) break;
                            o_LiveShowVIPPanel.stopScrollAutomatic();
                        }
                    }
                }

                @Override
                public void mouseEntered_Delayed(MouseEvent e) {
                }

                @Override
                public void mouseExited_Delayed(MouseEvent e) {
                }
            };
        }
    }
}

