/*
 * Decompiled with CFR 0.152.
 */
package FileToolPackage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.MessageDigest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.filechooser.FileFilter;

public class FileTools {
    public static String VALID_CHARS = "_0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

    public static boolean checkWritable(File p_File) {
        boolean boolWritable;
        File o_Directory;
        boolean boolExists;
        if (p_File == null) {
            return false;
        }
        if (!p_File.isDirectory()) {
            if (!p_File.exists()) {
                boolExists = false;
                try {
                    p_File.createNewFile();
                }
                catch (Exception e) {
                    return false;
                }
            } else {
                boolExists = true;
            }
            o_Directory = p_File.getParentFile();
        } else {
            o_Directory = p_File;
            if (!p_File.exists()) {
                boolExists = false;
                try {
                    p_File.mkdir();
                }
                catch (Exception e) {
                    return false;
                }
            } else {
                boolExists = true;
            }
        }
        try {
            File o_FileSubDir = new File(o_Directory.getAbsolutePath() + File.separator + "XXX_FILE_CHECKWRITABLE_XXX");
            o_FileSubDir.mkdir();
            if (o_FileSubDir.exists()) {
                boolWritable = true;
                o_FileSubDir.delete();
            } else {
                boolWritable = false;
            }
        }
        catch (Exception e) {
            boolWritable = false;
        }
        if (!boolExists) {
            try {
                p_File.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return boolWritable;
    }

    public static boolean deleteDirectory(File p_Directory) {
        if (p_Directory == null) {
            return false;
        }
        if (!p_Directory.exists()) {
            return false;
        }
        Path path = p_Directory.toPath();
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException e) {
                    return this.handleException(e);
                }

                private FileVisitResult handleException(IOException e) {
                    e.printStackTrace();
                    return FileVisitResult.TERMINATE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                    if (e != null) {
                        return this.handleException(e);
                    }
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static File findFileWithExtension(File p_Directory, String p_Extension) {
        File[] o_Files;
        if (p_Directory == null) {
            return null;
        }
        if (p_Extension == null) {
            return null;
        }
        if (!p_Directory.exists()) {
            return null;
        }
        try {
            o_Files = p_Directory.listFiles();
        }
        catch (Exception e) {
            return null;
        }
        if (o_Files == null || o_Files.length <= 0) {
            return null;
        }
        for (int intFile = 0; intFile < o_Files.length; ++intFile) {
            File o_File = o_Files[intFile];
            if (o_File == null || o_File.isDirectory() || !p_Extension.equals(FileTools.getFileNameExtension(o_File))) continue;
            return o_File;
        }
        return null;
    }

    public static String getFileNameBase(String p_FileName) {
        if (p_FileName == null) {
            return "";
        }
        String stringFileName = p_FileName;
        int intPos = -1;
        if (stringFileName.length() > 1 && (intPos = stringFileName.lastIndexOf(".")) > 0) {
            stringFileName = stringFileName.substring(0, intPos);
        }
        return stringFileName;
    }

    public static String getFileNameBase(File p_File) {
        if (p_File == null) {
            return "";
        }
        return FileTools.getFileNameBase(p_File.getName());
    }

    public static String getFileNameExtension(String p_FileName) {
        if (p_FileName == null) {
            return "";
        }
        String stringFileName = p_FileName;
        int intPos = -1;
        stringFileName = stringFileName.length() > 1 ? ((intPos = stringFileName.lastIndexOf(".")) > 0 ? stringFileName.substring(intPos, stringFileName.length()) : "") : "";
        return stringFileName;
    }

    public static String getFileNameExtension(File p_File) {
        if (p_File == null) {
            return "";
        }
        return FileTools.getFileNameExtension(p_File.getName());
    }

    public static String getFileNameExtension_WithoutPoint(String p_FileName) {
        if (p_FileName == null) {
            return "";
        }
        String stringFileName = p_FileName;
        int intPos = -1;
        stringFileName = stringFileName.length() > 1 ? ((intPos = stringFileName.lastIndexOf(".")) > 0 && intPos < stringFileName.length() ? stringFileName.substring(intPos + 1, stringFileName.length()) : "") : "";
        return stringFileName;
    }

    public static String getPathName(File p_File) {
        String stringPathName;
        if (p_File == null) {
            return "";
        }
        File o_Directory = p_File.getParentFile();
        try {
            stringPathName = o_Directory.getCanonicalPath();
        }
        catch (Exception e) {
            stringPathName = o_Directory.getPath();
        }
        return stringPathName;
    }

    public static File copyFileTo(File p_File, File p_NewDirectory, String p_FileName, boolean p_Overwrite) {
        String stringOldDirectory;
        if (p_File == null) {
            return null;
        }
        if (!p_File.exists()) {
            return null;
        }
        if (p_NewDirectory == null) {
            return null;
        }
        if (!p_NewDirectory.exists() && !p_NewDirectory.mkdir()) {
            return null;
        }
        if (!p_NewDirectory.isDirectory()) {
            return null;
        }
        String stringFileName = p_FileName == null ? p_File.getName() : p_FileName;
        String stringNewDirectory = p_NewDirectory.getAbsolutePath();
        File o_ParentFile = p_File.getParentFile();
        if (o_ParentFile != null && stringNewDirectory.equals(stringOldDirectory = p_File.getParentFile().getAbsolutePath()) && p_File.getName().equals(stringFileName)) {
            return p_File;
        }
        File o_NewFile = new File(stringNewDirectory + "/" + stringFileName);
        if (p_File.equals(o_NewFile)) {
            return null;
        }
        if (o_NewFile.exists() && !p_Overwrite) {
            return o_NewFile;
        }
        InputStream in = null;
        OutputStream out = null;
        try {
            int len;
            if (o_NewFile.exists()) {
                o_NewFile.delete();
            }
            o_NewFile.createNewFile();
            in = new FileInputStream(p_File);
            out = new FileOutputStream(o_NewFile);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) >= 0) {
                out.write(buf, 0, len);
            }
            in.close();
            out.close();
        }
        catch (Exception e) {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
        return o_NewFile;
    }

    public static boolean copyFilesTo(File p_OldDirectory, File p_NewDirectory, boolean p_Overwrite, boolean p_RemoveOld) {
        File o_File;
        int intFile;
        File[] o_Files;
        if (p_OldDirectory == null) {
            return false;
        }
        if (p_NewDirectory == null) {
            return false;
        }
        if (!p_OldDirectory.exists()) {
            return false;
        }
        if (!p_NewDirectory.exists()) {
            return false;
        }
        if (p_OldDirectory.getAbsolutePath().equals(p_NewDirectory.getAbsolutePath())) {
            return true;
        }
        try {
            o_Files = p_OldDirectory.listFiles();
            for (intFile = 0; intFile < o_Files.length; ++intFile) {
                o_File = o_Files[intFile];
                if (o_File.isDirectory() || FileTools.copyFileTo(o_File, p_NewDirectory, null, p_Overwrite) != null) continue;
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        if (p_RemoveOld) {
            try {
                o_Files = p_OldDirectory.listFiles();
                for (intFile = 0; intFile < o_Files.length; ++intFile) {
                    o_File = o_Files[intFile];
                    if (o_File.isDirectory()) continue;
                    o_File.delete();
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public static boolean equalsContent(File p_File1, File p_File2) {
        if (p_File1 == null && p_File2 == null) {
            return true;
        }
        if (p_File1 == null) {
            return false;
        }
        if (p_File2 == null) {
            return false;
        }
        if (p_File1.isDirectory() && p_File2.isDirectory()) {
            return true;
        }
        if (p_File1.isDirectory()) {
            return false;
        }
        if (p_File2.isDirectory()) {
            return false;
        }
        if (p_File1.length() != p_File2.length()) {
            return false;
        }
        FileInputStream o_InputStream1 = null;
        FileInputStream o_InputStream2 = null;
        boolean boolEqualContent = true;
        try {
            int len1;
            o_InputStream1 = new FileInputStream(p_File1);
            o_InputStream2 = new FileInputStream(p_File2);
            byte[] buf1 = new byte[1024];
            byte[] buf2 = new byte[1024];
            block4: while ((len1 = ((InputStream)o_InputStream1).read(buf1)) >= 0 && boolEqualContent) {
                int len2 = 0;
                int intOffset2 = 0;
                while (len2 < len1) {
                    len2 = ((InputStream)o_InputStream2).read(buf2, intOffset2, len1 - intOffset2);
                    if (len2 < 0) {
                        boolEqualContent = false;
                        break;
                    }
                    intOffset2 += len2;
                }
                for (int intByte = 0; intByte < len1; ++intByte) {
                    if (buf1[intByte] == buf2[intByte]) continue;
                    boolEqualContent = false;
                    continue block4;
                }
            }
        }
        catch (Exception e) {
            boolEqualContent = false;
        }
        try {
            if (o_InputStream1 != null) {
                ((InputStream)o_InputStream1).close();
            }
            if (o_InputStream2 != null) {
                ((InputStream)o_InputStream2).close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return boolEqualContent;
    }

    public static FileFilter createFileFilter(final String p_FileExtension, final String p_FileTypeName) {
        FileFilter o_FileFilter = new FileFilter(){

            @Override
            public boolean accept(File p_File) {
                if (p_File.isDirectory()) {
                    return true;
                }
                return p_File.getPath().endsWith(p_FileExtension);
            }

            @Override
            public String getDescription() {
                return p_FileTypeName;
            }
        };
        return o_FileFilter;
    }

    public static FileFilter createFileFilter(final String[] p_FileExtensions, final String p_FileTypeName) {
        FileFilter o_FileFilter = new FileFilter(){

            @Override
            public boolean accept(File p_File) {
                if (p_File.isDirectory()) {
                    return true;
                }
                int intLastPointPos = p_File.getPath().lastIndexOf(".");
                String stringActualPostfix = p_File.getPath().substring(intLastPointPos).trim().toLowerCase();
                for (int intPostfix = 0; intPostfix < p_FileExtensions.length; ++intPostfix) {
                    String stringPostfix = p_FileExtensions[intPostfix];
                    if (!stringPostfix.toLowerCase().equals(stringActualPostfix)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String getDescription() {
                return p_FileTypeName;
            }
        };
        return o_FileFilter;
    }

    public static String getCheckSum_MD5(File p_File) {
        String stringCheckSum;
        block7: {
            if (p_File == null) {
                return "";
            }
            if (!p_File.exists()) {
                return "";
            }
            stringCheckSum = "";
            FileInputStream o_FileInputStream = null;
            try {
                int numOfBytesRead;
                o_FileInputStream = new FileInputStream(p_File);
                MessageDigest o_MessageDigest = MessageDigest.getInstance("MD5");
                byte[] buffer = new byte[8192];
                while ((numOfBytesRead = o_FileInputStream.read(buffer)) > 0) {
                    o_MessageDigest.update(buffer, 0, numOfBytesRead);
                }
                byte[] hash = o_MessageDigest.digest();
                stringCheckSum = String.format("%032x", new BigInteger(1, hash));
                o_FileInputStream.close();
            }
            catch (Exception ex) {
                if (o_FileInputStream == null) break block7;
                try {
                    o_FileInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return stringCheckSum;
    }

    public static String getCheckSum_MD5_Partial(File p_File) {
        String stringCheckSum;
        block13: {
            int intPackages;
            if (p_File == null) {
                return "";
            }
            if (!p_File.exists()) {
                return "";
            }
            stringCheckSum = "";
            RandomAccessFile o_RandomAccessFile = null;
            byte[] buffer = new byte[8192];
            long longFileSize = p_File.length();
            if (longFileSize == 0L) {
                return "";
            }
            long longPackageSize = 0x3200000L;
            if (longFileSize > 4L * longPackageSize) {
                intPackages = 3;
            } else {
                intPackages = 1;
                longPackageSize = longFileSize;
            }
            try {
                o_RandomAccessFile = new RandomAccessFile(p_File, "r");
                MessageDigest o_MessageDigest = MessageDigest.getInstance("MD5");
                buffer = new byte[8192];
                for (int intPackage = 0; intPackage < intPackages; ++intPackage) {
                    long longSeekPosition = (long)intPackage * (longFileSize / 2L) - (long)intPackage * (longPackageSize / 2L);
                    o_RandomAccessFile.seek(longSeekPosition);
                    try {
                        int intBytesActualRead;
                        for (long longBytesReadTotal = 0L; (intBytesActualRead = o_RandomAccessFile.read(buffer, 0, buffer.length)) > 0 && longBytesReadTotal < longPackageSize; longBytesReadTotal += (long)intBytesActualRead) {
                            o_MessageDigest.update(buffer, 0, intBytesActualRead);
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                byte[] hash = o_MessageDigest.digest();
                stringCheckSum = String.format("%032x", new BigInteger(1, hash));
                o_RandomAccessFile.close();
            }
            catch (Exception ex) {
                if (o_RandomAccessFile == null) break block13;
                try {
                    o_RandomAccessFile.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return stringCheckSum;
    }

    public static String validateFileName(String p_FileName) {
        if (p_FileName == null) {
            return "";
        }
        if (p_FileName.length() <= 0) {
            return "";
        }
        String stringFileNameBase = FileTools.getFileNameBase(p_FileName);
        String stringFileNameExtension = FileTools.getFileNameExtension(p_FileName);
        stringFileNameBase = FileTools.validateName(stringFileNameBase);
        StringBuffer o_StringBuffer = new StringBuffer();
        o_StringBuffer.append(stringFileNameBase);
        o_StringBuffer.append(stringFileNameExtension);
        return o_StringBuffer.toString();
    }

    public static String validateName(String p_Name) {
        if (p_Name == null) {
            return "";
        }
        StringBuilder o_StringBuilder = new StringBuilder();
        for (int intChar = 0; intChar < p_Name.length(); ++intChar) {
            String stringChar = p_Name.substring(intChar, intChar + 1);
            if (VALID_CHARS.contains(stringChar)) {
                o_StringBuilder.append(stringChar);
                continue;
            }
            if (" ".equals(stringChar)) {
                o_StringBuilder.append("_");
                continue;
            }
            if ("\u00e4".equals(stringChar)) {
                o_StringBuilder.append("ae");
                continue;
            }
            if ("\u00c4".equals(stringChar)) {
                o_StringBuilder.append("Ae");
                continue;
            }
            if ("\u00f6".equals(stringChar)) {
                o_StringBuilder.append("oe");
                continue;
            }
            if ("\u00d6".equals(stringChar)) {
                o_StringBuilder.append("Oe");
                continue;
            }
            if ("\u00fc".equals(stringChar)) {
                o_StringBuilder.append("ue");
                continue;
            }
            if ("\u00dc".equals(stringChar)) {
                o_StringBuilder.append("Ue");
                continue;
            }
            if (!"\u00df".equals(stringChar)) continue;
            o_StringBuilder.append("ss");
        }
        return o_StringBuilder.toString();
    }

    public static File unzipFile(File p_DestDirectory, File p_ZIPFile) {
        if (p_ZIPFile == null) {
            return null;
        }
        if (!p_ZIPFile.exists()) {
            return null;
        }
        File boolSuccess = p_DestDirectory;
        byte[] buffer = new byte[1024];
        try {
            ZipInputStream o_ZipInputStream = new ZipInputStream(new FileInputStream(p_ZIPFile));
            ZipEntry o_ZipEntry = o_ZipInputStream.getNextEntry();
            if (o_ZipEntry != null) {
                while (o_ZipEntry != null) {
                    File newFile = FileTools.newValidatedFile_ZIP(p_DestDirectory, o_ZipEntry);
                    if (newFile == null) {
                        boolSuccess = null;
                        break;
                    }
                    if (o_ZipEntry.isDirectory()) {
                        if (!newFile.isDirectory() && !newFile.mkdirs()) {
                            boolSuccess = null;
                            break;
                        }
                    } else {
                        int len;
                        File parent = newFile.getParentFile();
                        if (!parent.isDirectory() && !parent.mkdirs()) {
                            boolSuccess = null;
                            break;
                        }
                        FileOutputStream fos = new FileOutputStream(newFile);
                        while ((len = o_ZipInputStream.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                        fos.close();
                    }
                    o_ZipEntry = o_ZipInputStream.getNextEntry();
                }
            } else {
                boolSuccess = null;
            }
            o_ZipInputStream.closeEntry();
            o_ZipInputStream.close();
        }
        catch (Exception e) {
            boolSuccess = null;
        }
        return boolSuccess;
    }

    private static File newValidatedFile_ZIP(File p_DestDirectory, ZipEntry p_ZipEntry) {
        String destFilePath;
        String destDirPath;
        if (p_DestDirectory == null) {
            return null;
        }
        if (p_ZipEntry == null) {
            return null;
        }
        File destFile = new File(p_DestDirectory, p_ZipEntry.getName());
        try {
            destDirPath = p_DestDirectory.getCanonicalPath();
            destFilePath = destFile.getCanonicalPath();
        }
        catch (Exception e) {
            return null;
        }
        if (!destFilePath.startsWith(destDirPath + File.separator)) {
            return null;
        }
        return destFile;
    }

    public static File zipFile(File p_SourceFileToZip, String p_ZIPFileName, File p_DestDirectory) {
        if (p_SourceFileToZip == null) {
            return null;
        }
        if (!p_SourceFileToZip.exists()) {
            return null;
        }
        if (p_ZIPFileName == null || p_ZIPFileName.length() <= 0) {
            return null;
        }
        if (p_DestDirectory == null || p_DestDirectory.length() <= 0L || !p_DestDirectory.exists()) {
            return null;
        }
        File o_FileOutput = null;
        FileOutputStream o_FileOutputStream = null;
        ZipOutputStream o_ZipOutputStream = null;
        o_FileOutput = new File(p_DestDirectory + File.separator + p_ZIPFileName);
        try {
            o_FileOutputStream = new FileOutputStream(o_FileOutput);
            o_ZipOutputStream = new ZipOutputStream(o_FileOutputStream);
            if (!FileTools.zipFileIntern(p_SourceFileToZip, o_FileOutput.getName(), o_ZipOutputStream)) {
                o_FileOutput = null;
            }
        }
        catch (Exception e) {
            o_FileOutput = null;
        }
        try {
            if (o_ZipOutputStream != null) {
                o_ZipOutputStream.close();
            }
            if (o_FileOutputStream != null) {
                o_FileOutputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return o_FileOutput;
    }

    private static boolean zipFileIntern(File p_SourceFileToZip, String fileName, ZipOutputStream p_ZipOutputStream) {
        if (p_SourceFileToZip == null) {
            return false;
        }
        if (p_SourceFileToZip.isHidden()) {
            return false;
        }
        if (fileName == null) {
            return false;
        }
        if (p_ZipOutputStream == null) {
            return false;
        }
        FileInputStream o_FileInputStream = null;
        try {
            if (p_SourceFileToZip.isDirectory()) {
                File[] children;
                if (fileName.endsWith("/")) {
                    p_ZipOutputStream.putNextEntry(new ZipEntry(fileName));
                    p_ZipOutputStream.closeEntry();
                } else {
                    p_ZipOutputStream.putNextEntry(new ZipEntry(fileName + "/"));
                    p_ZipOutputStream.closeEntry();
                }
                for (File childFile : children = p_SourceFileToZip.listFiles()) {
                    if (FileTools.zipFileIntern(childFile, fileName + "/" + childFile.getName(), p_ZipOutputStream)) continue;
                    return false;
                }
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        byte[] bytes = new byte[1024];
        boolean boolWritten = true;
        try {
            int length;
            o_FileInputStream = new FileInputStream(p_SourceFileToZip);
            ZipEntry o_ZipEntry = new ZipEntry(fileName);
            p_ZipOutputStream.putNextEntry(o_ZipEntry);
            while ((length = o_FileInputStream.read(bytes)) >= 0) {
                p_ZipOutputStream.write(bytes, 0, length);
            }
        }
        catch (Exception e) {
            boolWritten = false;
        }
        try {
            if (o_FileInputStream != null) {
                o_FileInputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return boolWritten;
    }
}

