/*
 * Decompiled with CFR 0.152.
 */
package ServerKernelPackage;

import ClientPackage.LiveDBClient;
import ClientPackage.LiveDBClientListener;
import LogEventPackage.LogEvent;
import MessagePackage.LiveDBMessageLiveDBClientsListAnswer;
import MessagePackage.LiveDBMessageLiveDBClientsListRequest;
import MessagePackage.LiveDBMessageLiveDBShutDown;
import ServerKernelPackage.LiveDBServerKernelListener;
import ServerPackage.LiveDBSocketServerListener;
import SocketManagementPackage.LiveDBSocketChannelManagement;
import SocketManagementPackage.LiveDBStream;
import SocketMessagePackage.LiveDBConnectionDescription;
import SocketMessagePackage.LiveDBMessageStreamInfo;
import SocketPackage.LiveDBSocket;
import SynchronizationPackage.LiveDBCloseSemaphore;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;

public class LiveDBServerKernel
implements LiveDBSocketServerListener,
LiveDBClientListener {
    public static long s_DestructWaitTime = 2000L;
    public static final int CONNECTION_CLOSE = 0;
    public static final int CONNECTION_TRYCONNECTION = 1;
    public static final int CONNECTION_CONNECT = 2;
    public static final int CONNECTION_RECONNECT = 3;
    public static final int CONNECTION_FAILED = 6;
    public static final int CONNECTION_LOST = 8;
    public static final int CONNECTION_TRYCLOSE = 9;
    public static final int CLOSESERVER_NOEFFECT = 0;
    public static final int CLOSESERVER_SUDDENLY = 1;
    public static final int CLOSESERVER_WAITFORCLIENTS = 2;
    public static final int CLOSESERVER_CANCEL = 9;
    public static String ERROR_SERVERKERNELDESTRUCTED = "LiveDBServerKernel was destructed prior and cannot be used again. The program must be restarted";
    public static String ERROR_STREAMHANDLEDINTERNAL = "The stream will be handled internal, there is no need to create an incoming stream!";
    private static ArrayList<LiveDBServerKernelListener> m_ServerKernelListeners = new ArrayList();
    private static ArrayList<LiveDBClient> m_ArrayListLiveDBClients = new ArrayList();
    private static ArrayList<String> m_ArrayListVerbosedIPs = LiveDBServerKernel.getVerbosedClientIPs();
    private static int m_ConnectionStatus = 0;
    private static LiveDBCloseSemaphore m_LiveDBCloseSemaphore = new LiveDBCloseSemaphore("LiveDBServerKernel");
    private static final Object m_SyncLiveDBClients = new Object();
    private static final Object m_SyncServerKernelListeners = new Object();
    private static final Object m_SyncDestruct = new Object();
    private static LiveDBServerKernel m_LiveDBServerKernel = new LiveDBServerKernel();

    private LiveDBServerKernel() {
        this.initMembers();
        LiveDBSocketChannelManagement.addLiveDBSocketServerListener((LiveDBSocketServerListener)this);
    }

    private void initMembers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void destruct(boolean p_WaitforServer, int p_CloseType, long p_DestructWaitTime) {
        if (p_WaitforServer) {
            Thread o_DestructThread = null;
            final long longDestructWaitTime = p_DestructWaitTime < s_DestructWaitTime ? s_DestructWaitTime : p_DestructWaitTime;
            Runnable o_DestructRunnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (m_ConnectionStatus == 0) {
                        return;
                    }
                    Object object = m_SyncDestruct;
                    synchronized (object) {
                        try {
                            long longWaitStart;
                            for (long longWaitTime = longDestructWaitTime; longWaitTime > 0L && m_ConnectionStatus != 0; longWaitTime -= System.nanoTime() / 1000000L - longWaitStart) {
                                longWaitStart = System.nanoTime() / 1000000L;
                                m_SyncDestruct.wait(longWaitTime);
                            }
                            return;
                        }
                        catch (Exception exception) {
                        }
                    }
                }
            };
            try {
                o_DestructThread = new Thread(o_DestructRunnable, LiveDBServerKernel.class.getSimpleName() + "_destruct");
                if (o_DestructThread == null) {
                    return;
                }
                o_DestructThread.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                LiveDBServerKernel.closeServer(p_CloseType);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (o_DestructThread != null) {
                    o_DestructThread.join(longDestructWaitTime);
                    if (!o_DestructThread.isAlive()) {
                        // empty if block
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!m_LiveDBCloseSemaphore.enterCloseSection()) {
            return;
        }
        Object object = m_ServerKernelListeners;
        synchronized (object) {
            if (m_ServerKernelListeners != null) {
                m_ServerKernelListeners.clear();
                m_ServerKernelListeners = null;
            }
        }
        object = m_SyncLiveDBClients;
        synchronized (object) {
            if (m_ArrayListLiveDBClients != null) {
                m_ArrayListLiveDBClients.clear();
                m_ArrayListLiveDBClients = null;
            }
        }
        LiveDBSocketChannelManagement.removeLiveDBSocketServerListener((LiveDBSocketServerListener)m_LiveDBServerKernel);
        LiveDBSocketChannelManagement.destruct();
        m_LiveDBServerKernel = null;
        m_LiveDBCloseSemaphore.leaveCloseSection();
        if (LiveDBSocketChannelManagement.getGarbageCollectionRatio() > 0.0) {
            // empty if block
        }
    }

    public static String getServerHostName() {
        return LiveDBSocketChannelManagement.getServerHostName();
    }

    public static LiveDBConnectionDescription createConnectionDescription_ServerSide(String p_ServerLocalURL, int p_ServerPort, String p_ServerID, String p_ServerTaskID, String p_ServerName, String p_ServerLongName, String p_ServerVersion) {
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        LiveDBConnectionDescription o_LiveDBConnectionDescription = LiveDBConnectionDescription.createConnectionDescription_ServerSide((String)p_ServerLocalURL, (int)p_ServerPort, (String)p_ServerID, (String)p_ServerTaskID, (String)p_ServerName, (String)p_ServerLongName, (String)p_ServerVersion);
        m_LiveDBCloseSemaphore.leaveWorkerSection();
        return o_LiveDBConnectionDescription;
    }

    public static void connectServer(String p_ServerLocalURL, int p_ServerPort, String p_ServerID, String p_ServerTaskID, String p_ServerName, String p_ServerLongName, String p_ServerVersion) {
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            LiveDBServerKernel.notifyServerKernelListeners_eventServerError(new Exception("Exception connectServer: ServerKernel was destructed prior"), ERROR_SERVERKERNELDESTRUCTED);
            return;
        }
        LiveDBConnectionDescription o_LiveDBConnectionDescription = LiveDBConnectionDescription.createConnectionDescription_ServerSide((String)p_ServerLocalURL, (int)p_ServerPort, (String)p_ServerID, (String)p_ServerTaskID, (String)p_ServerName, (String)p_ServerLongName, (String)p_ServerVersion);
        LiveDBServerKernel.connectServer(o_LiveDBConnectionDescription);
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    public static void connectServer(LiveDBConnectionDescription p_LiveDBConnectionDescription) {
        if (p_LiveDBConnectionDescription == null) {
            return;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            LiveDBServerKernel.notifyServerKernelListeners_eventServerError(new Exception("Exception connectServer: ServerKernel was destructed prior"), ERROR_SERVERKERNELDESTRUCTED);
            return;
        }
        LiveDBSocketChannelManagement.actionConnectServer((LiveDBConnectionDescription)p_LiveDBConnectionDescription);
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    public static int getConnectionStatus() {
        return m_ConnectionStatus;
    }

    public static void closeServer(int p_CloseType) {
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
        LiveDBSocketChannelManagement.actionCloseServer(null, (int)p_CloseType);
    }

    public static void setLogEventOutput(PrintStream p_PrintStream) {
        LogEvent.setPrintStream(p_PrintStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LiveDBClient getLiveDBClient(String p_ClientID) {
        if (p_ClientID == null) {
            return null;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        LiveDBClient o_LiveDBClient = null;
        Object object = m_SyncLiveDBClients;
        synchronized (object) {
            if (m_ArrayListLiveDBClients != null) {
                int intClientSize = m_ArrayListLiveDBClients.size();
                for (int intClient = 0; intClient < intClientSize && !p_ClientID.equals((o_LiveDBClient = m_ArrayListLiveDBClients.get(intClient)).getID()); ++intClient) {
                    o_LiveDBClient = null;
                }
            }
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
        return o_LiveDBClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getLiveDBClientsCount() {
        int intLiveDBClientsCount = 0;
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return 0;
        }
        Object object = m_SyncLiveDBClients;
        synchronized (object) {
            if (m_ArrayListLiveDBClients != null) {
                intLiveDBClientsCount = m_ArrayListLiveDBClients.size();
            }
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
        return intLiveDBClientsCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<LiveDBClient> getLiveDBClients() {
        ArrayList<LiveDBClient> o_ArrayListLiveDBClients = new ArrayList<LiveDBClient>();
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return o_ArrayListLiveDBClients;
        }
        Object object = m_SyncLiveDBClients;
        synchronized (object) {
            if (m_ArrayListLiveDBClients != null) {
                for (int intClient = 0; intClient < m_ArrayListLiveDBClients.size(); ++intClient) {
                    o_ArrayListLiveDBClients.add(m_ArrayListLiveDBClients.get(intClient));
                }
            }
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
        return o_ArrayListLiveDBClients;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAllClients() {
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        LiveDBClient o_LiveDBClient = null;
        Object[] o_LiveDBClients = null;
        Object object = m_SyncLiveDBClients;
        synchronized (object) {
            if (m_ArrayListLiveDBClients != null && m_ArrayListLiveDBClients != null) {
                o_LiveDBClients = m_ArrayListLiveDBClients.toArray();
            }
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
        if (o_LiveDBClients != null) {
            int intClientSize = o_LiveDBClients.length;
            for (int intClient = intClientSize - 1; intClient >= 0; --intClient) {
                o_LiveDBClient = (LiveDBClient)o_LiveDBClients[intClient];
                o_LiveDBClient.close();
            }
        }
    }

    public static LiveDBStream createIncomingStream(LiveDBClient p_LiveDBClient, LiveDBMessageStreamInfo p_StreamInfo, OutputStream p_OutputStream) {
        if (p_LiveDBClient == null) {
            return null;
        }
        if (p_StreamInfo == null) {
            return null;
        }
        if (p_OutputStream == null) {
            return null;
        }
        if (p_StreamInfo.getInternalHandled()) {
            LiveDBServerKernel.notifyServerKernelListeners_eventClientError(p_LiveDBClient, new Exception("Stream is handled internal, thers is no need to create an incoming stream"), ERROR_STREAMHANDLEDINTERNAL);
            return null;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        LiveDBStream o_LiveDBStream = LiveDBStream.createIncomingStream((LiveDBSocket)p_LiveDBClient.getLiveDBSocket(), (LiveDBMessageStreamInfo)p_StreamInfo, (OutputStream)p_OutputStream);
        m_LiveDBCloseSemaphore.leaveWorkerSection();
        return o_LiveDBStream;
    }

    public static void setMessagePrecode(byte[] p_MessagePrecode) {
        LiveDBSocketChannelManagement.setMessagePrecode((byte[])p_MessagePrecode);
    }

    public static byte[] getMessagePrecode() {
        return LiveDBSocketChannelManagement.getMessagePrecode();
    }

    public static void setSocketReceiveBufferSize(int p_ReadBufferSize) {
        LiveDBSocketChannelManagement.setSocketReceiveBufferSize((int)p_ReadBufferSize);
    }

    public static int getSocketReceiveBufferSize() {
        return LiveDBSocketChannelManagement.getSocketReceiveBufferSize();
    }

    public static void setSocketSendBufferSize(int p_SendBufferSize) {
        if (p_SendBufferSize <= 1024) {
            return;
        }
        LiveDBSocketChannelManagement.setSocketSendBufferSize((int)p_SendBufferSize);
    }

    public static int getSocketSendBufferSize() {
        return LiveDBSocketChannelManagement.getSocketSendBufferSize();
    }

    public static void setWatchdogConnection_Time(long p_Milliseconds) {
        LiveDBSocketChannelManagement.setWatchdogConnection_Time((long)p_Milliseconds);
    }

    public static void setWatchdogConnectionLost_Time(long p_Milliseconds) {
        LiveDBSocketChannelManagement.setWatchdogConnectionLost_Time((long)p_Milliseconds);
    }

    public static long getWatchdogConnectionLost_Time() {
        return LiveDBSocketChannelManagement.getWatchdogConnectionLost_Time();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyClientSoftwareVersion(LiveDBSocket p_LiveDBSocket, String p_ClientSoftwareVersion, LiveDBConnectionDescription p_LiveDBConnectionDescription) {
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        boolean boolAllowed = true;
        Object[] o_Listeners = null;
        Object object = m_SyncServerKernelListeners;
        synchronized (object) {
            if (m_ServerKernelListeners != null) {
                o_Listeners = m_ServerKernelListeners.toArray();
            }
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize && boolAllowed; ++intListener) {
                LiveDBServerKernelListener o_LiveDBServerKernelListener = (LiveDBServerKernelListener)o_Listeners[intListener];
                if (o_LiveDBServerKernelListener == null || o_LiveDBServerKernelListener.verifyClientSoftwareVersion(p_LiveDBConnectionDescription, p_ClientSoftwareVersion)) continue;
                boolAllowed = false;
            }
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
        return boolAllowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyClientLicense(LiveDBSocket p_LiveDBSocket, String p_ClientLicense, LiveDBConnectionDescription p_LiveDBConnectionDescription) {
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        boolean boolAllowed = true;
        Object[] o_Listeners = null;
        Object object = m_SyncServerKernelListeners;
        synchronized (object) {
            if (m_ServerKernelListeners != null) {
                o_Listeners = m_ServerKernelListeners.toArray();
            }
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize && boolAllowed; ++intListener) {
                LiveDBServerKernelListener o_LiveDBServerKernelListener = (LiveDBServerKernelListener)o_Listeners[intListener];
                if (o_LiveDBServerKernelListener == null || o_LiveDBServerKernelListener.verifyClientSoftwareVersion(p_LiveDBConnectionDescription, p_ClientLicense)) continue;
                boolAllowed = false;
            }
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
        return boolAllowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyCloseServer(LiveDBSocket p_LiveDBSocket, int p_ShutdownFlag) {
        LiveDBServerKernelListener o_LiveDBServerKernelListener;
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        boolean boolAllowed = true;
        LiveDBClient o_LiveDBClient = null;
        if (p_LiveDBSocket != null) {
            o_LiveDBClient = LiveDBServerKernel.getLiveDBClient(p_LiveDBSocket.getID());
        }
        ArrayList<LiveDBServerKernelListener> o_LiveDBServerKernelListeners = null;
        Object object = m_SyncServerKernelListeners;
        synchronized (object) {
            if (m_ServerKernelListeners != null) {
                o_LiveDBServerKernelListeners = new ArrayList<LiveDBServerKernelListener>();
                int intListenerSize = m_ServerKernelListeners.size();
                for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                    o_LiveDBServerKernelListener = m_ServerKernelListeners.get(intListener);
                    if (o_LiveDBServerKernelListener == null) continue;
                    o_LiveDBServerKernelListeners.add(o_LiveDBServerKernelListener);
                }
            }
        }
        if (o_LiveDBServerKernelListeners != null) {
            for (int intListener = 0; intListener < o_LiveDBServerKernelListeners.size() && boolAllowed; ++intListener) {
                o_LiveDBServerKernelListener = (LiveDBServerKernelListener)o_LiveDBServerKernelListeners.get(intListener);
                if (o_LiveDBServerKernelListener == null || o_LiveDBServerKernelListener.verifyCloseServer(o_LiveDBClient, p_ShutdownFlag)) continue;
                boolAllowed = false;
            }
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
        return boolAllowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyShutDownLiveDBClient(LiveDBClient p_LiveDBClientActor, LiveDBClient p_LiveDBClientToClose) {
        LiveDBServerKernelListener o_LiveDBServerKernelListener;
        boolean boolAllowed = true;
        if (p_LiveDBClientActor == null) {
            return false;
        }
        if (p_LiveDBClientToClose == null) {
            return false;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        ArrayList<LiveDBServerKernelListener> o_LiveDBServerKernelListeners = null;
        Object object = m_SyncServerKernelListeners;
        synchronized (object) {
            if (m_ServerKernelListeners != null) {
                o_LiveDBServerKernelListeners = new ArrayList<LiveDBServerKernelListener>();
                int intListenerSize = m_ServerKernelListeners.size();
                for (int intListener = 0; intListener < intListenerSize && boolAllowed; ++intListener) {
                    o_LiveDBServerKernelListener = m_ServerKernelListeners.get(intListener);
                    if (o_LiveDBServerKernelListener == null) continue;
                    o_LiveDBServerKernelListeners.add(o_LiveDBServerKernelListener);
                }
            }
        }
        if (o_LiveDBServerKernelListeners != null) {
            for (int intListener = 0; intListener < o_LiveDBServerKernelListeners.size() && boolAllowed; ++intListener) {
                o_LiveDBServerKernelListener = (LiveDBServerKernelListener)o_LiveDBServerKernelListeners.get(intListener);
                if (o_LiveDBServerKernelListener == null || o_LiveDBServerKernelListener.verifyShutDownLiveDBClient(p_LiveDBClientActor, p_LiveDBClientToClose)) continue;
                boolAllowed = false;
            }
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
        return boolAllowed;
    }

    public void eventServerConnectionStatus(int p_ConnectionStatus) {
        m_ConnectionStatus = p_ConnectionStatus;
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
        switch (p_ConnectionStatus) {
            case 0: {
                LiveDBServerKernel.finishCloseServer();
            }
        }
        LiveDBServerKernel.notifyServerKernelListeners_eventServerConnectionStatus(p_ConnectionStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void finishCloseServer() {
        Object object = m_SyncDestruct;
        synchronized (object) {
            m_SyncDestruct.notifyAll();
        }
    }

    public void eventServerError(Exception p_Exception, String p_Remark) {
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        LiveDBServerKernel.notifyServerKernelListeners_eventServerError(p_Exception, p_Remark);
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventServerLiveDBSocketAdded(LiveDBSocket p_LiveDBSocket) {
        if (p_LiveDBSocket == null) {
            return;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        LiveDBClient o_LiveDBClient = LiveDBClient.createLiveDBClient_ServerSide(p_LiveDBSocket);
        boolean boolAdded = false;
        Object object = m_SyncLiveDBClients;
        synchronized (object) {
            if (m_ArrayListLiveDBClients != null) {
                boolAdded = m_ArrayListLiveDBClients.add(o_LiveDBClient);
            }
        }
        if (boolAdded) {
            o_LiveDBClient.addLiveDBClientListener(m_LiveDBServerKernel);
            LiveDBServerKernel.notifyServerKernelListeners_eventLiveDBClientAdded(o_LiveDBClient);
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventServerLiveDBSocketRemoved(LiveDBSocket p_LiveDBSocket) {
        if (p_LiveDBSocket == null) {
            return;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        LiveDBClient o_LiveDBClient = LiveDBServerKernel.getLiveDBClient(p_LiveDBSocket.getID());
        if (o_LiveDBClient != null) {
            boolean boolRemoved = false;
            Object object = m_SyncLiveDBClients;
            synchronized (object) {
                if (m_ArrayListLiveDBClients != null) {
                    boolRemoved = m_ArrayListLiveDBClients.remove(o_LiveDBClient);
                }
            }
            if (boolRemoved) {
                o_LiveDBClient.removeLiveDBClientListener(m_LiveDBServerKernel);
                LiveDBServerKernel.notifyServerKernelListeners_eventLiveDBClientRemoved(o_LiveDBClient);
            }
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    public static void addVerbosedClientIP(LiveDBClient p_LivDBClient) {
        if (p_LivDBClient == null) {
            return;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        LiveDBConnectionDescription o_LiveDBConnectionDescription = p_LivDBClient.getLiveDBConnectionDescription();
        if (o_LiveDBConnectionDescription != null) {
            String stringClientIP = o_LiveDBConnectionDescription.getClientRemoteIP();
            LiveDBSocketChannelManagement.addVerbosedClientIP((String)stringClientIP);
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    public static void addVerbosedClientIP(String p_ClientIP) {
        if (p_ClientIP == null) {
            return;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        LiveDBSocketChannelManagement.addVerbosedClientIP((String)p_ClientIP);
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    public static void removeVerbosedClientIP(String p_ClientIP) {
        if (p_ClientIP == null) {
            return;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        LiveDBSocketChannelManagement.removeVerbosedClientIP((String)p_ClientIP);
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    public static void removeVerbosedClientIP(LiveDBClient p_LivDBClient) {
        if (p_LivDBClient == null) {
            return;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        LiveDBConnectionDescription o_LiveDBConnectionDescription = p_LivDBClient.getLiveDBConnectionDescription();
        if (o_LiveDBConnectionDescription != null) {
            String stringClientIP = o_LiveDBConnectionDescription.getClientRemoteIP();
            LiveDBSocketChannelManagement.removeVerbosedClientIP((String)stringClientIP);
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    public static void clearVerbosedClientIPs() {
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        LiveDBSocketChannelManagement.clearVerbosedClientIPs();
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    private static ArrayList<String> getVerbosedClientIPs() {
        ArrayList<String> o_ArrayListVerbosedIPs = new ArrayList<String>();
        int intVerbosedIPsCount = LiveDBSocketChannelManagement.getVerbosedClientIPsCount();
        for (int intIP = 0; intIP < intVerbosedIPsCount; ++intIP) {
            String stringVerbosedIP = LiveDBSocketChannelManagement.getVerbosedClientIP((int)intIP);
            if (stringVerbosedIP == null) continue;
            o_ArrayListVerbosedIPs.add(stringVerbosedIP);
        }
        return o_ArrayListVerbosedIPs;
    }

    public void eventServerVerbosedClientIP(String p_VerbosedIP, boolean p_Added) {
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        if (p_Added) {
            if (m_ArrayListVerbosedIPs != null && !m_ArrayListVerbosedIPs.contains(p_VerbosedIP)) {
                m_ArrayListVerbosedIPs.add(p_VerbosedIP);
            }
        } else if (m_ArrayListVerbosedIPs != null) {
            m_ArrayListVerbosedIPs.remove(p_VerbosedIP);
        }
        LiveDBServerKernel.notifyServerKernelListeners_eventServerVerbosedClientIP(p_VerbosedIP, p_Added);
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLiveDBServerKernelListener(LiveDBServerKernelListener p_LiveDBServerKernelListener) {
        if (p_LiveDBServerKernelListener == null) {
            return;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        Object object = m_SyncServerKernelListeners;
        synchronized (object) {
            if (m_ServerKernelListeners != null && !m_ServerKernelListeners.contains(p_LiveDBServerKernelListener)) {
                m_ServerKernelListeners.add(p_LiveDBServerKernelListener);
            }
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeLiveDBServerKernelListener(LiveDBServerKernelListener p_LiveDBServerKernelListener) {
        if (p_LiveDBServerKernelListener == null) {
            return false;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        boolean boolRemoved = false;
        Object object = m_SyncServerKernelListeners;
        synchronized (object) {
            if (m_ServerKernelListeners != null) {
                boolRemoved = m_ServerKernelListeners.remove(p_LiveDBServerKernelListener);
            }
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
        return boolRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyServerKernelListeners_eventServerConnectionStatus(int p_ConnectionStatus) {
        Object[] o_Listeners = null;
        Object object = m_SyncServerKernelListeners;
        synchronized (object) {
            if (m_ServerKernelListeners == null) {
                return;
            }
            o_Listeners = m_ServerKernelListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBServerKernelListener o_LiveDBServerKernelListener = (LiveDBServerKernelListener)o_Listeners[intListener];
                if (o_LiveDBServerKernelListener == null) continue;
                o_LiveDBServerKernelListener.eventServerConnectionStatus(p_ConnectionStatus);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyServerKernelListeners_eventServerError(Exception p_Exception, String p_Remark) {
        Object[] o_Listeners = null;
        Object object = m_SyncServerKernelListeners;
        synchronized (object) {
            if (m_ServerKernelListeners == null) {
                return;
            }
            o_Listeners = m_ServerKernelListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBServerKernelListener o_LiveDBServerKernelListener = (LiveDBServerKernelListener)o_Listeners[intListener];
                if (o_LiveDBServerKernelListener == null) continue;
                o_LiveDBServerKernelListener.eventServerError(p_Exception, p_Remark);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyServerKernelListeners_eventLiveDBClientAdded(LiveDBClient p_LiveDBClient) {
        Object[] o_Listeners = null;
        Object object = m_SyncServerKernelListeners;
        synchronized (object) {
            if (m_ServerKernelListeners == null) {
                return;
            }
            o_Listeners = m_ServerKernelListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBServerKernelListener o_LiveDBServerKernelListener = (LiveDBServerKernelListener)o_Listeners[intListener];
                if (o_LiveDBServerKernelListener == null) continue;
                o_LiveDBServerKernelListener.eventServerLiveDBClientAdded(p_LiveDBClient);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyServerKernelListeners_eventLiveDBClientRemoved(LiveDBClient p_LiveDBClient) {
        Object[] o_Listeners = null;
        Object object = m_SyncServerKernelListeners;
        synchronized (object) {
            if (m_ServerKernelListeners == null) {
                return;
            }
            o_Listeners = m_ServerKernelListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBServerKernelListener o_LiveDBServerKernelListener = (LiveDBServerKernelListener)o_Listeners[intListener];
                if (o_LiveDBServerKernelListener == null) continue;
                o_LiveDBServerKernelListener.eventServerLiveDBClientRemoved(p_LiveDBClient);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyServerKernelListeners_eventServerVerbosedClientIP(String p_ClientIP, boolean p_New) {
        Object[] o_Listeners = null;
        Object object = m_SyncServerKernelListeners;
        synchronized (object) {
            if (m_ServerKernelListeners == null) {
                return;
            }
            o_Listeners = m_ServerKernelListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBServerKernelListener o_LiveDBServerKernelListener = (LiveDBServerKernelListener)o_Listeners[intListener];
                if (o_LiveDBServerKernelListener == null) continue;
                o_LiveDBServerKernelListener.eventServerVerbosedClientIP(p_ClientIP, p_New);
            }
        }
    }

    @Override
    public void eventClientConnectionStatus(LiveDBClient p_LiveDBClient, int p_ConnectionStatus) {
        if (p_LiveDBClient == null) {
            return;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        LiveDBServerKernel.notifyServerKernelListeners_eventClientConnectionStatus(p_LiveDBClient, p_ConnectionStatus);
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    @Override
    public void eventClientMessageReadUnknown(LiveDBClient p_LiveDBClient) {
        if (p_LiveDBClient == null) {
            return;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        LiveDBServerKernel.notifyServerKernelListeners_eventClientMessageReadUnknown(p_LiveDBClient);
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    @Override
    public void eventClientMessageWritten(LiveDBClient p_LiveDBClient, Object p_MessageObject) {
        if (p_LiveDBClient == null) {
            return;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        LiveDBServerKernel.notifyServerKernelListeners_eventMessageWritten(p_LiveDBClient, p_MessageObject);
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    @Override
    public void eventClientError(LiveDBClient p_LiveDBClient, Exception p_Exception, String p_Remark) {
        if (p_LiveDBClient == null) {
            return;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        LiveDBServerKernel.notifyServerKernelListeners_eventClientError(p_LiveDBClient, p_Exception, p_Remark);
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseMessage(LiveDBClient p_LiveDBClient, Serializable p_MessageObject) {
        if (p_LiveDBClient == null) {
            return;
        }
        if (p_MessageObject == null) {
            return;
        }
        if (p_MessageObject instanceof LiveDBMessageLiveDBShutDown) {
            if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
                return;
            }
            boolean boolAllow = false;
            LiveDBMessageLiveDBShutDown o_Mesage = (LiveDBMessageLiveDBShutDown)p_MessageObject;
            LiveDBClient o_LiveDBClientToClose = LiveDBServerKernel.getLiveDBClient(o_Mesage.getClientIDToClose());
            if (o_LiveDBClientToClose != null && (boolAllow = this.verifyShutDownLiveDBClient(p_LiveDBClient, o_LiveDBClientToClose))) {
                LiveDBSocketChannelManagement.finishCloseLiveDBSocket((LiveDBSocket)o_LiveDBClientToClose.getLiveDBSocket());
            }
            m_LiveDBCloseSemaphore.leaveWorkerSection();
        } else if (p_MessageObject instanceof LiveDBMessageLiveDBClientsListRequest) {
            if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
                return;
            }
            LiveDBMessageLiveDBClientsListAnswer o_MessageAnswer = null;
            ArrayList<String> o_ListClientIDs = new ArrayList<String>();
            ArrayList<LiveDBConnectionDescription> o_ListLiveDBConnectionDescriptions = new ArrayList<LiveDBConnectionDescription>();
            ArrayList<Integer> o_ListConnectionStatus = new ArrayList<Integer>();
            Object object = m_SyncLiveDBClients;
            synchronized (object) {
                if (m_ArrayListLiveDBClients != null) {
                    for (int intClient = 0; intClient < m_ArrayListLiveDBClients.size(); ++intClient) {
                        LiveDBClient o_LiveDBClient = m_ArrayListLiveDBClients.get(intClient);
                        o_ListClientIDs.add(o_LiveDBClient.getID());
                        o_ListLiveDBConnectionDescriptions.add(o_LiveDBClient.getLiveDBConnectionDescription());
                        o_ListConnectionStatus.add(o_LiveDBClient.getConnectionStatus());
                    }
                    o_MessageAnswer = new LiveDBMessageLiveDBClientsListAnswer(o_ListClientIDs, o_ListLiveDBConnectionDescriptions, o_ListConnectionStatus);
                }
            }
            if (o_MessageAnswer != null) {
                p_LiveDBClient.sendMessage(o_MessageAnswer);
            }
            m_LiveDBCloseSemaphore.leaveWorkerSection();
        } else {
            LiveDBServerKernel.notifyServerKernelListeners_parseMessage(p_LiveDBClient, p_MessageObject);
            return;
        }
    }

    @Override
    public void parseMessageIncomingStreamStart(LiveDBClient p_LiveDBClient, LiveDBStream p_IncomingStream, LiveDBMessageStreamInfo p_StreamInfo) {
        if (p_LiveDBClient == null) {
            return;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        LiveDBServerKernel.notifyServerKernelListeners_parseMessageIncomingStreamStart(p_LiveDBClient, p_IncomingStream, p_StreamInfo);
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    @Override
    public void parseMessageIncomingStreamEnd(LiveDBClient p_LiveDBClient, LiveDBStream p_IncomingStream, boolean p_EndOfStream, boolean p_Canceled, boolean p_Error, String p_CancelRemark) {
        if (p_LiveDBClient == null) {
            return;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        LiveDBServerKernel.notifyServerKernelListeners_parseMessageIncomingStreamEnd(p_LiveDBClient, p_IncomingStream, p_EndOfStream, p_Canceled, p_Error, p_CancelRemark);
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    @Override
    public void parseMessageIncomingStreamPackage(LiveDBClient p_LiveDBClient, LiveDBStream p_IncomingStream, long p_ReceivedBytes) {
        if (p_LiveDBClient == null) {
            return;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        LiveDBServerKernel.notifyServerKernelListeners_parseMessageIncomingStreamPackage(p_LiveDBClient, p_IncomingStream, p_ReceivedBytes);
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    @Override
    public void parseMessageOutgoingStreamStart(LiveDBClient p_LiveDBClient, LiveDBStream p_OutgoingStream, LiveDBMessageStreamInfo p_StreamInfo) {
        if (p_LiveDBClient == null) {
            return;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        LiveDBServerKernel.notifyServerKernelListeners_parseMessageOutgoingStreamStart(p_LiveDBClient, p_OutgoingStream, p_StreamInfo);
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    @Override
    public void parseMessageOutgoingStreamEnd(LiveDBClient p_LiveDBClient, LiveDBStream p_OutgoingStream, boolean p_EndOfStream, boolean p_Canceled, boolean p_Error, String p_CancelRemark) {
        if (p_LiveDBClient == null) {
            return;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        LiveDBServerKernel.notifyServerKernelListeners_parseMessageOutgoingStreamEnd(p_LiveDBClient, p_OutgoingStream, p_EndOfStream, p_Canceled, p_Error, p_CancelRemark);
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    @Override
    public void parseMessageOutgoingStreamConfirmed(LiveDBClient p_LiveDBClient, LiveDBStream p_OutgoingStream, long p_ReceivedBytes) {
        if (p_LiveDBClient == null) {
            return;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        LiveDBServerKernel.notifyServerKernelListeners_parseMessageOutgoingStreamConfirmed(p_LiveDBClient, p_OutgoingStream, p_ReceivedBytes);
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyServerKernelListeners_eventClientConnectionStatus(LiveDBClient p_LiveDBClient, int p_ConnectionStatus) {
        Object[] o_Listeners = null;
        Object object = m_SyncServerKernelListeners;
        synchronized (object) {
            if (m_ServerKernelListeners == null) {
                return;
            }
            o_Listeners = m_ServerKernelListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBServerKernelListener o_LiveDBServerKernelListener = (LiveDBServerKernelListener)o_Listeners[intListener];
                if (o_LiveDBServerKernelListener == null) continue;
                o_LiveDBServerKernelListener.eventClientConnectionStatus(p_LiveDBClient, p_ConnectionStatus);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyServerKernelListeners_eventClientError(LiveDBClient p_LiveDBClient, Exception p_Exception, String p_Remark) {
        Object[] o_Listeners = null;
        Object object = m_SyncServerKernelListeners;
        synchronized (object) {
            if (m_ServerKernelListeners == null) {
                return;
            }
            o_Listeners = m_ServerKernelListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBServerKernelListener o_LiveDBServerKernelListener = (LiveDBServerKernelListener)o_Listeners[intListener];
                if (o_LiveDBServerKernelListener == null) continue;
                o_LiveDBServerKernelListener.eventClientError(p_LiveDBClient, p_Exception, p_Remark);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyServerKernelListeners_eventClientMessageReadUnknown(LiveDBClient p_LiveDBClient) {
        Object[] o_Listeners = null;
        Object object = m_SyncServerKernelListeners;
        synchronized (object) {
            if (m_ServerKernelListeners == null) {
                return;
            }
            o_Listeners = m_ServerKernelListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBServerKernelListener o_LiveDBServerKernelListener = (LiveDBServerKernelListener)o_Listeners[intListener];
                if (o_LiveDBServerKernelListener == null) continue;
                o_LiveDBServerKernelListener.eventClientMessageReadUnknown(p_LiveDBClient);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyServerKernelListeners_eventMessageWritten(LiveDBClient p_LiveDBClient, Object p_MessageObject) {
        Object[] o_Listeners = null;
        Object object = m_SyncServerKernelListeners;
        synchronized (object) {
            if (m_ServerKernelListeners == null) {
                return;
            }
            o_Listeners = m_ServerKernelListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBServerKernelListener o_LiveDBServerKernelListener = (LiveDBServerKernelListener)o_Listeners[intListener];
                if (o_LiveDBServerKernelListener == null) continue;
                o_LiveDBServerKernelListener.eventClientMessageWritten(p_LiveDBClient, p_MessageObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyServerKernelListeners_parseMessage(LiveDBClient p_LiveDBClient, Serializable p_Message) {
        Object[] o_Listeners = null;
        Object object = m_SyncServerKernelListeners;
        synchronized (object) {
            if (m_ServerKernelListeners == null) {
                return;
            }
            o_Listeners = m_ServerKernelListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBServerKernelListener o_LiveDBServerKernelListener = (LiveDBServerKernelListener)o_Listeners[intListener];
                if (o_LiveDBServerKernelListener == null) continue;
                o_LiveDBServerKernelListener.parseMessage(p_LiveDBClient, p_Message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyServerKernelListeners_parseMessageIncomingStreamStart(LiveDBClient p_Client, LiveDBStream p_IncomingStream, LiveDBMessageStreamInfo p_StreamInfo) {
        Object[] o_Listeners = null;
        Object object = m_SyncServerKernelListeners;
        synchronized (object) {
            if (m_ServerKernelListeners == null) {
                return;
            }
            o_Listeners = m_ServerKernelListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBServerKernelListener o_LiveDBServerKernelListener = (LiveDBServerKernelListener)o_Listeners[intListener];
                if (o_LiveDBServerKernelListener == null) continue;
                o_LiveDBServerKernelListener.parseMessageIncomingStreamStart(p_Client, p_IncomingStream, p_StreamInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyServerKernelListeners_parseMessageIncomingStreamEnd(LiveDBClient p_Client, LiveDBStream p_IncomingStream, boolean p_EndOfStream, boolean p_Canceled, boolean p_Error, String p_CancelRemark) {
        Object[] o_Listeners = null;
        Object object = m_SyncServerKernelListeners;
        synchronized (object) {
            if (m_ServerKernelListeners == null) {
                return;
            }
            o_Listeners = m_ServerKernelListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBServerKernelListener o_LiveDBServerKernelListener = (LiveDBServerKernelListener)o_Listeners[intListener];
                if (o_LiveDBServerKernelListener == null) continue;
                o_LiveDBServerKernelListener.parseMessageIncomingStreamEnd(p_Client, p_IncomingStream, p_EndOfStream, p_Canceled, p_Error, p_CancelRemark);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyServerKernelListeners_parseMessageIncomingStreamPackage(LiveDBClient p_Client, LiveDBStream p_IncomingStream, long p_ReceivedBytes) {
        Object[] o_Listeners = null;
        Object object = m_SyncServerKernelListeners;
        synchronized (object) {
            if (m_ServerKernelListeners == null) {
                return;
            }
            o_Listeners = m_ServerKernelListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBServerKernelListener o_LiveDBServerKernelListener = (LiveDBServerKernelListener)o_Listeners[intListener];
                if (o_LiveDBServerKernelListener == null) continue;
                o_LiveDBServerKernelListener.parseMessageIncomingStreamPackage(p_Client, p_IncomingStream, p_ReceivedBytes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyServerKernelListeners_parseMessageOutgoingStreamStart(LiveDBClient p_Client, LiveDBStream p_OutgoingStream, LiveDBMessageStreamInfo p_StreamInfo) {
        Object[] o_Listeners = null;
        Object object = m_SyncServerKernelListeners;
        synchronized (object) {
            if (m_ServerKernelListeners == null) {
                return;
            }
            o_Listeners = m_ServerKernelListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBServerKernelListener o_LiveDBServerKernelListener = (LiveDBServerKernelListener)o_Listeners[intListener];
                if (o_LiveDBServerKernelListener == null) continue;
                o_LiveDBServerKernelListener.parseMessageOutgoingStreamStart(p_Client, p_OutgoingStream, p_StreamInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyServerKernelListeners_parseMessageOutgoingStreamEnd(LiveDBClient p_Client, LiveDBStream p_OutgoingStream, boolean p_EndOfStream, boolean p_Canceled, boolean p_Error, String p_CancelRemark) {
        Object[] o_Listeners = null;
        Object object = m_SyncServerKernelListeners;
        synchronized (object) {
            if (m_ServerKernelListeners == null) {
                return;
            }
            o_Listeners = m_ServerKernelListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBServerKernelListener o_LiveDBServerKernelListener = (LiveDBServerKernelListener)o_Listeners[intListener];
                if (o_LiveDBServerKernelListener == null) continue;
                o_LiveDBServerKernelListener.parseMessageOutgoingStreamEnd(p_Client, p_OutgoingStream, p_EndOfStream, p_Canceled, p_Error, p_CancelRemark);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyServerKernelListeners_parseMessageOutgoingStreamConfirmed(LiveDBClient p_Client, LiveDBStream p_OutgoingStream, long p_ReceivedBytes) {
        Object[] o_Listeners = null;
        Object object = m_SyncServerKernelListeners;
        synchronized (object) {
            if (m_ServerKernelListeners == null) {
                return;
            }
            o_Listeners = m_ServerKernelListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBServerKernelListener o_LiveDBServerKernelListener = (LiveDBServerKernelListener)o_Listeners[intListener];
                if (o_LiveDBServerKernelListener == null) continue;
                o_LiveDBServerKernelListener.parseMessageOutgoingStreamConfirmed(p_Client, p_OutgoingStream, p_ReceivedBytes);
            }
        }
    }

    public static boolean loadRareByteInterpreter(String p_JarPathName, String p_ClassName) {
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        boolean boolOK = false;
        boolOK = LiveDBSocketChannelManagement.loadRareByteInterpreter((String)p_JarPathName, (String)p_ClassName);
        m_LiveDBCloseSemaphore.leaveWorkerSection();
        return boolOK;
    }

    public static long getFreeMemory() {
        return LiveDBSocketChannelManagement.getFreeMemory();
    }

    public static long getMaximalMemory() {
        return LiveDBSocketChannelManagement.getMaximalMemory();
    }

    public static long getTotalMemory() {
        return LiveDBSocketChannelManagement.getTotalMemory();
    }

    public static void setGarbageCollectionRatio(double p_Ratio) {
        LiveDBSocketChannelManagement.setGarbageCollectionRatio((double)p_Ratio);
    }

    public static boolean checkGarbageCollection() {
        return LiveDBSocketChannelManagement.checkGarbageCollection();
    }
}

