/*
 * Decompiled with CFR 0.152.
 */
package com.liveshowsound;

import com.liveshowsound.Exception_SoundCardLost;
import com.liveshowsound.PlayBuffer;
import javax.sound.sampled.AudioFormat;

public class Device {
    private long nativePointer;
    private String GUID;
    private String m_Name;
    private String m_Description;
    private int m_Channels;
    private int m_SampleRate;
    private int m_BitsPerSample;
    private AudioFormat m_AudioFormat;
    private PlayBuffer m_PlayBuffer;

    public Device() {
        this.initMembers();
    }

    private void initMembers() {
        this.nativePointer = 0L;
        this.GUID = "";
        this.m_Description = "";
        this.m_Channels = 0;
        this.m_PlayBuffer = null;
        this.m_AudioFormat = null;
    }

    public void close() {
        Device.closeDevice(this);
    }

    public static native int closeDevice(Device var0);

    public long getNativePointer() {
        return this.nativePointer;
    }

    public String getGUID() {
        return this.GUID;
    }

    public String getName() {
        return this.m_Name;
    }

    public String getDescription() {
        return this.m_Description;
    }

    public int getChannels() {
        return this.m_Channels;
    }

    public AudioFormat getAudioFormat() {
        if (this.m_AudioFormat == null) {
            this.m_AudioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, this.m_SampleRate, this.m_BitsPerSample, this.m_Channels, this.m_Channels * this.m_BitsPerSample / 8, this.m_SampleRate, false);
        }
        return this.m_AudioFormat;
    }

    public boolean getNativeDeviceExist() {
        return this.nativePointer > 0L;
    }

    public PlayBuffer createPlayBuffer(int p_BufferSize_Frames, int p_BufferGranularity) throws Exception_SoundCardLost {
        int intResult;
        PlayBuffer o_PlayBuffer = new PlayBuffer(this);
        try {
            intResult = Device.createPlayBuffer(this, o_PlayBuffer, p_BufferSize_Frames, p_BufferGranularity);
        }
        catch (Exception e) {
            this.m_PlayBuffer = null;
            throw new Exception_SoundCardLost("Device createPlayBuffer " + e.getMessage());
        }
        if (intResult != 0) {
            this.m_PlayBuffer = null;
            throw new Exception_SoundCardLost("Device createPlayBuffer");
        }
        this.m_PlayBuffer = o_PlayBuffer;
        return o_PlayBuffer;
    }

    public static native int createPlayBuffer(Device var0, PlayBuffer var1, int var2, int var3) throws Exception;

    public PlayBuffer getPlayBuffer() {
        return this.m_PlayBuffer;
    }
}

