/*
 * Decompiled with CFR 0.152.
 */
package ToolsGraphics;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;

public class Polygon2D {
    public int npoints;
    public double[] xpoints;
    public double[] ypoints;
    protected Rectangle2D bounds;
    protected Rectangle m_BoundingRectangle;
    private static final long serialVersionUID = -6460061437900069969L;
    private static final int MIN_LENGTH = 4;
    protected int m_Precision = (int)Math.pow(10.0, 5.0);

    public Polygon2D() {
        this.xpoints = new double[4];
        this.ypoints = new double[4];
        this.m_BoundingRectangle = new Rectangle();
    }

    public Polygon2D(double[] xpoints, double[] ypoints, int npoints) {
        if (npoints > xpoints.length || npoints > ypoints.length) {
            throw new IndexOutOfBoundsException("npoints > xpoints.length || npoints > ypoints.length");
        }
        if (npoints < 0) {
            throw new NegativeArraySizeException("npoints < 0");
        }
        this.npoints = npoints;
        this.xpoints = Arrays.copyOf(xpoints, npoints);
        this.ypoints = Arrays.copyOf(ypoints, npoints);
        this.m_BoundingRectangle = new Rectangle();
    }

    public void reset() {
        this.npoints = 0;
        this.bounds = null;
    }

    public void invalidate() {
        this.bounds = null;
    }

    public void translate(double deltaX, double deltaY) {
        int i = 0;
        while (i < this.npoints) {
            int n = i;
            this.xpoints[n] = this.xpoints[n] + deltaX;
            int n2 = i++;
            this.ypoints[n2] = this.ypoints[n2] + deltaY;
        }
        if (this.bounds != null) {
            this.translate(this.bounds, deltaX, deltaY);
        }
    }

    public void translate(Rectangle2D p_Rectangle2D, double dx, double dy) {
        double oldv = p_Rectangle2D.getX();
        double newv = oldv + dx;
        double doubleWidth = p_Rectangle2D.getWidth();
        if (dx < 0.0) {
            if (newv > oldv) {
                if (p_Rectangle2D.getWidth() >= 0.0) {
                    doubleWidth = p_Rectangle2D.getWidth() + newv - Double.MIN_VALUE;
                }
                newv = -2.147483648E9;
            }
        } else if (newv < oldv) {
            if (p_Rectangle2D.getWidth() >= 0.0 && (doubleWidth = p_Rectangle2D.getWidth() + newv - Double.MAX_VALUE) < 0.0) {
                doubleWidth = Double.MAX_VALUE;
            }
            newv = Double.MAX_VALUE;
        }
        double doubleX = newv;
        oldv = p_Rectangle2D.getY();
        newv = oldv + dy;
        double doubleHeight = p_Rectangle2D.getHeight();
        if (dy < 0.0) {
            if (newv > oldv) {
                if (p_Rectangle2D.getHeight() >= 0.0) {
                    doubleHeight = p_Rectangle2D.getHeight() + newv - -2.147483648E9;
                }
                newv = -2.147483648E9;
            }
        } else if (newv < oldv) {
            if (p_Rectangle2D.getHeight() >= 0.0 && (doubleHeight = p_Rectangle2D.getHeight() + newv - Double.MAX_VALUE) < 0.0) {
                doubleHeight = Double.MAX_VALUE;
            }
            newv = Double.MAX_VALUE;
        }
        double doubleY = newv;
        p_Rectangle2D.setRect(doubleX, doubleY, doubleWidth, doubleHeight);
    }

    void calculateBounds(double[] xpoints, double[] ypoints, int npoints) {
        double boundsMinX = Double.MAX_VALUE;
        double boundsMinY = Double.MAX_VALUE;
        double boundsMaxX = Double.MIN_VALUE;
        double boundsMaxY = Double.MIN_VALUE;
        for (int i = 0; i < npoints; ++i) {
            double x = xpoints[i];
            boundsMinX = Math.min(boundsMinX, x);
            boundsMaxX = Math.max(boundsMaxX, x);
            double y = ypoints[i];
            boundsMinY = Math.min(boundsMinY, y);
            boundsMaxY = Math.max(boundsMaxY, y);
        }
        if (this.bounds == null) {
            this.bounds = new Rectangle2D.Double();
        }
        this.bounds.setRect(boundsMinX, boundsMinY, boundsMaxX - boundsMinX, boundsMaxY - boundsMinY);
    }

    void updateBounds(double p_X, double p_y) {
        double doubleX = this.bounds.getX();
        double doubleY = this.bounds.getY();
        double doubleWidth = this.bounds.getWidth();
        double doubleHeight = this.bounds.getHeight();
        if (p_X < doubleX) {
            doubleWidth += this.bounds.getX() - p_X;
            doubleX = p_X;
        } else {
            doubleWidth = Math.max(doubleWidth, p_X - doubleX);
        }
        if (p_y < doubleY) {
            doubleHeight += doubleY - p_y;
            doubleY = p_y;
        } else {
            doubleHeight = Math.max(doubleHeight, p_y - doubleY);
        }
    }

    public void addPoint(double x, double y) {
        if (this.npoints >= this.xpoints.length || this.npoints >= this.ypoints.length) {
            int newLength = this.npoints * 2;
            if (newLength < 4) {
                newLength = 4;
            } else if ((newLength & newLength - 1) != 0) {
                newLength = Integer.highestOneBit(newLength);
            }
            this.xpoints = Arrays.copyOf(this.xpoints, newLength);
            this.ypoints = Arrays.copyOf(this.ypoints, newLength);
        }
        this.xpoints[this.npoints] = x;
        this.ypoints[this.npoints] = y;
        ++this.npoints;
        if (this.bounds != null) {
            this.updateBounds(x, y);
        }
    }

    public void addPoint(Point2D p_Point2D) {
        this.addPoint(p_Point2D.getX(), p_Point2D.getY());
    }

    public Point2D getPoint(int p_Index) {
        if (p_Index < 0 || p_Index >= this.npoints) {
            return null;
        }
        Point2D.Double o_Point2D = new Point2D.Double();
        ((Point2D)o_Point2D).setLocation(this.xpoints[p_Index], this.ypoints[p_Index]);
        return o_Point2D;
    }

    public Rectangle getBounds() {
        if (this.bounds == null) {
            this.getBounds2D();
        }
        this.m_BoundingRectangle.setRect(this.bounds.getX(), this.bounds.getY(), this.bounds.getWidth(), this.bounds.getHeight());
        return this.m_BoundingRectangle;
    }

    public boolean contains(Point p) {
        return this.contains(p.x, p.y);
    }

    public boolean contains(int x, int y) {
        return this.contains((double)x, (double)y);
    }

    @Deprecated
    public boolean inside(int x, int y) {
        return this.contains((double)x, (double)y);
    }

    public Rectangle2D getBounds2D() {
        if (this.npoints == 0) {
            return new Rectangle2D.Double();
        }
        if (this.bounds == null) {
            this.calculateBounds(this.xpoints, this.ypoints, this.npoints);
        }
        return this.bounds.getBounds2D();
    }

    public boolean containedInBound(double p_X, double p_Y) {
        if (this.bounds == null) {
            this.getBounds2D();
        }
        return p_X >= this.bounds.getX() && p_Y >= this.bounds.getY() && p_X <= this.bounds.getX() + this.bounds.getWidth() && p_Y <= this.bounds.getY() + this.bounds.getHeight();
    }

    public boolean contains(double p_x, double p_y) {
        int wn = 0;
        double x1 = this.xpoints[this.npoints - 1];
        double y1 = this.ypoints[this.npoints - 1];
        double x2 = this.xpoints[0];
        double y2 = this.ypoints[0];
        boolean startUeber = y1 >= p_y;
        for (int i = 1; i <= this.npoints; ++i) {
            boolean endUeber;
            double doubleTerm1 = x2 - p_x;
            double doubleTerm2 = y2 - p_y;
            double doubleInteger = (long)doubleTerm1;
            double doubleDecimalPlace = doubleTerm1 - doubleInteger;
            doubleDecimalPlace = (double)((long)(doubleDecimalPlace * (double)this.m_Precision)) / (double)this.m_Precision;
            doubleTerm1 = doubleInteger + doubleDecimalPlace;
            doubleInteger = (long)doubleTerm2;
            doubleDecimalPlace = doubleTerm2 - doubleInteger;
            doubleDecimalPlace = (double)((long)(doubleDecimalPlace * (double)this.m_Precision)) / (double)this.m_Precision;
            doubleTerm2 = doubleInteger + doubleDecimalPlace;
            if (doubleTerm1 == 0.0 && doubleTerm2 == 0.0) {
                return true;
            }
            boolean bl = endUeber = y2 >= p_y;
            if (startUeber != endUeber) {
                doubleTerm1 = (y2 - p_y) * (x2 - x1);
                doubleTerm2 = (y2 - y1) * (x2 - p_x);
                doubleInteger = (long)doubleTerm1;
                doubleDecimalPlace = doubleTerm1 - doubleInteger;
                doubleDecimalPlace = (double)((long)(doubleDecimalPlace * (double)this.m_Precision)) / (double)this.m_Precision;
                doubleTerm1 = doubleInteger + doubleDecimalPlace;
                doubleInteger = (long)doubleTerm2;
                doubleDecimalPlace = doubleTerm2 - doubleInteger;
                doubleTerm2 = doubleInteger + (doubleDecimalPlace = (double)((long)(doubleDecimalPlace * (double)this.m_Precision)) / (double)this.m_Precision);
                if (doubleTerm1 <= doubleTerm2) {
                    if (endUeber) {
                        ++wn;
                    }
                } else if (!endUeber) {
                    --wn;
                }
            }
            if (i >= this.npoints) break;
            startUeber = endUeber;
            y1 = y2;
            x1 = x2;
            x2 = this.xpoints[i];
            y2 = this.ypoints[i];
        }
        return wn != 0;
    }

    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return new PolygonPathIterator(this, at);
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }

    class PolygonPathIterator
    implements PathIterator {
        Polygon2D poly;
        AffineTransform transform;
        int index;

        public PolygonPathIterator(Polygon2D pg, AffineTransform at) {
            this.poly = pg;
            this.transform = at;
            if (pg.npoints == 0) {
                this.index = 1;
            }
        }

        @Override
        public int getWindingRule() {
            return 0;
        }

        @Override
        public boolean isDone() {
            return this.index > this.poly.npoints;
        }

        @Override
        public void next() {
            ++this.index;
        }

        @Override
        public int currentSegment(float[] coords) {
            if (this.index >= this.poly.npoints) {
                return 4;
            }
            coords[0] = (float)this.poly.xpoints[this.index];
            coords[1] = (float)this.poly.ypoints[this.index];
            if (this.transform != null) {
                this.transform.transform(coords, 0, coords, 0, 1);
            }
            return this.index == 0 ? 0 : 1;
        }

        @Override
        public int currentSegment(double[] coords) {
            if (this.index >= this.poly.npoints) {
                return 4;
            }
            coords[0] = this.poly.xpoints[this.index];
            coords[1] = this.poly.ypoints[this.index];
            if (this.transform != null) {
                this.transform.transform(coords, 0, coords, 0, 1);
            }
            return this.index == 0 ? 0 : 1;
        }
    }
}

