/*
 * Decompiled with CFR 0.152.
 */
package ToolsGraphics;

import GraphicsDeviceToolsPackage.GraphicsDeviceTools;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import SwingToolTipPackage.PopUpToolTip;
import ToolsGraphics.ImagesTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class LiveShowHTMLDocument
extends HTMLDocument
implements Externalizable,
DocumentListener {
    private static final long serialVersionUID = -2191570369962370294L;
    public static int s_SoftwareVersion = 1;
    public static HTMLEditorKit s_HTMLEditorKit = new HTMLEditorKit();
    private static Font DEFAULT_FONT;
    private static String DEFAULT_COLOR_STRING;
    private String m_HTML;
    private transient JTextComponent m_Owner;

    public static HTMLEditorKit getHTMLEditorKit() {
        return s_HTMLEditorKit;
    }

    public LiveShowHTMLDocument() {
        this.initMembers();
        this.initComponents();
    }

    private void initMembers() {
    }

    private void initComponents() {
        this.m_HTML = "";
        this.addDocumentListener(this);
        this.putProperty("IgnoreCharsetDirective", new Boolean(true));
    }

    public void close() {
        this.removeDocumentListener(this);
    }

    public void addFontRule_White() {
        String bodyRule = "body { font-family: " + DEFAULT_FONT.getFamily() + "; font-size: " + DEFAULT_FONT.getSize() + "pt; color: " + DEFAULT_COLOR_STRING + ";}";
        this.getStyleSheet().addRule(bodyRule);
    }

    public void setOwner(JTextComponent p_Object) {
        this.m_Owner = p_Object;
        if (this.m_Owner == null) {
            return;
        }
    }

    public Object getOwner() {
        return this.m_Owner;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        try {
            StringWriter o_StringWriter = new StringWriter();
            s_HTMLEditorKit.write(o_StringWriter, (Document)this, 0, this.getContent().length());
            o_StringWriter.flush();
            this.m_HTML = o_StringWriter.toString();
            this.m_HTML = this.m_HTML.replaceAll("\r", "");
            this.m_HTML = this.m_HTML.replaceAll("\n", "");
            o_StringWriter.close();
            out.writeInt(s_SoftwareVersion);
            out.writeUTF(this.m_HTML);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            int intSoftwareVersion = in.readInt();
            this.m_HTML = in.readUTF();
            StringReader o_StringReader = new StringReader(this.m_HTML);
            s_HTMLEditorKit.read(o_StringReader, (Document)this, 0);
        }
        catch (Exception e) {
            this.m_HTML = "";
        }
    }

    public static ByteBuffer saveDocumentInByteBuffer(LiveShowHTMLDocument p_Document) {
        if (p_Document == null) {
            return null;
        }
        ByteBuffer o_ByteBuffer = null;
        try {
            ByteArrayOutputStream o_ByteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream o_ObjectOutputStream = new ObjectOutputStream(o_ByteArrayOutputStream);
            p_Document.writeExternal(o_ObjectOutputStream);
            o_ObjectOutputStream.flush();
            o_ByteBuffer = ByteBuffer.allocate(o_ByteArrayOutputStream.size());
            o_ByteBuffer.put(o_ByteArrayOutputStream.toByteArray());
            o_ObjectOutputStream.close();
            o_ByteArrayOutputStream.close();
        }
        catch (Exception e) {
            return null;
        }
        return o_ByteBuffer;
    }

    public static LiveShowHTMLDocument loadDocumentInByteBuffer(ByteBuffer p_ByteBuffer) {
        if (p_ByteBuffer == null) {
            return null;
        }
        LiveShowHTMLDocument o_Document = null;
        try {
            ByteArrayInputStream o_ByteArrayInputStream = new ByteArrayInputStream(p_ByteBuffer.array());
            ObjectInputStream o_ObjectInputStream = new ObjectInputStream(o_ByteArrayInputStream);
            o_Document = new LiveShowHTMLDocument();
            o_Document.addFontRule_White();
            o_Document.readExternal(o_ObjectInputStream);
            o_ObjectInputStream.close();
            o_ByteArrayInputStream.close();
        }
        catch (Exception e) {
            return null;
        }
        return o_Document;
    }

    public void read(Reader in, int pos) throws IOException, BadLocationException {
        int nch;
        char[] buff = new char[4096];
        boolean lastWasCR = false;
        boolean isCRLF = false;
        boolean isCR = false;
        boolean wasEmpty = true;
        StringBuilder o_StringBuffer = new StringBuilder();
        while ((nch = in.read(buff, 0, buff.length)) != -1) {
            int last = 0;
            block5: for (int counter = 0; counter < nch; ++counter) {
                switch (buff[counter]) {
                    case '\r': {
                        if (lastWasCR) {
                            isCR = true;
                            if (counter == 0) {
                                o_StringBuffer.append("\n");
                                ++pos;
                                continue block5;
                            }
                            buff[counter - 1] = 10;
                            continue block5;
                        }
                        lastWasCR = true;
                        continue block5;
                    }
                    case '\n': {
                        if (!lastWasCR) continue block5;
                        if (counter > last + 1) {
                            o_StringBuffer.append(buff, last, counter - last - 1);
                            pos += counter - last - 1;
                        }
                        lastWasCR = false;
                        last = counter;
                        isCRLF = true;
                        continue block5;
                    }
                    default: {
                        if (!lastWasCR) continue block5;
                        isCR = true;
                        if (counter == 0) {
                            o_StringBuffer.append("\n");
                            ++pos;
                        } else {
                            buff[counter - 1] = 10;
                        }
                        lastWasCR = false;
                    }
                }
            }
            if (last >= nch) continue;
            if (lastWasCR) {
                if (last >= nch - 1) continue;
                o_StringBuffer.append(buff, last, nch - last - 1);
                pos += nch - last - 1;
                continue;
            }
            o_StringBuffer.append(buff, last, nch - last);
            pos += nch - last;
        }
        if (lastWasCR) {
            o_StringBuffer.append("\n");
            isCR = true;
        }
        this.m_HTML = o_StringBuffer.toString();
        int intStart = this.m_HTML.indexOf("<html>");
        if (intStart >= 0) {
            // empty if block
        }
        this.m_HTML = this.m_HTML.trim();
    }

    public String getHTMLString() {
        return this.m_HTML;
    }

    public String getText() {
        try {
            return super.getText(0, this.getLength());
        }
        catch (Exception e) {
            System.out.println(e);
            return "";
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    public static TextToolBar createTextToolBar() {
        TextToolBar jToolBar_Text = new TextToolBar();
        jToolBar_Text.setFloatable(false);
        JButton jButton_Bold = new JButton();
        jButton_Bold.setAction(new BoldAction());
        jButton_Bold.setText("");
        jButton_Bold.setIconTextGap(0);
        jButton_Bold.setToolTipText(TextToolBar.BOLD);
        jButton_Bold.setContentAreaFilled(false);
        jButton_Bold.setIcon(new ImageIcon(LiveShowHTMLDocument.class.getResource("/IconsPackage/TextFormat_Bold.png")));
        jButton_Bold.setPressedIcon(new ImageIcon(LiveShowHTMLDocument.class.getResource("/IconsPackage/ButtonPressed.png")));
        JButton jButton_Italic = new JButton();
        jButton_Italic.setAction(new ItalicAction());
        jButton_Italic.setText("");
        jButton_Italic.setIconTextGap(0);
        jButton_Italic.setToolTipText(TextToolBar.ITALIC);
        jButton_Italic.setContentAreaFilled(false);
        jButton_Italic.setIcon(new ImageIcon(LiveShowHTMLDocument.class.getResource("/IconsPackage/TextFormat_Italic.png")));
        jButton_Italic.setPressedIcon(new ImageIcon(LiveShowHTMLDocument.class.getResource("/IconsPackage/ButtonPressed.png")));
        JButton jButton_Font = new JButton();
        jButton_Font.setAction(new FontAndSizeAction());
        jButton_Font.setText("");
        jButton_Font.setIconTextGap(0);
        jButton_Font.setToolTipText(TextToolBar.FONT);
        jButton_Font.setContentAreaFilled(false);
        jButton_Font.setIcon(new ImageIcon(LiveShowHTMLDocument.class.getResource("/IconsPackage/TextFormat_FontSize.png")));
        jButton_Font.setPressedIcon(new ImageIcon(LiveShowHTMLDocument.class.getResource("/IconsPackage/ButtonPressed.png")));
        JButton jButton_Foreground = new JButton();
        jButton_Foreground.setAction(new ForegroundAction());
        jButton_Foreground.setText("");
        jButton_Foreground.setIconTextGap(0);
        jButton_Foreground.setToolTipText(TextToolBar.FOREGROUND);
        jButton_Foreground.setContentAreaFilled(false);
        jButton_Foreground.setIcon(new ImageIcon(LiveShowHTMLDocument.class.getResource("/IconsPackage/TextFormat_Foreground.png")));
        jButton_Foreground.setPressedIcon(new ImageIcon(LiveShowHTMLDocument.class.getResource("/IconsPackage/ButtonPressed.png")));
        JButton jButton_Background = new JButton();
        jButton_Background.setAction(new BackgroundAction());
        jButton_Background.setText("");
        jButton_Background.setIconTextGap(0);
        jButton_Background.setToolTipText(TextToolBar.BACKGROUND);
        jButton_Background.setContentAreaFilled(false);
        jButton_Background.setIcon(new ImageIcon(LiveShowHTMLDocument.class.getResource("/IconsPackage/TextFormat_Background.png")));
        jButton_Background.setPressedIcon(new ImageIcon(LiveShowHTMLDocument.class.getResource("/IconsPackage/ButtonPressed.png")));
        JButton jButton_Image = new JButton();
        jButton_Image.setAction(new ImageAction());
        jButton_Image.setText("");
        jButton_Image.setIconTextGap(0);
        jButton_Image.setToolTipText(TextToolBar.IMAGE);
        jButton_Image.setContentAreaFilled(false);
        jButton_Image.setIcon(new ImageIcon(LiveShowHTMLDocument.class.getResource("/IconsPackage/Image.png")));
        jButton_Image.setPressedIcon(new ImageIcon(LiveShowHTMLDocument.class.getResource("/IconsPackage/ButtonPressed.png")));
        jToolBar_Text.add(jButton_Font);
        jToolBar_Text.add(jButton_Bold);
        jToolBar_Text.add(jButton_Italic);
        jToolBar_Text.add(jButton_Foreground);
        jButton_Background.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        jButton_Bold.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        jButton_Font.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        jButton_Foreground.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        jButton_Image.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        jButton_Italic.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        return jToolBar_Text;
    }

    static {
        s_HTMLEditorKit.setDefaultCursor(Cursor.getPredefinedCursor(2));
        DEFAULT_FONT = new Font("Tahoma", 0, 16);
        DEFAULT_COLOR_STRING = "white";
    }

    public static class ImageAction
    extends StyledEditorKit.StyledTextAction {
        public ImageAction() {
            super("Image");
        }

        public String toString() {
            return "Image";
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextPane jTextPane = (JTextPane)this.getEditor(e);
            if (jTextPane == null) {
                return;
            }
            BufferedImage o_BufferedImage = ImagesTools.loadImageFileDialog(TextToolBar.IMAGE, null);
            if (o_BufferedImage == null) {
                return;
            }
            ImageIcon o_Icon = new ImageIcon(o_BufferedImage);
            jTextPane.insertIcon(o_Icon);
            jTextPane.requestFocusInWindow();
        }
    }

    public static class FontAndSizeAction
    extends StyledEditorKit.StyledTextAction {
        private static final long serialVersionUID = 584531387732416339L;
        private String m_FontFamily;
        private float m_FontSize;

        public FontAndSizeAction() {
            super("Font and Size");
        }

        private void initComponents() {
        }

        public String toString() {
            return "Font and Size";
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextPane o_TextPane = (JTextPane)this.getEditor(e);
            if (o_TextPane == null) {
                return;
            }
            int intSelectionStart = o_TextPane.getSelectionStart();
            StyledDocument o_StyledDocument = this.getStyledDocument(o_TextPane);
            Element o_Element = o_StyledDocument.getCharacterElement(intSelectionStart);
            AttributeSet o_AttributeSet = o_Element.getAttributes();
            this.m_FontFamily = StyleConstants.getFontFamily(o_AttributeSet);
            this.m_FontSize = StyleConstants.getFontSize(o_AttributeSet);
            TextToolBar.s_FontSizeChooser.setTitle(TextToolBar.FONT);
            TextToolBar.s_FontSizeChooser.setFontFamily(this.m_FontFamily);
            TextToolBar.s_FontSizeChooser.setFontSize(this.m_FontSize);
            if (TextToolBar.s_FontSizeChooser.showDialog() != null) {
                this.m_FontFamily = TextToolBar.s_FontSizeChooser.getFontFamily();
                this.m_FontSize = TextToolBar.s_FontSizeChooser.getFontSize();
                SimpleAttributeSet o_MutableAttributeSet = null;
                o_MutableAttributeSet = new SimpleAttributeSet();
                StyleConstants.setFontFamily(o_MutableAttributeSet, this.m_FontFamily);
                StyleConstants.setFontSize(o_MutableAttributeSet, (int)this.m_FontSize);
                this.setCharacterAttributes(o_TextPane, o_MutableAttributeSet, false);
            }
            o_TextPane.requestFocusInWindow();
        }
    }

    public static class FontSizeChooser
    extends JDialog {
        public static Icon s_Icon = new ImageIcon(FontSizeChooser.class.getResource("/IconsPackage/TextFormat_FontSize.png"));
        private boolean m_Accept = false;
        private String m_FontFamily;
        private float m_FontSize;
        private Font m_SelectedFont;
        private JComboBox m_ComboBoxFontFamily;
        private JComboBox m_ComboBoxFontSize;

        public FontSizeChooser() {
            super((Frame)null, TextToolBar.FONT, true);
            this.initComponents();
        }

        private void initComponents() {
            this.setIconImage(((ImageIcon)s_Icon).getImage());
            JPanel o_PanelContent = new JPanel();
            o_PanelContent.setLayout(new GridBagLayout());
            o_PanelContent.setBackground(Color.BLACK);
            o_PanelContent.setForeground(Color.WHITE);
            JPanel o_PanelChoosers = new JPanel();
            o_PanelChoosers.setLayout(new GridBagLayout());
            o_PanelChoosers.setBackground(Color.BLACK);
            o_PanelChoosers.setForeground(Color.WHITE);
            JLabel o_LabelFontFamily = new JLabel("Font");
            o_LabelFontFamily.setBackground(Color.BLACK);
            o_LabelFontFamily.setForeground(Color.WHITE);
            GridBagConstraints o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 0;
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.insets = new Insets(3, 3, 3, 3);
            o_PanelChoosers.add((Component)o_LabelFontFamily, o_GridBagConstraints);
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            String[] fontNames = ge.getAvailableFontFamilyNames();
            this.m_ComboBoxFontFamily = new JComboBox();
            this.m_ComboBoxFontFamily.setMinimumSize(new Dimension(150, 24));
            this.m_ComboBoxFontFamily.setPreferredSize(new Dimension(150, 24));
            for (int i = 0; i < fontNames.length; ++i) {
                this.m_ComboBoxFontFamily.addItem(fontNames[i]);
            }
            this.m_ComboBoxFontFamily.setSelectedIndex(0);
            this.m_FontFamily = (String)this.m_ComboBoxFontFamily.getSelectedItem();
            o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 1;
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.insets = new Insets(3, 3, 3, 3);
            o_GridBagConstraints.fill = 2;
            o_GridBagConstraints.weightx = 1.0;
            o_PanelChoosers.add((Component)this.m_ComboBoxFontFamily, o_GridBagConstraints);
            JLabel o_LabelFontSize = new JLabel("Size");
            o_LabelFontSize.setBackground(Color.BLACK);
            o_LabelFontSize.setForeground(Color.WHITE);
            o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 0;
            o_GridBagConstraints.gridy = 1;
            o_GridBagConstraints.insets = new Insets(3, 3, 3, 3);
            o_PanelChoosers.add((Component)o_LabelFontSize, o_GridBagConstraints);
            this.m_ComboBoxFontSize = new JComboBox();
            this.m_ComboBoxFontSize.setMinimumSize(new Dimension(150, 24));
            this.m_ComboBoxFontSize.setPreferredSize(new Dimension(150, 24));
            this.m_ComboBoxFontSize.setEditable(true);
            this.m_ComboBoxFontSize.addItem(new Float(8.0f));
            this.m_ComboBoxFontSize.addItem(new Float(9.0f));
            this.m_ComboBoxFontSize.addItem(new Float(10.0f));
            this.m_ComboBoxFontSize.addItem(new Float(11.0f));
            this.m_ComboBoxFontSize.addItem(new Float(12.0f));
            this.m_ComboBoxFontSize.addItem(new Float(14.0f));
            this.m_ComboBoxFontSize.addItem(new Float(16.0f));
            this.m_ComboBoxFontSize.addItem(new Float(20.0f));
            this.m_ComboBoxFontSize.addItem(new Float(24.0f));
            this.m_ComboBoxFontSize.setSelectedItem(new Float(14.0f));
            this.m_FontSize = ((Float)this.m_ComboBoxFontSize.getSelectedItem()).floatValue();
            ComboBoxEditor o_ComboBoxEditor = this.m_ComboBoxFontSize.getEditor();
            Component o_Component = o_ComboBoxEditor.getEditorComponent();
            o_Component.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                    if (e.getKeyChar() != '0' && e.getKeyChar() != '1' && e.getKeyChar() != '2' && e.getKeyChar() != '3' && e.getKeyChar() != '4' && e.getKeyChar() != '5' && e.getKeyChar() != '6' && e.getKeyChar() != '7' && e.getKeyChar() != '8' && e.getKeyChar() != '9' && e.getKeyChar() != '.') {
                        e.consume();
                    }
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }
            });
            o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 1;
            o_GridBagConstraints.gridy = 1;
            o_GridBagConstraints.insets = new Insets(3, 3, 3, 3);
            o_GridBagConstraints.fill = 2;
            o_GridBagConstraints.weightx = 1.0;
            o_PanelChoosers.add((Component)this.m_ComboBoxFontSize, o_GridBagConstraints);
            Dimension o_DimensionButtons = new Dimension(32, 32);
            JButton o_Button_Ok = new JButton("");
            o_Button_Ok.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_OK.png")));
            o_Button_Ok.setContentAreaFilled(false);
            o_Button_Ok.setMinimumSize(o_DimensionButtons);
            o_Button_Ok.setMaximumSize(o_DimensionButtons);
            o_Button_Ok.setPreferredSize(o_DimensionButtons);
            o_Button_Ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    m_Accept = true;
                    this.setVisible(false);
                    m_FontFamily = (String)m_ComboBoxFontFamily.getSelectedItem();
                    try {
                        Float floatFontSize = Float.valueOf(Float.parseFloat(m_ComboBoxFontSize.getSelectedItem().toString()));
                        m_FontSize = floatFontSize.floatValue();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    m_SelectedFont = new Font(m_FontFamily, 0, (int)m_FontSize);
                }
            });
            JButton o_Button_Cancel = new JButton("");
            o_Button_Cancel.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Cancel.png")));
            o_Button_Cancel.setContentAreaFilled(false);
            o_Button_Cancel.setMinimumSize(o_DimensionButtons);
            o_Button_Cancel.setMaximumSize(o_DimensionButtons);
            o_Button_Cancel.setPreferredSize(o_DimensionButtons);
            o_Button_Cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    m_Accept = false;
                    this.setVisible(false);
                    m_SelectedFont = null;
                }
            });
            JPanel o_PanelButtons = new JPanel();
            o_PanelButtons.setLayout(new GridBagLayout());
            o_PanelButtons.setBackground(Color.BLACK);
            o_PanelButtons.setForeground(Color.WHITE);
            o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 0;
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.insets = new Insets(3, 3, 3, 3);
            o_GridBagConstraints.fill = 2;
            o_GridBagConstraints.weightx = 1.0;
            o_PanelButtons.add((Component)o_Button_Ok, o_GridBagConstraints);
            o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 1;
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.insets = new Insets(3, 3, 3, 3);
            o_GridBagConstraints.fill = 2;
            o_GridBagConstraints.weightx = 1.0;
            o_PanelButtons.add((Component)o_Button_Cancel, o_GridBagConstraints);
            o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 0;
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.insets = new Insets(3, 3, 3, 3);
            o_GridBagConstraints.fill = 1;
            o_GridBagConstraints.weightx = 1.0;
            o_GridBagConstraints.weighty = 1.0;
            o_PanelContent.add((Component)o_PanelChoosers, o_GridBagConstraints);
            o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 0;
            o_GridBagConstraints.gridy = 1;
            o_GridBagConstraints.insets = new Insets(3, 3, 3, 3);
            o_GridBagConstraints.fill = 2;
            o_GridBagConstraints.weightx = 1.0;
            o_GridBagConstraints.weighty = 0.0;
            o_PanelContent.add((Component)o_PanelButtons, o_GridBagConstraints);
            this.getContentPane().add(o_PanelContent);
            this.setMinimumSize(new Dimension(210, 150));
            this.setPreferredSize(new Dimension(210, 150));
        }

        public void setFontFamily(String p_FontFamily) {
            if (p_FontFamily == null) {
                return;
            }
            this.m_ComboBoxFontFamily.setSelectedItem(p_FontFamily);
        }

        public String getFontFamily() {
            return this.m_FontFamily;
        }

        public void setFontSize(float p_FontSize) {
            this.m_ComboBoxFontSize.setSelectedItem(Float.valueOf(p_FontSize));
        }

        public float getFontSize() {
            return this.m_FontSize;
        }

        public void setSelectedFont(Font p_Font) {
            if (p_Font == null) {
                return;
            }
            this.m_FontFamily = p_Font.getFamily();
            this.m_FontSize = p_Font.getSize2D();
        }

        public Font getSelectedFont() {
            return this.m_SelectedFont;
        }

        public Font showDialog() {
            PointerInfo info = MouseInfo.getPointerInfo();
            Point mousePoint = info.getLocation();
            this.setLocation(mousePoint.x, mousePoint.y);
            this.setVisible(true);
            return this.m_SelectedFont;
        }

        @Override
        public void setLocation(int p_XOnScreen, int p_YOnScreen) {
            Dimension o_Dimension = this.getSize();
            int intX = p_XOnScreen;
            int intY = p_YOnScreen;
            GraphicsDeviceTools.GraphicsDeviceDescription o_GraphicsDeviceDescription = GraphicsDeviceTools.getGraphicsDeviceDescription(p_XOnScreen, p_YOnScreen);
            if (o_GraphicsDeviceDescription == null) {
                o_GraphicsDeviceDescription = GraphicsDeviceTools.getGraphicsDeviceDescription(0);
            }
            if (o_GraphicsDeviceDescription != null) {
                if (intX < o_GraphicsDeviceDescription.getX()) {
                    intX = o_GraphicsDeviceDescription.getX();
                }
                if (intX + o_Dimension.width > o_GraphicsDeviceDescription.getX() + o_GraphicsDeviceDescription.getWidth()) {
                    intX = o_GraphicsDeviceDescription.getX() + o_GraphicsDeviceDescription.getWidth() - o_Dimension.width;
                }
                if (intY < o_GraphicsDeviceDescription.getY()) {
                    intY = o_GraphicsDeviceDescription.getY();
                }
                if (intY + o_Dimension.height > o_GraphicsDeviceDescription.getY() + o_GraphicsDeviceDescription.getHeight()) {
                    intY = o_GraphicsDeviceDescription.getY() + o_GraphicsDeviceDescription.getHeight() - o_Dimension.height;
                }
            }
            super.setLocation(intX, intY);
        }
    }

    public static class BackgroundAction
    extends StyledEditorKit.StyledTextAction {
        private static final long serialVersionUID = 6384632651737400352L;
        private Color m_Color;

        public BackgroundAction() {
            super("background");
            this.initComponents();
        }

        private void initComponents() {
            this.m_Color = new Color(255, 255, 255, 255);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Color o_Color;
            JTextPane jTextPane = (JTextPane)this.getEditor(e);
            if (jTextPane == null) {
                return;
            }
            int intSelectionStart = jTextPane.getSelectionStart();
            StyledDocument o_StyledDocument = this.getStyledDocument(jTextPane);
            Element o_Element = o_StyledDocument.getCharacterElement(intSelectionStart);
            AttributeSet o_AttributeSet = o_Element.getAttributes();
            this.m_Color = StyleConstants.getBackground(o_AttributeSet);
            if (this.m_Color == null) {
                this.m_Color = Color.BLACK;
            }
            if ((o_Color = JColorChooser.showDialog(null, TextToolBar.BACKGROUND, this.m_Color)) == null) {
                return;
            }
            this.m_Color = o_Color;
            SimpleAttributeSet o_MutableAttributeSet = null;
            o_MutableAttributeSet = new SimpleAttributeSet();
            StyleConstants.setBackground(o_MutableAttributeSet, this.m_Color);
            this.setCharacterAttributes(jTextPane, o_MutableAttributeSet, false);
            jTextPane.requestFocusInWindow();
        }
    }

    public static class ForegroundAction
    extends StyledEditorKit.StyledTextAction {
        private static final long serialVersionUID = 6384632651737400352L;
        private Color m_Color;

        public ForegroundAction() {
            super("foreground");
            this.initComponents();
        }

        private void initComponents() {
            this.m_Color = Color.BLACK;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Color o_Color;
            JTextPane jTextPane = (JTextPane)this.getEditor(e);
            if (jTextPane == null) {
                return;
            }
            int intSelectionStart = jTextPane.getSelectionStart();
            StyledDocument o_StyledDocument = this.getStyledDocument(jTextPane);
            Element o_Element = o_StyledDocument.getCharacterElement(intSelectionStart);
            AttributeSet o_AttributeSet = o_Element.getAttributes();
            this.m_Color = StyleConstants.getForeground(o_AttributeSet);
            if (this.m_Color == null) {
                this.m_Color = Color.BLACK;
            }
            if ((o_Color = JColorChooser.showDialog(null, TextToolBar.FOREGROUND, this.m_Color)) == null) {
                return;
            }
            this.m_Color = o_Color;
            SimpleAttributeSet o_MutableAttributeSet = null;
            o_MutableAttributeSet = new SimpleAttributeSet();
            StyleConstants.setForeground(o_MutableAttributeSet, this.m_Color);
            this.setCharacterAttributes(jTextPane, o_MutableAttributeSet, false);
            jTextPane.requestFocusInWindow();
        }
    }

    public static class UnderlineAction
    extends StyledEditorKit.StyledTextAction {
        private static final long serialVersionUID = -1428340091100055456L;

        public UnderlineAction() {
            super("undeline");
        }

        public String toString() {
            return "Underline";
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextPane jTextPane = (JTextPane)this.getEditor(e);
            if (jTextPane != null) {
                StyledEditorKit o_StyledEditorKit = this.getStyledEditorKit(jTextPane);
                MutableAttributeSet o_MutableAttributeSet = o_StyledEditorKit.getInputAttributes();
                boolean boolUnderline = !StyleConstants.isUnderline(o_MutableAttributeSet);
                SimpleAttributeSet o_SimpleAttributeSet = new SimpleAttributeSet();
                StyleConstants.setUnderline(o_SimpleAttributeSet, boolUnderline);
                this.setCharacterAttributes(jTextPane, o_SimpleAttributeSet, false);
                jTextPane.requestFocusInWindow();
            }
        }
    }

    public static class ItalicAction
    extends StyledEditorKit.StyledTextAction {
        private static final long serialVersionUID = -1428340091100055456L;

        public ItalicAction() {
            super("font-italic");
        }

        public String toString() {
            return "Italic";
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextPane jTextPane = (JTextPane)this.getEditor(e);
            if (jTextPane != null) {
                StyledEditorKit o_StyledEditorKit = this.getStyledEditorKit(jTextPane);
                MutableAttributeSet o_MutableAttributeSet = o_StyledEditorKit.getInputAttributes();
                boolean boolItalic = !StyleConstants.isItalic(o_MutableAttributeSet);
                SimpleAttributeSet o_SimpleAttributeSet = new SimpleAttributeSet();
                StyleConstants.setItalic(o_SimpleAttributeSet, boolItalic);
                this.setCharacterAttributes(jTextPane, o_SimpleAttributeSet, false);
                jTextPane.requestFocusInWindow();
            }
        }
    }

    public static class BoldAction
    extends StyledEditorKit.StyledTextAction {
        private static final long serialVersionUID = 9174670038684056758L;

        public BoldAction() {
            super("font-bold");
        }

        public String toString() {
            return "Bold";
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextPane jTextPane = (JTextPane)this.getEditor(e);
            if (jTextPane != null) {
                StyledEditorKit o_StyledEditorKit = this.getStyledEditorKit(jTextPane);
                MutableAttributeSet o_MutableAttributeSet = o_StyledEditorKit.getInputAttributes();
                boolean boolBold = !StyleConstants.isBold(o_MutableAttributeSet);
                SimpleAttributeSet o_SimpleAttributeSet = new SimpleAttributeSet();
                StyleConstants.setBold(o_SimpleAttributeSet, boolBold);
                this.setCharacterAttributes(jTextPane, o_SimpleAttributeSet, false);
                jTextPane.requestFocusInWindow();
            }
        }
    }

    public static class TextToolBar
    extends JToolBar
    implements FocusListener {
        @LiveLanguageString
        public static String FONT = "Font/Size";
        @LiveLanguageString
        public static String FOREGROUND = "Foreground";
        @LiveLanguageString
        public static String BACKGROUND = "Background";
        @LiveLanguageString
        public static String IMAGE = "Image";
        @LiveLanguageString
        public static String BOLD = "Bold";
        @LiveLanguageString
        public static String ITALIC = "Italic";
        @LiveLanguageString
        public static String UNDERLINE = "Underline";
        public static FontSizeChooser s_FontSizeChooser = new FontSizeChooser();

        public TextToolBar() {
            LiveLanguage.addLanguageListener(this, null);
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.setEnabled(true);
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.setEnabled(false);
        }

        @Override
        public void setEnabled(boolean p_Enabled) {
            super.setEnabled(p_Enabled);
            for (int intButton = 0; intButton < super.getComponentCount(); ++intButton) {
                Component o_Component = super.getComponent(intButton);
                if (o_Component == null) continue;
                o_Component.setEnabled(p_Enabled);
            }
        }
    }
}

