/*
 * Decompiled with CFR 0.152.
 */
package ToolsGraphics;

import ToolsGraphics.BackgroundComponent;
import ToolsGraphics.BackgroundComponentInterface;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import javax.swing.JPanel;

public class JPanelBackground
extends JPanel
implements BackgroundComponentInterface {
    private BackgroundComponent m_ComponentBackground;

    public JPanelBackground() {
        this.initMembers();
    }

    public JPanelBackground(LayoutManager p_LayoutManager) {
        super(p_LayoutManager);
        this.initMembers();
    }

    public JPanelBackground(boolean p_IsDoubleBuffered) {
        super(p_IsDoubleBuffered);
        this.initMembers();
    }

    public JPanelBackground(LayoutManager p_LayoutManager, boolean p_IsDoubleBuffered) {
        super(p_LayoutManager, p_IsDoubleBuffered);
        this.initMembers();
    }

    private void initMembers() {
        super.setOpaque(false);
        this.m_ComponentBackground = new BackgroundComponent();
        this.setBackgroundOpaque(false);
        this.setFocusable(true);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.m_ComponentBackground != null) {
            this.m_ComponentBackground.paintComponentBackground(g, this);
        }
        super.paintComponent(g);
    }

    @Override
    public void setBackgroundComponent(BackgroundComponent p_BackgroundComponent) {
        if (p_BackgroundComponent != null) {
            this.m_ComponentBackground = p_BackgroundComponent;
            this.repaint();
        }
    }

    @Override
    public BackgroundComponent getBackgroundComponent() {
        return this.m_ComponentBackground;
    }

    @Override
    public void setOpaque(boolean p_Opaque) {
        super.setOpaque(false);
    }

    @Override
    public boolean getOpaque() {
        return super.isOpaque();
    }

    @Override
    public void setEnabled(boolean p_Enabled) {
        if (this.m_ComponentBackground != null) {
            this.m_ComponentBackground.setEnabled(p_Enabled);
        }
        super.setEnabled(p_Enabled);
    }

    @Override
    public void setBackgroundOpaque(boolean p_Opaque) {
        if (this.m_ComponentBackground == null) {
            return;
        }
        boolean oldValue = this.m_ComponentBackground.getOpaque();
        if (this.m_ComponentBackground.setOpaque(p_Opaque)) {
            this.firePropertyChange("backgroundOpaque", oldValue, p_Opaque);
            this.repaint();
        }
    }

    @Override
    public boolean getBackgroundOpaque() {
        if (this.m_ComponentBackground == null) {
            return false;
        }
        return this.m_ComponentBackground.getOpaque();
    }

    @Override
    public void setBackgroundStyle(int p_BackgroundStyle) {
        if (this.m_ComponentBackground == null) {
            return;
        }
        int oldValue = this.m_ComponentBackground.getBackgroundStyle();
        if (this.m_ComponentBackground.setBackgroundStyle(p_BackgroundStyle)) {
            this.firePropertyChange("backgroundStyle", oldValue, p_BackgroundStyle);
            this.repaint();
        }
    }

    @Override
    public void setBackground(Color p_BackgroundColor) {
        if (p_BackgroundColor == null) {
            return;
        }
        boolean boolRepaint = false;
        Color o_BackgroundColorSuper = super.getBackground();
        if (this.m_ComponentBackground != null) {
            Color oldValue = this.m_ComponentBackground.getBackground();
            if (this.m_ComponentBackground.setBackground(p_BackgroundColor)) {
                this.firePropertyChange("background", oldValue, p_BackgroundColor);
                boolRepaint = true;
            }
        }
        if (!p_BackgroundColor.equals(o_BackgroundColorSuper)) {
            super.setBackground(p_BackgroundColor);
            boolRepaint = false;
        }
        if (boolRepaint) {
            this.repaint();
        }
    }

    @Override
    public int getBackgroundStyle() {
        if (this.m_ComponentBackground == null) {
            return 0;
        }
        return this.m_ComponentBackground.getBackgroundStyle();
    }

    @Override
    public void setBackgroundImage(Image p_BackgroundImage) {
        if (this.m_ComponentBackground == null) {
            return;
        }
        Image oldValue = this.m_ComponentBackground.getBackgroundImage();
        if (this.m_ComponentBackground.setBackgroundImage(p_BackgroundImage)) {
            this.firePropertyChange("backgroundImage", oldValue, p_BackgroundImage);
            this.repaint();
        }
    }

    @Override
    public Image getBackgroundImage() {
        if (this.m_ComponentBackground == null) {
            return null;
        }
        return this.m_ComponentBackground.getBackgroundImage();
    }

    @Override
    public void setBackgroundImageFile(String p_BackgroundImageFile) {
        if (this.m_ComponentBackground == null) {
            return;
        }
        Image o_OldImage = this.m_ComponentBackground.getBackgroundImage();
        boolean boolDirty = false;
        boolDirty = this.m_ComponentBackground.setBackgroundImage(p_BackgroundImageFile);
        if (boolDirty) {
            this.firePropertyChange("backgroundImage", o_OldImage, this.m_ComponentBackground.getBackgroundImage());
            this.repaint();
        }
    }

    @Override
    public Color getBackgroundGradientColorFrom() {
        if (this.m_ComponentBackground == null) {
            return Color.BLACK;
        }
        return this.m_ComponentBackground.getBackgroundGradientColorFrom();
    }

    @Override
    public void setBackgroundGradientColorFrom(Color p_BackgroundGradientColorFrom) {
        if (this.m_ComponentBackground == null) {
            return;
        }
        Color oldValue = this.m_ComponentBackground.getBackgroundGradientColorFrom();
        if (this.m_ComponentBackground.setBackgroundGradientColorFrom(p_BackgroundGradientColorFrom)) {
            this.firePropertyChange("backgroundGradientColorFrom", oldValue, p_BackgroundGradientColorFrom);
            this.repaint();
        }
    }

    @Override
    public Color getBackgroundGradientColorTo() {
        if (this.m_ComponentBackground == null) {
            return Color.BLACK;
        }
        return this.m_ComponentBackground.getBackgroundGradientColorTo();
    }

    @Override
    public void setBackgroundGradientColorTo(Color p_BackgroundGradientColorTo) {
        if (this.m_ComponentBackground == null) {
            return;
        }
        Color oldValue = this.m_ComponentBackground.getBackgroundGradientColorTo();
        if (this.m_ComponentBackground.setBackgroundGradientColorTo(p_BackgroundGradientColorTo)) {
            this.firePropertyChange("backgroundGradientColorTo", oldValue, p_BackgroundGradientColorTo);
            this.repaint();
        }
    }

    @Override
    public int getBackgroundGradientAngle() {
        if (this.m_ComponentBackground == null) {
            return 0;
        }
        return this.m_ComponentBackground.getBackgroundGradientAngle();
    }

    @Override
    public void setBackgroundGradientAngle(int p_BackgroundGradientAngle) {
        if (this.m_ComponentBackground == null) {
            return;
        }
        int oldValue = this.m_ComponentBackground.getBackgroundGradientAngle();
        if (this.m_ComponentBackground.setBackgroundGradientAngle(p_BackgroundGradientAngle)) {
            this.firePropertyChange("backgroundGradientAngle", oldValue, p_BackgroundGradientAngle);
            this.repaint();
        }
    }
}

