/*
 * Decompiled with CFR 0.152.
 */
package ToolsGraphics;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class GraphicsTools {
    public static Color newColorSave(int p_Red, int p_Green, int p_Blue) {
        if (p_Red < 0) {
            p_Red = 0;
        } else if (p_Red > 255) {
            p_Red = 255;
        }
        if (p_Green < 0) {
            p_Green = 0;
        } else if (p_Green > 255) {
            p_Green = 255;
        }
        if (p_Blue < 0) {
            p_Blue = 0;
        } else if (p_Blue > 255) {
            p_Blue = 255;
        }
        Color o_Color = new Color(p_Red, p_Green, p_Blue);
        return o_Color;
    }

    public static Color newColorSave(float p_Red, float p_Green, float p_Blue) {
        if (p_Red == Float.NaN) {
            p_Red = 0.0f;
        } else if (p_Red < 0.0f) {
            p_Red = 0.0f;
        } else if (p_Red > 1.0f) {
            p_Red = 1.0f;
        }
        if (p_Green == Float.NaN) {
            p_Green = 0.0f;
        } else if (p_Green < 0.0f) {
            p_Green = 0.0f;
        } else if (p_Green > 1.0f) {
            p_Green = 1.0f;
        }
        if (p_Blue == Float.NaN) {
            p_Blue = 0.0f;
        } else if (p_Blue < 0.0f) {
            p_Blue = 0.0f;
        } else if (p_Blue > 1.0f) {
            p_Blue = 1.0f;
        }
        Color o_Color = new Color(p_Red, p_Green, p_Blue);
        return o_Color;
    }

    public static Color newColorSave(int p_Red, int p_Green, int p_Blue, int p_Alpha) {
        if (p_Red < 0) {
            p_Red = 0;
        } else if (p_Red > 255) {
            p_Red = 255;
        }
        if (p_Green < 0) {
            p_Green = 0;
        } else if (p_Green > 255) {
            p_Green = 255;
        }
        if (p_Blue < 0) {
            p_Blue = 0;
        } else if (p_Blue > 255) {
            p_Blue = 255;
        }
        if (p_Alpha < 0) {
            p_Alpha = 0;
        } else if (p_Alpha > 255) {
            p_Alpha = 255;
        }
        Color o_Color = new Color(p_Red, p_Green, p_Blue, p_Alpha);
        return o_Color;
    }

    public static Color newColorSave(float p_Red, float p_Green, float p_Blue, float p_Alpha) {
        if (p_Red == Float.NaN) {
            p_Red = 0.0f;
        } else if (p_Red < 0.0f) {
            p_Red = 0.0f;
        } else if (p_Red > 1.0f) {
            p_Red = 1.0f;
        }
        if (p_Green == Float.NaN) {
            p_Green = 0.0f;
        } else if (p_Green < 0.0f) {
            p_Green = 0.0f;
        } else if (p_Green > 1.0f) {
            p_Green = 1.0f;
        }
        if (p_Blue == Float.NaN) {
            p_Blue = 0.0f;
        } else if (p_Blue < 0.0f) {
            p_Blue = 0.0f;
        } else if (p_Blue > 1.0f) {
            p_Blue = 1.0f;
        }
        if (p_Alpha == Float.NaN) {
            p_Alpha = 0.0f;
        } else if (p_Alpha < 0.0f) {
            p_Alpha = 0.0f;
        } else if (p_Alpha > 1.0f) {
            p_Alpha = 1.0f;
        }
        Color o_Color = new Color(p_Red, p_Green, p_Blue, p_Alpha);
        return o_Color;
    }

    public static Color brighterColor(Color p_Color, double p_BrighterFactor) {
        if (p_Color == null) {
            return null;
        }
        if (p_BrighterFactor <= 0.0) {
            return p_Color;
        }
        if (p_BrighterFactor >= 1.0) {
            return p_Color.brighter();
        }
        double doubleRecipsocalFactor = 1.0 / p_BrighterFactor;
        Color newcolor = GraphicsTools.newColorSave(Math.min((int)((double)p_Color.getRed() * doubleRecipsocalFactor), 255), Math.min((int)((double)p_Color.getGreen() * doubleRecipsocalFactor), 255), Math.min((int)((double)p_Color.getBlue() * doubleRecipsocalFactor), 255));
        if (newcolor.equals(p_Color)) {
            return Color.white;
        }
        return newcolor;
    }

    public static Color darkerColor(Color p_Color, double p_DarkerFactor) {
        if (p_Color == null) {
            return null;
        }
        if (p_DarkerFactor <= 0.0) {
            return p_Color.darker();
        }
        if (p_DarkerFactor >= 1.0) {
            return p_Color;
        }
        Color newcolor = GraphicsTools.newColorSave(Math.max((int)((double)p_Color.getRed() * p_DarkerFactor), 0), Math.max((int)((double)p_Color.getGreen() * p_DarkerFactor), 0), Math.max((int)((double)p_Color.getBlue() * p_DarkerFactor), 0));
        if (newcolor.equals(p_Color)) {
            return Color.black;
        }
        return newcolor;
    }

    public static Point getPointCenterFont(Graphics p_Graphics, String p_Text, Rectangle p_Rect) {
        if (p_Graphics == null) {
            return null;
        }
        if (p_Text == null) {
            return null;
        }
        if (p_Rect == null) {
            return null;
        }
        FontMetrics metric = p_Graphics.getFontMetrics(p_Graphics.getFont());
        Point o_PointCenter = new Point((int)(p_Rect.getCenterX() - (double)(metric.stringWidth(p_Text) / 2)), (int)(p_Rect.getCenterY() + (double)(metric.getAscent() / 4)));
        return o_PointCenter;
    }

    public static Point getPointOnRectangleBorder(Rectangle p_Rectangle, double p_Degree) {
        double doubleCorrectX;
        double doubleCorrectY;
        if (p_Rectangle == null) {
            return null;
        }
        double doubleAngleRadianr = (p_Degree + 90.0) * Math.PI / 180.0;
        double doubleSin = Math.sin(doubleAngleRadianr);
        double doubleCos = Math.cos(doubleAngleRadianr);
        double doubleRectHalfHeight = p_Rectangle.getHeight() / 2.0;
        double doubleRectHalfWidth = p_Rectangle.getWidth() / 2.0;
        double doubleHypothenuse = Math.sqrt(doubleRectHalfWidth * doubleRectHalfWidth + doubleRectHalfHeight * doubleRectHalfHeight);
        double doubleCircleX = doubleHypothenuse * doubleCos;
        double doubleCircleY = doubleHypothenuse * doubleSin;
        double doubleFactorX = doubleCircleX >= 0.0 ? 1.0 : -1.0;
        double doubleFactorY = doubleCircleY >= 0.0 ? 1.0 : -1.0;
        if (Math.abs(doubleCircleY) >= doubleRectHalfHeight) {
            doubleCorrectY = doubleRectHalfHeight * doubleFactorY;
            double doubleCorrectDistance = doubleCircleY - doubleRectHalfHeight * doubleFactorY;
            if (doubleSin == 0.0) {
                doubleCorrectX = doubleRectHalfWidth * doubleFactorX;
            } else {
                double doubleCorrectionHypothenuse = doubleCorrectDistance / doubleSin;
                doubleCorrectX = doubleCircleX - doubleCos * doubleCorrectionHypothenuse;
            }
        } else {
            doubleCorrectX = doubleRectHalfWidth * doubleFactorX;
            double doubleCorrectDistance = doubleCircleX - doubleRectHalfWidth * doubleFactorX;
            if (doubleCos == 0.0) {
                doubleCorrectY = doubleRectHalfHeight * doubleFactorY;
            } else {
                double doubleCorrectionHypothenuse = doubleCorrectDistance / doubleCos;
                doubleCorrectY = doubleCircleY - doubleSin * doubleCorrectionHypothenuse;
            }
        }
        Point pointRect = new Point();
        pointRect.x = Math.round((float)(p_Rectangle.getCenterX() + doubleCorrectX));
        pointRect.y = Math.round((float)(p_Rectangle.getCenterY() - doubleCorrectY));
        if ((double)pointRect.x < p_Rectangle.getX()) {
            pointRect.x = (int)p_Rectangle.getX();
        } else if ((double)pointRect.x > p_Rectangle.getX() + p_Rectangle.getWidth()) {
            p_Rectangle.x = (int)(p_Rectangle.getX() + p_Rectangle.getWidth());
        }
        if ((double)pointRect.y < p_Rectangle.getY()) {
            pointRect.y = (int)p_Rectangle.getY();
        } else if ((double)pointRect.y > p_Rectangle.getY() + p_Rectangle.getHeight()) {
            p_Rectangle.y = (int)(p_Rectangle.getY() + p_Rectangle.getHeight());
        }
        return pointRect;
    }

    public static Point getDiagonalPoint(Rectangle p_Rectangle, Point p_Point) {
        if (p_Rectangle == null) {
            return null;
        }
        if (p_Point == null) {
            return null;
        }
        Point pointDiagonal = new Point();
        pointDiagonal.x = (int)(2.0 * p_Rectangle.getCenterX() - (double)p_Point.x);
        pointDiagonal.y = (int)(2.0 * p_Rectangle.getCenterY() - (double)p_Point.y);
        return pointDiagonal;
    }

    public static class Spline {
        private ArrayList<Point2D.Double> m_Points;
        private boolean m_Dirty;
        private ArrayList<Double> w;
        private ArrayList<Double> u;
        private ArrayList<Double> d;
        private ArrayList<Double> p;

        public Spline() {
            this.initMembers();
        }

        private void initMembers() {
            this.m_Points = new ArrayList();
            this.m_Dirty = false;
            this.w = new ArrayList();
            this.u = new ArrayList();
            this.d = new ArrayList();
            this.p = new ArrayList();
        }

        public void close() {
            this.m_Points.clear();
        }

        public boolean addPoint(Point2D.Double p_Point) {
            int intPoint;
            if (p_Point == null) {
                return false;
            }
            if (this.m_Points.contains(p_Point)) {
                return true;
            }
            for (intPoint = 0; intPoint < this.m_Points.size(); ++intPoint) {
                Point2D.Double o_Point = this.m_Points.get(intPoint);
                if (o_Point.getX() == p_Point.getX()) {
                    return o_Point.getY() == p_Point.getY();
                }
                if (!(o_Point.getX() < p_Point.getX())) break;
            }
            this.m_Points.add(intPoint, p_Point);
            this.m_Dirty = true;
            return true;
        }

        public void removePoint(Point2D.Double p_Point) {
            if (p_Point == null) {
                return;
            }
            if (this.m_Points.contains(p_Point)) {
                this.m_Points.remove(p_Point);
                this.m_Dirty = true;
            } else {
                for (int intPoint = 0; intPoint < this.m_Points.size(); ++intPoint) {
                    Point2D.Double o_Point = this.m_Points.get(intPoint);
                    if (o_Point.getX() != p_Point.getX() || o_Point.getY() != p_Point.getY()) continue;
                    this.m_Points.remove(o_Point);
                    this.m_Dirty = true;
                }
            }
        }

        public boolean movePoint(Point2D.Double p_Point, double p_NewX, double p_NewY) {
            if (p_Point == null) {
                return false;
            }
            Point2D.Double o_PointPrevious = null;
            Point2D.Double o_PointNext = null;
            int intIndex = this.m_Points.indexOf(p_Point);
            if (intIndex < 0) {
                return false;
            }
            Point2D.Double o_Point = this.m_Points.get(intIndex);
            if (o_Point.getX() != p_NewX || o_Point.getY() != p_NewY) {
                if (intIndex > 0) {
                    o_PointPrevious = this.m_Points.get(intIndex - 1);
                }
                if (intIndex < this.m_Points.size() - 1) {
                    o_PointNext = this.m_Points.get(intIndex + 1);
                }
                if (o_PointPrevious != null && o_PointPrevious.getX() >= p_NewX) {
                    p_NewX = o_PointPrevious.getX();
                }
                if (o_PointNext != null && p_NewX >= o_PointNext.getX()) {
                    p_NewX = o_PointNext.getX();
                }
                o_Point.setLocation(p_NewX, p_NewY);
                this.m_Dirty = true;
            }
            return true;
        }

        public int getPointCount() {
            return this.m_Points.size();
        }

        public Point2D.Double getPoint(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            if (p_Index >= this.m_Points.size()) {
                return null;
            }
            return this.m_Points.get(p_Index);
        }

        public Point2D.Double getPoint(double p_X) {
            for (int intPoint = 0; intPoint < this.m_Points.size(); ++intPoint) {
                Point2D.Double o_Point = this.m_Points.get(intPoint);
                if (o_Point.getX() != p_X) continue;
                return o_Point;
            }
            return null;
        }

        public boolean contains(Point2D.Double p_Point) {
            if (p_Point == null) {
                return false;
            }
            return this.m_Points.contains(p_Point);
        }

        public double getXMin() {
            if (this.m_Points.size() <= 0) {
                return Double.NaN;
            }
            return this.m_Points.get(0).getX();
        }

        public double getXMax() {
            if (this.m_Points.size() <= 0) {
                return Double.NaN;
            }
            return this.m_Points.get(this.m_Points.size() - 1).getX();
        }

        public boolean getDirty() {
            return this.m_Dirty;
        }

        public void calculateSpline() {
            Point2D o_Point;
            Point2D o_PointPrevious;
            Point2D o_PointNext;
            int i;
            if (!this.m_Dirty) {
                return;
            }
            if (this.m_Points.size() <= 0) {
                return;
            }
            if (this.m_Points.size() == 1) {
                return;
            }
            if (this.m_Points.size() == 2) {
                return;
            }
            int N = this.m_Points.size();
            if (N > this.p.size()) {
                for (int i2 = this.p.size(); i2 < N; ++i2) {
                    this.w.add(0.0);
                    this.u.add(0.0);
                    this.d.add(0.0);
                    this.p.add(0.0);
                }
            }
            for (i = 1; i <= N - 2; ++i) {
                o_PointNext = this.m_Points.get(i + 1);
                o_PointPrevious = this.m_Points.get(i - 1);
                double doubleValue = 2.0 * (o_PointNext.getX() - o_PointPrevious.getX());
                this.d.set(i, doubleValue);
            }
            for (i = 0; i <= N - 2; ++i) {
                o_Point = this.m_Points.get(i);
                o_PointNext = this.m_Points.get(i + 1);
                double doubleValue = o_PointNext.getX() - o_Point.getX();
                this.u.set(i, doubleValue);
            }
            for (i = 1; i <= N - 2; ++i) {
                o_Point = this.m_Points.get(i);
                o_PointPrevious = this.m_Points.get(i - 1);
                o_PointNext = this.m_Points.get(i + 1);
                double doubleValue = 6.0 * ((o_PointNext.getY() - o_Point.getY()) / this.u.get(i) - (o_Point.getY() - o_PointPrevious.getY()) / this.u.get(i - 1));
                this.w.set(i, doubleValue);
            }
            for (i = 1; i <= N - 3; ++i) {
                double doubleValue = this.w.get(i + 1) - this.w.get(i) * this.u.get(i) / this.d.get(i);
                this.w.set(i + 1, doubleValue);
                doubleValue = this.d.get(i + 1) - this.u.get(i) * this.u.get(i) / this.d.get(i);
                this.d.set(i + 1, doubleValue);
            }
            this.p.set(0, 0.0);
            this.p.set(N - 1, 0.0);
            for (i = N - 2; i >= 1; --i) {
                double doubleValue = (this.w.get(i) - this.u.get(i) * this.p.get(i + 1)) / this.d.get(i);
                this.p.set(i, doubleValue);
            }
            this.m_Dirty = false;
        }

        public double getValue(double p_X) {
            if (this.m_Points.size() <= 0) {
                return Double.NaN;
            }
            if (p_X < this.getXMin()) {
                p_X = this.getXMin();
            }
            if (p_X > this.getXMax()) {
                p_X = this.getXMax();
            }
            int intSection = -1;
            if (this.m_Points.size() == 1) {
                Point2D.Double o_Point = this.m_Points.get(0);
                if (o_Point.getX() != p_X) {
                    return Double.NaN;
                }
                return o_Point.getY();
            }
            if (this.m_Points.size() == 2) {
                Point2D.Double o_Point = this.m_Points.get(0);
                Point2D.Double o_PointNext = this.m_Points.get(1);
                double doubleRangeX = o_PointNext.getX() - o_Point.getX();
                if (doubleRangeX == 0.0) {
                    return o_PointNext.getY();
                }
                double doubleRangeY = o_PointNext.getY() - o_Point.getY();
                if (doubleRangeY == 0.0) {
                    return o_Point.getY();
                }
                double doubleValueY = o_Point.getY() + doubleRangeY / doubleRangeX * (p_X - o_Point.getX());
                return doubleValueY;
            }
            for (int intPoint = 0; intPoint < this.m_Points.size(); ++intPoint) {
                Point2D.Double o_Point = this.m_Points.get(intPoint);
                if (o_Point.getX() == p_X) {
                    return o_Point.getY();
                }
                if (!(p_X < o_Point.getX())) continue;
                intSection = intPoint - 1;
                double doubleValueY = this.getValueSection(intSection, p_X);
                return doubleValueY;
            }
            return Double.NaN;
        }

        private double f(double p_X) {
            return p_X * p_X * p_X - p_X;
        }

        public double getValueSection(int p_i, double p_X) {
            Point2D o_Point = this.m_Points.get(p_i);
            Point2D o_PointNext = this.m_Points.get(p_i + 1);
            double t = (p_X - o_Point.getX()) / this.u.get(p_i);
            double doubleResult = t * o_PointNext.getY() + (1.0 - t) * o_Point.getY() + this.u.get(p_i) * this.u.get(p_i) * (this.f(t) * this.p.get(p_i + 1) + this.f(1.0 - t) * this.p.get(p_i)) / 6.0;
            return doubleResult;
        }

        public Spline split(Point2D.Double p_Point) {
            if (!this.contains(p_Point)) {
                return null;
            }
            int intIndex = this.m_Points.indexOf(p_Point);
            Spline o_SplineNew = new Spline();
            for (int intPoint = this.m_Points.size() - 1; intPoint >= intIndex; --intPoint) {
                Point2D.Double o_Point = this.m_Points.get(intPoint);
                o_SplineNew.addPoint(o_Point);
                this.m_Points.remove(o_Point);
            }
            this.m_Dirty = true;
            return o_SplineNew;
        }

        public void merge(Spline p_Spline) {
            if (p_Spline == null) {
                return;
            }
            if (p_Spline == this) {
                return;
            }
            if (p_Spline.getPointCount() == 0) {
                return;
            }
            for (int intPoint = 0; intPoint < p_Spline.getPointCount(); ++intPoint) {
                Point2D.Double o_Point = p_Spline.getPoint(intPoint);
                this.addPoint(o_Point);
            }
        }
    }
}

