/*
 * Decompiled with CFR 0.152.
 */
package RTFPackage;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;

abstract class AbstractFilter_Corrected
extends OutputStream {
    protected char[] translationTable = latin1TranslationTable;
    protected boolean[] specialsTable = noSpecialsTable;
    static final char[] latin1TranslationTable;
    static final boolean[] noSpecialsTable;
    static final boolean[] allSpecialsTable;
    public boolean m_ReadIsNearEnd = true;

    public void readFromStream(InputStream in) throws IOException {
        byte[] buf1 = new byte[8192];
        byte[] buf2 = new byte[8192];
        boolean boolReady = false;
        this.m_ReadIsNearEnd = false;
        int count1 = in.read(buf1);
        if (count1 < 0) {
            this.m_ReadIsNearEnd = true;
            boolReady = true;
        }
        while (!boolReady) {
            int count2 = in.read(buf2);
            if (count2 < 0) {
                boolReady = true;
            }
            for (int i = 0; i < count1; ++i) {
                if (boolReady && i >= count1 - 4) {
                    this.m_ReadIsNearEnd = true;
                }
                this.write(buf1[i]);
            }
            if (boolReady) continue;
            System.arraycopy(buf2, 0, buf1, 0, count2);
            count1 = count2;
        }
    }

    public void readFromReader(Reader in) throws IOException {
        char[] buf1 = new char[1028];
        char[] buf2 = new char[1028];
        boolean boolReady = false;
        this.m_ReadIsNearEnd = false;
        int count1 = in.read(buf1);
        if (count1 < 0) {
            this.m_ReadIsNearEnd = true;
            boolReady = true;
        }
        while (!boolReady) {
            int count2 = in.read(buf2);
            if (count2 < 0) {
                boolReady = true;
            }
            for (int i = 0; i < count1; ++i) {
                if (boolReady && i >= count1 - 4) {
                    this.m_ReadIsNearEnd = true;
                }
                this.write(buf1[i]);
            }
            if (boolReady) continue;
            System.arraycopy(buf2, 0, buf1, 0, count2);
            count1 = count2;
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (b < 0) {
            b += 256;
        }
        if (this.specialsTable[b]) {
            this.writeSpecial(b);
        } else {
            char ch = this.translationTable[b];
            if (ch != '\u0000') {
                this.write(ch);
            }
        }
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        StringBuilder accumulator = null;
        while (len > 0) {
            short b = buf[off];
            if (b < 0) {
                b = (short)(b + 256);
            }
            if (this.specialsTable[b]) {
                if (accumulator != null) {
                    this.write(accumulator.toString());
                    accumulator = null;
                }
                this.writeSpecial(b);
            } else {
                char ch = this.translationTable[b];
                if (ch != '\u0000') {
                    if (accumulator == null) {
                        accumulator = new StringBuilder();
                    }
                    accumulator.append(ch);
                }
            }
            --len;
            ++off;
        }
        if (accumulator != null) {
            this.write(accumulator.toString());
        }
    }

    public void write(String s) throws IOException {
        int length = s.length();
        for (int index = 0; index < length; ++index) {
            this.write(s.charAt(index));
        }
    }

    protected abstract void write(char var1) throws IOException;

    protected abstract void writeSpecial(int var1) throws IOException;

    static {
        int i;
        noSpecialsTable = new boolean[256];
        for (i = 0; i < 256; ++i) {
            AbstractFilter_Corrected.noSpecialsTable[i] = false;
        }
        allSpecialsTable = new boolean[256];
        for (i = 0; i < 256; ++i) {
            AbstractFilter_Corrected.allSpecialsTable[i] = true;
        }
        latin1TranslationTable = new char[256];
        for (i = 0; i < 256; ++i) {
            AbstractFilter_Corrected.latin1TranslationTable[i] = (char)i;
        }
    }
}

