/*
 * Decompiled with CFR 0.152.
 */
package LiveShowScrollPackage;

import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowPlayPackage.Play;
import LiveShowPlayPackage.PlayControlCursor;
import LiveShowPlayPackage.PlayListener;
import LiveShowPlayPackage.Playable;
import LiveShowScrollPackage.LiveShowViewListener;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import LiveShowVirtualPackage.LiveShowVIP;
import LiveShowVirtualPackage.LiveShowVIPListener;
import LiveShowVirtualPackage.LiveShowVIPTrack;
import SwingComponents.MouseAdapter_Delayed;
import SwingToolTipPackage.PopUpToolTip;
import SynchronizationPackage.EventQueueHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class LiveShowTimeBar
extends JPanel
implements PlayListener,
LiveShowViewListener,
LiveShowVIPListener,
ComponentListener,
MouseListener,
MouseMotionListener {
    static final long serialVersionUID = -9122169035453483235L;
    private ArrayList<Play> m_Plays;
    private ArrayList<PlayControlCursor> m_PlayControlCursors;
    private double m_FrameTime;
    private long m_FrameStart;
    private long m_FrameEnd;
    private long m_VisibleFrameStart;
    private long m_VisibleFrameEnd;
    private long m_TickFrameStart;
    private long m_TickTimeStart;
    private double m_TickFrameJump;
    private long m_TickTimeJump;
    private int m_TickCount;
    private Rectangle2D m_Rectangle2D_TimeString;
    private ArrayList<LiveShowSceneBridge> m_LiveShowMainSceneBridges;
    private Font m_SceneBridgeFont;
    private Runnable m_Runnable_Calculate_PlayCursors;
    private Runnable m_Runnable_Calculate_Marks;
    private ArrayList<Mark> m_Marks;
    private Mark m_SelectedMark;
    private Runnable m_Runnable_Revalidate;
    private Runnable m_Runnable_Repaint;
    private Runnable m_Runnable_CalculateMainSceneBridges;
    private ArrayList<LiveShowTimeBarListener> m_LiveShowTimeBarListeners;
    private final Object m_SyncTimeBarListener = new Object();
    private StringBuilder m_StringBuilderTime;
    private final Object m_SyncStringBuilder = new Object();
    private Dimension m_OldSize;
    private File m_FileMarks;
    private boolean m_MarksChanged;
    private final Object m_SyncPlays = new Object();

    public LiveShowTimeBar() {
        this.initMembers();
        this.initComponents();
    }

    private void initMembers() {
        this.m_LiveShowTimeBarListeners = new ArrayList();
        this.m_OldSize = new Dimension(0, 0);
        this.m_Plays = new ArrayList();
        this.m_Marks = new ArrayList();
        this.m_MarksChanged = false;
        this.m_PlayControlCursors = new ArrayList();
        this.m_FrameTime = 1.0;
        this.m_StringBuilderTime = new StringBuilder();
        this.m_Rectangle2D_TimeString = new Rectangle(0, 0, 10, 10);
        this.m_Runnable_Calculate_PlayCursors = new Runnable(){

            @Override
            public void run() {
                try {
                    LiveShowTimeBar.this.calculatePlayCursors();
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        };
        this.m_Runnable_Calculate_Marks = new Runnable(){

            @Override
            public void run() {
                try {
                    LiveShowTimeBar.this.calculateMarks();
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        };
        this.m_Runnable_Revalidate = new Runnable(){

            @Override
            public void run() {
                try {
                    LiveShowTimeBar.this.revalidate();
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        };
        this.m_Runnable_Repaint = new Runnable(){

            @Override
            public void run() {
                try {
                    LiveShowTimeBar.this.repaint();
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        };
        this.m_Runnable_CalculateMainSceneBridges = new Runnable(){

            @Override
            public void run() {
                try {
                    LiveShowTimeBar.this.calculateMainSceneBridges();
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        };
    }

    private void initComponents() {
        this.setLayout(new AbsoluteLayout());
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        Font o_Font = new Font("Arial", 0, 11);
        this.setFont(o_Font);
        this.m_SceneBridgeFont = new Font("Arial", 0, 14);
        LineBorder o_LineBorder = new LineBorder(Color.LIGHT_GRAY, 1);
        this.setBorder(o_LineBorder);
        this.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.setToolTipText("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        EventQueueHandler.removeRunnable(this.m_Runnable_Calculate_Marks);
        EventQueueHandler.removeRunnable(this.m_Runnable_Calculate_PlayCursors);
        if (this.m_Marks != null) {
            int intMarkCount = this.m_Marks.size();
            for (int intMark = intMarkCount - 1; intMark >= 0; --intMark) {
                Mark o_Mark = this.m_Marks.get(intMark);
                this.removeMark(o_Mark);
            }
        }
        this.m_MarksChanged = false;
        Object object = this.m_SyncPlays;
        synchronized (object) {
            if (this.m_Plays != null) {
                int intPlayCount = this.m_Plays.size();
                for (int intPlay = intPlayCount - 1; intPlay >= 0; --intPlay) {
                    Play o_Play = this.m_Plays.get(intPlay);
                    this.removePlay(o_Play);
                }
            }
        }
        this.m_FileMarks = null;
        this.setComponentPopupMenu(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlay(Play p_Play) {
        if (p_Play == null) {
            return;
        }
        Object object = this.m_SyncPlays;
        synchronized (object) {
            if (this.m_Plays.contains(p_Play)) {
                return;
            }
            PlayControlCursor o_PlayControlCursor = new PlayControlCursor();
            o_PlayControlCursor.setForeground(p_Play.getColor());
            this.m_PlayControlCursors.add(o_PlayControlCursor);
            o_PlayControlCursor.setVisible(p_Play.getActive());
            this.add((Component)o_PlayControlCursor, o_PlayControlCursor.getAbsoluteConstraints());
            this.m_Plays.add(p_Play);
            p_Play.addPlayListener(this);
            Playable o_Playable = p_Play.getPlayable();
            if (o_Playable != null) {
                if (o_Playable instanceof LiveShowVIP) {
                    ((LiveShowVIP)o_Playable).addLiveShowVIPListener(this);
                }
                this.m_FrameTime = o_Playable.getFrameTime();
            }
        }
        EventQueueHandler.invokeLater(this.m_Runnable_Calculate_PlayCursors);
        EventQueueHandler.invokeLater(this.m_Runnable_CalculateMainSceneBridges);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlay(Play p_Play) {
        if (p_Play == null) {
            return;
        }
        Object object = this.m_SyncPlays;
        synchronized (object) {
            int intIndex = this.m_Plays.indexOf(p_Play);
            if (intIndex < 0) {
                return;
            }
            PlayControlCursor o_PlayControlCursor = this.m_PlayControlCursors.get(intIndex);
            p_Play.removePlayListener(this);
            this.m_Plays.remove(p_Play);
            this.m_PlayControlCursors.remove(o_PlayControlCursor);
            if (o_PlayControlCursor != null) {
                o_PlayControlCursor.setVisible(false);
            }
            this.remove(o_PlayControlCursor);
            Playable o_Playable = p_Play.getPlayable();
            if (o_Playable != null && o_Playable instanceof LiveShowVIP) {
                ((LiveShowVIP)o_Playable).removeLiveShowVIPListener(this);
            }
        }
    }

    public int getPlayCount() {
        if (this.m_Plays == null) {
            return 0;
        }
        return this.m_Plays.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Play getPlay(int p_Index) {
        Object object = this.m_SyncPlays;
        synchronized (object) {
            if (this.m_Plays == null) {
                return null;
            }
            if (p_Index < 0 || p_Index >= this.m_Plays.size()) {
                return null;
            }
            return this.m_Plays.get(p_Index);
        }
    }

    public double getFramesPerPoint() {
        if (this.getWidth() == 0) {
            return 0.0;
        }
        return (double)(this.m_VisibleFrameEnd - this.m_VisibleFrameStart) / (double)this.getWidth();
    }

    public long getPositionFrame(Point p_Point) {
        return this.getPositionFrame(p_Point.x);
    }

    public long getPositionFrame(int p_X) {
        long longFrame = this.m_VisibleFrameStart + (long)((double)p_X * this.getFramesPerPoint());
        return longFrame;
    }

    public int getPositionX(long p_Frame) {
        int intWidth = this.getWidth();
        double doubleFramesPerPoint = this.getFramesPerPoint();
        if (doubleFramesPerPoint <= 0.0) {
            return 0;
        }
        int intX = (int)((double)(p_Frame - this.m_VisibleFrameStart) / doubleFramesPerPoint);
        return intX;
    }

    public long getVisibleFrameStart() {
        return this.m_VisibleFrameStart;
    }

    public long getVisibleFrameEnd() {
        return this.m_VisibleFrameEnd;
    }

    public long getFrameStart() {
        return this.m_FrameStart;
    }

    public long getFrameEnd() {
        return this.m_FrameEnd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlayCursors(long p_FramePosition) {
        ArrayList<Play> o_Plays;
        if (p_FramePosition < 0L) {
            return;
        }
        Object object = this.m_SyncPlays;
        synchronized (object) {
            o_Plays = new ArrayList<Play>(this.m_Plays.size());
            o_Plays.addAll(this.m_Plays);
        }
        for (int intPlay = 0; intPlay < o_Plays.size(); ++intPlay) {
            Play o_Play = (Play)o_Plays.get(intPlay);
            if (o_Play == null) continue;
            if (!o_Play.getEditModeOn()) {
                o_Play.setPlayCursor(p_FramePosition);
                o_Play.playFramePositionOnce(p_FramePosition);
                continue;
            }
            o_Play.setEditCursor(p_FramePosition);
            o_Play.playFramePositionOnce(p_FramePosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculatePlayCursors() {
        boolean boolRevalidate = false;
        Object object = this.m_SyncPlays;
        synchronized (object) {
            for (int intPlay = 0; intPlay < this.m_Plays.size(); ++intPlay) {
                Play o_Play = this.m_Plays.get(intPlay);
                if (o_Play == null) continue;
                PlayControlCursor o_PlayControlCursor = this.m_PlayControlCursors.get(intPlay);
                o_PlayControlCursor.setVisible(o_Play.getActive());
                if (!this.calculatePlayCursor(o_Play, o_Play.getOldPlayCursor())) continue;
                boolRevalidate = true;
            }
        }
        if (boolRevalidate) {
            this.revalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean calculatePlayCursor(Play p_Play, long p_FramePlayCursor) {
        Object object = this.m_SyncPlays;
        synchronized (object) {
            int intIndex = this.m_Plays.indexOf(p_Play);
            if (intIndex < 0) {
                return false;
            }
            PlayControlCursor o_PlayControlCursor = this.m_PlayControlCursors.get(intIndex);
            if (o_PlayControlCursor == null) {
                return false;
            }
            AbsoluteConstraints o_AbsoluteConstraints = o_PlayControlCursor.getAbsoluteConstraints();
            o_AbsoluteConstraints.width = 5;
            o_AbsoluteConstraints.height = this.getHeight();
            int intNewX = this.getPositionX(p_FramePlayCursor);
            if ((intNewX -= o_AbsoluteConstraints.width / 2) != o_AbsoluteConstraints.x) {
                o_AbsoluteConstraints.x = intNewX;
                return true;
            }
            return false;
        }
    }

    public Mark createMark(long p_FramePosition) {
        Mark o_Mark = new Mark(this);
        o_Mark.setFramePosition(p_FramePosition);
        this.addMark(o_Mark);
        return o_Mark;
    }

    public void addMark(Mark p_Mark) {
        if (p_Mark == null) {
            return;
        }
        if (this.m_Marks.contains(p_Mark)) {
            return;
        }
        long longFramePosition = p_Mark.getFramePosition();
        if (longFramePosition < this.m_FrameStart) {
            longFramePosition = this.m_FrameStart;
            p_Mark.setFramePosition(longFramePosition);
        } else if (longFramePosition > this.m_FrameEnd) {
            longFramePosition = this.m_FrameEnd;
            p_Mark.setFramePosition(longFramePosition);
        }
        this.m_Marks.add(p_Mark);
        p_Mark.setVisible(true);
        this.add((Component)p_Mark, p_Mark.getAbsoluteConstraints());
        EventQueueHandler.invokeLater(this.m_Runnable_Calculate_Marks);
        this.m_MarksChanged = true;
        this.notifyListener_MarkAdded(p_Mark);
    }

    public void removeMark(Mark p_Mark) {
        if (p_Mark == null) {
            return;
        }
        if (!this.m_Marks.contains(p_Mark)) {
            return;
        }
        this.m_Marks.remove(p_Mark);
        p_Mark.close();
        p_Mark.setVisible(false);
        this.remove(p_Mark);
        EventQueueHandler.invokeLater(this.m_Runnable_Calculate_Marks);
        this.m_MarksChanged = true;
        this.notifyListener_MarkRemoved(p_Mark);
    }

    public ArrayList<Mark> getMarks() {
        return this.m_Marks;
    }

    public void setSelectedMark(Mark p_Mark) {
        if (this.m_SelectedMark == p_Mark) {
            return;
        }
        if (this.m_SelectedMark != null) {
            this.m_SelectedMark.setSelected(false);
        }
        this.m_SelectedMark = p_Mark;
        if (this.m_SelectedMark != null) {
            this.m_SelectedMark.setSelected(true);
        }
        this.notifyListener_MarkSelected(p_Mark);
    }

    public Mark getSelectedMark() {
        return this.m_SelectedMark;
    }

    public void setMarksChanged(boolean p_MarksChanged) {
        this.m_MarksChanged = p_MarksChanged;
    }

    public boolean getMarksChanged() {
        return this.m_MarksChanged;
    }

    public void calculateMarks() {
        boolean boolRevalidate = false;
        for (int intMark = 0; intMark < this.m_Marks.size(); ++intMark) {
            Mark o_Mark = this.m_Marks.get(intMark);
            if (!this.calculateMark(o_Mark)) continue;
            boolRevalidate = true;
        }
        if (boolRevalidate) {
            this.revalidate();
        }
    }

    public boolean calculateMark(Mark p_Mark) {
        if (p_Mark == null) {
            return false;
        }
        AbsoluteConstraints o_AbsoluteConstraints = p_Mark.getAbsoluteConstraints();
        o_AbsoluteConstraints.height = 2 * this.getHeight() / 3;
        int intNewX = this.getPositionX(p_Mark.getFramePosition());
        if ((intNewX -= o_AbsoluteConstraints.width / 2) != o_AbsoluteConstraints.x) {
            o_AbsoluteConstraints.x = intNewX;
            return true;
        }
        return false;
    }

    public void saveMarks(File p_File) {
        if (p_File == null) {
            return;
        }
        int intMarkCount = this.m_Marks.size();
        try {
            if (p_File.exists()) {
                p_File.delete();
            }
            p_File.createNewFile();
            this.m_FileMarks = p_File;
            FileOutputStream o_FileOutputStream = new FileOutputStream(p_File);
            ObjectOutputStream o_ObjectOutput = new ObjectOutputStream(o_FileOutputStream);
            o_ObjectOutput.writeInt(intMarkCount);
            for (int intMark = 0; intMark < this.m_Marks.size(); ++intMark) {
                Mark o_Mark = this.m_Marks.get(intMark);
                if (o_Mark == null) continue;
                o_Mark.writeExternal(o_ObjectOutput);
            }
            this.m_MarksChanged = false;
            o_ObjectOutput.close();
            o_FileOutputStream.close();
        }
        catch (Exception e) {
            return;
        }
    }

    public void readMarks(File p_File) {
        Mark o_Mark;
        int intMark;
        if (p_File == null) {
            return;
        }
        if (!p_File.exists()) {
            return;
        }
        this.m_FileMarks = p_File;
        ObjectInput o_ObjectInput = null;
        FileInputStream o_FileInputStream = null;
        int intMarkCount = this.m_Marks.size();
        for (intMark = intMarkCount - 1; intMark >= 0; --intMark) {
            o_Mark = this.m_Marks.get(intMark);
            this.removeMark(o_Mark);
        }
        try {
            o_FileInputStream = new FileInputStream(p_File);
            o_ObjectInput = new ObjectInputStream(o_FileInputStream);
            intMarkCount = o_ObjectInput.readInt();
            for (intMark = 0; intMark < intMarkCount; ++intMark) {
                o_Mark = new Mark(this);
                try {
                    o_Mark.readExternal(o_ObjectInput);
                }
                catch (Exception e) {
                    if (e instanceof IOException) break;
                }
                this.addMark(o_Mark);
            }
            o_ObjectInput.close();
            o_FileInputStream.close();
        }
        catch (Exception e) {
            try {
                if (o_ObjectInput != null) {
                    o_ObjectInput.close();
                }
                if (o_FileInputStream != null) {
                    o_FileInputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        this.m_MarksChanged = false;
    }

    public String calculateMarksFilePath(File p_File) {
        if (p_File == null) {
            return null;
        }
        String stringSoundFilePathName = p_File.getPath();
        String stringGraphicsFileName = null;
        stringGraphicsFileName = stringSoundFilePathName.substring(stringSoundFilePathName.length() - 4, stringSoundFilePathName.length() - 3).equals(".") ? stringSoundFilePathName.substring(0, stringSoundFilePathName.length() - 4) + ".lsm" : stringSoundFilePathName + ".lsm";
        return stringGraphicsFileName;
    }

    @Override
    public void setFont(Font p_Font) {
        super.setFont(p_Font);
    }

    @Override
    public Font getFont() {
        return super.getFont();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTimeString(long p_Milliseconds) {
        int intDays = (int)(p_Milliseconds / 86400000L);
        Object object = this.m_SyncStringBuilder;
        synchronized (object) {
            this.m_StringBuilderTime.delete(0, this.m_StringBuilderTime.length());
            if ((double)(this.m_FrameEnd - this.m_FrameStart) * this.m_FrameTime > 8.64E7) {
                if ((int)(this.m_TickTimeJump / 86400000L) > 0) {
                    this.m_StringBuilderTime.append("      ");
                    this.m_StringBuilderTime.append(intDays);
                    if (intDays > 1) {
                        this.m_StringBuilderTime.append(" d");
                    } else {
                        this.m_StringBuilderTime.append(" d");
                    }
                    return this.m_StringBuilderTime.toString();
                }
                if (intDays > 0) {
                    this.m_StringBuilderTime.append(intDays);
                    this.m_StringBuilderTime.append("d ");
                    p_Milliseconds -= (long)(intDays * 86400000);
                }
            }
            int intHours = (int)(p_Milliseconds / 3600000L);
            int intMinutes = (int)((p_Milliseconds -= (long)(intHours * 3600000)) / 60000L);
            int intSeconds = (int)((p_Milliseconds -= (long)(intMinutes * 60000)) / 1000L);
            int intMilliseconds = (int)(p_Milliseconds -= (long)(intSeconds * 1000));
            if (intHours < 10) {
                this.m_StringBuilderTime.append("0");
            }
            this.m_StringBuilderTime.append(intHours);
            this.m_StringBuilderTime.append(":");
            if (intMinutes < 10) {
                this.m_StringBuilderTime.append("0");
            }
            this.m_StringBuilderTime.append(intMinutes);
            this.m_StringBuilderTime.append(":");
            if (intSeconds < 10) {
                this.m_StringBuilderTime.append("0");
            }
            this.m_StringBuilderTime.append(intSeconds);
            this.m_StringBuilderTime.append(":");
            if (intMilliseconds < 10) {
                this.m_StringBuilderTime.append("00");
                this.m_StringBuilderTime.append(intMilliseconds);
            } else if (intMilliseconds < 100) {
                this.m_StringBuilderTime.append("0");
                this.m_StringBuilderTime.append(intMilliseconds);
            } else {
                this.m_StringBuilderTime.append(intMilliseconds);
            }
            return this.m_StringBuilderTime.toString();
        }
    }

    private void calculateRuler() {
        long longTimeStartFactor;
        int intWidth = this.getWidth();
        if (intWidth <= 5) {
            this.m_TickCount = -1;
            return;
        }
        if (this.m_Rectangle2D_TimeString.getWidth() <= 0.0) {
            return;
        }
        this.m_TickTimeJump = 1L;
        double doubleMinimalFrameJump = (double)(this.m_VisibleFrameEnd - this.m_VisibleFrameStart) / ((double)intWidth / (this.m_Rectangle2D_TimeString.getWidth() + 10.0));
        double doubleMinimalTimeJump = doubleMinimalFrameJump * this.m_FrameTime;
        if (doubleMinimalTimeJump < 100.0) {
            this.m_TickTimeJump = 100L;
        } else if (doubleMinimalTimeJump < 500.0) {
            this.m_TickTimeJump = 500L;
        } else if (doubleMinimalTimeJump < 1000.0) {
            this.m_TickTimeJump = 1000L;
        } else if (doubleMinimalTimeJump < 2000.0) {
            this.m_TickTimeJump = 2000L;
        } else if (doubleMinimalTimeJump < 5000.0) {
            this.m_TickTimeJump = 5000L;
        } else if (doubleMinimalTimeJump < 10000.0) {
            this.m_TickTimeJump = 10000L;
        } else if (doubleMinimalTimeJump < 30000.0) {
            this.m_TickTimeJump = 30000L;
        } else if (doubleMinimalTimeJump < 60000.0) {
            this.m_TickTimeJump = 60000L;
        } else if (doubleMinimalTimeJump < 120000.0) {
            this.m_TickTimeJump = 120000L;
        } else if (doubleMinimalTimeJump < 300000.0) {
            this.m_TickTimeJump = 300000L;
        } else if (doubleMinimalTimeJump < 600000.0) {
            this.m_TickTimeJump = 600000L;
        } else if (doubleMinimalTimeJump < 1800000.0) {
            this.m_TickTimeJump = 1800000L;
        } else if (doubleMinimalTimeJump < 3600000.0) {
            this.m_TickTimeJump = 3600000L;
        } else if (doubleMinimalTimeJump < 1.8E7) {
            this.m_TickTimeJump = 18000000L;
        } else if (doubleMinimalTimeJump < 3.6E7) {
            this.m_TickTimeJump = 36000000L;
        } else if (doubleMinimalTimeJump < 8.64E7) {
            this.m_TickTimeJump = 86400000L;
        } else if (doubleMinimalTimeJump < 1.728E8) {
            this.m_TickTimeJump = 172800000L;
        } else if (doubleMinimalTimeJump < 4.32E8) {
            this.m_TickTimeJump = 432000000L;
        } else if (doubleMinimalTimeJump < 8.64E8) {
            this.m_TickTimeJump = 864000000L;
        } else {
            this.m_TickTimeStart = 0L;
            this.m_TickFrameStart = 0L;
            this.m_TickFrameJump = 0.0;
            this.m_TickCount = -1;
            return;
        }
        if (this.m_FrameTime == 0.0) {
            longTimeStartFactor = 1L;
            this.m_FrameTime = 1.0;
        } else {
            longTimeStartFactor = (long)((double)this.m_VisibleFrameStart * this.m_FrameTime / (double)this.m_TickTimeJump) + 1L;
        }
        this.m_TickTimeStart = longTimeStartFactor * this.m_TickTimeJump;
        this.m_TickFrameStart = (long)((double)(longTimeStartFactor * this.m_TickTimeJump) / this.m_FrameTime);
        this.m_TickFrameJump = (double)this.m_TickTimeJump / this.m_FrameTime;
        this.m_TickCount = (int)((double)(this.m_VisibleFrameEnd - this.m_VisibleFrameStart) / this.m_TickFrameJump);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateMainSceneBridges() {
        Object object = this.m_SyncPlays;
        synchronized (object) {
            if (this.m_Plays.size() <= 0) {
                this.m_LiveShowMainSceneBridges = null;
                return;
            }
            Play o_Play = this.m_Plays.get(0);
            if (o_Play == null) {
                return;
            }
            Playable o_Playable = o_Play.getPlayable();
            if (o_Playable == null) {
                return;
            }
            if (!(o_Playable instanceof LiveShowVIP)) {
                this.m_LiveShowMainSceneBridges = null;
                return;
            }
            LiveShowVIP o_LiveShowVIP = (LiveShowVIP)o_Playable;
            this.m_LiveShowMainSceneBridges = o_LiveShowVIP.getLiveShowSceneBridges(this.m_LiveShowMainSceneBridges, true);
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            EventQueueHandler.invokeLater(this.m_Runnable_Repaint);
        } else {
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics p_Graphics) {
        super.paintComponent(p_Graphics);
        if (this.isOpaque()) {
            p_Graphics.setColor(this.getBackground());
            p_Graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        int intHeightTimeString = 0;
        int intHeightTimeTicks = this.getHeight() / 2;
        Object object = this.m_SyncPlays;
        synchronized (object) {
            if (this.m_LiveShowMainSceneBridges != null) {
                Shape o_OldClip = p_Graphics.getClip();
                Font o_OldFont = p_Graphics.getFont();
                Color o_OldColor = p_Graphics.getColor();
                p_Graphics.setFont(this.m_SceneBridgeFont);
                int intFontDescent = p_Graphics.getFontMetrics(this.m_SceneBridgeFont).getDescent();
                p_Graphics.setColor(Color.LIGHT_GRAY);
                for (int intBridge = 0; intBridge < this.m_LiveShowMainSceneBridges.size(); ++intBridge) {
                    long longFrameEnd;
                    String stringBridgeName;
                    LiveShowSceneBridge o_LiveShowSceneBridge = this.m_LiveShowMainSceneBridges.get(intBridge);
                    if (o_LiveShowSceneBridge == null || (stringBridgeName = o_LiveShowSceneBridge.getName()) == null) continue;
                    long longFrameStart = o_LiveShowSceneBridge.getFrameStart();
                    if (longFrameStart < this.m_VisibleFrameStart) {
                        longFrameStart = this.m_VisibleFrameStart;
                    }
                    if (intBridge + 1 >= this.m_LiveShowMainSceneBridges.size()) {
                        longFrameEnd = this.m_VisibleFrameEnd;
                    } else {
                        longFrameEnd = this.m_LiveShowMainSceneBridges.get(intBridge + 1).getFrameStart();
                        if (longFrameEnd < this.m_VisibleFrameStart) continue;
                        if (longFrameEnd > this.m_VisibleFrameEnd) {
                            longFrameEnd = this.m_VisibleFrameEnd;
                        }
                    }
                    int intPositionStart = this.getPositionX(longFrameStart);
                    int intPositionEnd = this.getPositionX(longFrameEnd);
                    Rectangle2D o_RectangleString = p_Graphics.getFontMetrics(this.m_SceneBridgeFont).getStringBounds(stringBridgeName, p_Graphics);
                    p_Graphics.setClip(intPositionStart, 0, intPositionEnd - intPositionStart, this.getHeight());
                    p_Graphics.drawString(stringBridgeName, intPositionStart + (int)((double)(intPositionEnd - intPositionStart) - o_RectangleString.getWidth()) / 2, (int)(o_RectangleString.getHeight() - 0.5) - intFontDescent);
                }
                p_Graphics.setClip(o_OldClip);
                p_Graphics.setFont(o_OldFont);
                p_Graphics.setColor(o_OldColor);
            }
        }
        intHeightTimeString = this.getHeight() / 3;
        intHeightTimeTicks = 6 * this.getHeight() / 7;
        Rectangle2D o_Rectangle2D = p_Graphics.getFontMetrics(super.getFont()).getStringBounds(" 88:88;88:888", p_Graphics);
        if (o_Rectangle2D.getWidth() != this.m_Rectangle2D_TimeString.getWidth()) {
            this.m_Rectangle2D_TimeString.setRect(o_Rectangle2D);
            this.calculateRuler();
        }
        p_Graphics.setColor(Color.WHITE);
        for (int intTick = 0; intTick <= this.m_TickCount; ++intTick) {
            long longTickFrame = (long)((double)this.m_TickFrameStart + (double)intTick * this.m_TickFrameJump);
            int intTickPositionX = this.getPositionX(longTickFrame);
            p_Graphics.drawLine(intTickPositionX, intHeightTimeTicks, intTickPositionX, this.getHeight());
            p_Graphics.drawString(this.getTimeString(this.m_TickTimeStart + this.m_TickTimeJump * (long)intTick), (int)((double)intTickPositionX - this.m_Rectangle2D_TimeString.getWidth() / 2.0), intHeightTimeString + (int)this.m_Rectangle2D_TimeString.getHeight());
        }
    }

    @Override
    public void eventPlayStart(Play p_Play) {
    }

    @Override
    public void eventPlayStop(Play p_Play) {
    }

    @Override
    public void eventPlayPause(Play p_Play) {
    }

    @Override
    public void eventPlayRewind(Play p_Play) {
    }

    @Override
    public void eventPlayFastForward(Play p_Play) {
    }

    @Override
    public void eventPlayFadePossibility(Play p_Play, boolean p_FadeInPossible, boolean p_FadeOutPossible, double p_FadeProgress) {
    }

    @Override
    public void eventPlayFadedIn(Play p_Play, boolean p_FadedIn, double p_FadeProgress) {
    }

    @Override
    public long eventPlayCheckRead(Play p_Play, long p_FrameStart, long p_FramesToRead) {
        return p_FramesToRead;
    }

    @Override
    public void eventEditModeOn(Play p_Play, boolean p_EditModeOn) {
    }

    @Override
    public void eventEditCursorSet(Play p_Play, long p_PlayCursor) {
    }

    @Override
    public void eventPlayCursorSet(Play p_Play, long p_PlayCursor) {
    }

    @Override
    public void eventPlayCursor(Play p_Play, long p_OldPlayCursor, long p_PlayCursor) {
        if (this.calculatePlayCursor(p_Play, p_Play.getOldPlayCursor())) {
            EventQueueHandler.invokeLater(this.m_Runnable_Revalidate);
        }
    }

    @Override
    public void eventPlayClosing(Play p_Play) {
        this.removePlay(p_Play);
    }

    @Override
    public void eventPlayError(Play p_Play, Exception p_Exception, String p_Remark) {
    }

    @Override
    public void eventPlayTimelineEnd(Play p_Play) {
    }

    @Override
    public void eventViewChanged(long p_FrameStart, long p_FrameEnd, long p_VisibleFrameStart, long p_VisibleFrameEnd, Rectangle p_Bounds) {
        this.m_FrameStart = p_FrameStart;
        this.m_FrameEnd = p_FrameEnd;
        this.m_VisibleFrameStart = p_VisibleFrameStart;
        this.m_VisibleFrameEnd = p_VisibleFrameEnd;
        this.calculatePlayCursors();
        this.calculateRuler();
        this.calculateMarks();
        if (!SwingUtilities.isEventDispatchThread()) {
            EventQueueHandler.invokeLater(this.m_Runnable_Repaint);
        } else {
            this.repaint();
        }
    }

    @Override
    public void eventViewScrollAutomaticStart() {
    }

    @Override
    public void eventZoomPlus(boolean p_AdjustFramePosition, long p_FramePosition) {
    }

    @Override
    public void eventZoomMinus(boolean p_AdjustFramePosition, long p_FramePosition) {
    }

    @Override
    public void eventZoomReset() {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.getWidth() == this.m_OldSize.width && this.getHeight() == this.m_OldSize.height) {
            return;
        }
        this.m_OldSize.setSize(this.getWidth(), this.getHeight());
        this.calculatePlayCursors();
        this.calculateRuler();
        this.calculateMarks();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        int intX = e.getX();
        long longFrame = this.getPositionFrame(intX);
        this.setPlayCursors(longFrame);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int intX = e.getX();
        long longFrame = this.getPositionFrame(intX);
        this.setPlayCursors(longFrame);
        try {
            Thread.sleep(40L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void eventVIPActive(LiveShowVIP p_LiveShowVIP, boolean p_Active) {
    }

    @Override
    public void eventVIPToFront(LiveShowVIP p_LiveShowVIP) {
    }

    @Override
    public void eventVIPTrackAdded(LiveShowVIP p_LiveShowSoundVIP, LiveShowVIPTrack p_LiveShowVIPTrack) {
    }

    @Override
    public void eventVIPTrackRemoved(LiveShowVIP p_LiveShowSoundVIP, LiveShowVIPTrack p_LiveShowVIPTrack) {
    }

    @Override
    public void eventVIPFrameMaxObjects(LiveShowVIP p_LiveShowVIP, long p_FrameMaxObjects) {
    }

    @Override
    public void eventVIPMaxFrame(LiveShowVIP p_LiveShowVIP, long p_FrameMax) {
    }

    @Override
    public void eventVIPFrameTime(LiveShowVIP p_LiveShowVIP, double p_FrameTime) {
    }

    @Override
    public void eventVIPClosing(LiveShowVIP p_LiveShowSoundVIP) {
    }

    @Override
    public void eventVIPSceneBridgeAdded(LiveShowVIP p_LiveShowSoundVIP, LiveShowSceneBridge p_LiveShowSceneBridge) {
        if (!p_LiveShowSceneBridge.getIsMainBridge()) {
            return;
        }
        EventQueueHandler.invokeLater(this.m_Runnable_CalculateMainSceneBridges);
    }

    @Override
    public void eventVIPSceneBridgeRemoved(LiveShowVIP p_LiveShowSoundVIP, LiveShowSceneBridge p_LiveShowSceneBridge) {
        if (!p_LiveShowSceneBridge.getIsMainBridge()) {
            return;
        }
        EventQueueHandler.invokeLater(this.m_Runnable_CalculateMainSceneBridges);
    }

    @Override
    public void eventVIPSceneBridgesResorted(LiveShowVIP p_LiveShowSoundVIP, LiveShowSceneBridge p_LiveShowSceneBridge, ArrayList<LiveShowSceneBridge> p_LiveShowSceneBridges) {
        if (!p_LiveShowSceneBridge.getIsMainBridge()) {
            return;
        }
        EventQueueHandler.invokeLater(this.m_Runnable_CalculateMainSceneBridges);
    }

    @Override
    public void eventVIPSceneBridgeCursorChanged(LiveShowVIP p_LiveShowVIP, boolean p_ActualPlaying, boolean p_ActualStopAtStart) {
    }

    @Override
    public void eventVIPSceneBridgeEditCursorChanged(LiveShowVIP p_LiveShowVIP) {
    }

    @Override
    public void eventVIPSceneBridgeStart(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge, boolean p_WillPlay) {
    }

    @Override
    public void eventVIPSceneBridgeEnd(LiveShowVIP p_LiveShowVIP, LiveShowSceneBridge p_LiveShowSceneBridge) {
    }

    @Override
    public void eventVIPObjectAdded(LiveShowVIP p_LiveShowSoundVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
    }

    @Override
    public void eventVIPObjectRemoved(LiveShowVIP p_LiveShowSoundVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
    }

    @Override
    public void eventVIPObjectParamChanged(LiveShowVIP p_LiveShowSoundVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
        LiveShowSceneBridge o_LiveShowSceneBridge;
        if (p_LiveShowObjectInterface instanceof LiveShowSceneBridge && (o_LiveShowSceneBridge = (LiveShowSceneBridge)p_LiveShowObjectInterface).getIsMainBridge()) {
            EventQueueHandler.invokeLater(this.m_Runnable_Repaint);
        }
    }

    @Override
    public void eventVIPObjectShowSettings(LiveShowVIP p_LiveShowSoundVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
    }

    @Override
    public void eventVIPObjectSelection(LiveShowVIP p_LiveShowSoundVIP, LiveShowObjectInterface p_LiveShowObjectInterface) {
    }

    @Override
    public void eventVIPEditModeOn(LiveShowVIP p_LiveShowVIP, boolean p_EditModeOn) {
    }

    @Override
    public void eventVIPCursorMode(LiveShowVIP p_LiveShowSoundVIP, int p_EditMode) {
    }

    @Override
    public void eventVIPEndOfAction(LiveShowVIP p_LiveShowVIP, LiveShowVIP p_ActorLiveShowVIP, boolean p_Success, int p_Action) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addLiveShowTimeBarListener(LiveShowTimeBarListener p_LiveShowTimeBarListener) {
        if (p_LiveShowTimeBarListener == null) {
            return false;
        }
        boolean boolAdded = false;
        Object object = this.m_SyncTimeBarListener;
        synchronized (object) {
            if (this.m_LiveShowTimeBarListeners != null && !this.m_LiveShowTimeBarListeners.contains(p_LiveShowTimeBarListener)) {
                this.m_LiveShowTimeBarListeners.add(p_LiveShowTimeBarListener);
                boolAdded = true;
            }
        }
        return boolAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeLiveShowTimeBarListener(LiveShowTimeBarListener p_LiveShowTimeBarListener) {
        if (p_LiveShowTimeBarListener == null) {
            return false;
        }
        boolean boolRemoved = false;
        Object object = this.m_SyncTimeBarListener;
        synchronized (object) {
            if (this.m_LiveShowTimeBarListeners != null) {
                boolRemoved = this.m_LiveShowTimeBarListeners.remove(p_LiveShowTimeBarListener);
            }
        }
        return boolRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListener_MarkAdded(Mark p_Mark) {
        ArrayList<LiveShowTimeBarListener> o_LiveShowTimeBarListeners;
        Object object = this.m_SyncTimeBarListener;
        synchronized (object) {
            if (this.m_LiveShowTimeBarListeners == null) {
                return;
            }
            if (this.m_LiveShowTimeBarListeners.size() <= 0) {
                return;
            }
            o_LiveShowTimeBarListeners = new ArrayList<LiveShowTimeBarListener>(this.m_LiveShowTimeBarListeners.size());
            o_LiveShowTimeBarListeners.addAll(this.m_LiveShowTimeBarListeners);
        }
        int intListenerCount = o_LiveShowTimeBarListeners.size();
        for (int intListener = 0; intListener < intListenerCount; ++intListener) {
            LiveShowTimeBarListener o_LiveShowTimeBarListener = (LiveShowTimeBarListener)o_LiveShowTimeBarListeners.get(intListener);
            o_LiveShowTimeBarListener.eventMarkAdded(this, p_Mark);
        }
        o_LiveShowTimeBarListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListener_MarkRemoved(Mark p_Mark) {
        ArrayList<LiveShowTimeBarListener> o_LiveShowTimeBarListeners;
        Object object = this.m_SyncTimeBarListener;
        synchronized (object) {
            if (this.m_LiveShowTimeBarListeners == null) {
                return;
            }
            if (this.m_LiveShowTimeBarListeners.size() <= 0) {
                return;
            }
            o_LiveShowTimeBarListeners = new ArrayList<LiveShowTimeBarListener>(this.m_LiveShowTimeBarListeners.size());
            o_LiveShowTimeBarListeners.addAll(this.m_LiveShowTimeBarListeners);
        }
        int intListenerCount = o_LiveShowTimeBarListeners.size();
        for (int intListener = 0; intListener < intListenerCount; ++intListener) {
            LiveShowTimeBarListener o_LiveShowTimeBarListener = (LiveShowTimeBarListener)o_LiveShowTimeBarListeners.get(intListener);
            o_LiveShowTimeBarListener.eventMarkRemoved(this, p_Mark);
        }
        o_LiveShowTimeBarListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListener_MarkSelected(Mark p_Mark) {
        ArrayList<LiveShowTimeBarListener> o_LiveShowTimeBarListeners;
        Object object = this.m_SyncTimeBarListener;
        synchronized (object) {
            if (this.m_LiveShowTimeBarListeners == null) {
                return;
            }
            if (this.m_LiveShowTimeBarListeners.size() <= 0) {
                return;
            }
            o_LiveShowTimeBarListeners = new ArrayList<LiveShowTimeBarListener>(this.m_LiveShowTimeBarListeners.size());
            o_LiveShowTimeBarListeners.addAll(this.m_LiveShowTimeBarListeners);
        }
        int intListenerCount = o_LiveShowTimeBarListeners.size();
        for (int intListener = 0; intListener < intListenerCount; ++intListener) {
            LiveShowTimeBarListener o_LiveShowTimeBarListener = (LiveShowTimeBarListener)o_LiveShowTimeBarListeners.get(intListener);
            o_LiveShowTimeBarListener.eventMarkSelected(this, p_Mark);
        }
        o_LiveShowTimeBarListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListener_ShowMarkSettings(Mark p_Mark, Point p_ScreenLocation) {
        ArrayList<LiveShowTimeBarListener> o_LiveShowTimeBarListeners;
        if (this.m_Plays.size() <= 0) {
            return;
        }
        Play o_Play = this.m_Plays.get(0);
        if (o_Play == null) {
            return;
        }
        Playable o_Playable = o_Play.getPlayable();
        if (o_Playable == null) {
            return;
        }
        Object object = this.m_SyncTimeBarListener;
        synchronized (object) {
            if (this.m_LiveShowTimeBarListeners == null) {
                return;
            }
            if (this.m_LiveShowTimeBarListeners.size() <= 0) {
                return;
            }
            o_LiveShowTimeBarListeners = new ArrayList<LiveShowTimeBarListener>(this.m_LiveShowTimeBarListeners.size());
            o_LiveShowTimeBarListeners.addAll(this.m_LiveShowTimeBarListeners);
        }
        int intListenerCount = o_LiveShowTimeBarListeners.size();
        for (int intListener = 0; intListener < intListenerCount; ++intListener) {
            LiveShowTimeBarListener o_LiveShowTimeBarListener = (LiveShowTimeBarListener)o_LiveShowTimeBarListeners.get(intListener);
            o_LiveShowTimeBarListener.eventShowMarkSettings(this, p_Mark, o_Playable, p_ScreenLocation);
        }
        o_LiveShowTimeBarListeners.clear();
    }

    public static interface MarkListener {
        public void eventMarkParameterChanged(Mark var1, String var2, long var3);

        public void eventMarkClosed(Mark var1);

        public void eventMarkSelection(Mark var1, boolean var2);
    }

    public static class Mark
    extends JComponent
    implements Externalizable {
        public static final int SOFTWAREVERSION = 1;
        public static final String FILESUFFIX = ".lsm";
        public static final int MARKWIDTH = 11;
        public LiveShowTimeBar m_LiveShowTimeBar;
        private long m_FramePosition;
        private String m_Name;
        private AbsoluteConstraints m_AbsoluteConstraints;
        private Color m_Color;
        private int[] m_PointsX;
        private int[] m_PointsY;
        private FontMetrics m_FontMetrics;
        private boolean m_IsSelected;
        private int m_MousePressedPosition;
        private ArrayList<MarkListener> m_MarkListeners;
        private final Object m_SyncMarkListeners = new Object();
        private MouseAdapter_Delayed m_MouseAdapter_Delayed;
        private Mark m_SelfReference = this;
        private Runnable m_RunnableRepaint;

        public Mark(LiveShowTimeBar p_LiveShowTimeBar) {
            this.m_LiveShowTimeBar = p_LiveShowTimeBar;
            this.initMembers();
            this.initComponents();
            this.setName("Marker");
        }

        private void initMembers() {
            this.m_MarkListeners = new ArrayList();
            this.m_FramePosition = 0L;
            this.m_IsSelected = false;
            this.m_RunnableRepaint = new Runnable(){

                @Override
                public void run() {
                    this.repaint();
                }
            };
        }

        private void initComponents() {
            this.createMouseAdapter_Delayed();
            this.m_AbsoluteConstraints = new AbsoluteConstraints(0, 0);
            this.m_AbsoluteConstraints.width = 11;
            this.m_Color = Color.BLUE;
            this.m_PointsX = new int[3];
            this.m_PointsY = new int[3];
            super.setOpaque(false);
            Font o_Font = new Font("Monospaced", 0, 11);
            super.setFont(o_Font);
            this.m_FontMetrics = super.getFontMetrics(super.getFont());
            super.addMouseListener(this.m_MouseAdapter_Delayed);
            super.addMouseMotionListener(this.m_MouseAdapter_Delayed);
        }

        public void close() {
            this.notifyObjectListeners_ObjectClosing();
            this.setVisible(false);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(1);
            out.writeUTF(this.m_Name);
            out.writeLong(this.m_FramePosition);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int intSoftwareVersion = in.readInt();
            if (intSoftwareVersion < 0 || intSoftwareVersion > 1) {
                throw new IOException("0");
            }
            this.m_Name = in.readUTF();
            this.m_FramePosition = in.readLong();
            this.setName(this.m_Name);
        }

        public AbsoluteConstraints getAbsoluteConstraints() {
            return this.m_AbsoluteConstraints;
        }

        public void setFramePosition(long p_FramePosition) {
            if (p_FramePosition < this.m_LiveShowTimeBar.getFrameStart()) {
                p_FramePosition = this.m_LiveShowTimeBar.getFrameStart();
            }
            if (p_FramePosition > this.m_LiveShowTimeBar.getFrameEnd()) {
                p_FramePosition = this.m_LiveShowTimeBar.getFrameEnd();
            }
            if (this.m_FramePosition == p_FramePosition) {
                return;
            }
            this.m_FramePosition = p_FramePosition;
            this.m_LiveShowTimeBar.calculateMarks();
            this.m_LiveShowTimeBar.setMarksChanged(true);
            this.notifyObjectListeners_ObjectParameterChanged();
        }

        public long getFramePosition() {
            return this.m_FramePosition;
        }

        @Override
        public void setName(String p_Name) {
            super.setName(p_Name);
            super.setToolTipText(p_Name);
            this.m_Name = p_Name;
            int intWidth = this.m_FontMetrics.stringWidth(p_Name);
            if (intWidth < 11) {
                intWidth = 11;
            }
            this.m_AbsoluteConstraints.width = intWidth;
            if (this.m_LiveShowTimeBar.calculateMark(this)) {
                this.m_LiveShowTimeBar.setMarksChanged(true);
                this.m_LiveShowTimeBar.revalidate();
            }
            if (!SwingUtilities.isEventDispatchThread()) {
                EventQueueHandler.invokeLater(this.m_RunnableRepaint);
            } else {
                this.repaint();
            }
        }

        @Override
        public String getName() {
            return this.m_Name;
        }

        public void setSelected(boolean p_Selected) {
            if (this.m_IsSelected == p_Selected) {
                return;
            }
            this.m_IsSelected = p_Selected;
            if (!SwingUtilities.isEventDispatchThread()) {
                EventQueueHandler.invokeLater(this.m_RunnableRepaint);
            } else {
                this.repaint();
            }
        }

        public boolean getSelected() {
            return this.m_IsSelected;
        }

        @Override
        public void paintComponent(Graphics p_Graphics) {
            super.paintComponent(p_Graphics);
            int intXPositionMark = this.m_AbsoluteConstraints.width / 2;
            int intFontHeight = this.m_FontMetrics.getAscent();
            p_Graphics.setColor(this.m_Color);
            if (this.m_IsSelected) {
                p_Graphics.fillRect(0, 0, this.m_AbsoluteConstraints.width - 1, this.m_AbsoluteConstraints.height - 1);
            }
            this.m_PointsX[0] = intXPositionMark - 5;
            this.m_PointsY[0] = intFontHeight;
            this.m_PointsX[1] = intXPositionMark + 5;
            this.m_PointsY[1] = intFontHeight;
            this.m_PointsX[2] = intXPositionMark;
            this.m_PointsY[2] = this.m_AbsoluteConstraints.height - 1;
            p_Graphics.fillPolygon(this.m_PointsX, this.m_PointsY, 3);
            p_Graphics.setColor(Color.LIGHT_GRAY);
            p_Graphics.drawPolygon(this.m_PointsX, this.m_PointsY, 3);
            p_Graphics.drawString(this.m_Name, 0, this.m_FontMetrics.getAscent());
        }

        private void createMouseAdapter_Delayed() {
            this.m_MouseAdapter_Delayed = new MouseAdapter_Delayed(){

                @Override
                public void mouseClicked_Delayed(MouseEvent e) {
                    m_LiveShowTimeBar.setSelectedMark(m_SelfReference);
                    if (e.getClickCount() > 1) {
                        Point o_Point = e.getPoint();
                        Point o_PointTimeBarParent = m_LiveShowTimeBar.getRootPane().getParent().getLocation();
                        o_Point.x = (int)((double)o_Point.x + o_PointTimeBarParent.getX());
                        o_Point.y = (int)((double)o_Point.y + o_PointTimeBarParent.getY());
                        m_LiveShowTimeBar.notifyListener_ShowMarkSettings(m_SelfReference, o_Point);
                    } else {
                        m_LiveShowTimeBar.setPlayCursors(m_FramePosition);
                    }
                }

                @Override
                public void mousePressed_Delayed(MouseEvent e) {
                    m_MousePressedPosition = e.getX();
                }

                @Override
                public void mouseDragged_Delayed(MouseEvent e) {
                    this.sleep(30L);
                    int intDiff = e.getX() - m_MousePressedPosition;
                    long longFrameDiff = (long)((double)intDiff * m_LiveShowTimeBar.getFramesPerPoint());
                    long longFramePosition = m_FramePosition + longFrameDiff;
                    this.setFramePosition(longFramePosition);
                    m_LiveShowTimeBar.setPlayCursors(longFramePosition);
                }

                @Override
                public void mouseReleased_Delayed(MouseEvent e) {
                }

                @Override
                public void mouseEntered_Delayed(MouseEvent e) {
                }

                @Override
                public void mouseExited_Delayed(MouseEvent e) {
                }

                @Override
                public void mouseMoved_Delayed(MouseEvent e) {
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addMarkListener(MarkListener p_MarkListener) {
            if (p_MarkListener == null) {
                return false;
            }
            boolean boolAdded = false;
            Object object = this.m_SyncMarkListeners;
            synchronized (object) {
                if (this.m_MarkListeners != null && !this.m_MarkListeners.contains(p_MarkListener)) {
                    this.m_MarkListeners.add(p_MarkListener);
                    boolAdded = true;
                }
            }
            return boolAdded;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeMarkListener(MarkListener p_MarkListener) {
            if (p_MarkListener == null) {
                return false;
            }
            boolean boolRemoved = false;
            Object object = this.m_SyncMarkListeners;
            synchronized (object) {
                if (this.m_MarkListeners != null) {
                    boolRemoved = this.m_MarkListeners.remove(p_MarkListener);
                }
            }
            return boolRemoved;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void notifyObjectListeners_ObjectParameterChanged() {
            ArrayList<MarkListener> o_MarkListeners;
            Object object = this.m_SyncMarkListeners;
            synchronized (object) {
                if (this.m_MarkListeners == null) {
                    return;
                }
                if (this.m_MarkListeners.size() <= 0) {
                    return;
                }
                o_MarkListeners = new ArrayList<MarkListener>(this.m_MarkListeners.size());
                o_MarkListeners.addAll(this.m_MarkListeners);
            }
            for (int intListener = 0; intListener < o_MarkListeners.size(); ++intListener) {
                MarkListener o_Listener = (MarkListener)o_MarkListeners.get(intListener);
                o_Listener.eventMarkParameterChanged(this, this.m_Name, this.m_FramePosition);
            }
            o_MarkListeners.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void notifyObjectListeners_ObjectClosing() {
            ArrayList<MarkListener> o_MarkListeners;
            Object object = this.m_SyncMarkListeners;
            synchronized (object) {
                if (this.m_MarkListeners == null) {
                    return;
                }
                if (this.m_MarkListeners.size() <= 0) {
                    return;
                }
                o_MarkListeners = new ArrayList<MarkListener>(this.m_MarkListeners.size());
                o_MarkListeners.addAll(this.m_MarkListeners);
                this.m_MarkListeners.clear();
            }
            int intListenerCount = o_MarkListeners.size();
            for (int intListener = intListenerCount - 1; intListener >= 0 && o_MarkListeners.size() > 0; --intListener) {
                MarkListener o_Listener = (MarkListener)o_MarkListeners.get(intListener);
                o_Listener.eventMarkClosed(this);
                o_MarkListeners.remove(o_Listener);
            }
            o_MarkListeners.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void notifyObjectListeners_Selection(boolean p_Added) {
            ArrayList<MarkListener> o_MarkListeners;
            Object object = this.m_SyncMarkListeners;
            synchronized (object) {
                if (this.m_MarkListeners == null) {
                    return;
                }
                if (this.m_MarkListeners.size() <= 0) {
                    return;
                }
                o_MarkListeners = new ArrayList<MarkListener>(this.m_MarkListeners.size());
                o_MarkListeners.addAll(this.m_MarkListeners);
            }
            for (int intListener = 0; intListener < o_MarkListeners.size(); ++intListener) {
                MarkListener o_Listener = (MarkListener)o_MarkListeners.get(intListener);
                o_Listener.eventMarkSelection(this, this.m_IsSelected);
            }
            o_MarkListeners.clear();
        }
    }

    public static interface LiveShowTimeBarListener {
        public void eventMarkAdded(LiveShowTimeBar var1, Mark var2);

        public void eventMarkRemoved(LiveShowTimeBar var1, Mark var2);

        public void eventMarkSelected(LiveShowTimeBar var1, Mark var2);

        public void eventShowMarkSettings(LiveShowTimeBar var1, Mark var2, Playable var3, Point var4);
    }
}

