/*
 * Decompiled with CFR 0.152.
 */
package LiveShowPlayPackage;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowPlayPackage.Play;
import LiveShowPlayPackage.PlayListener;
import LiveShowPlayPackage.PlayRemoteActions;
import LiveShowPlayPackage.Playable;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import LiveShowVirtualPackage.LiveShowVIP;
import SPITActionPackage.SPIT_ActionStatus;
import SPITActionPackage.SPIT_Action_Interface;
import SPITLibraryPackage.SPIT_Object_Interface;
import SPITLibraryPackage.SPIT_Type_Interface;
import SPITRemotePackage.SPITRemote;
import SwingComponents.MouseAdapter_Delayed;
import SwingToolTipPackage.PopUpToolTip;
import SynchronizationPackage.EventQueueHandler;
import ToolsGraphics.JLabelBackground;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;

public class PlayControlPanel
extends JPanel
implements PlayListener,
SPIT_Action_Interface {
    public static ImageIcon ICON_PLAYREWIND_32 = new ImageIcon(PlayControlPanel.class.getResource("/IconsPackage/PlayRewind32.png"));
    public static ImageIcon ICON_PLAYSTART_32 = new ImageIcon(PlayControlPanel.class.getResource("/IconsPackage/PlayStart32.png"));
    public static ImageIcon ICON_PLAYPAUSE_32 = new ImageIcon(PlayControlPanel.class.getResource("/IconsPackage/PlayPause32.png"));
    public static ImageIcon ICON_PLAYSTOP_32 = new ImageIcon(PlayControlPanel.class.getResource("/IconsPackage/PlayStop32.png"));
    public static ImageIcon ICON_PLAYFASTFORWARD_32 = new ImageIcon(PlayControlPanel.class.getResource("/IconsPackage/PlayFastForward32.png"));
    public static ImageIcon ICON_PLAYFADEINPAUSE_32 = new ImageIcon(PlayControlPanel.class.getResource("/IconsPackage/PlayFadeInPause32.png"));
    public static ImageIcon ICON_PLAYFADEOUT_32 = new ImageIcon(PlayControlPanel.class.getResource("/IconsPackage/PlayFadeOut32.png"));
    public static ImageIcon ICON_PLAYFADEOUTDIRECT_32 = new ImageIcon(PlayControlPanel.class.getResource("/IconsPackage/PlayFadeOut32.png"));
    public static ImageIcon ICON_PLAYSTARTFADEOUT_32 = new ImageIcon(PlayControlPanel.class.getResource("/IconsPackage/PlayStartFadeOut32.png"));
    public static ImageIcon ICON_PLAYREWIND_24 = new ImageIcon(PlayControlPanel.class.getResource("/IconsPackage/PlayRewind24.png"));
    public static ImageIcon ICON_PLAYSTART_24 = new ImageIcon(PlayControlPanel.class.getResource("/IconsPackage/PlayStart24.png"));
    public static ImageIcon ICON_PLAYPAUSE_24 = new ImageIcon(PlayControlPanel.class.getResource("/IconsPackage/PlayPause24.png"));
    public static ImageIcon ICON_PLAYSTOP_24 = new ImageIcon(PlayControlPanel.class.getResource("/IconsPackage/PlayStop24.png"));
    public static ImageIcon ICON_PLAYFASTFORWARD_24 = new ImageIcon(PlayControlPanel.class.getResource("/IconsPackage/PlayFastForward24.png"));
    public static ImageIcon ICON_PLAYFADEINPAUSE_24 = new ImageIcon(PlayControlPanel.class.getResource("/IconsPackage/PlayFadeInPause24.png"));
    public static ImageIcon ICON_PLAYFADEOUT_24 = new ImageIcon(PlayControlPanel.class.getResource("/IconsPackage/PlayFadeOut24.png"));
    public static ImageIcon ICON_PLAYFADEOUTDIRECT_24 = new ImageIcon(PlayControlPanel.class.getResource("/IconsPackage/PlayFadeOut24.png"));
    public static ImageIcon ICON_PLAYSTARTFADEOUT_24 = new ImageIcon(PlayControlPanel.class.getResource("/IconsPackage/PlayStartFadeOut24.png"));
    public static final int HORIZONTAL = 0;
    public static final int HORIZONTALBLOCK = 1;
    public static final int VERTICAL = 2;
    public static final int BIGSIZE = 64;
    public static final int SMALLSIZE = 32;
    public static final int CANCELACTION_PIXEL = 32;
    private Play.PlaySynchronisizer m_PlaySynchronisizer;
    private int m_Alignment;
    private int m_Size;
    private Insets m_Insets;
    private boolean m_Enabled;
    @LiveLanguageString
    public static String NAME_PLAYSTART = "start";
    private JLabel m_Button_PlayStart;
    private GridBagConstraints m_ConstraintsButton_PlayStart;
    private boolean m_Visible_Play;
    @LiveLanguageString
    public static String NAME_PLAYPAUSE = "pause";
    private JLabel m_Button_PlayPause;
    private GridBagConstraints m_ConstraintsButton_PlayPause;
    private boolean m_Visible_PlayPause;
    private boolean m_TogglePlayPause;
    @LiveLanguageString
    public static String NAME_PLAYSTOP = "stop";
    private JLabel m_Button_PlayStop;
    private GridBagConstraints m_ConstraintsButton_PlayStop;
    private boolean m_Visible_PlayStop;
    @LiveLanguageString
    public static String NAME_PLAYREWIND = "rewind";
    private JLabel m_Button_PlayRewind;
    private GridBagConstraints m_ConstraintsButton_PlayRewind;
    private boolean m_Visible_PlayRewind;
    @LiveLanguageString
    public static String NAME_PLAYFASTFORWARD = "fast forward";
    private JLabel m_Button_PlayFastForward;
    private GridBagConstraints m_ConstraintsButton_PlayFastForward;
    private boolean m_Visible_PlayFastForward;
    @LiveLanguageString
    public static String NAME_PLAYFADEIN = "Fade In";
    private JLabel m_Button_PlayFadeIn;
    private GridBagConstraints m_ConstraintsButton_PlayFadeIn;
    private boolean m_Visible_FadeIn;
    private boolean m_WillFadeIn;
    @LiveLanguageString
    public static String NAME_PLAYFADEOUT = "Fade Out";
    private JLabel m_Button_PlayFadeOut;
    private GridBagConstraints m_ConstraintsButton_PlayFadeOut;
    private boolean m_Visible_FadeOut;
    private boolean m_WillFadeOut;
    @LiveLanguageString
    public static String NAME_PLAYFADEOUTDIRECT = "Fade Out";
    private JLabel m_Button_PlayFadeOutDirect;
    private GridBagConstraints m_ConstraintsButton_PlayFadeOutDirect;
    private boolean m_Visible_FadeOutDirect;
    private boolean m_WillFadeOutDirect;
    private double m_FadeProgress;
    @LiveLanguageString
    public static String NAME_NEXTSCENE = "next scene";
    private JLabel m_Button_NextScene;
    private GridBagConstraints m_ConstraintsButton_NextScene;
    private boolean m_Visible_NextScene;
    @LiveLanguageString
    public static String NAME_PREVIOUSSCENE = "previuos scene";
    private JLabel m_Button_PreviousScene;
    private GridBagConstraints m_ConstraintsButton_PreviousScene;
    private boolean m_Visible_PreviousScene;
    @LiveLanguageString
    public static String NAME_NEXTMAINSCENE = "next mainscene";
    private JLabel m_Button_NextMainScene;
    private GridBagConstraints m_ConstraintsButton_NextMainScene;
    private boolean m_Visible_NextMainScene;
    @LiveLanguageString
    public static String NAME_PREVIOUSMAINSCENE = "previuos mainscene";
    private JLabel m_Button_PreviousMainScene;
    private GridBagConstraints m_ConstraintsButton_PreviousMainScene;
    private boolean m_Visible_PreviousMainScene;
    private PlayControlPanelStatus m_PlayControlPanelStatus;
    private ArrayList<PlayControlListener> m_PlayControlListeners;
    private final Object m_SyncPlayControlListener = new Object();
    private MouseRemotePlayControl m_MouseRemotePlayControl;
    private GridBagConstraints m_ConstraintsMouseRemoteControl;
    private boolean m_Visible_MouseControl;
    private Runnable m_RunnableRepainr;
    private Runnable m_RunnableRefresh;
    public static final String SPITID_START = "playControlStart";
    public static final String SPITID_PAUSE = "playControlPause";
    public static final String SPITID_NextScenebridge = "nextSceneBridge";
    public static final String SPITID_NextMainScenebridge = "nextMainSceneBridge";
    public static final String SPITID_PreviousScenebridge = "previuosSceneBridge";
    public static final String SPITID_PreviousMainScenebridge = "previousMainSceneBridge";

    public PlayControlPanel() {
        this(null, 0, true, true, false, false, false, false, false, false, true, false);
    }

    public PlayControlPanel(Play.PlaySynchronisizer p_PlaySynchronisizer, int p_Alignment, boolean p_VisiblePlay, boolean p_VisiblePause, boolean p_TogglePlayPause, boolean p_VisibleStop, boolean p_VisibleRewind, boolean p_VisibleFastForward, boolean p_VisibleFadeControls, boolean p_Visible_FadeOutDirect, boolean p_VisibleSceneControls, boolean p_VisibleMouseRemoteControl) {
        this.initMembers();
        this.m_PlayControlPanelStatus = new PlayControlPanelStatus();
        this.m_Alignment = p_Alignment;
        this.m_Visible_Play = p_VisiblePlay;
        this.m_Visible_PlayPause = p_VisiblePause;
        this.m_TogglePlayPause = p_TogglePlayPause;
        this.m_PlayControlPanelStatus.setStartVisible(true);
        this.m_PlayControlPanelStatus.setPauseVisible(true);
        this.m_Visible_PlayStop = p_VisibleStop;
        this.m_PlayControlPanelStatus.setStopVisible(p_VisibleStop);
        this.m_Visible_PlayRewind = p_VisibleRewind;
        this.m_PlayControlPanelStatus.setRewindVisible(p_VisibleRewind);
        this.m_Visible_PlayFastForward = p_VisibleFastForward;
        this.m_PlayControlPanelStatus.setFastForwardVisible(p_VisibleFastForward);
        this.m_Visible_FadeIn = p_VisibleFadeControls;
        this.m_PlayControlPanelStatus.setFadeInVisible(p_VisibleFadeControls);
        this.m_Visible_FadeOut = p_VisibleFadeControls;
        this.m_PlayControlPanelStatus.setFadeOutVisible(p_VisibleFadeControls);
        this.m_Visible_FadeOutDirect = p_Visible_FadeOutDirect;
        this.m_PlayControlPanelStatus.setFadeOutDirectVisible(p_Visible_FadeOutDirect);
        this.m_Visible_NextScene = p_VisibleSceneControls;
        this.m_Visible_PreviousScene = p_VisibleSceneControls;
        this.m_Visible_NextMainScene = p_VisibleSceneControls;
        this.m_Visible_PreviousMainScene = p_VisibleSceneControls;
        this.m_Visible_MouseControl = p_VisibleMouseRemoteControl;
        this.initComponents();
        this.m_PlaySynchronisizer = p_PlaySynchronisizer;
        LiveLanguage.addLanguageListener(this, null);
    }

    private void initMembers() {
        this.m_Enabled = true;
        this.m_Visible_Play = true;
        this.m_Visible_PlayPause = true;
        this.m_RunnableRepainr = new Runnable(){

            @Override
            public void run() {
                PlayControlPanel.this.revalidate();
                PlayControlPanel.this.repaint();
            }
        };
        this.m_RunnableRefresh = new Runnable(){

            @Override
            public void run() {
                PlayControlPanel.this.refreshButtons();
            }
        };
        this.m_PlayControlListeners = new ArrayList();
        this.m_Size = 32;
    }

    private void initComponents() {
        MouseAdapter o_MouseAdapter;
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.m_Insets = new Insets(2, 2, 2, 2);
        if (this.m_Visible_PlayRewind) {
            this.m_Button_PlayRewind = new JLabel();
            this.m_Button_PlayRewind.setIcon(ICON_PLAYREWIND_32);
            this.m_Button_PlayRewind.setBorder(null);
            this.m_Button_PlayRewind.setSize(this.m_Size + 2, this.m_Size + 2);
            this.m_Button_PlayRewind.setOpaque(false);
            this.m_Button_PlayRewind.setVisible(true);
            this.m_Button_PlayRewind.setCursor(Cursor.getPredefinedCursor(12));
            o_MouseAdapter = new MouseAdapter(){
                private int m_LastX = 0;
                private int m_LastY = 0;
                private boolean m_DoAction;

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getButton() != 1) {
                        return;
                    }
                    this.m_LastX = e.getX();
                    this.m_LastY = e.getY();
                    this.m_DoAction = true;
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (Math.abs(this.m_LastX - e.getX()) >= 32) {
                        this.m_DoAction = false;
                    }
                    if (Math.abs(this.m_LastY - e.getY()) >= 32) {
                        this.m_DoAction = false;
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.getButton() != 1) {
                        return;
                    }
                    if (!this.m_DoAction) {
                        return;
                    }
                    PlayControlPanel.this.actionPlayRewind();
                }
            };
            this.m_Button_PlayRewind.addMouseListener(o_MouseAdapter);
            this.m_Button_PlayRewind.addMouseMotionListener(o_MouseAdapter);
        }
        this.m_ConstraintsButton_PlayRewind = new GridBagConstraints();
        this.m_Button_PlayStart = new JLabel();
        this.m_Button_PlayStart.setIcon(ICON_PLAYSTART_32);
        this.m_Button_PlayStart.setBorder(null);
        this.m_Button_PlayStart.setSize(this.m_Size + 2, this.m_Size + 2);
        this.m_Button_PlayStart.setOpaque(false);
        this.m_Button_PlayStart.setVisible(true);
        this.m_Button_PlayStart.setCursor(Cursor.getPredefinedCursor(12));
        o_MouseAdapter = new MouseAdapter(){
            private int m_LastX = 0;
            private int m_LastY = 0;
            private boolean m_DoAction;

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() != 1) {
                    return;
                }
                this.m_LastX = e.getX();
                this.m_LastY = e.getY();
                this.m_DoAction = true;
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (Math.abs(this.m_LastX - e.getX()) >= 32) {
                    this.m_DoAction = false;
                }
                if (Math.abs(this.m_LastY - e.getY()) >= 32) {
                    this.m_DoAction = false;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() != 1) {
                    return;
                }
                if (!this.m_DoAction) {
                    return;
                }
                PlayControlPanel.this.actionPlayStart();
            }
        };
        this.m_Button_PlayStart.addMouseListener(o_MouseAdapter);
        this.m_Button_PlayStart.addMouseMotionListener(o_MouseAdapter);
        this.m_ConstraintsButton_PlayStart = new GridBagConstraints();
        this.m_Button_PlayPause = new JLabel();
        this.m_Button_PlayPause.setIcon(ICON_PLAYPAUSE_32);
        this.m_Button_PlayPause.setBorder(null);
        this.m_Button_PlayPause.setSize(this.m_Size + 2, this.m_Size + 2);
        this.m_Button_PlayPause.setOpaque(false);
        this.m_Button_PlayPause.setVisible(true);
        this.m_Button_PlayPause.setCursor(Cursor.getPredefinedCursor(12));
        o_MouseAdapter = new MouseAdapter(){
            private int m_LastX = 0;
            private int m_LastY = 0;
            private boolean m_DoAction;

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() != 1) {
                    return;
                }
                this.m_LastX = e.getX();
                this.m_LastY = e.getY();
                this.m_DoAction = true;
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (Math.abs(this.m_LastX - e.getX()) >= 32) {
                    this.m_DoAction = false;
                }
                if (Math.abs(this.m_LastY - e.getY()) >= 32) {
                    this.m_DoAction = false;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() != 1) {
                    return;
                }
                if (!this.m_DoAction) {
                    return;
                }
                PlayControlPanel.this.actionPlayPause();
            }
        };
        this.m_Button_PlayPause.addMouseListener(o_MouseAdapter);
        this.m_Button_PlayPause.addMouseMotionListener(o_MouseAdapter);
        this.m_ConstraintsButton_PlayPause = new GridBagConstraints();
        if (this.m_Visible_PlayStop) {
            this.m_Button_PlayStop = new JLabel();
            this.m_Button_PlayStop.setIcon(ICON_PLAYSTOP_32);
            this.m_Button_PlayStop.setBorder(null);
            this.m_Button_PlayStop.setSize(this.m_Size + 2, this.m_Size + 2);
            this.m_Button_PlayStop.setOpaque(false);
            this.m_Button_PlayStop.setVisible(true);
            this.m_Button_PlayStop.setCursor(Cursor.getPredefinedCursor(12));
            o_MouseAdapter = new MouseAdapter(){
                private int m_LastX = 0;
                private int m_LastY = 0;
                private boolean m_DoAction;

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getButton() != 1) {
                        return;
                    }
                    this.m_LastX = e.getX();
                    this.m_LastY = e.getY();
                    this.m_DoAction = true;
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (Math.abs(this.m_LastX - e.getX()) >= 32) {
                        this.m_DoAction = false;
                    }
                    if (Math.abs(this.m_LastY - e.getY()) >= 32) {
                        this.m_DoAction = false;
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.getButton() != 1) {
                        return;
                    }
                    if (!this.m_DoAction) {
                        return;
                    }
                    PlayControlPanel.this.actionPlayStop();
                }
            };
            this.m_Button_PlayStop.addMouseListener(o_MouseAdapter);
            this.m_Button_PlayStop.addMouseMotionListener(o_MouseAdapter);
        }
        this.m_ConstraintsButton_PlayStop = new GridBagConstraints();
        if (this.m_Visible_PlayFastForward) {
            this.m_Button_PlayFastForward = new JLabel();
            this.m_Button_PlayFastForward.setIcon(ICON_PLAYFASTFORWARD_32);
            this.m_Button_PlayFastForward.setBorder(null);
            this.m_Button_PlayFastForward.setSize(this.m_Size + 2, this.m_Size + 2);
            this.m_Button_PlayFastForward.setOpaque(false);
            this.m_Button_PlayFastForward.setVisible(true);
            this.m_Button_PlayFastForward.setCursor(Cursor.getPredefinedCursor(12));
            o_MouseAdapter = new MouseAdapter(){
                private int m_LastX = 0;
                private int m_LastY = 0;
                private boolean m_DoAction;

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getButton() != 1) {
                        return;
                    }
                    this.m_LastX = e.getX();
                    this.m_LastY = e.getY();
                    this.m_DoAction = true;
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (Math.abs(this.m_LastX - e.getX()) >= 32) {
                        this.m_DoAction = false;
                    }
                    if (Math.abs(this.m_LastY - e.getY()) >= 32) {
                        this.m_DoAction = false;
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.getButton() != 1) {
                        return;
                    }
                    if (!this.m_DoAction) {
                        return;
                    }
                    PlayControlPanel.this.actionPlayFastForward();
                }
            };
            this.m_Button_PlayFastForward.addMouseListener(o_MouseAdapter);
            this.m_Button_PlayFastForward.addMouseMotionListener(o_MouseAdapter);
            this.m_ConstraintsButton_PlayFastForward = new GridBagConstraints();
        }
        if (this.m_Visible_FadeIn) {
            this.m_Button_PlayFadeIn = new JLabel();
            this.m_Button_PlayFadeIn.setIcon(ICON_PLAYFADEINPAUSE_32);
            this.m_Button_PlayFadeIn.setBorder(null);
            this.m_Button_PlayFadeIn.setSize(this.m_Size + 2, this.m_Size + 2);
            this.m_Button_PlayFadeIn.setOpaque(false);
            this.m_Button_PlayFadeIn.setVisible(true);
            this.m_Button_PlayFadeIn.setCursor(Cursor.getPredefinedCursor(12));
            o_MouseAdapter = new MouseAdapter(){
                private int m_LastY;
                private int m_LastX;
                private boolean m_Dragged = false;
                private boolean m_DoAction;
                private int m_ButtonPressed = 0;

                @Override
                public void mousePressed(MouseEvent e) {
                    this.m_ButtonPressed = e.getButton();
                    if (e.getButton() != 1) {
                        return;
                    }
                    this.m_LastY = e.getY();
                    this.m_LastX = e.getX();
                    this.m_DoAction = true;
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.getButton() != 1) {
                        return;
                    }
                    if (!this.m_Dragged && this.m_DoAction) {
                        PlayControlPanel.this.actionPlayFadeIn();
                    }
                    this.m_Dragged = false;
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    int intYDiff;
                    if (this.m_ButtonPressed != 1) {
                        return;
                    }
                    if (Math.abs(this.m_LastX - e.getX()) > 32) {
                        this.m_DoAction = false;
                    }
                    if ((intYDiff = this.m_LastY - e.getY()) == 0) {
                        return;
                    }
                    if (!this.m_Dragged) {
                        if (Math.abs(intYDiff) < 5) {
                            return;
                        }
                        if (intYDiff < 0) {
                            intYDiff = -1;
                            this.m_LastY = e.getY() + 1;
                        } else {
                            intYDiff = 1;
                            this.m_LastY = e.getY() - 1;
                        }
                    }
                    PlayControlPanel.this.actionPlayFadeIn(!this.m_Dragged, (double)intYDiff / 255.0);
                    this.m_Dragged = true;
                }
            };
            this.m_Button_PlayFadeIn.addMouseListener(o_MouseAdapter);
            this.m_Button_PlayFadeIn.addMouseMotionListener(o_MouseAdapter);
            this.m_ConstraintsButton_PlayFadeIn = new GridBagConstraints();
        }
        if (this.m_Visible_FadeOut) {
            this.m_Button_PlayFadeOut = new JLabel();
            this.m_Button_PlayFadeOut.setIcon(ICON_PLAYFADEOUT_32);
            this.m_Button_PlayFadeOut.setBorder(null);
            this.m_Button_PlayFadeOut.setSize(this.m_Size + 2, this.m_Size + 2);
            this.m_Button_PlayFadeOut.setOpaque(false);
            this.m_Button_PlayFadeOut.setVisible(true);
            this.m_Button_PlayFadeOut.setCursor(Cursor.getPredefinedCursor(12));
            o_MouseAdapter = new MouseAdapter(){
                private int m_LastY;
                private int m_LastX;
                private boolean m_Dragged = false;
                private boolean m_DoAction;
                private int m_ButtonPressed = 0;

                @Override
                public void mousePressed(MouseEvent e) {
                    this.m_ButtonPressed = e.getButton();
                    if (e.getButton() != 1) {
                        return;
                    }
                    this.m_LastY = e.getY();
                    this.m_LastX = e.getX();
                    this.m_DoAction = true;
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.getButton() != 1) {
                        return;
                    }
                    if (!this.m_Dragged && this.m_DoAction) {
                        PlayControlPanel.this.actionPlayFadeOutDirect();
                    }
                    this.m_Dragged = false;
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    int intYDiff;
                    if (this.m_ButtonPressed != 1) {
                        return;
                    }
                    if (Math.abs(this.m_LastX - e.getX()) > 32) {
                        this.m_DoAction = false;
                    }
                    if ((intYDiff = this.m_LastY - e.getY()) == 0) {
                        return;
                    }
                    if (!this.m_Dragged) {
                        if (Math.abs(intYDiff) < 5) {
                            return;
                        }
                        if (intYDiff < 0) {
                            intYDiff = -1;
                            this.m_LastY = e.getY() + 1;
                        } else {
                            intYDiff = 1;
                            this.m_LastY = e.getY() - 1;
                        }
                    }
                    PlayControlPanel.this.actionPlayFadeOut(!this.m_Dragged, (double)intYDiff / 255.0);
                    this.m_Dragged = true;
                }
            };
            this.m_Button_PlayFadeOut.addMouseListener(o_MouseAdapter);
            this.m_Button_PlayFadeOut.addMouseMotionListener(o_MouseAdapter);
            this.m_ConstraintsButton_PlayFadeOut = new GridBagConstraints();
        }
        if (this.m_Visible_FadeOutDirect) {
            this.m_Button_PlayFadeOutDirect = new JLabel();
            this.m_Button_PlayFadeOutDirect.setIcon(ICON_PLAYFADEOUTDIRECT_32);
            this.m_Button_PlayFadeOutDirect.setBorder(null);
            this.m_Button_PlayFadeOutDirect.setSize(this.m_Size + 2, this.m_Size + 2);
            this.m_Button_PlayFadeOutDirect.setOpaque(false);
            this.m_Button_PlayFadeOutDirect.setVisible(true);
            this.m_Button_PlayFadeOutDirect.setCursor(Cursor.getPredefinedCursor(12));
            o_MouseAdapter = new MouseAdapter(){
                private int m_LastY;
                private int m_LastX;
                private boolean m_Dragged = false;
                private boolean m_DoAction;
                private int m_ButtonPressed = 0;

                @Override
                public void mousePressed(MouseEvent e) {
                    this.m_ButtonPressed = e.getButton();
                    if (e.getButton() != 1) {
                        return;
                    }
                    this.m_LastY = e.getY();
                    this.m_LastX = e.getX();
                    this.m_DoAction = true;
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.getButton() != 1) {
                        return;
                    }
                    if (!this.m_Dragged && this.m_DoAction) {
                        PlayControlPanel.this.actionPlayFadeOutDirect();
                    }
                    this.m_Dragged = false;
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (Math.abs(this.m_LastX - e.getX()) >= 32) {
                        this.m_DoAction = false;
                    }
                    if (Math.abs(this.m_LastY - e.getY()) >= 32) {
                        this.m_DoAction = false;
                    }
                }
            };
            this.m_Button_PlayFadeOutDirect.addMouseListener(o_MouseAdapter);
            this.m_Button_PlayFadeOutDirect.addMouseMotionListener(o_MouseAdapter);
            this.m_ConstraintsButton_PlayFadeOutDirect = new GridBagConstraints();
        }
        if (this.m_Visible_NextScene) {
            this.m_Button_NextScene = new JLabel();
            this.m_Button_NextScene.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Play_ScenebridgeNext.png")));
            this.m_Button_NextScene.setMaximumSize(new Dimension(32, 32));
            this.m_Button_NextScene.setMinimumSize(new Dimension(32, 32));
            this.m_Button_NextScene.setPreferredSize(new Dimension(32, 32));
            this.m_Button_NextScene.setCursor(Cursor.getPredefinedCursor(12));
            o_MouseAdapter = new MouseAdapter(){
                private int m_LastX = 0;
                private int m_LastY = 0;
                private boolean m_DoAction;

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getButton() != 1) {
                        return;
                    }
                    this.m_LastX = e.getX();
                    this.m_LastY = e.getY();
                    this.m_DoAction = true;
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (Math.abs(this.m_LastX - e.getX()) >= 32) {
                        this.m_DoAction = false;
                    }
                    if (Math.abs(this.m_LastY - e.getY()) >= 32) {
                        this.m_DoAction = false;
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.getButton() != 1) {
                        return;
                    }
                    if (!this.m_DoAction) {
                        return;
                    }
                    PlayControlPanel.this.actionNextScene();
                }
            };
            this.m_Button_NextScene.addMouseListener(o_MouseAdapter);
            this.m_Button_NextScene.addMouseMotionListener(o_MouseAdapter);
            this.m_ConstraintsButton_NextScene = new GridBagConstraints();
        }
        if (this.m_Visible_PreviousScene) {
            this.m_Button_PreviousScene = new JLabel();
            this.m_Button_PreviousScene.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Play_ScenebridgePrevious.png")));
            this.m_Button_PreviousScene.setMaximumSize(new Dimension(32, 32));
            this.m_Button_PreviousScene.setMinimumSize(new Dimension(32, 32));
            this.m_Button_PreviousScene.setPreferredSize(new Dimension(32, 32));
            this.m_Button_PreviousScene.setOpaque(false);
            this.m_Button_PreviousScene.setCursor(Cursor.getPredefinedCursor(12));
            o_MouseAdapter = new MouseAdapter(){
                private int m_LastX = 0;
                private int m_LastY = 0;
                private boolean m_DoAction;

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getButton() != 1) {
                        return;
                    }
                    this.m_LastX = e.getX();
                    this.m_LastY = e.getY();
                    this.m_DoAction = true;
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (Math.abs(this.m_LastX - e.getX()) >= 32) {
                        this.m_DoAction = false;
                    }
                    if (Math.abs(this.m_LastY - e.getY()) >= 32) {
                        this.m_DoAction = false;
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.getButton() != 1) {
                        return;
                    }
                    if (!this.m_DoAction) {
                        return;
                    }
                    PlayControlPanel.this.actionPreviousScene();
                }
            };
            this.m_Button_PreviousScene.addMouseListener(o_MouseAdapter);
            this.m_Button_PreviousScene.addMouseMotionListener(o_MouseAdapter);
            this.m_ConstraintsButton_PreviousScene = new GridBagConstraints();
        }
        if (this.m_Visible_NextMainScene) {
            this.m_Button_NextMainScene = new JLabel();
            this.m_Button_NextMainScene.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Play_ScenebridgeMainNext.png")));
            this.m_Button_NextMainScene.setMaximumSize(new Dimension(32, 32));
            this.m_Button_NextMainScene.setMinimumSize(new Dimension(32, 32));
            this.m_Button_NextMainScene.setPreferredSize(new Dimension(32, 32));
            this.m_Button_NextMainScene.setCursor(Cursor.getPredefinedCursor(12));
            o_MouseAdapter = new MouseAdapter(){
                private int m_LastX = 0;
                private int m_LastY = 0;
                private boolean m_DoAction;

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getButton() != 1) {
                        return;
                    }
                    this.m_LastX = e.getX();
                    this.m_LastY = e.getY();
                    this.m_DoAction = true;
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (Math.abs(this.m_LastX - e.getX()) >= 32) {
                        this.m_DoAction = false;
                    }
                    if (Math.abs(this.m_LastY - e.getY()) >= 32) {
                        this.m_DoAction = false;
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.getButton() != 1) {
                        return;
                    }
                    if (!this.m_DoAction) {
                        return;
                    }
                    PlayControlPanel.this.actionNextMainScene();
                }
            };
            this.m_Button_NextMainScene.addMouseListener(o_MouseAdapter);
            this.m_Button_NextMainScene.addMouseMotionListener(o_MouseAdapter);
            this.m_ConstraintsButton_NextMainScene = new GridBagConstraints();
        }
        if (this.m_Visible_PreviousMainScene) {
            this.m_Button_PreviousMainScene = new JLabel();
            this.m_Button_PreviousMainScene.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Play_ScenebridgeMainPrevious.png")));
            this.m_Button_PreviousMainScene.setMaximumSize(new Dimension(32, 32));
            this.m_Button_PreviousMainScene.setMinimumSize(new Dimension(32, 32));
            this.m_Button_PreviousMainScene.setPreferredSize(new Dimension(32, 32));
            this.m_Button_PreviousMainScene.setCursor(Cursor.getPredefinedCursor(12));
            o_MouseAdapter = new MouseAdapter(){
                private int m_LastX = 0;
                private int m_LastY = 0;
                private boolean m_DoAction;

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getButton() != 1) {
                        return;
                    }
                    this.m_LastX = e.getX();
                    this.m_LastY = e.getY();
                    this.m_DoAction = true;
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (Math.abs(this.m_LastX - e.getX()) >= 32) {
                        this.m_DoAction = false;
                    }
                    if (Math.abs(this.m_LastY - e.getY()) >= 32) {
                        this.m_DoAction = false;
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.getButton() != 1) {
                        return;
                    }
                    if (!this.m_DoAction) {
                        return;
                    }
                    PlayControlPanel.this.actionPreviousMainScene();
                }
            };
            this.m_Button_PreviousMainScene.addMouseListener(o_MouseAdapter);
            this.m_Button_PreviousMainScene.addMouseMotionListener(o_MouseAdapter);
            this.m_ConstraintsButton_PreviousMainScene = new GridBagConstraints();
        }
        if (this.m_Visible_MouseControl) {
            this.m_MouseRemotePlayControl = new MouseRemotePlayControl(this);
            this.m_ConstraintsMouseRemoteControl = new GridBagConstraints();
        }
        if (this.m_Visible_PlayRewind) {
            this.m_Button_PlayRewind.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        }
        this.m_Button_PlayStart.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.m_Button_PlayPause.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        if (this.m_Visible_FadeIn) {
            this.m_Button_PlayFadeIn.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        }
        if (this.m_Visible_FadeOut) {
            this.m_Button_PlayFadeOut.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        }
        if (this.m_Visible_FadeOutDirect) {
            this.m_Button_PlayFadeOutDirect.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        }
        if (this.m_Visible_PlayStop) {
            this.m_Button_PlayStop.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        }
        if (this.m_Visible_PlayFastForward) {
            this.m_Button_PlayFastForward.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        }
        if (this.m_Visible_NextScene) {
            this.m_Button_NextScene.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        }
        if (this.m_Visible_PreviousScene) {
            this.m_Button_PreviousScene.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        }
        if (this.m_Visible_NextMainScene) {
            this.m_Button_NextMainScene.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        }
        if (this.m_Visible_PreviousMainScene) {
            this.m_Button_PreviousMainScene.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        }
        this.setAlignment(this.m_Alignment);
        if (this.m_Visible_PlayRewind) {
            this.add((Component)this.m_Button_PlayRewind, this.m_ConstraintsButton_PlayRewind);
        }
        this.add((Component)this.m_Button_PlayStart, this.m_ConstraintsButton_PlayStart);
        this.add((Component)this.m_Button_PlayPause, this.m_ConstraintsButton_PlayPause);
        if (this.m_Visible_FadeIn) {
            this.add((Component)this.m_Button_PlayFadeIn, this.m_ConstraintsButton_PlayFadeIn);
        }
        if (this.m_Visible_FadeOut) {
            this.add((Component)this.m_Button_PlayFadeOut, this.m_ConstraintsButton_PlayFadeOut);
        }
        if (this.m_Visible_FadeOutDirect) {
            this.add((Component)this.m_Button_PlayFadeOutDirect, this.m_ConstraintsButton_PlayFadeOutDirect);
        }
        if (this.m_Visible_PlayStop) {
            this.add((Component)this.m_Button_PlayStop, this.m_ConstraintsButton_PlayStop);
        }
        if (this.m_Visible_PlayFastForward) {
            this.add((Component)this.m_Button_PlayFastForward, this.m_ConstraintsButton_PlayFastForward);
        }
        if (this.m_Visible_NextScene) {
            this.add((Component)this.m_Button_NextScene, this.m_ConstraintsButton_NextScene);
        }
        if (this.m_Visible_PreviousScene) {
            this.add((Component)this.m_Button_PreviousScene, this.m_ConstraintsButton_PreviousScene);
        }
        if (this.m_Visible_NextMainScene) {
            this.add((Component)this.m_Button_NextMainScene, this.m_ConstraintsButton_NextMainScene);
        }
        if (this.m_Visible_PreviousMainScene) {
            this.add((Component)this.m_Button_PreviousMainScene, this.m_ConstraintsButton_PreviousMainScene);
        }
        if (this.m_Visible_MouseControl) {
            this.add((Component)this.m_MouseRemotePlayControl, this.m_ConstraintsMouseRemoteControl);
        }
        this.revalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LiveLanguage.removeLanguageListener(this);
        Object object = this.m_SyncPlayControlListener;
        synchronized (object) {
            this.m_PlayControlListeners.clear();
        }
        if (this.m_PlaySynchronisizer != null) {
            // empty if block
        }
        this.m_Button_PlayStart.setComponentPopupMenu(null);
        this.m_Button_PlayPause.setComponentPopupMenu(null);
        if (this.m_Button_PlayFadeIn != null) {
            this.m_Button_PlayFadeIn.setComponentPopupMenu(null);
        }
        if (this.m_Button_PlayFadeOut != null) {
            this.m_Button_PlayFadeOut.setComponentPopupMenu(null);
        }
        if (this.m_Button_PlayFadeOutDirect != null) {
            this.m_Button_PlayFadeOutDirect.setComponentPopupMenu(null);
        }
        if (this.m_Button_PlayStop != null) {
            this.m_Button_PlayStop.setComponentPopupMenu(null);
        }
        if (this.m_Button_PlayFastForward != null) {
            this.m_Button_PlayFastForward.setComponentPopupMenu(null);
        }
        if (this.m_Button_NextScene != null) {
            this.m_Button_NextScene.setComponentPopupMenu(null);
        }
        if (this.m_Button_PreviousScene != null) {
            this.m_Button_PreviousScene.setComponentPopupMenu(null);
        }
        if (this.m_Button_NextMainScene != null) {
            this.m_Button_NextMainScene.setComponentPopupMenu(null);
        }
        if (this.m_Button_PreviousMainScene != null) {
            this.m_Button_PreviousMainScene.setComponentPopupMenu(null);
        }
        LiveLanguage.removeLanguageListener(this);
    }

    public void createRemoteMouseActions() {
        PlayRemoteActions.RemoteActionListener o_RemoteActionListener;
        ImageIcon o_ImageIcon;
        String stringActionGroup = "";
        String stringActionID = "actionPlayPause";
        String stringSourceID = "sourceIDTimelinePlayStop";
        String stringSourceName = PlayRemoteActions.SOURCENAME_TIMELINE;
        PlayRemoteActions.RemoteAction o_RemoteMouseAction = PlayRemoteActions.getRemoteAction(stringSourceID, stringActionID);
        if (o_RemoteMouseAction == null) {
            o_ImageIcon = new ImageIcon(this.getClass().getResource("/IconsPackage/PlayStart32.png"));
            o_RemoteActionListener = new PlayRemoteActions.RemoteActionListener(){

                @Override
                public void doAction(PlayRemoteActions.RemoteAction p_RemoteMouseAction, double p_Value) {
                    Play.PlaySynchronisizer o_PlaySynchronisizer = PlayControlPanel.this.getPlaySynchronisizer();
                    if (o_PlaySynchronisizer == null) {
                        return;
                    }
                    if (o_PlaySynchronisizer.isAllPlaying()) {
                        PlayControlPanel.this.actionPlayPause();
                        return;
                    }
                    PlayControlPanel.this.actionPlayStart();
                }
            };
            o_RemoteMouseAction = PlayRemoteActions.createRemoteAction(o_RemoteActionListener, o_ImageIcon, stringActionGroup, stringActionID, stringSourceID, stringSourceName, 0L);
        }
        stringActionGroup = "";
        stringActionID = "actionPlay";
        stringSourceID = "sourceIDTimelineNextScene";
        stringSourceName = NAME_NEXTSCENE;
        o_RemoteMouseAction = PlayRemoteActions.getRemoteAction(stringSourceID, stringActionID);
        if (o_RemoteMouseAction == null) {
            o_ImageIcon = new ImageIcon(this.getClass().getResource("/IconsPackage/Play_ScenebridgeNext.png"));
            o_RemoteActionListener = new PlayRemoteActions.RemoteActionListener(){

                @Override
                public void doAction(PlayRemoteActions.RemoteAction p_RemoteMouseAction, double p_Value) {
                    PlayControlPanel.this.actionNextScene();
                }
            };
            o_RemoteMouseAction = PlayRemoteActions.createRemoteAction(o_RemoteActionListener, o_ImageIcon, stringActionGroup, stringActionID, stringSourceID, stringSourceName, 0L);
        }
        stringActionGroup = "";
        stringActionID = "actionPlay";
        stringSourceID = "sourceIDTimelineNextMainScene";
        stringSourceName = NAME_NEXTMAINSCENE;
        o_RemoteMouseAction = PlayRemoteActions.getRemoteAction(stringSourceID, stringActionID);
        if (o_RemoteMouseAction == null) {
            o_ImageIcon = new ImageIcon(this.getClass().getResource("/IconsPackage/Play_ScenebridgeMainNext.png"));
            o_RemoteActionListener = new PlayRemoteActions.RemoteActionListener(){

                @Override
                public void doAction(PlayRemoteActions.RemoteAction p_RemoteMouseAction, double p_Value) {
                    PlayControlPanel.this.actionNextMainScene();
                }
            };
            o_RemoteMouseAction = PlayRemoteActions.createRemoteAction(o_RemoteActionListener, o_ImageIcon, stringActionGroup, stringActionID, stringSourceID, stringSourceName, 0L);
        }
        stringActionGroup = "";
        stringActionID = "actionPlay";
        stringSourceID = "sourceIDTimelinePreviousScene";
        stringSourceName = NAME_PREVIOUSSCENE;
        o_RemoteMouseAction = PlayRemoteActions.getRemoteAction(stringSourceID, stringActionID);
        if (o_RemoteMouseAction == null) {
            o_ImageIcon = new ImageIcon(this.getClass().getResource("/IconsPackage/Play_ScenebridgePrevious.png"));
            o_RemoteActionListener = new PlayRemoteActions.RemoteActionListener(){

                @Override
                public void doAction(PlayRemoteActions.RemoteAction p_RemoteMouseAction, double p_Value) {
                    PlayControlPanel.this.actionPreviousScene();
                }
            };
            o_RemoteMouseAction = PlayRemoteActions.createRemoteAction(o_RemoteActionListener, o_ImageIcon, stringActionGroup, stringActionID, stringSourceID, stringSourceName, 0L);
        }
        stringActionGroup = "";
        stringActionID = "actionPlay";
        stringSourceID = "sourceIDTimelinePreviousMainScene";
        stringSourceName = NAME_PREVIOUSMAINSCENE;
        o_RemoteMouseAction = PlayRemoteActions.getRemoteAction(stringSourceID, stringActionID);
        if (o_RemoteMouseAction == null) {
            o_ImageIcon = new ImageIcon(this.getClass().getResource("/IconsPackage/Play_ScenebridgeMainPrevious.png"));
            o_RemoteActionListener = new PlayRemoteActions.RemoteActionListener(){

                @Override
                public void doAction(PlayRemoteActions.RemoteAction p_RemoteMouseAction, double p_Value) {
                    PlayControlPanel.this.actionPreviousMainScene();
                }
            };
            o_RemoteMouseAction = PlayRemoteActions.createRemoteAction(o_RemoteActionListener, o_ImageIcon, stringActionGroup, stringActionID, stringSourceID, stringSourceName, 0L);
        }
    }

    public void moveMouseToMouseControl() {
        if (!this.m_Visible_MouseControl) {
            return;
        }
        EventQueueHandler.invokeLater(new Runnable(){

            @Override
            public void run() {
                GraphicsDevice[] gs;
                Rectangle o_MouseControlBounds = PlayControlPanel.this.m_MouseRemotePlayControl.getBounds();
                Point o_Point = PlayControlPanel.this.m_MouseRemotePlayControl.getLocationOnScreen();
                o_Point.setLocation(o_Point.x + o_MouseControlBounds.width / 2, o_Point.y + o_MouseControlBounds.height / 2);
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                for (GraphicsDevice device : gs = ge.getScreenDevices()) {
                    GraphicsConfiguration[] configurations;
                    for (GraphicsConfiguration config : configurations = device.getConfigurations()) {
                        Rectangle bounds = config.getBounds();
                        if (!bounds.contains(o_Point)) continue;
                        Point b = bounds.getLocation();
                        Point s = new Point(o_Point.x - b.x, o_Point.y - b.y);
                        try {
                            Robot r = new Robot(device);
                            r.mouseMove(s.x, s.y);
                        }
                        catch (AWTException e) {
                            e.printStackTrace();
                        }
                        return;
                    }
                }
            }
        });
    }

    public void setPlaySynchronisizer(Play.PlaySynchronisizer p_PlaySynchronisizer) {
        if (this.m_PlaySynchronisizer != null) {
            // empty if block
        }
        this.m_PlaySynchronisizer = p_PlaySynchronisizer;
    }

    public Play.PlaySynchronisizer getPlaySynchronisizer() {
        return this.m_PlaySynchronisizer;
    }

    public void addPlay(Play p_Play) {
        if (p_Play == null) {
            return;
        }
        p_Play.addPlayListener(this);
        this.refreshButtons();
    }

    public void removePlay(Play p_Play) {
        if (p_Play == null) {
            return;
        }
        p_Play.removePlayListener(this);
        this.refreshButtons();
    }

    public boolean containsPlay(Play p_Play) {
        if (this.m_PlaySynchronisizer == null) {
            return false;
        }
        return this.m_PlaySynchronisizer.containsPlay(p_Play);
    }

    public void actionPlayStart() {
        if (this.m_PlaySynchronisizer == null) {
            return;
        }
        this.m_PlaySynchronisizer.actionPlayStart();
    }

    public void actionPlayPause() {
        if (this.m_PlaySynchronisizer == null) {
            return;
        }
        this.m_PlaySynchronisizer.actionPlayPause();
    }

    public double getFadeProgress() {
        if (this.m_PlaySynchronisizer.getPlayCount() > 1) {
            return 0.0;
        }
        Play o_Play = this.m_PlaySynchronisizer.getPlay(0);
        if (o_Play == null) {
            return 0.0;
        }
        Playable.PlayObject o_PlayObject = o_Play.getPlayObject();
        if (o_PlayObject == null) {
            return 0.0;
        }
        return o_PlayObject.getFadeProgress();
    }

    public void actionFade(double p_ValuePercent) {
        if (p_ValuePercent < 0.0) {
            p_ValuePercent = 0.0;
        }
        if (p_ValuePercent > 1.0) {
            p_ValuePercent = 1.0;
        }
        if (this.m_PlaySynchronisizer.getPlayCount() > 1) {
            return;
        }
        Play o_Play = this.m_PlaySynchronisizer.getPlay(0);
        if (o_Play == null) {
            return;
        }
        Playable o_Playable = o_Play.getPlayable();
        if (o_Playable == null) {
            return;
        }
        Playable.PlayObject o_PlayObject = o_Play.getPlayObject();
        if (o_PlayObject == null) {
            return;
        }
        o_Play.fadeIn(p_ValuePercent);
    }

    public void actionPlayFadeIn(boolean p_DragStarted, double p_FadeDiff) {
        if (this.m_PlaySynchronisizer.getPlayCount() > 1) {
            return;
        }
        Play o_Play = this.m_PlaySynchronisizer.getPlay(0);
        if (o_Play == null) {
            return;
        }
        Playable o_Playable = o_Play.getPlayable();
        if (o_Playable == null) {
            return;
        }
        Playable.PlayObject o_PlayObject = o_Play.getPlayObject();
        if (o_PlayObject == null) {
            return;
        }
        if (p_DragStarted) {
            this.m_FadeProgress = o_PlayObject.getFadeProgress();
        }
        double doubleFadeProgress = this.m_FadeProgress + p_FadeDiff;
        if (p_FadeDiff <= 0.0 && o_PlayObject.getFramePosition() <= o_Play.getFramePositionStart()) {
            doubleFadeProgress = 0.0;
        }
        o_Play.fadeIn(doubleFadeProgress);
    }

    public void actionPlayFadeOut(boolean p_DragStarted, double p_FadeDiff) {
        if (this.m_PlaySynchronisizer.getPlayCount() > 1) {
            return;
        }
        Play o_Play = this.m_PlaySynchronisizer.getPlay(0);
        if (o_Play == null) {
            return;
        }
        Playable o_Playable = o_Play.getPlayable();
        if (o_Playable == null) {
            return;
        }
        Playable.PlayObject o_PlayObject = o_Play.getPlayObject();
        if (o_PlayObject == null) {
            return;
        }
        if (p_DragStarted) {
            this.m_FadeProgress = o_PlayObject.getFadeProgress();
        }
        double doubleFadeProgress = this.m_FadeProgress + p_FadeDiff;
        if (p_FadeDiff <= 0.0 && o_Play.getFramePositionStart() > 0L && o_PlayObject.getFramePosition() <= o_Play.getFramePositionStart()) {
            doubleFadeProgress = 0.0;
        }
        o_Play.fadeOut(doubleFadeProgress);
    }

    public void actionPlayFadeIn() {
        if (this.m_PlaySynchronisizer == null) {
            return;
        }
        if (this.m_PlaySynchronisizer.getPlayStartedCount() > 0) {
            this.m_WillFadeIn = true;
            this.m_PlaySynchronisizer.actionPlayPause();
        } else {
            this.m_PlaySynchronisizer.actionPlayFadeIn();
        }
    }

    public void actionPlayFadeOut() {
        if (this.m_PlaySynchronisizer == null) {
            return;
        }
        if (this.m_PlaySynchronisizer.getPlayStartedCount() > 0) {
            this.m_WillFadeOut = true;
            this.m_PlaySynchronisizer.actionPlayPause();
        } else {
            this.m_PlaySynchronisizer.actionPlayFadeOut();
        }
    }

    public void actionPlayFadeOutDirect() {
        if (this.m_PlaySynchronisizer == null) {
            return;
        }
        if (this.m_PlaySynchronisizer.getPlayStartedCount() > 0 || this.m_PlaySynchronisizer.getPlayWaitingCount() > 0) {
            this.m_PlaySynchronisizer.actionPlayFadeOutDirect();
        }
    }

    public void actionPlayFadeInOut() {
        if (this.m_PlaySynchronisizer == null) {
            return;
        }
        if (this.m_PlaySynchronisizer.getPlayStartedCount() > 0 || this.m_PlaySynchronisizer.getPlayWaitingCount() > 0) {
            this.actionPlayFadeOut();
        } else {
            this.actionPlayFadeIn();
        }
    }

    public void actionPlayStop() {
        if (this.m_PlaySynchronisizer == null) {
            return;
        }
        this.m_PlaySynchronisizer.actionPlayStop();
    }

    public void actionPlayStartStop() {
        if (this.m_PlaySynchronisizer == null) {
            return;
        }
        this.m_PlaySynchronisizer.actionPlayStartStop();
    }

    public void actionPlayStartPause() {
        if (this.m_PlaySynchronisizer == null) {
            return;
        }
        if (this.m_PlaySynchronisizer.isAllPlaying()) {
            this.actionPlayPause();
            return;
        }
        this.actionPlayStart();
    }

    public void actionPlayStartFadeOut() {
        if (this.m_PlaySynchronisizer == null) {
            return;
        }
        this.m_PlaySynchronisizer.actionPlayStartFadeOut();
    }

    public void actionPlayRewind() {
        if (this.m_PlaySynchronisizer == null) {
            return;
        }
        this.m_PlaySynchronisizer.actionPlayRewind();
    }

    public void actionPlayFastForward() {
        if (this.m_PlaySynchronisizer == null) {
            return;
        }
        this.m_PlaySynchronisizer.actionPlayFastForward();
    }

    public void actionNextScene() {
        this.gotoNextScene(false);
    }

    public void actionNextMainScene() {
        this.gotoNextScene(true);
    }

    public void gotoNextScene(boolean p_OnlyMainScenes) {
        LiveShowSceneBridge o_LiveShowSceneBridge;
        ArrayList<LiveShowSceneBridge> o_NextSceneBridges = new ArrayList<LiveShowSceneBridge>();
        ArrayList<Play> o_Plays = new ArrayList<Play>();
        if (this.m_PlaySynchronisizer == null) {
            return;
        }
        this.m_PlaySynchronisizer.clearPlaysTriggerSceneBridge();
        LiveShowSceneBridge o_NextSceneBridge = null;
        boolean boolFriends = false;
        for (int intPlay = 0; intPlay < this.m_PlaySynchronisizer.getPlayCount(); ++intPlay) {
            Play o_Play = this.m_PlaySynchronisizer.getPlay(intPlay);
            if (o_Play == null || !o_Play.getActive() || (o_LiveShowSceneBridge = o_Play.getNextScene_ToPlay(p_OnlyMainScenes)) == null) continue;
            if (o_NextSceneBridges.size() <= 0) {
                o_NextSceneBridges.add(o_LiveShowSceneBridge);
                o_Plays.add(o_Play);
                continue;
            }
            o_NextSceneBridge = (LiveShowSceneBridge)o_NextSceneBridges.get(0);
            if (o_LiveShowSceneBridge.getFrameStart() < o_NextSceneBridge.getFrameStart()) {
                o_NextSceneBridges.clear();
                o_Plays.clear();
                o_NextSceneBridges.add(o_LiveShowSceneBridge);
                o_Plays.add(o_Play);
                continue;
            }
            if (o_LiveShowSceneBridge.getFrameStart() != o_NextSceneBridge.getFrameStart()) continue;
            if (o_NextSceneBridge.getIsMainBridge() && o_LiveShowSceneBridge.getIsMainBridge()) {
                o_NextSceneBridges.clear();
                o_Plays.clear();
                boolFriends = true;
            }
            o_NextSceneBridges.add(o_LiveShowSceneBridge);
            o_Plays.add(o_Play);
        }
        for (int intBridge = 0; intBridge < o_NextSceneBridges.size(); ++intBridge) {
            LiveShowVIP o_LiveShowVIP;
            o_LiveShowSceneBridge = (LiveShowSceneBridge)o_NextSceneBridges.get(intBridge);
            if (o_LiveShowSceneBridge == null || (o_LiveShowVIP = o_LiveShowSceneBridge.getLiveShowVIP()) == null) continue;
            o_LiveShowVIP.gotoSceneBridge(o_LiveShowSceneBridge, boolFriends, false);
        }
        this.m_PlaySynchronisizer.actionStartPlaysSceneBridge();
    }

    public void actionPreviousScene() {
        this.gotoPreviousScene(false);
    }

    public void actionPreviousMainScene() {
        this.gotoPreviousScene(true);
    }

    public void gotoPreviousScene(boolean p_OnlyMainScenes) {
        LiveShowSceneBridge o_LiveShowSceneBridge;
        ArrayList<LiveShowSceneBridge> o_PreviousSceneBridges = new ArrayList<LiveShowSceneBridge>();
        ArrayList<Play> o_Plays = new ArrayList<Play>();
        if (this.m_PlaySynchronisizer == null) {
            return;
        }
        this.m_PlaySynchronisizer.clearPlaysTriggerSceneBridge();
        LiveShowSceneBridge o_PreviousSceneBridge = null;
        boolean boolFriends = false;
        for (int intPlay = 0; intPlay < this.m_PlaySynchronisizer.getPlayCount(); ++intPlay) {
            Play o_Play = this.m_PlaySynchronisizer.getPlay(intPlay);
            if (o_Play == null || !o_Play.getActive() || (o_LiveShowSceneBridge = o_Play.getPreviousScene_ToPlay(p_OnlyMainScenes)) == null) continue;
            if (o_PreviousSceneBridges.size() <= 0) {
                o_PreviousSceneBridges.add(o_LiveShowSceneBridge);
                o_Plays.add(o_Play);
                continue;
            }
            o_PreviousSceneBridge = (LiveShowSceneBridge)o_PreviousSceneBridges.get(0);
            if (o_LiveShowSceneBridge.getFrameStart() > o_PreviousSceneBridge.getFrameStart()) {
                o_PreviousSceneBridges.clear();
                o_Plays.clear();
                o_PreviousSceneBridges.add(o_LiveShowSceneBridge);
                o_Plays.add(o_Play);
                continue;
            }
            if (o_LiveShowSceneBridge.getFrameStart() != o_PreviousSceneBridge.getFrameStart()) continue;
            if (o_PreviousSceneBridge.getIsMainBridge() && o_LiveShowSceneBridge.getIsMainBridge()) {
                o_PreviousSceneBridges.clear();
                o_Plays.clear();
                boolFriends = true;
            }
            o_PreviousSceneBridges.add(o_LiveShowSceneBridge);
            o_Plays.add(o_Play);
        }
        for (int intBridge = 0; intBridge < o_PreviousSceneBridges.size(); ++intBridge) {
            LiveShowVIP o_LiveShowVIP;
            o_LiveShowSceneBridge = (LiveShowSceneBridge)o_PreviousSceneBridges.get(intBridge);
            if (o_LiveShowSceneBridge == null || (o_LiveShowVIP = o_LiveShowSceneBridge.getLiveShowVIP()) == null) continue;
            o_LiveShowVIP.gotoSceneBridge(o_LiveShowSceneBridge, boolFriends, false);
        }
        this.m_PlaySynchronisizer.actionStartPlaysSceneBridge();
    }

    private void setAlignment(int p_Alignment) {
        int intButtonPosition = 0;
        int intHeight = 34 + this.m_Insets.bottom + this.m_Insets.top;
        this.m_Alignment = p_Alignment;
        if (p_Alignment == 0) {
            if (this.m_Visible_PreviousMainScene) {
                this.m_ConstraintsButton_PreviousMainScene.gridx = intButtonPosition++;
                this.m_ConstraintsButton_PreviousMainScene.gridy = 0;
                this.m_ConstraintsButton_PreviousMainScene.gridwidth = 1;
                this.m_ConstraintsButton_PreviousMainScene.weightx = 1.0;
                this.m_ConstraintsButton_PreviousMainScene.insets = this.m_Insets;
            }
            if (this.m_Visible_PreviousScene) {
                this.m_ConstraintsButton_PreviousScene.gridx = intButtonPosition++;
                this.m_ConstraintsButton_PreviousScene.gridy = 0;
                this.m_ConstraintsButton_PreviousScene.gridwidth = 1;
                this.m_ConstraintsButton_PreviousScene.weightx = 1.0;
                this.m_ConstraintsButton_PreviousScene.insets = this.m_Insets;
            }
            if (this.m_Visible_PlayRewind) {
                this.m_ConstraintsButton_PlayRewind.gridx = intButtonPosition++;
                this.m_ConstraintsButton_PlayRewind.gridy = 0;
                this.m_ConstraintsButton_PlayRewind.weightx = 1.0;
                this.m_ConstraintsButton_PlayRewind.insets = this.m_Insets;
            }
            if (this.m_Visible_Play) {
                this.m_ConstraintsButton_PlayStart.gridx = intButtonPosition++;
                this.m_ConstraintsButton_PlayStart.gridy = 0;
                this.m_ConstraintsButton_PlayStart.weightx = 1.0;
                this.m_ConstraintsButton_PlayStart.insets = this.m_Insets;
                if (this.m_TogglePlayPause || this.m_Visible_PlayPause) {
                    // empty if block
                }
            }
            if (this.m_Visible_PlayPause) {
                this.m_ConstraintsButton_PlayPause.gridx = intButtonPosition++;
                this.m_ConstraintsButton_PlayPause.gridy = 0;
                this.m_ConstraintsButton_PlayPause.weightx = 1.0;
                this.m_ConstraintsButton_PlayPause.insets = this.m_Insets;
            }
            if (this.m_Visible_FadeIn) {
                this.m_ConstraintsButton_PlayFadeIn.gridx = intButtonPosition++;
                this.m_ConstraintsButton_PlayFadeIn.gridy = 0;
                this.m_ConstraintsButton_PlayFadeIn.weightx = 1.0;
                this.m_ConstraintsButton_PlayFadeIn.insets = this.m_Insets;
            }
            if (this.m_Visible_FadeOut) {
                this.m_ConstraintsButton_PlayFadeOut.gridx = intButtonPosition++;
                this.m_ConstraintsButton_PlayFadeOut.gridy = 0;
                this.m_ConstraintsButton_PlayFadeOut.weightx = 1.0;
                this.m_ConstraintsButton_PlayFadeOut.insets = this.m_Insets;
            }
            if (this.m_Visible_FadeOutDirect) {
                this.m_ConstraintsButton_PlayFadeOutDirect.gridx = intButtonPosition++;
                this.m_ConstraintsButton_PlayFadeOutDirect.gridy = 0;
                this.m_ConstraintsButton_PlayFadeOutDirect.weightx = 1.0;
                this.m_ConstraintsButton_PlayFadeOutDirect.insets = this.m_Insets;
            }
            if (this.m_Visible_PlayStop) {
                this.m_ConstraintsButton_PlayStop.gridx = intButtonPosition++;
                this.m_ConstraintsButton_PlayStop.gridy = 0;
                this.m_ConstraintsButton_PlayStop.weightx = 1.0;
                this.m_ConstraintsButton_PlayStop.insets = this.m_Insets;
            }
            if (this.m_Visible_PlayFastForward) {
                this.m_ConstraintsButton_PlayFastForward.gridx = intButtonPosition++;
                this.m_ConstraintsButton_PlayFastForward.gridy = 0;
                this.m_ConstraintsButton_PlayFastForward.weightx = 1.0;
                this.m_ConstraintsButton_PlayFastForward.insets = this.m_Insets;
            }
            if (this.m_Visible_NextScene) {
                this.m_ConstraintsButton_NextScene.gridx = intButtonPosition++;
                this.m_ConstraintsButton_NextScene.gridy = 0;
                this.m_ConstraintsButton_NextScene.gridwidth = 1;
                this.m_ConstraintsButton_NextScene.weightx = 1.0;
                this.m_ConstraintsButton_NextScene.insets = this.m_Insets;
            }
            if (this.m_Visible_NextMainScene) {
                this.m_ConstraintsButton_NextMainScene.gridx = intButtonPosition++;
                this.m_ConstraintsButton_NextMainScene.gridy = 0;
                this.m_ConstraintsButton_NextMainScene.gridwidth = 1;
                this.m_ConstraintsButton_NextMainScene.weightx = 1.0;
                this.m_ConstraintsButton_NextMainScene.insets = this.m_Insets;
            }
            if (this.m_Visible_MouseControl) {
                this.m_ConstraintsMouseRemoteControl.gridx = intButtonPosition++;
                this.m_ConstraintsMouseRemoteControl.gridy = 0;
                this.m_ConstraintsMouseRemoteControl.gridwidth = 1;
                this.m_ConstraintsMouseRemoteControl.gridheight = 1;
                this.m_ConstraintsMouseRemoteControl.fill = 1;
                this.m_ConstraintsMouseRemoteControl.weightx = 1.0;
                this.m_ConstraintsMouseRemoteControl.weighty = 1.0;
                this.m_ConstraintsMouseRemoteControl.insets = this.m_Insets;
            }
            this.setMinimumSize(new Dimension(intButtonPosition * 34, intHeight));
            this.setPreferredSize(new Dimension(intButtonPosition * 34, intHeight));
        } else if (p_Alignment == 1) {
            if (this.m_Visible_PlayRewind) {
                this.m_ConstraintsButton_PlayRewind.gridx = intButtonPosition++;
                this.m_ConstraintsButton_PlayRewind.gridy = 0;
                this.m_ConstraintsButton_PlayRewind.weightx = 1.0;
                this.m_ConstraintsButton_PlayRewind.insets = this.m_Insets;
            }
            ++intButtonPosition;
            if (this.m_Visible_Play) {
                this.m_ConstraintsButton_PlayStart.gridx = intButtonPosition++;
                this.m_ConstraintsButton_PlayStart.gridy = 0;
                this.m_ConstraintsButton_PlayStart.weightx = 1.0;
                this.m_ConstraintsButton_PlayStart.insets = this.m_Insets;
                if (this.m_TogglePlayPause || this.m_Visible_PlayPause) {
                    // empty if block
                }
            }
            if (this.m_Visible_PlayPause) {
                this.m_ConstraintsButton_PlayPause.gridx = intButtonPosition++;
                this.m_ConstraintsButton_PlayPause.gridy = 0;
                this.m_ConstraintsButton_PlayPause.weightx = 1.0;
                this.m_ConstraintsButton_PlayPause.insets = this.m_Insets;
            }
            if (this.m_Visible_FadeIn) {
                this.m_ConstraintsButton_PlayFadeIn.gridx = intButtonPosition++;
                this.m_ConstraintsButton_PlayFadeIn.gridy = 0;
                this.m_ConstraintsButton_PlayFadeIn.weightx = 1.0;
                this.m_ConstraintsButton_PlayFadeIn.insets = this.m_Insets;
            }
            if (this.m_Visible_FadeOut) {
                this.m_ConstraintsButton_PlayFadeOut.gridx = intButtonPosition++;
                this.m_ConstraintsButton_PlayFadeOut.gridy = 0;
                this.m_ConstraintsButton_PlayFadeOut.weightx = 1.0;
                this.m_ConstraintsButton_PlayFadeOut.insets = this.m_Insets;
            }
            if (this.m_Visible_FadeOutDirect) {
                this.m_ConstraintsButton_PlayFadeOutDirect.gridx = intButtonPosition++;
                this.m_ConstraintsButton_PlayFadeOutDirect.gridy = 0;
                this.m_ConstraintsButton_PlayFadeOutDirect.weightx = 1.0;
                this.m_ConstraintsButton_PlayFadeOutDirect.insets = this.m_Insets;
            }
            if (this.m_Visible_PlayStop) {
                this.m_ConstraintsButton_PlayStop.gridx = intButtonPosition++;
                this.m_ConstraintsButton_PlayStop.gridy = 0;
                this.m_ConstraintsButton_PlayStop.weightx = 1.0;
                this.m_ConstraintsButton_PlayStop.insets = this.m_Insets;
            }
            if (this.m_Visible_PlayFastForward) {
                this.m_ConstraintsButton_PlayFastForward.gridx = intButtonPosition++;
                this.m_ConstraintsButton_PlayFastForward.gridy = 0;
                this.m_ConstraintsButton_PlayFastForward.weightx = 1.0;
                this.m_ConstraintsButton_PlayFastForward.insets = this.m_Insets;
            }
            if (this.m_Visible_NextScene) {
                this.m_ConstraintsButton_NextScene.gridx = intButtonPosition - 1;
                this.m_ConstraintsButton_NextScene.gridy = 1;
                this.m_ConstraintsButton_NextScene.gridwidth = 1;
                this.m_ConstraintsButton_NextScene.weightx = 1.0;
                this.m_ConstraintsButton_NextScene.weighty = 0.5;
                this.m_ConstraintsButton_NextScene.insets = this.m_Insets;
            }
            if (this.m_Visible_PreviousScene) {
                this.m_ConstraintsButton_PreviousScene.gridx = 0;
                this.m_ConstraintsButton_PreviousScene.gridy = 1;
                this.m_ConstraintsButton_PreviousScene.gridwidth = 1;
                this.m_ConstraintsButton_PreviousScene.weightx = 1.0;
                this.m_ConstraintsButton_PreviousScene.weighty = 0.5;
                this.m_ConstraintsButton_PreviousScene.insets = this.m_Insets;
            }
            if (this.m_Visible_NextScene || this.m_Visible_PreviousScene) {
                intHeight = (int)((double)intHeight + (this.m_Button_PreviousScene.getPreferredSize().getHeight() + (double)this.m_Insets.bottom + (double)this.m_Insets.top));
            }
            if (this.m_Visible_NextMainScene) {
                this.m_ConstraintsButton_NextMainScene.gridx = intButtonPosition - 1;
                this.m_ConstraintsButton_NextMainScene.gridy = 2;
                this.m_ConstraintsButton_NextMainScene.gridwidth = 1;
                this.m_ConstraintsButton_NextMainScene.weightx = 1.0;
                this.m_ConstraintsButton_NextMainScene.weighty = 0.5;
                this.m_ConstraintsButton_NextMainScene.insets = this.m_Insets;
            }
            if (this.m_Visible_PreviousMainScene) {
                this.m_ConstraintsButton_PreviousMainScene.gridx = 0;
                this.m_ConstraintsButton_PreviousMainScene.gridy = 2;
                this.m_ConstraintsButton_PreviousMainScene.gridwidth = 1;
                this.m_ConstraintsButton_PreviousMainScene.weightx = 1.0;
                this.m_ConstraintsButton_PreviousMainScene.weighty = 0.5;
                this.m_ConstraintsButton_PreviousMainScene.insets = this.m_Insets;
            }
            if (this.m_Visible_NextMainScene || this.m_Visible_PreviousMainScene) {
                intHeight = (int)((double)intHeight + (this.m_Button_PreviousMainScene.getPreferredSize().getHeight() + (double)this.m_Insets.bottom + (double)this.m_Insets.top));
            }
            if (this.m_Visible_MouseControl) {
                this.m_ConstraintsMouseRemoteControl.gridx = 1;
                this.m_ConstraintsMouseRemoteControl.gridy = 1;
                this.m_ConstraintsMouseRemoteControl.gridwidth = intButtonPosition - 2;
                this.m_ConstraintsMouseRemoteControl.gridheight = 2;
                this.m_ConstraintsMouseRemoteControl.fill = 1;
                this.m_ConstraintsMouseRemoteControl.weightx = 1.0;
                this.m_ConstraintsMouseRemoteControl.weighty = 1.0;
                this.m_ConstraintsMouseRemoteControl.insets = this.m_Insets;
            }
            this.setMinimumSize(new Dimension(intButtonPosition * 34, intHeight));
            this.setPreferredSize(new Dimension(intButtonPosition * 34, intHeight));
        } else if (p_Alignment == 2) {
            if (this.m_Visible_PlayRewind) {
                this.m_ConstraintsButton_PlayRewind.gridx = 0;
                this.m_ConstraintsButton_PlayRewind.gridy = intButtonPosition++;
                this.m_ConstraintsButton_PlayRewind.weightx = 1.0;
                this.m_ConstraintsButton_PlayRewind.insets = this.m_Insets;
            }
            ++intButtonPosition;
            if (this.m_Visible_Play) {
                this.m_ConstraintsButton_PlayStart.gridx = 0;
                this.m_ConstraintsButton_PlayStart.gridy = intButtonPosition++;
                this.m_ConstraintsButton_PlayStart.weightx = 1.0;
                this.m_ConstraintsButton_PlayStart.insets = this.m_Insets;
                if (this.m_TogglePlayPause || this.m_Visible_PlayPause) {
                    // empty if block
                }
            }
            if (this.m_Visible_PlayPause) {
                this.m_ConstraintsButton_PlayPause.gridx = 0;
                this.m_ConstraintsButton_PlayPause.gridy = intButtonPosition++;
                this.m_ConstraintsButton_PlayPause.weightx = 1.0;
                this.m_ConstraintsButton_PlayPause.insets = this.m_Insets;
            }
            if (this.m_Visible_FadeIn) {
                this.m_ConstraintsButton_PlayFadeIn.gridx = 0;
                this.m_ConstraintsButton_PlayFadeIn.gridy = intButtonPosition++;
                this.m_ConstraintsButton_PlayFadeIn.weightx = 1.0;
                this.m_ConstraintsButton_PlayFadeIn.insets = this.m_Insets;
            }
            if (this.m_Visible_FadeOut) {
                this.m_ConstraintsButton_PlayFadeOut.gridx = 0;
                this.m_ConstraintsButton_PlayFadeOut.gridy = intButtonPosition++;
                this.m_ConstraintsButton_PlayFadeOut.weightx = 1.0;
                this.m_ConstraintsButton_PlayFadeOut.insets = this.m_Insets;
            }
            if (this.m_Visible_FadeOutDirect) {
                this.m_ConstraintsButton_PlayFadeOutDirect.gridx = 0;
                this.m_ConstraintsButton_PlayFadeOutDirect.gridy = intButtonPosition++;
                this.m_ConstraintsButton_PlayFadeOutDirect.weightx = 1.0;
                this.m_ConstraintsButton_PlayFadeOutDirect.insets = this.m_Insets;
            }
            if (this.m_Visible_PlayStop) {
                this.m_ConstraintsButton_PlayStop.gridx = 0;
                this.m_ConstraintsButton_PlayStop.gridy = intButtonPosition++;
                this.m_ConstraintsButton_PlayStop.weightx = 1.0;
                this.m_ConstraintsButton_PlayStop.insets = this.m_Insets;
            }
            if (this.m_Visible_PlayFastForward) {
                this.m_ConstraintsButton_PlayFastForward.gridx = 0;
                this.m_ConstraintsButton_PlayFastForward.gridy = intButtonPosition++;
                this.m_ConstraintsButton_PlayFastForward.weightx = 1.0;
                this.m_ConstraintsButton_PlayFastForward.insets = this.m_Insets;
            }
            if (this.m_Visible_NextScene) {
                this.m_ConstraintsButton_NextScene.gridx = 0;
                this.m_ConstraintsButton_NextScene.gridy = intButtonPosition++;
                this.m_ConstraintsButton_NextScene.weightx = 1.0;
                this.m_ConstraintsButton_NextScene.insets = this.m_Insets;
            }
            if (this.m_Visible_PreviousScene) {
                this.m_ConstraintsButton_PreviousScene.gridx = 0;
                this.m_ConstraintsButton_PreviousScene.gridy = intButtonPosition++;
                this.m_ConstraintsButton_PreviousScene.weightx = 1.0;
                this.m_ConstraintsButton_PreviousScene.insets = this.m_Insets;
            }
            if (this.m_Visible_NextMainScene) {
                this.m_ConstraintsButton_NextMainScene.gridx = 0;
                this.m_ConstraintsButton_NextMainScene.gridy = intButtonPosition++;
                this.m_ConstraintsButton_NextMainScene.weightx = 1.0;
                this.m_ConstraintsButton_NextMainScene.insets = this.m_Insets;
            }
            if (this.m_Visible_PreviousMainScene) {
                this.m_ConstraintsButton_PreviousMainScene.gridx = 0;
                this.m_ConstraintsButton_PreviousMainScene.gridy = intButtonPosition++;
                this.m_ConstraintsButton_PreviousMainScene.weightx = 1.0;
                this.m_ConstraintsButton_PreviousMainScene.insets = this.m_Insets;
            }
            if (this.m_Visible_MouseControl) {
                this.m_ConstraintsMouseRemoteControl.gridx = 0;
                this.m_ConstraintsMouseRemoteControl.gridy = intButtonPosition++;
                this.m_ConstraintsMouseRemoteControl.fill = 1;
                this.m_ConstraintsMouseRemoteControl.weightx = 1.0;
                this.m_ConstraintsMouseRemoteControl.weighty = 1.0;
                this.m_ConstraintsMouseRemoteControl.insets = this.m_Insets;
            }
            this.setMinimumSize(new Dimension(34, intButtonPosition * (34 + this.m_Insets.bottom + this.m_Insets.top)));
            this.setPreferredSize(new Dimension(34, intButtonPosition * (34 + this.m_Insets.bottom + this.m_Insets.top)));
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            EventQueueHandler.invokeLater(this.m_RunnableRepainr);
        } else {
            this.revalidate();
            this.repaint();
        }
    }

    public int getAlignment() {
        return this.m_Alignment;
    }

    @Override
    public void setEnabled(boolean p_Enabled) {
        super.setEnabled(p_Enabled);
        this.m_Enabled = p_Enabled;
        this.refreshButtons();
    }

    public void refreshButtons() {
        if (this.m_PlaySynchronisizer == null) {
            return;
        }
        if (!this.m_Enabled) {
            if (this.m_Button_PlayFadeIn != null) {
                this.m_Button_PlayFadeIn.setEnabled(false);
            }
            if (this.m_Button_PlayFadeOut != null) {
                this.m_Button_PlayFadeOut.setEnabled(false);
            }
            if (this.m_Button_PlayFadeOutDirect != null) {
                this.m_Button_PlayFadeOutDirect.setEnabled(false);
            }
            if (this.m_Button_PlayFastForward != null) {
                this.m_Button_PlayFastForward.setEnabled(false);
            }
            if (this.m_Button_PlayPause != null) {
                this.m_Button_PlayPause.setEnabled(false);
            }
            if (this.m_Button_PlayRewind != null) {
                this.m_Button_PlayRewind.setEnabled(false);
            }
            if (this.m_Button_PlayStart != null) {
                this.m_Button_PlayStart.setEnabled(false);
            }
            if (this.m_Button_PlayStop != null) {
                this.m_Button_PlayStop.setEnabled(false);
            }
            return;
        }
        if (this.m_Button_PlayFadeIn != null) {
            this.m_Button_PlayFadeIn.setEnabled(true);
        }
        if (this.m_Button_PlayFadeOut != null) {
            this.m_Button_PlayFadeOut.setEnabled(true);
        }
        if (this.m_Button_PlayFadeOutDirect != null) {
            this.m_Button_PlayFadeOutDirect.setEnabled(true);
        }
        if (this.m_Button_PlayFastForward != null) {
            this.m_Button_PlayFastForward.setEnabled(true);
        }
        if (this.m_Button_PlayPause != null) {
            this.m_Button_PlayPause.setEnabled(true);
        }
        if (this.m_Button_PlayRewind != null) {
            this.m_Button_PlayRewind.setEnabled(true);
        }
        if (this.m_Button_PlayStart != null) {
            this.m_Button_PlayStart.setEnabled(true);
        }
        if (this.m_Button_PlayStop != null) {
            this.m_Button_PlayStop.setEnabled(true);
        }
        this.m_PlayControlPanelStatus.setRewindEnabled(true);
        if (this.m_PlaySynchronisizer.getPlayStartedCount() > 0) {
            this.m_PlayControlPanelStatus.setPauseEnabled(true);
            if (!this.m_TogglePlayPause) {
                this.m_Button_PlayPause.setEnabled(true);
            } else {
                this.m_Button_PlayPause.setVisible(true);
            }
            if (this.m_Visible_PlayStop) {
                this.m_PlayControlPanelStatus.setStopEnabled(true);
                this.m_Button_PlayStop.setEnabled(true);
            }
        } else {
            this.m_PlayControlPanelStatus.setPauseEnabled(false);
            if (!this.m_TogglePlayPause) {
                this.m_Button_PlayPause.setEnabled(false);
            } else {
                this.m_Button_PlayPause.setVisible(false);
            }
            if (this.m_Visible_PlayStop) {
                this.m_PlayControlPanelStatus.setStopEnabled(false);
                this.m_Button_PlayStop.setEnabled(false);
            }
        }
        if (this.m_PlaySynchronisizer.getPlayWaitingCount() > 0) {
            this.m_PlayControlPanelStatus.setStopEnabled(true);
            if (this.m_Visible_PlayStop) {
                this.m_Button_PlayStop.setEnabled(true);
            }
        }
        if (this.m_PlaySynchronisizer.getPlayStoppedCount() > 0) {
            this.m_PlayControlPanelStatus.setStartEnabled(true);
            if (!this.m_TogglePlayPause) {
                this.m_Button_PlayStart.setEnabled(true);
            } else {
                this.m_Button_PlayStart.setVisible(true);
            }
        } else {
            this.m_PlayControlPanelStatus.setStartEnabled(false);
            if (!this.m_TogglePlayPause) {
                this.m_Button_PlayStart.setEnabled(false);
            } else {
                this.m_Button_PlayStart.setVisible(false);
            }
        }
        if (this.m_PlaySynchronisizer.getPlayFadeInPossibleCount() > 0) {
            this.m_PlayControlPanelStatus.setFadeInEnabled(true);
            if (this.m_Visible_FadeIn) {
                this.m_Button_PlayFadeIn.setEnabled(true);
            }
        } else {
            this.m_PlayControlPanelStatus.setFadeInEnabled(false);
            if (this.m_Visible_FadeIn) {
                this.m_Button_PlayFadeIn.setEnabled(false);
            }
        }
        if (this.m_PlaySynchronisizer.getPlayFadeOutPossibleCount() > 0) {
            this.m_PlayControlPanelStatus.setFadeOutEnabled(true);
            if (this.m_Visible_FadeOut) {
                this.m_Button_PlayFadeOut.setEnabled(true);
            }
        } else {
            this.m_PlayControlPanelStatus.setFadeOutEnabled(false);
            if (this.m_Visible_FadeOut) {
                this.m_Button_PlayFadeOut.setEnabled(false);
            }
        }
        if (this.m_PlaySynchronisizer.getPlayFadeOutPossibleCount() > 0) {
            this.m_PlayControlPanelStatus.setFadeOutDirectEnabled(true);
            if (this.m_Visible_FadeOutDirect) {
                this.m_Button_PlayFadeOutDirect.setEnabled(true);
            }
        } else {
            this.m_PlayControlPanelStatus.setFadeOutDirectEnabled(false);
            if (this.m_Visible_FadeOutDirect) {
                this.m_Button_PlayFadeOutDirect.setEnabled(false);
            }
        }
        this.notifyPlayControlStatus();
    }

    @Override
    public void eventPlayStart(Play p_Play) {
        this.m_WillFadeIn = false;
        this.m_WillFadeOut = false;
        this.refreshButtons();
    }

    @Override
    public void eventPlayStop(Play p_Play) {
        this.refreshButtons();
    }

    @Override
    public void eventPlayPause(Play p_Play) {
        this.refreshButtons();
        if (this.m_PlaySynchronisizer == null) {
            return;
        }
        if (this.m_WillFadeIn) {
            this.m_PlaySynchronisizer.actionPlayFadeIn();
            this.m_WillFadeIn = false;
        } else if (this.m_WillFadeOut) {
            this.m_PlaySynchronisizer.actionPlayFadeOut();
            this.m_WillFadeOut = false;
        }
    }

    @Override
    public void eventPlayRewind(Play p_Play) {
    }

    @Override
    public void eventPlayFastForward(Play p_Play) {
    }

    @Override
    public void eventPlayFadePossibility(Play p_Play, boolean p_FadeInPossible, boolean p_FadeOutPossible, double p_FadeProgress) {
        this.refreshButtons();
    }

    @Override
    public void eventPlayFadedIn(Play p_Play, boolean p_FadedIn, double p_FadeProgress) {
    }

    @Override
    public void eventPlayCursorSet(Play p_Play, long p_PlayCursor) {
    }

    @Override
    public void eventEditModeOn(Play p_Play, boolean p_EditModeOn) {
    }

    @Override
    public void eventEditCursorSet(Play p_Play, long p_EditCursor) {
    }

    @Override
    public long eventPlayCheckRead(Play p_Play, long p_FrameStart, long p_FramesToRead) {
        return p_FramesToRead;
    }

    @Override
    public void eventPlayCursor(Play p_Play, long p_OldPlayCursor, long p_PlayCursor) {
    }

    @Override
    public void eventPlayClosing(Play p_Play) {
        this.removePlay(p_Play);
    }

    @Override
    public void eventPlayError(Play p_Play, Exception p_Exception, String p_Remark) {
    }

    @Override
    public void eventPlayTimelineEnd(Play p_Play) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlayControlListener(PlayControlListener p_PlayControlListener) {
        if (p_PlayControlListener == null) {
            return;
        }
        Object object = this.m_SyncPlayControlListener;
        synchronized (object) {
            if (this.m_PlayControlListeners.contains(p_PlayControlListener)) {
                return;
            }
            this.m_PlayControlListeners.add(p_PlayControlListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlayControlListener(PlayControlListener p_PlayControlListener) {
        if (p_PlayControlListener == null) {
            return;
        }
        Object object = this.m_SyncPlayControlListener;
        synchronized (object) {
            if (!this.m_PlayControlListeners.contains(p_PlayControlListener)) {
                return;
            }
            this.m_PlayControlListeners.remove(p_PlayControlListener);
        }
    }

    public PlayControlPanelStatus getPlayControlPanelStatus() {
        return this.m_PlayControlPanelStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyPlayControlStatus() {
        PlayControlListener o_PlayControlListener;
        ArrayList<PlayControlListener> o_PlayControlListeners;
        Object object = this.m_SyncPlayControlListener;
        synchronized (object) {
            if (this.m_PlayControlListeners.size() <= 0) {
                return;
            }
            o_PlayControlListeners = new ArrayList<PlayControlListener>(this.m_PlayControlListeners.size());
            for (int intListener = 0; intListener < this.m_PlayControlListeners.size(); ++intListener) {
                o_PlayControlListener = this.m_PlayControlListeners.get(intListener);
                o_PlayControlListeners.add(o_PlayControlListener);
            }
        }
        for (int intListener = 0; intListener < o_PlayControlListeners.size(); ++intListener) {
            o_PlayControlListener = (PlayControlListener)o_PlayControlListeners.get(intListener);
            o_PlayControlListener.eventPlayControlStatus(this.m_PlayControlPanelStatus);
        }
    }

    public void createSPITRemote(String p_GroupName) {
        SPIT_Type_Interface o_SPIT_Type = SPITRemote.createServerRemoteSPIT_Type((String)SPITID_START, (String)p_GroupName, (String)NAME_PLAYSTART, (boolean)true);
        SPITRemote.addRemoteSPIT_Type((SPIT_Type_Interface)o_SPIT_Type);
        SPIT_Object_Interface o_SPIT_Object = SPITRemote.createServerRemoteSPIT_Object((SPIT_Type_Interface)o_SPIT_Type, null, null, (byte)0);
        o_SPIT_Object.setSPIT_Action_Interface((SPIT_Action_Interface)this, null);
        SPITRemote.addRemoteSPIT_Object((SPIT_Object_Interface)o_SPIT_Object);
        o_SPIT_Type = SPITRemote.createServerRemoteSPIT_Type((String)SPITID_PAUSE, (String)p_GroupName, (String)NAME_PLAYPAUSE, (boolean)true);
        SPITRemote.addRemoteSPIT_Type((SPIT_Type_Interface)o_SPIT_Type);
        o_SPIT_Object = SPITRemote.createServerRemoteSPIT_Object((SPIT_Type_Interface)o_SPIT_Type, null, null, (byte)0);
        o_SPIT_Object.setSPIT_Action_Interface((SPIT_Action_Interface)this, null);
        SPITRemote.addRemoteSPIT_Object((SPIT_Object_Interface)o_SPIT_Object);
        o_SPIT_Type = SPITRemote.createServerRemoteSPIT_Type((String)SPITID_NextScenebridge, (String)p_GroupName, (String)NAME_NEXTSCENE, (boolean)true);
        SPITRemote.addRemoteSPIT_Type((SPIT_Type_Interface)o_SPIT_Type);
        o_SPIT_Object = SPITRemote.createServerRemoteSPIT_Object((SPIT_Type_Interface)o_SPIT_Type, null, null, (byte)0);
        o_SPIT_Object.setSPIT_Action_Interface((SPIT_Action_Interface)this, null);
        SPITRemote.addRemoteSPIT_Object((SPIT_Object_Interface)o_SPIT_Object);
        o_SPIT_Type = SPITRemote.createServerRemoteSPIT_Type((String)SPITID_NextMainScenebridge, (String)p_GroupName, (String)NAME_NEXTMAINSCENE, (boolean)true);
        SPITRemote.addRemoteSPIT_Type((SPIT_Type_Interface)o_SPIT_Type);
        o_SPIT_Object = SPITRemote.createServerRemoteSPIT_Object((SPIT_Type_Interface)o_SPIT_Type, null, null, (byte)0);
        o_SPIT_Object.setSPIT_Action_Interface((SPIT_Action_Interface)this, null);
        SPITRemote.addRemoteSPIT_Object((SPIT_Object_Interface)o_SPIT_Object);
        o_SPIT_Type = SPITRemote.createServerRemoteSPIT_Type((String)SPITID_PreviousScenebridge, (String)p_GroupName, (String)NAME_PREVIOUSSCENE, (boolean)true);
        SPITRemote.addRemoteSPIT_Type((SPIT_Type_Interface)o_SPIT_Type);
        o_SPIT_Object = SPITRemote.createServerRemoteSPIT_Object((SPIT_Type_Interface)o_SPIT_Type, null, null, (byte)0);
        o_SPIT_Object.setSPIT_Action_Interface((SPIT_Action_Interface)this, null);
        SPITRemote.addRemoteSPIT_Object((SPIT_Object_Interface)o_SPIT_Object);
        o_SPIT_Type = SPITRemote.createServerRemoteSPIT_Type((String)SPITID_PreviousMainScenebridge, (String)p_GroupName, (String)NAME_PREVIOUSMAINSCENE, (boolean)true);
        SPITRemote.addRemoteSPIT_Type((SPIT_Type_Interface)o_SPIT_Type);
        o_SPIT_Object = SPITRemote.createServerRemoteSPIT_Object((SPIT_Type_Interface)o_SPIT_Type, null, null, (byte)0);
        o_SPIT_Object.setSPIT_Action_Interface((SPIT_Action_Interface)this, null);
        SPITRemote.addRemoteSPIT_Object((SPIT_Object_Interface)o_SPIT_Object);
    }

    public void playStarted(SPIT_Object_Interface p_SPIT_Object_Interface, SPIT_ActionStatus p_SPIT_ActionStatus, Object p_SPIT_Action_Object) {
    }

    public void play(SPIT_Object_Interface p_SPIT_Object_Interface, SPIT_ActionStatus p_SPIT_ActionStatus, Object p_SPIT_Action_Object) {
        if (p_SPIT_Object_Interface == null) {
            return;
        }
        switch (p_SPIT_Object_Interface.getID()) {
            case "playControlStart": {
                this.actionPlayStart();
                break;
            }
            case "playControlPause": {
                this.actionPlayPause();
                break;
            }
            case "nextSceneBridge": {
                this.actionNextScene();
                break;
            }
            case "nextMainSceneBridge": {
                this.actionNextMainScene();
                break;
            }
            case "previuosSceneBridge": {
                this.actionPreviousScene();
                break;
            }
            case "previousMainSceneBridge": {
                this.actionPreviousMainScene();
            }
        }
    }

    public void playEnd(SPIT_Object_Interface p_SPIT_Object_Interface, SPIT_ActionStatus p_SPIT_ActionStatus, Object p_SPIT_Action_Object) {
    }

    public static class MouseRemotePlayControl
    extends JPanel {
        private PlayControlPanel m_PlayControlPanel;
        private JLabelBackground m_Button_MouseControl;
        private GridBagConstraints m_ConstraintsButton_MouseControl;

        public MouseRemotePlayControl(PlayControlPanel p_PlayControlPanel) {
            this.initMembers();
            this.m_PlayControlPanel = p_PlayControlPanel;
            this.initComponents();
            this.m_PlayControlPanel.createRemoteMouseActions();
        }

        private void initMembers() {
        }

        private void initComponents() {
            super.setLayout(new GridBagLayout());
            this.m_Button_MouseControl = new JLabelBackground();
            this.m_Button_MouseControl.setBackgroundStyle(3);
            this.m_Button_MouseControl.setBackground(Color.LIGHT_GRAY);
            this.m_Button_MouseControl.setBackgroundOpaque(true);
            this.m_Button_MouseControl.setBorder(new BevelBorder(1));
            this.m_Button_MouseControl.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Mouse.png")));
            this.m_Button_MouseControl.setMinimumSize(new Dimension(32, 32));
            this.m_Button_MouseControl.setPreferredSize(new Dimension(32, 32));
            this.m_Button_MouseControl.setVisible(true);
            MouseAdapter_Delayed o_MouseListener_MouseControl = new MouseAdapter_Delayed(){

                @Override
                public void mouseEntered_Delayed(MouseEvent e) {
                    m_Button_MouseControl.setBackground(Color.GREEN);
                    m_Button_MouseControl.requestFocusInWindow();
                }

                @Override
                public void mouseExited_Delayed(MouseEvent e) {
                    m_Button_MouseControl.setBackground(Color.LIGHT_GRAY);
                }
            };
            this.m_Button_MouseControl.setFocusTraversalKeysEnabled(false);
            this.m_Button_MouseControl.addMouseListener(o_MouseListener_MouseControl);
            this.m_Button_MouseControl.addKeyListener(PlayRemoteActions.s_KeyAdapter_Delayed);
            this.m_Button_MouseControl.addMouseListener(PlayRemoteActions.s_MouseAdapter_Delayed);
            this.m_Button_MouseControl.setFocusable(true);
            this.m_Button_MouseControl.setFocusTraversalKeysEnabled(false);
            this.m_ConstraintsButton_MouseControl = new GridBagConstraints();
            this.m_ConstraintsButton_MouseControl.gridx = 0;
            this.m_ConstraintsButton_MouseControl.gridy = 0;
            this.m_ConstraintsButton_MouseControl.fill = 1;
            this.m_ConstraintsButton_MouseControl.weightx = 1.0;
            this.m_ConstraintsButton_MouseControl.weighty = 1.0;
            this.add((Component)this.m_Button_MouseControl, this.m_ConstraintsButton_MouseControl);
        }
    }

    public static interface PlayControlListener {
        public void eventPlayControlStatus(PlayControlPanelStatus var1);
    }

    public static class PlayControlPanelStatus {
        private boolean m_StartVisible;
        private boolean m_StopVisible;
        private boolean m_PauseVisible;
        private boolean m_FadeInVisible;
        private boolean m_FadeOutVisible;
        private boolean m_FadeOutDirectVisible;
        private boolean m_FastForwardVisible;
        private boolean m_RewindVisible;
        private boolean m_Start;
        private boolean m_Stop;
        private boolean m_Pause;
        private boolean m_FadeIn;
        private boolean m_FadeOut;
        private boolean m_FadeOutDirect;
        private boolean m_FastForward;
        private boolean m_Rewind;

        public void setStartVisible(boolean p_Visible) {
            this.m_StartVisible = p_Visible;
        }

        public boolean getStartVisible() {
            return this.m_StartVisible;
        }

        public void setStartEnabled(boolean p_Enabled) {
            this.m_Start = p_Enabled;
        }

        public boolean getStartEnabled() {
            if (!this.m_StartVisible) {
                return false;
            }
            return this.m_Start;
        }

        public void setPauseVisible(boolean p_Visible) {
            this.m_PauseVisible = p_Visible;
        }

        public boolean getPauseVisible() {
            return this.m_PauseVisible;
        }

        public void setPauseEnabled(boolean p_Enabled) {
            this.m_Pause = p_Enabled;
        }

        public boolean getPauseEnabled() {
            if (!this.m_PauseVisible) {
                return false;
            }
            return this.m_Pause;
        }

        public void setStopVisible(boolean p_Visible) {
            this.m_StopVisible = p_Visible;
        }

        public boolean getStopVisible() {
            return this.m_StopVisible;
        }

        public void setStopEnabled(boolean p_Enabled) {
            this.m_Stop = p_Enabled;
        }

        public boolean getStopEnabled() {
            if (!this.m_StopVisible) {
                return false;
            }
            return this.m_Stop;
        }

        public void setFadeInVisible(boolean p_Visible) {
            this.m_FadeInVisible = p_Visible;
        }

        public boolean getFadeInVisible() {
            return this.m_FadeInVisible;
        }

        public void setFadeInEnabled(boolean p_Enabled) {
            this.m_FadeIn = p_Enabled;
        }

        public boolean getFadeInEnabled() {
            if (!this.m_FadeInVisible) {
                return false;
            }
            return this.m_FadeIn;
        }

        public void setFadeOutVisible(boolean p_Visible) {
            this.m_FadeOutVisible = p_Visible;
        }

        public boolean getFadeOutVisible() {
            return this.m_FadeOutVisible;
        }

        public void setFadeOutEnabled(boolean p_Enabled) {
            this.m_FadeOut = p_Enabled;
        }

        public boolean getFadeOutEnabled() {
            if (!this.m_FadeOutVisible) {
                return false;
            }
            return this.m_FadeOut;
        }

        public void setFadeOutDirectVisible(boolean p_Visible) {
            this.m_FadeOutDirectVisible = p_Visible;
        }

        public boolean getFadeOutDirectVisible() {
            return this.m_FadeOutDirectVisible;
        }

        public void setFadeOutDirectEnabled(boolean p_Enabled) {
            this.m_FadeOutDirect = p_Enabled;
        }

        public boolean getFadeOutDirectEnabled() {
            if (!this.m_FadeOutDirectVisible) {
                return false;
            }
            return this.m_FadeOutDirect;
        }

        public void setFastForwardVisible(boolean p_Visible) {
            this.m_FastForwardVisible = p_Visible;
        }

        public boolean getFastForwardVisible() {
            return this.m_FastForwardVisible;
        }

        public void setFastForwardEnabled(boolean p_Enabled) {
            this.m_FastForward = p_Enabled;
        }

        public boolean getFastForwardEnabled() {
            if (!this.m_FastForwardVisible) {
                return false;
            }
            return this.m_FastForward;
        }

        public void setRewindVisible(boolean p_Visible) {
            this.m_RewindVisible = p_Visible;
        }

        public boolean getRewindVisible() {
            return this.m_RewindVisible;
        }

        public void setRewindEnabled(boolean p_Enabled) {
            this.m_Rewind = p_Enabled;
        }

        public boolean getRewindEnabled() {
            if (!this.m_RewindVisible) {
                return false;
            }
            return this.m_Rewind;
        }
    }
}

