/*
 * Decompiled with CFR 0.152.
 */
package LiveShowPlayPackage;

import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowPlayPackage.PlayJumpInterface;
import LiveShowPlayPackage.PlayListener;
import LiveShowPlayPackage.Playable;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import LiveShowVirtualPackage.LiveShowVIP;
import SynchronizationPackage.EventQueueHandler;
import SynchronizationPackage.LiveCloseSemaphore;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class Play
implements Runnable {
    public static final int STATUS_ERROR = -1;
    public static final int STATUS_STOP = 0;
    public static final int STATUS_WAIT = 1;
    public static final int STATUS_START = 2;
    public static final int STATUS_RUN = 3;
    public static final int STATUS_CLOSE = 9;
    public static ArrayList<Play> s_AllPlays = new ArrayList();
    public static final Object s_AllPlaysSync = new Object();
    protected int m_Status;
    private Color m_Color;
    protected PlaySynchronisizer m_PlaySynchronisizer;
    protected boolean m_WaitForTrigger;
    protected Playable m_Playable;
    protected Thread m_PlayThread;
    protected static String s_PlayThreadName = "PlayThread_" + Play.class.getSimpleName();
    protected boolean m_Closed;
    protected boolean m_StopFlag;
    protected boolean m_WaitFlag;
    protected boolean m_ShouldRun;
    protected boolean m_PauseAfterFadeIn;
    protected boolean m_FadeInPossible;
    protected boolean m_FadeOutPossible;
    protected boolean m_FadedIn;
    protected boolean m_WasFadedIn;
    protected long m_FramePlayCursor;
    protected long m_FrameOldPlayCursor;
    protected boolean m_PlayCursorSet;
    protected boolean m_IsEditModeOn;
    protected long m_FrameEditCursor;
    protected boolean m_OverwriteManualValues;
    protected boolean m_HasOutputLine;
    protected long m_PlayStartTime;
    protected long m_FramesRead;
    protected PlayJumpInterface m_ActualPlayJump;
    protected ArrayList<PlayListener> m_PlayListeners;
    protected LiveCloseSemaphore m_LiveCloseSemaphore;
    protected final Object m_SyncFramePosition = new Object();
    protected final Object m_SyncPlayListeners = new Object();
    protected final Object m_SyncPlay = new Object();
    protected ArrayList<LiveShowObjectInterface> m_LiveShowOOjects_Jingle;
    protected ArrayList<Playable.PlayObject> m_LiveShowObjects_JingleActive;
    protected ArrayList<Playable.PlayObject> m_LiveShowObjects_JingleStopped;
    protected HashMap<String, Playable.PlayObject> m_PlayObjects_Jingles;
    protected final Object m_SyncJingles = new Object();
    private LiveShowSceneBridge m_WillStopAtSceneBridge;

    public static boolean isSomethingPlaying() {
        int intPlayCount = Play.getPlayCount();
        for (int intPlay = 0; intPlay < intPlayCount; ++intPlay) {
            int intStatus;
            Play o_Play = Play.getPlay(intPlay);
            if (o_Play == null || (intStatus = o_Play.getStatus()) != 3 && intStatus != 2) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPlay(Play p_Play) {
        if (p_Play == null) {
            return;
        }
        Object object = s_AllPlaysSync;
        synchronized (object) {
            if (s_AllPlays.contains(p_Play)) {
                return;
            }
            s_AllPlays.add(p_Play);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePlay(Play p_Play) {
        if (p_Play == null) {
            return;
        }
        Object object = s_AllPlaysSync;
        synchronized (object) {
            s_AllPlays.remove(p_Play);
        }
    }

    public static int getPlayCount() {
        return s_AllPlays.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Play getPlay(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = s_AllPlaysSync;
        synchronized (object) {
            if (p_Index >= s_AllPlays.size()) {
                return null;
            }
            return s_AllPlays.get(p_Index);
        }
    }

    public Play(Playable p_Playable) {
        this.m_Playable = p_Playable;
        this.initMembers();
        this.addPlayListener(this.m_Playable);
        this.m_FramePlayCursor = this.m_Playable != null ? 0L : 0L;
        Play.addPlay(this);
        this.m_PlayThread = new Thread((Runnable)this, s_PlayThreadName);
        try {
            this.m_PlayThread.setPriority(7);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_PlayThread.start();
    }

    private void initMembers() {
        this.m_Status = 0;
        this.m_Closed = false;
        this.m_ShouldRun = false;
        this.m_LiveCloseSemaphore = new LiveCloseSemaphore(this.getClass().getSimpleName());
        this.m_PlayListeners = new ArrayList();
        this.m_FramePlayCursor = 0L;
        this.m_FrameOldPlayCursor = 0L;
        this.m_IsEditModeOn = false;
        this.m_FrameEditCursor = 0L;
        this.m_ActualPlayJump = null;
        this.m_WaitForTrigger = false;
        this.m_OverwriteManualValues = false;
        this.m_PauseAfterFadeIn = false;
        this.m_FadeInPossible = true;
        this.m_FadeOutPossible = false;
        this.m_FadedIn = false;
        this.m_WasFadedIn = false;
        this.m_HasOutputLine = false;
        this.m_FramesRead = -1L;
        this.m_LiveShowOOjects_Jingle = new ArrayList();
        this.m_PlayObjects_Jingles = new HashMap();
        this.m_LiveShowObjects_JingleActive = new ArrayList();
        this.m_LiveShowObjects_JingleStopped = new ArrayList();
    }

    public abstract boolean createOutputLine();

    public abstract boolean closeOutputLine();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object;
        if (!this.m_LiveCloseSemaphore.enterCloseSection()) {
            return;
        }
        this.m_Closed = true;
        Play.removePlay(this);
        Thread o_PlayThread = this.m_PlayThread;
        if (o_PlayThread != null) {
            this.stop();
            object = this.m_SyncPlay;
            synchronized (object) {
                this.m_SyncPlay.notifyAll();
            }
            try {
                if (o_PlayThread.isAlive() && Thread.currentThread() != o_PlayThread) {
                    o_PlayThread.join(1000L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.m_PlaySynchronisizer != null) {
                this.m_PlaySynchronisizer.removePlay(this);
                this.m_PlaySynchronisizer = null;
            }
        }
        this.notifyPlayListeners_Closing();
        this.m_Status = 9;
        object = this.m_SyncPlayListeners;
        synchronized (object) {
            if (this.m_PlayListeners != null) {
                this.m_PlayListeners.clear();
            }
        }
        if (this.m_Playable != null) {
            // empty if block
        }
        this.closeOutputLine();
        this.m_LiveCloseSemaphore.leaveCloseSection();
    }

    public int getStatus() {
        return this.m_Status;
    }

    public void setPlayable(Playable p_Playable, Object p_Addition) {
        if (p_Playable == null) {
            return;
        }
        if (this.m_Playable == p_Playable) {
            return;
        }
        this.stop();
        this.m_Playable = p_Playable;
    }

    public Playable getPlayable() {
        Playable o_Playable = null;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return o_Playable;
        }
        o_Playable = this.m_Playable;
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return o_Playable;
    }

    public boolean getActive() {
        Playable o_Playable = null;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        o_Playable = this.m_Playable;
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        if (o_Playable == null) {
            return false;
        }
        return o_Playable.getActive();
    }

    public void setPlaySynchronizer(PlaySynchronisizer p_PlaySynchronisizer) {
        if (this.m_PlaySynchronisizer == p_PlaySynchronisizer) {
            return;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        if (this.m_PlaySynchronisizer != null) {
            this.m_PlaySynchronisizer.removePlay(this);
        }
        this.m_PlaySynchronisizer = p_PlaySynchronisizer;
        if (this.m_PlaySynchronisizer != null) {
            this.m_PlaySynchronisizer.addPlay(this);
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    public PlaySynchronisizer getPlaySynchronizer() {
        return this.m_PlaySynchronisizer;
    }

    protected abstract void initPlayObject();

    public abstract Playable.PlayObject getPlayObject();

    public Color getColor() {
        return this.m_Color;
    }

    public void setColor(Color p_Color) {
        if (p_Color == null) {
            return;
        }
        this.m_Color = p_Color;
    }

    public long getFramePositionStart() {
        long longFrame = 0L;
        Playable o_Playable = this.m_Playable;
        if (o_Playable != null) {
            longFrame = o_Playable.getFrameStart();
        }
        return longFrame;
    }

    public long getFramePositionEnd() {
        long longFrame = 0L;
        Playable o_Playable = this.m_Playable;
        if (o_Playable != null) {
            longFrame = o_Playable.getFrameEnd();
        }
        return longFrame;
    }

    public void setActualPlayJump(PlayJumpInterface p_PlayJump) {
        this.m_ActualPlayJump = p_PlayJump;
    }

    public void setOverwriteManualValues(boolean p_Overwrite) {
        this.m_OverwriteManualValues = p_Overwrite;
    }

    protected abstract void clearPlaying();

    protected abstract void reworkPause();

    protected abstract void reworkStop();

    public abstract void playFramePositionOnce(long var1);

    public abstract void playFramePositionOnce();

    public abstract long getBufferDelayFrames();

    public void startPlaying() {
        if (this.m_Status == 3 || this.m_Status == 2) {
            return;
        }
        this.m_Status = 2;
        boolean boolOK = true;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.m_WasFadedIn = false;
        if (this.m_Playable == null) {
            boolOK = false;
        }
        if (!boolOK) {
            this.m_Status = -1;
            this.m_LiveCloseSemaphore.leaveWorkerSection();
            return;
        }
        this.m_StopFlag = false;
        this.m_WaitFlag = false;
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        this.letsRun();
    }

    public void start() {
        this.m_ShouldRun = true;
        this.m_PauseAfterFadeIn = false;
        this.startPlaying();
    }

    public void startWait() {
    }

    public void fadeIn() {
        Playable o_Playable = this.getPlayable();
        if (o_Playable == null) {
            return;
        }
        Playable.PlayObject o_PlayObject = this.getPlayObject();
        if (o_PlayObject == null) {
            return;
        }
        o_Playable.resetFadeOutDirect();
        double doubleFadeProgress = o_PlayObject.getFadeProgress();
        if (doubleFadeProgress > 0.0) {
            long longFramePosition = o_Playable.findFramePosition_FadeIn(doubleFadeProgress);
            if (longFramePosition < 0L) {
                longFramePosition = 0L;
            }
            this.setPlayCursor(longFramePosition);
        }
        this.m_ShouldRun = true;
        this.m_PauseAfterFadeIn = true;
        this.startPlaying();
    }

    public void fadeOut() {
        Playable o_Playable = this.getPlayable();
        if (o_Playable == null) {
            return;
        }
        Playable.PlayObject o_PlayObject = this.getPlayObject();
        if (o_PlayObject == null) {
            return;
        }
        double doubleFadeProgress = o_PlayObject.getFadeProgress();
        long longFramePosition = o_Playable.findFramePosition_FadeOut(doubleFadeProgress);
        if (longFramePosition < 0L) {
            longFramePosition = 0L;
        }
        this.setPlayCursor(longFramePosition);
        this.m_ShouldRun = true;
        this.m_PauseAfterFadeIn = false;
        this.startPlaying();
    }

    public void fadeIn(double p_FadeProgress) {
        Playable o_Playable;
        if (p_FadeProgress < 0.0) {
            p_FadeProgress = 0.0;
        }
        if (p_FadeProgress > 1.0) {
            p_FadeProgress = 1.0;
        }
        if ((o_Playable = this.getPlayable()) == null) {
            return;
        }
        Playable.PlayObject o_PlayObject = this.getPlayObject();
        if (o_PlayObject == null) {
            return;
        }
        if (p_FadeProgress <= 0.0) {
            this.stop();
            this.m_Status = 0;
            this.clearPlaying();
            this.m_FrameOldPlayCursor = this.m_FramePlayCursor;
            this.playRewind();
            return;
        }
        if (this.m_PlaySynchronisizer.getPlayStartedCount() > 0) {
            this.m_PlaySynchronisizer.actionPlayPause();
        } else if (this.m_Status != 1) {
            this.m_Status = 3;
            this.notifyPlayListeners_PlayStart();
            this.m_Status = 1;
            this.m_WaitFlag = true;
            this.m_StopFlag = false;
            this.m_ShouldRun = false;
            this.reworkPause();
            this.notifyPlayListeners_PlayPause();
        }
        long longFramePosition = o_Playable.findFramePosition_FadeIn(p_FadeProgress);
        if (longFramePosition < 0L) {
            longFramePosition = 0L;
        }
        this.setPlayCursor(longFramePosition);
        this.setPlayCursorInternal(longFramePosition, longFramePosition);
        this.fetchwriteData();
        this.checkFadeProgress(true);
    }

    public void fadeOutDirect() {
        this.m_PauseAfterFadeIn = false;
        Playable o_Playable = this.getPlayable();
        if (o_Playable == null) {
            return;
        }
        Playable.PlayObject o_PlayObject = this.getPlayObject();
        if (o_PlayObject == null) {
            return;
        }
        boolean boolCanFadeOutDirect = o_Playable.getFrameLength_FadeOutDirect() > 0L ? true : o_Playable.setFadeOutDirect(this.m_FramePlayCursor, o_PlayObject.getFadeInProgress(), o_PlayObject.getFadeOutProgress());
        if (!boolCanFadeOutDirect || o_Playable.getFrameLength_FadeOutDirect() <= 0L) {
            if (this.m_PlaySynchronisizer != null) {
                this.m_PlaySynchronisizer.actionPlayStop();
            }
            return;
        }
        if (this.m_WaitFlag && this.m_PlaySynchronisizer != null) {
            this.m_PlaySynchronisizer.actionPlayStart();
        }
    }

    public void fadeOut(double p_FadeProgress) {
        if (p_FadeProgress < 0.0) {
            p_FadeProgress = 0.0;
        }
        if (p_FadeProgress > 1.0) {
            p_FadeProgress = 1.0;
        }
        this.m_PauseAfterFadeIn = false;
        Playable o_Playable = this.getPlayable();
        if (o_Playable == null) {
            return;
        }
        Playable.PlayObject o_PlayObject = this.getPlayObject();
        if (o_PlayObject == null) {
            return;
        }
        if (p_FadeProgress <= 0.0) {
            this.stop();
            this.m_Status = 0;
            this.clearPlaying();
            this.m_FrameOldPlayCursor = this.m_FramePlayCursor;
            this.playRewind();
            return;
        }
        if (this.m_PlaySynchronisizer.getPlayStartedCount() > 0) {
            this.m_PlaySynchronisizer.actionPlayPause();
        } else if (this.m_Status != 1) {
            this.m_Status = 3;
            this.notifyPlayListeners_PlayStart();
            this.m_Status = 1;
            this.m_WaitFlag = true;
            this.m_StopFlag = false;
            this.m_ShouldRun = false;
            this.reworkPause();
            this.notifyPlayListeners_PlayPause();
        }
        long longFramePosition = o_Playable.findFramePosition_FadeOut(p_FadeProgress);
        if (longFramePosition < 0L) {
            longFramePosition = 0L;
        }
        this.setPlayCursor(longFramePosition);
        this.setPlayCursorInternal(longFramePosition, longFramePosition);
        this.fetchwriteData();
        this.checkFadeProgress(true);
        if (longFramePosition >= o_Playable.getFrameEndToPlay()) {
            this.stop();
            this.m_Status = 0;
            this.clearPlaying();
            this.m_FrameOldPlayCursor = this.m_FramePlayCursor;
            this.playRewind();
            return;
        }
    }

    public void setWaitForTrigger(boolean p_Wait) {
        this.m_WaitForTrigger = p_Wait;
    }

    public boolean getWaitForTrigger() {
        return this.m_WaitForTrigger;
    }

    public void setWillStopAtSceneBridge(LiveShowSceneBridge p_LiveShowSceneBridge) {
        this.m_WillStopAtSceneBridge = p_LiveShowSceneBridge;
    }

    public LiveShowSceneBridge getWillStopAtSceneBridge() {
        return this.m_WillStopAtSceneBridge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void letsRun() {
        if (this.m_Status == 2) {
            this.m_Status = 3;
            Object object = this.m_SyncPlay;
            synchronized (object) {
                this.m_SyncPlay.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.m_Closed) {
            Object object = this.m_SyncPlay;
            synchronized (object) {
                if (!this.m_ShouldRun) {
                    try {
                        this.m_SyncPlay.wait();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (this.m_Closed) {
                this.m_PlayThread = null;
                return;
            }
            if (!this.m_ShouldRun) continue;
            this.m_ShouldRun = false;
            object = this.m_SyncPlay;
            synchronized (object) {
                this.m_Status = 3;
            }
            this.notifyPlayListeners_PlayStart();
            try {
                this.fetchwriteData();
                if (this.m_PlaySynchronisizer != null) {
                    this.m_PlaySynchronisizer.callTriggerStart(this);
                }
                this.m_PlayStartTime = System.nanoTime();
                this.m_FramesRead = 0L;
            }
            catch (Exception e) {
                if (this.m_PlaySynchronisizer != null) {
                    this.m_PlaySynchronisizer.removePlayTriggerStart(this);
                    this.m_PlaySynchronisizer.removePlayTriggerSceneBridge(this);
                }
                this.m_ShouldRun = false;
                this.m_WaitFlag = false;
                this.m_StopFlag = true;
            }
            Playable o_Playable = this.m_Playable;
            while (!this.m_StopFlag && !this.m_WaitFlag && o_Playable != null && this.m_FramePlayCursor < o_Playable.getFrameEndToPlay()) {
                try {
                    this.fetchwriteData();
                }
                catch (Exception e) {
                    this.m_ShouldRun = false;
                    this.m_WaitFlag = false;
                    this.m_StopFlag = true;
                    continue;
                }
                this.checkFadeProgress(true);
                if (this.m_PauseAfterFadeIn) {
                    if (this.getPlayObject().getFadeInProgress() >= 1.0) {
                        this.m_ShouldRun = false;
                        this.m_WaitFlag = true;
                        this.m_FadeInPossible = false;
                    } else if (this.m_FramePlayCursor >= o_Playable.getFrameEndToPlay()) {
                        this.m_ShouldRun = false;
                        this.m_WaitFlag = true;
                        this.m_FadeInPossible = false;
                    }
                }
                o_Playable = this.m_Playable;
            }
            if (this.m_StopFlag && o_Playable != null) {
                o_Playable.resetFadeOutDirect();
            }
            this.clearPlaying();
            if (this.m_PlaySynchronisizer != null) {
                this.m_PlaySynchronisizer.callTriggerStop(this);
            }
            this.m_FrameOldPlayCursor = this.m_FramePlayCursor;
            this.notifyPlayListeners_PlayCursor(this.m_FrameOldPlayCursor, this.m_FramePlayCursor);
            if (o_Playable == null) {
                this.m_FramePlayCursor = 0L;
            } else if (!this.m_PauseAfterFadeIn && this.m_FramePlayCursor >= o_Playable.getFrameEndToPlay()) {
                this.m_StopFlag = true;
                this.playRewind();
                if (o_Playable instanceof LiveShowVIP) {
                    EventQueueHandler.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Play.this.notifyPlayListeners_TimelineEnd();
                        }
                    });
                }
                o_Playable.resetFadeOutDirect();
            }
            if (this.m_WaitFlag || this.m_PauseAfterFadeIn) {
                this.m_Status = 1;
                this.reworkPause();
                this.notifyPlayListeners_PlayPause();
                continue;
            }
            this.m_Status = 0;
            this.reworkStop();
            this.notifyPlayListeners_PlayStop();
        }
        this.m_PlayThread = null;
    }

    public void stop() {
        this.m_ShouldRun = false;
        this.m_WaitFlag = false;
        this.m_StopFlag = true;
        this.m_PauseAfterFadeIn = false;
        if (this.m_Status == 1) {
            this.m_Status = 0;
            this.notifyPlayListeners_PlayStop();
        }
    }

    public void stopInternal() {
        this.m_StopFlag = true;
    }

    public void stopAndWaitFor() {
        this.m_ShouldRun = false;
        if (!this.isRunning()) {
            // empty if block
        }
        this.m_StopFlag = true;
        if (this.m_Status == 1) {
            this.notifyPlayListeners_PlayStop();
        }
    }

    public void pause() {
        this.m_ShouldRun = false;
        this.m_WaitFlag = true;
    }

    public void stopAtBridge() {
        this.m_ShouldRun = false;
        this.m_WaitFlag = true;
    }

    protected void checkFadeProgress(boolean p_NotifyListeners) {
        double doubleFadeProgress;
        boolean boolFadeInPossible = false;
        boolean boolFadeOutPossible = false;
        boolean boolFadedIn = false;
        Playable.PlayObject o_PlayObject = this.getPlayObject();
        if (o_PlayObject == null) {
            doubleFadeProgress = 0.0;
            boolFadeInPossible = false;
            boolFadeInPossible = false;
            boolFadedIn = false;
        } else {
            doubleFadeProgress = o_PlayObject.getFadeProgress();
            boolFadeInPossible = false;
            boolFadeOutPossible = false;
            if (this.m_Status == 1) {
                if (this.getPlayObject().getFadeInProgress() < 1.0 || this.getPlayObject().getFadeOutProgress() < 1.0) {
                    boolFadeInPossible = true;
                }
                if (this.getPlayObject().getFadeOutProgress() >= 1.0 || this.getPlayObject().getFadeInProgress() > 0.0) {
                    boolFadeOutPossible = true;
                }
            } else {
                if (this.getPlayObject().getFadeInProgress() == 0.0 || this.getPlayObject().getFadeOutProgress() < 1.0 && this.getPlayObject().getFadeOutProgress() > 0.0) {
                    boolFadeInPossible = true;
                }
                if (this.getPlayObject().getFadeOutProgress() == 1.0 || this.getPlayObject().getFadeInProgress() < 1.0 && this.getPlayObject().getFadeInProgress() > 0.0) {
                    boolFadeOutPossible = true;
                }
            }
            if (this.getPlayObject().getFadeInProgress() == 1.0) {
                boolFadedIn = true;
            }
        }
        if (this.m_FadeInPossible != boolFadeInPossible || this.m_FadeOutPossible != boolFadeOutPossible) {
            this.m_FadeInPossible = boolFadeInPossible;
            this.m_FadeOutPossible = boolFadeOutPossible;
            if (p_NotifyListeners) {
                this.notifyPlayListeners_PlayFadePossibility(this.m_FadeInPossible, this.m_FadeOutPossible, doubleFadeProgress);
            }
        }
        if (this.m_FadedIn != boolFadedIn) {
            this.m_FadedIn = boolFadedIn;
            if (boolFadedIn) {
                this.m_WasFadedIn = true;
            }
            this.notifyPlayListeners_PlayFadedIn(this.m_FadedIn, doubleFadeProgress);
        }
    }

    public boolean getFadeInPossible() {
        this.checkFadeProgress(false);
        return this.m_FadeInPossible;
    }

    public boolean getFadeOutPossible() {
        this.checkFadeProgress(false);
        return this.m_FadeOutPossible;
    }

    public boolean getFadedIn() {
        this.checkFadeProgress(false);
        return this.m_FadedIn;
    }

    public boolean getWasFadedIn() {
        this.checkFadeProgress(false);
        return this.m_WasFadedIn;
    }

    public void playRewind() {
        if (this.getPlayCursor() == 0L) {
            return;
        }
        if (this.getPlayCursor() == 0L) {
            return;
        }
        this.setPlayCursor(0L);
        this.setPlayCursorInternal(0L, 0L);
        this.notifyPlayListeners_PlayRewind();
        if (this.m_Status == 1) {
            this.m_Status = 0;
            this.notifyPlayListeners_PlayStop();
        }
    }

    public void playFastForward() {
        if (this.getPlayCursor() == this.getFramePositionEnd()) {
            return;
        }
        this.stop();
        this.setPlayCursor(this.getFramePositionEnd() - 1L);
        this.setPlayCursorInternal(this.getFramePositionEnd() - 1L, this.getFramePositionEnd() - 1L);
        this.notifyPlayListeners_PlayFastForward();
    }

    public boolean isRunning() {
        return this.m_Status == 3;
    }

    public boolean isPaused() {
        return this.m_Status == 1;
    }

    public LiveShowSceneBridge getNextScene(boolean p_OnlyMainScenes) {
        LiveShowSceneBridge o_LiveShowSceneBridge = null;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return o_LiveShowSceneBridge;
        }
        if (this.m_Playable == null) {
            this.m_LiveCloseSemaphore.leaveWorkerSection();
            return o_LiveShowSceneBridge;
        }
        o_LiveShowSceneBridge = this.m_Playable.getLiveShowSceneBridge_Next(this.getPlayCursor(), p_OnlyMainScenes, true);
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return o_LiveShowSceneBridge;
    }

    public LiveShowSceneBridge getNextScene(long p_StartFrame, boolean p_OnlyMainScenes, boolean p_OnlyActiveBridges) {
        LiveShowSceneBridge o_LiveShowSceneBridge = null;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return o_LiveShowSceneBridge;
        }
        if (this.m_Playable == null) {
            this.m_LiveCloseSemaphore.leaveWorkerSection();
            return o_LiveShowSceneBridge;
        }
        o_LiveShowSceneBridge = this.m_Playable.getLiveShowSceneBridge_Next(p_StartFrame, p_OnlyMainScenes, p_OnlyActiveBridges);
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return o_LiveShowSceneBridge;
    }

    public LiveShowSceneBridge getNextScene_ToPlay(boolean p_OnlyMainScenes) {
        LiveShowSceneBridge o_LiveShowSceneBridge = null;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return o_LiveShowSceneBridge;
        }
        if (this.m_Playable == null) {
            this.m_LiveCloseSemaphore.leaveWorkerSection();
            return o_LiveShowSceneBridge;
        }
        o_LiveShowSceneBridge = this.m_Playable.getLiveShowSceneBridge_NextToPlay(this.getPlayCursor(), p_OnlyMainScenes);
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return o_LiveShowSceneBridge;
    }

    public LiveShowSceneBridge getPreviousScene(boolean p_OnlyMainScenes) {
        LiveShowSceneBridge o_LiveShowSceneBridge = null;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return o_LiveShowSceneBridge;
        }
        if (this.m_Playable == null) {
            this.m_LiveCloseSemaphore.leaveWorkerSection();
            return o_LiveShowSceneBridge;
        }
        o_LiveShowSceneBridge = this.m_Playable.getLiveShowSceneBridge_Previous(this.getPlayCursor(), p_OnlyMainScenes, true);
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return o_LiveShowSceneBridge;
    }

    public LiveShowSceneBridge getPreviousScene_ToPlay(boolean p_OnlyMainScenes) {
        LiveShowSceneBridge o_LiveShowSceneBridge = null;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return o_LiveShowSceneBridge;
        }
        if (this.m_Playable == null) {
            this.m_LiveCloseSemaphore.leaveWorkerSection();
            return o_LiveShowSceneBridge;
        }
        o_LiveShowSceneBridge = this.m_Playable.getLiveShowSceneBridge_PreviousToPlay(this.getPlayCursor(), p_OnlyMainScenes);
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return o_LiveShowSceneBridge;
    }

    public LiveShowSceneBridge getPreviousScene(long p_StartFrame, boolean p_OnlyMainScenes, boolean p_OnlyActiveBridges) {
        LiveShowSceneBridge o_LiveShowSceneBridge = null;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return o_LiveShowSceneBridge;
        }
        if (this.m_Playable == null) {
            this.m_LiveCloseSemaphore.leaveWorkerSection();
            return o_LiveShowSceneBridge;
        }
        o_LiveShowSceneBridge = this.m_Playable.getLiveShowSceneBridge_Previous(p_StartFrame, p_OnlyMainScenes, p_OnlyActiveBridges);
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return o_LiveShowSceneBridge;
    }

    protected abstract void fetchwriteData();

    public abstract void addLiveShowObjectInterface_Jingle(LiveShowObjectInterface var1);

    public abstract void removeLiveShowObjectInterface_Jingle(LiveShowObjectInterface var1);

    public abstract int getLiveShowObjectInterfaces_JingleCount();

    public abstract void fetchWriteLiveShowObjectInterfaces_Jingle(long var1, long var3);

    public abstract LiveShowObjectInterface getLiveShowObjectInterface_Jingle(int var1);

    public void setEditModeOn(boolean p_EditModeOn) {
        if (this.m_IsEditModeOn == p_EditModeOn) {
            return;
        }
        this.m_IsEditModeOn = p_EditModeOn;
        this.notifyPlayListeners_ModeEditCursor(p_EditModeOn);
    }

    public boolean getEditModeOn() {
        return this.m_IsEditModeOn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEditCursor(long p_FramePosition) {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        if (this.m_Playable == null) {
            this.m_LiveCloseSemaphore.leaveWorkerSection();
            return;
        }
        Object object = this.m_SyncFramePosition;
        synchronized (object) {
            if (p_FramePosition < 0L) {
                p_FramePosition = 0L;
            }
            if (p_FramePosition > this.m_Playable.getFrameEnd()) {
                p_FramePosition = this.m_Playable.getFrameEnd();
            }
            this.notifyPlayListeners_EditCursorSet(p_FramePosition);
            this.m_FrameEditCursor = p_FramePosition;
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    public long getEditCursor() {
        return this.m_FrameEditCursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlayCursor(long p_FramePosition) {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        if (this.m_Playable == null) {
            this.m_LiveCloseSemaphore.leaveWorkerSection();
            return;
        }
        Object object = this.m_SyncFramePosition;
        synchronized (object) {
            if (p_FramePosition < 0L) {
                p_FramePosition = 0L;
            }
            if (p_FramePosition > this.m_Playable.getFrameEnd()) {
                p_FramePosition = this.m_Playable.getFrameEnd();
            }
            if (this.m_FramePlayCursor != p_FramePosition) {
                this.m_PlayCursorSet = true;
            }
            this.m_FramePlayCursor = p_FramePosition;
            this.notifyPlayListeners_PlayCursorSet(p_FramePosition);
            this.m_FrameOldPlayCursor = p_FramePosition;
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    public void setPlayCursorInternal(long p_OldFramePosition, long p_FramePosition) {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        if (this.m_Playable == null) {
            this.m_LiveCloseSemaphore.leaveWorkerSection();
            return;
        }
        boolean boolNotify = false;
        if (p_FramePosition < 0L) {
            p_FramePosition = 0L;
        }
        if (p_FramePosition > this.m_Playable.getFrameEnd()) {
            p_FramePosition = this.m_Playable.getFrameEnd();
        }
        if (this.m_FramePlayCursor != p_FramePosition || this.m_FrameOldPlayCursor != p_OldFramePosition) {
            boolNotify = true;
        }
        this.m_FramePlayCursor = p_FramePosition;
        this.m_FrameOldPlayCursor = p_OldFramePosition;
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        this.notifyPlayListeners_PlayCursor(this.m_FrameOldPlayCursor, this.m_FramePlayCursor);
        this.m_PlayCursorSet = false;
    }

    public long getPlayCursor() {
        return this.m_FramePlayCursor;
    }

    public long getOldPlayCursor() {
        return this.m_FrameOldPlayCursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPlayListener(PlayListener p_PlayListener) {
        if (p_PlayListener == null) {
            return false;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        boolean boolAdded = false;
        Object object = this.m_SyncPlayListeners;
        synchronized (object) {
            if (this.m_PlayListeners != null && !this.m_PlayListeners.contains(p_PlayListener)) {
                this.m_PlayListeners.add(p_PlayListener);
                boolAdded = true;
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return boolAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePlayListener(PlayListener p_PlayListener) {
        if (p_PlayListener == null) {
            return false;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        boolean boolRemoved = false;
        Object object = this.m_SyncPlayListeners;
        synchronized (object) {
            if (this.m_PlayListeners != null) {
                boolRemoved = this.m_PlayListeners.remove(p_PlayListener);
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return boolRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyPlayListeners_PlayCursorSet(long p_PlayCursor) {
        ArrayList<PlayListener> o_PlayListeners;
        Object object = this.m_SyncPlayListeners;
        synchronized (object) {
            if (this.m_PlayListeners == null) {
                return;
            }
            o_PlayListeners = new ArrayList<PlayListener>(this.m_PlayListeners.size());
            o_PlayListeners.addAll(this.m_PlayListeners);
        }
        for (int intListener = 0; intListener < o_PlayListeners.size(); ++intListener) {
            PlayListener o_Listener = (PlayListener)o_PlayListeners.get(intListener);
            o_Listener.eventPlayCursorSet(this, p_PlayCursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyPlayListeners_PlayCursor(long p_OldPlayCursor, long p_PlayCursor) {
        ArrayList<PlayListener> o_PlayListeners;
        Object object = this.m_SyncPlayListeners;
        synchronized (object) {
            if (this.m_PlayListeners == null) {
                return;
            }
            o_PlayListeners = new ArrayList<PlayListener>(this.m_PlayListeners.size());
            o_PlayListeners.addAll(this.m_PlayListeners);
        }
        for (int intListener = 0; intListener < o_PlayListeners.size(); ++intListener) {
            PlayListener o_Listener = (PlayListener)o_PlayListeners.get(intListener);
            o_Listener.eventPlayCursor(this, p_OldPlayCursor, p_PlayCursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyPlayListeners_PlayStart() {
        ArrayList<PlayListener> o_PlayListeners;
        Object object = this.m_SyncPlayListeners;
        synchronized (object) {
            if (this.m_PlayListeners == null) {
                return;
            }
            o_PlayListeners = new ArrayList<PlayListener>(this.m_PlayListeners.size());
            o_PlayListeners.addAll(this.m_PlayListeners);
        }
        for (int intListener = 0; intListener < o_PlayListeners.size(); ++intListener) {
            PlayListener o_Listener = (PlayListener)o_PlayListeners.get(intListener);
            o_Listener.eventPlayStart(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyPlayListeners_PlayStop() {
        ArrayList<PlayListener> o_PlayListeners;
        Object object = this.m_SyncPlayListeners;
        synchronized (object) {
            if (this.m_PlayListeners == null) {
                return;
            }
            o_PlayListeners = new ArrayList<PlayListener>(this.m_PlayListeners.size());
            o_PlayListeners.addAll(this.m_PlayListeners);
        }
        for (int intListener = 0; intListener < o_PlayListeners.size(); ++intListener) {
            PlayListener o_Listener = (PlayListener)o_PlayListeners.get(intListener);
            o_Listener.eventPlayStop(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyPlayListeners_PlayPause() {
        ArrayList<PlayListener> o_PlayListeners;
        Object object = this.m_SyncPlayListeners;
        synchronized (object) {
            if (this.m_PlayListeners == null) {
                return;
            }
            o_PlayListeners = new ArrayList<PlayListener>(this.m_PlayListeners.size());
            o_PlayListeners.addAll(this.m_PlayListeners);
        }
        for (int intListener = 0; intListener < o_PlayListeners.size(); ++intListener) {
            PlayListener o_Listener = (PlayListener)o_PlayListeners.get(intListener);
            o_Listener.eventPlayPause(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyPlayListeners_PlayFadePossibility(boolean p_FadeInPossible, boolean p_FadeOutPossible, double p_FadeProgress) {
        ArrayList<PlayListener> o_PlayListeners;
        Object object = this.m_SyncPlayListeners;
        synchronized (object) {
            if (this.m_PlayListeners == null) {
                return;
            }
            o_PlayListeners = new ArrayList<PlayListener>(this.m_PlayListeners.size());
            o_PlayListeners.addAll(this.m_PlayListeners);
        }
        for (int intListener = 0; intListener < o_PlayListeners.size(); ++intListener) {
            PlayListener o_Listener = (PlayListener)o_PlayListeners.get(intListener);
            o_Listener.eventPlayFadePossibility(this, p_FadeInPossible, p_FadeOutPossible, p_FadeProgress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyPlayListeners_PlayFadedIn(boolean p_FadedIn, double p_FadeProgress) {
        ArrayList<PlayListener> o_PlayListeners;
        Object object = this.m_SyncPlayListeners;
        synchronized (object) {
            if (this.m_PlayListeners == null) {
                return;
            }
            o_PlayListeners = new ArrayList<PlayListener>(this.m_PlayListeners.size());
            o_PlayListeners.addAll(this.m_PlayListeners);
        }
        for (int intListener = 0; intListener < o_PlayListeners.size(); ++intListener) {
            PlayListener o_Listener = (PlayListener)o_PlayListeners.get(intListener);
            o_Listener.eventPlayFadedIn(this, p_FadedIn, p_FadeProgress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyPlayListeners_PlayRewind() {
        ArrayList<PlayListener> o_PlayListeners;
        Object object = this.m_SyncPlayListeners;
        synchronized (object) {
            if (this.m_PlayListeners == null) {
                return;
            }
            o_PlayListeners = new ArrayList<PlayListener>(this.m_PlayListeners.size());
            o_PlayListeners.addAll(this.m_PlayListeners);
        }
        for (int intListener = 0; intListener < o_PlayListeners.size(); ++intListener) {
            PlayListener o_Listener = (PlayListener)o_PlayListeners.get(intListener);
            o_Listener.eventPlayRewind(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyPlayListeners_PlayFastForward() {
        ArrayList<PlayListener> o_PlayListeners;
        Object object = this.m_SyncPlayListeners;
        synchronized (object) {
            if (this.m_PlayListeners == null) {
                return;
            }
            o_PlayListeners = new ArrayList<PlayListener>(this.m_PlayListeners.size());
            o_PlayListeners.addAll(this.m_PlayListeners);
        }
        for (int intListener = 0; intListener < o_PlayListeners.size(); ++intListener) {
            PlayListener o_Listener = (PlayListener)o_PlayListeners.get(intListener);
            o_Listener.eventPlayFastForward(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyPlayListeners_Closing() {
        PlayListener o_Listener;
        ArrayList<PlayListener> o_PlayListeners;
        Object object = this.m_SyncPlayListeners;
        synchronized (object) {
            if (this.m_PlayListeners == null) {
                return;
            }
            o_PlayListeners = new ArrayList<PlayListener>(this.m_PlayListeners.size());
            int intListenerCount = this.m_PlayListeners.size();
            for (int intListener = intListenerCount - 1; intListener >= 0 && this.m_PlayListeners.size() > 0; --intListener) {
                o_Listener = this.m_PlayListeners.get(intListener);
                o_PlayListeners.add(o_Listener);
                this.m_PlayListeners.remove(o_Listener);
            }
        }
        for (int intListener = 0; intListener < o_PlayListeners.size(); ++intListener) {
            o_Listener = (PlayListener)o_PlayListeners.get(intListener);
            o_Listener.eventPlayClosing(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyPlayListeners_Error(Exception p_Exception, String p_Remark) {
        ArrayList<PlayListener> o_PlayListeners;
        Object object = this.m_SyncPlayListeners;
        synchronized (object) {
            if (this.m_PlayListeners == null) {
                return;
            }
            o_PlayListeners = new ArrayList<PlayListener>(this.m_PlayListeners.size());
            o_PlayListeners.addAll(this.m_PlayListeners);
        }
        for (int intListener = 0; intListener < o_PlayListeners.size(); ++intListener) {
            PlayListener o_Listener = (PlayListener)o_PlayListeners.get(intListener);
            o_Listener.eventPlayError(this, p_Exception, p_Remark);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyPlayListeners_ModeEditCursor(boolean p_EditModeOn) {
        ArrayList<PlayListener> o_PlayListeners;
        Object object = this.m_SyncPlayListeners;
        synchronized (object) {
            if (this.m_PlayListeners == null) {
                return;
            }
            o_PlayListeners = new ArrayList<PlayListener>(this.m_PlayListeners.size());
            o_PlayListeners.addAll(this.m_PlayListeners);
        }
        for (int intListener = 0; intListener < o_PlayListeners.size(); ++intListener) {
            PlayListener o_Listener = (PlayListener)o_PlayListeners.get(intListener);
            o_Listener.eventEditModeOn(this, p_EditModeOn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyPlayListeners_EditCursorSet(long p_PlayCursor) {
        ArrayList<PlayListener> o_PlayListeners;
        Object object = this.m_SyncPlayListeners;
        synchronized (object) {
            if (this.m_PlayListeners == null) {
                return;
            }
            o_PlayListeners = new ArrayList<PlayListener>(this.m_PlayListeners.size());
            o_PlayListeners.addAll(this.m_PlayListeners);
        }
        for (int intListener = 0; intListener < o_PlayListeners.size(); ++intListener) {
            PlayListener o_Listener = (PlayListener)o_PlayListeners.get(intListener);
            o_Listener.eventEditCursorSet(this, p_PlayCursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyPlayListeners_TimelineEnd() {
        ArrayList<PlayListener> o_PlayListeners;
        Object object = this.m_SyncPlayListeners;
        synchronized (object) {
            if (this.m_PlayListeners == null) {
                return;
            }
            o_PlayListeners = new ArrayList<PlayListener>(this.m_PlayListeners.size());
            o_PlayListeners.addAll(this.m_PlayListeners);
        }
        for (int intListener = 0; intListener < o_PlayListeners.size(); ++intListener) {
            PlayListener o_Listener = (PlayListener)o_PlayListeners.get(intListener);
            o_Listener.eventPlayTimelineEnd(this);
        }
    }

    public static PlaySynchronisizer createPlaySynchronisizer() {
        return new PlaySynchronisizer();
    }

    public static class PlaySynchronisizer
    implements PlayListener {
        private ArrayList<Play> m_ArrayListPlays;
        private final Object m_SyncPlays = new Object();
        private ArrayList<Play> m_ArrayListPlaysStart;
        private final Object m_SyncPlayTriggerStart = new Object();
        private ArrayList<Play> m_ArrayListPlaysSceneBridge;
        private final Object m_SyncPlayTriggerPlaySceneBridge = new Object();
        private ArrayList<Play> m_ArrayListPlaysStop;
        private ArrayList<Long> m_ArrayListPlaysStopAtFrame;
        private final Object m_SyncPlayTriggerStop = new Object();
        private Thread m_ThreadTrigger;
        private Runnable m_RunnableTriggerNotify;
        private final Object m_SyncTrigger = new Object();

        public PlaySynchronisizer() {
            this.initMembers();
        }

        private void initMembers() {
            this.m_ArrayListPlays = new ArrayList();
            this.m_ArrayListPlaysStart = new ArrayList();
            this.m_ArrayListPlaysSceneBridge = new ArrayList();
            this.m_ArrayListPlaysStop = new ArrayList();
            this.m_ArrayListPlaysStopAtFrame = new ArrayList();
            this.m_RunnableTriggerNotify = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = m_SyncTrigger;
                    synchronized (object) {
                        m_SyncTrigger.notifyAll();
                    }
                }
            };
        }

        public void close() {
            for (int intPlay = this.getPlayCount() - 1; intPlay >= 0; --intPlay) {
                Play o_Play = this.getPlay(intPlay);
                if (o_Play == null) continue;
                this.removePlay(o_Play);
                o_Play.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addPlay(Play p_Play) {
            if (p_Play == null) {
                return;
            }
            Object object = this.m_SyncPlays;
            synchronized (object) {
                if (this.m_ArrayListPlays.contains(p_Play)) {
                    return;
                }
                this.m_ArrayListPlays.add(p_Play);
                p_Play.addPlayListener(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removePlay(Play p_Play) {
            if (p_Play == null) {
                return;
            }
            Object object = this.m_SyncPlays;
            synchronized (object) {
                if (!this.m_ArrayListPlays.contains(p_Play)) {
                    return;
                }
                p_Play.removePlayListener(this);
                this.m_ArrayListPlays.remove(p_Play);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsPlay(Play p_Play) {
            Object object = this.m_SyncPlays;
            synchronized (object) {
                return this.m_ArrayListPlays.contains(p_Play);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getPlayCount() {
            Object object = this.m_SyncPlays;
            synchronized (object) {
                return this.m_ArrayListPlays.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Play getPlay(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            Object object = this.m_SyncPlays;
            synchronized (object) {
                if (p_Index >= this.m_ArrayListPlays.size()) {
                    return null;
                }
                return this.m_ArrayListPlays.get(p_Index);
            }
        }

        public int getPlayStartedCount() {
            int intPlaying = 0;
            int intStopped = 0;
            int intWaiting = 0;
            int intStatus = 0;
            for (int intPlay = 0; intPlay < this.getPlayCount(); ++intPlay) {
                Play o_Play = this.getPlay(intPlay);
                if (o_Play == null) continue;
                intStatus = o_Play.getStatus();
                if (intStatus == 3 || intStatus == 2) {
                    ++intPlaying;
                    continue;
                }
                if (intStatus != 9 && intStatus != 0 && intStatus != 1) continue;
                ++intStopped;
                if (intStatus != 1) continue;
                ++intWaiting;
            }
            return intPlaying;
        }

        public int getPlayStoppedCount() {
            int intPlaying = 0;
            int intStopped = 0;
            int intWaiting = 0;
            int intStatus = 0;
            for (int intPlay = 0; intPlay < this.getPlayCount(); ++intPlay) {
                Play o_Play = this.getPlay(intPlay);
                if (o_Play == null) continue;
                intStatus = o_Play.getStatus();
                if (intStatus == 3 || intStatus == 2) {
                    ++intPlaying;
                    continue;
                }
                if (intStatus != 9 && intStatus != 0 && intStatus != 1) continue;
                ++intStopped;
                if (intStatus != 1) continue;
                ++intWaiting;
            }
            return intStopped;
        }

        public int getPlayWaitingCount() {
            int intPlaying = 0;
            int intStopped = 0;
            int intWaiting = 0;
            int intStatus = 0;
            for (int intPlay = 0; intPlay < this.getPlayCount(); ++intPlay) {
                Play o_Play = this.getPlay(intPlay);
                if (o_Play == null) continue;
                intStatus = o_Play.getStatus();
                if (intStatus == 3 || intStatus == 2) {
                    ++intPlaying;
                    continue;
                }
                if (intStatus != 9 && intStatus != 0 && intStatus != 1) continue;
                ++intStopped;
                if (intStatus != 1) continue;
                ++intWaiting;
            }
            return intWaiting;
        }

        public int getPlayFadeInPossibleCount() {
            int intFadInPossible = 0;
            for (int intPlay = 0; intPlay < this.getPlayCount(); ++intPlay) {
                Play o_Play = this.getPlay(intPlay);
                if (o_Play == null || !o_Play.getFadeInPossible()) continue;
                ++intFadInPossible;
            }
            return intFadInPossible;
        }

        public int getPlayFadeOutPossibleCount() {
            int intFadOutPossible = 0;
            for (int intPlay = 0; intPlay < this.getPlayCount(); ++intPlay) {
                Play o_Play = this.getPlay(intPlay);
                if (o_Play == null || !o_Play.getFadeOutPossible()) continue;
                ++intFadOutPossible;
            }
            return intFadOutPossible;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void callTriggerStart(Play p_Play) {
            Object object = this.m_SyncTrigger;
            synchronized (object) {
                Play o_Play;
                int intPlay;
                if (!this.containsPlayTriggerStart(p_Play) && !this.containsPlayTriggerSceneBridge(p_Play)) {
                    return;
                }
                p_Play.setWaitForTrigger(true);
                boolean boolAllWaitForTrigger = true;
                for (intPlay = 0; intPlay < this.getPlayTriggerStartCount(); ++intPlay) {
                    o_Play = this.getPlayTriggerStart(intPlay);
                    if (o_Play == null || o_Play.getWaitForTrigger()) continue;
                    boolAllWaitForTrigger = false;
                    break;
                }
                for (intPlay = 0; intPlay < this.getPlaysTriggerSceneBridgeCount(); ++intPlay) {
                    o_Play = this.getPlayTriggerSceneBridge(intPlay);
                    if (o_Play == null || o_Play.getWaitForTrigger()) continue;
                    boolAllWaitForTrigger = false;
                    break;
                }
                if (boolAllWaitForTrigger) {
                    this.m_SyncTrigger.notifyAll();
                } else {
                    try {
                        this.m_SyncTrigger.wait(120L);
                    }
                    catch (Exception e) {
                        System.err.println("Play callTriggerStart error: " + e.getMessage());
                    }
                }
                p_Play.setWaitForTrigger(false);
                this.removePlayTriggerStart(p_Play);
                this.removePlayTriggerSceneBridge(p_Play);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addPlayTriggerStart(Play p_Play) {
            if (p_Play == null) {
                return;
            }
            if (!p_Play.getActive()) {
                return;
            }
            Object object = this.m_SyncPlayTriggerStart;
            synchronized (object) {
                if (this.m_ArrayListPlaysStart.contains(p_Play)) {
                    return;
                }
                this.m_ArrayListPlaysStart.add(p_Play);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removePlayTriggerStart(Play p_Play) {
            if (p_Play == null) {
                return;
            }
            Object object = this.m_SyncPlayTriggerStart;
            synchronized (object) {
                if (!this.m_ArrayListPlaysStart.contains(p_Play)) {
                    return;
                }
                this.m_ArrayListPlaysStart.remove(p_Play);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearPlaysTriggerStart() {
            Object object = this.m_SyncPlayTriggerStart;
            synchronized (object) {
                this.m_ArrayListPlaysStart.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getPlayTriggerStartCount() {
            Object object = this.m_SyncPlayTriggerStart;
            synchronized (object) {
                return this.m_ArrayListPlaysStart.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Play getPlayTriggerStart(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            Object object = this.m_SyncPlayTriggerStart;
            synchronized (object) {
                if (p_Index >= this.m_ArrayListPlaysStart.size()) {
                    return null;
                }
                return this.m_ArrayListPlaysStart.get(p_Index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsPlayTriggerStart(Play p_Play) {
            Object object = this.m_SyncPlayTriggerStart;
            synchronized (object) {
                return this.m_ArrayListPlaysStart.contains(p_Play);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addPlayTriggerSceneBridge(Play p_Play) {
            if (p_Play == null) {
                return;
            }
            if (!p_Play.getActive()) {
                return;
            }
            Object object = this.m_SyncPlayTriggerPlaySceneBridge;
            synchronized (object) {
                if (this.m_ArrayListPlaysSceneBridge.contains(p_Play)) {
                    return;
                }
                this.m_ArrayListPlaysSceneBridge.add(p_Play);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removePlayTriggerSceneBridge(Play p_Play) {
            if (p_Play == null) {
                return;
            }
            Object object = this.m_SyncPlayTriggerPlaySceneBridge;
            synchronized (object) {
                if (!this.m_ArrayListPlaysSceneBridge.contains(p_Play)) {
                    return;
                }
                this.m_ArrayListPlaysSceneBridge.remove(p_Play);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearPlaysTriggerSceneBridge() {
            Object object = this.m_SyncPlayTriggerPlaySceneBridge;
            synchronized (object) {
                this.m_ArrayListPlaysSceneBridge.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getPlaysTriggerSceneBridgeCount() {
            Object object = this.m_SyncPlayTriggerPlaySceneBridge;
            synchronized (object) {
                return this.m_ArrayListPlaysSceneBridge.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Play getPlayTriggerSceneBridge(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            Object object = this.m_SyncPlayTriggerPlaySceneBridge;
            synchronized (object) {
                if (p_Index >= this.m_ArrayListPlaysSceneBridge.size()) {
                    return null;
                }
                return this.m_ArrayListPlaysSceneBridge.get(p_Index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsPlayTriggerSceneBridge(Play p_Play) {
            if (p_Play == null) {
                return false;
            }
            Object object = this.m_SyncPlayTriggerPlaySceneBridge;
            synchronized (object) {
                return this.m_ArrayListPlaysSceneBridge.contains(p_Play);
            }
        }

        public void actionStartPlaysSceneBridge() {
            int intPlayTriggerSceneBridgeCount = this.getPlaysTriggerSceneBridgeCount();
            for (int intPlay = 0; intPlay < intPlayTriggerSceneBridgeCount; ++intPlay) {
                Play o_Play = this.getPlayTriggerSceneBridge(intPlay);
                if (o_Play == null) continue;
                o_Play.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void callTriggerStop(Play p_Play) {
            Object object = this.m_SyncTrigger;
            synchronized (object) {
                if (!this.containsPlayTriggerStop(p_Play)) {
                    return;
                }
                p_Play.setWaitForTrigger(true);
                boolean boolAllWaitForTrigger = true;
                for (int intPlay = 0; intPlay < this.getPlaysTriggerStopCount(); ++intPlay) {
                    Play o_Play = this.getPlayTriggerStop(intPlay);
                    if (o_Play == null || o_Play.getWaitForTrigger()) continue;
                    boolAllWaitForTrigger = false;
                    break;
                }
                if (boolAllWaitForTrigger) {
                    this.m_SyncTrigger.notifyAll();
                }
                try {
                    this.m_SyncTrigger.wait(120L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                p_Play.setWaitForTrigger(false);
            }
            if (p_Play.getPlayCursor() > this.getPlayTriggerStopAtFrame(p_Play) + p_Play.getBufferDelayFrames()) {
                p_Play.setPlayCursor(p_Play.getPlayCursor() - p_Play.getBufferDelayFrames());
            }
            this.removePlayTriggerStop(p_Play);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addPlayTriggerStop(Play p_Play) {
            if (p_Play == null) {
                return;
            }
            if (!p_Play.getActive()) {
                return;
            }
            Object object = this.m_SyncPlayTriggerStop;
            synchronized (object) {
                if (this.m_ArrayListPlaysStop.contains(p_Play)) {
                    return;
                }
                this.m_ArrayListPlaysStop.add(p_Play);
                this.m_ArrayListPlaysStopAtFrame.add(p_Play.getPlayCursor());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removePlayTriggerStop(Play p_Play) {
            if (p_Play == null) {
                return;
            }
            Object object = this.m_SyncPlayTriggerStop;
            synchronized (object) {
                if (!this.m_ArrayListPlaysStop.contains(p_Play)) {
                    return;
                }
                int intPlayIndex = this.m_ArrayListPlaysStop.indexOf(p_Play);
                this.m_ArrayListPlaysStop.remove(p_Play);
                this.m_ArrayListPlaysStopAtFrame.remove(intPlayIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearPlaysTriggerStop() {
            Object object = this.m_SyncPlayTriggerStop;
            synchronized (object) {
                this.m_ArrayListPlaysStop.clear();
                this.m_ArrayListPlaysStopAtFrame.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getPlaysTriggerStopCount() {
            Object object = this.m_SyncPlayTriggerStop;
            synchronized (object) {
                return this.m_ArrayListPlaysStop.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Play getPlayTriggerStop(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            Object object = this.m_SyncPlayTriggerStop;
            synchronized (object) {
                if (p_Index >= this.m_ArrayListPlaysStop.size()) {
                    return null;
                }
                return this.m_ArrayListPlaysStop.get(p_Index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getPlayTriggerStopAtFrame(Play p_Play) {
            if (p_Play == null) {
                return 0L;
            }
            Object object = this.m_SyncPlayTriggerStop;
            synchronized (object) {
                int intIndex = this.m_ArrayListPlaysStop.indexOf(p_Play);
                if (intIndex < 0) {
                    return 0L;
                }
                if (intIndex >= this.m_ArrayListPlaysStopAtFrame.size()) {
                    return 0L;
                }
                return this.m_ArrayListPlaysStopAtFrame.get(intIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean containsPlayTriggerStop(Play p_Play) {
            if (p_Play == null) {
                return false;
            }
            Object object = this.m_SyncPlayTriggerStop;
            synchronized (object) {
                return this.m_ArrayListPlaysStop.contains(p_Play);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPlayStart() {
            Play o_Play;
            int intPlay;
            Object object = this.m_SyncTrigger;
            synchronized (object) {
                if (this.getPlayCount() > 1) {
                    this.clearPlaysTriggerStart();
                }
                for (intPlay = 0; intPlay < this.getPlayCount(); ++intPlay) {
                    o_Play = this.getPlay(intPlay);
                    if (o_Play == null || o_Play.getStatus() == 9 || o_Play.getStatus() == 3 || o_Play.getStatus() == 2) continue;
                    this.addPlayTriggerStart(o_Play);
                }
            }
            int intPlayTriggerStartCount = this.getPlayTriggerStartCount();
            for (intPlay = 0; intPlay < intPlayTriggerStartCount; ++intPlay) {
                o_Play = this.getPlayTriggerStart(intPlay);
                if (o_Play == null || o_Play.getStatus() == 9 || o_Play.getStatus() == 3 || o_Play.getStatus() == 2) continue;
                o_Play.start();
            }
        }

        public boolean isAllPlaying() {
            for (int intPlay = 0; intPlay < this.getPlayCount(); ++intPlay) {
                Play o_Play = this.getPlay(intPlay);
                if (o_Play == null || o_Play.getStatus() == 9 || o_Play.getStatus() == 3 || o_Play.getStatus() == 2) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPlayFadeIn() {
            Play o_Play;
            Object object = this.m_SyncTrigger;
            synchronized (object) {
                if (this.getPlayCount() > 1) {
                    this.clearPlaysTriggerStart();
                }
                for (int intPlay = 0; intPlay < this.getPlayCount(); ++intPlay) {
                    o_Play = this.getPlay(intPlay);
                    if (o_Play == null || o_Play.getStatus() == 9 || o_Play.getStatus() == 2) continue;
                    this.addPlayTriggerStart(o_Play);
                }
            }
            for (int intPlay = 0; intPlay < this.getPlayTriggerStartCount(); ++intPlay) {
                o_Play = this.getPlayTriggerStart(intPlay);
                if (o_Play == null || o_Play.getStatus() == 9 || o_Play.getStatus() == 2) continue;
                o_Play.fadeIn();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPlayFadeOut() {
            Play o_Play;
            Object object = this.m_SyncTrigger;
            synchronized (object) {
                if (this.getPlayCount() > 1) {
                    this.clearPlaysTriggerStart();
                }
                for (int intPlay = 0; intPlay < this.getPlayCount(); ++intPlay) {
                    o_Play = this.getPlay(intPlay);
                    if (o_Play == null || o_Play.getStatus() == 9 || o_Play.getStatus() == 3 || o_Play.getStatus() == 2) continue;
                    this.addPlayTriggerStart(o_Play);
                }
            }
            for (int intPlay = 0; intPlay < this.getPlayTriggerStartCount(); ++intPlay) {
                o_Play = this.getPlayTriggerStart(intPlay);
                if (o_Play == null || o_Play.getStatus() == 9 || o_Play.getStatus() == 3 || o_Play.getStatus() == 2) continue;
                o_Play.fadeOut();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPlayFadeOutDirect() {
            Play o_Play;
            Object object = this.m_SyncTrigger;
            synchronized (object) {
                if (this.getPlayCount() > 1) {
                    this.clearPlaysTriggerStart();
                }
                for (int intPlay = 0; intPlay < this.getPlayCount(); ++intPlay) {
                    o_Play = this.getPlay(intPlay);
                    if (o_Play == null || o_Play.getStatus() == 9 || o_Play.getStatus() != 3 && o_Play.getStatus() != 1 && o_Play.getStatus() != 2) continue;
                    this.addPlayTriggerStop(o_Play);
                }
            }
            for (int intPlay = this.getPlaysTriggerStopCount() - 1; intPlay >= 0; --intPlay) {
                o_Play = this.getPlayTriggerStop(intPlay);
                if (o_Play == null || o_Play.getStatus() == 9 || o_Play.getStatus() != 3 && o_Play.getStatus() != 1 && o_Play.getStatus() != 2) continue;
                o_Play.fadeOutDirect();
                this.removePlayTriggerStop(o_Play);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPlayPause() {
            Play o_Play;
            ArrayList<Play> o_ArrayListRunning = new ArrayList<Play>(this.getPlayCount());
            Object object = this.m_SyncTrigger;
            synchronized (object) {
                this.clearPlaysTriggerStop();
                for (int intPlay = 0; intPlay < this.getPlayCount(); ++intPlay) {
                    o_Play = this.getPlay(intPlay);
                    if (o_Play == null || o_Play.getStatus() == 9 || !o_Play.isRunning()) continue;
                    this.addPlayTriggerStop(o_Play);
                    o_ArrayListRunning.add(o_Play);
                }
            }
            for (int intPlay = 0; intPlay < o_ArrayListRunning.size(); ++intPlay) {
                o_Play = (Play)o_ArrayListRunning.get(intPlay);
                if (o_Play == null) continue;
                o_Play.pause();
            }
        }

        public void actionPlayStop() {
            for (int intPlay = 0; intPlay < this.getPlayCount(); ++intPlay) {
                Play o_Play = this.getPlay(intPlay);
                if (o_Play == null || o_Play.getStatus() == 9) continue;
                o_Play.stop();
            }
            this.actionPlayRewind();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPlayStartStop() {
            boolean boolOneIsRunning = false;
            Object object = this.m_SyncTrigger;
            synchronized (object) {
                for (int intPlay = 0; intPlay < this.getPlayCount(); ++intPlay) {
                    Play o_Play = this.getPlay(intPlay);
                    if (o_Play == null || o_Play.getStatus() == 9 || o_Play.getStatus() != 3 && o_Play.getStatus() != 1) continue;
                    boolOneIsRunning = true;
                }
            }
            if (boolOneIsRunning) {
                this.actionPlayStop();
            } else {
                this.actionPlayStart();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPlayStartFadeOut() {
            boolean boolOneIsRunning = false;
            Object object = this.m_SyncTrigger;
            synchronized (object) {
                for (int intPlay = 0; intPlay < this.getPlayCount(); ++intPlay) {
                    Play o_Play = this.getPlay(intPlay);
                    if (o_Play == null || o_Play.getStatus() == 9 || o_Play.getStatus() != 3 && o_Play.getStatus() != 1) continue;
                    boolOneIsRunning = true;
                }
            }
            if (boolOneIsRunning) {
                this.actionPlayFadeOutDirect();
            } else {
                this.actionPlayStart();
            }
        }

        public void actionPlayRewind() {
            for (int intPlay = 0; intPlay < this.getPlayCount(); ++intPlay) {
                Play o_Play = this.getPlay(intPlay);
                if (o_Play == null || o_Play.getStatus() == 9) continue;
                o_Play.playRewind();
            }
        }

        public void actionPlayFastForward() {
            for (int intPlay = 0; intPlay < this.getPlayCount(); ++intPlay) {
                Play o_Play = this.getPlay(intPlay);
                if (o_Play == null || o_Play.getStatus() == 9) continue;
                o_Play.playFastForward();
            }
        }

        @Override
        public void eventPlayStart(Play p_Play) {
        }

        @Override
        public void eventPlayStop(Play p_Play) {
        }

        @Override
        public void eventPlayPause(Play p_Play) {
        }

        @Override
        public void eventPlayRewind(Play p_Play) {
        }

        @Override
        public void eventPlayFastForward(Play p_Play) {
        }

        @Override
        public void eventPlayFadePossibility(Play p_Play, boolean p_FadeInPossible, boolean p_FadeOutPossible, double p_FadeProgress) {
        }

        @Override
        public void eventPlayFadedIn(Play p_Play, boolean p_FadedIn, double p_FadeProgress) {
        }

        @Override
        public long eventPlayCheckRead(Play p_Play, long p_FrameStart, long p_FramesToRead) {
            return p_FramesToRead;
        }

        @Override
        public void eventEditModeOn(Play p_Play, boolean p_EditModeOn) {
        }

        @Override
        public void eventEditCursorSet(Play p_Play, long p_PlayCursor) {
        }

        @Override
        public void eventPlayCursorSet(Play p_Play, long p_PlayCursor) {
        }

        @Override
        public void eventPlayCursor(Play p_Play, long p_OldPlayCursor, long p_PlayCursor) {
        }

        @Override
        public void eventPlayClosing(Play p_Play) {
            this.removePlay(p_Play);
        }

        @Override
        public void eventPlayError(Play p_Play, Exception p_Exception, String p_Remark) {
        }

        @Override
        public void eventPlayTimelineEnd(Play p_Play) {
        }
    }
}

