/*
 * Decompiled with CFR 0.152.
 */
package LiveShowObjectPackage;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowVirtualPackage.LiveShowVIP;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEditSupport;

public class LiveShowUndo
implements UndoableEditListener {
    public static int MIN_UNDOLIMIT;
    public static int UNDOLIMIT;
    private static LiveShowUndo s_SelfReference;
    public static final int ACTION_NONE = 0;
    @LiveLanguageString
    public static String ACTION_ADD_STRING;
    public static final int ACTION_ADD = 11;
    @LiveLanguageString
    public static String ACTION_REMOVE_STRING;
    public static final int ACTION_REMOVE = 12;
    @LiveLanguageString
    public static String ACTION_MOVE_STRING;
    public static final int ACTION_MOVE = 13;
    @LiveLanguageString
    public static String ACTION_PARAMCHANGE_STRING;
    public static final int ACTION_PARAMCHANGE = 14;
    @LiveLanguageString
    public static String ACTION_SPLITMAINBRIDGE_STRING;
    public static final int ACTION_SPLITMAINBRIDGE = 15;
    @LiveLanguageString
    public static String ACTION_DRAGMOVE_STRING;
    public static final int ACTION_DRAGMOVE = 20;
    @LiveLanguageString
    public static String ACTION_DRAGCOPY_STRING;
    public static final int ACTION_DRAGCOPY = 21;
    @LiveLanguageString
    public static String ACTION_DRAGDROP_STRING;
    public static final int ACTION_DRAGDROP = 26;
    @LiveLanguageString
    public static String ACTION_COPYPASTE_STRING;
    public static final int ACTION_COPYPASTE = 30;
    @LiveLanguageString
    public static String ACTION_OBJECTSTOPPER_STRING;
    public static final int ACTION_OBJECTSTOPPER = 110;
    @LiveLanguageString
    public static String ACTION_OBJECTACTIVE_STRING;
    public static final int ACTION_OBJECTACTIVE = 111;
    @LiveLanguageString
    public static String ACTION_OBJECTJUMP_STRING;
    public static final int ACTION_OBJECTJUMP = 112;
    @LiveLanguageString
    public static String ACTION_OBJECTSETTINGS_STRING;
    public static final int ACTION_OBJECTSETTINGS = 120;
    @LiveLanguageString
    public static String ACTION_FADESETTINGS_STRING;
    public static final int ACTION_FADESETTINGS = 121;
    @LiveLanguageString
    public static String ACTION_SOUNDSETTINGS_STRING;
    public static final int ACTION_SOUNDSETTINGS = 122;
    @LiveLanguageString
    public static String ACTION_MEDIASERVERSETTINGS_STRING;
    public static final int ACTION_MEDIASERVERSETTINGS = 131;
    @LiveLanguageString
    public static String ACTION_IMPORT_STRING;
    public static final int ACTION_IMPORT = 201;
    @LiveLanguageString
    public static String ACTION_IMPORTJINGLEGROUP_STRING;
    public static final int ACTION_IMPORTJINGLEGROUP = 301;
    private UndoManager m_UndoManager;
    private UndoableEditSupport m_UndoableEditSupport;
    private int m_LastAction;
    private ActionUndoableEdit m_ActionUndoableEdit;
    private ArrayList<UndoRedolistener> m_UndoRedoListeners;
    private boolean m_UndoInProgress;
    private boolean m_RedoInProgress;
    private final Object m_SyncListener = new Object();
    private HashMap<Integer, ActionUndoableEdit> m_Actions;

    public static void setUndoLimit(int p_UndoLimit) {
        UndoManager o_UndoManager;
        if (p_UndoLimit < MIN_UNDOLIMIT) {
            p_UndoLimit = MIN_UNDOLIMIT;
        }
        if (p_UndoLimit == UNDOLIMIT) {
            return;
        }
        UNDOLIMIT = p_UndoLimit;
        if (s_SelfReference != null && (o_UndoManager = s_SelfReference.getUndoManager()) != null) {
            try {
                o_UndoManager.setLimit(UNDOLIMIT);
            }
            catch (Exception exception) {
                // empty catch block
            }
            UNDOLIMIT = o_UndoManager.getLimit();
        }
    }

    public LiveShowUndo() {
        s_SelfReference = this;
        this.initMembers();
        LiveLanguage.addLanguageListener(this, null);
    }

    private void initMembers() {
        this.m_UndoManager = new UndoManager();
        this.m_UndoManager.setLimit(UNDOLIMIT);
        this.m_Actions = new HashMap();
        this.m_UndoRedoListeners = new ArrayList();
        this.m_UndoableEditSupport = new UndoableEditSupport();
        this.m_UndoableEditSupport.addUndoableEditListener(this.m_UndoManager);
        this.m_UndoableEditSupport.addUndoableEditListener(this);
        this.m_LastAction = 0;
        this.m_UndoInProgress = false;
        this.m_RedoInProgress = false;
    }

    public UndoManager getUndoManager() {
        return this.m_UndoManager;
    }

    public UndoableEditSupport getUndoableEditSupport() {
        return this.m_UndoableEditSupport;
    }

    public void setUndoManagerSupport(UndoManager p_UndoManager, UndoableEditSupport p_UndoableEditSupport) {
        if (p_UndoManager == null) {
            return;
        }
        if (p_UndoableEditSupport == null) {
            return;
        }
        if (this.m_UndoManager == p_UndoManager) {
            return;
        }
        if (this.m_UndoManager != null) {
            if (this.m_UndoableEditSupport != null) {
                this.m_UndoableEditSupport.removeUndoableEditListener(this.m_UndoManager);
            }
            this.m_UndoManager.end();
        }
        this.m_UndoManager = p_UndoManager;
        this.m_UndoableEditSupport = p_UndoableEditSupport;
    }

    public void clear() {
        this.m_UndoManager.discardAllEdits();
        this.notifyCleared();
    }

    public boolean checkStartAction(int p_Action) {
        if (this.m_UndoInProgress || this.m_RedoInProgress) {
            return false;
        }
        if (this.m_LastAction == p_Action) {
            return false;
        }
        return this.m_ActionUndoableEdit == null;
    }

    public boolean startAction(int p_Action, String p_ActionName, ActionOwnerInterface p_ActionOwner, LiveShowVIP.LiveShowVIPStatus p_OldLiveShowVIPStatus) {
        if (this.m_UndoInProgress || this.m_RedoInProgress) {
            return false;
        }
        if (this.m_LastAction == p_Action) {
            return false;
        }
        if (this.m_ActionUndoableEdit == null) {
            this.m_LastAction = p_Action;
            this.m_ActionUndoableEdit = new ActionUndoableEdit(this, p_Action, p_ActionName, p_ActionOwner);
            this.setStatusOld(p_OldLiveShowVIPStatus);
            return true;
        }
        return false;
    }

    private boolean setStatusOld(LiveShowVIP.LiveShowVIPStatus p_LiveShowVIPStatus) {
        if (this.m_ActionUndoableEdit == null) {
            return false;
        }
        this.m_ActionUndoableEdit.setStatusOld(p_LiveShowVIPStatus);
        return true;
    }

    public LiveShowVIP.LiveShowVIPStatus getLiveShowVIPStatusOld() {
        if (this.m_ActionUndoableEdit == null) {
            return null;
        }
        return (LiveShowVIP.LiveShowVIPStatus)this.m_ActionUndoableEdit.getStatusOld();
    }

    private boolean setStatusNew(LiveShowVIP.LiveShowVIPStatus p_LiveShowVIPStatus) {
        if (this.m_ActionUndoableEdit == null) {
            return false;
        }
        this.m_ActionUndoableEdit.setStatusNew(p_LiveShowVIPStatus);
        return true;
    }

    public LiveShowVIP.LiveShowVIPStatus getLiveShowVIPStatusNew() {
        if (this.m_ActionUndoableEdit == null) {
            return null;
        }
        return (LiveShowVIP.LiveShowVIPStatus)this.m_ActionUndoableEdit.getStatusNew();
    }

    public boolean checkEndAction(int p_Action) {
        if (this.m_UndoInProgress || this.m_RedoInProgress) {
            return false;
        }
        return this.m_ActionUndoableEdit != null;
    }

    public boolean endAction(boolean p_Success, int p_Action, ActionOwnerInterface p_ActionOwner, LiveShowVIP.LiveShowVIPStatus p_NewLiveShowVIPStatus) {
        if (this.m_UndoInProgress || this.m_RedoInProgress) {
            return false;
        }
        if (this.m_ActionUndoableEdit == null) {
            return false;
        }
        if (p_Action != 26 && p_Action != this.m_ActionUndoableEdit.getAction()) {
            return false;
        }
        this.setStatusNew(p_NewLiveShowVIPStatus);
        if (p_Success) {
            this.m_UndoableEditSupport.postEdit(this.m_ActionUndoableEdit);
        } else {
            this.undo(this.m_ActionUndoableEdit);
        }
        this.m_LastAction = 0;
        this.m_ActionUndoableEdit = null;
        if (p_ActionOwner != null) {
            p_ActionOwner.eventEndOfAction(p_NewLiveShowVIPStatus, p_Success, p_Action);
        }
        return true;
    }

    public void undo() {
        this.m_UndoManager.undo();
    }

    public void undo(ActionUndoableEdit p_ActionUndoableEdit) {
        this.m_UndoInProgress = true;
        ActionOwnerInterface o_ActionOwnerInterface = p_ActionUndoableEdit.getActionOwnerInterface();
        o_ActionOwnerInterface.undo(p_ActionUndoableEdit);
        this.notifyUndoHappened();
        this.m_UndoInProgress = false;
    }

    public void redo() {
        this.m_UndoManager.redo();
    }

    public void redo(ActionUndoableEdit p_ActionUndoableEdit) {
        this.m_RedoInProgress = true;
        ActionOwnerInterface o_ActionOwnerInterface = p_ActionUndoableEdit.getActionOwnerInterface();
        o_ActionOwnerInterface.redo(p_ActionUndoableEdit);
        this.notifyRedoHappened();
        this.m_RedoInProgress = false;
    }

    public int getActualAction() {
        if (this.m_ActionUndoableEdit == null) {
            return -1;
        }
        return this.m_ActionUndoableEdit.getAction();
    }

    public ActionUndoableEdit getActualActionUndoableEdit() {
        return this.m_ActionUndoableEdit;
    }

    public ActionOwnerInterface getActualActionOwnerInterface() {
        if (this.m_ActionUndoableEdit == null) {
            return null;
        }
        return this.m_ActionUndoableEdit.getActionOwnerInterface();
    }

    public int getLastAction() {
        return this.m_LastAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUndoRedoListener(UndoRedolistener p_UndoRedoListener) {
        if (p_UndoRedoListener == null) {
            return;
        }
        Object object = this.m_SyncListener;
        synchronized (object) {
            if (this.m_UndoRedoListeners.contains(p_UndoRedoListener)) {
                return;
            }
            this.m_UndoRedoListeners.add(p_UndoRedoListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUndoRedoListener(UndoRedolistener p_UndoRedolistener) {
        if (p_UndoRedolistener == null) {
            return;
        }
        Object object = this.m_SyncListener;
        synchronized (object) {
            if (!this.m_UndoRedoListeners.contains(p_UndoRedolistener)) {
                return;
            }
            this.m_UndoRedoListeners.remove(p_UndoRedolistener);
        }
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        this.notifyUndoableEditHappened(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyUndoableEditHappened(UndoableEditEvent e) {
        ArrayList<UndoRedolistener> o_UndoRedoListeners;
        Object object = this.m_SyncListener;
        synchronized (object) {
            o_UndoRedoListeners = new ArrayList<UndoRedolistener>(this.m_UndoRedoListeners.size());
            o_UndoRedoListeners.addAll(this.m_UndoRedoListeners);
        }
        for (int intListener = 0; intListener < o_UndoRedoListeners.size(); ++intListener) {
            UndoRedolistener o_UndoRedolistener = (UndoRedolistener)o_UndoRedoListeners.get(intListener);
            o_UndoRedolistener.undoableEditHappened(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyUndoHappened() {
        ArrayList<UndoRedolistener> o_UndoRedoListeners;
        Object object = this.m_SyncListener;
        synchronized (object) {
            o_UndoRedoListeners = new ArrayList<UndoRedolistener>(this.m_UndoRedoListeners.size());
            o_UndoRedoListeners.addAll(this.m_UndoRedoListeners);
        }
        for (int intListener = 0; intListener < o_UndoRedoListeners.size(); ++intListener) {
            UndoRedolistener o_UndoRedolistener = (UndoRedolistener)o_UndoRedoListeners.get(intListener);
            o_UndoRedolistener.undoHappened();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyRedoHappened() {
        ArrayList<UndoRedolistener> o_UndoRedoListeners;
        Object object = this.m_SyncListener;
        synchronized (object) {
            o_UndoRedoListeners = new ArrayList<UndoRedolistener>(this.m_UndoRedoListeners.size());
            o_UndoRedoListeners.addAll(this.m_UndoRedoListeners);
        }
        for (int intListener = 0; intListener < o_UndoRedoListeners.size(); ++intListener) {
            UndoRedolistener o_UndoRedolistener = (UndoRedolistener)o_UndoRedoListeners.get(intListener);
            o_UndoRedolistener.redoHappened();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCleared() {
        ArrayList<UndoRedolistener> o_UndoRedoListeners;
        Object object = this.m_SyncListener;
        synchronized (object) {
            o_UndoRedoListeners = new ArrayList<UndoRedolistener>(this.m_UndoRedoListeners.size());
            o_UndoRedoListeners.addAll(this.m_UndoRedoListeners);
        }
        for (int intListener = 0; intListener < o_UndoRedoListeners.size(); ++intListener) {
            UndoRedolistener o_UndoRedolistener = (UndoRedolistener)o_UndoRedoListeners.get(intListener);
            o_UndoRedolistener.undoredoCleared();
        }
    }

    static {
        UNDOLIMIT = MIN_UNDOLIMIT = 15;
        ACTION_ADD_STRING = "Add Object";
        ACTION_REMOVE_STRING = "Remove Object";
        ACTION_MOVE_STRING = "Move Object";
        ACTION_PARAMCHANGE_STRING = "Change Object";
        ACTION_SPLITMAINBRIDGE_STRING = "Split MainBridge";
        ACTION_DRAGMOVE_STRING = "DragMove Object";
        ACTION_DRAGCOPY_STRING = "DragCopy Object";
        ACTION_DRAGDROP_STRING = "Drag Object";
        ACTION_COPYPASTE_STRING = "Copy Paste Objects";
        ACTION_OBJECTSTOPPER_STRING = "Object stopper changed";
        ACTION_OBJECTACTIVE_STRING = "Object activation changed";
        ACTION_OBJECTJUMP_STRING = "Object jump changed";
        ACTION_OBJECTSETTINGS_STRING = "Object Settings";
        ACTION_FADESETTINGS_STRING = "Object FadeSettings";
        ACTION_SOUNDSETTINGS_STRING = "Object SoundLines";
        ACTION_MEDIASERVERSETTINGS_STRING = "Object MediaServerSettings";
        ACTION_IMPORT_STRING = "Import";
        ACTION_IMPORTJINGLEGROUP_STRING = "JingleGroup";
    }

    public static class ButtonRedo
    extends JButton
    implements UndoRedolistener {
        private LiveShowUndo m_LiveShowUndo;
        private Runnable m_RunnableRedoCheck;

        public ButtonRedo(LiveShowUndo p_LiveShowUndo) {
            this.m_LiveShowUndo = p_LiveShowUndo;
            this.initComponents();
            this.m_LiveShowUndo.addUndoRedoListener(this);
            this.refreshUndoRedo();
        }

        private void initComponents() {
            this.setText("Redo");
            this.m_RunnableRedoCheck = new Runnable(){

                @Override
                public void run() {
                    if (m_LiveShowUndo == null) {
                        this.setEnabled(false);
                        return;
                    }
                    this.setToolTipText(m_LiveShowUndo.getUndoManager().getRedoPresentationName());
                    this.setEnabled(m_LiveShowUndo.getUndoManager().canRedo());
                }
            };
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    m_LiveShowUndo.getUndoManager().redo();
                    this.refreshUndoRedo();
                }
            });
            this.setVisible(true);
        }

        public void refreshUndoRedo() {
            this.m_RunnableRedoCheck.run();
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            this.refreshUndoRedo();
        }

        @Override
        public void undoHappened() {
            this.refreshUndoRedo();
        }

        @Override
        public void redoHappened() {
            this.refreshUndoRedo();
        }

        @Override
        public void undoredoCleared() {
            this.m_RunnableRedoCheck.run();
        }
    }

    public static class ButtonUndo
    extends JButton
    implements UndoRedolistener {
        private LiveShowUndo m_LiveShowUndo;
        private Runnable m_RunnableUndoCheck;

        public ButtonUndo(LiveShowUndo p_LiveShowUndo) {
            this.m_LiveShowUndo = p_LiveShowUndo;
            this.initComponents();
            this.m_LiveShowUndo.addUndoRedoListener(this);
            this.refreshUndoRedo();
        }

        private void initComponents() {
            this.setText("Undo");
            this.m_RunnableUndoCheck = new Runnable(){

                @Override
                public void run() {
                    if (m_LiveShowUndo == null) {
                        this.setEnabled(false);
                        return;
                    }
                    this.setToolTipText(m_LiveShowUndo.getUndoManager().getUndoPresentationName());
                    this.setEnabled(m_LiveShowUndo.getUndoManager().canUndo());
                }
            };
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    m_LiveShowUndo.getUndoManager().undo();
                    this.refreshUndoRedo();
                }
            });
            this.setVisible(true);
        }

        public void refreshUndoRedo() {
            this.m_RunnableUndoCheck.run();
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            this.refreshUndoRedo();
        }

        @Override
        public void undoHappened() {
            this.refreshUndoRedo();
        }

        @Override
        public void redoHappened() {
            this.refreshUndoRedo();
        }

        @Override
        public void undoredoCleared() {
            this.m_RunnableUndoCheck.run();
        }
    }

    public static interface UndoRedolistener {
        public void undoableEditHappened(UndoableEditEvent var1);

        public void undoHappened();

        public void redoHappened();

        public void undoredoCleared();
    }

    public static class ActionUndoableEdit
    extends AbstractUndoableEdit {
        private LiveShowUndo m_LiveShowUndo;
        private int m_Action;
        private String m_ActionName;
        private ActionOwnerInterface m_ActionOwnerInterface;
        private Object m_StatusOld;
        private Object m_StatusNew;

        public ActionUndoableEdit(LiveShowUndo p_LiveShowUndo, int p_Action, String p_ActionName, ActionOwnerInterface p_ActionOwnerInterface) {
            this.initMembers();
            this.m_LiveShowUndo = p_LiveShowUndo;
            this.m_Action = p_Action;
            this.m_ActionName = p_ActionName;
            this.m_ActionOwnerInterface = p_ActionOwnerInterface;
        }

        private void initMembers() {
            this.m_StatusOld = null;
            this.m_StatusNew = null;
        }

        public void close() {
            Method o_Method;
            if (this.m_StatusNew != null) {
                try {
                    o_Method = this.m_StatusNew.getClass().getDeclaredMethod("close", new Class[0]);
                    o_Method.invoke(this.m_StatusNew, new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.m_StatusOld != null) {
                try {
                    o_Method = this.m_StatusOld.getClass().getMethod("close", new Class[0]);
                    o_Method.invoke(this.m_StatusOld, new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.m_LiveShowUndo = null;
            this.m_ActionOwnerInterface = null;
        }

        public LiveShowUndo getLiveShowUndo() {
            return this.m_LiveShowUndo;
        }

        public ActionOwnerInterface getActionOwnerInterface() {
            return this.m_ActionOwnerInterface;
        }

        public void setAction(int p_Action, String p_ActionName) {
            this.m_Action = p_Action;
        }

        public int getAction() {
            return this.m_Action;
        }

        public void setStatusOld(Object p_Status) {
            if (p_Status == null) {
                return;
            }
            this.m_StatusOld = p_Status;
        }

        public Object getStatusOld() {
            return this.m_StatusOld;
        }

        public void setStatusNew(Object p_Status) {
            if (p_Status == null) {
                return;
            }
            this.m_StatusNew = p_Status;
        }

        public Object getStatusNew() {
            return this.m_StatusNew;
        }

        @Override
        public String getUndoPresentationName() {
            StringBuilder stringBuilder_Name = new StringBuilder();
            String stringActionName = this.m_ActionName == null || this.m_ActionName.length() <= 0 ? this.getPresentationName() : this.m_ActionName;
            if (!"".equals(stringActionName)) {
                stringBuilder_Name.append(UIManager.getString("AbstractUndoableEdit.undoText"));
                stringBuilder_Name.append(" ");
                stringBuilder_Name.append(stringActionName);
            } else {
                stringBuilder_Name.append(UIManager.getString("AbstractUndoableEdit.undoText"));
            }
            return stringBuilder_Name.toString();
        }

        @Override
        public String getRedoPresentationName() {
            StringBuilder stringBuilder_Name = new StringBuilder();
            String stringActionName = this.m_ActionName == null || this.m_ActionName.length() <= 0 ? this.getPresentationName() : this.m_ActionName;
            if (!"".equals(stringActionName)) {
                stringBuilder_Name.append(UIManager.getString("AbstractUndoableEdit.redoText"));
                stringBuilder_Name.append(" ");
                stringBuilder_Name.append(stringActionName);
            } else {
                stringBuilder_Name.append(UIManager.getString("AbstractUndoableEdit.redoText"));
            }
            return stringBuilder_Name.toString();
        }

        @Override
        public void undo() {
            if (this.m_LiveShowUndo != null) {
                this.m_LiveShowUndo.undo(this);
            }
        }

        @Override
        public void redo() {
            if (this.m_LiveShowUndo != null) {
                this.m_LiveShowUndo.redo(this);
            }
        }

        @Override
        public boolean canRedo() {
            return true;
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void die() {
            this.close();
        }
    }

    public static interface ActionOwnerInterface {
        public void undo(ActionUndoableEdit var1);

        public void redo(ActionUndoableEdit var1);

        public Object getStatusSelected_Cloned();

        public Object getStatusSelected_ForStartAction();

        public Object getStatusSelected_ForEndAction();

        public void eventEndOfAction(LiveShowVIP.LiveShowVIPStatus var1, boolean var2, int var3);
    }
}

