/*
 * Decompiled with CFR 0.152.
 */
package LiveShowObjectPackage;

import BioMathmaticsPackage.BioMathematics;
import GUID.LiveGUID;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import java.awt.BasicStroke;
import java.awt.Color;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class LiveShowObjectDescription
implements Externalizable {
    static final int SOFTWAREVERSION = 5;
    private int m_ReadSoftwareVersion;
    public static long BYTESCOUNT_ESTIMATED = 600L;
    public static final DescriptionStrings s_DESCRIPTION_STRINGS = new DescriptionStrings();
    public static final int OBJECTTYPE_SOUNDOBJECT = 1;
    public static final int OBJECTTYPE_SOUNDSCENEBRIDGE = 2;
    public static final int OBJECTTYPE_DMXOBJECT = 11;
    public static final int OBJECTTYPE_DMXSCENEBRIDGE = 12;
    public static final int OBJECTTYPE_DMXDEVICEADJUSTMENTOBJECT = 13;
    public static final int OBJECTTYPE_MEDIAOBJECT = 21;
    public static final int OBJECTTYPE_MEDIASCENEBRIDGE = 22;
    public static final int OBJECTTYPE_SPITOBJECT = 25;
    public static Color s_ColorNotDefault = new Color(255, 100, 0);
    public static BasicStroke s_BasicStroke_NotDefault = new BasicStroke(3.0f);
    public static Color s_ColorOverlap = new Color(255, 150, 0);
    public static Border s_OverlapBorder = new LineBorder(s_ColorOverlap, 2);
    public static long DEFAULTFRAMELENGTH = 441000L;
    private static ArrayList<LiveShowObjectDescription> s_LiveShowObjectDescriptionsPool = new ArrayList();
    private static final Object s_SyncDescriptions = new Object();
    protected String m_ID;
    protected String m_Name;
    protected String m_SourceName;
    protected int m_ObjectType;
    protected String m_SourceString;
    protected String m_EffectSourceString;
    protected ArrayList<Double> m_EffectParameters;
    protected int m_VIPTrackNumber;
    protected long m_FrameStart;
    protected long m_FrameStartOffset;
    protected long m_FrameLength;
    protected long m_FrameFadeInLength;
    protected long m_FrameFadeInOffset;
    protected long m_FrameFadeOutLength;
    protected long m_FrameFadeOutOffset;
    protected float m_VolumeFactor;
    protected float m_VolumeFactor_Logarithm;
    protected float m_VolumeFactor_Linear;
    protected boolean m_Active;
    protected boolean m_StopAtStart;
    protected boolean m_IsMainBridge;
    protected long m_MouseFramePositionInside;
    protected String m_StringPre;
    protected String m_StringPost;
    protected boolean m_Changeable_FadeIn;
    protected boolean m_Changeable_FadeOut;
    protected boolean m_Changeable_Volume;
    protected boolean m_EqualDefaultSettings;
    protected String m_JumpToID;
    protected boolean m_JumpActive;
    protected boolean m_JumpPossible;
    protected boolean m_isJingle;
    protected long m_FramesRecordedToNext;
    protected boolean m_Closed;
    protected final Object m_SyncObject = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LiveShowObjectDescription poolGet() {
        LiveShowObjectDescription o_LiveShowObjectDescription;
        Object object = s_SyncDescriptions;
        synchronized (object) {
            if (s_LiveShowObjectDescriptionsPool.size() > 0) {
                int intIndex = s_LiveShowObjectDescriptionsPool.size() - 1;
                o_LiveShowObjectDescription = s_LiveShowObjectDescriptionsPool.get(intIndex);
                s_LiveShowObjectDescriptionsPool.remove(intIndex);
                o_LiveShowObjectDescription.reactivate(true);
            } else {
                o_LiveShowObjectDescription = new LiveShowObjectDescription();
            }
        }
        return o_LiveShowObjectDescription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean poolAddEmpty(LiveShowObjectDescription p_LiveShowObjectDescription) {
        Object object = s_SyncDescriptions;
        synchronized (object) {
            if (s_LiveShowObjectDescriptionsPool.size() < 5000) {
                s_LiveShowObjectDescriptionsPool.add(p_LiveShowObjectDescription);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void poolClear() {
        Object object = s_SyncDescriptions;
        synchronized (object) {
            s_LiveShowObjectDescriptionsPool.clear();
        }
    }

    public LiveShowObjectDescription() {
        this.initMembers();
    }

    private void initMembers() {
        this.m_ReadSoftwareVersion = 0;
        this.m_ID = LiveGUID.getUID();
        this.m_Name = "";
        this.m_SourceName = "";
        this.m_SourceString = "";
        this.m_EffectSourceString = "";
        if (this.m_EffectParameters == null) {
            this.m_EffectParameters = new ArrayList();
        } else {
            this.m_EffectParameters.clear();
        }
        this.m_Active = true;
        this.m_StopAtStart = true;
        this.m_IsMainBridge = false;
        this.m_MouseFramePositionInside = 0L;
        this.m_FrameFadeInOffset = 0L;
        this.m_FrameFadeInLength = 0L;
        this.m_FrameFadeOutOffset = 0L;
        this.m_FrameFadeOutLength = 0L;
        this.m_VolumeFactor = 1.0f;
        this.m_StringPre = "";
        this.m_StringPost = "";
        this.m_Changeable_FadeIn = true;
        this.m_Changeable_FadeOut = true;
        this.m_Changeable_Volume = true;
        this.m_EqualDefaultSettings = true;
        this.m_JumpToID = null;
        this.m_JumpActive = false;
        this.m_JumpPossible = false;
        this.m_isJingle = false;
        this.m_FramesRecordedToNext = -1L;
        this.m_VIPTrackNumber = -1;
        this.m_FrameLength = 0L;
        this.m_FrameStartOffset = 0L;
        this.m_FrameStart = 0L;
        this.m_Closed = false;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (out == null) {
            return;
        }
        try {
            out.writeInt(5);
            out.writeUTF(this.m_ID);
            out.writeUTF(this.m_Name);
            out.writeInt(this.m_ObjectType);
            if (this.m_SourceName == null) {
                out.writeUTF("null");
            } else {
                out.writeUTF(this.m_SourceName);
            }
            if (this.m_SourceString == null) {
                out.writeUTF("null");
            } else {
                out.writeUTF(this.m_SourceString);
            }
            out.writeInt(this.m_VIPTrackNumber);
            out.writeLong(this.m_FrameStart);
            out.writeLong(this.m_FrameStartOffset);
            out.writeLong(this.m_FrameLength);
            out.writeLong(this.m_FrameFadeInLength);
            out.writeLong(this.m_FrameFadeInOffset);
            out.writeLong(this.m_FrameFadeOutLength);
            out.writeLong(this.m_FrameFadeOutOffset);
            out.writeFloat(this.m_VolumeFactor);
            out.writeBoolean(this.m_Active);
            out.writeBoolean(this.m_StopAtStart);
            out.writeBoolean(this.m_IsMainBridge);
            out.writeLong(this.m_MouseFramePositionInside);
            out.writeUTF(this.m_StringPre);
            out.writeUTF(this.m_StringPost);
            if (this.m_JumpToID == null) {
                out.writeUTF("null");
            } else {
                out.writeUTF(this.m_JumpToID);
            }
            out.writeBoolean(this.m_JumpActive);
            out.writeLong(this.m_FramesRecordedToNext);
            out.writeBoolean(this.m_isJingle);
            if (this.m_EffectSourceString == null) {
                out.writeUTF("null");
            } else {
                out.writeUTF(this.m_EffectSourceString);
            }
            out.writeInt(this.m_EffectParameters.size());
            for (int intParameter = 0; intParameter < this.m_EffectParameters.size(); ++intParameter) {
                out.writeDouble(this.m_EffectParameters.get(intParameter));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (in == null) {
            return;
        }
        try {
            this.m_ReadSoftwareVersion = in.readInt();
            this.m_ID = in.readUTF();
            this.m_Name = in.readUTF();
            this.m_ObjectType = in.readInt();
            this.m_SourceName = in.readUTF();
            if ("null".equals(this.m_SourceName)) {
                this.m_SourceName = null;
            }
            this.m_SourceString = in.readUTF();
            if ("null".equals(this.m_SourceString)) {
                this.m_SourceString = null;
            }
            this.m_VIPTrackNumber = in.readInt();
            this.m_FrameStart = in.readLong();
            this.m_FrameStartOffset = in.readLong();
            this.m_FrameLength = in.readLong();
            this.m_FrameFadeInLength = in.readLong();
            this.m_FrameFadeInOffset = in.readLong();
            this.m_FrameFadeOutLength = in.readLong();
            this.m_FrameFadeOutOffset = in.readLong();
            this.setVolumeFactor(in.readFloat());
            this.m_Active = in.readBoolean();
            this.m_StopAtStart = in.readBoolean();
            this.m_IsMainBridge = in.readBoolean();
            this.m_MouseFramePositionInside = in.readLong();
            this.m_StringPre = in.readUTF();
            this.m_StringPost = in.readUTF();
            this.m_JumpToID = in.readUTF();
            if ("null".equals(this.m_JumpToID)) {
                this.m_JumpToID = null;
            }
            this.m_JumpActive = in.readBoolean();
            if (this.m_ReadSoftwareVersion >= 2) {
                this.m_FramesRecordedToNext = in.readLong();
            }
            if (this.m_ReadSoftwareVersion >= 5) {
                this.m_isJingle = in.readBoolean();
            }
            if (this.m_ReadSoftwareVersion >= 3) {
                this.m_EffectSourceString = in.readUTF();
                if ("null".equals(this.m_EffectSourceString)) {
                    this.m_EffectSourceString = null;
                }
                this.m_EffectParameters.clear();
                int intParameterCount = in.readInt();
                for (int intParameter = 0; intParameter < intParameterCount; ++intParameter) {
                    this.m_EffectParameters.add(in.readDouble());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getReadExternalSoftwareVersion() {
        return this.m_ReadSoftwareVersion;
    }

    public long getDiskSpaceEstimated() {
        long longBytesCount = 0L;
        longBytesCount += 4L;
        longBytesCount += (long)(this.m_ID.length() * 2);
        longBytesCount += (long)(this.m_Name.length() * 2);
        longBytesCount += 4L;
        longBytesCount = this.m_SourceName == null ? (longBytesCount += (long)("null".length() * 2)) : (longBytesCount += (long)(this.m_SourceName.length() * 2));
        longBytesCount = this.m_SourceString == null ? (longBytesCount += (long)("null".length() * 2)) : (longBytesCount += (long)(this.m_SourceString.length() * 2));
        longBytesCount += 4L;
        longBytesCount += 8L;
        longBytesCount += 8L;
        longBytesCount += 8L;
        longBytesCount += 8L;
        longBytesCount += 8L;
        longBytesCount += 8L;
        longBytesCount += 8L;
        longBytesCount += 4L;
        ++longBytesCount;
        ++longBytesCount;
        ++longBytesCount;
        longBytesCount += 8L;
        longBytesCount += (long)(this.m_StringPre.length() * 2);
        longBytesCount += (long)(this.m_StringPost.length() * 2);
        longBytesCount = this.m_JumpToID != null ? (longBytesCount += (long)(this.m_JumpToID.length() * 2)) : (longBytesCount += (long)("null".length() * 2));
        ++longBytesCount;
        return longBytesCount += 8L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean p_Final) {
        this.m_ID = null;
        this.m_ObjectType = -1;
        this.m_Name = "";
        this.m_SourceName = null;
        this.m_SourceString = null;
        this.m_EffectSourceString = null;
        this.m_EffectParameters.clear();
        this.m_Active = true;
        this.m_StopAtStart = false;
        this.m_IsMainBridge = false;
        this.m_MouseFramePositionInside = 0L;
        this.m_FrameFadeInOffset = 0L;
        this.m_FrameFadeOutOffset = 0L;
        this.m_VolumeFactor = 1.0f;
        this.m_StringPre = null;
        this.m_StringPost = null;
        this.m_Changeable_FadeIn = true;
        this.m_Changeable_FadeOut = true;
        this.m_Changeable_Volume = true;
        this.m_JumpToID = null;
        this.m_JumpActive = false;
        this.m_FramesRecordedToNext = -1L;
        if (p_Final) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_Closed) {
                    return;
                }
                this.m_Closed = true;
            }
            if (!LiveShowObjectDescription.poolAddEmpty(this)) {
                // empty if block
            }
        }
    }

    public void reactivate(boolean p_SetToDefault) {
        this.initMembers();
    }

    public boolean isEqual(LiveShowObjectDescription p_LiveShowObjectDescription) {
        if (!this.m_Name.equals(p_LiveShowObjectDescription.getName())) {
            return false;
        }
        if (this.m_ObjectType != p_LiveShowObjectDescription.getObjectType()) {
            return false;
        }
        if (this.m_SourceName == null) {
            if (p_LiveShowObjectDescription.getSourceName() != null) {
                return false;
            }
        } else {
            if (p_LiveShowObjectDescription.getSourceName() == null) {
                return false;
            }
            if (!this.m_SourceName.equals(p_LiveShowObjectDescription.getSourceName())) {
                return false;
            }
        }
        if (this.m_SourceString == null) {
            if (p_LiveShowObjectDescription.getSourceString() != null) {
                return false;
            }
        } else {
            if (p_LiveShowObjectDescription.getSourceString() == null) {
                return false;
            }
            if (!this.m_SourceString.equals(p_LiveShowObjectDescription.getSourceString())) {
                return false;
            }
        }
        if (this.m_EffectSourceString == null) {
            if (p_LiveShowObjectDescription.getEffectSourceString() != null) {
                return false;
            }
        } else {
            if (p_LiveShowObjectDescription.getEffectSourceString() == null) {
                return false;
            }
            if (!this.m_EffectSourceString.equals(p_LiveShowObjectDescription.getEffectSourceString())) {
                return false;
            }
        }
        if (this.m_EffectParameters == null) {
            if (p_LiveShowObjectDescription.getEffectParameters() != null) {
                return false;
            }
        } else {
            if (p_LiveShowObjectDescription.getEffectParameters() == null) {
                return false;
            }
            ArrayList<Double> o_Parameters = p_LiveShowObjectDescription.getEffectParameters();
            if (this.m_EffectParameters.size() != o_Parameters.size()) {
                return false;
            }
            for (int intParameter = 0; intParameter < this.m_EffectParameters.size(); ++intParameter) {
                if (this.m_EffectParameters.get(intParameter) == o_Parameters.get(intParameter)) continue;
                return false;
            }
        }
        if (this.m_VIPTrackNumber != p_LiveShowObjectDescription.getVIPTrackNumber()) {
            return false;
        }
        if (this.m_FrameStart != p_LiveShowObjectDescription.getFrameStart()) {
            return false;
        }
        if (this.m_FrameStartOffset != p_LiveShowObjectDescription.getFrameStartOffset()) {
            return false;
        }
        if (this.m_FrameLength != p_LiveShowObjectDescription.getFrameLength()) {
            return false;
        }
        if (this.m_FrameFadeInLength != p_LiveShowObjectDescription.getFrameFadeInLength()) {
            return false;
        }
        if (this.m_FrameFadeInOffset != p_LiveShowObjectDescription.getFrameFadeInOffset()) {
            return false;
        }
        if (this.m_FrameFadeOutLength != p_LiveShowObjectDescription.getFrameFadeOutLength()) {
            return false;
        }
        if (this.m_FrameFadeOutOffset != p_LiveShowObjectDescription.getFrameFadeOutOffset()) {
            return false;
        }
        if (this.m_VolumeFactor != p_LiveShowObjectDescription.getVolumeFactor()) {
            return false;
        }
        if (this.m_Active != p_LiveShowObjectDescription.getActive()) {
            return false;
        }
        if (this.m_StopAtStart != p_LiveShowObjectDescription.getStopAtStart()) {
            return false;
        }
        if (this.m_IsMainBridge != p_LiveShowObjectDescription.getIsMainBridge()) {
            return false;
        }
        if (!this.m_StringPre.equals(p_LiveShowObjectDescription.getStringPre())) {
            return false;
        }
        if (!this.m_StringPost.equals(p_LiveShowObjectDescription.getStringPost())) {
            return false;
        }
        if (this.m_JumpToID == null) {
            if (p_LiveShowObjectDescription.getJumpID() != null) {
                return false;
            }
        } else {
            if (p_LiveShowObjectDescription.getJumpID() == null) {
                return false;
            }
            if (!this.m_JumpToID.equals(p_LiveShowObjectDescription.getJumpID())) {
                return false;
            }
        }
        if (this.m_JumpActive != p_LiveShowObjectDescription.getJumpActive()) {
            return false;
        }
        return this.m_FramesRecordedToNext == p_LiveShowObjectDescription.getFramesRecordedToNext();
    }

    public String getID() {
        return this.m_ID;
    }

    public boolean setID(String p_ID) {
        if (p_ID == null ? this.m_ID == null : p_ID.equals(this.m_ID)) {
            return false;
        }
        this.m_ID = p_ID;
        return true;
    }

    public void setID_New() {
        this.m_ID = LiveGUID.getUID();
    }

    public String getName() {
        return this.m_Name;
    }

    public boolean setName(String p_Name) {
        if (p_Name == null) {
            p_Name = "";
        }
        if (p_Name.equals(this.m_Name)) {
            return false;
        }
        this.m_Name = p_Name;
        return true;
    }

    public String getSourceName() {
        return this.m_SourceName;
    }

    public boolean setSourceName(String p_Name) {
        if (p_Name == null ? this.m_SourceName == null : p_Name.equals(this.m_SourceName)) {
            return false;
        }
        this.m_SourceName = p_Name;
        return true;
    }

    public boolean setObjectType(int p_ObjectType) {
        if (this.m_ObjectType == p_ObjectType) {
            return false;
        }
        this.m_ObjectType = p_ObjectType;
        return true;
    }

    public int getObjectType() {
        return this.m_ObjectType;
    }

    public String getSourceString() {
        return this.m_SourceString;
    }

    public boolean setSourceString(String p_SourceString) {
        if (p_SourceString == null ? this.m_SourceString == null : p_SourceString.equals(this.m_SourceString)) {
            return false;
        }
        this.m_SourceString = p_SourceString;
        return true;
    }

    public String getEffectSourceString() {
        return this.m_EffectSourceString;
    }

    public boolean setEffectSourceString(String p_EffectSourceString) {
        if (p_EffectSourceString == null ? this.m_EffectSourceString == null : p_EffectSourceString.equals(this.m_EffectSourceString)) {
            return false;
        }
        this.m_EffectSourceString = p_EffectSourceString;
        if (this.m_EffectSourceString == null) {
            // empty if block
        }
        return true;
    }

    public ArrayList<Double> getEffectParameters() {
        return this.m_EffectParameters;
    }

    public boolean setEffectParameters(ArrayList<Double> p_EffectParameters) {
        if (p_EffectParameters == null) {
            if (this.m_EffectParameters.size() > 0) {
                this.m_EffectParameters.clear();
                return true;
            }
            return false;
        }
        if (this.m_EffectParameters.size() != p_EffectParameters.size()) {
            this.m_EffectParameters.clear();
            for (int intParameter = 0; intParameter < p_EffectParameters.size(); ++intParameter) {
                this.m_EffectParameters.add(p_EffectParameters.get(intParameter));
            }
            return true;
        }
        boolean boolChanged = false;
        for (int intParameter = 0; intParameter < p_EffectParameters.size(); ++intParameter) {
            double doubleValue = p_EffectParameters.get(intParameter);
            if (this.m_EffectParameters.get(intParameter) == doubleValue) continue;
            this.m_EffectParameters.set(intParameter, doubleValue);
            boolChanged = true;
        }
        return boolChanged;
    }

    public int getVIPTrackNumber() {
        return this.m_VIPTrackNumber;
    }

    public boolean setVIPTrackNumber(int p_VIPTrackNumber) {
        if (this.m_VIPTrackNumber == p_VIPTrackNumber) {
            return false;
        }
        this.m_VIPTrackNumber = p_VIPTrackNumber;
        return true;
    }

    public boolean setMouseFramePositionInside(long p_FramePosition) {
        if (this.m_MouseFramePositionInside == p_FramePosition) {
            return false;
        }
        this.m_MouseFramePositionInside = p_FramePosition;
        return true;
    }

    public long getMouseFramePositionInside() {
        return this.m_MouseFramePositionInside;
    }

    public long getFrameStart() {
        return this.m_FrameStart;
    }

    public boolean setFrameStart(long p_StartFramePosition) {
        if (this.m_FrameStart == p_StartFramePosition) {
            return false;
        }
        this.m_FrameStart = p_StartFramePosition;
        return true;
    }

    public long getFrameStartOffset() {
        return this.m_FrameStartOffset;
    }

    public boolean setFrameStartOffset(long p_FrameOffset) {
        if (this.m_FrameStartOffset == p_FrameOffset) {
            return false;
        }
        this.m_FrameStartOffset = p_FrameOffset;
        return true;
    }

    public long getFrameLength() {
        return this.m_FrameLength;
    }

    public boolean setFrameLength(long p_FrameLength) {
        if (this.m_FrameLength == p_FrameLength) {
            return false;
        }
        this.m_FrameLength = p_FrameLength;
        return true;
    }

    public long getFrameFadeInLength() {
        return this.m_FrameFadeInLength;
    }

    public boolean setFrameFadeInLength(long p_FrameFadeInLength) {
        if (this.m_FrameFadeInLength == p_FrameFadeInLength) {
            return false;
        }
        this.m_FrameFadeInLength = p_FrameFadeInLength;
        return true;
    }

    public long getFrameFadeInOffset() {
        return this.m_FrameFadeInOffset;
    }

    public boolean setFrameFadeInOffset(long p_FrameFadeInOffset) {
        if (this.m_FrameFadeInOffset == p_FrameFadeInOffset) {
            return false;
        }
        this.m_FrameFadeInOffset = p_FrameFadeInOffset;
        return true;
    }

    public long getFrameFadeOutLength() {
        return this.m_FrameFadeOutLength;
    }

    public boolean setFrameFadeOutLength(long p_FrameFadeOutLength) {
        if (this.m_FrameFadeOutLength == p_FrameFadeOutLength) {
            return false;
        }
        this.m_FrameFadeOutLength = p_FrameFadeOutLength;
        return true;
    }

    public long getFrameFadeOutOffset() {
        return this.m_FrameFadeOutOffset;
    }

    public boolean setFrameFadeOutOffset(long p_FrameFadeOutOffset) {
        if (this.m_FrameFadeOutOffset == p_FrameFadeOutOffset) {
            return false;
        }
        this.m_FrameFadeOutOffset = p_FrameFadeOutOffset;
        return true;
    }

    public float getVolumeFactor() {
        return this.m_VolumeFactor;
    }

    public boolean setVolumeFactor(float p_VolumeFactor) {
        boolean boolChanged = true;
        if (this.m_VolumeFactor == p_VolumeFactor) {
            boolChanged = false;
        }
        this.m_VolumeFactor = p_VolumeFactor;
        this.m_VolumeFactor_Linear = (float)BioMathematics.calculateVolumeFactor_Linear(this.m_VolumeFactor);
        this.m_VolumeFactor_Logarithm = (float)BioMathematics.calculateVolumeFactor_Logarithm(this.m_VolumeFactor);
        return boolChanged;
    }

    public float getVolumeFactor_Logarithm() {
        return this.m_VolumeFactor_Logarithm;
    }

    public float getVolumeFactor_Linear() {
        return this.m_VolumeFactor_Linear;
    }

    public void setEqualDefaultSettings(boolean p_Equal) {
        this.m_EqualDefaultSettings = p_Equal;
    }

    public boolean isEqualDefaultSettings() {
        return this.m_EqualDefaultSettings;
    }

    public boolean setActive(boolean p_Active) {
        if (this.m_Active == p_Active) {
            return false;
        }
        this.m_Active = p_Active;
        return true;
    }

    public boolean getActive() {
        return this.m_Active;
    }

    public boolean setStopAtStart(boolean p_Stop) {
        if (this.m_StopAtStart == p_Stop) {
            return false;
        }
        this.m_StopAtStart = p_Stop;
        return true;
    }

    public boolean getStopAtStart() {
        return this.m_StopAtStart;
    }

    public boolean getIsSceneBridge() {
        if (this.m_ObjectType == 2) {
            return true;
        }
        if (this.m_ObjectType == 12) {
            return true;
        }
        return this.m_ObjectType == 22;
    }

    public boolean setIsMainBridge(boolean p_IsMainBridge) {
        if (this.m_IsMainBridge == p_IsMainBridge) {
            return false;
        }
        this.m_IsMainBridge = p_IsMainBridge;
        return true;
    }

    public boolean getIsMainBridge() {
        return this.m_IsMainBridge;
    }

    public boolean setStringPre(String p_Text) {
        if (p_Text == null) {
            p_Text = "";
        }
        if (p_Text.equals(this.m_StringPre)) {
            return false;
        }
        this.m_StringPre = p_Text;
        return true;
    }

    public String getStringPre() {
        return this.m_StringPre;
    }

    public boolean setStringPost(String p_Text) {
        if (p_Text == null) {
            p_Text = "";
        }
        if (p_Text.equals(this.m_StringPost)) {
            return false;
        }
        this.m_StringPost = p_Text;
        return true;
    }

    public String getStringPost() {
        return this.m_StringPost;
    }

    public boolean setChangeable_FadeIn(boolean p_ChangeableFadeIn) {
        if (this.m_Changeable_FadeIn == p_ChangeableFadeIn) {
            return false;
        }
        this.m_Changeable_FadeIn = p_ChangeableFadeIn;
        return true;
    }

    public boolean getChangeable_FadeIn() {
        return this.m_Changeable_FadeIn;
    }

    public boolean setChangeable_FadeOut(boolean p_ChangeableFadeOut) {
        if (this.m_Changeable_FadeOut == p_ChangeableFadeOut) {
            return false;
        }
        this.m_Changeable_FadeOut = p_ChangeableFadeOut;
        return true;
    }

    public boolean getChangeable_FadeOut() {
        return this.m_Changeable_FadeOut;
    }

    public boolean setChangeable_Volume(boolean p_ChangeableVolume) {
        if (this.m_Changeable_Volume == p_ChangeableVolume) {
            return false;
        }
        this.m_Changeable_Volume = p_ChangeableVolume;
        return true;
    }

    public boolean getChangeable_Volume() {
        return this.m_Changeable_Volume;
    }

    public boolean setJumpID(String p_JumpID) {
        if (p_JumpID == null ? this.m_JumpToID == null : p_JumpID.equals(this.m_JumpToID)) {
            return false;
        }
        this.m_JumpToID = p_JumpID;
        return true;
    }

    public String getJumpID() {
        return this.m_JumpToID;
    }

    public boolean setJumpActive(boolean p_JumpActive) {
        if (this.m_JumpActive == p_JumpActive) {
            return false;
        }
        this.m_JumpActive = p_JumpActive;
        return true;
    }

    public boolean getJumpActive() {
        return this.m_JumpActive;
    }

    public void setJumpPossible(boolean p_JumpPossible) {
        this.m_JumpPossible = p_JumpPossible;
    }

    public boolean getJumpPossible() {
        return this.m_JumpPossible;
    }

    public boolean setFramesRecordedToNext(long p_Frames) {
        if (this.m_FramesRecordedToNext == p_Frames) {
            return false;
        }
        this.m_FramesRecordedToNext = p_Frames;
        return true;
    }

    public long getFramesRecordedToNext() {
        return this.m_FramesRecordedToNext;
    }

    public boolean setIsJingle(boolean p_IsJingle) {
        if (this.m_isJingle == p_IsJingle) {
            return false;
        }
        this.m_isJingle = p_IsJingle;
        return true;
    }

    public boolean getIsJingle() {
        return this.m_isJingle;
    }

    public LiveShowObjectDescription clone(LiveShowObjectDescription p_Description) {
        if (p_Description == null) {
            p_Description = LiveShowObjectDescription.poolGet();
        }
        p_Description.setID(this.m_ID);
        p_Description.setName(this.m_Name);
        p_Description.setObjectType(this.m_ObjectType);
        p_Description.setSourceName(this.m_SourceName);
        p_Description.setSourceString(this.m_SourceString);
        p_Description.setEffectSourceString(this.m_EffectSourceString);
        p_Description.setEffectParameters(this.m_EffectParameters);
        p_Description.setVIPTrackNumber(this.m_VIPTrackNumber);
        p_Description.setFrameStart(this.m_FrameStart);
        p_Description.setFrameStartOffset(this.m_FrameStartOffset);
        p_Description.setFrameLength(this.m_FrameLength);
        p_Description.setFrameFadeInLength(this.m_FrameFadeInLength);
        p_Description.setFrameFadeInOffset(this.m_FrameFadeInOffset);
        p_Description.setFrameFadeOutLength(this.m_FrameFadeOutLength);
        p_Description.setFrameFadeOutOffset(this.m_FrameFadeOutOffset);
        p_Description.setVolumeFactor(this.m_VolumeFactor);
        p_Description.setMouseFramePositionInside(this.m_MouseFramePositionInside);
        p_Description.setActive(this.m_Active);
        p_Description.setStopAtStart(this.m_StopAtStart);
        p_Description.setIsMainBridge(this.m_IsMainBridge);
        p_Description.setStringPre(this.m_StringPre);
        p_Description.setStringPost(this.m_StringPost);
        p_Description.setJumpID(this.m_JumpToID);
        p_Description.setJumpActive(this.m_JumpActive);
        p_Description.setFramesRecordedToNext(this.m_FramesRecordedToNext);
        p_Description.setIsJingle(this.m_isJingle);
        return p_Description;
    }

    public boolean copyFrom(LiveShowObjectDescription p_Description) {
        if (p_Description == null) {
            return false;
        }
        boolean boolChanged = false;
        if (this.setID(p_Description.getID())) {
            boolChanged = true;
        }
        if (this.setName(p_Description.getName())) {
            boolChanged = true;
        }
        if (this.setObjectType(p_Description.getObjectType())) {
            boolChanged = true;
        }
        if (this.setSourceName(p_Description.getSourceName())) {
            boolChanged = true;
        }
        if (this.setSourceString(p_Description.getSourceString())) {
            boolChanged = true;
        }
        if (this.setEffectSourceString(p_Description.getEffectSourceString())) {
            boolChanged = true;
        }
        if (this.setEffectParameters(p_Description.getEffectParameters())) {
            boolChanged = true;
        }
        if (this.setVIPTrackNumber(p_Description.getVIPTrackNumber())) {
            boolChanged = true;
        }
        if (this.setFrameStart(p_Description.getFrameStart())) {
            boolChanged = true;
        }
        if (this.setFrameStartOffset(p_Description.getFrameStartOffset())) {
            boolChanged = true;
        }
        if (this.setFrameLength(p_Description.getFrameLength())) {
            boolChanged = true;
        }
        if (this.setFrameFadeInLength(p_Description.getFrameFadeInLength())) {
            boolChanged = true;
        }
        if (this.setFrameFadeInOffset(p_Description.getFrameFadeInOffset())) {
            boolChanged = true;
        }
        if (this.setFrameFadeOutLength(p_Description.getFrameFadeOutLength())) {
            boolChanged = true;
        }
        if (this.setFrameFadeOutOffset(p_Description.getFrameFadeOutOffset())) {
            boolChanged = true;
        }
        if (this.setVolumeFactor(p_Description.getVolumeFactor())) {
            boolChanged = true;
        }
        if (this.setMouseFramePositionInside(p_Description.getMouseFramePositionInside())) {
            boolChanged = true;
        }
        if (this.setActive(p_Description.getActive())) {
            boolChanged = true;
        }
        if (this.setStopAtStart(p_Description.getStopAtStart())) {
            boolChanged = true;
        }
        if (this.setIsMainBridge(p_Description.getIsMainBridge())) {
            boolChanged = true;
        }
        if (this.setStringPre(p_Description.getStringPre())) {
            boolChanged = true;
        }
        if (this.setStringPost(p_Description.getStringPost())) {
            boolChanged = true;
        }
        if (this.setJumpID(p_Description.getJumpID())) {
            boolChanged = true;
        }
        if (this.setJumpActive(p_Description.getJumpActive())) {
            boolChanged = true;
        }
        if (this.setFramesRecordedToNext(p_Description.getFramesRecordedToNext())) {
            boolChanged = true;
        }
        if (this.setIsJingle(p_Description.getIsJingle())) {
            boolChanged = true;
        }
        return boolChanged;
    }

    public static class DescriptionStrings {
        @LiveLanguageString
        public static String s_Name = "Name";
        @LiveLanguageString
        public static String s_Source = "Source";
        @LiveLanguageString
        public static String s_SourceStartOffset = "SourceStartOffset";
        @LiveLanguageString
        public static String s_SourceEndOffset = "SourceEndOffset";
        @LiveLanguageString
        public static String s_Active = "Active";
        @LiveLanguageString
        public static String s_StopAtStart = "StopAtStart";
        @LiveLanguageString
        public static String s_Jump = "Jump";
        @LiveLanguageString
        public static String s_TimeRecordedToNext = "Recorded Time";
        @LiveLanguageString
        public static String s_Start = "Start";
        @LiveLanguageString
        public static String s_End = "End";
        @LiveLanguageString
        public static String s_Length = "Length";
        @LiveLanguageString
        public static String s_FadeIn = "FadeIn";
        @LiveLanguageString
        public static String s_FadeOut = "FadeOut";
        @LiveLanguageString
        public static String s_FadeInOffset = "FadeIn";
        @LiveLanguageString
        public static String s_FadeOutOffset = "FadeOut";
        @LiveLanguageString
        public static String s_Volume = "Volume";

        public DescriptionStrings() {
            LiveLanguage.addLanguageListener(this, null);
        }
    }
}

