/*
 * Decompiled with CFR 0.152.
 */
package FileToolPackage;

import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

public class FileImagePreview
extends JComponent
implements PropertyChangeListener {
    public static Dimension SIZE = new Dimension(150, 150);
    private ImageIcon m_Thumbnail = null;
    private File m_File = null;
    private FileNameExtensionFilter m_ImageFilter;
    private FileNameExtensionFilter m_SoundFilter;
    private FileNameExtensionFilter m_VideoFilter;
    private FileNameExtensionFilter m_TextFilter;

    public FileImagePreview(JFileChooser fc, FileNameExtensionFilter p_ImageFilter, FileNameExtensionFilter p_SoundFilter, FileNameExtensionFilter p_VideoFilter, FileNameExtensionFilter p_TextFilter) {
        this.m_ImageFilter = p_ImageFilter;
        this.m_SoundFilter = p_SoundFilter;
        this.m_VideoFilter = p_VideoFilter;
        this.m_TextFilter = p_TextFilter;
        this.setPreferredSize(SIZE);
        fc.addPropertyChangeListener(this);
    }

    private boolean getIsAcceptedImage() {
        if (this.m_File == null) {
            return false;
        }
        if (this.m_ImageFilter == null) {
            return false;
        }
        return this.m_ImageFilter.accept(this.m_File);
    }

    private boolean getIsAcceptedSound() {
        if (this.m_File == null) {
            return false;
        }
        if (this.m_SoundFilter == null) {
            return false;
        }
        return this.m_SoundFilter.accept(this.m_File);
    }

    private boolean getIsAcceptedVideo() {
        if (this.m_File == null) {
            return false;
        }
        if (this.m_VideoFilter == null) {
            return false;
        }
        return this.m_VideoFilter.accept(this.m_File);
    }

    private boolean getIsAcceptedText() {
        if (this.m_File == null) {
            return false;
        }
        if (this.m_TextFilter == null) {
            return false;
        }
        return this.m_TextFilter.accept(this.m_File);
    }

    public void loadImage() {
        double doubleRatio;
        if (this.m_File == null || this.m_File.isDirectory()) {
            this.m_Thumbnail = null;
            return;
        }
        ImageIcon tmpIcon = null;
        if (this.getIsAcceptedImage()) {
            try {
                tmpIcon = new ImageIcon(this.m_File.getPath());
            }
            catch (Exception e) {
                tmpIcon = new ImageIcon(FileImagePreview.class.getResource("Icon_Image_128.png"));
            }
        } else {
            tmpIcon = this.getIsAcceptedVideo() ? new ImageIcon(FileImagePreview.class.getResource("Icon_Video_128.png")) : (this.getIsAcceptedSound() ? new ImageIcon(FileImagePreview.class.getResource("Icon_Sound_128.png")) : (this.getIsAcceptedText() ? new ImageIcon(FileImagePreview.class.getResource("Icon_Text_128.png")) : null));
        }
        this.m_Thumbnail = tmpIcon != null ? (tmpIcon.getIconWidth() <= 0 || tmpIcon.getIconHeight() <= 0 ? null : ((doubleRatio = (double)tmpIcon.getIconWidth() / (double)tmpIcon.getIconHeight()) > 1.0 ? (tmpIcon.getIconWidth() > FileImagePreview.SIZE.width ? new ImageIcon(tmpIcon.getImage().getScaledInstance(FileImagePreview.SIZE.width, -1, 1)) : tmpIcon) : (tmpIcon.getIconHeight() > 50 ? new ImageIcon(tmpIcon.getImage().getScaledInstance(-1, FileImagePreview.SIZE.height, 1)) : tmpIcon))) : null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        boolean update = false;
        String prop = e.getPropertyName();
        if ("directoryChanged".equals(prop)) {
            this.m_File = null;
            update = true;
        } else if ("SelectedFileChangedProperty".equals(prop)) {
            this.m_File = (File)e.getNewValue();
            update = true;
        }
        if (update) {
            this.m_Thumbnail = null;
            if (this.isShowing()) {
                this.loadImage();
                this.repaint();
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.m_Thumbnail == null) {
            this.loadImage();
        }
        if (this.m_Thumbnail != null) {
            int x = this.getWidth() / 2 - this.m_Thumbnail.getIconWidth() / 2;
            int y = this.getHeight() / 2 - this.m_Thumbnail.getIconHeight() / 2;
            if (y < 0) {
                y = 0;
            }
            if (x < 5) {
                x = 5;
            }
            this.m_Thumbnail.paintIcon(this, g, x, y);
        }
    }
}

