/*
 * Decompiled with CFR 0.152.
 */
package ClientKernelPackage;

import ClientKernelPackage.LiveDBClientKernelListener;
import ClientPackage.LiveDBClient;
import ClientPackage.LiveDBClientListener;
import LogEventPackage.LogEvent;
import SocketManagementPackage.LiveDBSocketChannelManagement;
import SocketManagementPackage.LiveDBStream;
import SocketMessagePackage.LiveDBConnectionDescription;
import SocketMessagePackage.LiveDBMessageStreamInfo;
import SocketPackage.LiveDBSocket;
import SynchronizationPackage.LiveDBCloseSemaphore;
import SystemProperties.PropertiesSystem;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;

public class LiveDBClientKernel
implements LiveDBClientListener {
    public static long s_DestructWaitTime = 2000L;
    public static final int CONNECTION_CLOSE = 0;
    public static final int CONNECTION_TRYCONNECTION = 1;
    public static final int CONNECTION_CONNECT = 2;
    public static final int CONNECTION_RECONNECT = 3;
    public static final int CONNECTION_FAILED = 6;
    public static final int CONNECTION_LOST = 8;
    public static final int CONNECTION_TRYCLOSE = 9;
    public static String ERROR_CLIENTCLOSED = "LiveDBClient was closed prior and cannot be used again. Create a new one!";
    public static String ERROR_CLIENTKERNELDESTRUCTED = "LiveDBClientKernel was destructed prior and cannot be used again. The program must be restarted";
    public static String ERROR_STREAMHANDLEDINTERNAL = "The stream will be handled internal, there is no need to create an incoming stream!";
    private static ArrayList<LiveDBClientKernelListener> m_ClientKernelListeners = new ArrayList();
    private static ArrayList<LiveDBClient> m_ArrayListLiveDBClients = new ArrayList();
    private static LiveDBClientKernel m_LiveDBClientKernel = new LiveDBClientKernel();
    private static LiveDBCloseSemaphore m_LiveDBCloseSemaphore = new LiveDBCloseSemaphore("LiveDBClientKernel");
    private static final Object m_SyncLiveDBClients = new Object();
    private static final Object m_SyncClientKernelListeners = new Object();
    private static final Object m_SyncDestruct = new Object();

    private LiveDBClientKernel() {
        this.initMembers();
    }

    private void initMembers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destruct(boolean p_WaitForClients, long p_DestructWaitTime) {
        LiveDBClientKernel.closeClientsAll();
        if (p_WaitForClients) {
            long longDestructWaitTime = p_DestructWaitTime < s_DestructWaitTime ? s_DestructWaitTime : p_DestructWaitTime;
            Runnable o_DestructRunnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (m_ArrayListLiveDBClients == null || m_ArrayListLiveDBClients.size() <= 0) {
                        return;
                    }
                    Object object = m_SyncDestruct;
                    synchronized (object) {
                        try {
                            m_SyncDestruct.wait();
                            return;
                        }
                        catch (Exception exception) {
                        }
                    }
                }
            };
            Thread o_DestructThread = new Thread(o_DestructRunnable, LiveDBClientKernel.class.getSimpleName() + "_destruct");
            o_DestructThread.start();
            try {
                o_DestructThread.join(longDestructWaitTime);
                if (o_DestructThread.isAlive()) {
                    o_DestructThread.interrupt();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!m_LiveDBCloseSemaphore.enterCloseSection()) {
            return;
        }
        Object object = m_SyncClientKernelListeners;
        synchronized (object) {
            if (m_ClientKernelListeners != null) {
                m_ClientKernelListeners.clear();
                m_ClientKernelListeners = null;
            }
        }
        object = m_SyncLiveDBClients;
        synchronized (object) {
            if (m_ArrayListLiveDBClients != null) {
                m_ArrayListLiveDBClients.clear();
                m_ArrayListLiveDBClients = null;
            }
        }
        LiveDBSocketChannelManagement.destruct();
        m_LiveDBClientKernel = null;
        m_LiveDBCloseSemaphore.leaveCloseSection();
        if (LiveDBSocketChannelManagement.getGarbageCollectionRatio() > 0.0) {
            System.gc();
        }
    }

    public static void setLogEventOutput(PrintStream p_PrintStream) {
        LogEvent.setPrintStream(p_PrintStream);
    }

    public static LiveDBConnectionDescription createConnectionDescription_ClientSide(String p_ServerURL, int p_ServerPort, String p_ClientIP, boolean p_ClientTryAllInterfaces, String p_ClientVersion, String p_ClientLicense, String p_CLientUserName, int p_ClientUserStatus) {
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        LiveDBConnectionDescription o_LiveDBConnectionDescription = LiveDBConnectionDescription.createConnectionDescription_ClientSide((String)p_ServerURL, (int)p_ServerPort, (String)p_ClientIP, (boolean)p_ClientTryAllInterfaces, (String)p_ClientVersion, (String)p_ClientLicense, (String)PropertiesSystem.getMacAddress(), (String)p_CLientUserName, (int)p_ClientUserStatus);
        m_LiveDBCloseSemaphore.leaveWorkerSection();
        return o_LiveDBConnectionDescription;
    }

    public static LiveDBConnectionDescription createConnectionDescription_ClientSide(String p_ServerURL, int p_ServerPort, String p_ClientIP, boolean p_ClientTryAllInterfaces, String p_ClientVersion, String p_ClientLicense) {
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        LiveDBConnectionDescription o_LiveDBConnectionDescription = LiveDBConnectionDescription.createConnectionDescription_ClientSide((String)p_ServerURL, (int)p_ServerPort, (String)p_ClientIP, (boolean)p_ClientTryAllInterfaces, (String)p_ClientVersion, (String)p_ClientLicense, (String)PropertiesSystem.getMacAddress(), (String)"", (int)0);
        m_LiveDBCloseSemaphore.leaveWorkerSection();
        return o_LiveDBConnectionDescription;
    }

    public static LiveDBClient createLiveDBClient(LiveDBConnectionDescription p_LiveDBConnectionDescription) {
        if (p_LiveDBConnectionDescription == null) {
            return null;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        LiveDBClient o_LiveDBClient = LiveDBClient.createLiveDBClient_ClientSide(p_LiveDBConnectionDescription);
        LiveDBClientKernel.addLiveDBClient(o_LiveDBClient);
        m_LiveDBCloseSemaphore.leaveWorkerSection();
        return o_LiveDBClient;
    }

    public static LiveDBClient createLiveDBClient(String p_ServerURL, int p_ServerPort, String p_ClientIP, boolean p_ClientTryAllInterfaces, String p_ClientVersion, String p_ClientLicense, String p_Username, int p_UserStatus) {
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        LiveDBClient o_LiveDBClient = null;
        LiveDBConnectionDescription o_LiveDBConnectionDescription = LiveDBClientKernel.createConnectionDescription_ClientSide(p_ServerURL, p_ServerPort, p_ClientIP, p_ClientTryAllInterfaces, p_ClientVersion, p_ClientLicense, p_Username, p_UserStatus);
        o_LiveDBClient = LiveDBClientKernel.createLiveDBClient(o_LiveDBConnectionDescription);
        m_LiveDBCloseSemaphore.leaveWorkerSection();
        return o_LiveDBClient;
    }

    public static void connectClient(LiveDBClient p_LiveDBClient) {
        if (p_LiveDBClient == null) {
            return;
        }
        if (p_LiveDBClient.getLiveDBSocket() == null && m_LiveDBClientKernel != null) {
            LiveDBClientKernel.notifyClientKernelListeners_eventClientError(p_LiveDBClient, new Exception("Connection exception: Client was closed prior"), ERROR_CLIENTCLOSED);
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            LiveDBClientKernel.notifyClientKernelListeners_eventClientError(p_LiveDBClient, new Exception("Exception connectClient: ClientKernel was destructed prior"), ERROR_CLIENTKERNELDESTRUCTED);
            return;
        }
        LiveDBSocketChannelManagement.actionConnectLiveDBSocket((LiveDBSocket)p_LiveDBClient.getLiveDBSocket());
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    public static void closeClient(LiveDBClient p_LiveDBClient) {
        if (p_LiveDBClient == null) {
            return;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        p_LiveDBClient.close();
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeClientsAll() {
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        ArrayList<LiveDBClient> o_ArrayListClients = new ArrayList<LiveDBClient>();
        Object object = m_SyncLiveDBClients;
        synchronized (object) {
            if (m_ArrayListLiveDBClients != null) {
                for (int intClient = 0; intClient < m_ArrayListLiveDBClients.size(); ++intClient) {
                    o_ArrayListClients.add(m_ArrayListLiveDBClients.get(intClient));
                }
            }
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
        for (int intClient = 0; intClient < o_ArrayListClients.size(); ++intClient) {
            ((LiveDBClient)o_ArrayListClients.get(intClient)).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addLiveDBClient(LiveDBClient p_LiveDBClient) {
        if (p_LiveDBClient == null) {
            return;
        }
        boolean boolAdded = false;
        Object object = m_SyncLiveDBClients;
        synchronized (object) {
            if (m_ArrayListLiveDBClients != null && !m_ArrayListLiveDBClients.contains(p_LiveDBClient) && m_ArrayListLiveDBClients.add(p_LiveDBClient)) {
                boolAdded = true;
                p_LiveDBClient.addLiveDBClientListener(m_LiveDBClientKernel);
            }
        }
        if (boolAdded) {
            LiveDBClientKernel.notifyClientKernelListeners_eventLiveDBClientAdded(p_LiveDBClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean removeLiveDBClient(LiveDBClient p_LiveDBClient) {
        if (p_LiveDBClient == null) {
            return false;
        }
        boolean boolRemoved = false;
        Object object = m_SyncLiveDBClients;
        synchronized (object) {
            if (m_ArrayListLiveDBClients != null && (boolRemoved = m_ArrayListLiveDBClients.remove(p_LiveDBClient))) {
                p_LiveDBClient.removeLiveDBClientListener(m_LiveDBClientKernel);
            }
        }
        if (boolRemoved) {
            LiveDBClientKernel.notifyClientKernelListeners_eventLiveDBClientRemoved(p_LiveDBClient);
        }
        boolean boolAllClosed = false;
        Object object2 = m_SyncLiveDBClients;
        synchronized (object2) {
            if (m_ArrayListLiveDBClients != null) {
                if (m_ArrayListLiveDBClients.size() <= 0) {
                    boolAllClosed = true;
                }
            } else {
                boolAllClosed = true;
            }
        }
        if (boolAllClosed) {
            object2 = m_SyncDestruct;
            synchronized (object2) {
                m_SyncDestruct.notifyAll();
            }
        }
        return boolRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LiveDBClient getLiveDBClient(String p_ClientID) {
        if (p_ClientID == null) {
            return null;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        LiveDBClient o_LiveDBClient = null;
        Object object = m_SyncLiveDBClients;
        synchronized (object) {
            if (m_ArrayListLiveDBClients != null) {
                int intClientSize = m_ArrayListLiveDBClients.size();
                for (int intClient = 0; intClient < intClientSize && !p_ClientID.equals((o_LiveDBClient = m_ArrayListLiveDBClients.get(intClient)).getID()); ++intClient) {
                    o_LiveDBClient = null;
                }
            }
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
        return o_LiveDBClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLiveDBClientsCount() {
        int intLiveDBClientsCount = 0;
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return 0;
        }
        Object object = m_SyncLiveDBClients;
        synchronized (object) {
            if (m_ArrayListLiveDBClients != null) {
                intLiveDBClientsCount = m_ArrayListLiveDBClients.size();
            }
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
        return intLiveDBClientsCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<LiveDBClient> getLiveDBClients() {
        ArrayList<LiveDBClient> o_ArrayListLiveDBClients = new ArrayList<LiveDBClient>();
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return o_ArrayListLiveDBClients;
        }
        Object object = m_SyncLiveDBClients;
        synchronized (object) {
            if (m_ArrayListLiveDBClients != null) {
                for (int intClient = 0; intClient < m_ArrayListLiveDBClients.size(); ++intClient) {
                    o_ArrayListLiveDBClients.add(m_ArrayListLiveDBClients.get(intClient));
                }
            }
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
        return o_ArrayListLiveDBClients;
    }

    public static void setWatchdogConnection_Time(long p_Milliseconds) {
        LiveDBSocketChannelManagement.setWatchdogConnection_Time((long)p_Milliseconds);
    }

    public static LiveDBStream createIncomingStream(LiveDBClient p_LiveDBClient, LiveDBMessageStreamInfo p_StreamInfo, OutputStream p_OutputStream) {
        if (p_LiveDBClient == null) {
            return null;
        }
        if (p_StreamInfo == null) {
            return null;
        }
        if (p_OutputStream == null) {
            return null;
        }
        if (p_StreamInfo.getInternalHandled()) {
            LiveDBClientKernel.notifyClientKernelListeners_eventClientError(p_LiveDBClient, new Exception("Stream is handled internal, thers is no need to create an incoming stream"), ERROR_STREAMHANDLEDINTERNAL);
            return null;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        LiveDBStream o_LiveDBStream = LiveDBStream.createIncomingStream((LiveDBSocket)p_LiveDBClient.getLiveDBSocket(), (LiveDBMessageStreamInfo)p_StreamInfo, (OutputStream)p_OutputStream);
        m_LiveDBCloseSemaphore.leaveWorkerSection();
        return o_LiveDBStream;
    }

    public static void setMessagePrecode(byte[] p_MessagePrecode) {
        LiveDBSocketChannelManagement.setMessagePrecode((byte[])p_MessagePrecode);
    }

    public static byte[] getMessagePrecode() {
        return LiveDBSocketChannelManagement.getMessagePrecode();
    }

    public static void setSocketReceiveBufferSize(int p_ReadBufferSize) {
        LiveDBSocketChannelManagement.setSocketReceiveBufferSize((int)p_ReadBufferSize);
    }

    public static int getSocketReceiveBufferSize() {
        return LiveDBSocketChannelManagement.getSocketReceiveBufferSize();
    }

    public static void setSocketSendBufferSize(int p_SendBufferSize) {
        if (p_SendBufferSize <= 1024) {
            return;
        }
        LiveDBSocketChannelManagement.setSocketSendBufferSize((int)p_SendBufferSize);
    }

    public static int getSocketSendBufferSize() {
        return LiveDBSocketChannelManagement.getSocketSendBufferSize();
    }

    public static void setTimeWaitForHandshake(int p_Milliseconds) {
        LiveDBSocket.TIME_WAITFORHANDSHAKE = p_Milliseconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLiveDBClientKernelListener(LiveDBClientKernelListener p_LiveDBClientKernelListener) {
        if (p_LiveDBClientKernelListener == null) {
            return;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        Object object = m_SyncClientKernelListeners;
        synchronized (object) {
            if (m_ClientKernelListeners != null && !m_ClientKernelListeners.contains(p_LiveDBClientKernelListener)) {
                m_ClientKernelListeners.add(p_LiveDBClientKernelListener);
            }
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeLiveDBClientKernelListener(LiveDBClientKernelListener p_LiveDBClientKernelListener) {
        if (p_LiveDBClientKernelListener == null) {
            return false;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        boolean boolRemoved = false;
        Object object = m_SyncClientKernelListeners;
        synchronized (object) {
            if (m_ClientKernelListeners != null) {
                boolRemoved = m_ClientKernelListeners.remove(p_LiveDBClientKernelListener);
            }
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
        return boolRemoved;
    }

    @Override
    public void eventClientConnectionStatus(LiveDBClient p_LiveDBClient, int p_ConnectionStatus) {
        if (p_LiveDBClient == null) {
            return;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        LiveDBClientKernel.notifyClientKernelListeners_eventClientConnectionStatus(p_LiveDBClient, p_ConnectionStatus);
        switch (p_ConnectionStatus) {
            case 0: {
                LiveDBClientKernel.removeLiveDBClient(p_LiveDBClient);
            }
        }
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    @Override
    public void eventClientMessageReadUnknown(LiveDBClient p_LiveDBClient) {
        if (p_LiveDBClient == null) {
            return;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        LiveDBClientKernel.notifyClientKernelListeners_eventMessageReadUnknown(p_LiveDBClient);
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    @Override
    public void eventClientMessageWritten(LiveDBClient p_LiveDBClient, Object p_MessageObject) {
        if (p_LiveDBClient == null) {
            return;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        LiveDBClientKernel.notifyClientKernelListeners_eventMessageWritten(p_LiveDBClient, p_MessageObject);
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    @Override
    public void eventClientError(LiveDBClient p_LiveDBClient, Exception p_Exception, String p_Remark) {
        if (p_LiveDBClient == null) {
            return;
        }
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        LiveDBClientKernel.notifyClientKernelListeners_eventClientError(p_LiveDBClient, p_Exception, p_Remark);
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyClientKernelListeners_eventClientConnectionStatus(LiveDBClient p_LiveDBClient, int p_ConnectionStatus) {
        Object[] o_Listeners = null;
        Object object = m_SyncClientKernelListeners;
        synchronized (object) {
            if (m_ClientKernelListeners == null) {
                return;
            }
            o_Listeners = m_ClientKernelListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBClientKernelListener o_LiveDBClientKernelListener = (LiveDBClientKernelListener)o_Listeners[intListener];
                if (o_LiveDBClientKernelListener == null) continue;
                o_LiveDBClientKernelListener.eventClientConnectionStatus(p_LiveDBClient, p_ConnectionStatus);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyClientKernelListeners_eventClientError(LiveDBClient p_LiveDBClient, Exception p_Exception, String p_Remark) {
        Object[] o_Listeners = null;
        Object object = m_SyncClientKernelListeners;
        synchronized (object) {
            if (m_ClientKernelListeners == null) {
                return;
            }
            o_Listeners = m_ClientKernelListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBClientKernelListener o_LiveDBClientKernelListener = (LiveDBClientKernelListener)o_Listeners[intListener];
                if (o_LiveDBClientKernelListener == null) continue;
                o_LiveDBClientKernelListener.eventClientError(p_LiveDBClient, p_Exception, p_Remark);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyClientKernelListeners_eventLiveDBClientAdded(LiveDBClient p_LiveDBClient) {
        Object[] o_Listeners = null;
        Object object = m_SyncClientKernelListeners;
        synchronized (object) {
            if (m_ClientKernelListeners == null) {
                return;
            }
            o_Listeners = m_ClientKernelListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBClientKernelListener o_LiveDBClientKernelListener = (LiveDBClientKernelListener)o_Listeners[intListener];
                if (o_LiveDBClientKernelListener == null) continue;
                o_LiveDBClientKernelListener.eventLiveDBClientAdded(p_LiveDBClient);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyClientKernelListeners_eventLiveDBClientRemoved(LiveDBClient p_LiveDBClient) {
        Object[] o_Listeners = null;
        Object object = m_SyncClientKernelListeners;
        synchronized (object) {
            if (m_ClientKernelListeners == null) {
                return;
            }
            o_Listeners = m_ClientKernelListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBClientKernelListener o_LiveDBClientKernelListener = (LiveDBClientKernelListener)o_Listeners[intListener];
                if (o_LiveDBClientKernelListener == null) continue;
                o_LiveDBClientKernelListener.eventLiveDBClientRemoved(p_LiveDBClient);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyClientKernelListeners_eventMessageReadUnknown(LiveDBClient p_LiveDBClient) {
        Object[] o_Listeners = null;
        Object object = m_SyncClientKernelListeners;
        synchronized (object) {
            if (m_ClientKernelListeners == null) {
                return;
            }
            o_Listeners = m_ClientKernelListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBClientKernelListener o_LiveDBClientKernelListener = (LiveDBClientKernelListener)o_Listeners[intListener];
                if (o_LiveDBClientKernelListener == null) continue;
                o_LiveDBClientKernelListener.eventClientMessageReadUnknown(p_LiveDBClient);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyClientKernelListeners_eventMessageWritten(LiveDBClient p_LiveDBClient, Object p_MessageObject) {
        Object[] o_Listeners = null;
        Object object = m_SyncClientKernelListeners;
        synchronized (object) {
            if (m_ClientKernelListeners == null) {
                return;
            }
            o_Listeners = m_ClientKernelListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBClientKernelListener o_LiveDBClientKernelListener = (LiveDBClientKernelListener)o_Listeners[intListener];
                if (o_LiveDBClientKernelListener == null) continue;
                o_LiveDBClientKernelListener.eventClientMessageWritten(p_LiveDBClient, p_MessageObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyClientKernelListeners_parseMessage(LiveDBClient p_LiveDBClient, Serializable p_Message) {
        Object[] o_Listeners = null;
        Object object = m_SyncClientKernelListeners;
        synchronized (object) {
            if (m_ClientKernelListeners == null) {
                return;
            }
            o_Listeners = m_ClientKernelListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBClientKernelListener o_LiveDBClientKernelListener = (LiveDBClientKernelListener)o_Listeners[intListener];
                if (o_LiveDBClientKernelListener == null) continue;
                o_LiveDBClientKernelListener.parseMessage(p_LiveDBClient, p_Message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyClientKernelListeners_parseMessageIncomingStreamStart(LiveDBClient p_Client, LiveDBStream p_IncomingStream, LiveDBMessageStreamInfo p_StreamInfo) {
        Object[] o_Listeners = null;
        Object object = m_SyncClientKernelListeners;
        synchronized (object) {
            if (m_ClientKernelListeners == null) {
                return;
            }
            o_Listeners = m_ClientKernelListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBClientKernelListener o_LiveDBClientKernelListener = (LiveDBClientKernelListener)o_Listeners[intListener];
                if (o_LiveDBClientKernelListener == null) continue;
                o_LiveDBClientKernelListener.parseMessageIncomingStreamStart(p_Client, p_IncomingStream, p_StreamInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyClientKernelListeners_parseMessageIncomingStreamEnd(LiveDBClient p_Client, LiveDBStream p_IncomingStream, boolean p_EndOfStream, boolean p_Canceled, boolean p_Error, String p_CancelRemark) {
        Object[] o_Listeners = null;
        Object object = m_SyncClientKernelListeners;
        synchronized (object) {
            if (m_ClientKernelListeners == null) {
                return;
            }
            o_Listeners = m_ClientKernelListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBClientKernelListener o_LiveDBClientKernelListener = (LiveDBClientKernelListener)o_Listeners[intListener];
                if (o_LiveDBClientKernelListener == null) continue;
                o_LiveDBClientKernelListener.parseMessageIncomingStreamEnd(p_Client, p_IncomingStream, p_EndOfStream, p_Canceled, p_Error, p_CancelRemark);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyClientKernelListeners_parseMessageIncomingStreamPackage(LiveDBClient p_Client, LiveDBStream p_IncomingStream, long p_ReceivedBytes) {
        Object[] o_Listeners = null;
        Object object = m_SyncClientKernelListeners;
        synchronized (object) {
            if (m_ClientKernelListeners == null) {
                return;
            }
            o_Listeners = m_ClientKernelListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBClientKernelListener o_LiveDBClientKernelListener = (LiveDBClientKernelListener)o_Listeners[intListener];
                if (o_LiveDBClientKernelListener == null) continue;
                o_LiveDBClientKernelListener.parseMessageIncomingStreamPackage(p_Client, p_IncomingStream, p_ReceivedBytes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyClientKernelListeners_parseMessageOutgoingStreamStart(LiveDBClient p_Client, LiveDBStream p_OutgoingStream, LiveDBMessageStreamInfo p_StreamInfo) {
        Object[] o_Listeners = null;
        Object object = m_SyncClientKernelListeners;
        synchronized (object) {
            if (m_ClientKernelListeners == null) {
                return;
            }
            o_Listeners = m_ClientKernelListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBClientKernelListener o_LiveDBClientKernelListener = (LiveDBClientKernelListener)o_Listeners[intListener];
                if (o_LiveDBClientKernelListener == null) continue;
                o_LiveDBClientKernelListener.parseMessageOutgoingStreamStart(p_Client, p_OutgoingStream, p_StreamInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyClientKernelListeners_parseMessageOutgoingStreamEnd(LiveDBClient p_Client, LiveDBStream p_OutgoingStream, boolean p_EndOfStream, boolean p_Canceled, boolean p_Error, String p_CancelRemark) {
        Object[] o_Listeners = null;
        Object object = m_SyncClientKernelListeners;
        synchronized (object) {
            if (m_ClientKernelListeners == null) {
                return;
            }
            o_Listeners = m_ClientKernelListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBClientKernelListener o_LiveDBClientKernelListener = (LiveDBClientKernelListener)o_Listeners[intListener];
                if (o_LiveDBClientKernelListener == null) continue;
                o_LiveDBClientKernelListener.parseMessageOutgoingStreamEnd(p_Client, p_OutgoingStream, p_EndOfStream, p_Canceled, p_Error, p_CancelRemark);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyClientKernelListeners_parseMessageOutgoingStreamConfirmed(LiveDBClient p_Client, LiveDBStream p_OutgoingStream, long p_ReceivedBytes) {
        Object[] o_Listeners = null;
        Object object = m_SyncClientKernelListeners;
        synchronized (object) {
            if (m_ClientKernelListeners == null) {
                return;
            }
            o_Listeners = m_ClientKernelListeners.toArray();
        }
        if (o_Listeners != null) {
            int intListenerSize = o_Listeners.length;
            for (int intListener = 0; intListener < intListenerSize; ++intListener) {
                LiveDBClientKernelListener o_LiveDBClientKernelListener = (LiveDBClientKernelListener)o_Listeners[intListener];
                if (o_LiveDBClientKernelListener == null) continue;
                o_LiveDBClientKernelListener.parseMessageOutgoingStreamConfirmed(p_Client, p_OutgoingStream, p_ReceivedBytes);
            }
        }
    }

    @Override
    public void parseMessage(LiveDBClient p_Client, Serializable p_Message) {
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        LiveDBClientKernel.notifyClientKernelListeners_parseMessage(p_Client, p_Message);
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    @Override
    public void parseMessageIncomingStreamStart(LiveDBClient p_LiveDBClient, LiveDBStream p_IncomingStream, LiveDBMessageStreamInfo p_StreamInfo) {
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        LiveDBClientKernel.notifyClientKernelListeners_parseMessageIncomingStreamStart(p_LiveDBClient, p_IncomingStream, p_StreamInfo);
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    @Override
    public void parseMessageIncomingStreamEnd(LiveDBClient p_LiveDBClient, LiveDBStream p_IncomingStream, boolean p_EndOfStream, boolean p_Canceled, boolean p_Error, String p_CancelRemark) {
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        LiveDBClientKernel.notifyClientKernelListeners_parseMessageIncomingStreamEnd(p_LiveDBClient, p_IncomingStream, p_EndOfStream, p_Canceled, p_Error, p_CancelRemark);
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    @Override
    public void parseMessageIncomingStreamPackage(LiveDBClient p_LiveDBClient, LiveDBStream p_IncomingStream, long p_ReceivedBytes) {
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        LiveDBClientKernel.notifyClientKernelListeners_parseMessageIncomingStreamPackage(p_LiveDBClient, p_IncomingStream, p_ReceivedBytes);
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    @Override
    public void parseMessageOutgoingStreamStart(LiveDBClient p_LiveDBClient, LiveDBStream p_OutgoingStream, LiveDBMessageStreamInfo p_StreamInfo) {
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        LiveDBClientKernel.notifyClientKernelListeners_parseMessageOutgoingStreamStart(p_LiveDBClient, p_OutgoingStream, p_StreamInfo);
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    @Override
    public void parseMessageOutgoingStreamEnd(LiveDBClient p_LiveDBClient, LiveDBStream p_OutgoingStream, boolean p_EndOfStream, boolean p_Canceled, boolean p_Error, String p_CancelRemark) {
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        LiveDBClientKernel.notifyClientKernelListeners_parseMessageOutgoingStreamEnd(p_LiveDBClient, p_OutgoingStream, p_EndOfStream, p_Canceled, p_Error, p_CancelRemark);
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    @Override
    public void parseMessageOutgoingStreamConfirmed(LiveDBClient p_LiveDBClient, LiveDBStream p_OutgoingStream, long p_ReceivedBytes) {
        if (!m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        LiveDBClientKernel.notifyClientKernelListeners_parseMessageOutgoingStreamConfirmed(p_LiveDBClient, p_OutgoingStream, p_ReceivedBytes);
        m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    public static long getFreeMemory() {
        return LiveDBSocketChannelManagement.getFreeMemory();
    }

    public static long getMaximalMemory() {
        return LiveDBSocketChannelManagement.getMaximalMemory();
    }

    public static long getTotalMemory() {
        return LiveDBSocketChannelManagement.getTotalMemory();
    }

    public static void setGarbageCollectionRatio(double p_Ratio) {
        LiveDBSocketChannelManagement.setGarbageCollectionRatio((double)p_Ratio);
    }

    public static boolean checkGarbageCollection() {
        return LiveDBSocketChannelManagement.checkGarbageCollection();
    }
}

