/*
 * Decompiled with CFR 0.152.
 */
package JarLoader;

import java.util.Hashtable;

public abstract class JarMultiClassLoader
extends ClassLoader {
    private Hashtable<String, Class> m_LoadedClasses;
    protected boolean m_DebugOn;
    private final Object m_SyncObject = new Object();

    public JarMultiClassLoader() {
        this.initMembers();
    }

    private void initMembers() {
        this.m_DebugOn = false;
        this.m_LoadedClasses = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.m_SyncObject;
        synchronized (object) {
            this.m_LoadedClasses.clear();
        }
    }

    protected void finalize() {
        this.m_LoadedClasses = null;
    }

    protected abstract byte[] loadClassBytes(String var1);

    public Class loadClass(String p_ClassName) throws ClassNotFoundException {
        return this.loadClass(p_ClassName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadClass(String p_ClassName, boolean p_ResolveIt) throws ClassNotFoundException {
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (p_ClassName == null) {
                throw new ClassNotFoundException("ClassName must not be null!");
            }
            if (p_ClassName.length() <= 0) {
                throw new ClassNotFoundException("ClassName.length must be greater than 0!");
            }
            this.setDebugOutput(">> MultiClassLoader.loadClass(" + p_ClassName + ", " + p_ResolveIt + ")");
            Class<?> o_Class = this.m_LoadedClasses.get(p_ClassName);
            if (o_Class != null) {
                this.setDebugOutput(">> returning cached result.");
                return o_Class;
            }
            try {
                o_Class = super.findSystemClass(p_ClassName);
                this.setDebugOutput(">> returning system class (in CLASSPATH).");
                return o_Class;
            }
            catch (ClassNotFoundException e) {
                this.setDebugOutput(">> Not a system class.");
                byte[] byteArrayClass = this.loadClassBytes(p_ClassName);
                if (byteArrayClass == null) {
                    throw new ClassNotFoundException();
                }
                try {
                    o_Class = this.defineClass(p_ClassName, byteArrayClass, 0, byteArrayClass.length);
                }
                catch (LinkageError e_Exception) {
                    throw new ClassNotFoundException();
                }
                if (o_Class == null) {
                    throw new ClassNotFoundException();
                }
                if (p_ResolveIt) {
                    this.resolveClass(o_Class);
                }
                this.m_LoadedClasses.put(p_ClassName, o_Class);
                this.setDebugOutput(">> Returning newly loaded class.");
                return o_Class;
            }
        }
    }

    protected void setDebugOutput(String text) {
        if (this.m_DebugOn) {
            System.out.println(text);
        }
    }
}

