/*
 * Decompiled with CFR 0.152.
 */
package JarLoader;

import JarLoader.JarMultiClassLoader;
import JarLoader.JarResources;
import java.net.URL;
import java.util.ArrayList;

public class JarClassLoader
extends JarMultiClassLoader {
    private JarResources m_JarResources;
    private String m_FileName;

    public JarClassLoader(String p_JarFileName) {
        this.m_FileName = p_JarFileName;
        this.m_JarResources = new JarResources(p_JarFileName);
    }

    public String getJarFileName() {
        return this.m_JarResources.getJarFileName();
    }

    public boolean isValid() {
        return this.m_JarResources.isValid();
    }

    @Override
    public byte[] loadClassBytes(String p_ClassName) {
        p_ClassName = this.m_JarResources.formatClassName(p_ClassName);
        return this.m_JarResources.getResource(p_ClassName);
    }

    public ArrayList<String> getClassNames() {
        if (this.m_JarResources == null) {
            return null;
        }
        return this.m_JarResources.getClassNames();
    }

    public JarResources getJarResources() {
        return this.m_JarResources;
    }

    @Override
    public URL getResource(String name) {
        URL url = super.getResource(name);
        if (url == null) {
            try {
                url = new URL("jar:file:" + this.m_FileName + "!/" + name);
            }
            catch (Exception e) {
                String string = e.toString();
            }
        }
        return url;
    }
}

